/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import jet.datastream.render.barcode.linearBarcode.Barcode128;
import jet.datastream.render.barcode.linearBarcode.Barcode39;
import jet.datastream.render.barcode.linearBarcode.BarcodeCodabar;
import jet.datastream.render.barcode.linearBarcode.BarcodeEAN13;
import jet.datastream.render.barcode.linearBarcode.BarcodeEAN8;
import jet.datastream.render.barcode.linearBarcode.BarcodeObject;
import jet.datastream.render.barcode.linearBarcode.BarcodeUPCA;
import jet.datastream.render.barcode.linearBarcode.BarcodeUPCE;

public class BarcodeConstraints
extends JComponent {
    private int SEDU;
    private String calculateWidth = "";
    private String init = "";
    protected BarcodeObject[] barcodes;
    public boolean runtime = true;
    public short barHeight = (short)72;
    private int locate = 1;
    private String paint;
    private Color rotate;
    private Color I;
    private boolean Z = true;
    private Font C;
    private short B;
    private short D;
    private int F = 2;
    private boolean J = true;
    private int S;
    private int A;
    private int E = 3;
    private int G = 2;
    private boolean H;
    private int K;
    private double L;
    private Dimension M = new Dimension();
    private float N = 1.0f;
    private boolean O;

    public BarcodeConstraints() {
    }

    public BarcodeConstraints(int n, String string) {
        this.SEDU = n;
        this.init = string;
        this.init();
    }

    public void locate() {
        this.S = this.getBounds().width / 2;
        this.A = this.getBounds().height / 2;
    }

    public void init() {
        this.L = (double)this.K * Math.PI / 180.0;
        this.barcodes = new BarcodeObject[1];
        this.SEDU(this.SEDU, this.init);
        this.locate();
    }

    private void SEDU(int n, String string) {
        switch (n) {
            case 6: {
                this.barcodes[0] = new BarcodeCodabar(this);
                break;
            }
            case 5: {
                this.barcodes[0] = new Barcode128(this);
                break;
            }
            case 4: {
                this.barcodes[0] = new Barcode39(this);
                break;
            }
            case 2: {
                this.barcodes[0] = new BarcodeEAN13(this);
                break;
            }
            case 3: {
                this.barcodes[0] = new BarcodeEAN8(this);
                break;
            }
            case 1: {
                this.barcodes[0] = new BarcodeUPCE(this);
                break;
            }
            case 0: {
                this.barcodes[0] = new BarcodeUPCA(this);
            }
        }
        this.barcodes[0].init();
    }

    public void paint(Graphics2D graphics2D) {
        this.init();
        graphics2D.rotate(this.L);
        this.barcodes[0].paint(graphics2D);
        graphics2D.rotate(-this.L);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paint(graphics2D);
    }

    public void calculateWidth() {
        this.init();
        this.barcodes[0].calculateWidth();
    }

    public void setType(int n) {
        this.SEDU = n;
    }

    public int getType() {
        return this.SEDU;
    }

    public void setBodeCodeData(String string) {
        this.init = string;
    }

    public String getBodeCodeData() {
        return this.init;
    }

    public Object clone() {
        return null;
    }

    public void updateProperties() {
    }

    public void updateBounds() {
    }

    public void setBarOrientation(int n) {
        this.K = n;
    }

    public int getBarOrientation() {
        return this.K;
    }

    public void setBarHRFont(Font font) {
        this.C = font;
    }

    public Font getBarHRFont() {
        return this.C;
    }

    public void setBar128Type(int n) {
        this.E = n;
    }

    public int getBar128Type() {
        return this.E;
    }

    public void setBarCheckEnable(boolean bl) {
        this.Z = bl;
    }

    public boolean getBarCheckEnable() {
        return this.Z;
    }

    public void setBarNarrowWidth(short s) {
        this.locate = s;
    }

    public short getBarNarrowWidth() {
        return (short)this.locate;
    }

    public void setBarMessage(String string) {
        this.init = string;
    }

    public String getBarMessage() {
        return this.init;
    }

    public void setBarQuietZone(short s) {
        this.B = s;
        this.D = s;
    }

    public short getBarQuietZone() {
        return this.B;
    }

    public void setBarRatio(float f) {
        this.F = (int)f;
    }

    public float getBarRatio() {
        return this.F;
    }

    public void setBarScaleMode(int n) {
        this.G = n;
    }

    public int getBarScaleMode() {
        return this.G;
    }

    public void setBarSupplement(String string) {
        this.paint = string;
    }

    public String getBarSupplement() {
        return this.paint;
    }

    public void setBarSymbology(int n) {
        this.SEDU = n;
    }

    public int getBarSymbology() {
        return this.SEDU;
    }

    public void setBarHeight(short s) {
        this.barHeight = s;
    }

    public short getBarHeight() {
        return this.barHeight;
    }

    public void setBarHRDisplay(boolean bl) {
        this.J = bl;
    }

    public boolean getBarHRDisplay() {
        return this.J;
    }

    public void setBarTransparent(boolean bl) {
        this.H = bl;
    }

    public boolean getBarTransparent() {
        return this.H;
    }

    @Override
    public void setBackground(Color color) {
        this.rotate = color;
    }

    @Override
    public Color getBackground() {
        return this.rotate;
    }

    @Override
    public void setForeground(Color color) {
        this.I = color;
    }

    @Override
    public Color getForeground() {
        return this.I;
    }

    public void setCenterXY(int n, int n2) {
        this.S = n;
        this.A = n2;
    }

    public int getCenterX() {
        return this.S;
    }

    public int getCenterY() {
        return this.A;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.M;
    }

    public void setBarDimension(Dimension dimension) {
        this.M = dimension;
    }

    public void setUnit(float f) {
        this.N = f / 100.0f;
    }

    public float getUnit() {
        return this.N;
    }

    public void setIsExportToPDF(boolean bl) {
        this.O = bl;
    }

    public boolean getIsExportToPDF() {
        return this.O;
    }
}

