/*
 * Decompiled with CFR 0.152.
 */
package jet.export;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.FileLockInterruptionException;
import java.util.List;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.export.ExpException;
import jet.export.Exporter;
import jet.util.EngineErrorListener;

public abstract class AbstractExporter
implements Exporter {
    protected Communicator _commu;
    protected Communicator[] _commuList;
    protected EngineErrorListener[] listeners;
    protected EngineErrorListener[][] listenerList;
    private boolean SEDU = false;

    protected void waitCommunicator() throws ExpException {
        this.SEDU();
        long l = System.currentTimeMillis();
        this._commu.waitFinished();
        long l2 = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4406005, l2 - l);
        }
    }

    protected void checkFilePathExist(String string) throws ExpException {
        File file = new File(string);
        File file2 = file.getAbsoluteFile().getParentFile();
        if (!file2.exists() || !file2.isDirectory()) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 4406004, file2.getPath());
            }
            throw new ExpException(406003);
        }
    }

    protected void checkOutputStream(OutputStream outputStream) throws ExpException {
        if (outputStream == null) {
            throw new ExpException(406004);
        }
    }

    private void SEDU() throws ExpException {
        if (this._commu == null) {
            throw new ExpException(406010);
        }
    }

    protected void treatIOException(IOException iOException, String string, boolean bl) throws ExpException {
        if (!bl) {
            throw new ExpException(406009, (Throwable)iOException);
        }
        if (iOException instanceof FileNotFoundException) {
            throw new ExpException(406005, new Object[]{string}, (Throwable)iOException);
        }
        if (iOException instanceof FileLockInterruptionException) {
            throw new ExpException(406006, new Object[]{string}, (Throwable)iOException);
        }
        if (iOException instanceof InterruptedIOException) {
            throw new ExpException(406007, (Throwable)iOException);
        }
        throw new ExpException(406008, (Throwable)iOException);
    }

    @Override
    public abstract List exportToFile(String var1) throws ExpException, JRStopEngineException;

    @Override
    public abstract void exportToStream(OutputStream var1) throws ExpException, JRStopEngineException;

    @Override
    public void setListeners(EngineErrorListener[][] engineErrorListenerArray) {
        this.listenerList = engineErrorListenerArray;
    }

    protected void showingWaitMessage(boolean bl, String string) {
        if (this.SEDU) {
            try {
                if (bl) {
                    this.waitCommunicator();
                }
                System.out.println(string + ", please press OK to continue.....");
                int n = System.in.read();
                while (n != 79) {
                    n = System.in.read();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void logCommunicatorNullInfo(int n) {
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "The Communicator object is null, its index is (" + n + ") ");
        }
    }
}

