/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class Tick
extends Biff {
    public static final byte NONE = 0;
    public static final byte INSIDE = 1;
    public static final byte OUTSIDE = 2;
    public static final byte CROSS = 3;
    public static final byte SHOWNONE = 0;
    public static final byte LOWAREA = 1;
    public static final byte HIGHAREA = 2;
    public static final byte NEXTAXIS = 3;
    public static final byte TRANSPARENT = 1;
    public static final byte OPAQUE = 2;
    public static final short AUTOCOLOR = 1;
    public static final short AUTOBG = 2;
    public static final short DEFAULT = -29;
    public static final short NOROTATION = 0;
    public static final short UPRIGHT = 4;
    public static final short ROT90COUNTERCLOCK = 8;
    public static final short ROT90CLOCK = 12;
    public static final short AUTOROT = 32;
    public static final int TEX_ORDER_DEFAULT = 63;
    public static final int TEX_ORDER_LEFT_RIGHT = 16447;
    public static final int TEX_ORDER_RIGHT_LEFT = 32831;
    byte SEDU = (byte)2;
    byte addColor = 0;
    byte black = (byte)3;
    byte getColorRGB = 1;
    int needUpdateIndex;
    int output;
    short readByte;
    short readInt;
    private ColorTable readIntWithShortFormat;

    public Tick(ColorTable colorTable) {
        this.readIntWithShortFormat = colorTable;
        this.length = 30;
        this.SEDU(true);
        this.addColor(true);
        this.needUpdateIndex = 0;
        this.readByte = colorTable.addColor(Color.black);
    }

    @Override
    public final int opcode() {
        return 4126;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.readIntWithShortFormat.needUpdateIndex()) {
            this.readByte = this.readIntWithShortFormat.updateColorIndex(this.readByte);
        }
        randomAccessStream.writeByte(this.SEDU);
        randomAccessStream.writeByte(this.addColor);
        randomAccessStream.writeByte(this.black);
        randomAccessStream.writeByte(this.getColorRGB);
        this.writeInt(randomAccessStream, this.needUpdateIndex);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeInt(randomAccessStream, 0);
        this.writeShort(randomAccessStream, this.output);
        this.writeShort(randomAccessStream, this.readByte);
        this.writeShort(randomAccessStream, this.readInt);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.SEDU = randomAccessStream.readByte();
        this.addColor = randomAccessStream.readByte();
        this.black = randomAccessStream.readByte();
        this.getColorRGB = randomAccessStream.readByte();
        this.needUpdateIndex = this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.readInt(randomAccessStream);
        this.output = this.readIntWithShortFormat(randomAccessStream);
        this.readByte = this.readShort(randomAccessStream);
        this.readInt = this.readShort(randomAccessStream);
    }

    public void setTickMajor(byte by) {
        this.SEDU = by;
    }

    public byte getTickMajor() {
        return this.SEDU;
    }

    public void setTickMinor(byte by) {
        this.addColor = by;
    }

    public byte getTickMinor() {
        return this.addColor;
    }

    public void setTlt(byte by) {
        this.black = by;
    }

    public byte getTlt() {
        return this.black;
    }

    public void setBgMode(byte by) {
        this.getColorRGB = by;
    }

    public byte getBgMode() {
        return this.getColorRGB;
    }

    public void setRotation(short s) {
        this.readInt = s;
        this.addColor(false);
    }

    public short getRotation() {
        return this.readInt;
    }

    public boolean isAutoColor() {
        return (this.output & 1) == 1;
    }

    private void SEDU(boolean bl) {
        this.output = bl ? this.output | 1 : this.output & 0xFFFFFFFE;
    }

    public boolean isAutoBg() {
        return (this.output & 2) == 2;
    }

    public void setAutoBg(boolean bl) {
        this.output = bl ? this.output | 2 : this.output & 0xFFFFFFFD;
    }

    public void setRot(short s) {
        this.output = (short)(this.output & 0xFFFFFFE3);
        this.output = (short)(this.output | s);
    }

    public short getRot() {
        return (short)(this.output | 0x1C);
    }

    public boolean isAutoRot() {
        return (this.output & 0x20) == 32;
    }

    private void addColor(boolean bl) {
        this.output = bl ? this.output | 0x20 : this.output & 0xFFFFFFDF;
    }

    public void setTextOrder(int n) {
        this.output |= n;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.needUpdateIndex = this.readIntWithShortFormat.getColorRGB(color);
            this.readByte = this.readIntWithShortFormat.addColor(color);
            this.SEDU(false);
        } else {
            this.SEDU(true);
        }
    }

    public boolean isShow() {
        return this.SEDU != 0 ? true : (this.addColor != 0 ? true : this.black != 0);
    }
}

