/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.shapeprops;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;
import jet.export.excel.imp.xlsx.shapeprops.NoFill;
import jet.export.excel.imp.xlsx.shapeprops.SolidFill;

public class LineStyle
implements jet.export.excel.api.LineStyle {
    public static final byte CAP_FLAT = 1;
    public static final byte CAP_ROUND = 2;
    public static final byte CAP_SQUARE = 3;
    public static final byte JOIN_ROUND = 1;
    public static final byte JOIN_BEVEL = 2;
    public static final byte JOIN_MITER = 3;
    private double SEDU = -1.0;
    private FillStyle append = new SolidFill(-16777216);
    private byte getRGB = (byte)-1;
    private byte isTrace = (byte)-1;
    private byte setFill = (byte)-1;
    private byte setTransparency = (byte)-1;
    private double toString = -1.0;

    @Override
    public void setWidth(double d) {
        if (d < 0.0 || d > 1584.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (LineStyle.setWidth(double))");
            }
            return;
        }
        this.SEDU = d;
    }

    public void setFill(FillStyle fillStyle) {
        this.append = fillStyle;
    }

    public void setCompoundType(byte by) {
        this.getRGB = by;
    }

    public void setDashType(byte by) {
        this.isTrace = by;
    }

    public void setCapType(byte by) {
        this.setFill = by;
    }

    public void setJoinType(byte by) {
        this.setTransparency = by;
    }

    public void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("a", "ln", "http://schemas.openxmlformats.org/drawingml/2006/main");
            if (this.SEDU != -1.0) {
                xMLStreamWriter.writeAttribute("w", String.valueOf((int)(this.SEDU * 12700.0)));
            }
            if (this.getRGB != -1) {
                switch (this.getRGB) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("cmpd", "dbl");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("cmpd", "sng");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("cmpd", "thickThin");
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeAttribute("cmpd", "thinThick");
                        break;
                    }
                    case 5: {
                        xMLStreamWriter.writeAttribute("cmpd", "tri");
                        break;
                    }
                    default: {
                        xMLStreamWriter.writeAttribute("cmpd", "sng");
                    }
                }
            }
            if (this.setFill != -1) {
                switch (this.setFill) {
                    case 1: {
                        xMLStreamWriter.writeAttribute("cap", "flat");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("cap", "rnd");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("cap", "sq");
                        break;
                    }
                    default: {
                        xMLStreamWriter.writeAttribute("cap", "flat");
                    }
                }
            }
            if (this.append != null) {
                if (this.toString != -1.0 && this.append instanceof SolidFill) {
                    ((SolidFill)this.append).setTransparency(this.toString);
                }
                this.append.write(xMLStreamWriter, noneRelsPart);
            }
            if (this.isTrace != -1) {
                xMLStreamWriter.writeEmptyElement("a", "prstDash", "http://schemas.openxmlformats.org/drawingml/2006/main");
                switch (this.isTrace) {
                    case 6: {
                        xMLStreamWriter.writeAttribute("val", "dash");
                        break;
                    }
                    case 8: {
                        xMLStreamWriter.writeAttribute("val", "dashDot");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("val", "dot");
                        break;
                    }
                    case 7: {
                        xMLStreamWriter.writeAttribute("val", "lgDash");
                        break;
                    }
                    case 9: {
                        xMLStreamWriter.writeAttribute("val", "lgDashDot");
                        break;
                    }
                    case 10: {
                        xMLStreamWriter.writeAttribute("val", "lgDashDotDot");
                        break;
                    }
                    case 0: {
                        xMLStreamWriter.writeAttribute("val", "solid");
                        break;
                    }
                    default: {
                        xMLStreamWriter.writeAttribute("val", "dash");
                    }
                }
            }
            if (this.setTransparency != -1) {
                switch (this.setTransparency) {
                    case 1: {
                        xMLStreamWriter.writeEmptyElement("a", "round", "http://schemas.openxmlformats.org/drawingml/2006/main");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeEmptyElement("a", "bevel", "http://schemas.openxmlformats.org/drawingml/2006/main");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeEmptyElement("a", "miter", "http://schemas.openxmlformats.org/drawingml/2006/main");
                        break;
                    }
                    default: {
                        xMLStreamWriter.writeEmptyElement("a", "miter", "http://schemas.openxmlformats.org/drawingml/2006/main");
                    }
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            this.setFill(new SolidFill(color.getRGB()));
        } else {
            this.setFill(new NoFill());
        }
    }

    @Override
    public void setStyle(int n) {
        this.getRGB = (byte)n;
    }

    public FillStyle getFill() {
        return this.append;
    }

    @Override
    public void setTransparency(double d) {
        if (d < 0.0 || d > 100.0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Xlsx API: Invalid parameter " + d + " (LineStyle.setTransparency(double))");
            }
            return;
        }
        this.toString = d;
    }
}

