/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.PDFParameter;
import jet.connect.DbBinary;
import jet.connect.DbValue;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.CommNode;
import jet.datastream.Communicator;
import jet.datastream.DSArea;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSGMap;
import jet.datastream.DSGeoMap;
import jet.datastream.DSGroup;
import jet.datastream.DSMap;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSNavigateControl;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSPicture;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSSlider;
import jet.datastream.DSSubReport;
import jet.datastream.DSTOC;
import jet.datastream.DSTable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextBox;
import jet.datastream.DSTextObj;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderHidden;
import jet.datastream.render.RenderImage;
import jet.datastream.render.RenderImageButton;
import jet.datastream.render.RenderRank;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.pdf.ArabicShaping;
import jet.export.pdf.Box;
import jet.export.pdf.ExportLine;
import jet.export.pdf.ExportLineStyle;
import jet.export.pdf.ExportRectFromV7;
import jet.export.pdf.ExportRectangle;
import jet.export.pdf.ExportText;
import jet.export.pdf.ExportTextStyle;
import jet.export.pdf.GeoBdrInfo;
import jet.export.pdf.GridBox;
import jet.export.pdf.GridBoxes;
import jet.export.pdf.PDFCache;
import jet.export.pdf.PDFConstants;
import jet.export.pdf.PDFFont;
import jet.export.pdf.PDFSpliter;
import jet.export.pdf.PDFWriter;
import jet.export.pdf.PdfExt;
import jet.export.relayout.table.ContainerInfo;
import jet.export.relayout.table.ContentCell;
import jet.export.relayout.table.DrawingTable;
import jet.export.relayout.table.RectCell;
import jet.export.relayout.table.Row;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;
import jet.export.util.DSShapeRegion;
import jet.export.util.ExportUtil;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.FontInfo;
import jet.export.util.ImageEngine;
import jet.export.util.ImageInfo;
import jet.export.util.ImageTool;
import jet.naming.PropertyNames;
import jet.thinviewer.JReportGoMap;
import jet.thinviewer.JReportGoogleMap;
import jet.thinviewer.JReportMap;
import jet.udo.HtmlGeneratable;
import jet.udo.JRObjectRender;
import jet.udos.JHyperLinkRslt;
import jet.udos.JHyperlinkLineInfo;
import jet.util.BitmapReader;
import jet.util.JRInterruptedException;
import jet.util.TreeIterater;
import jet.util.image.ImageResource;

public class ExportToPDF
extends AbstractExporter
implements PDFConstants {
    private String BLACK = null;
    private OutputStream BORDERJOINT_ROUND = null;
    public static final String FILENAME_SEPARATE = "_";
    public static final String FILENAME_OF = "of";
    public final int maxSizeofPDF;
    public final int maxPageofPDF;
    private String ConvertProperties;
    private CommEnumeration F;
    private Vector FILL_COLOR;
    private Hashtable HorizontalAlignment;
    private Vector SEDU;
    private boolean WHITE;
    private Stack add;
    private Vector addElement;
    private Vector addPropsChangedBy;
    private Rectangle append;
    private int background;
    private int bgRect;
    private int black;
    private int booleanValue;
    private boolean charAt;
    private int checkFilePathExist;
    private int checkOutputStream = -1;
    private float checkStop = -1.0f;
    private boolean clear;
    private boolean clearCacheRender;
    private IntHashtable close;
    private ArabicShaping convertInchToPixel;
    private PDFWriter convertPixelToUnit;
    private PdfExt convertTwoRes;
    private int convertUnitToPixel;
    private String convertUnitToPoint;
    private int createChildren;
    private final boolean createFile;
    private int createImage = 1;
    private final PDFParameter createSignature;
    private ImageEngine deIndent;
    private boolean delete = false;
    private HashMap dispose = new HashMap();
    private HashMap drawArc = new HashMap();
    private HashMap drawFileLink = new HashMap();
    private PDFCache drawImage;
    private ImageTool drawLine;
    private Hashtable drawLocalLink;
    private Hashtable drawOval;
    private int drawRect = 0;
    private ExportAuxInfo drawRoundRect;

    public ExportToPDF(Communicator[] communicatorArray, PDFParameter pDFParameter) {
        this._commuList = communicatorArray;
        this.createSignature = pDFParameter;
        this.createFile = pDFParameter.isSimPrintMode();
        this.maxSizeofPDF = pDFParameter.getMaxSizeOfOneFile();
        this.maxPageofPDF = pDFParameter.getMaxPageOfOneFile();
        this.drawLine = new ImageTool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        JRLog.indent("PDF Exporter");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401001);
        }
        this.drawImage = new PDFCache(this.drawRoundRect, "pdf");
        this.checkFilePathExist(string);
        this.BLACK = this.fillOval(string);
        this.BW2();
        Stack<String> stack = new Stack<String>();
        try {
            JRLog.indent("build PDF file.");
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401011);
            }
            int n = 1;
            int[] nArray = this.createSignature.getExportPages();
            int[][] nArray2 = this.createSignature.getExportPageRange();
            Color color = null;
            int n2 = 0;
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                if (this._commu == null) continue;
                this.drawRect += n2;
                n2 = 0;
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "Start export communicator: " + this._commu);
                }
                this.CONTACT();
                try {
                    color = this._commu.getHeaderInfo((int)0).background;
                    while (this.F.hasMoreElements()) {
                        ExportUtil.checkStop(this._commu);
                        if ((nArray != null || nArray2 != null) && this.BORDERLINENAME(nArray, nArray2, ++n2)) {
                            this.F.nextElement();
                            continue;
                        }
                        DSPage dSPage = (DSPage)this.F.nextElement();
                        this.BORDERJOINT_ROUND(dSPage, n, stack, color);
                        if (color != null) {
                            this.convertPixelToUnit.fillRect(0.0f, 0.0f, this.black, this.booleanValue, color);
                        }
                        this.DEF_COLOR(dSPage);
                        ++n;
                    }
                    continue;
                }
                finally {
                    this._commu.setResolution(this.createChildren);
                    this.BH();
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, "Finished export communicator: " + this._commu);
                    }
                }
            }
            this.fillColor();
            File file = new File(this.BLACK);
            if (file.exists() && file.isFile()) {
                stack.push(this.BLACK);
            }
            this.fillArc(stack, color);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, this.BLACK, true);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)exception);
            }
            ExportUtil.checkStop(this._commu);
            throw new ExpException(401001, (Throwable)exception);
        }
        finally {
            if (this.convertPixelToUnit != null && this.convertPixelToUnit.Z != null) {
                try {
                    this.convertPixelToUnit.dispose();
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, outOfSpaceException);
                    }
                    throw new ExpException(outOfSpaceException);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, iOException);
                    }
                    throw new ExpException(iOException);
                }
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401012);
            }
            JRLog.deIndent("build PDF file.");
        }
        ExportUtil.checkStop(this._commu);
        if (this.maxSizeofPDF == -1) {
            this.BLACK(stack);
        }
        ExportUtil.checkStop(this._commu);
        JRLog.deIndent("PDF Exporter");
        PDFSpliter pDFSpliter = new PDFSpliter(stack, this.createSignature, this.drawRoundRect);
        if (this.maxSizeofPDF != -1 && stack.size() > 0) {
            pDFSpliter.splitBySize();
        } else if (this.maxPageofPDF != -1 && stack.size() > 0) {
            pDFSpliter.splitByPage();
        }
        return stack;
    }

    private void BH() {
        this.drawArc.clear();
        this.dispose.clear();
        this.drawImage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BLACK(Stack stack) throws ExpException {
        if (this.createSignature != null && this.createSignature.hasSignature()) {
            try {
                KeyStore keyStore = this.getKeyStore(this.createSignature.getDigitalIDFileStream(), this.createSignature.getDigitalIDFilePassword());
                Enumeration enumeration = stack.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = ExportToPDF.I("encrypt.pdf", String.valueOf(new SecureRandom().nextDouble()));
                    File file = new File(string);
                    File file2 = new File(this.drawImage.getTemporaryPath(), string2);
                    file.renameTo(file2);
                    this.drawImage.fileUpdated(new File(string));
                    this.drawImage.fileUpdated(file2);
                    try {
                        PdfReader pdfReader = new PdfReader(file2.getPath());
                        File file3 = this.drawRoundRect.getDiskStore().createFile(string);
                        FileOutputStream fileOutputStream = new FileOutputStream(file3);
                        PdfStamper pdfStamper = PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)fileOutputStream, (char)'\u0000');
                        PDFWriter.signAndEncrypt(keyStore, pdfStamper, this.createSignature);
                        pdfStamper.close();
                        this.drawRoundRect.getDiskStore().fileUpdated(file3);
                    }
                    finally {
                        if (file2 == null || !file2.exists()) continue;
                        this.drawImage.delete(file2);
                    }
                }
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401002, (Throwable)exception);
                }
                throw new ExpException(401002, (Throwable)exception);
            }
        }
    }

    protected KeyStore getKeyStore(InputStream inputStream, String string) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        if (string != null) {
            keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, string.toCharArray());
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 131590);
        }
        return keyStore;
    }

    private void BORDERJOINT_ROUND(DSPage dSPage, int n, Stack stack, Color color) throws IOException, DocumentException, OutOfSpaceException {
        this.fillRoundRect(dSPage);
        boolean bl = false;
        if (n == 1) {
            this.fillRect(this.BLACK);
        }
        if (n == 1 || bl) {
            this.convertPixelToUnit.open(new Dimension(this.black, this.booleanValue), color);
        } else {
            this.convertPixelToUnit.I(new Dimension(this.black, this.booleanValue), color);
        }
    }

    private boolean BORDERLINENAME(int[] nArray, int[][] nArray2, int n) {
        int n2;
        int n3 = 0;
        if (nArray != null) {
            n3 = nArray.length;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            return false;
        }
        n2 = 0;
        if (nArray2 != null) {
            n2 = nArray2.length;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray2[i];
            n4 = nArray3[0];
            n5 = nArray3[1];
            if (n < n4 || n > n5) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        JRLog.indent("PDF Exporter");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401001);
        }
        this.drawImage = new PDFCache(this.drawRoundRect, "pdf");
        this.checkOutputStream(outputStream);
        OutputStream outputStream2 = this.BORDERJOINT_ROUND = new BufferedOutputStream(outputStream);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.createSignature.hasSignature()) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream2 = byteArrayOutputStream;
        }
        this.BW2();
        try {
            JRLog.indent("build PDF file.");
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401011);
            }
            int n = 1;
            int[] nArray = this.createSignature.getExportPages();
            int[][] nArray2 = this.createSignature.getExportPageRange();
            this.convertTwoRes = new PdfExt();
            this.convertPixelToUnit = new PDFWriter(this.convertTwoRes, outputStream2, this.createSignature, this.drawRoundRect);
            this.convertPixelToUnit.setEncoding(this._commuList[0].getEncoding());
            int n2 = 0;
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                this.drawRect += n2;
                n2 = 0;
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "Start export communicator: " + this._commu);
                }
                this.CONTACT();
                try {
                    Color color = this._commu.getHeaderInfo((int)0).background;
                    while (this.F.hasMoreElements()) {
                        ExportUtil.checkStop(this._commu);
                        if ((nArray != null || nArray2 != null) && this.BORDERLINENAME(nArray, nArray2, ++n2)) {
                            this.F.nextElement();
                            continue;
                        }
                        DSPage dSPage = (DSPage)this.F.nextElement();
                        this.fillRoundRect(dSPage);
                        if (n == 1) {
                            this.convertPixelToUnit.open(new Dimension(this.black, this.booleanValue), color);
                        } else {
                            this.convertPixelToUnit.I(new Dimension(this.black, this.booleanValue), color);
                        }
                        if (color != null) {
                            this.convertPixelToUnit.fillRect(0.0f, 0.0f, this.black, this.booleanValue, color);
                        }
                        this.DEF_COLOR(dSPage);
                        ++n;
                    }
                    continue;
                }
                finally {
                    this._commu.setResolution(this.createChildren);
                    this.BH();
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, "Finished export communicator: " + this._commu);
                    }
                }
            }
            this.fillColor();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, "", false);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)exception);
            }
            throw new ExpException(401001, (Throwable)exception);
        }
        finally {
            if (this.convertPixelToUnit != null && this.convertPixelToUnit.Z != null) {
                try {
                    this.convertPixelToUnit.dispose();
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, outOfSpaceException);
                    }
                    throw new ExpException(outOfSpaceException);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, iOException);
                    }
                    throw new ExpException(iOException);
                }
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401012);
            }
            JRLog.deIndent("build PDF file.");
        }
        ExportUtil.checkStop(this._commu);
        this.BW1(byteArrayOutputStream);
        ExportUtil.checkStop(this._commu);
        JRLog.deIndent("PDF Exporter");
    }

    private void BW1(ByteArrayOutputStream byteArrayOutputStream) throws ExpException {
        if (this.createSignature != null && this.createSignature.hasSignature()) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            try {
                PdfReader pdfReader = new PdfReader((InputStream)byteArrayInputStream);
                PdfStamper pdfStamper = PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)this.BORDERJOINT_ROUND, (char)'\u0000');
                KeyStore keyStore = this.getKeyStore(this.createSignature.getDigitalIDFileStream(), this.createSignature.getDigitalIDFilePassword());
                PDFWriter.signAndEncrypt(keyStore, pdfStamper, this.createSignature);
                pdfStamper.close();
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401003, (Throwable)exception);
                }
                throw new ExpException(401003, (Throwable)exception);
            }
            finally {
                try {
                    byteArrayInputStream.close();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2401004, (Throwable)iOException);
                    }
                    throw new ExpException(401004, (Throwable)iOException);
                }
            }
        }
    }

    private void BW2() {
        JRLog.indent("Init parameters");
        JRLog.indent("Parameters list");
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Communicator count: " + this._commuList.length);
            JRLog.trace(5, 5401002, new Integer(this.createSignature.getImageCompressRatio()));
            JRLog.trace(5, 5401003, new Integer(this.createSignature.getMaxSizeOfOneFile()));
            JRLog.trace(5, 5401004, new Boolean(this.createSignature.hasDrill()));
            JRLog.trace(5, 5401005, new Boolean(this.createSignature.hasToc()));
            JRLog.trace(5, 5401006, new Boolean(this.createSignature.isSimPrintMode()));
            JRLog.trace(5, 5401007, new Boolean(this.createSignature.noMargin()));
            JRLog.trace(5, 5401008, (Object[])this.createSignature.getExportPageRange());
            JRLog.trace(5, 5401009, (Object)this.createSignature.getExportPages());
            JRLog.trace(5, 5401010, new Boolean(this.createSignature.hasEncryption()));
            if (this.createSignature.hasEncryption()) {
                JRLog.trace(5, 5401013, new Integer(this.createSignature.getPermissions()));
                JRLog.trace(5, 5401014, new Boolean(this.createSignature.isStrength128Bits()));
            }
            JRLog.trace(5, 5401015, new Boolean(this.createSignature.hasSignature()));
            if (this.createSignature.hasSignature()) {
                JRLog.trace(5, 5401017, this.createSignature.getDigitalIDFileStream());
                JRLog.trace(5, 5401018, new Integer(this.createSignature.getSignatureMethod()));
                JRLog.trace(5, 5401019, this.createSignature.getSigningContact());
                JRLog.trace(5, 5401020, this.createSignature.getSigningLocation());
                JRLog.trace(5, 5401021, this.createSignature.getSigningReason());
            }
            JRLog.trace(5, 5401022, new Boolean(this.clearCacheRender));
            JRLog.trace(5, 5401023, new Boolean(this.charAt));
            JRLog.trace(5, 5401024, new Boolean(this.createSignature.isTransparent()));
            JRLog.trace(5, "parameter \"clippingArea\" = " + this.createSignature.getClippingArea());
        }
        JRLog.deIndent("Parameters list");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401002);
        }
        JRLog.deIndent("Init parameters");
    }

    private void CONTACT() throws ExpException, JRStopEngineException {
        DataStream dataStream;
        this.waitCommunicator();
        this.background = 0;
        this.bgRect = 0;
        if (this.createSignature.hasDrill()) {
            this.HorizontalAlignment = new Hashtable();
            this.SEDU = new Vector();
        }
        this.WHITE = true;
        this.convertUnitToPoint = "";
        this.clearCacheRender = this.getBackground();
        if (this.clearCacheRender && this.close == null) {
            this.ConvertProperties();
        }
        this.ConvertProperties = this._commu.getHeaderInfo(0).getEmbFonts();
        Vector vector = this._commu.getLinkComms();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = ((Communicator)vector.get(i)).getHeaderInfo(0).getEmbFonts();
                this.ConvertProperties = this.ConvertProperties + "; " + string;
            }
        }
        this.charAt = (dataStream = (DataStream)this._commu.getDataStream(0)).ie() == 1;
        this.deIndent = new ImageEngine();
        this.delete = this.createSignature.getImageCompressRatio() == -1;
        this.deIndent.setResolusion(Unit.getResolution());
        this.add = new Stack();
        this.add.push(new Offset(0, 0));
        this.F = new CommEnumeration(this._commu);
        this.createChildren = this._commu.getResolution();
        this._commu.setResolution(Unit.getResolution());
    }

    private void ConvertProperties() {
        if (this.close == null) {
            this.close = new IntHashtable();
            this.close.put(40, 41);
            this.close.put(41, 40);
            this.close.put(60, 62);
            this.close.put(62, 60);
            this.close.put(91, 93);
            this.close.put(93, 91);
            this.close.put(123, 125);
            this.close.put(125, 123);
            this.close.put(171, 187);
            this.close.put(187, 171);
            this.close.put(8249, 8250);
            this.close.put(8250, 8249);
            this.close.put(8261, 8262);
            this.close.put(8262, 8261);
            this.close.put(8317, 8318);
            this.close.put(8318, 8317);
            this.close.put(8333, 8334);
            this.close.put(8334, 8333);
            this.close.put(8712, 8715);
            this.close.put(8713, 8716);
            this.close.put(8714, 8717);
            this.close.put(8715, 8712);
            this.close.put(8716, 8713);
            this.close.put(8717, 8714);
            this.close.put(8725, 10741);
            this.close.put(8764, 8765);
            this.close.put(8765, 8764);
            this.close.put(8771, 8909);
            this.close.put(8786, 8787);
            this.close.put(8787, 8786);
            this.close.put(8788, 8789);
            this.close.put(8789, 8788);
            this.close.put(8804, 8805);
            this.close.put(8805, 8804);
            this.close.put(8806, 8807);
            this.close.put(8807, 8806);
            this.close.put(8808, 8809);
            this.close.put(8809, 8808);
            this.close.put(8810, 8811);
            this.close.put(8811, 8810);
            this.close.put(8814, 8815);
            this.close.put(8815, 8814);
            this.close.put(8816, 8817);
            this.close.put(8817, 8816);
            this.close.put(8818, 8819);
            this.close.put(8819, 8818);
            this.close.put(8820, 8821);
            this.close.put(8821, 8820);
            this.close.put(8822, 8823);
            this.close.put(8823, 8822);
            this.close.put(8824, 8825);
            this.close.put(8825, 8824);
            this.close.put(8826, 8827);
            this.close.put(8827, 8826);
            this.close.put(8828, 8829);
            this.close.put(8829, 8828);
            this.close.put(8830, 8831);
            this.close.put(8831, 8830);
            this.close.put(8832, 8833);
            this.close.put(8833, 8832);
            this.close.put(8834, 8835);
            this.close.put(8835, 8834);
            this.close.put(8836, 8837);
            this.close.put(8837, 8836);
            this.close.put(8838, 8839);
            this.close.put(8839, 8838);
            this.close.put(8840, 8841);
            this.close.put(8841, 8840);
            this.close.put(8842, 8843);
            this.close.put(8843, 8842);
            this.close.put(8847, 8848);
            this.close.put(8848, 8847);
            this.close.put(8849, 8850);
            this.close.put(8850, 8849);
            this.close.put(8856, 10680);
            this.close.put(8866, 8867);
            this.close.put(8867, 8866);
            this.close.put(8870, 10974);
            this.close.put(8872, 10980);
            this.close.put(8873, 10979);
            this.close.put(8875, 10981);
            this.close.put(8880, 8881);
            this.close.put(8881, 8880);
            this.close.put(8882, 8883);
            this.close.put(8883, 8882);
            this.close.put(8884, 8885);
            this.close.put(8885, 8884);
            this.close.put(8886, 8887);
            this.close.put(8887, 8886);
            this.close.put(8905, 8906);
            this.close.put(8906, 8905);
            this.close.put(8907, 8908);
            this.close.put(8908, 8907);
            this.close.put(8909, 8771);
            this.close.put(8912, 8913);
            this.close.put(8913, 8912);
            this.close.put(8918, 8919);
            this.close.put(8919, 8918);
            this.close.put(8920, 8921);
            this.close.put(8921, 8920);
            this.close.put(8922, 8923);
            this.close.put(8923, 8922);
            this.close.put(8924, 8925);
            this.close.put(8925, 8924);
            this.close.put(8926, 8927);
            this.close.put(8927, 8926);
            this.close.put(8928, 8929);
            this.close.put(8929, 8928);
            this.close.put(8930, 8931);
            this.close.put(8931, 8930);
            this.close.put(8932, 8933);
            this.close.put(8933, 8932);
            this.close.put(8934, 8935);
            this.close.put(8935, 8934);
            this.close.put(8936, 8937);
            this.close.put(8937, 8936);
            this.close.put(8938, 8939);
            this.close.put(8939, 8938);
            this.close.put(8940, 8941);
            this.close.put(8941, 8940);
            this.close.put(8944, 8945);
            this.close.put(8945, 8944);
            this.close.put(8946, 8954);
            this.close.put(8947, 8955);
            this.close.put(8948, 8956);
            this.close.put(8950, 8957);
            this.close.put(8951, 8958);
            this.close.put(8954, 8946);
            this.close.put(8955, 8947);
            this.close.put(8956, 8948);
            this.close.put(8957, 8950);
            this.close.put(8958, 8951);
            this.close.put(8968, 8969);
            this.close.put(8969, 8968);
            this.close.put(8970, 8971);
            this.close.put(8971, 8970);
            this.close.put(9001, 9002);
            this.close.put(9002, 9001);
            this.close.put(10088, 10089);
            this.close.put(10089, 10088);
            this.close.put(10090, 10091);
            this.close.put(10091, 10090);
            this.close.put(10092, 10093);
            this.close.put(10093, 10092);
            this.close.put(10094, 10095);
            this.close.put(10095, 10094);
            this.close.put(10096, 10097);
            this.close.put(10097, 10096);
            this.close.put(10098, 10099);
            this.close.put(10099, 10098);
            this.close.put(10100, 10101);
            this.close.put(10101, 10100);
            this.close.put(10197, 10198);
            this.close.put(10198, 10197);
            this.close.put(10205, 10206);
            this.close.put(10206, 10205);
            this.close.put(10210, 10211);
            this.close.put(10211, 10210);
            this.close.put(10212, 10213);
            this.close.put(10213, 10212);
            this.close.put(10214, 10215);
            this.close.put(10215, 10214);
            this.close.put(10216, 10217);
            this.close.put(10217, 10216);
            this.close.put(10218, 10219);
            this.close.put(10219, 10218);
            this.close.put(10627, 10628);
            this.close.put(10628, 10627);
            this.close.put(10629, 10630);
            this.close.put(10630, 10629);
            this.close.put(10631, 10632);
            this.close.put(10632, 10631);
            this.close.put(10633, 10634);
            this.close.put(10634, 10633);
            this.close.put(10635, 10636);
            this.close.put(10636, 10635);
            this.close.put(10637, 10640);
            this.close.put(10638, 10639);
            this.close.put(10639, 10638);
            this.close.put(10640, 10637);
            this.close.put(10641, 10642);
            this.close.put(10642, 10641);
            this.close.put(10643, 10644);
            this.close.put(10644, 10643);
            this.close.put(10645, 10646);
            this.close.put(10646, 10645);
            this.close.put(10647, 10648);
            this.close.put(10648, 10647);
            this.close.put(10680, 8856);
            this.close.put(10688, 10689);
            this.close.put(10689, 10688);
            this.close.put(10692, 10693);
            this.close.put(10693, 10692);
            this.close.put(10703, 10704);
            this.close.put(10704, 10703);
            this.close.put(10705, 10706);
            this.close.put(10706, 10705);
            this.close.put(10708, 10709);
            this.close.put(10709, 10708);
            this.close.put(10712, 10713);
            this.close.put(10713, 10712);
            this.close.put(10714, 10715);
            this.close.put(10715, 10714);
            this.close.put(10741, 8725);
            this.close.put(10744, 10745);
            this.close.put(10745, 10744);
            this.close.put(10748, 10749);
            this.close.put(10749, 10748);
            this.close.put(10795, 10796);
            this.close.put(10796, 10795);
            this.close.put(10797, 10796);
            this.close.put(10798, 10797);
            this.close.put(10804, 10805);
            this.close.put(10805, 10804);
            this.close.put(10812, 10813);
            this.close.put(10813, 10812);
            this.close.put(10852, 10853);
            this.close.put(10853, 10852);
            this.close.put(10873, 10874);
            this.close.put(10874, 10873);
            this.close.put(10877, 10878);
            this.close.put(10878, 10877);
            this.close.put(10879, 10880);
            this.close.put(10880, 10879);
            this.close.put(10881, 10882);
            this.close.put(10882, 10881);
            this.close.put(10883, 10884);
            this.close.put(10884, 10883);
            this.close.put(10891, 10892);
            this.close.put(10892, 10891);
            this.close.put(10897, 10898);
            this.close.put(10898, 10897);
            this.close.put(10899, 10900);
            this.close.put(10900, 10899);
            this.close.put(10901, 10902);
            this.close.put(10902, 10901);
            this.close.put(10903, 10904);
            this.close.put(10904, 10903);
            this.close.put(10905, 10906);
            this.close.put(10906, 10905);
            this.close.put(10907, 10908);
            this.close.put(10908, 10907);
            this.close.put(10913, 10914);
            this.close.put(10914, 10913);
            this.close.put(10918, 10919);
            this.close.put(10919, 10918);
            this.close.put(10920, 10921);
            this.close.put(10921, 10920);
            this.close.put(10922, 10923);
            this.close.put(10923, 10922);
            this.close.put(10924, 10925);
            this.close.put(10925, 10924);
            this.close.put(10927, 10928);
            this.close.put(10928, 10927);
            this.close.put(10931, 10932);
            this.close.put(10932, 10931);
            this.close.put(10939, 10940);
            this.close.put(10940, 10939);
            this.close.put(10941, 10942);
            this.close.put(10942, 10941);
            this.close.put(10943, 10944);
            this.close.put(10944, 10943);
            this.close.put(10945, 10946);
            this.close.put(10946, 10945);
            this.close.put(10947, 10948);
            this.close.put(10948, 10947);
            this.close.put(10949, 10950);
            this.close.put(10950, 10949);
            this.close.put(10957, 10958);
            this.close.put(10958, 10957);
            this.close.put(10959, 10960);
            this.close.put(10960, 10959);
            this.close.put(10961, 10962);
            this.close.put(10962, 10961);
            this.close.put(10963, 10964);
            this.close.put(10964, 10963);
            this.close.put(10965, 10966);
            this.close.put(10966, 10965);
            this.close.put(10974, 8870);
            this.close.put(10979, 8873);
            this.close.put(10980, 8872);
            this.close.put(10981, 8875);
            this.close.put(10988, 10989);
            this.close.put(10989, 10988);
            this.close.put(10999, 11000);
            this.close.put(11000, 10999);
            this.close.put(11001, 11002);
            this.close.put(11002, 11001);
            this.close.put(12296, 12297);
            this.close.put(12297, 12296);
            this.close.put(12298, 12299);
            this.close.put(12299, 12298);
            this.close.put(12300, 12301);
            this.close.put(12301, 12300);
            this.close.put(12302, 12303);
            this.close.put(12303, 12302);
            this.close.put(12304, 12305);
            this.close.put(12305, 12304);
            this.close.put(12308, 12309);
            this.close.put(12309, 12308);
            this.close.put(12310, 12311);
            this.close.put(12311, 12310);
            this.close.put(12312, 12313);
            this.close.put(12313, 12312);
            this.close.put(12314, 12315);
            this.close.put(12315, 12314);
            this.close.put(65288, 65289);
            this.close.put(65289, 65288);
            this.close.put(65308, 65310);
            this.close.put(65310, 65308);
            this.close.put(65339, 65341);
            this.close.put(65341, 65339);
            this.close.put(65371, 65373);
            this.close.put(65373, 65371);
            this.close.put(65375, 65376);
            this.close.put(65376, 65375);
            this.close.put(65378, 65379);
            this.close.put(65379, 65378);
            this.convertInchToPixel = new ArabicShaping(127);
        }
    }

    private void DEF_COLOR(DSPage dSPage) throws IOException, DocumentException, JRStopEngineException {
        float f = ExportToPDF.convertUnitToPoint(this.append.width);
        float f2 = ExportToPDF.convertUnitToPoint(this.append.height);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(this.background, this.bgRect, f, f2);
        }
        this.checkFilePathExist = dSPage.getPageNum();
        this.FILL_COLOR = new Vector();
        List list = ExportUtil.getContainerChildren(dSPage);
        this.F(list, 0, 0);
        if (this.charAt) {
            this.getDataStream();
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void F(List list, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle;
        ArrayList<JRObjectResult> arrayList = new ArrayList<JRObjectResult>();
        ArrayList<JRObjectResult> arrayList2 = new ArrayList<JRObjectResult>();
        HashMap<DSSection, ExportRectangle> hashMap = new HashMap<DSSection, ExportRectangle>();
        JRObjectResult jRObjectResult = null;
        DSContainer dSContainer = null;
        Vector vector = null;
        Box box = null;
        int n3 = list.size();
        while (--n3 >= 0) {
            jRObjectResult = this.getAscent((JRObjectResult)list.get(n3));
            boolean bl = this.drawImage.isExport(jRObjectResult);
            if (!bl && this.checkOutputStream == -1) continue;
            if (jRObjectResult instanceof DSShape) {
                arrayList2.add(jRObjectResult);
                continue;
            }
            if (jRObjectResult instanceof DSTable) {
                dSContainer = (DSTable)jRObjectResult;
                continue;
            }
            if (jRObjectResult instanceof DSGroup) continue;
            arrayList.add(jRObjectResult);
        }
        if (dSContainer != null) {
            box = this.convertInchToPixel((DSTable)dSContainer, n, n2, (Offset)this.add.peek());
            vector = dSContainer.getChildren();
            this.checkStop = box.I;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            JRObjectResult jRObjectResult2 = (JRObjectResult)listIterator.next();
            if (!(jRObjectResult2 instanceof DSSection)) continue;
            exportRectangle = this.WHITE((DSSection)jRObjectResult2, n, n2);
            hashMap.put((DSSection)jRObjectResult2, exportRectangle);
            this.getDrillDownPage(exportRectangle);
        }
        if (vector != null) {
            this.convertPixelToUnit(vector, n, box);
        }
        listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            this.fileUpdated((DSShape)listIterator.next(), n);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JRObjectResult jRObjectResult3 = (JRObjectResult)arrayList.get(i);
            exportRectangle = null;
            if (jRObjectResult3 instanceof DSSection) {
                exportRectangle = (ExportRectangle)hashMap.get((DSSection)jRObjectResult3);
                this._commu((DSSection)jRObjectResult3, exportRectangle, n);
                continue;
            }
            this.FB(jRObjectResult3, n, n2);
        }
        Enumeration enumeration = this.FILL_COLOR.elements();
        while (enumeration.hasMoreElements()) {
            this.getDSTOC((GeoBdrInfo)enumeration.nextElement());
        }
        this.checkStop = -1.0f;
    }

    private void FB(JRObjectResult jRObjectResult, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        boolean bl = this.drawImage.isExport(jRObjectResult);
        if (bl || this.checkOutputStream != -1) {
            int n3 = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSField) {
                String string = this.get((DSField)jRObjectResult);
                this.delete((DSField)jRObjectResult, n, n2, string);
            } else if (jRObjectResult instanceof DSSubReport) {
                this.close((DSSubReport)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSBody) {
                this._commuList((DSBody)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTabular) {
                this.TW((DSTabular)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTabularCell) {
                this.SEDU((DSTabularCell)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParagraph) {
                this.add((DSParagraph)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParagraphText) {
                this.deIndent((DSParagraphText)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSCrossTab) {
                this.endsWith((DSCrossTab)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTextObj) {
                this.elements((DSTextObj)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSChartPlatform) {
                this.dy((DSChartPlatform)jRObjectResult, n2);
            } else if (jRObjectResult instanceof DSTableObject) {
                this.PHONE((DSTableObject)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTableRow) {
                this.LIMITEDBOUND((DSTableRow)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTableCell) {
                this.NEWBORDERWIDTH((DSTableCell)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTextBox) {
                this.NEWBORDERCOLOR((DSTextBox)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSMultiValueContainer) {
                boolean bl2 = CCUtil.getBooleanPropertyByName(jRObjectResult, "ExportToPDF");
                if (bl2) {
                    this.convertTwoRes((DSMultiValueContainer)jRObjectResult, n, n2);
                }
            } else if ((n3 & 0x80) == 128) {
                if (n3 == 128) {
                    this.createFile((DSPicture)jRObjectResult, n, n2);
                } else if (n3 == 129) {
                    this.equals((DSPicture)jRObjectResult, n, n2);
                }
            } else if (n3 == 4096) {
                this.error((JRVisiableResult)jRObjectResult, n);
            } else if (jRObjectResult instanceof DSMap) {
                this.convertUnitToPixel((DSMap)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSFilterControl) {
                this.FILL_COLOR((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSNavigateButton) {
                this.FILL_COLOR((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSSlider) {
                this.FILL_COLOR((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParameterForm) {
                this.HorizontalAlignment((DSParameterForm)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSNavigateControl) {
                this.FT((DSNavigateControl)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSGMap) {
                this.convertUnitToPoint((DSGMap)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSGeoMap) {
                this.createChildren((DSGeoMap)jRObjectResult, n, n2);
            } else if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3401001, jRObjectResult);
            }
        }
    }

    private void FILL_COLOR(JRVisiableResult jRVisiableResult, int n, int n2) throws IOException, DocumentException {
        ExportRectangle exportRectangle = this.checkStop(jRVisiableResult, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        this.getDrillDownPage(exportRectangle);
        Render render = null;
        if (jRVisiableResult instanceof DSFilterControl) {
            render = ((DSFilterControl)jRVisiableResult).getRender();
        } else if (jRVisiableResult instanceof DSNavigateButton) {
            render = ((DSNavigateButton)jRVisiableResult).getRender();
        } else if (jRVisiableResult instanceof DSSlider) {
            render = ((DSSlider)jRVisiableResult).getRender();
        }
        if (render != null) {
            this.add.push(new Offset((Offset)this.add.peek(), jRVisiableResult.getX(), this.getY(jRVisiableResult, n2)));
            this.drawLocalLink(render, n, null);
            this.add.pop();
        }
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void FT(DSNavigateControl dSNavigateControl, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        this.addElement(dSNavigateControl, n, n2);
    }

    private void HorizontalAlignment(DSParameterForm dSParameterForm, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        ExportRectangle exportRectangle = this.checkStop(dSParameterForm, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        this.getDrillDownPage(exportRectangle);
        this.addPropsChangedBy(dSParameterForm, n, n2);
        boolean bl = CCUtil.getBooleanPropertyByName(dSParameterForm, "IsShowTitle");
        if (bl) {
            Offset offset = (Offset)this.add.peek();
            Rectangle rectangle = dSParameterForm.getTitleRec();
            int[] nArray = dSParameterForm.getTitleXY();
            Color color = CCUtil.getColorPropertyByName(dSParameterForm, "TitleBackground");
            if (rectangle != null) {
                int n3 = dSParameterForm.getX() + n + rectangle.x;
                int n4 = this.getY(dSParameterForm, n2) + rectangle.y;
                Box box = this.getFloatPropertyByName(offset, n3, n4, rectangle.width, rectangle.height);
                if (color != null) {
                    this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, color);
                }
                Color color2 = CCUtil.getColorPropertyByName(dSParameterForm, "TitleForeground");
                boolean bl2 = CCUtil.getBooleanPropertyByName(dSParameterForm, "TitleUnderline");
                FontInfo fontInfo = this.drawImage.getFontInfo(dSParameterForm);
                String string = fontInfo.getFontName();
                boolean bl3 = this.getBooleanPropertyByName(string);
                float f = this.getDSRow(fontInfo.getFontSize());
                int n5 = this.getCurrentCommunicator(dSParameterForm, string);
                PDFFont pDFFont = new PDFFont(string, n5, f);
                FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
                int n6 = fontMetrics.getAscent();
                ExportTextStyle exportTextStyle = new ExportTextStyle(color2, pDFFont, bl3);
                exportTextStyle.setUnderline(bl2, 1, color2);
                exportTextStyle.setAscent(n6);
                String string2 = CCUtil.getStringPropertyByName(dSParameterForm, "TitleText");
                float f2 = ExportToPDF.convertUnitToPoint(n3 + nArray[0] + offset.dx) + (float)this.background;
                float f3 = ExportToPDF.convertUnitToPoint(n4 + nArray[1] + offset.dy) + (float)this.bgRect;
                ExportText exportText = new ExportText(string2, f2, f3, exportTextStyle);
                this.getEveryLinePos(exportText);
            }
        }
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void LIMITEDBOUND(DSTableRow dSTableRow, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addElement(dSTableRow, n, n2);
    }

    private void NEWBORDERCOLOR(DSTextBox dSTextBox, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addElement(dSTextBox, n, n2);
    }

    private void NEWBORDERWIDTH(DSTableCell dSTableCell, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addElement(dSTableCell, n, n2);
    }

    private void PHONE(DSTableObject dSTableObject, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle = this.checkStop(dSTableObject, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        this.getDrillDownPage(exportRectangle);
        this.add.push(new Offset((Offset)this.add.peek(), dSTableObject.getX(), this.getY(dSTableObject, n2)));
        int n3 = dSTableObject.getStartYPos();
        DrawingTable drawingTable = DrawingTable.getInstance(dSTableObject, this.drawImage, (byte)0);
        this.drawLocalLink = new Hashtable();
        this.drawOval = new Hashtable();
        this.addElement = new Vector();
        this.addPropsChangedBy = new Vector();
        while (drawingTable.hasMoreChild()) {
            Row row = drawingTable.nextChild();
            Box box = this.getFloatPropertyByName((Offset)this.add.peek(), row.getX(), row.getY(), row.getWidth(), row.getHeight());
            ExportRectangle exportRectangle2 = this.background(row, box);
            ExportRectangle exportRectangle3 = new ExportRectangle(exportRectangle2);
            exportRectangle3.setTopBorder(null);
            exportRectangle3.setBottomBorder(null);
            this.addElement.add(exportRectangle3);
            ExportRectangle exportRectangle4 = new ExportRectangle(exportRectangle2);
            exportRectangle4.setLeftBorder(null);
            exportRectangle4.setRightBorder(null);
            this.addPropsChangedBy.add(exportRectangle4);
            this.getDrillDownPage(exportRectangle2);
            Offset offset = new Offset((Offset)this.add.peek(), row.getX(), row.getY());
            while (row.hasMoreChild()) {
                RectCell rectCell = row.nextChild();
                if (rectCell.isMerged()) {
                    this.drawOval.put(rectCell, offset);
                    continue;
                }
                this.append(rectCell, offset, n, n3);
            }
        }
        this.checkFilePathExist();
        this.charAt(n, n3);
        this.booleanValue(n, n3);
        this.checkOutputStream();
        this.add.pop();
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void SEDU(DSTabularCell dSTabularCell, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addElement(dSTabularCell, n, n2);
    }

    private void TW(DSTabular dSTabular, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addElement(dSTabular, n, n2);
    }

    private ExportRectangle WHITE(DSSection dSSection, int n, int n2) {
        int n3 = dSSection.getX() + n;
        int n4 = this.getY(dSSection, n2);
        int n5 = dSSection.getWidth();
        int n6 = dSSection.getHeight();
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFloatPropertyByName(offset, n3, n4, n5, n6);
        return this.clear(dSSection, box);
    }

    private void _commu(DSSection dSSection, ExportRectangle exportRectangle, int n) throws IOException, DocumentException, JRStopEngineException {
        boolean bl;
        if (this.createSignature.hasDrill()) {
            this.floatValue(dSSection, this.BLACK.substring(0, this.BLACK.length() - 4));
        }
        if ((bl = CCUtil.getBooleanPropertyByName(dSSection, "ShowBottomLine")) && null == exportRectangle.D) {
            if (this.checkStop != -1.0f) {
                exportRectangle.I.I = this.checkStop;
            }
            exportRectangle.setBottomBorder(new ExportLineStyle(1.0f, 1, Color.BLACK));
        }
        Offset offset = (Offset)this.add.peek();
        int n2 = (int)Unit.convertPixelToUnit(exportRectangle.I.y - (float)this.bgRect, 72) - offset.dy;
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        int n3 = -1;
        if (this.checkOutputStream != -1) {
            n3 = this.checkOutputStream;
            this.checkOutputStream = -1;
        }
        ++n;
        int n4 = dSSection.getStartYPos();
        this.add.push(new Offset((Offset)this.add.peek(), dSSection.getX(), n2));
        Vector vector = dSSection.getChildren();
        if (vector != null) {
            int n5 = vector.size();
            while (--n5 >= 0) {
                JRObjectResult jRObjectResult = this.getAscent((JRObjectResult)vector.get(n5));
                this.FB(jRObjectResult, n, n4);
            }
        }
        if (n3 != -1) {
            this.checkOutputStream = n3;
        }
        this.add.pop();
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void _commuList(DSBody dSBody, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.drawImage.handleContainerBegin(dSBody);
        this.addElement(dSBody, n, n2);
        this.drawImage.handleContainerEnd(dSBody);
    }

    private void add(DSParagraph dSParagraph, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.addPropsChangedBy(dSParagraph, n, n2);
    }

    private void addElement(DSContainer dSContainer, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle = this.checkStop(dSContainer, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        this.getDrillDownPage(exportRectangle);
        this.addPropsChangedBy(dSContainer, n, n2);
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void addPropsChangedBy(DSContainer dSContainer, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.add.push(new Offset((Offset)this.add.peek(), dSContainer.getX(), this.getY(dSContainer, n2)));
        int n3 = dSContainer.getStartYPos();
        List list = ExportUtil.getContainerChildren(dSContainer);
        if (list != null) {
            int n4 = list.size();
            while (--n4 >= 0) {
                JRObjectResult jRObjectResult = this.getAscent((JRObjectResult)list.get(n4));
                this.FB(jRObjectResult, n, n3);
            }
        }
        this.add.pop();
    }

    private void append(RectCell rectCell, Offset offset, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        Box box = this.getFloatPropertyByName(offset, rectCell.getX(), rectCell.getY(), rectCell.getWidth(), rectCell.getHeight());
        ExportRectangle exportRectangle = this.background(rectCell, box);
        this.addElement.add(exportRectangle);
        this.getDrillDownPage(exportRectangle);
        Offset offset2 = new Offset(offset, rectCell.getX(), rectCell.getY());
        Box box2 = this.getFloatPropertyByName(offset2, 0, 0, rectCell.getWidth(), rectCell.getHeight());
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box2.x, box2.y, box2.I, box2.Z);
        }
        while (rectCell.hasMoreChild()) {
            ContentCell contentCell = rectCell.nextChild();
            Offset offset3 = new Offset(offset2, contentCell.getX(), contentCell.getY());
            if (contentCell.isExpand()) {
                this.drawLocalLink.put(contentCell, offset3);
                continue;
            }
            this.bgRect(contentCell, offset3, n, n2);
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private ExportRectangle background(ContainerInfo containerInfo, Box box) {
        Color color = containerInfo.getBackground();
        ExportRectangle exportRectangle = new ExportRectangle(box, color);
        ExportLineStyle exportLineStyle = null;
        if (containerInfo.hasTopBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getTopBorderWidth()), this.clearCacheRender(containerInfo.getTopBorderStyle()), containerInfo.getTopBorderColor());
            exportRectangle.setTopBorder(exportLineStyle);
        }
        if (containerInfo.hasBottomBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getBottomBorderWidth()), this.clearCacheRender(containerInfo.getBottomBorderStyle()), containerInfo.getBottomBorderColor());
            exportRectangle.setBottomBorder(exportLineStyle);
        }
        if (containerInfo.hasLeftBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getLeftBorderWidth()), this.clearCacheRender(containerInfo.getLeftBorderStyle()), containerInfo.getLeftBorderColor());
            exportRectangle.setLeftBorder(exportLineStyle);
        }
        if (containerInfo.hasRightBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getRightBorderWidth()), this.clearCacheRender(containerInfo.getRightBorderStyle()), containerInfo.getRightBorderColor());
            exportRectangle.setRightBorder(exportLineStyle);
        }
        boolean bl = containerInfo.hasShadow();
        Color color2 = containerInfo.getShadowColor();
        exportRectangle.setShadow(bl, bl, bl, bl, color2, shadow);
        if (containerInfo instanceof Row) {
            DSTableRow dSTableRow = ((Row)containerInfo).getDSRow();
            FillPatternProperties fillPatternProperties = FillPatternAdapter.ConvertProperties(dSTableRow);
            exportRectangle.setFillPatternProperties(fillPatternProperties);
        }
        return exportRectangle;
    }

    private void bgRect(ContentCell contentCell, Offset offset, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        JRObjectResult jRObjectResult = contentCell.getSimpleObject();
        this.add.push(new Offset(offset, contentCell.getContentX(), contentCell.getContentY()));
        Box box = this.getFloatPropertyByName(offset, 0, 0, contentCell.getWidth(), contentCell.getHeight());
        if (box.I > 0.0f && box.Z > 0.0f) {
            if (this.createSignature.getClippingArea()) {
                this.convertPixelToUnit.I();
                this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
            }
            if (jRObjectResult instanceof DSField) {
                DSField dSField = (DSField)jRObjectResult;
                this.black(dSField, box, n, n2);
            } else if (jRObjectResult instanceof DSParagraph) {
                List list = ExportUtil.getContainerChildren((DSParagraph)jRObjectResult);
                if (list != null) {
                    int n3 = list.size();
                    while (--n3 >= 0) {
                        JRObjectResult jRObjectResult2 = this.getAscent((JRObjectResult)list.get(n3));
                        this.FB(jRObjectResult2, n, n2);
                    }
                }
            } else {
                JRObjectResult jRObjectResult3 = this.getAscent(jRObjectResult);
                this.FB(jRObjectResult3, n, n2);
            }
            if (this.createSignature.getClippingArea()) {
                this.convertPixelToUnit.Z();
            }
        }
        this.add.pop();
    }

    private void black(DSField dSField, Box box, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        Render render = this.drawImage.getRender(dSField);
        if (render instanceof RenderHidden) {
            render = null;
            return;
        }
        int n3 = dSField.getRenderType();
        boolean bl = true;
        if (!(n3 != 4 && n3 != 5 && n3 != 6 && n3 != 7 && n3 != 8 && n3 != 9 && n3 != 10 && n3 != 11 || (bl = CCUtil.getBooleanPropertyByName(dSField, "ExportToPDF")))) {
            return;
        }
        ExportRectFromV7 exportRectFromV7 = this.drawImage(dSField);
        Object[] objectArray = new Object[]{exportRectFromV7, box};
        this.addElement.add(objectArray);
        this.dispose(exportRectFromV7.D, exportRectFromV7.J, box);
        this.drawArc(dSField, exportRectFromV7, box);
        Box box2 = this.getFloatPropertyByName((Offset)this.add.peek(), 0, 0, dSField.getWidth(), dSField.getHeight());
        this.drawLocalLink(render, n, box2);
        render.clearCacheRender();
        render = null;
        if (exportRectFromV7.A) {
            this.getBaseFont(dSField, box);
        }
    }

    private void booleanValue(int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        if (this.drawLocalLink.size() <= 0) {
            return;
        }
        Enumeration enumeration = this.drawLocalLink.keys();
        while (enumeration.hasMoreElements()) {
            ContentCell contentCell = (ContentCell)enumeration.nextElement();
            Offset offset = (Offset)this.drawLocalLink.get(contentCell);
            this.bgRect(contentCell, offset, n, n2);
        }
    }

    private void charAt(int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        if (this.drawOval.size() <= 0) {
            return;
        }
        Enumeration enumeration = this.drawOval.keys();
        while (enumeration.hasMoreElements()) {
            RectCell rectCell = (RectCell)enumeration.nextElement();
            Offset offset = (Offset)this.drawOval.get(rectCell);
            this.append(rectCell, offset, n, n2);
        }
    }

    private void checkFilePathExist() {
        for (int i = 0; i < this.addPropsChangedBy.size(); ++i) {
            Object e = this.addPropsChangedBy.get(i);
            if (!(e instanceof ExportRectangle)) continue;
            this.getEmbFonts((ExportRectangle)e);
        }
    }

    private void checkOutputStream() {
        for (int i = 0; i < this.addElement.size(); ++i) {
            Object e = this.addElement.get(i);
            if (e instanceof ExportRectangle) {
                this.getEmbFonts((ExportRectangle)e);
                continue;
            }
            if (!(e instanceof Object[])) continue;
            Object[] objectArray = (Object[])e;
            this.drawFileLink((ExportRectFromV7)objectArray[0], (Box)objectArray[1]);
        }
    }

    private ExportRectangle checkStop(JRVisiableResult jRVisiableResult, int n, int n2) {
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(jRVisiableResult, offset, n, n2);
        return this.clear(jRVisiableResult, box);
    }

    private ExportRectangle clear(JRVisiableResult jRVisiableResult, Box box) {
        FillPatternProperties fillPatternProperties;
        Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
        ExportRectangle exportRectangle = new ExportRectangle(box, color);
        if (jRVisiableResult.getObjectType() == 45) {
            int n = CCUtil.getIntPropertyByName(jRVisiableResult, "BorderJoint");
            float f = ExportToPDF.convertUnitToPoint(CCUtil.getFloatPropertyByName(jRVisiableResult, "RoundJointRadius"));
            exportRectangle.setBorderJoint(n);
            exportRectangle.setRoundJointRadius(f);
        }
        int[] nArray = new int[4];
        float[] fArray2 = new float[4];
        Color[] colorArray = new Color[4];
        int n = 4;
        while (--n >= 0) {
            nArray[n] = this.clearCacheRender(CCUtil.getIntPropertyByName(jRVisiableResult, BORDERLINENAME[n]));
            fArray2[n] = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(jRVisiableResult, NEWBORDERWIDTH[n]));
            colorArray[n] = CCUtil.getColorPropertyByName(jRVisiableResult, NEWBORDERCOLOR[n]);
        }
        ExportLineStyle exportLineStyle = null;
        if (nArray[1] != 0 && colorArray[1] != null && fArray2[1] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[1], nArray[1], colorArray[1]);
            exportRectangle.setLeftBorder(exportLineStyle);
        }
        if (nArray[0] != 0 && colorArray[0] != null && fArray2[0] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[0], nArray[0], colorArray[0]);
            exportRectangle.setTopBorder(exportLineStyle);
        }
        if (nArray[3] != 0 && colorArray[3] != null && fArray2[3] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[3], nArray[3], colorArray[3]);
            exportRectangle.setRightBorder(exportLineStyle);
        }
        if (nArray[2] != 0 && colorArray[2] != null && fArray2[2] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[2], nArray[2], colorArray[2]);
            exportRectangle.setBottomBorder(exportLineStyle);
        }
        boolean bl = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Shadow");
        Color color2 = CCUtil.getColorPropertyByName(jRVisiableResult, "ShadowColor");
        exportRectangle.setShadow(bl, bl, bl, bl, color2, shadow);
        if ((jRVisiableResult instanceof DSSection || jRVisiableResult instanceof DSTableRow || jRVisiableResult instanceof DSBody) && (fillPatternProperties = FillPatternAdapter.ConvertProperties(jRVisiableResult)).getFillPatternType() != FillPatternProperties.FILL_COLOR) {
            exportRectangle.setFillPatternProperties(fillPatternProperties);
        }
        return exportRectangle;
    }

    private int clearCacheRender(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        if (JRLog.isTrace(3)) {
            JRLog.trace(3, 3401002, new Integer(n));
        }
        return 0;
    }

    private void close(DSSubReport dSSubReport, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        boolean bl = !this.drawImage.isExport(dSSubReport);
        int n3 = dSSubReport.getStartYPos();
        if (bl) {
            return;
        }
        this.drawImage.handleContainerBegin(dSSubReport);
        ExportRectangle exportRectangle = this.checkStop(dSSubReport, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            if (exportRectangle.L == BorderProperties.BORDERJOINT_ROUND) {
                this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z, exportRectangle.M);
            } else {
                this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
            }
        }
        this.getDrillDownPage(exportRectangle);
        this.add.push(new Offset((Offset)this.add.peek(), dSSubReport.getX(), this.getY(dSSubReport, n2)));
        List list = ExportUtil.getContainerChildren(dSSubReport);
        this.F(list, n, n3);
        this.add.pop();
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
        this.drawImage.handleContainerEnd(dSSubReport);
    }

    Box convertInchToPixel(DSTable dSTable, int n, int n2, Offset offset) {
        Box box = this.getFillPatternType(dSTable, offset, n, n2);
        Color color = CCUtil.getColorPropertyByName(dSTable, "Background");
        if (color != null) {
            this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, color);
        }
        if (CCUtil.getBooleanPropertyByName(dSTable, "ShowBorder")) {
            this.FILL_COLOR.addElement(new GeoBdrInfo(box.x, box.y, box.I, box.Z, 23, Color.black, 1.0f, 1, -1, -1, -1));
        }
        return box;
    }

    void convertPixelToUnit(Vector vector, int n, Box box) {
        float f;
        float f2;
        int n2;
        DSColumn dSColumn = null;
        Color color = null;
        Offset offset = (Offset)this.add.elementAt(0);
        float f3 = box.y;
        float f4 = box.Z;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            dSColumn = (DSColumn)vector.elementAt(n2);
            if (!this.drawImage.isExport(dSColumn)) continue;
            f2 = ExportToPDF.convertUnitToPoint(dSColumn.getX() + offset.dx + n) + box.x;
            f = ExportToPDF.convertUnitToPoint(dSColumn.getWidth());
            color = CCUtil.getColorPropertyByName(dSColumn, "Background");
            if (color == null) continue;
            this.convertPixelToUnit.fillRect(f2, f3, f, f4, color);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            dSColumn = (DSColumn)vector.elementAt(n2);
            if (!this.drawImage.isExport(dSColumn)) continue;
            f2 = ExportToPDF.convertUnitToPoint(dSColumn.getX() + offset.dx + n) + box.x;
            f = ExportToPDF.convertUnitToPoint(dSColumn.getWidth());
            if (!CCUtil.getBooleanPropertyByName(dSColumn, "ShowBorder")) continue;
            this.convertPixelToUnit.drawLine(f2 + f, f3, f2 + f, f3 + f4, 1.0f, 1, Color.black);
        }
    }

    private void convertTwoRes(DSMultiValueContainer dSMultiValueContainer, int n, int n2) throws IOException, DocumentException {
        ExportRectangle exportRectangle = this.checkStop(dSMultiValueContainer, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(exportRectangle.I.x, exportRectangle.I.y, exportRectangle.I.I, exportRectangle.I.Z);
        }
        this.getDrillDownPage(exportRectangle);
        this.add.push(new Offset((Offset)this.add.peek(), dSMultiValueContainer.getX(), this.getY(dSMultiValueContainer, n2)));
        Render render = dSMultiValueContainer.getRender();
        this.drawLocalLink(render, n, null);
        this.add.pop();
        this.getEmbFonts(exportRectangle);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void convertUnitToPixel(DSMap dSMap, int n, int n2) throws JRStopEngineException {
        Object object;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSMap, offset, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        JReportMap jReportMap = new JReportMap();
        if (!this.createFile) {
            object = jReportMap.getMapImage(dSMap);
            if (object != null) {
                this.createImage(dSMap, (Image)object, box.x, box.y, box.I, box.Z);
            }
        } else {
            jReportMap.setProperty(dSMap);
            jReportMap.setBounds(dSMap.getBounds());
            jReportMap.createChildren(dSMap);
            object = this.convertPixelToUnit.getGraphics((float)this.black > box.I ? (float)this.black : box.I, (float)this.booleanValue > box.Z ? (float)this.booleanValue : box.Z);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            ((Graphics2D)object).setTransform(affineTransform);
            jReportMap.paint((Graphics)object);
            ((Graphics)object).dispose();
        }
        this.add.push(new Offset((Offset)this.add.peek(), dSMap.getX(), dSMap.getY()));
        object = ExportUtil.getContainerChildren(dSMap);
        if (object != null) {
            int n3 = object.size();
            while (--n3 >= 0) {
                JRObjectResult jRObjectResult = this.getAscent((JRObjectResult)object.get(n3));
                if (!(jRObjectResult instanceof DSArea)) continue;
                List list = ExportUtil.getContainerChildren((DSArea)jRObjectResult);
                int n4 = list.size();
                while (--n4 >= 0) {
                    JRObjectResult jRObjectResult2 = this.getAscent((JRObjectResult)list.get(n4));
                    if (!(jRObjectResult2 instanceof DSField)) continue;
                    DSField dSField = (DSField)jRObjectResult2;
                    Box box2 = this.getFillPatternType(dSField, (Offset)this.add.peek(), n, n2);
                    this.getBaseFont(dSField, box2);
                }
            }
        }
        this.add.pop();
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void convertUnitToPoint(DSGMap dSGMap, int n, int n2) {
        JReportGoogleMap jReportGoogleMap;
        Image image;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSGMap, offset, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        if ((image = (jReportGoogleMap = new JReportGoogleMap()).getMapImage(dSGMap)) != null) {
            this.createImage(dSGMap, image, box.x, box.y, box.I, box.Z);
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void createChildren(DSGeoMap dSGeoMap, int n, int n2) throws JRStopEngineException {
        JReportGoMap jReportGoMap;
        Image image;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSGeoMap, offset, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        if ((image = (jReportGoMap = new JReportGoMap()).getMapImage(dSGeoMap)) != null) {
            this.createImage(dSGeoMap, image, box.x, box.y, box.I, box.Z);
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    void createFile(DSPicture dSPicture, int n, int n2) throws JRStopEngineException {
        ImageInfo imageInfo;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSPicture, offset, n, n2);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        if ((imageInfo = this.deIndent.getImage(this.delete, true, dSPicture)) != null) {
            Image image = imageInfo.getImage();
            int n3 = imageInfo.getWidth();
            int n4 = imageInfo.getHeight();
            int n5 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
            int n6 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
            n3 = Unit.convertUnitToPixel(n3, 72);
            n4 = Unit.convertUnitToPixel(n4, 72);
            if (image != null) {
                this.createImage(dSPicture, image, box.x + (float)n5, box.y + (float)n6, n3, n4);
            }
        }
        this.getBaseFont(dSPicture, box);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    void createImage(JRVisiableResult jRVisiableResult, Image image, float f, float f2, float f3, float f4) {
        String string = null;
        ExportUtil.waitImage(image);
        if (jRVisiableResult instanceof DSPicture) {
            string = this.createSignature(jRVisiableResult, image);
        }
        this.convertPixelToUnit.drawImage(image, f, f2, f3, f4, string);
    }

    private String createSignature(JRVisiableResult jRVisiableResult, Image image) {
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        Object v = this.dispose.get(dSTemplatible);
        if (v != null) {
            return v.toString();
        }
        String string = this.convertPixelToUnit.getImgID(image);
        if (!CCUtil.isChangeByFormularProperty(jRVisiableResult, "PictureName")) {
            this.dispose.put(dSTemplatible, string);
        }
        return string;
    }

    void deIndent(DSParagraphText dSParagraphText, int n, int n2) throws IOException, DocumentException {
        String string = dSParagraphText.getText();
        if (string != null) {
            Offset offset = (Offset)this.add.peek();
            Box box = this.getFillPatternType(dSParagraphText, offset, n, n2);
            Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
            if (color != null) {
                this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, color);
            }
            if (string.trim().length() > 0) {
                int n3;
                Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
                FontInfo fontInfo = this.drawImage.getFontInfo(dSParagraphText);
                String string2 = fontInfo.getFontName();
                boolean bl = this.getBooleanPropertyByName(string2);
                boolean bl2 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript") != 0;
                float f = fontInfo.getFontSize();
                if (bl2) {
                    f = f * 2.0f / 3.0f;
                }
                f = this.getDSRow(f);
                int n4 = this.getContentY(dSParagraphText, string2);
                PDFFont pDFFont = new PDFFont(string2, n4, f);
                boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
                int n5 = 0;
                Color color3 = null;
                if (bl3) {
                    n5 = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
                    if (n5 == 0) {
                        n5 = 1;
                    } else if (n5 == 1) {
                        n5 = 5;
                    }
                    color3 = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
                }
                boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
                int n6 = 0;
                Color color4 = null;
                if (bl4) {
                    n6 = this.getBottomBorderColor(dSParagraphText, CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle"));
                    color4 = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
                }
                ExportTextStyle exportTextStyle = new ExportTextStyle(color2, pDFFont, bl);
                exportTextStyle.setUnderline(bl4, n6, color4);
                exportTextStyle.setStrikethrough(bl3, n5, color3);
                int n7 = CCUtil.getIntPropertyByName((DSParagraph)dSParagraphText.getParent(), PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
                if (n7 == 3 && (n3 = dSParagraphText.getWords().size()) > 0) {
                    for (int i = 0; i < n3; ++i) {
                        string = this.getBottomBorderStyle((String)dSParagraphText.getWords().elementAt(i));
                        float f2 = box.x + ExportToPDF.convertUnitToPoint(dSParagraphText.getWordsPosition()[i] + dSParagraphText.getTextX());
                        float f3 = box.y + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextY());
                        ExportText exportText = new ExportText(string, f2, f3, exportTextStyle);
                        this.getEveryLinePos(exportText);
                    }
                    return;
                }
                string = this.getBottomBorderStyle(string);
                float f4 = box.x + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextX());
                float f5 = box.y + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextY());
                ExportText exportText = new ExportText(string, f4, f5, exportTextStyle);
                this.getEveryLinePos(exportText);
            }
        }
    }

    void delete(DSField dSField, int n, int n2, String string) throws IOException, DocumentException, JRStopEngineException {
        Render render = this.drawImage.getRender(dSField);
        if (render instanceof RenderHidden) {
            render = null;
            return;
        }
        boolean bl = this.drawImage.isExport(dSField);
        if (!bl) {
            return;
        }
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSField, offset, n, n2);
        if (box.I <= 0.0f || box.Z <= 0.0f) {
            return;
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        ExportRectFromV7 exportRectFromV7 = this.drawImage(dSField);
        this.dispose(exportRectFromV7.D, exportRectFromV7.J, box);
        this.drawArc(dSField, exportRectFromV7, box);
        this.add.push(new Offset((Offset)this.add.peek(), dSField.getX(), this.getY(dSField, n2)));
        this.drawLocalLink(render, n, box);
        render.clearCacheRender();
        render = null;
        this.add.pop();
        this.drawFileLink(exportRectFromV7, box);
        if (exportRectFromV7.A) {
            this.getBaseFont(dSField, box);
        }
        if (string != null) {
            if (string.lastIndexOf("\\") != -1) {
                string = string.substring(string.lastIndexOf("\\") + 1, string.length());
            }
            this.convertPixelToUnit.drawFileLink(string, box.x, box.y, box.I, box.Z);
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    void dispose(Color color, boolean bl, Box box) {
        if (color != null) {
            if (bl) {
                this.convertPixelToUnit.fillRect(box.x, box.y, box.I - (float)shadow, box.Z - (float)shadow, color);
            } else {
                this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, color);
            }
        }
    }

    void drawArc(DSField dSField, ExportRectFromV7 exportRectFromV7, Box box) {
        int[] nArray = exportRectFromV7.F;
        float f = exportRectFromV7.I;
        int n = exportRectFromV7.S;
        if (n != 0) {
            float f2;
            float f3 = box.x;
            float f4 = box.y;
            float f5 = box.I;
            float f6 = box.Z;
            float f7 = f2 = f;
            float f8 = f2;
            float f9 = f2;
            if (exportRectFromV7.Z > 0) {
                if (nArray[0] == 5) {
                    f9 = f * 3.0f;
                }
                if (nArray[1] == 5) {
                    f8 = f * 3.0f;
                }
                if (nArray[2] == 5) {
                    f7 = f * 3.0f;
                }
                if (nArray[3] == 5) {
                    f2 = f * 3.0f;
                }
                f3 += f8;
                f4 += f9;
                f5 -= f8 + f2;
                f6 -= f9 + f7;
            }
            if (exportRectFromV7.J) {
                f5 -= (float)shadow;
                f6 -= (float)shadow;
            }
            Color color = CCUtil.getColorPropertyByName(dSField, "PatternColor");
            Box box2 = new Box(f3, f4, f5, f6);
            this.getColorPropertyByName(box2, color, n);
        }
    }

    void drawFileLink(ExportRectFromV7 exportRectFromV7, Box box) {
        boolean bl = exportRectFromV7.J;
        this.getDbBinaryPropertyByName(box, null, exportRectFromV7.C, exportRectFromV7.I, exportRectFromV7.F, bl, bl, bl, bl, exportRectFromV7.B, shadow);
    }

    /*
     * WARNING - void declaration
     */
    private ExportRectFromV7 drawImage(DSField dSField) {
        void var6_10;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.drawFileLink.get(dSTemplatible);
        if (v != null) {
            int n;
            ExportRectFromV7 exportRectFromV7 = new ExportRectFromV7((ExportRectFromV7)v);
            Vector vector = exportRectFromV7.getPropsChangedBy();
            if (vector != null && (n = vector.size()) > 0) {
                block9: for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)vector.get(i);
                    switch (n2) {
                        case 1: {
                            int[] nArray = new int[4];
                            int n3 = 0;
                            int n4 = 4;
                            while (--n4 >= 0) {
                                nArray[n4] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[n4]);
                                n3 += nArray[n4];
                            }
                            exportRectFromV7.setBorderCount(n3);
                            exportRectFromV7.setBorderStyle(nArray);
                            continue block9;
                        }
                        case 2: {
                            int n4 = CCUtil.getBooleanPropertyByName(dSField, "Shadow");
                            exportRectFromV7.setHasShadow(n4 != 0);
                            continue block9;
                        }
                        case 3: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "ShadowColor");
                            exportRectFromV7.setShadowColor(color);
                            continue block9;
                        }
                        case 4: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "BorderColor");
                            exportRectFromV7.setBorderColor(color);
                            continue block9;
                        }
                        case 5: {
                            float f = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "BorderWidth"));
                            exportRectFromV7.setBorderWidth(f);
                            continue block9;
                        }
                        case 6: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "Background");
                            exportRectFromV7.setBackground(color);
                            continue block9;
                        }
                        case 7: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "EnableHyperlinkOnPDF");
                            exportRectFromV7.setEnablelink(bl);
                        }
                    }
                }
            }
            return exportRectFromV7;
        }
        int[] nArray = new int[4];
        int n = 0;
        int bl = 4;
        while (--var6_10 >= 0) {
            nArray[var6_10] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[var6_10]);
            n += nArray[var6_10];
        }
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Shadow");
        Color color = CCUtil.getColorPropertyByName(dSField, "ShadowColor");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        float f = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "BorderWidth"));
        Color color3 = CCUtil.getColorPropertyByName(dSField, "Background");
        int n5 = CCUtil.getIntPropertyByName(dSField, "PatternStyle");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSField, "EnableHyperlinkOnPDF");
        ExportRectFromV7 exportRectFromV7 = new ExportRectFromV7(color3, f, nArray, color2, n, n5);
        exportRectFromV7.setShadow(bl2, color);
        exportRectFromV7.setEnablelink(bl3);
        this.drawLine(dSField, exportRectFromV7);
        this.drawFileLink.put(dSTemplatible, exportRectFromV7);
        return exportRectFromV7;
    }

    private void drawLine(DSField dSField, ExportRectFromV7 exportRectFromV7) {
        if (CCUtil.isChangeByFormularProperty(dSField, "TopLine") || CCUtil.isChangeByFormularProperty(dSField, "LeftLine") || CCUtil.isChangeByFormularProperty(dSField, "BottomLine") || CCUtil.isChangeByFormularProperty(dSField, "RightLine")) {
            exportRectFromV7.addPropsChangedBy(1);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Shadow")) {
            exportRectFromV7.addPropsChangedBy(2);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "ShadowColor")) {
            exportRectFromV7.addPropsChangedBy(3);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "BorderColor")) {
            exportRectFromV7.addPropsChangedBy(4);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "BorderWidth")) {
            exportRectFromV7.addPropsChangedBy(5);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Background")) {
            exportRectFromV7.addPropsChangedBy(6);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "EnableHyperlinkOnPDF")) {
            exportRectFromV7.addPropsChangedBy(7);
        }
    }

    private void drawLocalLink(Render render, int n, Box box) throws IOException, DocumentException {
        if (render instanceof RenderText) {
            this.drawString((RenderText)render, box);
        } else if (render instanceof RenderImage) {
            this.drawRoundRect(render, n);
        } else if (render instanceof RenderBarCode) {
            this.drawRect((RenderBarCode)render, n);
        } else {
            this.drawOval(render, n);
        }
    }

    private void drawOval(Render render, int n) {
        Offset offset = (Offset)this.add.peek();
        Box box = this.getExportPages(render, offset, n);
        box.x = (float)((double)box.x + 0.75);
        box.y = (float)((double)box.y + 0.5);
        box.I = (float)((double)box.I - 0.75);
        box.Z = (float)((double)box.Z - 0.5);
        if (!this.createFile) {
            ImageInfo imageInfo = this.deIndent.getImage(this.delete, true, render);
            if (imageInfo != null) {
                Image image = imageInfo.getImage();
                if (image == null) {
                    return;
                }
                if (render instanceof RenderImageButton || render instanceof RenderRank) {
                    int n2 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
                    int n3 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
                    int n4 = Unit.convertTwoRes(imageInfo.getWidth(), this.createChildren, 72);
                    int n5 = Unit.convertTwoRes(imageInfo.getHeight(), this.createChildren, 72);
                    this.createImage(render.getParent(), image, box.x + (float)n2, box.y + (float)n3, Unit.convertUnitToPixel(n4), Unit.convertUnitToPixel(n5));
                } else {
                    this.createImage(render.getParent(), image, box.x, box.y, box.I, box.Z);
                }
            }
        } else {
            Rectangle rectangle = new Rectangle(Unit.convertUnitToPixel(render.getWidth()), Unit.convertUnitToPixel(render.getHeight()));
            render.setPaintCalledByField(false);
            Graphics2D graphics2D = this.convertPixelToUnit.getGraphics(this.black > rectangle.width ? (float)this.black : (float)rectangle.width, this.booleanValue > rectangle.height ? (float)this.booleanValue : (float)rectangle.height);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            graphics2D.setTransform(affineTransform);
            render.paint(graphics2D);
            graphics2D.dispose();
        }
    }

    private void drawRect(RenderBarCode renderBarCode, int n) {
        this.drawOval(renderBarCode, n);
    }

    private void drawRoundRect(Render render, int n) {
        ImageInfo imageInfo;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getExportPages(render, offset, n);
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.I();
            this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
        }
        if ((imageInfo = this.deIndent.getImage(this.delete, true, render)) != null) {
            Image image = imageInfo.getImage();
            int n2 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
            int n3 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
            int n4 = Unit.convertUnitToPixel(imageInfo.getWidth(), 72);
            int n5 = Unit.convertUnitToPixel(imageInfo.getHeight(), 72);
            if (image != null) {
                this.createImage(render.getParent(), image, box.x + (float)n2, box.y + (float)n3, n4, n5);
            }
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private void drawString(RenderText renderText, Box box) throws IOException, DocumentException {
        Offset offset = (Offset)this.add.peek();
        DSField dSField = renderText.getParent();
        ExportTextStyle exportTextStyle = this.drawURLLink(dSField);
        Vector vector = renderText.getVLines();
        int[][] nArray = renderText.getEveryLinePos();
        if (vector != null && nArray != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = this.getBottomBorderStyle((String)vector.get(i));
                float f = ExportToPDF.convertUnitToPoint(nArray[i][0] + offset.dx) + (float)this.background;
                float f2 = ExportToPDF.convertUnitToPoint(nArray[i][1] + offset.dy) + (float)this.bgRect;
                ExportText exportText = new ExportText(string, f, f2, exportTextStyle);
                this.getExportPageRange(exportText, box);
            }
        }
    }

    private ExportTextStyle drawURLLink(DSField dSField) {
        int n;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.drawArc.get(dSTemplatible);
        if (v != null) {
            int n2;
            ExportTextStyle exportTextStyle = new ExportTextStyle((ExportTextStyle)v);
            Vector vector = exportTextStyle.getPropsChangedBy();
            if (vector != null && (n2 = vector.size()) > 0) {
                block6: for (int i = 0; i < n2; ++i) {
                    int n3 = (Integer)vector.get(i);
                    switch (n3) {
                        case 3: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
                            exportTextStyle.setUnderlineColor(color);
                            exportTextStyle.setStrikethroughColor(color);
                            exportTextStyle.setForeColor(color);
                            exportTextStyle.setFont(color, exportTextStyle.S, exportTextStyle.A);
                            continue block6;
                        }
                        case 4: {
                            FontInfo fontInfo = this.drawImage.getFontInfo(dSField);
                            String string = fontInfo.getFontName();
                            float f = this.getDSRow(fontInfo.getFontSize());
                            boolean bl = this.getBooleanPropertyByName(string);
                            int n4 = this.getContentY(dSField, string);
                            PDFFont pDFFont = new PDFFont(string, n4, f);
                            FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
                            int n5 = fontMetrics.getAscent();
                            exportTextStyle.setFont(exportTextStyle.C, pDFFont, bl);
                            exportTextStyle.setAscent(n5);
                            continue block6;
                        }
                        case 1: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
                            exportTextStyle.setStrikethrough(bl, 1, exportTextStyle.C);
                            continue block6;
                        }
                        case 2: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "Underline");
                            exportTextStyle.setUnderline(bl, 1, exportTextStyle.C);
                        }
                    }
                }
            }
            return exportTextStyle;
        }
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Underline");
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        FontInfo fontInfo = this.drawImage.getFontInfo(dSField);
        String string = fontInfo.getFontName();
        boolean bl3 = this.getBooleanPropertyByName(string);
        float f = this.getDSRow(fontInfo.getFontSize());
        int n6 = this.getContentY(dSField, string);
        PDFFont pDFFont = new PDFFont(string, n6, f);
        FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
        int n7 = fontMetrics.getAscent();
        int n8 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        ExportTextStyle exportTextStyle = new ExportTextStyle(color, pDFFont, bl3);
        exportTextStyle.setUnderline(bl2, 1, color);
        exportTextStyle.setStrikethrough(bl, 1, color);
        exportTextStyle.setAlignment(n8);
        exportTextStyle.setAscent(n7);
        if (n8 == 1 && !pDFFont.isJFont() && ((n = CCUtil.getIntPropertyByName(dSField, "position")) == 2 || dSField instanceof DSCTField)) {
            exportTextStyle.setRightPadding(ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "padding-right")));
        }
        this.dx(dSField, exportTextStyle, fontInfo);
        this.drawArc.put(dSTemplatible, exportTextStyle);
        return exportTextStyle;
    }

    private void dx(DSField dSField, ExportTextStyle exportTextStyle, FontInfo fontInfo) {
        if (CCUtil.isChangeByFormularProperty(dSField, "Foreground")) {
            exportTextStyle.addPropsChangedBy(3);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "StrikeOut")) {
            exportTextStyle.addPropsChangedBy(1);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Underline")) {
            exportTextStyle.addPropsChangedBy(2);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Italic") || CCUtil.isChangeByFormularProperty(dSField, "Bold") || !fontInfo.isCanBeCache()) {
            exportTextStyle.addPropsChangedBy(4);
        }
    }

    void dy(DSChartPlatform dSChartPlatform, int n) throws JRStopEngineException {
        Object object;
        Object object2;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSChartPlatform, offset, 0, n);
        Rectangle rectangle = dSChartPlatform.getBounds();
        if (!this.createFile) {
            object2 = new BufferedImage(rectangle.width, rectangle.height, 1);
            object = ((Image)object2).getGraphics();
            ((Graphics)object).setColor(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, rectangle.width, rectangle.height);
            dSChartPlatform.paint((Graphics)object);
            this.createImage(dSChartPlatform, (Image)object2, box.x, box.y, box.I, box.Z);
        } else {
            object2 = this.convertPixelToUnit.getGraphics(this.black, this.booleanValue);
            object = new AffineTransform();
            ((AffineTransform)object).scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            ((AffineTransform)object).translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            ((Graphics2D)object2).setTransform((AffineTransform)object);
            dSChartPlatform.paint((Graphics)object2);
            ((Graphics)object2).dispose();
        }
        if (dSChartPlatform.isHeatMapChart()) {
            this.add.push(new Offset(offset, dSChartPlatform.getX(), this.getY(dSChartPlatform, n)));
            object2 = dSChartPlatform.getChildren();
            int n2 = dSChartPlatform.getStartYPos();
            for (int i = 0; i < object2.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)object2.get(i);
                if (!(jRObjectResult instanceof DSChartCoordinatepaper)) continue;
                DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)jRObjectResult;
                this.add.push(new Offset((Offset)this.add.peek(), dSChartCoordinatepaper.getX(), this.getY(dSChartCoordinatepaper, n2)));
                Vector vector = dSChartCoordinatepaper.getChildren();
                int n3 = dSChartCoordinatepaper.getStartYPos();
                for (int j = 0; j < vector.size(); ++j) {
                    JRObjectResult jRObjectResult2 = (JRObjectResult)vector.get(j);
                    if (!(jRObjectResult2 instanceof DSChartHeatMapGroupRect)) continue;
                    DSChartHeatMapGroupRect dSChartHeatMapGroupRect = (DSChartHeatMapGroupRect)jRObjectResult2;
                    Box box2 = this.getFillPatternType(dSChartHeatMapGroupRect, (Offset)this.add.peek(), 0, n3);
                    this.getBaseFont(dSChartHeatMapGroupRect, box2);
                    this.elementAt(dSChartHeatMapGroupRect, n3);
                }
                this.add.pop();
            }
            this.add.pop();
        }
    }

    private void elementAt(DSContainer dSContainer, int n) throws JRStopEngineException {
        this.add.push(new Offset((Offset)this.add.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        Vector vector = dSContainer.getChildren();
        int n2 = dSContainer.getStartYPos();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSField)) continue;
            Offset offset = (Offset)this.add.peek();
            Box box = this.getFillPatternType((DSField)jRObjectResult, offset, 0, n2);
            this.getBaseFont(jRObjectResult, box);
        }
        this.add.pop();
    }

    void elements(DSTextObj dSTextObj, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ++n;
        Offset offset = (Offset)this.add.peek();
        float f = dSTextObj.getX();
        float f2 = this.getY(dSTextObj, n2);
        float f3 = dSTextObj.getWidth();
        float f4 = dSTextObj.getHeight();
        this.add.push(new Offset(offset, (int)f, (int)f2));
        f = ExportToPDF.convertUnitToPoint(f + (float)offset.dx + (float)n) + (float)this.background;
        f2 = ExportToPDF.convertUnitToPoint(f2 + (float)offset.dy) + (float)this.bgRect;
        f3 = ExportToPDF.convertUnitToPoint(f3);
        f4 = ExportToPDF.convertUnitToPoint(f4);
        int n3 = dSTextObj.getStartYPos();
        boolean bl = CCUtil.getBooleanPropertyByName(dSTextObj, "Shadow");
        Color color = CCUtil.getColorPropertyByName(dSTextObj, "Background");
        if (color != null) {
            if (bl) {
                this.convertPixelToUnit.fillRect(f, f2, f3 - (float)shadow, f4 - (float)shadow, color);
            } else {
                this.convertPixelToUnit.fillRect(f, f2, f3, f4, color);
            }
        }
        Vector vector = dSTextObj.getChildren();
        int n4 = -1;
        int n5 = n4 = vector.size();
        while (--n5 >= 0) {
            this.FB((JRObjectResult)vector.elementAt(n5), n, n3);
        }
        int[] nArray = new int[4];
        n5 = 0;
        int n6 = 4;
        while (--n6 >= 0) {
            nArray[n6] = CCUtil.getIntPropertyByName(dSTextObj, BORDERLINENAME[n6]);
            n5 += nArray[n6];
        }
        Box box = new Box(f, f2, f3, f4);
        if (n5 > 0) {
            float f5 = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSTextObj, "BorderWidth"));
            Color color2 = CCUtil.getColorPropertyByName(dSTextObj, "BorderColor");
            if (bl) {
                Color color3 = CCUtil.getColorPropertyByName(dSTextObj, "ShadowColor");
                this.getDbBinaryPropertyByName(box, color, color2, f5, nArray, bl, bl, bl, bl, color3, shadow);
            } else {
                this.getDbBinaryPropertyByName(box, color, color2, f5, nArray, false, false, false, false, null, shadow);
            }
        } else if (bl) {
            Color color4 = CCUtil.getColorPropertyByName(dSTextObj, "ShadowColor");
            this.getDbBinaryPropertyByName(box, color, null, 0.0f, null, bl, bl, bl, bl, color4, shadow);
        } else {
            this.getDbBinaryPropertyByName(box, color, null, 0.0f, null, false, false, false, false, null, shadow);
        }
        this.add.pop();
    }

    void endsWith(DSCrossTab dSCrossTab, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        int n3;
        this.getContentX(dSCrossTab, n, n2);
        ++n;
        Offset offset = new Offset((Offset)this.add.peek(), dSCrossTab.getX(), this.getY(dSCrossTab, n2));
        this.add.push(offset);
        boolean bl = CCUtil.getBooleanPropertyByName(dSCrossTab, "Hasborder");
        Color color = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
        int n4 = dSCrossTab.getStartYPos();
        GridBoxes gridBoxes = new GridBoxes();
        Vector vector = dSCrossTab.getGridInfos();
        int n5 = -1;
        int n6 = n5 = vector.size();
        while (--n6 >= 0) {
            Vector vector2 = (Vector)vector.elementAt(n6);
            n3 = vector2.size();
            while (--n3 >= 0) {
                CTGridInfo cTGridInfo = (CTGridInfo)vector2.elementAt(n3);
                if (n6 == 0 && n3 == 0 && cTGridInfo.getChildren().size() == 0) continue;
                float f = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.x + offset.dx);
                float f2 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.y - n4 + offset.dy);
                float f3 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.x + offset.dx + cTGridInfo.bgRect.width) - f;
                float f4 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.y - n4 + offset.dy + cTGridInfo.bgRect.height) - f2;
                if (!bl && cTGridInfo.fillColor == null) continue;
                gridBoxes.add(new GridBox(f + (float)this.background, f2 + (float)this.bgRect, f3, f4, cTGridInfo.fillColor));
            }
        }
        Enumeration enumeration = gridBoxes.I.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            n3 = n5 = vector3.size();
            while (--n3 >= 0) {
                GridBox gridBox = (GridBox)vector3.elementAt(n3);
                boolean bl2 = true;
                if (gridBox.D != null) {
                    this.convertPixelToUnit.fillRect(gridBox.I, (float)bl2 / 2.0f + gridBox.Z, gridBox.C, gridBox.B, gridBox.D);
                }
                if (!bl || color == null || color.equals(gridBox.D)) continue;
                this.convertPixelToUnit.drawRect(gridBox.I, (float)bl2 / 2.0f + gridBox.Z, gridBox.C, gridBox.B - (float)bl2 / 2.0f, (float)bl2, 1, color);
            }
        }
        Vector vector4 = dSCrossTab.getChildren();
        n3 = n5 = vector4.size();
        while (--n3 >= 0) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector4.elementAt(n3);
            this.delete((DSField)jRObjectResult, n, n4, null);
        }
        this.add.pop();
    }

    void equals(DSPicture dSPicture, int n, int n2) {
        Object object;
        Object object2;
        Offset offset = (Offset)this.add.peek();
        Box box = this.getFillPatternType(dSPicture, offset, ++n, n2);
        Box box2 = new Box(box.x, box.y, box.I, box.Z);
        int n3 = Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSPicture, "BorderWidth"), 72);
        boolean bl = CCUtil.getBooleanPropertyByName(dSPicture, "Shadow");
        int[] nArray = new int[4];
        int n4 = 0;
        int n5 = 4;
        while (--n5 >= 0) {
            nArray[n5] = CCUtil.getIntPropertyByName(dSPicture, BORDERLINENAME[n5]);
            n4 += nArray[n5];
        }
        DbBinary dbBinary = CCUtil.getDbBinaryPropertyByName(dSPicture, "ColumnName");
        if (!dbBinary.isNull()) {
            object2 = dbBinary.get();
            int n6 = (Integer)dSPicture.getPropertyByName("MediaType").getObject();
            if (object2 != null) {
                if (n6 == 2) {
                    if (object2[0] == 66 && object2[1] == 77) {
                        n6 = 1;
                    } else if (object2[0] == 71 && object2[1] == 73 && object2[2] == 70) {
                        n6 = 4;
                    } else if (object2[0] == -1 && object2[1] == -40 && object2[2] == -1 && object2[3] == -32) {
                        n6 = 0;
                    }
                }
                if (n6 == 4 || n6 == 0) {
                    object = PDFWriter.I.createImage((byte[])object2);
                    if (n4 > 0) {
                        box.x += (float)n3;
                        box.y += (float)n3;
                        box.I -= (float)(n3 << 1);
                        box.Z -= (float)(n3 << 1);
                    }
                    this.createImage(dSPicture, (Image)object, box.x, box.y, bl ? box.I - (float)shadow : box.I, bl ? box.Z - (float)shadow : box.Z);
                } else if (n6 == 1 && (object = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream((byte[])object2)))) != null) {
                    Image image = PDFWriter.I.createImage(((BitmapReader)object).getMemImgSrc());
                    ExportUtil.waitImage(image);
                    if (n4 > 0) {
                        box.x += (float)n3;
                        box.y += (float)n3;
                        box.I -= (float)(n3 << 1);
                        box.Z -= (float)(n3 << 1);
                    }
                    this.createImage(dSPicture, image, box.x, box.y, bl ? box.I - (float)shadow : box.I, bl ? box.Z - (float)shadow : box.Z);
                }
            }
        }
        if (n4 > 0) {
            object2 = CCUtil.getColorPropertyByName(dSPicture, "BorderColor");
            if (bl) {
                object = CCUtil.getColorPropertyByName(dSPicture, "ShadowColor");
                this.getDbBinaryPropertyByName(box2, null, (Color)object2, n3, nArray, bl, bl, bl, bl, (Color)object, shadow);
            } else {
                this.getDbBinaryPropertyByName(box2, null, (Color)object2, n3, nArray, false, false, false, false, null, shadow);
            }
        } else if (bl) {
            object2 = CCUtil.getColorPropertyByName(dSPicture, "ShadowColor");
            this.getDbBinaryPropertyByName(box2, null, null, 0.0f, null, bl, bl, bl, bl, (Color)object2, shadow);
        } else {
            this.getDbBinaryPropertyByName(box2, null, null, 0.0f, null, false, false, false, false, null, shadow);
        }
    }

    void error(JRVisiableResult jRVisiableResult, int n) throws IOException, DocumentException {
        block19: {
            Offset offset = (Offset)this.add.peek();
            Box box = this.getFillPatternType(jRVisiableResult, offset, n, 0);
            if (this.createSignature.getClippingArea()) {
                this.convertPixelToUnit.I();
                this.convertPixelToUnit.I(box.x, box.y, box.I, box.Z);
            }
            try {
                JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
                if (jRObjectRender == null) break block19;
                jRObjectRender.setProperty(jRVisiableResult);
                if (jRVisiableResult instanceof JHyperLinkRslt) {
                    Image image;
                    ImageResource imageResource = jRVisiableResult.getImgResourceByPropertyName("displayImage");
                    Image image2 = image = imageResource == null ? null : imageResource.getImage();
                    if (image == null) {
                        ExportTextStyle exportTextStyle = this.exists(jRVisiableResult);
                        exportTextStyle.setUnderline(true, 1, exportTextStyle.C);
                        Box box2 = new Box(box.x, box.y, box.I, box.Z);
                        Color color = (Color)jRVisiableResult.getPropertyByName("background").getObject();
                        if (color != null) {
                            this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, color);
                        }
                        List list = ((JHyperLinkRslt)jRVisiableResult).getLines();
                        for (int i = 0; i < list.size(); ++i) {
                            float f = box2.x + ExportToPDF.convertUnitToPoint(((JHyperlinkLineInfo)list.get(i)).getX());
                            float f2 = box2.y + ExportToPDF.convertUnitToPoint(((JHyperlinkLineInfo)list.get(i)).getY());
                            String string = ((JHyperlinkLineInfo)list.get(i)).getLine();
                            ExportText exportText = new ExportText(string, f, f2, exportTextStyle);
                            this.getEveryLinePos(exportText);
                        }
                    } else if (image != null) {
                        this.createImage(jRVisiableResult, image, box.x, box.y, box.I, box.Z);
                    }
                    try {
                        boolean bl = true;
                        if (jRVisiableResult.getPropertyByName("EnableHyperlinkOnPDF") != null) {
                            bl = CCUtil.getBooleanPropertyByName(jRVisiableResult, "EnableHyperlinkOnPDF");
                        }
                        if (bl) {
                            this.convertPixelToUnit.drawURLLink(((HtmlGeneratable)((Object)jRVisiableResult)).getHyperLinks()[0], box.x, box.y, box.I, box.Z);
                        }
                        break block19;
                    }
                    catch (Exception exception) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2401005, (Throwable)exception);
                        }
                        break block19;
                    }
                }
                Rectangle rectangle = jRVisiableResult.getBounds();
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
                if (!this.createFile) {
                    BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                    graphics.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics);
                    graphics.dispose();
                    this.createImage(jRVisiableResult, bufferedImage, box.x, box.y, box.I, box.Z);
                } else {
                    Graphics2D graphics2D = this.convertPixelToUnit.getGraphics(this.black > rectangle.width ? (float)this.black : (float)rectangle.width, this.booleanValue > rectangle.height ? (float)this.booleanValue : (float)rectangle.height);
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
                    affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
                    graphics2D.setTransform(affineTransform);
                    graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics2D);
                    graphics2D.dispose();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.createSignature.getClippingArea()) {
            this.convertPixelToUnit.Z();
        }
    }

    private ExportTextStyle exists(JRVisiableResult jRVisiableResult) {
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        Object v = this.drawArc.get(dSTemplatible);
        if (v != null) {
            return (ExportTextStyle)v;
        }
        int n = 0;
        FontInfo fontInfo = this.drawImage.getUdoFontInfo(jRVisiableResult);
        float f = this.getDSRow(fontInfo.getFontSize());
        String string = fontInfo.getFontName();
        boolean bl = false;
        if (((Boolean)jRVisiableResult.getPropertyByName("fontBold").getObject()).booleanValue()) {
            n |= 1;
        }
        if (((Boolean)jRVisiableResult.getPropertyByName("fontItalic").getObject()).booleanValue()) {
            n |= 2;
        }
        Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
        PDFFont pDFFont = new PDFFont(string, n, f);
        boolean bl2 = this.getBooleanPropertyByName(string);
        ExportTextStyle exportTextStyle = new ExportTextStyle(color, pDFFont, bl2);
        if (CCUtil.isChangeByFormularProperty(jRVisiableResult, "foreground") || CCUtil.isChangeByFormularProperty(jRVisiableResult, "fontItalic") || CCUtil.isChangeByFormularProperty(jRVisiableResult, "fontBold") || !fontInfo.isCanBeCache()) {
            return exportTextStyle;
        }
        this.drawArc.put(dSTemplatible, exportTextStyle);
        return exportTextStyle;
    }

    void fileUpdated(DSShape dSShape, int n) {
        DSShapeRegion dSShapeRegion = new DSShapeRegion(dSShape, false);
        Rectangle rectangle = dSShapeRegion.getShapeRegion();
        if (rectangle != null) {
            float f;
            Offset offset = (Offset)this.add.elementAt(0);
            float f2 = ExportToPDF.convertUnitToPoint(rectangle.x + offset.dx + n) + (float)this.background;
            float f3 = ExportToPDF.convertUnitToPoint(rectangle.y + offset.dy) + (float)this.bgRect;
            float f4 = ExportToPDF.convertUnitToPoint(rectangle.width);
            float f5 = ExportToPDF.convertUnitToPoint(rectangle.height);
            Color color = null;
            Color color2 = null;
            int n2 = 0;
            int n3 = dSShape.getObjectType();
            if (n3 != 22) {
                color = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
                color2 = CCUtil.getColorPropertyByName(dSShape, "Background");
                n2 = CCUtil.getIntPropertyByName(dSShape, "BorderStyle");
                f = Unit.convertUnitToPixel(CCUtil.getFloatPropertyByName(dSShape, "BorderWidth"), 72);
                if (f > 0.0f && n2 != 0 && color2 != null) {
                    f2 += (float)((int)f >> 1);
                    f3 += (float)((int)f >> 1);
                    f4 -= f;
                    f5 -= f;
                }
            } else {
                color = CCUtil.getColorPropertyByName(dSShape, "LineColor");
                f = ExportToPDF.convertUnitToPoint(CCUtil.getFloatPropertyByName(dSShape, "LineWidth"));
                n2 = CCUtil.getIntPropertyByName(dSShape, "LineStyle");
            }
            if (n3 == 22) {
                this.FILL_COLOR.addElement(new GeoBdrInfo(f2, f3, f4 + f2, f5 + f3, n3, color, f, n2, -1, -1, -1));
            } else if (n3 == 23) {
                if (color2 != null) {
                    this.convertPixelToUnit.fillRect(f2, f3, f4, f5, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.FILL_COLOR.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, -1, -1));
                }
            } else if (n3 == 20) {
                int n4 = Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSShape, "CornerFactor"));
                if (color2 != null) {
                    this.convertPixelToUnit.fillRoundRect(f2, f3, f4, f5, n4, n4, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.FILL_COLOR.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, n4, -1, -1));
                }
            } else if (n3 == 19) {
                if (color2 != null) {
                    this.convertPixelToUnit.fillOval(f2, f3, f4, f5, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.FILL_COLOR.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, -1, -1));
                }
            } else if (n3 == 18) {
                int n5 = CCUtil.getIntPropertyByName(dSShape, "StartAngle");
                int n6 = CCUtil.getIntPropertyByName(dSShape, "ArcAngle");
                if (color2 != null) {
                    this.convertPixelToUnit.fillArc(f2, f3, f4, f5, n5, n6, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.FILL_COLOR.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, n5, n6));
                }
            }
        }
    }

    private void fillArc(Stack stack, Color color) throws IOException, DocumentException, JRStopEngineException, OutOfSpaceException {
        if (this.createSignature.hasDrill() && this.SEDU.size() > 0 && this._commuList.length == 1) {
            this.WHITE = false;
            for (int i = 0; i < this.SEDU.size(); ++i) {
                this.checkOutputStream = 0;
                String string = (String)this.SEDU.elementAt(i);
                DSPage dSPage = (DSPage)this.HorizontalAlignment.get(string);
                this.fillRoundRect(dSPage);
                this.fillRect(string);
                this.convertPixelToUnit.open(new Dimension(this.black, this.booleanValue), color);
                this.DEF_COLOR(dSPage);
                this.convertPixelToUnit.dispose();
                stack.push(string);
                this.checkOutputStream = -1;
            }
        }
    }

    private void fillColor() throws NumberFormatException, OutOfSpaceException, IOException {
        if (this.createSignature.hasToc() && this._commuList.length == 1 && this.maxSizeofPDF == -1) {
            if (Float.valueOf(System.getProperty("java.version").substring(0, 3)).floatValue() > 1.29f) {
                DSTOC dSTOC = this._commu.getDSTOC();
                if (dSTOC != null) {
                    this.convertPixelToUnit.I(dSTOC.getTOCNode());
                }
            } else if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3401003);
            }
        }
        if (this.convertPixelToUnit != null) {
            this.convertPixelToUnit.dispose();
        }
    }

    String fillOval(String string) {
        return string.endsWith(".pdf") ? string : string + ".pdf";
    }

    String fillPattern(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ("\\/:*?\"<>|()".indexOf(c) == -1) continue;
            string = string.replace(c, '-');
        }
        return string;
    }

    private void fillRect(String string) throws IOException, DocumentException, OutOfSpaceException {
        this.convertTwoRes = new PdfExt();
        this.convertPixelToUnit = new PDFWriter(this.convertTwoRes, string, this.createSignature, this.drawRoundRect);
        this.convertPixelToUnit.setEncoding(this._commu.getEncoding());
    }

    static String I(String string, String string2) {
        String string3 = string.substring(0, string.length() - 4);
        string3 = string3 + string2 + ".pdf";
        return string3;
    }

    private void fillRoundRect(DSPage dSPage) {
        Rectangle rectangle = dSPage.getPageArea();
        this.append = dSPage.getPrintableArea();
        rectangle.width = rectangle.width <= LIMITEDBOUND ? rectangle.width : LIMITEDBOUND;
        rectangle.height = rectangle.height <= LIMITEDBOUND ? rectangle.height : LIMITEDBOUND;
        this.append.width = this.append.width <= LIMITEDBOUND ? this.append.width : LIMITEDBOUND;
        int n = this.append.height = this.append.height <= LIMITEDBOUND ? this.append.height : LIMITEDBOUND;
        if (!this.createSignature.noMargin()) {
            this.background = Unit.convertUnitToPixel(this.append.x, 72);
            this.bgRect = Unit.convertUnitToPixel(this.append.y, 72);
        }
        this.black = Unit.convertUnitToPixel(rectangle.width, 72);
        this.booleanValue = Unit.convertUnitToPixel(rectangle.height, 72);
    }

    private String floatValue(DSSection dSSection, String string) {
        String string2 = null;
        if (dSSection.getObjectType() == 515 || dSSection.getObjectType() == 518) {
            if (dSSection.groupLevel < this.convertUnitToPixel) {
                int n = -1;
                for (int i = 0; i < dSSection.groupLevel; ++i) {
                    n = this.convertUnitToPoint.indexOf(FILENAME_SEPARATE, n + 1);
                }
                this.convertUnitToPoint = n > 0 ? this.convertUnitToPoint.substring(0, n) : "";
            } else if (dSSection.groupLevel == this.convertUnitToPixel) {
                this.convertUnitToPoint = this.convertUnitToPoint.substring(0, this.convertUnitToPoint.lastIndexOf(FILENAME_SEPARATE));
            }
            this.convertUnitToPoint = string2 = dSSection.groupValue == null ? this.convertUnitToPoint + '_' + "NULL" : this.convertUnitToPoint + '_' + dSSection.groupValue.toString();
            this.convertUnitToPixel = dSSection.groupLevel;
            string2 = string + this.fillPattern(string2);
        }
        return string2;
    }

    private String get(DSField dSField) throws JRStopEngineException {
        int n;
        DSSection dSSection;
        String string = null;
        if (this.createSignature.hasDrill() && this.WHITE && (dSSection = dSField.getSection()) != null && ((n = dSSection.getObjectType()) == 515 || n == 518) && this.getAwtFont(dSField) && (string = this.floatValue(dSSection, this.BLACK.substring(0, this.BLACK.length() - 4))) != null) {
            string = this.fillOval(string);
            this.SEDU.addElement(string);
            DSPage dSPage = this._commu.getDrillDownPage(dSSection.getDataStream().getSubIndex(), this.checkFilePathExist, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), (Integer)dSSection.getTemplate().getPropertyByName("BranchIdx").getObject(), dSSection);
            this.HorizontalAlignment.put(string, dSPage);
        }
        return string;
    }

    private JRObjectResult getAscent(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult2.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    private boolean getAwtFont(DSField dSField) {
        boolean bl = false;
        if (dSField.getObjectType() == 258) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            bl = dbValue.getColDesc().isGroupable();
        }
        return bl;
    }

    private boolean getBackground() {
        this.clear = this._commu.getLocale().getLanguage().equals(new Locale("ar", "", "").getLanguage());
        return this.clear || this._commu.getLocale().getLanguage().equals(new Locale("iw", "", "").getLanguage());
    }

    private void getBaseFont(JRObjectResult jRObjectResult, Box box) throws JRStopEngineException {
        int n = this.F != null ? this.getClass(this.F.getCurrentCommunicator(), jRObjectResult) : -1;
        if (n != -1) {
            this.convertPixelToUnit.drawLocalLink(this.drawRect + n, box.x, box.y, box.I, box.Z);
        } else if (jRObjectResult.getLinkComm() == -1 && this.WHITE) {
            String string;
            String string2 = string = this.F == null ? null : this.F.getCurrentCommunicator().getLinkedInfo(jRObjectResult.getLinkCondition());
            if (string != null) {
                this.convertPixelToUnit.drawURLLink(string, box.x, box.y, box.I, box.Z);
            }
        }
    }

    private boolean getBooleanPropertyByName(String string) {
        boolean bl = false;
        if (this.ConvertProperties.length() > 0 && string.startsWith("*")) {
            bl = this.ConvertProperties.indexOf(string) > -1;
        }
        return bl;
    }

    private int getBottomBorderColor(JRObjectResult jRObjectResult, int n) {
        if (jRObjectResult instanceof DSParagraphText) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 6;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 10;
                }
                case 9: {
                    return 11;
                }
                case 10: {
                    return 4;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 13;
                }
                case 13: {
                    return 14;
                }
                case 14: {
                    return 15;
                }
                case 15: {
                    return 16;
                }
                case 16: {
                    return 17;
                }
            }
        }
        return 0;
    }

    private String getBottomBorderStyle(String string) {
        if (this.clearCacheRender) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            StringBuffer stringBuffer2 = new StringBuffer(n);
            String string2 = this.getColDesc(string);
            if (string2 != null) {
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    if (this.getBottomBorderWidth(c)) {
                        if (stringBuffer2.length() != 0) {
                            stringBuffer.append(stringBuffer2.reverse().toString());
                            stringBuffer2 = new StringBuffer();
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    char c2 = (char)this.close.get((int)c);
                    if (c2 != '\u0000') {
                        if (stringBuffer2.length() != 0) {
                            stringBuffer.append(stringBuffer2.reverse().toString());
                            stringBuffer2 = new StringBuffer();
                        }
                        stringBuffer.append(c2);
                        continue;
                    }
                    int n2 = Character.getType(c);
                    if (n2 != 20 && n2 != 22 && n2 != 24 && n2 != 14) {
                        stringBuffer2.append(c);
                        continue;
                    }
                    if (stringBuffer2.length() != 0) {
                        stringBuffer.append(stringBuffer2.reverse().toString());
                        stringBuffer2 = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2.reverse().toString());
                }
                string = stringBuffer.toString();
                if (this.clear) {
                    string = this.convertInchToPixel.shape(string);
                }
            }
        }
        return string;
    }

    boolean getBottomBorderWidth(char c) {
        return this.getBounds(c) || this.getChildren(c);
    }

    boolean getBounds(char c) {
        return c >= '\u0600' && c < '\u0700';
    }

    boolean getChildren(char c) {
        return c >= '\u0590' && c < '\u0600';
    }

    int getClass(Communicator communicator, JRObjectResult jRObjectResult) throws JRStopEngineException {
        int n;
        Communicator communicator2;
        int n2 = jRObjectResult.getLinkComm();
        int n3 = -1;
        if (n2 != -1 && (communicator2 = communicator.getLinkedComm(n2)) != null && (n = communicator2.getLinkedPage(jRObjectResult.getLinkCondition())) >= 0) {
            n3 = this.getClippingArea(communicator, n2, n);
        }
        return n3;
    }

    int getClippingArea(Communicator communicator, int n, int n2) {
        if (n != -1 || n2 != -1) {
            Communicator communicator2;
            CommNode commNode;
            TreeIterater treeIterater = new TreeIterater(new CommNode(this._commu), false);
            communicator = communicator.getLinkedComm(n);
            while ((commNode = (CommNode)treeIterater.next()) != null && (communicator2 = commNode.getComm()) != communicator) {
                n2 += communicator2.getPageNum();
            }
        }
        return n2;
    }

    String getColDesc(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length - 1;
        boolean bl = false;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = cArray[i];
            cArray[i] = cArray[n - i];
            cArray[n - i] = c;
            if (bl) continue;
            bl = this.getBottomBorderWidth(cArray[i]) || this.getBottomBorderWidth(cArray[n - i]);
        }
        return bl ? new String(cArray) : null;
    }

    private void getColorPropertyByName(Box box, Color color, int n) {
        if (color != null) {
            switch (n) {
                case 1: {
                    this.getComm(box, 2, color);
                    break;
                }
                case 5: {
                    this.getComm(box, 6, color);
                    break;
                }
                case 2: {
                    this.getContainerChildren(box, 6, 1, color);
                    break;
                }
                case 3: {
                    this.getContainerChildren(box, 6, 2, color);
                    break;
                }
                case 4: {
                    this.getContainerChildren(box, 6, 3, color);
                }
            }
        }
    }

    private void getComm(Box box, int n, Color color) {
        float f;
        float f2;
        float f3 = f2 = box.x;
        float f4 = f = box.y;
        float f5 = box.I + f2;
        float f6 = box.Z + f;
        this.convertPixelToUnit.drawLine(f2, f, f2, f, 1.0f, 1, color);
        if (box.I > box.Z) {
            while (f + (float)n < f6) {
                this.convertPixelToUnit.drawLine(f2 + (float)n, f4, f3, f + (float)n, 1.0f, 1, color);
                f2 += (float)n;
                f += (float)n;
            }
            f3 = f + (float)n - f6 + f3;
            while (f2 + (float)n < f5) {
                this.convertPixelToUnit.drawLine(f2 + (float)n, f4, f3, f6, 1.0f, 1, color);
                f2 += (float)n;
                f3 += (float)n;
            }
            for (f4 = f2 + (float)n - f5 + f4; f4 <= f6; f4 += (float)n) {
                this.convertPixelToUnit.drawLine(f5, f4, f3, f6, 1.0f, 1, color);
                f3 += (float)n;
            }
        } else {
            while (f2 + (float)n < f5) {
                this.convertPixelToUnit.drawLine(f2 + (float)n, f4, f3, f + (float)n, 1.0f, 1, color);
                f2 += (float)n;
                f += (float)n;
            }
            f4 = f2 + (float)n - f5 + f4;
            while (f + (float)n < f6) {
                this.convertPixelToUnit.drawLine(f5, f4, f3, f + (float)n, 1.0f, 1, color);
                f += (float)n;
                f4 += (float)n;
            }
            f3 = f + (float)n - f6 + f3;
            while (f3 <= f5) {
                this.convertPixelToUnit.drawLine(f5, f4, f3, f6, 1.0f, 1, color);
                f3 += (float)n;
                f4 += (float)n;
            }
        }
    }

    private void getContainerChildren(Box box, int n, int n2, Color color) {
        float f;
        float f2 = box.x;
        float f3 = box.x + box.I;
        float f4 = box.y;
        float f5 = box.y + box.Z;
        if ((n2 & 1) != 0) {
            for (f = f4 + (float)n - 1.0f; f < f5 + 1.0f; f += (float)n) {
                this.convertPixelToUnit.drawLine(f2, f, f3, f, 1.0f, 1, color);
            }
        }
        if ((n2 & 2) != 0) {
            for (f = f2 + (float)n - 1.0f; f < f3 + 1.0f; f += (float)n) {
                this.convertPixelToUnit.drawLine(f, f4, f, f5, 1.0f, 1, color);
            }
        }
    }

    private Box getContentX(JRVisiableResult jRVisiableResult, int n, int n2) {
        Offset offset = (Offset)this.add.peek();
        float f = ExportToPDF.convertUnitToPoint(jRVisiableResult.getX() + offset.dx + n) + (float)this.background;
        float f2 = ExportToPDF.convertUnitToPoint(this.getY(jRVisiableResult, n2) + offset.dy) + (float)this.bgRect;
        float f3 = ExportToPDF.convertUnitToPoint(jRVisiableResult.getWidth());
        float f4 = ExportToPDF.convertUnitToPoint(jRVisiableResult.getHeight());
        Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
        if (color != null) {
            this.convertPixelToUnit.fillRect(f, f2, f3, f4, color);
        }
        return new Box(f, f2, f3, f4);
    }

    private int getContentY(JRObjectResult jRObjectResult, String string) {
        int n = 0;
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Bold")) {
            n |= 1;
        }
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Italic")) {
            n |= 2;
        }
        return n;
    }

    private int getCurrentCommunicator(JRObjectResult jRObjectResult, String string) {
        int n = 0;
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "TitleBold")) {
            n |= 1;
        }
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "TitleItalic")) {
            n |= 2;
        }
        return n;
    }

    private float getDSRow(float f) {
        return ExportToPDF.convertUnitToPoint(f);
    }

    public boolean isVectorExportChart() {
        return this.createFile;
    }

    void getDSTOC(GeoBdrInfo geoBdrInfo) {
        switch (geoBdrInfo.I) {
            case 22: {
                this.convertPixelToUnit.drawLine(geoBdrInfo.F, geoBdrInfo.J, geoBdrInfo.S, geoBdrInfo.A, geoBdrInfo.E, geoBdrInfo.Z, geoBdrInfo.G);
                break;
            }
            case 23: {
                this.convertPixelToUnit.drawRect(geoBdrInfo.F, geoBdrInfo.J, geoBdrInfo.S, geoBdrInfo.A, geoBdrInfo.E, geoBdrInfo.Z, geoBdrInfo.G);
                break;
            }
            case 20: {
                this.convertPixelToUnit.drawRoundRect(geoBdrInfo.F, geoBdrInfo.J, geoBdrInfo.S, geoBdrInfo.A, geoBdrInfo.C, geoBdrInfo.C, geoBdrInfo.E, geoBdrInfo.Z, geoBdrInfo.G);
                break;
            }
            case 19: {
                this.convertPixelToUnit.drawOval(geoBdrInfo.F, geoBdrInfo.J, geoBdrInfo.S, geoBdrInfo.A, geoBdrInfo.E, geoBdrInfo.Z, geoBdrInfo.G);
                break;
            }
            case 18: {
                this.convertPixelToUnit.drawArc(geoBdrInfo.F, geoBdrInfo.J, geoBdrInfo.S, geoBdrInfo.A, geoBdrInfo.B, geoBdrInfo.D, geoBdrInfo.E, geoBdrInfo.Z, geoBdrInfo.G);
            }
        }
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult instanceof DSSection && this.checkOutputStream != -1) {
            int n2 = this.checkOutputStream;
            this.checkOutputStream += jRVisiableResult.getHeight();
            return n2;
        }
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (jRVisiableResult instanceof DSSubReport) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n5 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n5 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n4 = (n3 = n5) > 0 ? n3 : 0;
        }
        return n4;
    }

    void getDataStream() throws IOException, DocumentException {
        int n = Unit.convertInchToPixel(2.0, 72);
        int n2 = Unit.convertInchToPixel(3.0, 72);
        int n3 = Unit.convertInchToPixel(2.0, 72);
        for (int i = Unit.convertInchToPixel(1.0, 72); n < this.black || i < this.booleanValue; n += n2, i += n3) {
            int n4 = n - TW / 2;
            int n5 = n - BW1 / 2;
            int n6 = n - BW2 / 2;
            int n7 = i - BH / 2 - 5;
            int n8 = i;
            int n9 = i + BH / 2 + 5;
            this.convertPixelToUnit.setFont(FT, false);
            this.convertPixelToUnit.drawString("JReport Evaluation Copy", n4 + this.background, n7 + this.bgRect, DEF_COLOR);
            this.convertPixelToUnit.setFont(FB, false);
            this.convertPixelToUnit.drawString(CONTACT, n5 + this.background, n8 + this.bgRect, DEF_COLOR);
            this.convertPixelToUnit.drawString(PHONE, n6 + this.background, n9 + this.bgRect, DEF_COLOR);
        }
    }

    private void getDbBinaryPropertyByName(Box box, Color color, Color color2, float f, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color3, int n) {
        Color[] colorArray = null;
        float[] fArray2 = new float[4];
        if (color2 != null) {
            colorArray = new Color[4];
            colorArray[1] = colorArray[3] = color2;
            colorArray[2] = colorArray[3];
            colorArray[0] = colorArray[3];
        }
        fArray2[1] = fArray2[3] = f;
        fArray2[2] = fArray2[3];
        fArray2[0] = fArray2[3];
        this.getDefinitionName(box, color, colorArray, fArray2, nArray, bl, bl2, bl3, bl4, color3, n);
    }

    private void getDefinitionName(Box box, Color color, Color[] colorArray, float[] fArray2, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color2, int n) {
        float f = box.I;
        float f2 = box.Z;
        if (bl) {
            f2 -= (float)n;
        }
        if (bl2) {
            f -= (float)n;
        }
        if (colorArray != null) {
            if (fArray2[0] > 0.0f && colorArray[0] != null && !colorArray[0].equals(color) && nArray[0] != 0) {
                if (nArray[0] != 5) {
                    this.convertPixelToUnit.drawLine(box.x, fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] / 2.0f + box.y, fArray2[0], nArray[0], colorArray[0]);
                } else {
                    this.convertPixelToUnit.drawLine(box.x, fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] / 2.0f + box.y, fArray2[0], 1, colorArray[0]);
                    this.convertPixelToUnit.drawLine(box.x, fArray2[0] * 2.0f + fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] * 2.0f + fArray2[0] / 2.0f + box.y, fArray2[0], 1, colorArray[0]);
                }
            }
            if (fArray2[2] > 0.0f && colorArray[2] != null && !colorArray[2].equals(color) && nArray[2] != 0) {
                if (nArray[2] != 5) {
                    this.convertPixelToUnit.drawLine(box.x, f2 - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] / 2.0f + box.y, fArray2[2], nArray[2], colorArray[2]);
                } else {
                    this.convertPixelToUnit.drawLine(box.x, f2 - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] / 2.0f + box.y, fArray2[2], 1, colorArray[2]);
                    this.convertPixelToUnit.drawLine(box.x, f2 - fArray2[2] * 2.0f - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] * 2.0f - fArray2[2] / 2.0f + box.y, fArray2[2], 1, colorArray[2]);
                }
            }
            if (fArray2[1] > 0.0f && colorArray[1] != null && !colorArray[1].equals(color) && nArray[1] != 0) {
                if (nArray[1] != 5) {
                    this.convertPixelToUnit.drawLine(fArray2[1] / 2.0f + box.x, box.y, fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], nArray[1], colorArray[1]);
                } else {
                    this.convertPixelToUnit.drawLine(fArray2[1] / 2.0f + box.x, box.y, fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], 1, colorArray[1]);
                    this.convertPixelToUnit.drawLine(fArray2[1] * 2.0f + fArray2[1] / 2.0f + box.x, box.y, fArray2[1] * 2.0f + fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], 1, colorArray[1]);
                }
            }
            if (fArray2[3] > 0.0f && colorArray[3] != null && !colorArray[3].equals(color) && nArray[3] != 0) {
                if (nArray[3] != 5) {
                    this.convertPixelToUnit.drawLine(f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], nArray[3], colorArray[3]);
                } else {
                    this.convertPixelToUnit.drawLine(f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], 1, colorArray[3]);
                    this.convertPixelToUnit.drawLine(f - fArray2[3] * 2.0f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] * 2.0f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], 1, colorArray[3]);
                }
            }
        }
        if ((bl || bl2) && color2 != null && n > 0) {
            int n2;
            if (bl) {
                n2 = bl3 ? n : 0;
                this.convertPixelToUnit.fillRect((float)n2 + box.x, box.Z - (float)n + box.y, box.I - (float)n2, n, color2);
            }
            if (bl2) {
                n2 = bl4 ? n : 0;
                this.convertPixelToUnit.fillRect(box.I - (float)n + box.x, (float)n2 + box.y, n, box.Z - (float)n2, color2);
            }
        }
    }

    private void getDigitalIDFilePassword(ExportLine exportLine) {
        ExportLineStyle exportLineStyle = exportLine.D;
        if (exportLineStyle != null && exportLineStyle.C != null && exportLineStyle.I > 0.0f) {
            float f = exportLineStyle.I;
            if (exportLineStyle.Z == 5) {
                if (f < 3.0f) {
                    this.convertPixelToUnit.drawLine(exportLine.I, exportLine.Z, exportLine.C, exportLine.B, exportLineStyle.I, 1, exportLineStyle.C);
                } else if (exportLine.I == exportLine.C) {
                    this.convertPixelToUnit.drawLine(exportLine.I, exportLine.Z, exportLine.C, exportLine.B, f / 3.0f, 1, exportLineStyle.C);
                    this.convertPixelToUnit.drawLine(exportLine.I + f * 2.0f / 3.0f, exportLine.Z, exportLine.C + f * 2.0f / 3.0f, exportLine.B, f / 3.0f, 1, exportLineStyle.C);
                } else if (exportLine.Z == exportLine.B) {
                    this.convertPixelToUnit.drawLine(exportLine.I, exportLine.Z, exportLine.C, exportLine.B, f / 3.0f, 1, exportLineStyle.C);
                    this.convertPixelToUnit.drawLine(exportLine.I, exportLine.Z + f * 2.0f / 3.0f, exportLine.C, exportLine.B + f * 2.0f / 3.0f, f / 3.0f, 1, exportLineStyle.C);
                }
            } else if (exportLineStyle.Z != 0) {
                this.convertPixelToUnit.drawLine(exportLine.I, exportLine.Z, exportLine.C, exportLine.B, f, exportLineStyle.Z, exportLineStyle.C);
            }
        }
    }

    private void getDigitalIDFileStream(ExportRectangle exportRectangle) {
        Box box;
        if (exportRectangle.K != null && (box = new Box(exportRectangle.getInnerLocation())) != null) {
            FillPatternAdapter fillPatternAdapter = new FillPatternAdapter(exportRectangle.K);
            if (exportRectangle.K.getFillPatternType() == 2 && exportRectangle.K.getGradientStyle() == 1) {
                BufferedImage bufferedImage = new BufferedImage((int)box.I, (int)box.Z, 1);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, (int)box.I, (int)box.Z);
                fillPatternAdapter.fillPattern(graphics, new Rectangle(0, 0, (int)box.I, (int)box.Z));
                this.createImage(null, bufferedImage, box.x, box.y, box.I, box.Z);
            } else {
                int n = Unit.convertTwoRes((int)box.I, 72, Unit.getResolution());
                int n2 = Unit.convertTwoRes((int)box.Z, 72, Unit.getResolution());
                Graphics2D graphics2D = this.getDiskStore(box);
                fillPatternAdapter.fillPattern(graphics2D, new Rectangle(0, 0, n, n2));
                graphics2D.dispose();
            }
        }
    }

    private Graphics2D getDiskStore(Box box) {
        Graphics2D graphics2D = this.convertPixelToUnit.getGraphics((float)this.black > box.I ? (float)this.black : box.I, (float)this.booleanValue > box.Z ? (float)this.booleanValue : box.Z);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
        affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
        graphics2D.setTransform(affineTransform);
        return graphics2D;
    }

    private void getDrillDownPage(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if (box != null) {
            if (exportRectangle.K != null && exportRectangle.K.getFillPatternType() != FillPatternProperties.FILL_COLOR) {
                this.getDigitalIDFileStream(exportRectangle);
                return;
            }
            if (exportRectangle.J) {
                box.Z -= (float)exportRectangle.H;
            }
            if (exportRectangle.S) {
                box.I -= (float)exportRectangle.H;
            }
            if (exportRectangle.F != null) {
                if (exportRectangle.L == BorderProperties.BORDERJOINT_ROUND) {
                    float f = exportRectangle.M;
                    this.convertPixelToUnit.fillRoundRect(box.x, box.y, box.I, box.Z, f, f, exportRectangle.F);
                } else {
                    this.convertPixelToUnit.fillRect(box.x, box.y, box.I, box.Z, exportRectangle.F);
                }
            }
        }
    }

    private void getEmbFonts(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if (box != null) {
            if (exportRectangle.L == BorderProperties.BORDERJOINT_ROUND) {
                float f = exportRectangle.M;
                ExportLineStyle exportLineStyle = exportRectangle.B;
                if (exportLineStyle != null) {
                    this.convertPixelToUnit.drawRoundRect(box.x, box.y, box.I, box.Z, f, f, exportLineStyle.I, exportLineStyle.Z, exportLineStyle.C);
                }
            } else {
                ExportLine exportLine;
                if (exportRectangle.J) {
                    box.Z -= (float)exportRectangle.H;
                }
                if (exportRectangle.S) {
                    box.I -= (float)exportRectangle.H;
                }
                ExportLineStyle exportLineStyle = exportRectangle.Z;
                float f = 0.0f;
                if (exportLineStyle != null) {
                    exportLine = new ExportLine(box.x + f, box.y, box.x + f, box.y + box.Z);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.getDigitalIDFilePassword(exportLine);
                }
                if ((exportLineStyle = exportRectangle.B) != null) {
                    exportLine = new ExportLine(box.x, box.y + f, box.x + box.I, box.y + f);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.getDigitalIDFilePassword(exportLine);
                }
                if ((exportLineStyle = exportRectangle.C) != null) {
                    exportLine = new ExportLine(box.x + box.I - f, box.y, box.x + box.I - f, box.y + box.Z);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.getDigitalIDFilePassword(exportLine);
                }
                if ((exportLineStyle = exportRectangle.D) != null) {
                    exportLine = new ExportLine(box.x, box.y + box.Z - f, box.x + box.I, box.y + box.Z - f);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.getDigitalIDFilePassword(exportLine);
                }
                this.getEncoding(exportRectangle);
            }
        }
    }

    void getEncoding(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if ((exportRectangle.J || exportRectangle.S) && exportRectangle.G != null && exportRectangle.H > 0) {
            int n;
            if (exportRectangle.J) {
                n = exportRectangle.A ? exportRectangle.H : 0;
                this.convertPixelToUnit.fillRect((float)n + box.x, box.Z - (float)exportRectangle.H + box.y, box.I - (float)n, exportRectangle.H, exportRectangle.G);
            }
            if (exportRectangle.S) {
                n = exportRectangle.E ? exportRectangle.H : 0;
                this.convertPixelToUnit.fillRect(box.I - (float)exportRectangle.H + box.x, (float)n + box.y, exportRectangle.H, box.Z - (float)n, exportRectangle.G);
            }
        }
    }

    private void getEveryLinePos(ExportText exportText) throws IOException, DocumentException {
        String string = exportText.I;
        ExportTextStyle exportTextStyle = exportText.Z;
        PDFFont pDFFont = exportTextStyle.S;
        Font font = pDFFont.getAwtFont();
        if (exportTextStyle.C != null && string != null && string.length() != 0 && font != null) {
            float f;
            BaseFont baseFont = this.convertTwoRes.getBaseFont(string, pDFFont, exportTextStyle.A, pDFFont.isJFont());
            float f2 = font.getSize2D();
            this.convertPixelToUnit.setFont(pDFFont, exportTextStyle.A);
            FontMetrics fontMetrics = PDFWriter.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            float f3 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
            f3 = f3 > 1.0f ? f3 : 1.0f;
            float f4 = exportText.x;
            float f5 = exportText.y;
            if (pDFFont.isNeedChangeStyle()) {
                this.convertPixelToUnit.drawString(string, baseFont, pDFFont.getTrueStyle(), f2, f4, f5 + (float)n, exportTextStyle.C);
            } else {
                this.convertPixelToUnit.drawString(string, baseFont, f2, f4, f5 + (float)n, exportTextStyle.C);
            }
            if (exportTextStyle.I && exportTextStyle.B != null) {
                f = baseFont.getWidthPoint(string, f2);
                if (exportTextStyle.F == 5) {
                    this.convertPixelToUnit.drawLine(f4, f5 + (float)n + 1.0f, f4 + f, f5 + (float)n + 1.0f, f3, 1, exportTextStyle.B);
                    this.convertPixelToUnit.drawLine(f4, f5 + (float)n + 2.0f + f3 / 2.0f, f4 + f, f5 + (float)n + 2.0f + f3 / 2.0f, f3, 1, exportTextStyle.B);
                } else {
                    float f6 = f5 + (float)n + 2.0f + f3 / 2.0f;
                    this.convertPixelToUnit.drawLine(f4, f6, f4 + f, f6, f3, exportTextStyle.F, exportTextStyle.B);
                }
            }
            if (exportTextStyle.Z && exportTextStyle.D != null) {
                f = baseFont.getWidthPoint(string, f2);
                int n2 = fontMetrics.getHeight();
                if (exportTextStyle.J == 5) {
                    this.convertPixelToUnit.drawLine(f4, f5 + (float)(n2 / 2) + 1.0f, f4 + f, f5 + (float)(n2 / 2) + 1.0f, f3, 1, exportTextStyle.D);
                    this.convertPixelToUnit.drawLine(f4, f5 + (float)(n2 / 2) + 2.0f + f3 / 2.0f, f4 + f, f5 + (float)(n2 / 2) + 2.0f + f3 / 2.0f, f3, 1, exportTextStyle.D);
                } else {
                    this.convertPixelToUnit.drawLine(f4, f5 + (float)(n2 / 2) + 1.0f, f4 + f, f5 + (float)(n2 / 2) + 1.0f, f3, exportTextStyle.J, exportTextStyle.D);
                }
            }
        }
    }

    private void getExportPageRange(ExportText exportText, Box box) throws IOException, DocumentException {
        String string = exportText.I;
        ExportTextStyle exportTextStyle = exportText.Z;
        PDFFont pDFFont = exportTextStyle.S;
        Font font = pDFFont.getAwtFont();
        if (exportTextStyle.C != null && string != null && string.length() != 0 && font != null) {
            BaseFont baseFont = this.convertTwoRes.getBaseFont(string, pDFFont, exportTextStyle.A, pDFFont.isJFont());
            float f = font.getSize2D();
            this.convertPixelToUnit.setFont(pDFFont, exportTextStyle.A);
            int n = exportTextStyle.G;
            float f2 = exportText.x;
            float f3 = exportText.y;
            float f4 = -1.0f;
            int n2 = exportText.Z.E;
            if (n2 == 1 && !pDFFont.isJFont() && box != null) {
                f4 = baseFont.getWidthPoint(string, f);
                f2 = box.x + box.I - f4 - exportTextStyle.H;
            }
            if (pDFFont.isNeedChangeStyle()) {
                this.convertPixelToUnit.drawString(string, baseFont, pDFFont.getTrueStyle(), f, f2, f3 + (float)n, exportTextStyle.C);
            } else {
                this.convertPixelToUnit.drawString(string, baseFont, f, f2, f3 + (float)n, exportTextStyle.C);
            }
            if (exportTextStyle.I && exportTextStyle.B != null) {
                if (f4 == -1.0f) {
                    f4 = baseFont.getWidthPoint(string, f);
                }
                float f5 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
                float f6 = f5 = f5 > 1.0f ? f5 : 1.0f;
                if (exportTextStyle.F == 5) {
                    this.convertPixelToUnit.drawLine(f2, f3 + (float)n + 1.0f, f2 + f4, f3 + (float)n + 1.0f, f5, 1, exportTextStyle.B);
                    this.convertPixelToUnit.drawLine(f2, f3 + (float)n + 2.0f + f5 / 2.0f, f2 + f4, f3 + (float)n + 2.0f + f5 / 2.0f, f5, 1, exportTextStyle.B);
                } else {
                    float f7 = f3 + (float)n + 2.0f + f5 / 2.0f;
                    this.convertPixelToUnit.drawLine(f2, f7, f2 + f4, f7, f5, exportTextStyle.F, exportTextStyle.B);
                }
            }
            if (exportTextStyle.Z && exportTextStyle.D != null) {
                if (f4 == -1.0f) {
                    f4 = baseFont.getWidthPoint(string, f);
                }
                FontMetrics fontMetrics = PDFWriter.getFontMetrics(font);
                int n3 = fontMetrics.getHeight();
                float f8 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
                float f9 = f8 = f8 > 1.0f ? f8 : 1.0f;
                if (exportTextStyle.J == 5) {
                    this.convertPixelToUnit.drawLine(f2, f3 + (float)(n3 / 2) + 1.0f, f2 + f4, f3 + (float)(n3 / 2) + 1.0f, f8, 1, exportTextStyle.D);
                    this.convertPixelToUnit.drawLine(f2, f3 + (float)(n3 / 2) + 2.0f + f8 / 2.0f, f2 + f4, f3 + (float)(n3 / 2) + 2.0f + f8 / 2.0f, f8, 1, exportTextStyle.D);
                } else {
                    this.convertPixelToUnit.drawLine(f2, f3 + (float)(n3 / 2) + 1.0f, f2 + f4, f3 + (float)(n3 / 2) + 1.0f, f8, exportTextStyle.J, exportTextStyle.D);
                }
            }
        }
    }

    private Box getExportPages(Render render, Offset offset, int n) {
        Box box = new Box();
        box.x = ExportToPDF.convertUnitToPoint(render.getX() + offset.dx + n) + (float)this.background;
        box.y = ExportToPDF.convertUnitToPoint(render.getY() + offset.dy) + (float)this.bgRect;
        box.I = ExportToPDF.convertUnitToPoint(render.getWidth());
        box.Z = ExportToPDF.convertUnitToPoint(render.getHeight());
        return box;
    }

    private Box getFillPatternType(JRVisiableResult jRVisiableResult, Offset offset, int n, int n2) {
        int n3;
        int n4;
        if (jRVisiableResult.getParent() instanceof DSTableCell) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = jRVisiableResult.getX() + n;
            n3 = this.getY(jRVisiableResult, n2);
        }
        int n5 = jRVisiableResult.getWidth();
        int n6 = jRVisiableResult.getHeight();
        return this.getFloatPropertyByName(offset, n4, n3, n5, n6);
    }

    Box getFloatPropertyByName(Offset offset, int n, int n2, int n3, int n4) {
        float f = ExportToPDF.convertUnitToPoint(n + offset.dx) + (float)this.background;
        float f2 = ExportToPDF.convertUnitToPoint(n2 + offset.dy) + (float)this.bgRect;
        float f3 = ExportToPDF.convertUnitToPoint(n3);
        float f4 = ExportToPDF.convertUnitToPoint(n4);
        return new Box(f, f2, f3, f4);
    }

    public static float convertUnitToPoint(float f) {
        return Unit.convertUnitToPixel(f, 72);
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.drawRoundRect = exportAuxInfo;
    }
}

