/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jet.bean.PDFParameter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.pdf.PDFWriter;

public class PDFImporter {
    private PdfReader SEDU;
    private int addPage;
    private PDFParameter close;
    private ExportAuxInfo createFile;
    PdfCopy encrypt;
    Document error;

    public PDFImporter(PDFParameter pDFParameter, ExportAuxInfo exportAuxInfo) {
        this.close = pDFParameter;
        this.createFile = exportAuxInfo;
    }

    public boolean openSourcePDFFile(String string) throws ExpException {
        boolean bl = false;
        try {
            if (this.close.hasEncryption()) {
                String string2 = this.close.getOwnerPassword();
                if (string2 == null || string2.length() == 0) {
                    string2 = this.close.getUserPassword();
                }
                this.SEDU = new PdfReader(string, string2.getBytes());
            } else {
                this.SEDU = new PdfReader(string);
            }
            this.addPage = this.SEDU.getNumberOfPages();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401013, (Throwable)fileNotFoundException);
            }
            throw new ExpException(401021, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401014, (Throwable)iOException);
            }
            throw new ExpException(401021, (Throwable)iOException);
        }
        return bl;
    }

    public void closeSourcePDFFile() {
        this.SEDU = null;
    }

    public int getTotalPagesNumberOfSourcePDF() {
        return this.addPage;
    }

    void SEDU(String string) throws ExpException {
        this.error = new Document(this.SEDU.getPageSizeWithRotation(1));
        try {
            File file = this.createFile.getDiskStore().createFile(string);
            this.encrypt = new PdfCopy(this.error, (OutputStream)new FileOutputStream(file));
            PDFWriter.encrypt((PdfWriter)this.encrypt, this.close);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401015, (Throwable)fileNotFoundException);
            }
            throw new ExpException(401021, (Throwable)fileNotFoundException);
        }
        catch (DocumentException documentException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401016, (Throwable)documentException);
            }
            throw new ExpException(401021, (Throwable)documentException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, outOfSpaceException);
            }
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
            throw new ExpException(iOException);
        }
    }

    public void importPDFFile(String string, int n, int n2) throws ExpException {
        if (this.addPage < n2) {
            return;
        }
        this.SEDU(string);
        this.error.open();
        try {
            for (int i = n; i <= n2; ++i) {
                PdfImportedPage pdfImportedPage = this.encrypt.getImportedPage(this.SEDU, i);
                this.encrypt.addPage(pdfImportedPage);
            }
            this.createFile.getDiskStore().fileUpdated(new File(string));
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401017, (Throwable)exception);
            }
            throw new ExpException(401001, (Throwable)exception);
        }
        finally {
            Object var4_7 = null;
            this.error.close();
            this.error = null;
            this.encrypt = null;
        }
    }
}

