/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSFontValue;
import jet.util.nls.NLSFontValueImpl;
import jet.util.nls.NLSValue;

public class RSTNLSMap
implements INLSMap {
    private Hashtable SEDU = new Hashtable();

    private RSTNLSMap() {
    }

    @Override
    public NLSValue getTextValue(int n, String string) {
        return null;
    }

    @Override
    public NLSFontValue getFontValue(String string, double d) {
        return (NLSFontValue)this.SEDU.get(string + '@' + d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToRST(OutputStream outputStream) throws IOException {
        Vector<Object[]> vector = new Vector<Object[]>(this.SEDU.size());
        for (String string : this.SEDU.keySet()) {
            int n = string.lastIndexOf(64);
            vector.add(new Object[]{string.substring(0, n), Double.parseDouble(string.substring(n + 1))});
        }
        try {
            RSTNLSMap.saveToRST(this, outputStream, vector);
        }
        finally {
            vector.clear();
            vector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RSTNLSMap loadFromRST(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != -566226943) {
            throw new IOException("Invalid NLSMap storage");
        }
        n2 = dataInputStream.readInt();
        if (n2 <= 1) {
            throw new UnsupportedOperationException("The NLSMap was saved in developing version!! please rescreate it.");
        }
        if (n2 > 2) {
            throw new UnsupportedOperationException("The NLSMap was saved in higher version!");
        }
        dataInputStream.readInt();
        dataInputStream.readUTF();
        dataInputStream.readLong();
        dataInputStream.readInt();
        dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        dataInputStream.readInt();
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        RSTNLSMap rSTNLSMap = new RSTNLSMap();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            filterInputStream = new DataInputStream(gZIPInputStream);
            n2 = ((DataInputStream)filterInputStream).readInt();
            for (n = 0; n < n2; ++n) {
                RSTNLSMap.SEDU(rSTNLSMap, (DataInputStream)filterInputStream);
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    filterInputStream = null;
                }
            }
            if (gZIPInputStream != null) {
                try {
                    gZIPInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    gZIPInputStream = null;
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    byteArrayInputStream = null;
                }
            }
            byArray = null;
        }
        n = dataInputStream.readBoolean() ? 1 : 0;
        if (n != 0) {
            throw new UnsupportedOperationException("The NLSMap was saved in higher version!");
        }
        dataInputStream.readByte();
        return rSTNLSMap;
    }

    private static void SEDU(RSTNLSMap rSTNLSMap, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != 4) {
            throw new UnsupportedOperationException("The NLSMap was saved in higher version!");
        }
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        while (bl) {
            int n4 = dataInputStream.readInt();
            byte[] byArray = new byte[n4];
            dataInputStream.read(byArray);
            String string = new String(byArray, "Unicode");
            double d = dataInputStream.readDouble();
            dataInputStream.readByte();
            n4 = dataInputStream.readInt();
            byArray = new byte[n4];
            dataInputStream.read(byArray);
            String string2 = new String(byArray, "Unicode");
            double d2 = dataInputStream.readDouble();
            rSTNLSMap.SEDU.put(string + '@' + d, new NLSFontValueImpl(string2, d2, null));
            dataInputStream.readByte();
            bl = dataInputStream.readBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToRST(INLSMap iNLSMap, OutputStream outputStream, Collection collection) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(-566226943);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(1);
        Calendar calendar = Calendar.getInstance();
        dataOutputStream.writeUTF(calendar.getTimeZone().getID());
        dataOutputStream.writeLong(calendar.getTime().getTime());
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        dataOutputStream.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        GZIPOutputStream gZIPOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            filterOutputStream = new DataOutputStream(gZIPOutputStream);
            if (collection == null || collection.isEmpty()) {
                ((DataOutputStream)filterOutputStream).writeInt(0);
            } else {
                ((DataOutputStream)filterOutputStream).writeInt(1);
                RSTNLSMap.add(iNLSMap, (DataOutputStream)filterOutputStream, collection);
            }
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    filterOutputStream = null;
                }
            }
            if (gZIPOutputStream != null) {
                try {
                    gZIPOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    gZIPOutputStream = null;
                }
            }
        }
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.writeInt(0);
        byteArrayOutputStream.writeTo(dataOutputStream);
        dataOutputStream.flush();
        byteArrayOutputStream = null;
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeByte(-17);
        dataOutputStream.flush();
    }

    private static void add(INLSMap iNLSMap, DataOutputStream dataOutputStream, Collection collection) throws IOException {
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(0);
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            double d;
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            NLSFontValue nLSFontValue = iNLSMap.getFontValue(string, d = ((Double)objectArray[1]).doubleValue());
            if (nLSFontValue != null && !nLSFontValue.isEmptyValue()) {
                String string2 = nLSFontValue.getFontName();
                double d2 = nLSFontValue.getFontSize();
                dataOutputStream.writeBoolean(true);
                byte[] byArray = string.getBytes("Unicode");
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                dataOutputStream.writeDouble(d);
                dataOutputStream.writeByte(-32);
                byArray = string2.getBytes("Unicode");
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
                dataOutputStream.writeDouble(d2);
                dataOutputStream.writeByte(-31);
                if (n % 10 == 0) {
                    dataOutputStream.flush();
                }
            }
            ++n;
        }
        dataOutputStream.writeBoolean(false);
    }
}

