/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import jet.JRStopEngineException;
import jet.datastream.DSArea;
import jet.thinviewer.JReportAreaComponent;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.util.PropertySetable;
import util.RenderToolkit;

public class JReportArea
extends JReportAreaComponent
implements PainterConstants {
    private static final long serialVersionUID = 1L;
    Color SEDU = null;
    Color abs = null;
    int append;
    int arraycopy;
    int[] convertUnitToPixel;
    int[] countTokens;
    int drawBox;
    private DSArea drawLine = null;

    public JReportArea() {
        this.enableEvents(16L);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.drawLine = (DSArea)propertySetable;
        super.setProperty(this.drawLine);
        Rectangle rectangle = this.drawLine.getBounds();
        double d = 1.0;
        this.Z = this.drawLine.getShapeType();
        this.arraycopy = this.drawLine.getBoundaryStyle();
        int[][] nArray = this.drawLine.getPolygon();
        this.SEDU = this.drawLine.getFillColorValue();
        this.abs = this.drawLine.getBoundaryColorValue();
        this.append = Unit.convertUnitToPixel(this.drawLine.getBoundaryWidth(), this.resolution);
        if (this.Z == 3 || this.Z == 4) {
            int n;
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Area type is polygon or polygongroup: " + this.Z);
            }
            this.drawBox = nArray.length;
            this.convertUnitToPixel = new int[this.drawBox];
            this.countTokens = new int[this.drawBox];
            for (n = 0; n < this.drawBox; ++n) {
                this.convertUnitToPixel[n] = Unit.convertUnitToPixel(nArray[n][0], this.resolution);
                this.countTokens[n] = Unit.convertUnitToPixel(nArray[n][1], this.resolution);
            }
            d = (double)rectangle.width / (double)new Polygon((int[])this.convertUnitToPixel, (int[])this.countTokens, (int)this.drawBox).getBounds().width;
            if (Math.abs(d - 1.0) > 0.03) {
                for (n = 0; n < this.drawBox; ++n) {
                    this.convertUnitToPixel[n] = (int)Math.round((double)this.convertUnitToPixel[n] * d);
                    this.countTokens[n] = (int)Math.round((double)this.countTokens[n] * d);
                }
            }
            this.I = new Polygon(this.convertUnitToPixel, this.countTokens, this.drawBox);
        } else {
            int[] nArray2 = this.SEDU((String)this.drawLine.getPropertyByName("Coordinates").getObject());
            if (this.Z == 2) {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Area type is circle: " + this.Z);
                }
                d = (double)rectangle.width / (double)(nArray2[2] * 2);
                this.I = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Area type is others(rectangle or others): " + this.Z);
                }
                this.I = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (Math.abs(d - 1.0) > 0.03) {
            this.append = (int)Math.round((double)this.append * d);
        }
    }

    protected void fillBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.SEDU != null) {
            graphics.setColor(this.SEDU);
            if (this.Z == 3) {
                graphics.fillPolygon(this.convertUnitToPixel, this.countTokens, this.drawBox);
            } else if (this.Z == 4) {
                int[] nArray = null;
                int[] nArray2 = null;
                int n = 0;
                int[] nArray3 = this.drawLine.getGroupPoints();
                int[] nArray4 = this.drawLine.getCoordParts();
                int n2 = 0;
                for (int i = 0; i < nArray4.length; ++i) {
                    n2 = nArray4[i];
                    n = nArray3[i];
                    nArray = new int[n];
                    nArray2 = new int[n];
                    System.arraycopy(this.convertUnitToPixel, n2, nArray, 0, n);
                    System.arraycopy(this.countTokens, n2, nArray2, 0, n);
                    graphics.fillPolygon(nArray, nArray2, n);
                }
            } else if (this.Z == 2) {
                graphics.fillOval(0, 0, dimension.width, dimension.height);
            } else {
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.append > 0 && this.abs != null && this.arraycopy != 0) {
            if (this.Z == 3) {
                for (int i = 0; i < this.drawBox - 1; ++i) {
                    RenderToolkit.drawLine(graphics, this.convertUnitToPixel[i], this.countTokens[i], this.convertUnitToPixel[i + 1], this.countTokens[i + 1], this.abs, this.append, this.arraycopy);
                }
                RenderToolkit.drawLine(graphics, this.convertUnitToPixel[0], this.countTokens[0], this.convertUnitToPixel[this.drawBox - 1], this.countTokens[this.drawBox - 1], this.abs, this.append, this.arraycopy);
            } else if (this.Z == 4) {
                int n = 0;
                int[] nArray = this.drawLine.getGroupPoints();
                int[] nArray2 = this.drawLine.getCoordParts();
                for (int i = 0; i < nArray2.length; ++i) {
                    n = nArray[i];
                    int[] nArray3 = new int[n];
                    int[] nArray4 = new int[n];
                    System.arraycopy(this.convertUnitToPixel, nArray2[i], nArray3, 0, n);
                    System.arraycopy(this.countTokens, nArray2[i], nArray4, 0, n);
                    for (int j = 0; j < n - 1; ++j) {
                        RenderToolkit.drawLine(graphics, nArray3[j], nArray4[j], nArray3[j + 1], nArray4[j + 1], this.abs, this.append, this.arraycopy);
                    }
                }
            } else if (this.Z == 2) {
                RenderToolkit.drawOval(graphics, 0.0f, 0.0f, dimension.width, dimension.height, null, this.abs, this.append, this.arraycopy);
            } else {
                RenderToolkit.drawBox(graphics, 0.0f, 0.0f, dimension.width - 1, dimension.height - 1, null, this.abs, this.append, this.arraycopy);
            }
        }
        super.paint(graphics);
    }

    int[] SEDU(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, new String(","));
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                nArray[i] = Unit.convertUnitToPixel(new Integer(string2.trim()), this.resolution);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ViewerTools.I(2401501, numberFormatException);
        }
        return nArray;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        JReportViewer jReportViewer;
        if (mouseEvent.getID() == 500) {
            JReportViewer jReportViewer2;
            if (this.abs()) {
                JReportViewer jReportViewer3;
                if (mouseEvent.getClickCount() == 1 && (jReportViewer3 = this.append()).C(this.drawLine) && !(jReportViewer3 instanceof JReportDrillDownViewer)) {
                    try {
                        jReportViewer3.Z(this.drawLine);
                    }
                    catch (JRStopEngineException jRStopEngineException) {
                        ViewerTools.I(131600, jRStopEngineException);
                    }
                }
            } else if (!mouseEvent.isMetaDown() && (jReportViewer2 = this.append()).C(this.drawLine)) {
                try {
                    jReportViewer2.Z(this.drawLine);
                }
                catch (JRStopEngineException jRStopEngineException) {
                    ViewerTools.I(131600, jRStopEngineException);
                }
            }
        } else if (mouseEvent.getID() == 504 && !((jReportViewer = this.append()) instanceof JReportDrillDownViewer)) {
            if (jReportViewer.C(this.drawLine)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private boolean abs() {
        boolean bl = false;
        JReportViewer jReportViewer = this.append();
        bl = jReportViewer.C(this.drawLine);
        return bl;
    }

    private JReportViewer append() {
        Container container = this.getParent();
        while (!(container instanceof JReportViewer)) {
            container = container.getParent();
        }
        return (JReportViewer)container;
    }
}

