/*
 * Decompiled with CFR 0.152.
 */
package jet.util.loader;

import com.jinfonet.resstore.loader.CachedObject;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jet.util.JRInterruptedException;
import jet.util.MemoryCounter;
import jet.util.loader.AbsCacherKey;

public abstract class AbsCacherValue<K, V, T extends AbsCacherKey<K>>
implements CachedObject<K, V> {
    protected T keyInst;
    protected V valueObj = null;
    private long SEDU = 0L;
    private boolean doEstimateLength = false;
    private long estimate = 0L;
    private boolean estimateLength = false;
    private ReadWriteLock fireValueIsCached;

    public AbsCacherValue(T t) {
        this.keyInst = t;
        this.fireValueIsCached = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateContent() throws Throwable {
        try {
            this.fireValueIsCached.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            if (this.valueObj == null) {
                this.valueObj = this.foreceLoadValue();
                this.SEDU = this.estimateLength();
            } else if (this.isNeedReload()) {
                this.fireValueIsCached(false);
                this.valueObj = this.foreceLoadValue();
                this.SEDU = this.estimateLength();
            } else {
                this.updateValueNeedNotReload();
            }
        }
        finally {
            this.fireValueIsCached.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final V getValueObject() {
        try {
            this.fireValueIsCached.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            V v = this.valueObj;
            return v;
        }
        finally {
            this.fireValueIsCached.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getValueLength() {
        try {
            this.fireValueIsCached.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            long l = this.SEDU;
            return l;
        }
        finally {
            this.fireValueIsCached.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setIsCached(boolean bl, long l) {
        try {
            this.fireValueIsCached.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            throw new JRInterruptedException();
        }
        try {
            this.estimate = bl ? l : 0L;
            this.estimateLength = bl;
            this.fireValueIsCached(bl);
        }
        finally {
            this.fireValueIsCached.writeLock().unlock();
        }
    }

    protected final long getLengthInCacher() {
        return this.estimate;
    }

    protected final void resetItemLocked(boolean bl) {
        this.doEstimateLength = bl;
    }

    protected final boolean isCahed() {
        return this.estimateLength;
    }

    protected final boolean isItemLocked() {
        return this.doEstimateLength;
    }

    protected long estimateLength() {
        return this.doEstimateLength(this.valueObj);
    }

    protected final long doEstimateLength(Object object) {
        if (object == null) {
            return 0L;
        }
        return new MemoryCounter().estimate(object);
    }

    protected boolean sureCanPutInfoCacher() {
        return true;
    }

    protected abstract void updateValueNeedNotReload();

    protected abstract boolean isNeedReload();

    protected abstract V foreceLoadValue() throws Throwable;

    protected abstract void fireValueIsCached(boolean var1);

    public K key() {
        return ((AbsCacherKey)this.keyInst).getOuterUsedID();
    }

    public V value() {
        return this.getValueObject();
    }

    @Override
    public boolean isLocked() {
        return this.isItemLocked();
    }

    @Override
    public long length() {
        return this.getValueLength();
    }
}

