
import jet.api.*;
import java.io.*;
import java.awt.*;
import jet.jetc.*;
import jet.universe.exception.*;

/**
 * This class creates 2 reports using 2 concurrent threads for 2 different users.
 * It requires the SampleReports.cat resources.
 * 
 * Usage: TestMultiUserDesign <path> <catalog> [logfile]
 */
public class TestMultiUserDesign
{	
	MultiUserDesigner desg = null;  // Instance of the Designer object used by this class.
	Boolean ready = false;      // True - designerReady is ready to use.
	static String errorMsg = null;     // Holds error message related to a failure that is visible to main().	
	
	public static String getErrorMsg()
	{
	       return TestMultiUserDesign.errorMsg;
	}
	
	public TestMultiUserDesign(String path, String cat)
	{
		try
		{
			DesignerUserInfo userInfo=new DesignerUserInfo("Jinfonet", "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
			desg = new MultiUserDesigner(path, cat,userInfo);
		}
		catch (ReadFailureException rf)
		{
			rf.printStackTrace();
		}
		catch (UniverseFileException uf)
		{
			uf.printStackTrace();
		}
	}

	public void setLog(String log)
	{
		try
		{
			desg.setLog(new FileOutputStream(log), "8859_1");
		}
		catch (FileNotFoundException fn)
		{
		}
	}

	
	// parameter tokens
    private final static String pathArg = "-path=";
    private final static String catArg = "-catalog=";
    private final static String rptArg = "-report=";
    private final static String logArg = "-log=";
	
	private final static void showUsage() {
        System.out.println( "TestDesignInvoice - programattically define an invoice report, registered into a report catalog.");
        System.out.println( "Usage:  java TestDesignInvoice <-options>");
        System.out.println("\nwhere options include:");
        System.out.println("    " + pathArg +   "<path to catalog>  indicates the full path name to the report catalog directory");
        System.out.println("    " + catArg +    "<catalog name>  indicates the name of the report catalog");
        System.out.println("    " + rptArg +    "<report name>  indicates the name of the report to create");
        System.out.println("    " + logArg +    "<log file path and name>   indicates to log to this file, defined by full path name");
        System.out.println("\nExample to create and define a report from the command line:");
        System.out.println("java TestDesignInvoice -path=C:\\JReport\\Designer\\Demo\\Reports\\TutorialReports  -catalog=JinfonetGourmetJava.cat  -report=TestInvoice.cls -log=C:\\JReport\\Designer\\logs\\designer.log");
    }
	
	
	public static void main(String arg[])
	{
		if(true)
		{
			TestMultiUserDesign test = new TestMultiUserDesign("c:\\JReport\\Designer\\Demo\\Reports\\TutorialReports","JinfonetGourmetJava.cat");			
			if(arg.length ==3)
			{
				test.setLog(arg[2]);
			}

			DesignerReport DESInvoice = new DesignerReport("Myinvoice", test.desg, "designer1");
			DesignerReport DESregionsalesgraph = new DesignerReport("Myregionsalesgraph", test.desg, "designer3");	
			DESInvoice.start();			
			DESregionsalesgraph.start();
			
			try
			{
				DESInvoice.join();
				DESregionsalesgraph.join();
			}catch (InterruptedException t)
			{
				t.printStackTrace();
			}			

			test.desg.exit();
			System.exit(0);
		}
	
	}
}

class DesignerReport extends Thread
{
	int Case;
	String name, User;
	MultiUserDesigner desg;

	public DesignerReport(String name, MultiUserDesigner desg, String User)
	{
		try
		{
			if(name.compareToIgnoreCase("Myinvoice") == 0)
			{
				Case = 10001;
				this.name = name;
				this.desg = desg;
				this.User = User;

			}		
			else if(name.compareToIgnoreCase("Myregionsalesgraph") == 0)
			{
				Case = 10003;
				this.name = name;
				this.desg = desg;
				this.User = User;

			}
		
			else
			{
				throw new Exception("Not found the method for " + name);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public void run()
	{
		switch(Case)
		{
		case 10001:	createMyinvoice();
			break;		
		case 10003:	createMyregionsalesgraph();
			break;
		
		}
	}

	public boolean createMyinvoice()
	{		
		
		String reportset;     // Holds internal name of the created report set. Used while defining the report set.
        String report;        // Holds internal name of the created report. Used while defining the report.
        String dataset;       // Holds internal name of the created dataset. Used while registering it with the report.
        String groupCust,groupOrd;         // Holds internal name of a group that is inserted into report. Used while defining the group.
        String header;        // Holds internal name of a header that is inserted into the report. Used while defining the header.
        String detail;        // Holds internal name of a page detail.  Used while defining the detail.
        String footer;        // Holds internal name of a footer.  Used while defining the footer.
        String handle;        // Holds internal name of a variety of inserted report elements.  Used while setting attributes for each.
        String handles[];     // Array of report element names returned from getHandles() call. 
        String banded;        // Holds the internal name of the banded object
        String reportbody;    // Holds the internal name of the report body that the banded object goes into 
        Boolean fSuccess = false;  //  true - the goal of creating a report is accomplished 
        
        System.out.println("---start create -----");
        
        /**
         *  Section 1 - 
         *    This section uses a style of rigorous error handling - check the result of each method call, and handle each specific error.
         *
         * Approach:
         *  When something fails during a method call, the code will know it immediately and will know exactly the case.
         *  
         *  Called methods report failure in two ways - throw an exception, or return a value that indicates error.
         *  This section watches for failures in two ways - by having calls within a try/catch loop for noticing thrown exceptions
         *  and by checking the returned values for the particular value that indicates error.
         *  
         *  Code is more complicated.
         *
         *  Appropriate when doing a sequence of operations that depend on the one before, with the full sequence needing to be done.
         */
        try{
        	
	        // Remove any existing page report (.cls) with the same name to avoid an error when creating one.
	        // This generates an entry in the error log reporting that "name" does not exist, when it doesn't.
	        desg.deleteReportFile(name);
	
	        // 1. Create a page report.  use the name from the -name parameter. 
	        reportset = desg.createReportSet(name);
	        if (reportset == null) {
	        	TestMultiUserDesign.errorMsg = "Failure createReportSet(): " + desg.getError();
	            return false;
	        }   
	                    
	        // 2. Register the existing query "WorldWideSales" to this report set.
	        //    The existing query in the catalog is the third parameter.
	        //    The corresponding new data source is the second parameter.
	        //    The name for this registered dataset is fourth parameter.
	        //    The type of dataset is in the fifth parameter.
	        dataset = desg.addDataset(reportset, "Data Source 1", "WorldWideSales","dsWorldWideSales", "",Designer.DATASET_TYPE_QUERY);
	        if (dataset == null) {
	        	TestMultiUserDesign.errorMsg = "Failure addDataSet(): " + desg.getError();
	            return false;
	        }
	        
	        // 3. Create the named report tab within the Page Report
	        //    For this example program, the name of the added report tab is hard coded.
	        report = desg.addReport(reportset, "Myinvoice");
	        if (report == null) {
	        	TestMultiUserDesign.errorMsg = "Failure addReport(): " + desg.getError();
	            return false;
	        }
	        
	        reportbody = desg.getHandles(report, Designer.REPORTBODY, -1)[0];
	        
	        // 4. Insert a PagePanel into the Invoice tab
	        String page = desg.insertPage(report);
	         
	        desg.insertPageStartEnd(page, reportbody, 0, 0);
	        desg.set(page, "Width", 8.0f);
	        desg.set(page, "Height", 9.2f);
	        
	        String[] pageFooter = desg.getHandles(report, Designer.PAGEFOOTER, -1);
	        desg.set(pageFooter[0], "Height", 0.2f);
	        
	        String[] pageHeader = desg.getHandles(report,Designer.PAGEHEADER, -1);
	        desg.set(pageHeader[0], "Height", 0.2f);
	        //gets a report body.
	        reportbody = desg.getHandles(report, Designer.REPORTBODY, -1)[0];
			
	        // 5. Insert the banded object for the invoice report             
            banded = desg.insertBandedObject(reportbody, true, true, true);
            desg.set(banded, "Width", 8.0f);
            // designer.set(banded, "Height", 9.2f);

            String[] sections = desg.getSections(banded);

            //to set width of all sections in banded object 
            for ( int i = 0; i< sections.length;i++)
            {
            	desg.set(sections[i], "Width", 8.0f);
            }

            handles = desg.getHandles(banded, Designer.BANDEDOBJECT_HEADER);
            System.out.println("banded object header handle: " + handles[0]);
            desg.set(handles[0], "Invisible", true);
             
        
            // 6. bind the dataset to the report body and set banded object to inherit the dataset
            // it is an container object that must have a data set bound to it.
            if( ! desg.bindDataSet(reportbody, "dsWorldWideSales") ) {
            	TestMultiUserDesign.errorMsg = "Failure bindDataSet(): " + desg.getError();
                return false;
            }
            desg.set(banded, "dataInherit", true);           
	        
	        // 7. ================draw the report
	        // insert group panel 1 on Customer ID - we will not show anything in this group
	        // use insertSectionGroup() since V8 to add group to banded object.
	        handles = desg.getHandles(banded, Designer.PAGE);
	        System.out.println("page within banded: " + banded + "  " + handles[0]);
	
	        GroupInfo ginfo =new GroupInfo( "Customers_Customer ID", GroupInfo.DESCENDING );
	        groupCust = desg.insertSectionGroup( handles[0], ginfo );
	
	        if (groupCust == null) {
	        	TestMultiUserDesign.errorMsg = "Failure insert GroupPanel1(): " + desg.getError();
	            return false;
	        }
	
	        // After inserting a group, the details of the report are moved to this group, and a group header/footer is created.
	        // Remove the group header and footer.
	        handles = desg.getHandles(groupCust, Designer.GROUPHEADER);
	        System.out.println("group header 1 handle: " + handles[0]);
	        desg.set(handles[0], "Width", 7.5f);
	        desg.set(handles[0], "Height", 0.0f);
	        desg.set(handles[0], "Invisible", true);
	        // Hide the special group field that is added automatically with the group
	        handles = desg.getHandles(handles[0], Designer.GROUPNAME);
	        desg.set(handles[0], "Invisible", true);
	        // showHandles("after set Group Header invisible ");
	
	        handles = desg.getHandles(groupCust, Designer.GROUPFOOTER);
	        desg.set(handles[0], "Width", 7.5f);
	        desg.set(handles[0], "Height", 0.0f);
	        desg.set(handles[0], "Invisible", true);
	        
	        ginfo = new GroupInfo( "Orders_Order ID", GroupInfo.DESCENDING );
	        groupOrd = desg.insertSectionGroup( groupCust, ginfo );
	        handles = desg.getHandles(groupOrd, Designer.GROUPHEADER);
	        System.out.println("group header 2 handle: " + handles[0]);
	
	        if (groupOrd == null) {
	        	TestMultiUserDesign.errorMsg = "Failure insert GroupPanel2(): " + desg.getError();
	            return false;
	        }
	        // After inserting a group into a panel the detail panel of the parent group are moved into new group
	        //showHandles("after insert Group Panel2");
	
	        // style the header
	        header = desg.getHandles(groupOrd,Designer.GROUPHEADER)[0];
	        if (! desg.set(header, "Label", "GroupHeaderPanel(OrderID)") ) {
	        	TestMultiUserDesign.errorMsg = "Failure set Label GroupHeaderPanel: " + desg.getError();
	            return false;
	        }
	        desg.set(header, "Width", 7.5f);
	        desg.set(header, "Height", 1.75f);
	    }
	    catch ( Exception e ) {
	        e.printStackTrace();
	        TestMultiUserDesign.errorMsg = "Exception while registering report set and report, and while defining top section of report.";
	        return fSuccess;
	    }

        /**
         *  Section 2 - 
         *    This section uses a style of casual error handling - don't check the result of each method call.
         *
         *  Error handling approach:
         *   Don't check the result of each method call.
         *   When the insert() call fails, the use of the null returned handle will cause the following set() call to throw an exception.
         *   This will percolate up the stack and be caught by main(), where main logic can back out the edits made to the report.
         *   If an insert() succeeds but a set() fails, the set() method returns a boolean which is ignored by this style error handling.  
         *   If the set() method fails for an attibute, that attribute will not be set.  This causes the report design to look wrong.
         *   It should be acceptable that the report may look bad after running this style error handling code.
         *
         *   This style makes the code simple to read.
         *
         *   This style is appropriate where exact details of the failure is not important, and where
         *   failures in a set command only cause acceptable cosmetic problems.
         */
        System.out.println("group header handle in second section: " + header);
        
        //1. Draw GroupHeader 1
        handle = desg.insert(header, Designer.LABEL, "Label1");
        desg.set(handle, "Width", 1.74f);
        desg.set(handle, "Height", 0.35f);
        desg.set(handle, "Text", "Invoice");
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Foreground", new Color(0x900000));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.31f);

        handle = desg.insert(header, Designer.LABEL, "Label2");
        desg.set(handle, "Width", 0.68f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "Text", "Date:");
        desg.set(handle, "Y", 0.36f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Foreground", new Color(0x00007f));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label3");
        desg.set(handle, "Width", 0.86f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "Text", "Invoice No:");
        desg.set(handle, "Y", 0.55f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Foreground", new Color(0x00007f));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.PARAMETER, "Parameter1", "PStartDate");
        desg.set(handle, "Width", 1.14f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "Format", "MM/dd/yyyy");
        desg.set(handle, "X", 0.68f);
        desg.set(handle, "Y", 0.36f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField1", "Orders_Order ID");
        desg.set(handle, "Width", 0.64f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.93f);
        desg.set(handle, "Y", 0.55f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "#####");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.IMAGE, "Image1");
        desg.set(handle, "Width", 0.93f);
        desg.set(handle, "Height", 0.81f);
        desg.set(handle, "X", 3.80f);
        desg.set(handle, "Y", 0.05f);
        desg.set(handle, "AutoSize", true);
        desg.set(handle, "PictureName", "Coffee.gif");

        handle = desg.insert(header, Designer.LABEL, "Label4");
        desg.set(handle, "Width", 0.576f);
        desg.set(handle, "Height", 0.21f);
        desg.set(handle, "Text", "Bill to:");
        desg.set(handle, "Y", 0.94f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField2", "Customer Name");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.74f);
        desg.set(handle, "Y", 0.93f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBFieldAdd1", "Address1");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.74f);
        desg.set(handle, "Y", 1.11f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.FORMULA, "formula2", "CustomerCityStateZip");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.74f);
        desg.set(handle, "Y", 1.29f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField3", "Customers_Country");
        desg.set(handle, "Width", 1.30f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.74f);
        desg.set(handle, "Y", 1.47f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label5");
        desg.set(handle, "Width", 0.646f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "Text", "Ship to:");
        desg.set(handle, "X", 2.80);
        desg.set(handle, "Y", 0.93f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField4", "Customer Name");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 3.49f);
        desg.set(handle, "Y", 0.93f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBFieldAdd2", "Address1");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 3.49f);
        desg.set(handle, "Y", 1.11f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.FORMULA, "formula4", "CustomerCityStateZip");
        desg.set(handle, "Width", 1.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 3.49f);
        desg.set(handle, "Y", 1.29f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField5", "Customers_Country");
        desg.set(handle, "Width", 1.30f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 3.49f);
        desg.set(handle, "Y", 1.47f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        
        handle = desg.insert(report, Designer.LINE, "Line1");
        desg.setReference(handle, "TopAttach", header);
        desg.setReference(handle, "BottomAttach", header);
        desg.set(handle, "TopAttachPosX", 0f);
        desg.set(handle, "TopAttachPosY", 0.9f);
        desg.set(handle, "BottomAttachPosX", 2.2f);
        desg.set(handle, "BottomAttachPosY", 0.9f);
        desg.set(handle, "LineColor", Color.blue);
        desg.set(handle, "LineWidth", 0.01f);

        handle = desg.insert(report, Designer.LINE, "Line2");
        desg.setReference(handle, "TopAttach", header);
        desg.setReference(handle, "BottomAttach", header);
        desg.set(handle, "TopAttachPosX", 2.8f);
        desg.set(handle, "TopAttachPosY", 0.9f);
        desg.set(handle, "BottomAttachPosX", 4.8f);
        desg.set(handle, "BottomAttachPosY", 0.9f);
        desg.set(handle, "LineColor", new Color(0x00007f));
        desg.set(handle, "LineWidth", 0.01f);

		try{
		        header = desg.insertSectionPanel(groupOrd, header,Designer.GROUPHEADER, false);
		        desg.set(header, "Label", "GroupHeaderPanel(OrderID)");
		        desg.set(header, "Height", 0.86f);
		        desg.set(header, "Width", 7.5f);
		}
		catch(Exception e )
		{
			e.printStackTrace();
		}


        //2. Draw GroupHeader 2
        handle = desg.insert(report, Designer.BOX, "Box1");
        desg.set(handle, "TopAttachPosX", 0f);
        desg.set(handle, "TopAttachPosY", 0.18f);
        desg.set(handle, "BottomAttachPosX", 4.8f);
        desg.set(handle, "BottomAttachPosY", 0.48f);
        desg.set(handle, "BorderColor", new Color(0x00007f));
        desg.set(handle, "BorderWidth", 0.01f);

        
        handle = desg.insert(header, Designer.LABEL, "Label6");
        desg.set(handle, "Width", 0.60f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Cust ID");
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField6", "Customers_Customer ID");
        desg.set(handle, "Width", 0.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.02f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "#####");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label7");
        desg.set(handle, "Width", 0.60f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "No.");
        desg.set(handle, "X", 0.60f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField7", "Orders_Order ID");
        desg.set(handle, "Width", 0.60f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 0.60f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "#####");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label8");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Order Date");
        desg.set(handle, "X", 1.2f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField8", "Order Date");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 1.2f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "MM/dd/yyyy");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label9");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Required Date");
        desg.set(handle, "X", 1.9f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField9", "Order Date");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 1.9f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "MM/dd/yyyy");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label10");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Ship Date");
        desg.set(handle, "X", 2.6f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField10", "Order Date");
        desg.set(handle, "Width", 0.70f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 2.6f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "MM/dd/yyyy");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label11");
        desg.set(handle, "Width", 1f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Ship Via");
        desg.set(handle, "X", 3.3f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.DBFIELD, "DBField12", "Payment Received");
        desg.set(handle, "Width", 1f);
        desg.set(handle, "Height", 0.18f);
        desg.set(handle, "X", 3.3f);
        desg.set(handle, "Y", 0.31f);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label12");
        desg.set(handle, "Width", 0.51f);
        desg.set(handle, "Height", 0.13f);
        desg.set(handle, "Text", "Terms");
        desg.set(handle, "X", 4.3f);
        desg.set(handle, "Y", 0.18f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.09f);

        handle = desg.insert(header, Designer.LABEL, "Label13");
        desg.set(handle, "Width", 0.51f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "Text", "30 days");
        desg.set(handle, "X", 4.3f);
        desg.set(handle, "Y", 0.3f);
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(header, Designer.LABEL, "Label14");
        desg.set(handle, "Width", 1.05f);
        desg.set(handle, "Height", 0.16f);
        desg.set(handle, "Text", "Item");
        desg.set(handle, "Y", 0.71f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(header, Designer.LABEL, "Label15");
        desg.set(handle, "Width", 0.9f);
        desg.set(handle, "Height", 0.16f);
        desg.set(handle, "Text", "Product No.");
        desg.set(handle, "X", 1.05f);
        desg.set(handle, "Y", 0.71f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(header, Designer.LABEL, "Label16");
        desg.set(handle, "Width", 0.95f);
        desg.set(handle, "Height", 0.16f);
        desg.set(handle, "Text", "Unit Price");
        desg.set(handle, "X", 1.95f);
        desg.set(handle, "Y", 0.71f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(header, Designer.LABEL, "Label17");
        desg.set(handle, "Width", 0.95f);
        desg.set(handle, "Height", 0.16f);
        desg.set(handle, "Text", "Quantity");
        desg.set(handle, "X", 2.9f);
        desg.set(handle, "Y", 0.71f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(header, Designer.LABEL, "Label18");
        desg.set(handle, "Width", 0.95f);
        desg.set(handle, "Height", 0.16f);
        desg.set(handle, "Text", "Amount");
        desg.set(handle, "X", 3.8f);
        desg.set(handle, "Y", 0.71f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        // get group2.detail
        detail = desg.getHandles(groupOrd, Designer.DETAIL)[0];
        desg.set(detail, "Label", "Detail");
        desg.set(detail, "Width", 7.5f);
        desg.set(detail, "Height", 0.25f);

        //3. Draw detail panel
        handle = desg.insert(detail, Designer.DBFIELD, "DBField13", "Product Name");
        desg.set(handle, "Width", 1f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "X", 0.02f);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(detail, Designer.DBFIELD, "DBField14", "Products_Product ID");
        desg.set(handle, "Width", 0.85f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "X", 1.05f);
        desg.set(handle, "Format", "#####");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(detail, Designer.DBFIELD, "DBField15", "Unit Price");
        desg.set(handle, "Width", 0.94f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "X", 1.95f);
        desg.set(handle, "Format", "$#,##0.00");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(detail, Designer.DBFIELD, "DBField16", "Quantity");
        desg.set(handle, "Width", 0.9f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "X", 2.9f);
        desg.set(handle, "Format", "#####");
        desg.set(handle, "FontSize", 0.11f);

        handle = desg.insert(detail, Designer.FORMULA, "Formula17", "Total");
        desg.set(handle, "Width", 0.95f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "X", 3.8f);
        desg.set(handle, "Format", "$#,##0.00");
        desg.set(handle, "Alignment", "RIGHTCENTER");
        desg.set(handle, "FontSize", 0.11f);

        // get group2.footer
        footer = desg.getHandles(groupOrd, Designer.GROUPFOOTER)[0];
        desg.set(footer, "Label", "GroupFooterPanel(OrderID)");
        desg.set(footer, "FillWholePage", true);
        desg.set(footer, "Height", 0.21f);

        //4. Draw groupfooter panel
        handle = desg.insert(footer, Designer.LABEL, "Label19");
        desg.set(handle, "Width", 0.52f);
        desg.set(handle, "Height", 0.21f);
        desg.set(handle, "Text", "Total:");
        desg.set(handle, "X", 2.84f);
        desg.set(handle, "Background", new Color(0x000090));
        desg.set(handle, "Foreground", new Color(0xffffff));
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.13f);

        handle = desg.insert(footer,  Designer.SUMMARY, "Summary1", "Sum_ProductSales_DynamicSummary");
        // handle = desg.insert(footer,  desg.SUMMARY, "Summary1", "Sum_ProductSales_StaticGroupID");
        desg.set(handle, "Width", 0.95f);
        desg.set(handle, "Height", 0.21f);
        desg.set(handle, "X", 3.8f);
        desg.set(handle, "Alignment", "RIGHTCENTER");
        desg.set(handle, "Format", "$#,##0.00");
        desg.set(handle, "FontSize", 0.13f);
        
        //5. Draw pagefooter panel
        footer = desg.getHandles(report, Designer.PAGEFOOTER, -1)[0];
        desg.set(footer, "Height", 0.6f);
        handle = desg.insert(footer, Designer.DBFIELD, "DBField18", "Customer Name");
        desg.set(handle, "Width", 4.15f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(footer, Designer.FORMULA, "formula19", "CustomerCityStateZip");
        desg.set(handle, "Width", 4.15f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "Y", 0.2f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        handle = desg.insert(footer, Designer.DBFIELD, "DBField19", "Customers_Phone");
        desg.set(handle, "Width", 4.15f);
        desg.set(handle, "Height", 0.2f);
        desg.set(handle, "Y", 0.4f);
        desg.set(handle, "Alignment", Designer.LEFTCENTER);
        desg.set(handle, "Format", "XXXXXXXXXX..");
        desg.set(handle, "Bold", true);
        desg.set(handle, "FontSize", 0.10f);

        fSuccess = true;  // report was made successfully
        return fSuccess;
    }	

		

	



	public boolean createMyregionsalesgraph()
	{
		String  report, dataset, reportbody, reportset;
		Boolean ret = false;
        try{
			// Delete old <report>.cls if it is present
			desg.deleteReportFile(name);
			
			// 1. Create new <report>.cls
			reportset = desg.createReportSet(name);
			if (reportset == null) {
				TestMultiUserDesign.errorMsg = "Failure addDataSet(): " + desg.getError();
		        return false;
		    }
			
			// 2. Register the existing query "AnnualSalesbyRegion" to this report set.
		    dataset = desg.addDataset(reportset, "Data Source 1", "AnnualSalesbyRegion","QueryDataSet","",Designer.DATASET_TYPE_QUERY);        
		    if (dataset == null) {
		    	TestMultiUserDesign.errorMsg = "Failure addDataSet(): " + desg.getError();
		        return false;
		    }
		              
		    // 3. Create the named report tab within the Page Report
		    //    For this example program, the name of the added report tab is hard coded.
		    report = desg.addReport(reportset, "Chart");
		    if (report == null) {
		    	TestMultiUserDesign.errorMsg = "Failure addReport(): " + desg.getError();
		            return false;
		        }
		 
		            reportbody = desg.getHandles(report, Designer.REPORTBODY, -1)[0];
		             
		        // 4. Insert a PagePanel into the Invoice tab
		        String page = desg.insertPage(report);             
		        desg.insertPageStartEnd(page, reportbody, 0, 0);
		        desg.set(page, "Width", 8.0f);
		        desg.set(page, "Height", 9.2f);              
		      
		          
		        String[] pageFooter = desg.getHandles(report, Designer.PAGEFOOTER,-1);
		        desg.set(pageFooter[0], "Height", 0.2f);           
		
		        
		        // 5. Insert a chart
		        ChartInfo chartInfo = new ChartInfo("Region_AbbreviationName","YearOfOrderDate");       
		        chartInfo.SetChartShowType(Designer.BAR_SIDEBYSIDE_3D, false, "Sum_AnnualSalesbyRegion_AbbreviationName");
		        ChartLabelInfo labelInfo = new ChartLabelInfo("ChartPaperObject","Annual Sales by Region","","","ChartLabelObject1","Regions");
		        chartInfo.setChartLabelInfo(labelInfo);           
		        ChartLegendInfo legendInfo = new ChartLegendInfo("ChartLegendObject",true,ChartLegendInfo.RIGHT);
		        chartInfo.setChartLegendInfo(legendInfo);
		        String chartHandle = desg.insertChart(reportbody, chartInfo);
		        if(chartHandle == null){
		        	TestMultiUserDesign.errorMsg = "Failure insertChart(): " + desg.getError();
		        	return false;
		        }
		        desg.set(chartHandle, "Height", 3.83f);
		        desg.set(chartHandle, "Width", 5.07f);
		        desg.set(chartHandle, "X", 0.14f);
				desg.set(chartHandle, "Y", 0.14f);
				
				// 6. bind the dataSet to the report body and set banded object to inherit the dataSet
		        // it is an container object that must have a data set bound to it.
			    if( ! desg.bindDataSet(reportbody, "QueryDataSet") ) {
			    	TestMultiUserDesign.errorMsg = "Failure bindDataSet(): " + desg.getError();
		             return false;
		           }
		        desg.set(chartHandle, "dataInherit", true);
        }catch(Exception e){
        	e.printStackTrace();
        }
		
        ret = true;
       
		try
		{
			desg.closeLog();
		}
		catch ( IOException e )
		{
			e.printStackTrace();
		}		
		return ret;
	
	}

		
}

class EditReport extends Thread
{
	String name, User;
	MultiUserDesigner desg;

	public EditReport()
	{
	}

	public void run()
	{
		try
		{
			if(name.compareToIgnoreCase("Myinvoice") != 0)
			{
				throw new Exception("Not found the method for " + name);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public void modifyMyinvoice()
	{
		int index=0;
		String handle, report;

		report = desg.open(name);
		if ( report != null )
		{
			// As there is only one picture in the report invoice1.
			if ( desg.getHandles(report, Designer.IMAGE,-1).length > 0 )
			{
				handle = desg.getHandles(report, Designer.IMAGE,-1)[0];
			}
			else
			{
				String GroupHeaderpanel[] = desg.getHandles(desg.getHandles(report, MultiUserDesigner.GROUP, -1 )[0], MultiUserDesigner.GROUPHEADER, -1);
				handle = desg.insert(GroupHeaderpanel[0], Designer.IMAGE ,"Image"+index);
			}
			desg.set(handle, "PictureName","CoffeeLogo.gif");
			desg.set(handle, "X", 2.24f);
			desg.set(handle, "Width", 4.76f);
		}

		try
		{
			desg.closeLog();
		}
		catch ( IOException e )
		{
			e.printStackTrace();
		}
	}
}