import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import jet.cs.util.APIConst;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.api.rmi.RemoteRptServer;
import jet.server.api.RemoteFileService;
/**
 * This demo is created to demonstrate the usage of the JReport Server API methods to run and export results
 * using a remote interface to JReport Server.  It may be on the same computer but running in a different JVM.
 *
 * The report rsult is created in HTML format and all the files of the HTML result are copied to the client.
 * This is the normal way to make requests to a stand-alone JReport Server.
 *
 * Assume that there is a catalog SampleReports.cat, a report CustomerAnalysis.cls 
 * already deployed to /SampleReports in Public Reports.
 * Requires that the C:\JReport\Server\temp directory exists.
 */
public class RemoteAPIDemoFileService
{

    public static void main(String[] args)
	{
		try {
			//set report home for logging and location of rmi.auth file for security
			System.getProperties().put("reporthome", "C:\\JReport\\Server");
			System.getProperties().put("jrs.rmi.auth_file", "C:\\JReport\\Server\\bin\\rmi.auth");
			String host = "localhost";
			String port = "1129";
			System.out.println("*******************************************************************************");									
			System.out.println("You must input your server's IP before running the APIDemo!");
			System.out.println("Please input your server's IP, and make sure it is correct! For example '111.111.111.111' or 'localhost'");
			System.out.println("*******************************************************************************");
			// get Server's IP input by user
			BufferedReader inputIP = new BufferedReader(new InputStreamReader(System.in));	    
			host = inputIP.readLine();
			System.out.println();
		    
			// print the note and description
			System.out.println("******************************************************************************");									
			System.out.println("You must input the port to connect server before running the APIDemo!");
			System.out.println("Please input the port, and make sure it is correct! For example '1129'");
			System.out.println("******************************************************************************");
			// get port input by user
			BufferedReader inputPort = new BufferedReader(new InputStreamReader(System.in));	    
			port = inputPort.readLine();
			System.out.println();
			
            // get a RemoteRptServer instance
			RemoteRptServer server = RemoteReportServerToolkit.getRemoteRptServer(host, port);
			System.out.println("========server="+server);

			String catalog = "/SampleReports/SampleReports.cat";
			String rptName = "CustomerAnalysis.cls";

			//set report properties
			Properties props = new Properties();
			
			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);			
			//set result type as .pdf format.
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.PDF));

			System.out.println("\n========to pdf="+props);

			String tempResult = server.runReport("admin", catalog, rptName, props);
			System.out.println("========tempResult="+tempResult);

			String localFolder = "C:\\temp\\result\\";
			//copy remote temp result file to local folder.
			RemoteFileService remoteFileService = RemoteReportServerToolkit.getRemoteFileService(host, port);
			System.out.println("========remoteFileService="+remoteFileService);

			remoteFileService.copyFromRemote(tempResult, localFolder);

			props = new Properties();

			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);
			//set result type as .html format
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.HTML));			
			props.put(APIConst.TAG_IS_MULTI_FILES , "true");
			props.put(APIConst.TAG_IS_CHART_APPLET  , "false");

			System.out.println("\n========to html="+props);

			tempResult = server.runReport("admin", catalog, rptName, props);
			//the tempResult is the first html page. If want to get all html files, 
			System.out.println("========tempResult="+tempResult);
			// get the 	file name prefix and using this for file name filter to copy all the related files.
			if ( tempResult.indexOf("_1.html") > -1 ) {
				String fileNameFilter = tempResult.substring(0, tempResult.indexOf("_1.html"));
				String remoteFile = fileNameFilter + "*";
				remoteFileService.copyFromRemote(remoteFile,localFolder);
			}
		}catch (Throwable t){
			t.printStackTrace();
		}
		System.exit(0);
    }
}


