
import java.io.*;
import jet.server.api.http.SendFileAuthorizor;
import jet.server.api.http.HttpRptServer;

/** 
 * Demo of implementation of SendFileAuthorizor.
 * <pre>
 * Usage: 
 * Use the command line to start the report server:
 * java -Dcom.jinfonet.sendfileAuth=CustomizedSendFileAuthorizor -classpath ...
 * </pre>
 */
public class CustomizedSendFileAuthorizor implements SendFileAuthorizor {

    public CustomizedSendFileAuthorizor() {
    	System.out.println("========CustomizedSendFileAuthorizor========");
    }

    public boolean isAuthorized(String userID, String _path, HttpRptServer httpRptServer) {
		String path = _path;
		if (path == null || path.trim().length() == 0) {
			return false;
		}

		File file = new File(path);
		try {
			if( file.exists() ) {
				path = file.getCanonicalPath();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		String serverPath = httpRptServer.getResourceManager().getRoot();
	    String tempPath = httpRptServer.getResourceManager().getTempDir();
		String histPath = httpRptServer.getResourceManager().getHistDir();

		// for files under server root
		if (serverPath != null && path.indexOf(serverPath) != -1) {
			System.out.println("server root: " + serverPath + " user: " + userID);
			return true;
		}

		// for files under temp directory (viewing report)
		if (tempPath != null && path.indexOf(tempPath) != -1) {
			System.out.println("temp directory: " + tempPath + " user: " + userID);
			return true;
		}

		// for files under history directory (viewing a version)
		if (histPath != null && path.indexOf(histPath) != -1) {
			System.out.println("history directory: " + histPath + " user: " + userID);
		    return true;
		}

		// if the user is "admin", he can access files under C:.
		if (userID.equals("admin") && path.indexOf("C:") != -1) {
			System.out.println("files under c:  user: " + userID);
		    return true;
		}
	    return false;
	}
}

