
import javax.servlet.*;

import jet.server.api.http.HttpUtil;
import jet.server.api.http.HttpUserSessionManager;

import jet.server.servlets.JRServlet;

//  Example servlet code that can dynamically set an implementation of HttpExternalAuthorized java
//  interface into the report server.
//
//  This code registers the sample implementation CustomHttpExternalAuthorized which is included in this same folder.
//  In the CustomHttpExternalAuthorized.java, comments explain how to register it when starting JReport Server by
//  setting a system property in the command line (use -Djrs.httpExternalAuthorized=CustomHttpExternalAuthorized)
//  after placing the jar file holding the compiled java file into a folder on the classpath.
//
//  This code will register the same class as the ExternalAuthorized implementation to use.
//  It also depends on the compiled class being found on the classpath of JReport Server.
//  Put the jar file that holds it into a folder on the classpath.
//
//  Compile this servlet and deploy it using your local technique for deploying a servlet.
//  Then access this servlet by URL.
//  It will turn on Single Sign On with CustomHttpExternalAuthorized as the module that handles it.
//  
//  A servlet must be used to dynamically set an implementation of HttpExternalAuthorized that is
//  named without a multi-tiered package name.  This servlet can compile because the reference
//  to the CustomHttpExternalAuthroized can be satisfied by compiling it within the same project
//  as the CustomHttpExternalAuthorized.java file.
//
//  See the sample JSP files in this folder that show similar actions.
//  These JSP pages work within a demonstration framework with entry at customIndex.jsp.
//  customTurnOnSSO.jsp   - turn on Single Sign On by registering an implementation of the HttpExternalAuthorized java interface.
//  customTurnOffSSO.jsp  - turn off Single Sign On
//  These JSP pages work with an implementation that has a multi-tiered package name.


public class CustomServlet extends JRServlet
{

	public void init(ServletConfig conf) throws ServletException
	{
        try {
            //call the init(...) of JRServlet at first.
			super.init(conf);

			//get the HttpUserSessionManager object.
			HttpUserSessionManager ssnMan = HttpUtil.getHttpRptServer().getHttpUserSessionManager();
			
			//create a CustomHttpExternalAuthorized object and set it into 
			//the the HttpUserSessionManager.
			ssnMan.setHttpExternalAuthorized(new CustomHttpExternalAuthorized());

        } catch (ServletException se) {
			throw se;
        } catch (Throwable t) {
			t.printStackTrace();
        }
    }

}

