import java.util.*;
import java.awt.*;
import java.awt.event.*;

import jet.server.api.engine.*;

/**
 * This demo is created to demonstrate the usage of JReport Server API methods of report engine.
 * This does not require that there be a running JReport Server instance.
 * 
 * The sample assumes JReport Server is installed on Windows in the default location
 * SampleReports/SampleReports.cat and SampleReports/CustomerAnalysis.cls are deployed under Public Reports
 * That the C:/JReport/Server/temp directory exists.
 */ 
public class APIDemoReportEngine extends Frame implements ActionListener {

	TextField tf;
	ReportEngine bean = null;

	public APIDemoReportEngine() {
		System.getProperties().put("reporthome", "c:\\JReport\\Server");
		setLayout(null);
		setBounds(0, 0, 200, 100);

		Menu m1 = new Menu("Test");
		MenuItem item = new MenuItem("Test A");
		item.addActionListener(this);
        m1.add(item);
		item = new MenuItem("Test B");
		item.addActionListener(this);
        m1.add(item);
		
		Menu m2 = new Menu("export");
		item = new MenuItem("export to Pdf");
		item.addActionListener(this);
        m2.add(item);
		item = new MenuItem("export to Txt");
		item.addActionListener(this);
        m2.add(item);
		item = new MenuItem("export to Html");
		item.addActionListener(this);
        m2.add(item);
        item = new MenuItem("export to Dhtml");
		item.addActionListener(this);
		m2.add(item);
		item = new MenuItem("export to PS");
		item.addActionListener(this);
		m2.add(item);
		item = new MenuItem("export to Rst");
		item.addActionListener(this);
        m2.add(item);
        item = new MenuItem("export to Rtf");
		item.addActionListener(this);
        m2.add(item);
		item = new MenuItem("export to Xls");
		item.addActionListener(this);
        m2.add(item);
		item = new MenuItem("export to XML");
		item.addActionListener(this);
        m2.add(item);
		item = new MenuItem("export to mail");
		item.addActionListener(this);
		m2.add(item);
        item = new MenuItem("export to Fax");
		item.addActionListener(this);
        m2.add(item);

        Menu m3 = new Menu("Where Portion");
		item = new MenuItem("Set WherePortion name");
		item.addActionListener(this);
        m3.add(item);
		item = new MenuItem("Set WherePortion string");
		item.addActionListener(this);
        m3.add(item);
		item = new MenuItem("Save WherePortion");
		item.addActionListener(this);
        m3.add(item);
		item = new MenuItem("delete WherePortion");
		item.addActionListener(this);
        m3.add(item);
		item = new MenuItem("get Available Query Fields");
		item.addActionListener(this);
        m3.add(item);
		item = new MenuItem("get Available Where Portion");
		item.addActionListener(this);
        m3.add(item);

		MenuBar mb = new MenuBar();
		mb.add(m1);
		mb.add(m2);
		mb.add(m3);
		setMenuBar(mb);

        tf = new TextField("");
        tf.setEditable(false);
        tf.setBounds(10, 50, 100, 40);
        add(tf);

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				if (bean != null) {
					bean.exit();
				}
				System.exit(0);
			}
		} );
		setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {
		String label = e.getActionCommand();
		
		if (label.equals("Test A")) {
            tf.setText("running");
			bean = ReportEngineFactory.getInstance();
			bean.setReportHome("c:\\JReport\\Server");
			bean.setReportName("c:\\JReport\\Server\\jreports\\SampleReports\\CustomerAnalysis.cls");
			bean.setCatName("c:\\JReport\\Server\\jreports\\SampleReports\\SampleReports.cat");
			bean.setShowInfoLevel( ReportEngineConst.vDebug | ReportEngineConst.vError );
			bean.setLogFile("c:\\JReport\\Server\\logs\\reportEngine.log");
						
			bean.runReport();
			String sStatus = bean.getStatus();
            tf.setText(sStatus);

            System.out.println("**** status:" + sStatus);
            
		    tf.setText("running second");
		    ReportEngine bean2= ReportEngineFactory.getInstance();
		    bean2.setReportHome("c:\\JReport\\Server");
		    bean2.setReportName("c:\\JReport\\Server\\jreports\\SampleReports\\CustomerAnalysis.cls");
		    bean2.setCatName("c:\\JReport\\Server\\jreports\\SampleReports\\SampleReports.cat");
		    bean2.setShowInfoLevel( ReportEngineConst.vDebug | ReportEngineConst.vError );
		    bean2.setLogFile("");
		    bean2.runReport();
		    sStatus = bean2.getStatus();
		    tf.setText(sStatus);
		    System.out.println("**** status second:" + sStatus);
		} else if (label.equals("Test B")) {
		    tf.setText("running");

			bean = ReportEngineFactory.getInstance();
			bean.setReportHome("c:\\JReport\\Server");
			bean.setReportName("c:\\JReport\\Server\\jreports\\SampleReports\\CustomerAnalysis.cls");
			bean.setCatName("c:\\JReport\\Server\\jreports\\SampleReports\\SampleReports.cat");
			bean.setParamValues("p_StartDate=01/01/2006,p_EndDate=12/31/2007");
			bean.setResultFile("c:\\JReport\\Server\\temp\\CustomerAnalysis.rst");
								
			
			bean.runReport();
			String sStatus = bean.getStatus();
            tf.setText(sStatus);

			System.out.println("**** status:" + sStatus);
		} else if (label.equals("export to mail")) {
			tf.setText("running");
            try {
                bean.configMailServer("192.192.192.192", "rose@jinfonet.com", 25);
                bean.exportToMail("someone@jinfonet.com",
									"rose@jinfonet.com", 
									null, 
									null, 
									"hello", 
									null, 
									false, 
									ReportEngineConst.HTMLFILEMAIL,
									false,
									-1,
									-1,
									false,
									20,
									false,
									null,
									true,
									false,
									false,
									false,
									ReportEngineConst.KEEPORIGIN,
									false,
									ReportEngineConst.EXPORTSHAPE,
									false,
									false,
									null);
                System.out.println("send mail ok");
            } catch (Exception exc) {
                exc.printStackTrace();
            }
        } else if (label.equals("export to Pdf")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToPdf("C:\\JReport\\Server\\temp\\DateParameterUsage.pdf", 
									false, 
									false, 
									20, 
									false, 
									false, 
									false, 
									null);
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to Txt")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToText("C:\\JReport\\Server\\temp\\DateParameterUsage.txt", 
									true, 
									false, 
									' ', 
									-1, 
									-1, 
									false, 
									-1, 
									true, 
									true, 
									true);
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to Html")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToHtml("C:\\JReport\\Server\\temp\\DateParameterUsage.html", 
									false, 
									true, 
									false, 
									true, 
									true, 
									true, 
									ReportEngineConst.IE, 
									false, 
									false, 
									null, 
									-1, 
									ReportEngineConst.HIDDEN);
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to Dhtml")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToDhtml("C:\\JReport\\Server\\temp\\DateParameterUsage.dhtml", 
									false, 
									true, 
									false, 
									true, 
									true, 
									true, 
									ReportEngineConst.IE, 
									false, 
									false, 
									null, 
									-1, 
									ReportEngineConst.HIDDEN);
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to PS")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToPS("C:\\JReport\\Server\\temp\\DateParameterUsage.ps", false);
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		} else if (label.equals("export to Rst")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToRst("C:\\JReport\\Server\\temp\\DateParameterUsage.rst");
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		} else if (label.equals("export to Rtf")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToRtf("C:\\JReport\\Server\\temp\\DateParameterUsage.rtf", false);
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		} else if (label.equals("export to Xls")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				bean.exportToXls("C:\\JReport\\Server\\temp\\DateParameterUsage.xls", 
									ReportEngineConst.KEEPORIGIN, 
									false, 
									0, 
									false);
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to XML")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                try{
				    bean.exportToXML("C:\\JReport\\Server\\temp\\DateParameterUsage.xml",
										true,
										null);
                }catch(Exception xmle){
                    System.out.println("exportToXML file fail!!!");
                }
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("export to Fax")) {
			if (bean != null) {
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				try{
				    bean.exportToFax("COM2",
									"ATV1Q0",
									0,
									0,
									"AT&K3",
									0,
									60,
									3,
									true,
									false,
									false,
									false,
									"1234567",
									null,
									null,
									null,
									null,
									null,
									null,
									null,
									false,
									false,
									false,
									false);
                } catch(Exception faxe) {
                    System.out.println("exportToFax file fail!!!");
                }
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
		} else if (label.equals("Save WherePortion")) {
            if (bean != null) {
	            boolean isOK;
				//showStatus.setText("Save name = condition1 \n value = @\"Customers_Customer ID\" < 20");
				isOK = bean.saveWherePortion("condition2","CUSTOMERS.CUSTOMERID < 20");	
				if (isOK) {
					tf.setText("Save Complete!");
				} else {
					tf.setText("Save Failed!");
				}
				String sStatus = bean.getStatus();
	    		System.out.println("**** status:" + sStatus);
			}
		} else if (label.equals("Set WherePortion name")) {
			bean = ReportEngineFactory.getInstance();
			bean.setReportHome("c:\\JReport\\Server");
			bean.setReportName("c:\\JReport\\Server\\jreports\\SampleReports\\CustomerAnalysis.cls");
			bean.setCatName("c:\\JReport\\Server\\jreports\\SampleReports\\SampleReports.cat");
			bean.setShowInfoLevel( ReportEngineConst.vDebug | ReportEngineConst.vError );
			bean.setLogFile("c:\\JReport\\Server\\logs\\reportEngine.log");
			bean.setNamedWherePortion("condition 2");
			bean.runReport();
			
			String sStatus = bean.getStatus();
			System.out.println("**** status:" + sStatus);
		} else if (label.equals("Set WherePortion string")) {
			bean = ReportEngineFactory.getInstance();
			bean.setReportHome("c:\\JReport\\Server");
			bean.setReportName("c:\\JReport\\Server\\jreports\\SampleReports\\CustomerAnalysis.cls");
			bean.setCatName("c:\\JReport\\Server\\jreports\\SampleReports\\SampleReports.cat");
			bean.setShowInfoLevel( ReportEngineConst.vDebug | ReportEngineConst.vError );
			bean.setLogFile("c:\\JReport\\Server\\logs\\reportEngine.log");
			bean.setWherePortion("((CUSTOMERS.CUSTOMERID > 10) and (CUSTOMERS.CUSTOMERID < 20))");
			bean.runReport();
			
            String sStatus = bean.getStatus();
			System.out.println("**** status:" + sStatus);
		} else if (label.equals("delete WherePortion")) {
            if (bean != null) {
	            boolean isOK;
				//showStatus.setText("delete \"condition1\"");
				isOK = bean.deleteWherePortion("condition2");
				if (isOK) {
					tf.setText("Delete Complete!");
				} else {
					 tf.setText("Failed!");
				}
				String sStatus = bean.getStatus();
				System.out.println("**** status:" + sStatus);
			}
		} else if (label.equals("get Available Query Fields")) {
            if (bean != null) {
	            Enumeration e1 = bean.getAvailableQueryFields();
				String tmpStr = "";
				while (e1.hasMoreElements()) {
					tmpStr = tmpStr +"\n"+ e1.nextElement().toString() + "\n";
				}
				tf.setText(tmpStr);
				String sStatus = tmpStr;
				System.out.println("**** status:" + sStatus);
			}
		} else if (label.equals("get Available Where Portion")) {
            if (bean != null) {
	            Enumeration e1 = bean.getAvailableWherePortions();
				String tmpStr = "";
				while (e1.hasMoreElements()) {
					tmpStr = tmpStr + e1.nextElement().toString() + "\n";
				}
				tf.setText(tmpStr);
				String sStatus = tmpStr;
				System.out.println("**** status:" + sStatus);
			}
		}
	}

	public static void main(String argv[]) {
		new APIDemoReportEngine();
	}
}
