package jreport.uds.javabean;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

import jreport.uds.javabean.exception.JavaBeanDataProviderException;
import jreport.uds.javabean.exception.MetaDataExceptionForJavaBean;
import jreport.uds.javabean.exception.ResultSetExceptionForJavaBean;
import jreport.uds.javabean.api.JavaBeanDataProvider;


/*
 * Created on Jul 17, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author jennyw
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ResultSetForJavaBean implements ResultSet {
	private JavaBeanDataProvider dataProvider = null;
	private MetaDataForJavaBean metaData=null;
	private Object beanData=null; // buffered next bean data
	
	public  ResultSetForJavaBean(JavaBeanDataProvider dataProvider) throws ResultSetExceptionForJavaBean{
	    this.dataProvider = dataProvider;
        try {
			metaData = new MetaDataForJavaBean(dataProvider);
		} catch (MetaDataExceptionForJavaBean e) {
			throw new ResultSetExceptionForJavaBean(e, e.getMessage());
//			e.printStackTrace();
		}
	    
	}
	public ResultSetMetaData getMetaData() throws SQLException {
		// TODO Auto-generated method stub
		
		return metaData;
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#next()
	 */
	public boolean next() throws SQLException {
		try {
			beanData = dataProvider.next();
		} catch (JavaBeanDataProviderException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new SQLException(e.getMessage());
		}
		if( beanData !=null)
			return true;
		return false;
	}
	
	public void close() throws SQLException {
	}
	
	private Object getValue(ColumnInfo info) throws SQLException{
		Vector methods = info.getMethods();
		int size = methods.size();
		
		Object obj = this.beanData;
		for( int i=0; i < size; i++){
			Method method = (Method)methods.elementAt(i);
			UDSForJavaBeanLogger.debug("Invoking method>>>"+method);
			try {
				obj = method.invoke(obj, null);
				if( obj == null)
					return null;
			} catch (IllegalArgumentException e) {
				throw new SQLException("Method error on column:"+info.getName()+"."+e.getMessage());
	//			e.printStackTrace();
			} catch (IllegalAccessException e) {
				throw new SQLException("Method error on column:"+info.getName()+"."+e.getMessage());
			} catch (InvocationTargetException e) {
				throw new SQLException("Method error on column:"+info.getName()+"."+e.getMessage());
			}
		}
		
		return obj;
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getByte(int)
	 */
	public byte getByte(ColumnInfo info) throws SQLException{
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		if(info.getTypeClass().equals(Byte.class) ||info.getTypeClass().equals(byte.class)){
			Object obj = getValue(info);
			
			if( obj != null ){
				
				if( obj.getClass().equals(Boolean.class))
					return ((Byte)obj).byteValue();
//				else if( obj.getClass().equals(byte.class))
//					return (byte)obj;
				else{
					new SQLException("Column "+info.getName()+" is not Byte type value.");
				}
			}else{
				new SQLException("Column "+info.getName()+" is not Byte type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Byte ");
	}
	public byte getByte(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getByte(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getByte(java.lang.String)
	 */
	public byte getByte(String columnName) throws SQLException {
		ColumnInfo info = metaData.getColumnInfo(columnName);
		if( info == null )
			new SQLException("Cannot find column "+columnName+".");
		return getByte(info);
	}

	public double getDouble(ColumnInfo info)throws SQLException{
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		Object obj = getValue(info);
		
		if( obj != null && obj instanceof Number){
			
			return ((Number)obj).doubleValue();
//			
		}else{
			new SQLException("Column "+info.getName()+" is not Double type value.");
		}
		return 0;
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getDouble(int)
	 */
	public double getDouble(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		
		return getDouble(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getDouble(java.lang.String)
	 */
	public double getDouble(String columnName) throws SQLException {
		ColumnInfo info = metaData.getColumnInfo(columnName);
		if( info == null )
			new SQLException("Cannot find column:"+columnName+".");
		
		return getDouble(info);
	}

	public float getFloat(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		Object obj = getValue(info);
		
		if( obj != null && obj instanceof Number){
			
			return ((Number)obj).floatValue();
//			
		}else{
			new SQLException("Column "+info.getName()+" is not Float type value.");
		}
		return 0;
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getFloat(int)
	 */
	public float getFloat(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		
		return getFloat(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getFloat(java.lang.String)
	 */
	public float getFloat(String columnName) throws SQLException {
		ColumnInfo info = metaData.getColumnInfo(columnName);
		if( info == null )
			new SQLException("Cannot find column:"+columnName+".");
		
		return getFloat(info);
	}

	public int getInt(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		Object obj = getValue(info);
		
		if( obj != null && obj instanceof Number){
			
			return ((Number)obj).intValue();
//			
		}else{
			new SQLException("Column "+info.getName()+" is not Integer type value.");
		}
		return 0;
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getInt(int)
	 */
	public int getInt(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		
		return getInt(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getInt(java.lang.String)
	 */
	public int getInt(String columnName) throws SQLException {
		ColumnInfo info = metaData.getColumnInfo(columnName);
		if( info == null )
			new SQLException("Cannot find column:"+columnName+".");
		
		return getInt(info);
	}
	
	public long getLong(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		Object obj = getValue(info);
		if( obj != null && obj instanceof Number){
			
			return ((Number)obj).longValue();
//			
		}else{
			new SQLException("Column "+info.getName()+" is not Long type value.");
		}
		return 0;
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getLong(int)
	 */
	public long getLong(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			throw new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getLong(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getLong(java.lang.String)
	 */
	public long getLong(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		return getLong(info);
	}
	
	public short getShort(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		Object obj = getValue(info);
		
		if( obj != null && obj instanceof Number){
			
			return ((Number)obj).shortValue();
//			
		}else{
			throw new SQLException("Column "+info.getName()+" is not Short type value.");
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getShort(int)
	 */
	public short getShort(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			throw new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		
		return getShort(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getShort(java.lang.String)
	 */
	public short getShort(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		
		return getShort(info);
	}

	public boolean getBoolean(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		if(info.getTypeClass().equals(Boolean.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Boolean ){
				return ((Boolean)obj).booleanValue();
			}else{
				new SQLException("Column "+info.getName()+" is not Boolean type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Boolean ");
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getBoolean(int)
	 */
	public boolean getBoolean(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getBoolean(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getBoolean(java.lang.String)
	 */
	public boolean getBoolean(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		return getBoolean(info);
	}

	public String getString(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		Class clsType = info.getTypeClass();
		boolean isCollectiontype =DataTypeMapping.isDetailCollectionClass(clsType); 
		if(clsType.equals(String.class) || isCollectiontype){
				 
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof String ){
				return (String)obj;
			}else if( isCollectiontype ){
				
				long lkey = (hashCode()+System.currentTimeMillis());
				String key = lkey+"";
				Object data = obj==null?new ArrayList():obj;
				int maxShare = dataProvider.getMaxShareTimes(info.getName());
				
				while(!DataCenter.putData(key,data, this, maxShare, 
						dataProvider.getTimeoutForSubCollection(info.getName()),false )){
					key = (lkey++)+"";
				}
				
				UDSForJavaBeanLogger.debug("Put sub-data key:"+key+" Obj:"+ data);
				return key;
			}else if( obj == null){
				return null;
			}else{
				new SQLException("Error!!-You are trying to return "+obj.getClass().getName()+
						" type of value to the String type of column "+info.getName());
			}
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not String ");
	}
	public String getString(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			throw new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getString(info);
	}
	

	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getString(java.lang.String)
	 */
	public String getString(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		return getString(info);
	}

	public Date getDate(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		if(info.getTypeClass().equals(Date.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Date ){
				return (Date)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not Date type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Date.");
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getDate(int)
	 */
	public Date getDate(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getDate(info);
	}
	
	public Date getDate(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		
		return getDate(info);
	}

	public Time getTime(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		if(info.getTypeClass().equals(Time.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Time){
				return (Time)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not Time type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Time.");
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getMetaData()
	 */
	public Time getTime(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getTime(info);
	}
	
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getTime(java.lang.String)
	 */
	public Time getTime(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		return getTime(info);
	}
	
	public Timestamp getTimestamp(ColumnInfo info) throws SQLException {
		if( info == null){
			throw new SQLException("Null ColumnInfo is passed");
		}
		
		if(info.getTypeClass().equals(Timestamp.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Timestamp){
				return (Timestamp)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not Timestamp type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Timestamp.");
	}
	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getTimestamp(int)
	 */
	public Timestamp getTimestamp(int columnIndex) throws SQLException {
		ColumnInfo info = (ColumnInfo)this.metaData.getColumnInfo(columnIndex-1);
		if( info == null )
			new SQLException("Cannot find column at index:"+columnIndex+". Total columns number is:"+this.metaData.getColumnCount());
		return getTimestamp(info);
	}

	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getTimestamp(java.lang.String)
	 */
	public Timestamp getTimestamp(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		return getTimestamp(info);
	}
	
	public BigDecimal getBigDecimal(String columnName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(columnName);
		if( info == null )
			throw new SQLException("Cannot find column "+columnName);
		
		if(info.getTypeClass().equals(BigDecimal.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof BigDecimal){
				return (BigDecimal)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not BigDecimal type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Timestamp.");
	}
	public Blob getBlob(String colName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(colName);
		if( info == null )
			throw new SQLException("Cannot find column "+colName);
		
		if(info.getTypeClass().equals(Blob.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Blob){
				return (Blob)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not BigDecimal type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not BigDecimal.");
	}
	
	public Clob getClob(String colName) throws SQLException {
		ColumnInfo info = this.metaData.getColumnInfo(colName);
		if( info == null )
			throw new SQLException("Cannot find column "+colName);
		
		if(info.getTypeClass().equals(Clob.class)){
			Object obj = getValue(info);
			
			if( obj != null && obj instanceof Blob){
				return (Clob)obj;
			}else{
				new SQLException("Column "+info.getName()+" is not Clob type value.");
			}
				
		}
		throw new SQLException("Data type on the clumn:"+info.getName()+" is not Clob.");
	}
	
	
	
	
	
	public void updateString(String columnName, String x) throws SQLException {}
	public BigDecimal getBigDecimal(String columnName, int scale)
			throws SQLException {return null;}
	public void updateBigDecimal(String columnName, BigDecimal x)throws SQLException {}
	public URL getURL(String columnName) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Array getArray(String colName) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	public void updateArray(String columnName, Array x) throws SQLException {}
	public void updateBlob(String columnName, Blob x) throws SQLException {}
	public void updateClob(String columnName, Clob x) throws SQLException {}
	public void updateDate(String columnName, Date x) throws SQLException {}
	public Date getDate(int columnIndex, Calendar cal) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Ref getRef(String colName) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Time getTime(int columnIndex, Calendar cal) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public void updateTimestamp(String columnName, Timestamp x)
			throws SQLException {}

	public Timestamp getTimestamp(int columnIndex, Calendar cal)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Object getObject(String colName, Map map) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Date getDate(String columnName, Calendar cal) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getTime(java.lang.String, java.util.Calendar)
	 */
	public Time getTime(String columnName, Calendar cal) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see java.sql.ResultSet#getTimestamp(java.lang.String, java.util.Calendar)
	 */
	public Timestamp getTimestamp(String columnName, Calendar cal)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public int getConcurrency() throws SQLException {return 0;}
	public int getFetchDirection() throws SQLException {return 0;}
	public int getFetchSize() throws SQLException {return 0;}
	public int getRow() throws SQLException {return 0;}
	public int getType() throws SQLException {return 0;}
	public void afterLast() throws SQLException {}
	public void beforeFirst() throws SQLException {}
	public void cancelRowUpdates() throws SQLException {}
	public void clearWarnings() throws SQLException {}
	
	public void deleteRow() throws SQLException {}
	public void insertRow() throws SQLException {}
	public void moveToCurrentRow() throws SQLException {}
	public void moveToInsertRow() throws SQLException {}
	public void refreshRow() throws SQLException {}
	public void updateRow() throws SQLException {}
	public boolean first() throws SQLException {return false;	}
	public boolean isAfterLast() throws SQLException {return false;	}
	public boolean isBeforeFirst() throws SQLException {return false;	}
	public boolean isFirst() throws SQLException {return false;	}
	public boolean isLast() throws SQLException {return false;	}
	public boolean last() throws SQLException {return false;}
	
	public boolean previous() throws SQLException {return false;}
	public boolean rowDeleted() throws SQLException {return false;}
	public boolean rowInserted() throws SQLException {return false;}
	public boolean rowUpdated() throws SQLException {return false;}
	public boolean wasNull() throws SQLException {return false;}

	public void setFetchDirection(int direction) throws SQLException {}
	public void setFetchSize(int rows) throws SQLException {}
	public void updateNull(int columnIndex) throws SQLException {}
	public boolean absolute(int row) throws SQLException {return false;}
	public boolean relative(int rows) throws SQLException {return false;}
	public byte[] getBytes(int columnIndex) throws SQLException {return null;}
	public byte[] getBytes(String columnName) throws SQLException {return null;}
	public void updateByte(int columnIndex, byte x) throws SQLException {}
	public void updateDouble(int columnIndex, double x) throws SQLException {}
	public void updateFloat(int columnIndex, float x) throws SQLException {}
	public void updateInt(int columnIndex, int x) throws SQLException {}
	public void updateLong(int columnIndex, long x) throws SQLException {}
	public void updateShort(int columnIndex, short x) throws SQLException {}
	public void updateBoolean(int columnIndex, boolean x) throws SQLException {}
	public void updateBytes(int columnIndex, byte[] x) throws SQLException {}
	public InputStream getAsciiStream(int columnIndex) throws SQLException {return null;}
	public InputStream getBinaryStream(int columnIndex) throws SQLException {return null;}
	public InputStream getUnicodeStream(int columnIndex) throws SQLException {return null;}
	public void updateAsciiStream(int columnIndex, InputStream x, int length)
			throws SQLException {}
	public void updateBinaryStream(int columnIndex, InputStream x, int length)
			throws SQLException {}
	public Reader getCharacterStream(int columnIndex) throws SQLException {return null;}
	public void updateCharacterStream(int columnIndex, Reader x, int length)
			throws SQLException {}

	public Object getObject(int columnIndex) throws SQLException {return null;}
	public void updateObject(int columnIndex, Object x) throws SQLException {}
	public void updateObject(int columnIndex, Object x, int scale)
			throws SQLException {}
	
	public String getCursorName() throws SQLException {return null;}
	
	public void updateByte(String columnName, byte x) throws SQLException {}
	public void updateDouble(String columnName, double x) throws SQLException {}
	public void updateFloat(String columnName, float x) throws SQLException {}
	public void updateInt(String columnName, int x) throws SQLException {}
	public void updateLong(String columnName, long x) throws SQLException {}
	public void updateShort(String columnName, short x) throws SQLException {}
	public void updateBoolean(String columnName, boolean x) throws SQLException {}
	public void updateBytes(String columnName, byte[] x) throws SQLException {}
	public BigDecimal getBigDecimal(int columnIndex) throws SQLException {return null;}
	public BigDecimal getBigDecimal(int columnIndex, int scale)
			throws SQLException {return null;}
	public void updateBigDecimal(int columnIndex, BigDecimal x)
			throws SQLException {}
	public URL getURL(int columnIndex) throws SQLException {return null;}
	public Array getArray(int i) throws SQLException {return null;}
	public void updateArray(int columnIndex, Array x) throws SQLException {}
	public Blob getBlob(int i) throws SQLException {return null;}
	public void updateBlob(int columnIndex, Blob x) throws SQLException {}
	public Clob getClob(int i) throws SQLException {return null;}
	public void updateClob(int columnIndex, Clob x) throws SQLException {}
	
	public void updateDate(int columnIndex, Date x) throws SQLException {}
	public Ref getRef(int i) throws SQLException {return null;}
	public void updateRef(int columnIndex, Ref x) throws SQLException {}
	public SQLWarning getWarnings() throws SQLException {return null;}
	public Statement getStatement() throws SQLException {return null;}
	public void updateTime(int columnIndex, Time x) throws SQLException {}
	public void updateTimestamp(int columnIndex, Timestamp x)throws SQLException {}
	public InputStream getAsciiStream(String columnName) throws SQLException {return null;}
	public InputStream getBinaryStream(String columnName) throws SQLException {return null;}
	public InputStream getUnicodeStream(String columnName) throws SQLException {return null;}
	public void updateAsciiStream(String columnName, InputStream x, int length)throws SQLException {}
	public void updateBinaryStream(String columnName, InputStream x, int length)throws SQLException {}
	public Reader getCharacterStream(String columnName) throws SQLException {return null;}
	public void updateCharacterStream(String columnName, Reader reader,int length) throws SQLException {}
	public Object getObject(String columnName) throws SQLException {return null;}
	public void updateObject(String columnName, Object x) throws SQLException {}
	public void updateObject(String columnName, Object x, int scale)throws SQLException {}
	public Object getObject(int i, Map map) throws SQLException {return null;}
	public void updateNull(String columnName) throws SQLException {}
	public void updateString(int columnIndex, String x) throws SQLException {}
	public int findColumn(String columnName) throws SQLException {return 0;}
	
	public void updateRef(String columnName, Ref x) throws SQLException {}
	public void updateTime(String columnName, Time x) throws SQLException {}
	public RowId getRowId(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public RowId getRowId(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public void updateRowId(int columnIndex, RowId x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateRowId(String columnLabel, RowId x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public int getHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}
	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
	public void updateNString(int columnIndex, String nString) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNString(String columnLabel, String nString) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public NClob getNClob(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public NClob getNClob(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public SQLXML getSQLXML(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public SQLXML getSQLXML(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public String getNString(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public String getNString(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Reader getNCharacterStream(int columnIndex) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public Reader getNCharacterStream(String columnLabel) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(int columnIndex, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateClob(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(int columnIndex, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public void updateNClob(String columnLabel, Reader reader) throws SQLException {
		// TODO Auto-generated method stub
		
	}
	public <T> T unwrap(Class<T> iface) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
 
 
 
	public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
	 
	public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
}
