package jreport.uds.javabean.beans;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
//import java.sql.Date;
import java.util.StringTokenizer;
import java.util.Vector;

import jet.datasource.JRUserDataSourceException;
import jreport.uds.javabean.DataCenter;
import jreport.uds.javabean.beans.PutData;


public class PutData
{	
    BufferedReader reader;
	
	/**
	 * Open data file
	 * @param strFileName: file name
	 * @throws JRUserDataSourceException
	 */
	public void readfile(String strFileName) throws JRUserDataSourceException
	    {
	        // Create the values array.
	        try
	        {
	            // Open the file specified in argument.
	            File flAddressList = new File(strFileName);
	            reader = new BufferedReader(new FileReader(flAddressList));  
	        }
	        catch(FileNotFoundException e)
	        {
	            throw new JRUserDataSourceException("File not found. " + strFileName);
	        }	       
	        
	    }

	
	/**
	 * get value list from String
	 * @param record String contain record values.
	 * @return String list of record values
	 */
	private String[] getValuesFromString(String record){		
		String[] values = new String[15];
		int iIndex = 0;	        

        // If the end of file not reach.
        StringTokenizer tokenizer = new StringTokenizer(record, "	",true);

        // In the loop, get each item as token.
		String s2="";
        while(tokenizer.hasMoreTokens())
        {			
			String s1=null;
			s1=tokenizer.nextToken();					
			
			if(s1.compareTo("	")!=0)
			{
				values[iIndex]=s1;	
				iIndex++;
			}
			else if(s1.compareTo("	")==0 && s2.compareTo("	")==0 )
			{
				values[iIndex]=null;	
				iIndex++;
			}
			else
			{
				
			}					   
			s2=s1;					  
          }	
		return values;
	}

	/**
	 * read records from data file to generate person beans
	 * @param reader file reader
	 * @return
	 * @throws JRUserDataSourceException
	 */

	private Vector getResults() throws JRUserDataSourceException{
		Vector v = new Vector();
		String record;
		
		try {
			record = reader.readLine();
			while (record != null){
				if (record.length()!=0){
					v.add(generatePersonBean(getValuesFromString(record)));
				}
				record = reader.readLine();	
			}
		} catch (IOException e) {			
			e.printStackTrace();
			throw new JRUserDataSourceException("Cannot read file.");
		}
		return v;
	}
	
	/**
	 * generate Person bean according to value list
	 * 
	 * @param values String list of record values
	 * @return person bean instance
	 */	
	private Person generatePersonBean(String values[]){
		Person p = new Person();		 
		Name n = new Name();	 
		Address a =new Address();	
		Phone phone=new Phone();
		YesNo yesno=new YesNo();
		
		Date date= new Date(values[0]); 
		p.setBirthDate(new java.sql.Date(date.getTime()));
		
		a.setCity(values[1]);       	
		a.setState(values[2]);    	
	    a.setStreet(values[3]);
	    a.setZipcode(values[4]);	  		
	    p.setCurrentMailingAddress(a);
	   
	    phone.setAreaCode(values[5]);
	    phone.setCountryCode(values[6]);
	    phone.setPhoneNumber(values[7]);
	    p.setCurrentWorkPhone(phone); 		
	
	   
	    p.setEmailAddress(values[8]);
	    p.setGender(values[9]);
	    
	    yesno.setAnswer(new Boolean(values[10]));
	    p.setIsDataVerified(yesno);
	  
	    n.setFirstName(values[11]);
	    n.setLastName(values[12]);	   
	    p.setName(n);
	
	    p.setNewbornWeight(new Long(values[13]));		   
	    p.setSsn(values[14]);	
	    return p;
	}
	
    /**
     * Closes the result set and frees the resource.
     */
    public void close() throws JRUserDataSourceException
    {
        try
        {
            // Close the address file.
            reader.close();
        }
        catch(IOException ioe)
        {
            throw new JRUserDataSourceException("Cannot close the file.");
        }
        return;
    }
	 
	/**
	 * init java bean data in datacenter
	 *
	 */	
	public void initPersonData() 
	{
		boolean temp=true;
		Vector persons;
		try {
			this.readfile(System.getProperty("user.dir")+"\\data.txt");				
			persons = getResults();
			DataCenter.putData("persions",persons, this, 10,0,false);			
			close();
			
		} catch (JRUserDataSourceException e) {
			e.printStackTrace();			
		}	
	}
	
	/**
	 * for test
	 * @param args
	 */
	public static void main(String[] args)
	{
		PutData put=new PutData();
		put.initPersonData();
		
	}
}