package help;

import java.sql.*;

public class AddressListResultSetMetaData implements ResultSetMetaData 
{
	/**
	 * The column name of the ResultSet.
	 */ 
	String[] colName = new String[]{"Firstname",
									"Lastname", 
									"Address",
									"City", 
									"StateOrProvince", 
									"PostalCode",
									"Country",
									"EmailAddress", 
									"HomePhone", 
									"WorkPhone", 
									"FaxNumber" };

	/**
	 * Constuctor.
	 */
    public AddressListResultSetMetaData ()
	{
		;
	}

	/**
	 * Return the number of columns.
	 */
	public int getColumnCount()
	{
		return colName.length;
	}
	
	/**
	 * Return the name of column regarding as the index.
	 */
    public String getColumnName(int column) throws SQLException
	{
		if (column <= 0 || column > getColumnCount())
		{
			throw new SQLException("The index is out of bound");
		}
		return colName[column-1];
	}

	/**
	 * Return the data type of the column.
	 */
	public int getColumnType(int column) throws SQLException
	{
		if (column <= 0 || column > getColumnCount())
		{
			throw new SQLException("The index is out of bound");
		}

		// The data type of all columns is VARCHAR.
		return java.sql.Types.VARCHAR;
	}

	/**
	 * Return the name of data type.
	 */
    public String getColumnTypeName(int column)
	{
		return "String";
	}

	/**
	 * Return the precision of the column.
	 */
	public int getPrecision(int column)
	{
		// the precision of all columns is 10.
		return 10;
	}

	/**
	 * Return the length of the column.
	 */
	public int getColumnDisplaySize(int column)
	{
		// the length of all columns is 10.
		return 10;
	}

	/**
	 * Return the scale of the column.
	 */
	public int getScale(int column)
	{
		return 0;
	}

	/**
	 * Return the nullable state of the column.
	 */
	public int isNullable(int column)
	{
		return ResultSetMetaData.columnNoNulls;
	}
    
    /**
	 * The methods below are not used in JReport.
	 */
	public String getColumnLabel(int column) {return null;};	
	public boolean isSigned(int column) {return false;};
    public String getSchemaName(int column) {return null;};
    public String getTableName(int column) {return null;};
    public String getCatalogName(int column) {return null;};
    public boolean isReadOnly(int column) {return false;};
    public boolean isWritable(int column) {return false;};
    public boolean isDefinitelyWritable(int column) {return false;};
	public boolean isAutoIncrement(int column) {return false;};
	public boolean isCaseSensitive(int column) {return false;};	
	public boolean isSearchable(int column) {return false;};
	public boolean isCurrency(int column) {return false;};
    

    //--------------------------JDBC 2.0-----------------------------------
    public String getColumnClassName(int column) {return null;}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	};
}
