/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.datasource.xml;

import com.jinfonet.api.datatypes.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import jet.dataengine.api.DSException;

public class DataConverterImpl {
    private static final byte[] QOIV = DataConverterImpl.append();
    private static final char[] append = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    public static String parseString(String string) {
        return string;
    }

    public static int parseInt(String string) throws DSException {
        int n = string.length();
        int n2 = 1;
        int n3 = 0;
        if (n == 0 || string == null) {
            throw new DSException(11622, new String[]{string + " is not an int value."});
        }
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (!DataConverterImpl.isBlankSpace(c)) {
                if ('0' <= c && c <= '9') {
                    n3 = n3 * 10 + (c - 48);
                } else if (c == '-') {
                    n2 = -1;
                } else if (c != '+') {
                    throw new DSException(11614, new String[]{string + " is not an int value."});
                }
            }
            ++n4;
        }
        return n3 * n2;
    }

    public static short parseShort(String string) throws DSException {
        return (short)DataConverterImpl.parseInt(string);
    }

    public static long parseLong(String string) throws DSException {
        long l = 0L;
        try {
            l = Long.valueOf(DataConverterImpl.equals(string).trim());
        }
        catch (Exception exception) {
            throw new DSException(11626, new String[]{string + " is not a long value.", exception.getMessage()});
        }
        return l;
    }

    public static BigInteger parseInteger(String string) throws DSException {
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(DataConverterImpl.equals(string).toString());
        }
        catch (Exception exception) {
            throw new DSException(11627, new String[]{string + " is not a big int value.", exception.getMessage()});
        }
        return bigInteger;
    }

    public static BigDecimal parseDecimal(String string) throws DSException {
        int n;
        String string2 = string.trim();
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string2);
        }
        catch (Exception exception) {
            throw new DSException(11628, new String[]{string + " is not a decimal value.", exception.getMessage()});
        }
        int n2 = Types.getMaxPrecision(3);
        int n3 = n2 - 1;
        if (string.indexOf(43) != -1) {
            string2 = string2.replaceAll("\\+", "");
        }
        if (string2.indexOf(45) != -1) {
            string2 = string2.replaceAll("-", "");
        }
        if (string2.indexOf(46) != -1) {
            string2 = string2.replaceAll("\\.", "");
        }
        if ((n = string2.length()) > n2 || bigDecimal.scale() > n3) {
            throw new DSException(11619, new String[]{"the max precision of decimal in xml is: " + n2, " but current precision is:" + n + ".", " the max scale of decimal in xml is: " + n3, " but current scale is:" + bigDecimal.scale() + "."});
        }
        return bigDecimal;
    }

    public static float parseFloat(String string) throws DSException {
        String string2 = string.trim();
        if (string2.equals("NaN")) {
            return Float.NaN;
        }
        if (string2.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string2.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (string2.length() == 0 || !DataConverterImpl.equalsIgnoreCase(string2.charAt(0)) || !DataConverterImpl.equalsIgnoreCase(string2.charAt(string2.length() - 1))) {
            throw new DSException(11615, new String[]{string + " is not a flaot value."});
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (Exception exception) {
            throw new DSException(11629, new String[]{string + " is not a float value.", exception.getMessage()});
        }
        if (Float.isNaN(f)) {
            throw new DSException(11620, new String[]{"XML can not support NaN value."});
        }
        return f;
    }

    public static double parseDouble(String string) throws DSException {
        if ((string = string.trim()).equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DataConverterImpl.equalsIgnoreCase(string.charAt(0)) || !DataConverterImpl.equalsIgnoreCase(string.charAt(string.length() - 1))) {
            throw new DSException(11616, new String[]{string + " is not a double value."});
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new DSException(11630, new String[]{string + " is not a double value.", exception.getMessage()});
        }
        if (Double.isNaN(d)) {
            throw new DSException(11621, new String[]{"XML can not support NaN value."});
        }
        return d;
    }

    public static boolean parseBoolean(String string) throws DSException {
        char c;
        String string2 = string.trim();
        int n = 0;
        int n2 = string2.length();
        while (DataConverterImpl.isBlankSpace(c = string2.charAt(n++)) && n < n2) {
        }
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || c == '1') {
            return true;
        }
        if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no") || c == '0') {
            return false;
        }
        throw new DSException(11631, new String[]{string + " is not a boolean value."});
    }

    public static byte parseByte(String string) throws DSException {
        return (byte)DataConverterImpl.parseInt(string);
    }

    public static byte[] parseHexBinary(String string) throws DSException {
        int n = string.length();
        if (n % 2 != 0) {
            throw new DSException(11632, new String[]{string + " is not valid HexBinary. The value length must multiple of 2."});
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = DataConverterImpl.getMaxPrecision(string.charAt(n2));
            int n4 = DataConverterImpl.getMaxPrecision(string.charAt(n2 + 1));
            if (n3 == -1 || n4 == -1) {
                return null;
            }
            byArray[n2 / 2] = (byte)(n3 * 16 + n4);
            n2 += 2;
        }
        return byArray;
    }

    public static byte[] parseBase64Binary(String string) throws DSException {
        String string2 = string.trim();
        int n = DataConverterImpl.QOIV(string2);
        if (n == -1) {
            throw new DSException(11633, new String[]{"The baseCode has invalid char."});
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = string2.length();
        byte[] byArray2 = new byte[4];
        int n4 = 0;
        try {
            int n5 = 0;
            while (n5 < n3) {
                char c = string2.charAt(n5);
                byte by = QOIV[c];
                if (by != -1) {
                    byArray2[n4++] = by;
                }
                if (n4 == 4) {
                    byArray[n2++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                    if (byArray2[2] != 127) {
                        byArray[n2++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                    }
                    if (byArray2[3] != 127) {
                        byArray[n2++] = (byte)(byArray2[2] << 6 | byArray2[3]);
                    }
                    n4 = 0;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            throw new DSException(11634, new String[]{exception.getMessage()});
        }
        return byArray;
    }

    private static int QOIV(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '=') break;
            if (c >= '\u0080') {
                return -1;
            }
            if (QOIV[c] != -1) {
                ++n2;
            }
            ++n3;
        }
        return n2 / 4 * 3 + Math.max(0, n2 % 4 - 1);
    }

    private static byte[] append() {
        byte[] byArray = new byte[128];
        int n = 0;
        while (n < 128) {
            byArray[n] = -1;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            byArray[n] = (byte)(n - 65);
            ++n;
        }
        n = 97;
        while (n <= 122) {
            byArray[n] = (byte)(n - 97 + 26);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            byArray[n] = (byte)(n - 48 + 52);
            ++n;
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    public static long parseUnsignedInt(String string) throws DSException {
        return DataConverterImpl.parseLong(string);
    }

    public static int parseUnsignedShort(String string) throws DSException {
        return DataConverterImpl.parseInt(string);
    }

    public static Date parseTime(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public Date parseDate(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public Date parseDateTime(String string, String string2) throws DSException {
        throw new UnsupportedOperationException();
    }

    public String parseAnySimpleType(String string) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal parseCoinType(String string) throws DSException {
        char c = string.charAt(0);
        if (c != '$') {
            throw new NumberFormatException(string + " is not a coin value.");
        }
        string = string.substring(1, string.length());
        return new BigDecimal(DataConverterImpl.charAt(string));
    }

    private static double charAt(String string) throws DSException {
        int n;
        int n2 = string.length();
        int n3 = 1;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n5 = 0;
        while (n5 < n2) {
            n = string.charAt(n5);
            if (n == 46) {
                n4 = n5;
                break;
            }
            if (!DataConverterImpl.isBlankSpace((char)n) && n != 44) {
                if (48 <= n && n <= 57) {
                    d = d * 10.0 + (double)(n - 48);
                } else if (n == 45) {
                    n3 = -1;
                } else if (n != 43) {
                    throw new DSException(11617, new String[]{string + " is not a double value."});
                }
            }
            ++n5;
        }
        n = n2 - 1;
        while (n > n4) {
            char c = string.charAt(n);
            if (!DataConverterImpl.isBlankSpace(c) && c != ',') {
                if ('0' <= c && c <= '9') {
                    d2 = d2 * 1.0 / 10.0 + (double)(c - 48) / 10.0;
                } else {
                    throw new DSException(11618, new String[]{string + " is not a double value."});
                }
            }
            --n;
        }
        return (double)n3 * (d + d2);
    }

    public static final boolean isBlankSpace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    private static String equals(String string) {
        int n = string.length();
        if (n <= 1 || string.charAt(0) != '+') {
            return string;
        }
        char c = (string = (String)string.subSequence(1, n)).charAt(0);
        if ('0' <= c && c <= '9') {
            return string;
        }
        if ('.' == c) {
            return string;
        }
        throw new NumberFormatException();
    }

    private static boolean equalsIgnoreCase(char c) {
        if (c == '+' || c == '.' || c == '-') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private static int getMaxPrecision(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }
}

