/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbDataField;
import com.jinfonet.dataservice.expression.variable.ParameterImpl;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import java.util.Date;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IConditionExpression;
import jet.dataengine.api.expression.tuple.ILogicExpression;
import jet.dataengine.api.expression.tuple.IMultiTupleExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.pushdown.ExpPushDownParser;
import jet.dataengine8.core.queryengine.querybuilder.info.NamingTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.universe.JetUSupportInfo;

class SQL92PushDownParser
extends ExpPushDownParser {
    protected SQL92PushDownParser(ResourceContainer resourceContainer, JDSConnection jDSConnection, JetUSupportInfo jetUSupportInfo) throws DSException {
        super(resourceContainer, jDSConnection, jetUSupportInfo);
    }

    public String getSQLConditionString() throws DSException {
        if (this.filterString == null) {
            if (this.pushFilterExps.size() < 1) {
                return null;
            }
            if (this.pushFilterExps.size() == 1) {
                this.filterString = this.append((IExpression)this.pushFilterExps.get(0));
            } else {
                String[] stringArray = new String[this.pushFilterExps.size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = this.append((IExpression)this.pushFilterExps.get(n));
                    ++n;
                }
                this.filterString = this.QOIV(stringArray);
            }
        }
        return this.filterString;
    }

    private String QOIV(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("(");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(")");
            if (n < stringArray.length - 1) {
                stringBuffer.append(" ");
                stringBuffer.append("AND");
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private String append(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return this.getDataType(iExpression);
        }
        if (ExpressionToolKit.isLogicExp(iExpression.expressionType())) {
            return this.expressionType((ILogicExpression)iExpression);
        }
        if (ExpressionToolKit.isConditionExp(iExpression.expressionType())) {
            return this.connection((IConditionExpression)iExpression);
        }
        throw new DSException(2520, new Object[]{"local condition exp type error : " + iExpression.expressionType()});
    }

    private String connection(IConditionExpression iConditionExpression) throws DSException {
        if (ExpressionToolKit.isSingleConditionExp(iConditionExpression.expressionType())) {
            return this.convertDateString((ISingleConditionExpression)iConditionExpression);
        }
        if (ExpressionToolKit.isBinaryConditionExp(iConditionExpression.expressionType())) {
            return this.equalsIgnoreCase((IBinaryConditionExpression)iConditionExpression);
        }
        if (ExpressionToolKit.isTripleConditonExp(iConditionExpression.expressionType())) {
            return this.containsIgnoreCase((ITripleConditionExpression)iConditionExpression);
        }
        throw new DSException(2521, new Object[]{"condition exp type error : " + iConditionExpression.expressionType()});
    }

    private String containsIgnoreCase(ITripleConditionExpression iTripleConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iTripleConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDSName(iTripleConditionExpression.getExpression1()));
        stringBuffer.append(" ");
        if (OperatorToolKit.isBetween(iTupleOperator.operatorType())) {
            stringBuffer.append("BETWEEN");
        } else if (OperatorToolKit.isNotBetween(iTupleOperator.operatorType())) {
            stringBuffer.append("NOT");
            stringBuffer.append(" ");
            stringBuffer.append("BETWEEN");
        } else {
            throw new DSException(2522, new Object[]{"triple condition op type error : " + iTupleOperator.operatorType()});
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getDSName(iTripleConditionExpression.getExpression2()));
        stringBuffer.append(" ");
        stringBuffer.append("AND");
        stringBuffer.append(" ");
        stringBuffer.append(this.getDSName(iTripleConditionExpression.getExpression3()));
        return stringBuffer.toString();
    }

    private String convertDateString(ISingleConditionExpression iSingleConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iSingleConditionExpression.getOperator();
        if (OperatorToolKit.isNull(iTupleOperator.operatorType())) {
            return this.append(iSingleConditionExpression.getExpression()) + " " + "IS NULL";
        }
        if (OperatorToolKit.isNotNull(iTupleOperator.operatorType())) {
            return this.append(iSingleConditionExpression.getExpression()) + " " + "IS NOT NULL";
        }
        throw new DSException(2523, new Object[]{"single condition op type error : " + iTupleOperator.operatorType()});
    }

    private String equalsIgnoreCase(IBinaryConditionExpression iBinaryConditionExpression) throws DSException {
        ITupleOperator iTupleOperator = iBinaryConditionExpression.getOperator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDSName(iBinaryConditionExpression.getExpression1()));
        stringBuffer.append(" ");
        switch (iTupleOperator.operatorType()) {
            case 556793872: {
                stringBuffer.append("=");
                break;
            }
            case 556793888: {
                stringBuffer.append("<>");
                break;
            }
            case 556794112: {
                stringBuffer.append("<");
                break;
            }
            case 556794368: {
                stringBuffer.append("<=");
                break;
            }
            case 556793984: {
                stringBuffer.append(">=");
                break;
            }
            case 556793920: {
                stringBuffer.append(">");
                break;
            }
            case 556793857: {
                stringBuffer.append("IN");
                break;
            }
            case 556793858: {
                stringBuffer.append("NOT");
                stringBuffer.append(" ");
                stringBuffer.append("IN");
                break;
            }
            case 556793860: {
                stringBuffer.append("LIKE");
                break;
            }
            case 556793864: {
                stringBuffer.append("NOT");
                stringBuffer.append(" ");
                stringBuffer.append("LIKE");
                break;
            }
            default: {
                throw new DSException(2524, new Object[]{"binary condition op type error : " + iTupleOperator.operatorType()});
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getDSName(iBinaryConditionExpression.getExpression2()));
        return stringBuffer.toString();
    }

    private String expressionType(ILogicExpression iLogicExpression) throws DSException {
        if (OperatorToolKit.isSingleLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.get((ISingleLogicExpression)iLogicExpression);
        }
        if (OperatorToolKit.isMultiLogicOperator(iLogicExpression.getOperator().operatorType())) {
            return this.filterString((IMultiTupleExpression)((Object)iLogicExpression));
        }
        throw new DSException(2525, new Object[]{"logic exp type error : " + iLogicExpression.expressionType()});
    }

    private String filterString(IMultiTupleExpression iMultiTupleExpression) throws DSException {
        IExpression[] iExpressionArray = iMultiTupleExpression.getExpressions();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (OperatorToolKit.isOr(iMultiTupleExpression.getOperator().operatorType())) {
            string = "OR";
        } else if (OperatorToolKit.isAnd(iMultiTupleExpression.getOperator().operatorType())) {
            string = "AND";
        } else {
            throw new DSException(2526, new Object[]{"multiple logic exp type error : " + iMultiTupleExpression.expressionType()});
        }
        stringBuffer.append(this.getDSName(iExpressionArray[0]));
        int n = 1;
        while (n < iExpressionArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.getDSName(iExpressionArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String get(ISingleLogicExpression iSingleLogicExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        IExpression iExpression = iSingleLogicExpression.getExpression();
        try {
            if (iExpression instanceof IConstant && (((IConstant)iExpression).getValue().equalsIgnoreCase("true") || ((IConstant)iExpression).getValue().equalsIgnoreCase("false"))) {
                if (((IConstant)iExpression).getValue().equalsIgnoreCase("true")) {
                    stringBuffer.append(" 1<>1 ");
                } else {
                    stringBuffer.append(" 1=1 ");
                }
            } else {
                stringBuffer.append("NOT");
                stringBuffer.append(" ");
                stringBuffer.append(this.getDSName(iSingleLogicExpression.getExpression()));
            }
            return stringBuffer.toString();
        }
        catch (ConditionException conditionException) {
            throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
        }
    }

    private String getDSName(IExpression iExpression) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            stringBuffer.append("(");
        }
        stringBuffer.append(this.append(iExpression));
        if (!ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getDataType(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType())) {
            return this.getExpression2(iExpression);
        }
        if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
            return this.getExpression((IConstant)iExpression);
        }
        if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            return this.getExpression1((IVariableList)iExpression);
        }
        if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
            return this.getExpression2(iExpression);
        }
        throw new DSException(2527, new Object[]{"sub exp type error : " + iExpression.expressionType()});
    }

    private String getExpression(IConstant iConstant) throws DSException {
        try {
            if (Types.isTimeType(iConstant.getDataType())) {
                if (iConstant.getValue() == null) {
                    throw new DSException(2528, new Object[]{"constant date value was null"});
                }
                return QueryTransform.convertDateString((Date)iConstant.getObjectValue(), iConstant.getDataType(), this.supportInfo);
            }
            if (Types.isStringType(iConstant.getDataType())) {
                return StringTools.getSQLString4pushdownParser(iConstant.getValue());
            }
            return this.getFormulaPushDownString(iConstant.getValue());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2529, new Object[]{"ConditionException"}, conditionException);
        }
    }

    private String getExpression1(IVariableList iVariableList) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        try {
            int n = 0;
            while (n < iVariableList.size()) {
                stringBuffer.append(this.append(iVariableList.getVariableExp(n)));
                if (n < iVariableList.size() - 1) {
                    stringBuffer.append(",");
                    stringBuffer.append(" ");
                }
                ++n;
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2530, new Object[]{"ConditionException"}, conditionException);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getExpression2(IExpression iExpression) throws DSException {
        String string;
        block11: {
            string = null;
            try {
                if (this.resource.containsIgnoreCase(iExpression.getName())) {
                    if (ExpressionToolKit.isReference(iExpression.expressionType())) {
                        this.resource.getStringValue();
                        if (!this.resource.wasField()) {
                            throw new DSException(2531, new Object[]{string + " is not db field"});
                        }
                        JAttribute jAttribute = this.resource.getJAttribute();
                        if (!(jAttribute instanceof JRdbDataField)) {
                            throw new DSException(2532, new Object[]{iExpression.getName() + " not rdb data field"});
                        }
                        string = NamingTools.getDSName((RdbConnection)this.connection, (JRdbDataField)jAttribute);
                    } else if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
                        string = this.resource.getFormulaPushDownString();
                        if (!this.resource.wasFormula()) {
                            throw new DSException(2533, new Object[]{string + " is not formula"});
                        }
                    } else if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
                        ParameterImpl parameterImpl = (ParameterImpl)iExpression;
                        string = parameterImpl.getStringValue(true);
                    }
                    break block11;
                }
                throw new DSException(2534, new Object[]{"internal error, can not found " + string + " in resource container"});
            }
            catch (ConditionException conditionException) {
                throw new DSException(2535, new Object[]{"ConditionException"}, conditionException);
            }
        }
        return string;
    }

    public String getSQLSortString() throws DSException {
        if (this.sortString == null) {
            if (this.pushSortExp == null) {
                return null;
            }
            ISortInformation[] iSortInformationArray = null;
            IOperatorInformation iOperatorInformation = ((ISortOperator)this.pushSortExp.getOperator()).getOperatorInformation();
            if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
                ISortInformation iSortInformation = (ISortInformation)iOperatorInformation;
                iSortInformationArray = new ISortInformation[]{iSortInformation};
            } else if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
                ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
                iSortInformationArray = new ISortInformation[iSortInformationCollector.size()];
                int n = 0;
                while (n < iSortInformationArray.length) {
                    iSortInformationArray[n] = iSortInformationCollector.getSortInformation(n);
                    ++n;
                }
            }
            this.sortString = this.getExpression3(iSortInformationArray);
        }
        return this.sortString;
    }

    private String getExpression3(ISortInformation[] iSortInformationArray) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < iSortInformationArray.length) {
            if (iSortInformationArray[n].getSortType() != 0) {
                stringBuffer.append(this.getExpression2(iSortInformationArray[n].getReference()));
                stringBuffer.append(" ");
                stringBuffer.append(this.getExpressions(iSortInformationArray[n]));
                if (n < iSortInformationArray.length - 1) {
                    stringBuffer.append(",");
                    stringBuffer.append(" ");
                }
            }
            ++n;
        }
        return stringBuffer.length() < 1 ? null : stringBuffer.toString().trim();
    }

    private String getExpressions(ISortInformation iSortInformation) throws DSException {
        if (iSortInformation.getSortType() == 1) {
            return "ASC";
        }
        if (iSortInformation.getSortType() == 2) {
            return "DESC";
        }
        throw new DSException(2536, new Object[]{"sort type error : " + iSortInformation.getSortType()});
    }

    private String getFormulaPushDownString(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (Character.isWhitespace(cArray[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return "'" + string + "'";
        }
        return string;
    }

    public String getSQLTopNString() throws DSException {
        throw new UnsupportedOperationException();
    }
}

