/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.Detail;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.MeasureMember;
import jet.dataengine.api.schema.olap.JCube;
import jet.dataengine.api.schema.olap.metadata.JDimension;
import jet.dataengine.api.schema.olap.metadata.JMeasure;
import jet.dataengine.util.DSLog;
import jet.dataengine8.olap.core.CoordinateCalculator;
import jet.dataengine8.olap.core.CubeInstanceManager;
import jet.dataengine8.olap.core.DimensionInstance;
import jet.dataengine8.olap.core.LeafLayer;
import jet.dataengine8.olap.core.node.AAggregatorNode;
import jet.dataengine8.olap.core.node.ACalculator;
import jet.dataengine8.olap.core.node.ALeafNodeAggregator;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.AggregatorFactory;
import jet.dataengine8.olap.core.node.CalculatorFactory;
import jet.dataengine8.olap.core.node.Node;
import jet.dataengine8.olap.core.node.NodeHashMap;
import jet.dataengine8.olap.core.node.NodeMetaData;
import jet.dataengine8.util.OneDimensionIntArrayList;

public class CubeInstance {
    public static final int UNPROCESSED = 0;
    public static final int PROCESSING = 1;
    public static final int PROCESSED = 2;
    public static final String[] StateName = new String[]{"UNPROCESSED", "PROCESSING", "PROCESSED"};
    public final int ID;
    private final JCube QOIV;
    private final boolean add;
    private final boolean addRowID;
    private final boolean addValue;
    private final MeasureMember[] aggregate;
    private final Detail[] append;
    private final ARelation arraycopy;
    private final DSLog beforeFirst = DSLog.getDSLog(this.getClass().getName());
    private final int calculateRadix;
    private final int clear;
    private final DimensionInstance[] close;
    private final long[] comapreDimensions;
    private final NodeHashMap copy = new NodeHashMap();
    private volatile int createAggregator = 0;
    private volatile int createAggregatorNode = 0;
    private List createCalculator = new ArrayList();
    private NodeMetaData createIfNeeded = null;
    private ALeafNodeAggregator[] createLayer = null;
    private AAggregatorNode[] createRelation = null;
    private ACalculator[] deIndent = null;
    private JMeasure[] debug = null;
    private HashMap dump = new HashMap();
    private CubeInstanceManager equalsIgnoreCase = null;
    private boolean findColumn = false;

    public CubeInstance(JCube jCube, IRelationData iRelationData, JCubeQuery jCubeQuery, CubeInstanceManager cubeInstanceManager) throws DSException {
        this.beforeFirst.debug("CubeInstance(JCube cube, IRelationData relationData, JCubeQuery cubeQuery)");
        this.ID = jCubeQuery.getCubeQueryId();
        this.equalsIgnoreCase = cubeInstanceManager;
        this.add = jCubeQuery.getOption().isPushdownGroup();
        this.addRowID = jCubeQuery.getOption().isPushdownOrder();
        this.addValue = jCubeQuery.getOption().isValueChange();
        this.aggregate = jCubeQuery.getMeasureMembers();
        this.append = jCubeQuery.getDetails();
        this.QOIV = jCube.copy();
        this.arraycopy = iRelationData.createRelation();
        JDimension[] jDimensionArray = jCube.getDimensions();
        this.calculateRadix = jDimensionArray.length;
        if (this.calculateRadix < 1) {
            throw new DSException(3021);
        }
        this.close = new DimensionInstance[this.calculateRadix];
        int n = 0;
        while (n < this.calculateRadix) {
            this.close[n] = new DimensionInstance(jDimensionArray[n], this.arraycopy);
            ++n;
        }
        JRelationMetaData jRelationMetaData = this.arraycopy.getMetaData();
        this.debug = jCube.getMeasures();
        this.clear = this.debug.length;
        this.createLayer = new ALeafNodeAggregator[this.clear];
        this.createRelation = new AAggregatorNode[this.clear];
        this.deIndent = new ACalculator[this.clear];
        String[] stringArray = new String[this.clear];
        int[] nArray = new int[this.clear];
        int n2 = 0;
        while (n2 < this.clear) {
            JAttribute jAttribute = this.debug[n2].getDefaultAttribute();
            this.createLayer[n2] = AggregatorFactory.createAggregator(jAttribute, n2, jRelationMetaData, this.add);
            this.createRelation[n2] = AggregatorFactory.createAggregatorNode(jAttribute, n2);
            this.deIndent[n2] = CalculatorFactory.createCalculator(iRelationData, jRelationMetaData.findColumn(jAttribute.getAliasName()), n2, jAttribute.getDataType());
            stringArray[n2] = jAttribute.getAliasName();
            nArray[n2] = jAttribute.getDataType();
            ++n2;
        }
        this.createIfNeeded = new NodeMetaData(stringArray, nArray);
        this.comapreDimensions = new long[this.calculateRadix - 1];
        this.beforeFirst.debug("CubeInstance(JCube cube, IRelationData relationData, JCubeQuery cubeQuery) end");
    }

    public AAggregatorNode[] getAggregatorNodes() {
        return this.createRelation;
    }

    public ACalculator[] getCalculators() {
        return this.deIndent;
    }

    public ACalculator getCalculator(JAttribute jAttribute) throws DSException {
        int n = 0;
        while (n < this.clear) {
            if (jAttribute.getAliasName().equalsIgnoreCase(this.debug[n].getDefaultAttribute().getAliasName())) {
                return this.deIndent[n];
            }
            ++n;
        }
        throw new DSException(3022, new String[]{jAttribute.getAliasName()});
    }

    public ACalculator getCalculator(String string) throws DSException {
        int n = 0;
        while (n < this.clear) {
            if (string.equalsIgnoreCase(this.debug[n].getDefaultAttribute().getAliasName())) {
                return this.deIndent[n];
            }
            ++n;
        }
        throw new DSException(3022, new String[]{string});
    }

    public synchronized void createIfNeeded() throws DSException {
        try {
            switch (this.createAggregator) {
                case 2: {
                    return;
                }
                case 0: {
                    this.createAggregator = 1;
                    this.ID();
                    this.createAggregator = 2;
                    return;
                }
                case 1: {
                    throw new RuntimeException("state == PROCESSING");
                }
            }
            throw new RuntimeException();
        }
        catch (DSException dSException) {
            this.equalsIgnoreCase.removeCubeInstance(this);
            throw dSException;
        }
        catch (RuntimeException runtimeException) {
            this.equalsIgnoreCase.removeCubeInstance(this);
            throw runtimeException;
        }
    }

    public synchronized LeafLayer getLayer(JCube jCube, boolean bl) throws DSException {
        this.createIfNeeded();
        int n = this.createCalculator.size() - 1;
        while (n >= 0) {
            LeafLayer leafLayer = (LeafLayer)this.createCalculator.get(n);
            int n2 = leafLayer.getCube().comapreDimensions(jCube);
            switch (n2) {
                case 0: {
                    if (bl) {
                        return leafLayer.createLayer(jCube, false);
                    }
                    return leafLayer;
                }
                case 1: {
                    LeafLayer leafLayer2 = leafLayer.createLayer(jCube, true);
                    if (n < this.createCalculator.size() - 1) {
                        this.createCalculator.add(n + 1, leafLayer2);
                    } else {
                        this.createCalculator.add(leafLayer2);
                    }
                    return leafLayer2;
                }
            }
            --n;
        }
        throw new DSException(3023);
    }

    public ARelation getRelation() {
        return this.arraycopy;
    }

    public JCube getCube() throws DSException {
        return this.QOIV;
    }

    public DimensionInstance[] getDimensionInstancesCopy() throws DSException {
        DimensionInstance[] dimensionInstanceArray = new DimensionInstance[this.calculateRadix];
        int n = 0;
        while (n < this.calculateRadix) {
            dimensionInstanceArray[n] = new DimensionInstance(this.close[n]);
            ++n;
        }
        return dimensionInstanceArray;
    }

    public DimensionInstance[] getDimensionInstances() {
        return this.close;
    }

    public MeasureMember[] getMeasureMembers() {
        return this.aggregate;
    }

    public NodeMetaData getNodeMetaData() {
        return this.createIfNeeded;
    }

    public NodeHashMap getAllLeafNodes() throws DSException {
        return this.copy;
    }

    public long[] getRadixCopy() {
        long[] lArray = new long[this.comapreDimensions.length];
        System.arraycopy(this.comapreDimensions, 0, lArray, 0, this.comapreDimensions.length);
        return lArray;
    }

    public synchronized void addReference() {
        ++this.createAggregatorNode;
    }

    public synchronized void destroy() throws DSException {
        --this.createAggregatorNode;
        if (this.createAggregatorNode > 0) {
            return;
        }
        if (this.arraycopy != null) {
            this.arraycopy.close();
        }
        int n = 0;
        while (n < this.calculateRadix) {
            this.close[n] = null;
            ++n;
        }
        this.copy.clear();
    }

    public void dump(int n) {
        this.beforeFirst.indent("CubeInstance");
        this.beforeFirst.debug("CubeInstance: ");
        this.beforeFirst.indent("CubeInstance");
        this.beforeFirst.debug("State: " + StateName[this.createAggregator]);
        this.QOIV.dump();
        this.beforeFirst.debug("dimension: " + this.calculateRadix);
        int n2 = 0;
        while (n2 < this.close.length) {
            this.close[n2].dump();
            ++n2;
        }
        this.beforeFirst.deIndent("CubeInstance");
        this.beforeFirst.debug("end CubeInstance");
        this.beforeFirst.deIndent("CubeInstance");
    }

    private void ID() throws DSException {
        try {
            int n;
            this.beforeFirst.debug("begin CubeInstance.createCube()");
            this.beforeFirst.indent("CubeInstance");
            this.beforeFirst.debug("isAggregation = " + this.add);
            this.beforeFirst.debug("begin Aggregate record to cube");
            this.arraycopy.beforeFirst();
            block4: while (this.arraycopy.next()) {
                if (this.findColumn) break;
                ArrayHashKey arrayHashKey = this.add();
                n = 0;
                while (n < this.calculateRadix) {
                    int n2 = this.close[n].I(this.arraycopy);
                    if (n2 == -1) continue block4;
                    arrayHashKey.addValue(n2);
                    ++n;
                }
                this.QOIV(this.arraycopy, arrayHashKey);
            }
            n = 0;
            while (n < this.calculateRadix) {
                this.close[n].I();
                ++n;
            }
            this.StateName();
            this.beforeFirst.debug("end Aggregate record to cube");
            Object var5_6 = null;
            this.beforeFirst.deIndent("CubeInstance");
            this.beforeFirst.debug("end CubeInstance.createCube()");
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.beforeFirst.deIndent("CubeInstance");
            this.beforeFirst.debug("end CubeInstance.createCube()");
            throw throwable;
        }
        LeafLayer leafLayer = new LeafLayer(this, this.copy, this.close, this.comapreDimensions);
        leafLayer.setCube(this.QOIV);
        this.createCalculator.add(leafLayer);
    }

    public void addLayer(LeafLayer leafLayer) {
        this.createCalculator.add(leafLayer);
    }

    private void QOIV(ARelation aRelation, ArrayHashKey arrayHashKey) throws DSException {
        ANode aNode = (ANode)this.dump.get(arrayHashKey);
        if (aNode == null) {
            aNode = new Node(0L, this.createIfNeeded, false);
            aNode.setRowID(new OneDimensionIntArrayList());
            this.dump.put(arrayHashKey, aNode);
        }
        aNode.addRowID(aRelation.getCurrentRowID());
        if (this.add) {
            int n = 0;
            while (n < this.clear) {
                this.createLayer[n].update(aNode, aRelation);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.clear) {
                this.createLayer[n].aggregate(aNode, aRelation);
                ++n;
            }
        }
    }

    private void StateName() throws DSException {
        this.addRowID();
        int[] nArray = new int[this.calculateRadix];
        Set set = this.dump.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ArrayHashKey arrayHashKey = (ArrayHashKey)iterator.next();
            Node node = (Node)this.dump.get(arrayHashKey);
            long l = arrayHashKey.toCoordinate(nArray);
            node.setKey(l);
            this.copy.put(l, node);
        }
        this.dump.clear();
        this.dump = null;
    }

    private ArrayHashKey add() {
        return new ShortArrayHashKey(this);
    }

    private void addRowID() throws DSException {
        int[] nArray = new int[this.calculateRadix];
        int n = 0;
        while (n < this.calculateRadix) {
            nArray[n] = this.close[n].getMemberCount();
            ++n;
        }
        CoordinateCalculator.calculateRadix(nArray, this.comapreDimensions);
    }

    public void cancel() {
        this.findColumn = true;
    }

    static int access$000(CubeInstance cubeInstance) {
        return cubeInstance.calculateRadix;
    }

    static long[] access$100(CubeInstance cubeInstance) {
        return cubeInstance.comapreDimensions;
    }

    class ShortArrayHashKey
    extends ArrayHashKey {
        short[] QOIV;
        int access$000;
        private final CubeInstance this$0;

        ShortArrayHashKey(CubeInstance cubeInstance) {
            this.this$0 = cubeInstance;
            super(cubeInstance);
            this.QOIV = new short[CubeInstance.access$000(this.this$0)];
            this.access$000 = 0;
        }

        void addValue(int n) {
            if (n <= Short.MAX_VALUE) {
                this.QOIV[this.access$000] = (short)n;
            } else {
                short[] sArray = this.QOIV;
                this.QOIV = new short[sArray.length + 1];
                System.arraycopy(sArray, 0, this.QOIV, 0, this.access$000);
                this.QOIV[this.access$000] = (short)(0x8000 | n >> 15);
                this.QOIV[++this.access$000] = (short)(n & Short.MAX_VALUE);
            }
            ++this.access$000;
        }

        long toCoordinate(int[] nArray) {
            if (this.QOIV.length == CubeInstance.access$000(this.this$0)) {
                return CoordinateCalculator.convertToDecimal(CubeInstance.access$100(this.this$0), this.QOIV);
            }
            int n = 0;
            int n2 = 0;
            while (n < CubeInstance.access$000(this.this$0)) {
                int n3 = this.QOIV[n2];
                nArray[n] = (n3 & 0x8000) == 0 ? n3 : (n3 & Short.MAX_VALUE) << 15 | this.QOIV[++n2] & Short.MAX_VALUE;
                ++n;
                ++n2;
            }
            return CoordinateCalculator.convertToDecimal(CubeInstance.access$100(this.this$0), nArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            short[] sArray = ((ShortArrayHashKey)object).QOIV;
            if (this.QOIV.length != sArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.QOIV.length) {
                if (this.QOIV[n] != sArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.QOIV.length) {
                n = 31 * n + (this.QOIV[n2] & 0xFFFF);
                ++n2;
            }
            return n;
        }
    }

    abstract class ArrayHashKey {
        private final CubeInstance this$0;

        ArrayHashKey(CubeInstance cubeInstance) {
            this.this$0 = cubeInstance;
        }

        abstract void addValue(int var1);

        abstract long toCoordinate(int[] var1);
    }
}

