/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.util.JRLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class SignatureTools {
    public static final int Status_OK = 100;
    public static final int Status_PasswordIncorrect = 101;
    public static final int Status_DigitalIDError = 102;

    public static synchronized int checkDigitalIDFileAndPassword(String string, String string2) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401009, (Throwable)fileNotFoundException);
            }
            return 102;
        }
        return SignatureTools.checkDigitalIDFileAndPassword(fileInputStream, string2);
    }

    public static synchronized int checkDigitalIDFileAndPassword(InputStream inputStream, String string) {
        int n = 100;
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, string.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401009, (Throwable)keyStoreException);
            }
            n = 102;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401009, (Throwable)noSuchAlgorithmException);
            }
            n = 102;
        }
        catch (CertificateException certificateException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401009, (Throwable)certificateException);
            }
            n = 102;
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            if (string2.startsWith("failed to decrypt safe contents entry")) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401010, (Throwable)iOException);
                }
                n = 101;
            }
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401009, (Throwable)iOException);
            }
            n = 102;
        }
        return n;
    }
}

