/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.formula.DataType;
import jet.formula.DataTypeDef;
import jet.formula.IAllValue;
import jet.formula.JetOperation;
import jet.formula.SymbolInfo;
import jet.formula.fArray;
import jet.log.JRLogger;
import jet.util.StringFormatCheck;
import jet.util.StringToolKit;

public class ParamDesc {
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_NUMBER = "Number";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_CURRENCY = "Currency";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATETIME = "DateTime";
    public static final String TYPE_PARAMETER = "Parameters";
    public static final String TYPE_PARAMETER_SEPARATOR1 = "@";
    public static final String TYPE_PARAMETER_SEPARATOR2 = ",";
    public static final Locale defaultLocale = Locale.getDefault();
    public static final int dateStyle = 1;
    public static final int timeStyle = 2;
    public static final int NORMAL = 0;
    public static final int GROUPSORT = 1;
    public static final int AUTO = 2;
    public static final int IMPORT = 3;
    public static final int PSEUDO = 4;
    public static final int SORTORDER = 5;
    public String name;
    public String type;
    public String promptText;
    public String value;
    public boolean isStringNull;
    public String stringFormat;
    public String inValue;
    private SymbolInfo D = new SymbolInfo();
    private DbColDesc J = null;
    private DbValue SqlToFml = null;
    private int add = 0;
    String addAll;
    Vector addElement;
    private boolean addReferParamToVsortParams;
    private boolean append;
    private Vector applyLocalizedPattern = new Vector(2);
    private final Vector bNull = new Vector(6);
    private Vector booleanValue = new Vector(6);
    private Vector checkString = new Vector(6);
    private boolean class$ = false;
    private boolean clear = false;
    private String clone = "";
    private boolean contains = false;
    private String containsKey = "";
    private int countTokens = -1;
    private int debug = -1;
    private String doubleValue = null;
    private static String elementAt = System.getProperty("file.encoding");
    private String elements = elementAt;
    private Vector endsWith = new Vector();
    String equals;
    private String equalsIgnoreCase = null;
    private Vector error = new Vector();
    private static JRLogger fatal = JRLogger.getLogger((class$jet$formula$ParamDesc == null ? (class$jet$formula$ParamDesc = ParamDesc.class$("jet.formula.ParamDesc")) : class$jet$formula$ParamDesc).getName());
    private String forName;
    private Vector format = null;
    private boolean get = false;
    private Vector getAllRelatedParamByValue;
    protected boolean isCascading = false;
    protected String previousLevel;
    protected String nextLevel;
    protected String chainID = "";
    protected boolean isSetAsParameter;
    protected boolean isAllSelected = true;
    private boolean getBeColumn = false;
    protected boolean allowTypeIn = true;
    public static final int ADOPT_DIRECTLY = 1;
    public static final int USE_DEFAULT = 2;
    public static final int WARN = 3;
    protected int whenOutOfRange;
    private boolean getBinding;
    static Class class$jet$formula$ParamDesc;

    public void setSecurityEntry(String string) {
        this.forName = string;
    }

    public String getSecurityEntry() {
        return this.forName;
    }

    public ParamDesc() {
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2) {
        this(string, string2, string3, vector, vector2, string4, n, n2, null);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, String string5) {
        this(string, string2, string3, vector, vector2, string4, n, n2, 0, null, null, new Vector(6), string5);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, null, null, new Vector(6), null);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, false, false);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl, boolean bl2) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, bl, bl2, false);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, null, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, String string5, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, 0, null, null, new Vector(6), string5, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, null, null, new Vector(6), null, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl) {
        this(string, string2, string3, vector, vector2, string4, n, n2, n3, string5, vector3, vector4, string6, false, false, bl);
    }

    public ParamDesc(String string, String string2, String string3, Vector vector, Vector vector2, String string4, int n, int n2, int n3, String string5, Vector vector3, Vector vector4, String string6, boolean bl, boolean bl2, boolean bl3) {
        this.type = string2;
        this.name = string;
        this.promptText = string3;
        this.debug = n;
        this.doubleValue = string6;
        this.add = n3;
        this.get = bl3;
        this.bNull(string2);
        this.endsWith = vector2;
        this.J.setColName(string);
        this.addReferParamToVsortParams = bl;
        this.append = bl2;
        String string7 = "";
        if (string4 == null || string4.length() <= 0) {
            this.containsKey = "";
        } else {
            this.containsKey = string4;
            if (this.type.equalsIgnoreCase(TYPE_STRING)) {
                this.J.setEncodingName(this.containsKey);
            }
        }
        if (vector != null && vector.size() > 0) {
            try {
                this.setLimit(vector, null);
            }
            catch (InvalidParameterException invalidParameterException) {
                string7 = string7 + invalidParameterException.getMessage();
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            try {
                this.setValues(vector2, null);
            }
            catch (InvalidParameterException invalidParameterException) {
                string7 = string7 + invalidParameterException.getMessage();
            }
        }
        this.setDefaultIndex(n2);
        this.inValue = this.getDefaultValue();
        this.value = this.bNull.size() > 0 ? this.getDisplayValue(this.getValue(), Locale.getDefault()) : "";
        this.addAll = string5;
        this.addElement = vector3 == null ? new Vector() : vector3;
        this.booleanValue = vector4;
        if (string7.length() > 0 && fatal.isErrorEnabled()) {
            fatal.error("init Parameter\n" + string + ": " + string7);
        }
    }

    public Vector getDefaultValues() {
        return this.endsWith;
    }

    public SymbolInfo getInfo() {
        return this.D;
    }

    public DbValue getValue() {
        if (this.get && this.isAllSelected()) {
            return fArray.getSpecialInstance(this.D.type, this.J);
        }
        if (this.SqlToFml == null) {
            try {
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (fatal.isErrorEnabled()) {
                    fatal.error("", invalidParameterException);
                }
                return null;
            }
        }
        return this.SqlToFml;
    }

    public String getStrValue() {
        if (this.SqlToFml == null) {
            try {
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (fatal.isErrorEnabled()) {
                    fatal.error("", invalidParameterException);
                }
                return "";
            }
        }
        return this.booleanValue(this.SqlToFml);
    }

    private DbValue D(DbValue dbValue) {
        DbValue dbValue2 = dbValue;
        DbColDesc dbColDesc = dbValue.getColDesc();
        int n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        switch (this.D.type) {
            case 6: 
            case 7: 
            case 8: {
                if (n == this.D.type) break;
                dbValue2 = DbValue.makeDbValue(this.J);
                ((DbDateTime)dbValue2).set(((DbDateTime)dbValue).value);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                if (n == this.D.type) break;
                fArray fArray2 = fArray.getInstance(this.D.type, this.J);
                int n2 = ((fArray)dbValue).value == null ? 0 : ((fArray)dbValue).value.length;
                DbValue[] dbValueArray = null;
                switch (this.D.type) {
                    case 17: 
                    case 18: 
                    case 19: {
                        dbValueArray = new DbDateTime[n2];
                    }
                }
                DbDateTime dbDateTime = null;
                int n3 = 0;
                while (n3 < n2) {
                    dbValueArray[n3] = (DbDateTime)DbValue.makeDbValue(this.J);
                    dbDateTime = (DbDateTime)((fArray)dbValue).value[n3];
                    ((DbDateTime)dbValueArray[n3]).set(dbDateTime.get());
                    ++n3;
                }
                fArray2.set(dbValueArray);
                if (dbValue.bNull) {
                    fArray2.bNull = true;
                }
                dbValue2 = fArray2;
                break;
            }
            default: {
                dbValue2 = dbValue;
            }
        }
        return dbValue2;
    }

    public void set(DbValue dbValue) {
        if (dbValue instanceof IAllValue && this.get) {
            this.setAllSelected(true);
            return;
        }
        this.setAllSelected(false);
        dbValue = this.D(dbValue);
        if (this.SqlToFml == null) {
            this.getValue();
        }
        if (this.SqlToFml != null) {
            this.SqlToFml.setValue(dbValue);
        } else {
            this.SqlToFml = (DbValue)dbValue.clone();
        }
        if (!this.get) {
            this.inValue = this.booleanValue(this.SqlToFml);
            this.value = this.getDisplayValue(dbValue, Locale.getDefault());
        }
    }

    public String getValueMeaning() {
        return this.getDisplayValue(this.SqlToFml, Locale.getDefault());
    }

    public DbColDesc getColDesc() {
        return this.getValue().getColDesc();
    }

    public void initParam(Locale locale) throws InvalidParameterException {
        if (this.name.equals("")) {
            throw new InvalidParameterException(JResource.getMessage("FML_ERRNAME"));
        }
        if (this.type.equals("")) {
            throw new InvalidParameterException(JResource.getMessage("FML_ERRTYPE"));
        }
        if (this.bNull.size() > 0) {
            DbValue dbValue = null;
            dbValue = this.countTokens == -1 ? (DbValue)this.bNull.lastElement() : (DbValue)this.bNull.elementAt(this.countTokens);
            if (this.get) {
                String string = this.getDisplayValue(dbValue, Locale.getDefault());
                this.setValue(new String[]{string}, Locale.getDefault());
            } else {
                this.SqlToFml = dbValue;
                this.inValue = this.booleanValue(this.SqlToFml);
                this.value = this.getDisplayValue(this.SqlToFml, Locale.getDefault());
            }
        } else if (this.get) {
            this.setValue(new String[0], Locale.getDefault());
        } else {
            this.SqlToFml = this.append("", defaultLocale, false);
            this.value = "";
            this.inValue = "";
        }
    }

    public void setBeColumn(int n) {
        this.add = n;
    }

    public int getBeColumn() {
        return this.add;
    }

    public boolean isColumn() {
        return this.add != 0;
    }

    public boolean isColumnCal() {
        return this.add > 0;
    }

    public void setLimit(Vector vector, Locale locale) throws InvalidParameterException {
        boolean bl = locale == null;
        int n = vector.size();
        Locale locale2 = bl ? defaultLocale : locale;
        Vector vector2 = (Vector)this.applyLocalizedPattern.clone();
        this.applyLocalizedPattern.removeAllElements();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if (string2 != null && string2.length() > 0) {
                try {
                    DbValue dbValue = this.append(string2, locale2, !bl);
                    this.applyLocalizedPattern.addElement(dbValue);
                }
                catch (InvalidParameterException invalidParameterException) {
                    string = "\n\"" + string2 + "\": " + invalidParameterException.getMessage();
                }
            } else {
                this.applyLocalizedPattern.addElement(null);
            }
            ++n2;
        }
        if (string.length() > 0) {
            this.applyLocalizedPattern = vector2;
            throw new InvalidParameterException(JResource.getMessage("FML_INVALIDLIMIT", (Object)string));
        }
        int n3 = JetOperation.I(1, this.applyLocalizedPattern);
        if (n3 == -1) {
            this.applyLocalizedPattern = new Vector(6);
        } else if (n3 == 1) {
            this.applyLocalizedPattern = vector2;
            throw new InvalidParameterException(JResource.getMessage("FML_INVALIDLIMIT", (Object)JResource.getMessage("FML_LIMITMATCH")));
        }
        this.bNull.removeAllElements();
    }

    public void setLimit(String string, Locale locale, int n) throws InvalidParameterException {
        String string2 = "";
        Vector vector = (Vector)this.applyLocalizedPattern.clone();
        if (string.length() > 0) {
            try {
                this.applyLocalizedPattern.setElementAt(null, n);
                DbValue dbValue = this.applyLocalizedPattern(string, locale, true);
                this.applyLocalizedPattern.setElementAt(dbValue, n);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.applyLocalizedPattern = vector;
                throw new InvalidParameterException("\"" + string + "\": " + invalidParameterException.getMessage());
            }
        } else {
            this.applyLocalizedPattern.setElementAt(null, n);
        }
        int n2 = JetOperation.I(1, this.applyLocalizedPattern);
        if (n2 == -1) {
            this.applyLocalizedPattern = new Vector(6);
        } else if (n2 == 1) {
            this.applyLocalizedPattern = vector;
            throw new InvalidParameterException(JResource.getMessage("FML_INVALIDLIMIT", (Object)JResource.getMessage("FML_LIMITMATCH")));
        }
        this.bNull.removeAllElements();
    }

    private Number J(String string, Locale locale, boolean bl) throws InvalidParameterException {
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        if (bl && this.containsKey != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.containsKey, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)decimalFormat.toLocalizedPattern()));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            DecimalFormat decimalFormat2 = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
            parsePosition = new ParsePosition(0);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                parsePosition = new ParsePosition(0);
                number = decimalFormat2.parse(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    number = null;
                }
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new Object[]{decimalFormat.toLocalizedPattern(), decimalFormat2.toLocalizedPattern()}));
            }
        }
        return number;
    }

    private Number QOIV(String string, Locale locale, boolean bl) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (bl && this.containsKey != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.containsKey, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)decimalFormat.toLocalizedPattern()));
            }
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            parsePosition = new ParsePosition(0);
            decimalFormat.setParseIntegerOnly(true);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                String string2 = decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getGroupingSeparator() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "" + decimalFormatSymbols.getDigit() + "";
                char[] cArray = new char[5];
                int n = 0;
                while (n < cArray.length) {
                    cArray[n] = decimalFormatSymbols.getDigit();
                    ++n;
                }
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new String[]{string2, String.valueOf(cArray)}));
            }
        }
        return number;
    }

    private Number SqlToFml(String string, Locale locale, boolean bl) throws InvalidParameterException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = null;
        if (bl && this.containsKey != "") {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            DecimalFormat decimalFormat = new DecimalFormat(this.containsKey, decimalFormatSymbols);
            number = (Number)decimalFormat.parseObject(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)decimalFormat.toLocalizedPattern()));
            }
        } else {
            parsePosition = new ParsePosition(0);
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
            number = decimalFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                number = null;
            }
            if (number == null) {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFML", (Object)decimalFormat.toLocalizedPattern()));
            }
        }
        return number;
    }

    private static String[] add(String string) {
        String string2;
        String string3;
        int n = string.indexOf("/");
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "false";
        }
        return new String[]{string3, string2};
    }

    private Boolean addAll(String string, String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string.equalsIgnoreCase(string2)) {
                return new Boolean(true);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string3 = stringArray2[n2];
            if (string.equalsIgnoreCase(string3)) {
                return new Boolean(false);
            }
            ++n2;
        }
        return null;
    }

    public String[][] getBooleanLiteral() {
        String string;
        String string2;
        String[] stringArray;
        if (this.containsKey != "") {
            stringArray = ParamDesc.add(this.containsKey);
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            string2 = "true";
            string = "false";
        }
        stringArray = new String[2][2];
        stringArray[0][0] = string2;
        stringArray[0][1] = "1";
        stringArray[1][0] = string;
        stringArray[1][1] = "0";
        return stringArray;
    }

    private boolean addElement(String string, Locale locale, boolean bl) throws InvalidParameterException {
        String string2;
        String string3;
        String[] stringArray;
        boolean bl2 = true;
        if (bl && this.containsKey != "") {
            stringArray = ParamDesc.add(this.containsKey);
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string3 = "true";
            string2 = "false";
        }
        stringArray = new String[]{string3, "1"};
        String[] stringArray2 = new String[]{string2, "0"};
        Boolean bl3 = this.addAll(string, stringArray, stringArray2);
        if (bl3 == null) {
            if (this.containsKey == "") {
                throw new InvalidParameterException(JResource.getMessage("FML_VALIDFORMAT", new String[]{"true", "false"}));
            }
            throw new InvalidParameterException(JResource.getMessage("FML_USERFORMAT", (Object)("TRUE = \"" + string3 + "\" , FALSE = \"" + string2 + "\"")));
        }
        bl2 = bl3;
        return bl2;
    }

    private String addReferParamToVsortParams(String string) throws InvalidParameterException {
        if (this.stringFormat != null && this.stringFormat.length() != 0 || !this.isColumn()) {
            if (this.isStringNull && (string.equals("") || string == "")) {
                return string;
            }
            boolean bl = StringFormatCheck.checkString(this.stringFormat, string);
            if (bl) {
                return string;
            }
            String string2 = JResource.getMessage("FML_USERFORMAT", (Object)this.stringFormat);
            fatal.fatal(string2, new InvalidParameterException(string2));
            throw new InvalidParameterException(string2);
        }
        return string;
    }

    private java.util.Date allowTypeIn(String string, int n, Locale locale, boolean bl) throws InvalidParameterException {
        java.util.Date date = null;
        if (bl && this.containsKey != "") {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.containsKey, dateFormatSymbols);
            ParsePosition parsePosition = new ParsePosition(0);
            date = (java.util.Date)simpleDateFormat.parseObject(string, parsePosition);
            if (date != null && parsePosition.getIndex() != string.length()) {
                date = null;
            }
            if (date == null) {
                String string2 = JResource.getMessage("FML_USERFORMAT", (Object)simpleDateFormat.toLocalizedPattern());
                fatal.fatal(string2, new InvalidParameterException(string2));
                throw new InvalidParameterException(string2);
            }
        } else {
            String string3;
            SimpleDateFormat[] simpleDateFormatArray = null;
            switch (n) {
                case 6: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getDateInstance(0, locale), new SimpleDateFormat("yyyy-MM-dd z", defaultLocale)};
                    break;
                }
                case 7: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(1, locale), (SimpleDateFormat)SimpleDateFormat.getTimeInstance(0, locale)};
                    break;
                }
                case 8: {
                    simpleDateFormatArray = new SimpleDateFormat[]{(SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 0, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1, locale), (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, locale), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", defaultLocale)};
                    simpleDateFormatArray[16].setTimeZone(TimeZone.getTimeZone("GMT"));
                }
            }
            int n2 = 0;
            while (date == null && n2 < simpleDateFormatArray.length) {
                block18: {
                    string3 = simpleDateFormatArray[n2].toLocalizedPattern();
                    if (!this.elements.equals(elementAt)) {
                        try {
                            string3 = new String(string3.getBytes(this.elements));
                            simpleDateFormatArray[n2].applyLocalizedPattern(string3);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!fatal.isDebugEnabled()) break block18;
                            fatal.debug(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                        }
                    }
                }
                simpleDateFormatArray[n2].setLenient(false);
                DateFormatSymbols dateFormatSymbols = simpleDateFormatArray[n2].getDateFormatSymbols();
                dateFormatSymbols.setZoneStrings(new String[0][0]);
                simpleDateFormatArray[n2].setDateFormatSymbols(dateFormatSymbols);
                ParsePosition parsePosition = new ParsePosition(0);
                date = simpleDateFormatArray[n2].parse(string.trim(), parsePosition);
                if (date != null && parsePosition.getIndex() != string.length()) {
                    date = null;
                }
                ++n2;
            }
            if (date == null) {
                string3 = JResource.getMessage("FML_VALIDFML1");
                int n3 = 0;
                while (n3 < simpleDateFormatArray.length) {
                    string3 = string3 + "\n    " + simpleDateFormatArray[n3].toLocalizedPattern();
                    ++n3;
                }
                this.allowUseExpression(simpleDateFormatArray);
                if (fatal.isFatalEnabled()) {
                    fatal.fatal(string3, new InvalidParameterException(string3));
                }
                throw new InvalidParameterException(string3);
            }
            this.allowUseExpression(simpleDateFormatArray);
        }
        if (fatal.isDebugEnabled()) {
            fatal.debug("Parse Date Time Parameter with Format\nValue: " + string + "\nDataType: " + n + "\nLocale: " + locale + "\nReturn: " + date);
        }
        return date;
    }

    private void allowUseExpression(SimpleDateFormat[] simpleDateFormatArray) {
        int n = 0;
        while (n < simpleDateFormatArray.length) {
            simpleDateFormatArray[n] = null;
            ++n;
        }
    }

    public void clearMem() {
        this.applyLocalizedPattern.removeAllElements();
        this.bNull.removeAllElements();
    }

    private DbValue append(String string, Locale locale, boolean bl) throws InvalidParameterException {
        int n = this.D.type;
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        if (n != 5) {
            string = string.trim();
        }
        DbValue dbValue = null;
        switch (n) {
            case 3: {
                dbValue = new DbDecimal(this.J);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                dbValue.value = new BigDecimal(this.J(string, locale, bl).doubleValue());
                dbValue.bNull = false;
                break;
            }
            case 1: {
                dbValue = new DbBigInt(this.J);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbBigInt)dbValue).value = this.QOIV(string, locale, bl).longValue();
                dbValue.bNull = false;
                break;
            }
            case 2: {
                dbValue = new DbDouble(this.J);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbDouble)dbValue).value = this.SqlToFml(string, locale, bl).doubleValue();
                dbValue.bNull = false;
                break;
            }
            case 5: {
                dbValue = new DbChar(this.J);
                ((DbChar)dbValue).value = string;
                if (this.isStringNull && string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                dbValue.bNull = false;
                break;
            }
            case 4: {
                dbValue = new DbBit(this.J);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                ((DbBit)dbValue).value = this.addElement(string, locale, bl);
                dbValue.bNull = false;
                break;
            }
            case 6: {
                dbValue = new DbDate(this.J);
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                java.util.Date date = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                        DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                        dateFormatSymbols.setZoneStrings(new String[0][0]);
                        simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                        date = simpleDateFormat.parse(string);
                    }
                    catch (Exception exception) {
                        date = null;
                    }
                    if (date == null) {
                        try {
                            date = Date.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            date = null;
                        }
                    }
                }
                if (date == null) {
                    date = this.allowTypeIn(string, n, locale, bl);
                }
                ((DbDate)dbValue).value = date.getTime();
                dbValue.bNull = false;
                break;
            }
            case 7: {
                if (dbValue == null) {
                    dbValue = new DbTime(this.J);
                }
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                Time time2 = null;
                if (!bl) {
                    try {
                        time2 = Time.valueOf(string);
                    }
                    catch (Exception exception) {
                        if (fatal.isDebugEnabled()) {
                            fatal.debug("Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        time2 = null;
                    }
                }
                if (time2 == null) {
                    time2 = new Time(this.allowTypeIn(string, n, locale, bl).getTime());
                }
                ((DbTime)dbValue).value = time2.getTime();
                dbValue.bNull = false;
                break;
            }
            case 8: {
                if (dbValue == null) {
                    dbValue = new DbTimestamp(this.J);
                }
                if (string.equals("")) {
                    dbValue.bNull = true;
                    break;
                }
                Timestamp timestamp = null;
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
                    }
                    catch (Exception exception) {
                        if (fatal.isDebugEnabled()) {
                            fatal.debug("Parse Time Parameter\n" + string + "\n" + exception.getMessage());
                        }
                        timestamp = null;
                    }
                }
                if (timestamp == null) {
                    timestamp = new Timestamp(this.allowTypeIn(string, n, locale, bl).getTime());
                }
                ((DbTimestamp)dbValue).set(timestamp);
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid parameter type " + this.type + "!");
            }
        }
        return dbValue;
    }

    private DbValue applyLocalizedPattern(String string, Locale locale, boolean bl) throws InvalidParameterException {
        DbValue dbValue = this.append(this.addReferParamToVsortParams(string), locale, bl);
        if (!dbValue.isNull()) {
            this.Operation(dbValue, locale);
        }
        return dbValue;
    }

    private void Operation(DbValue dbValue, Locale locale) throws InvalidParameterException {
        int n = JetOperation.Operation(this.debug, this.applyLocalizedPattern, dbValue);
        if (n != 0) {
            String string = JResource.getMessage(n == -1 ? "FML_CMPMIN" : "FML_CMPMAX", (Object)this.getDisplayValue((DbValue)this.applyLocalizedPattern.elementAt(n == -1 ? 0 : 1), locale));
            throw new InvalidParameterException(JResource.getMessage("FML_CMPBEYOND", (Object)string));
        }
    }

    private void bNull(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(TYPE_INTEGER)) {
            n = 1;
        } else if (string.equalsIgnoreCase(TYPE_NUMBER)) {
            n = 2;
        } else if (string.equalsIgnoreCase(TYPE_STRING)) {
            n = 5;
        } else if (string.equalsIgnoreCase(TYPE_CURRENCY)) {
            n = 3;
        } else if (string.equalsIgnoreCase(TYPE_BOOLEAN)) {
            n = 4;
        } else if (string.equalsIgnoreCase(TYPE_DATE)) {
            n = 6;
        } else if (string.equalsIgnoreCase(TYPE_TIME)) {
            n = 7;
        } else if (string.equalsIgnoreCase(TYPE_DATETIME)) {
            n = 8;
        } else if (string.equalsIgnoreCase(TYPE_PARAMETER)) {
            n = 5;
        } else if (fatal.isErrorEnabled()) {
            fatal.error("Invalid parameter type " + string + "!");
        }
        this.type = string;
        this.J = DataType.toDbColDesc(n, -1, -1);
        if (this.get) {
            n += 11;
        }
        this.D.setInfo(this.name, null, n, -1, 7, -1, true);
    }

    public String getDefaultValue() {
        String string = "";
        if (this.bNull.size() > 0) {
            DbValue dbValue = null;
            dbValue = this.countTokens == -1 ? (DbValue)this.bNull.lastElement() : (DbValue)this.bNull.elementAt(this.countTokens);
            if (dbValue != null) {
                string = this.booleanValue(dbValue);
            }
        }
        return string;
    }

    private String booleanValue(DbValue dbValue) {
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            switch (n) {
                case 3: {
                    string = new String(NumberFormat.getCurrencyInstance(defaultLocale).format(((DbDecimal)dbValue).value));
                    break;
                }
                case 1: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).longValue()));
                    break;
                }
                case 2: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).doubleValue()));
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    string = new String(((DbBit)dbValue).value ? "TRUE" : "FALSE");
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    string = simpleDateFormat.format(((DbDate)dbValue).getDate());
                    break;
                }
                case 7: {
                    string = new Time(((DbTime)dbValue).value).toString();
                    break;
                }
                case 8: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    string = simpleDateFormat.format(((DbTimestamp)dbValue).toUtilDate());
                    break;
                }
                default: {
                    if (!fatal.isErrorEnabled()) break;
                    fatal.error(dbValue + " Unknow parameter type!");
                }
            }
        }
        return string;
    }

    public String getDisplayValue(DbValue dbValue, Locale locale) {
        if (dbValue instanceof fArray) {
            return null;
        }
        int n = this.D.type;
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            switch (n) {
                case 3: {
                    string = this.containsKey != "" ? new DecimalFormat(this.containsKey).format(((DbDecimal)dbValue).value) : NumberFormat.getCurrencyInstance(locale).format(((DbDecimal)dbValue).value);
                    break;
                }
                case 1: {
                    string = this.containsKey != "" ? new DecimalFormat(this.containsKey).format(new Long(((DbNumber)dbValue).longValue())) : NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).longValue());
                    break;
                }
                case 2: {
                    string = this.containsKey != "" ? new DecimalFormat(this.containsKey).format(new Double(((DbNumber)dbValue).doubleValue())) : NumberFormat.getNumberInstance(locale).format(((DbNumber)dbValue).doubleValue());
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = this.containsKey != "" ? new SimpleDateFormat(this.containsKey) : (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    simpleDateFormat.setTimeZone(TimeZone.getDefault());
                    string = simpleDateFormat.format(new java.util.Date(((DbDate)dbValue).value));
                    if (this.elements.equals(elementAt)) break;
                    try {
                        string = new String(string.getBytes(this.elements));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!fatal.isDebugEnabled()) break;
                        fatal.debug(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                    }
                    break;
                }
                case 7: {
                    string = this.containsKey != "" ? new SimpleDateFormat(this.containsKey).format(new java.util.Date(((DbTime)dbValue).value)) : DateFormat.getTimeInstance(2, locale).format(new java.util.Date(((DbTime)dbValue).value));
                    break;
                }
                case 8: {
                    java.util.Date date = ((DbTimestamp)dbValue).toUtilDate();
                    if (this.containsKey != "") {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.containsKey);
                        simpleDateFormat.setTimeZone(TimeZone.getDefault());
                        string = simpleDateFormat.format(date);
                        break;
                    }
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
                    dateFormat.setTimeZone(TimeZone.getDefault());
                    string = dateFormat.format(date);
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    if (this.containsKey == "") {
                        string = dbValue.toString();
                        break;
                    }
                    String[] stringArray = ParamDesc.add(this.containsKey);
                    string = ((DbBit)dbValue).value ? stringArray[0] : stringArray[1];
                    break;
                }
                default: {
                    string = dbValue.toString();
                }
            }
        }
        return string;
    }

    public Vector getDisplayValues(Locale locale) {
        int n = this.bNull.size();
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(this.getDisplayValue((DbValue)this.bNull.elementAt(n2), locale));
            ++n2;
        }
        return vector;
    }

    public Vector getValues() {
        int n = this.bNull.size();
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(this.booleanValue((DbValue)this.bNull.elementAt(n2)));
            ++n2;
        }
        return vector;
    }

    public boolean isValuesNotEmpty() {
        return this.bNull.size() > 0;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrompt() {
        return this.promptText;
    }

    public Vector getLimit() {
        Vector vector = this.applyLocalizedPattern;
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(this.checkString((DbValue)vector.elementAt(n2)));
            ++n2;
        }
        return vector2;
    }

    public Vector getDisplayLimit(Locale locale) {
        int n = this.applyLocalizedPattern.size();
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(this.getDisplayValue((DbValue)this.applyLocalizedPattern.elementAt(n2), locale));
            ++n2;
        }
        return vector;
    }

    public String getFormat() {
        return this.containsKey;
    }

    public String getDefaultDateFormat(Locale locale) {
        SimpleDateFormat simpleDateFormat = null;
        switch (this.D.type) {
            case 6: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale);
                break;
            }
            case 7: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale);
                break;
            }
            case 8: {
                simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, locale);
                break;
            }
            default: {
                simpleDateFormat = null;
            }
        }
        if (simpleDateFormat == null) {
            return null;
        }
        return simpleDateFormat.toPattern();
    }

    public int getDefaultIndex() {
        return this.countTokens;
    }

    public int getOperation() {
        return this.debug;
    }

    public void setFormat(String string) {
        this.containsKey = string.length() > 0 ? string : "";
    }

    public void setPrompt(String string) {
        this.promptText = string;
    }

    public void setValues(Vector vector, Locale locale) throws InvalidParameterException {
        if (this.equalsIgnoreCase != null && this.equalsIgnoreCase.trim().length() != 0) {
            this.checkString.clear();
            this.bNull.clear();
        }
        int n = vector.size();
        int n2 = this.bNull.size();
        boolean bl = locale == null;
        Locale locale2 = bl ? defaultLocale : locale;
        String string = "";
        int n3 = 0;
        while (n3 < n) {
            String string2 = (String)vector.elementAt(n3);
            if (string2 != null) {
                try {
                    DbValue dbValue = this.applyLocalizedPattern(string2, locale2, !bl);
                    if (n3 < n2) {
                        this.bNull.setElementAt(dbValue, n3);
                    } else if (this.add == 4) {
                        this.bNull.addElement(dbValue);
                    } else if (!this.bNull.contains(dbValue)) {
                        this.bNull.addElement(dbValue);
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    this.checkString.addElement(new Integer(n3));
                    string = string + "\n\"" + string2 + "\": " + invalidParameterException.getMessage();
                }
            } else {
                this.checkString.addElement(new Integer(n3));
            }
            ++n3;
        }
        if (this.add != 4) {
            int n4 = this.bNull.size();
            while (--n4 >= n) {
                this.bNull.removeElementAt(n4);
            }
        }
        if (string.length() > 0) {
            throw new InvalidParameterException(string);
        }
    }

    public void setShowValues(Vector vector) {
        this.booleanValue = vector;
        int n = this.checkString.size();
        while (--n >= 0) {
            this.booleanValue.removeElementAt((Integer)this.checkString.elementAt(n));
        }
    }

    public Vector getShowValues() {
        if (this.equalsIgnoreCase != null && this.equalsIgnoreCase.length() != 0) {
            return this.booleanValue;
        }
        return this.booleanValue == null || this.booleanValue.size() == 0 ? this.bNull : this.booleanValue;
    }

    public Object clone() {
        ParamDesc paramDesc = new ParamDesc(this.getName(), this.getType(), this.getPrompt(), this.getLimit(), this.getValues(), this.getFormat(), this.getOperation(), this.getDefaultIndex(), this.getBeColumn(), this.getColumn(), this.getColumns(), this.getShowValues(), this.getBinding(), this.isDistinct(), this.isRequired(), this.get);
        paramDesc.setImportSql(this.getImportSql());
        paramDesc.setUseCurrentDate(this.isUseCurrentDate());
        paramDesc.setUseCurrentDateWhenBlank(this.isUseCurrentDateWhenBlank());
        paramDesc.setDynamicTemplate(this.getDynamicTemplate());
        paramDesc.setHideParameterWhenSingleValueReturn(this.isHideParameterWhenSingleValueReturn());
        paramDesc.setSelectedValues(this.getSelectedValues());
        paramDesc.setIsCascading(this.isCascading);
        paramDesc.setAllSelected(this.isAllSelected);
        paramDesc.setAllowAll(this.isAllowAll());
        paramDesc.allowTypeIn = this.allowTypeIn;
        paramDesc.whenOutOfRange = this.whenOutOfRange;
        paramDesc.setAllowUseExpression(this.allowUseExpression());
        paramDesc.setCascadingInfo(this.chainID, this.previousLevel, this.nextLevel, this.isSetAsParameter);
        paramDesc.setImportParams(this.error);
        paramDesc.format = this.format;
        return paramDesc;
    }

    public void setDefaultIndex(int n) {
        int n2 = this.bNull.size() - 1;
        this.countTokens = n == -1 || n > n2 ? -1 : n;
        if (n2 == -1) {
            this.inValue = "";
            this.value = "";
        } else {
            DbValue dbValue;
            DbValue dbValue2 = dbValue = this.countTokens == -1 ? (DbValue)this.bNull.lastElement() : (DbValue)this.bNull.elementAt(this.countTokens);
            if (this.get) {
                if (!this.isAllSelected()) {
                    this.value = this.getDisplayValue(dbValue, Locale.getDefault());
                    try {
                        this.setValue(new String[]{this.value}, Locale.getDefault());
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        throw new RuntimeException(invalidParameterException.getMessage());
                    }
                }
            } else {
                this.inValue = this.getDefaultValue();
                this.SqlToFml = dbValue;
                this.value = this.getDisplayValue(this.SqlToFml, Locale.getDefault());
            }
        }
    }

    public boolean equals(ParamDesc paramDesc) {
        boolean bl;
        boolean bl2 = bl = this.getPrompt().equalsIgnoreCase(paramDesc.getPrompt()) && this.getType().equalsIgnoreCase(paramDesc.getType()) && this.getFormat().equalsIgnoreCase(paramDesc.getFormat()) && this.getDefaultIndex() == paramDesc.getDefaultIndex() && this.getOperation() == paramDesc.getOperation();
        if (bl) {
            int n;
            Vector vector = paramDesc.getLimit();
            Vector vector2 = this.getLimit();
            if (vector.size() == vector2.size()) {
                n = 0;
                while (bl && n < vector.size()) {
                    bl = ((String)vector.elementAt(n)).equalsIgnoreCase((String)vector2.elementAt(n));
                    ++n;
                }
            } else {
                bl = false;
            }
            if (bl) {
                vector = paramDesc.getValues();
                vector2 = this.getValues();
                if (vector.size() == vector2.size()) {
                    n = 0;
                    while (bl && n < vector.size()) {
                        bl = vector2.contains(vector.elementAt(n));
                        ++n;
                    }
                }
            }
        }
        return bl;
    }

    public DbValue parseInternalValue(String string) throws InvalidParameterException {
        DbValue dbValue = this.applyLocalizedPattern(string, defaultLocale, false);
        return dbValue;
    }

    private boolean chainID(DbValue dbValue) {
        if (dbValue != null && (dbValue instanceof DbChar ? ((DbChar)dbValue).value.equals("") : dbValue.bNull)) {
            return false;
        }
        return this.bNull.size() > 0 && !this.bNull.contains(dbValue);
    }

    public String setValue(String string, Locale locale) throws InvalidParameterException {
        String string2;
        if (this.get) {
            throw new InvalidParameterException("Please call setValue(String[], locale) for multi-value parameter");
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        DbValue dbValue = this.applyLocalizedPattern(string, locale2, true);
        boolean bl = this.chainID(dbValue);
        if (this.getWhenOutOfRange() == 2 && bl) {
            string2 = this.getDefaultValue();
            dbValue = this.parseInternalValue(string2);
        } else if (this.getWhenOutOfRange() == 3 && bl) {
            throw new InvalidParameterException("Warning: the inputed value '" + string + "' is out of range");
        }
        this.SqlToFml = dbValue;
        string2 = this.booleanValue(dbValue);
        String string3 = this.getDisplayValue(dbValue, locale2);
        if (!this.bNull.contains(dbValue)) {
            this.bNull.addElement(dbValue);
            this.countTokens = -1;
            this.inValue = string2;
            this.value = this.getDisplayValue(dbValue, locale2);
        } else {
            this.countTokens = this.bNull.indexOf(dbValue);
            this.value = this.getDisplayValue(dbValue, locale2);
            this.inValue = this.booleanValue(dbValue);
        }
        return string3;
    }

    public String setValue(DbValue dbValue, Locale locale) throws InvalidParameterException {
        if (this.get) {
            return this.setValue((fArray)dbValue, locale)[0];
        }
        DbValue dbValue2 = this.D(dbValue);
        boolean bl = this.chainID(dbValue2);
        if (bl && this.getWhenOutOfRange() == 2) {
            String string = this.getDefaultValue();
            this.SqlToFml = this.parseInternalValue(string);
        } else {
            if (bl && this.getWhenOutOfRange() == 3) {
                throw new InvalidParameterException("Warning: the inputed value '" + this.getDisplayValue(dbValue2, locale) + "' is out of range");
            }
            this.SqlToFml = dbValue2;
        }
        this.inValue = this.booleanValue(this.SqlToFml);
        this.value = this.getDisplayValue(this.SqlToFml, locale);
        if (!this.bNull.contains(this.SqlToFml)) {
            this.bNull.addElement(this.SqlToFml);
            this.countTokens = -1;
        } else {
            this.countTokens = this.bNull.indexOf(this.SqlToFml);
        }
        return this.value;
    }

    public void check(String string, Locale locale) throws InvalidParameterException {
        this.setValue(string, locale);
    }

    public boolean isSimilar(ParamDesc paramDesc) {
        boolean bl;
        boolean bl2 = bl = this.getPrompt().equalsIgnoreCase(paramDesc.getPrompt()) && this.getType().equalsIgnoreCase(paramDesc.getType()) && this.getFormat().equalsIgnoreCase(paramDesc.getFormat()) && this.getOperation() == paramDesc.getOperation() && this.getBeColumn() == paramDesc.getBeColumn();
        if (bl) {
            int n;
            if (this.add == 4) {
                if (!this.addAll.equals(paramDesc.addAll) || this.addElement.size() != paramDesc.addElement.size()) {
                    return false;
                }
                int n2 = this.addElement.size();
                while (--n2 >= 0) {
                    if (this.addElement.elementAt(n2).equals(paramDesc.addElement.elementAt(n2))) continue;
                    return false;
                }
            }
            Vector vector = paramDesc.getLimit();
            Vector vector2 = this.getLimit();
            if (vector.size() == vector2.size()) {
                n = 0;
                while (bl && n < vector.size()) {
                    if (!((String)vector.elementAt(n)).equalsIgnoreCase((String)vector2.elementAt(n))) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = false;
            }
            if (bl) {
                vector2 = paramDesc.getValues();
                vector = this.getValues();
                if (this.add == 0) {
                    if (vector.size() <= vector2.size()) {
                        n = 0;
                        while (bl && n < vector.size()) {
                            bl = vector2.contains(vector.elementAt(n));
                            ++n;
                        }
                    }
                } else if (vector.size() == vector2.size()) {
                    n = 0;
                    while (bl && n < vector.size()) {
                        if (!vector2.contains(vector.elementAt(n))) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public String getBinding() {
        return this.doubleValue;
    }

    public void setBinding(String string) {
        this.doubleValue = string;
    }

    public String getColumn() {
        return this.addAll;
    }

    public Vector getColumns() {
        return this.addElement;
    }

    public void setColumn(String string) {
        this.addAll = string;
    }

    public void setColumns(Vector vector) {
        this.addElement = vector;
    }

    public void setDistinct(boolean bl) {
        this.addReferParamToVsortParams = bl;
    }

    public boolean isDistinct() {
        return this.addReferParamToVsortParams;
    }

    public void setEncoding(String string) {
        this.elements = string;
    }

    public void setRequired(boolean bl) {
        this.append = bl;
    }

    public boolean isRequired() {
        return this.append;
    }

    public void setDataSource(String string) {
        this.equals = string;
    }

    public String getDataSource() {
        return this.equals;
    }

    public String getImportSql() {
        return this.equalsIgnoreCase;
    }

    public void setImportSql(String string) {
        this.equalsIgnoreCase = string;
    }

    public static void getRelatedParamDescsByParam(Hashtable hashtable, Vector vector, ParamDesc paramDesc) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            Vector vector2 = paramDesc.getValues();
            int n = 0;
            while (n < vector2.size()) {
                String[] stringArray = ParamDesc.splitValue(vector2.get(n).toString());
                int n2 = 0;
                while (n2 < stringArray.length) {
                    ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[n2].toString().toUpperCase());
                    if (paramDesc2 != null && !vector.contains(paramDesc2)) {
                        vector.add(paramDesc2);
                        ParamDesc.getRelatedParamDescsByParam(hashtable, vector, paramDesc2);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public static Vector getFirstLevelRelatedParamByValue(Hashtable hashtable, ParamDesc paramDesc, Object object) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            int n = 0;
            while (n < stringArray.length) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[n].toString().toUpperCase());
                if (paramDesc2 != null && !vector.contains(paramDesc2)) {
                    vector.add(paramDesc2);
                }
                ++n;
            }
        }
        return vector;
    }

    public static void getFirstShowParamDescs(Hashtable hashtable, Vector vector, ParamDesc paramDesc, Object object) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            int n = 0;
            while (n < stringArray.length) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[n].toString().toUpperCase());
                if (paramDesc2 != null && !vector.contains(paramDesc2)) {
                    vector.add(paramDesc2);
                    ParamDesc.getFirstShowParamDescs(hashtable, vector, paramDesc2, paramDesc2.getDefaultValue());
                }
                ++n;
            }
        }
    }

    public static void getFirstLevelParam(Hashtable hashtable) {
        Vector vector = ParamDesc.getReferPara(hashtable);
        int n = 0;
        while (n < vector.size()) {
            ParamDesc paramDesc = (ParamDesc)vector.get(n);
            if (hashtable.containsKey(paramDesc.getName().toUpperCase())) {
                hashtable.remove(paramDesc.getName().toUpperCase());
            }
            ++n;
        }
    }

    public static void getAllRelatedParamByValue(Hashtable hashtable, Vector vector, ParamDesc paramDesc, Object object) {
        if (paramDesc.type.equals(TYPE_PARAMETER)) {
            String[] stringArray = ParamDesc.splitValue(object.toString());
            int n = 0;
            while (n < stringArray.length) {
                ParamDesc paramDesc2 = (ParamDesc)hashtable.get(stringArray[n].toString().toUpperCase());
                if (paramDesc2 != null && !vector.contains(paramDesc2)) {
                    vector.add(paramDesc2);
                    Vector vector2 = paramDesc2.getValues();
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        String string = vector2.get(n2).toString();
                        ParamDesc.getAllRelatedParamByValue(hashtable, vector, paramDesc2, string);
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public static boolean hasNestedPara(Hashtable hashtable) {
        boolean bl = false;
        if (hashtable == null) {
            return bl;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
            if (!paramDesc.type.equals(TYPE_PARAMETER)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Vector getReferPara(Hashtable hashtable) {
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
            ParamDesc.getRelatedParamDescsByParam(hashtable, vector, paramDesc);
        }
        return vector;
    }

    public static String[] splitValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, TYPE_PARAMETER_SEPARATOR1);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.endsWith(TYPE_PARAMETER_SEPARATOR2)) {
                string2 = string2.substring(0, string2.length() - TYPE_PARAMETER_SEPARATOR2.length());
            }
            stringArray[n] = string2;
            ++n;
        }
        return stringArray;
    }

    public boolean IsParameters() {
        return this.type.equals(TYPE_PARAMETER);
    }

    public Vector getImportParams() {
        return this.error;
    }

    public void setImportParams(Vector vector) {
        this.error = vector;
    }

    public static boolean hasImportParam(Vector vector) {
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            ParamDesc paramDesc = (ParamDesc)vector.get(n);
            if (paramDesc.getImportParams() != null && paramDesc.getImportParams().size() != 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean isImportByPara(ParamDesc paramDesc, ParamDesc paramDesc2, Vector vector) {
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        ParamDesc paramDesc3 = null;
        if (paramDesc2 == null) {
            int n = 0;
            while (n < vector.size()) {
                paramDesc3 = (ParamDesc)vector.get(n);
                if (paramDesc3.getImportParams().contains(paramDesc.name) && vector.contains(paramDesc)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        } else if (vector.contains(paramDesc) && paramDesc2.error.contains(paramDesc.name)) {
            bl = true;
        }
        return bl;
    }

    public Vector getReferedBy() {
        return this.format;
    }

    public boolean isReferedBy() {
        return this.format != null && this.format.size() > 0;
    }

    public void clearReferedBy() {
        if (this.format != null) {
            this.format.clear();
            this.format = null;
        }
    }

    public boolean isReferOther() {
        return this.error != null && this.error.size() > 0;
    }

    public void addReferParamToVsortParams(Hashtable hashtable, Hashtable hashtable2, Vector vector) {
        if (this.error.size() != 0) {
            boolean bl = false;
            ParamDesc paramDesc = null;
            Enumeration enumeration = this.error.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                String string = ((String)e).toUpperCase();
                paramDesc = (ParamDesc)hashtable.get(string);
                if (!vector.contains(e)) {
                    int n = vector.indexOf(this.name);
                    if (n == -1) {
                        n = 0;
                    }
                    vector.insertElementAt(e, n);
                }
                if (hashtable2.get(string) == null) {
                    hashtable2.put(string, paramDesc);
                }
                if (paramDesc.format == null) {
                    paramDesc.format = new Vector();
                }
                if (!paramDesc.format.contains(this)) {
                    paramDesc.format.add(this);
                }
                if (paramDesc == null || paramDesc.error.size() == 0) continue;
                paramDesc.addReferParamToVsortParams(hashtable, hashtable2, vector);
            }
        }
    }

    public static Vector changedHashToVector(Hashtable hashtable) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)hashtable.get(enumeration.nextElement());
                if (paramDesc == null) continue;
                vector.add(paramDesc);
            }
        }
        return vector;
    }

    public static Hashtable changedVectorToHash(Vector vector) {
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ParamDesc paramDesc = (ParamDesc)vector.get(n);
                if (paramDesc != null) {
                    hashtable.put(paramDesc.getName().toUpperCase(), paramDesc);
                }
                ++n;
            }
        }
        return hashtable;
    }

    public void transferValues(ParamDesc paramDesc) {
        if (this.isReferOther()) {
            this.bNull.clear();
            this.booleanValue.clear();
            this.bNull.addAll(paramDesc.bNull);
            this.booleanValue.addAll(paramDesc.booleanValue);
        }
        this.setDefaultIndex(paramDesc.countTokens);
    }

    public String toString() {
        if (this.get) {
            return "(" + this.name + TYPE_PARAMETER_SEPARATOR2 + this.SqlToFml + ")";
        }
        return "(" + this.name + TYPE_PARAMETER_SEPARATOR2 + this.value.toString() + ")";
    }

    private String checkString(DbValue dbValue) {
        String string = "";
        if (dbValue != null && !dbValue.isNull()) {
            int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
            switch (n) {
                case 3: {
                    string = dbValue.toString();
                    break;
                }
                case 1: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).longValue()));
                    string = StringToolKit.replaceAll(string, TYPE_PARAMETER_SEPARATOR2, "");
                    break;
                }
                case 2: {
                    string = new String(NumberFormat.getNumberInstance(defaultLocale).format(((DbNumber)dbValue).doubleValue()));
                    string = StringToolKit.replaceAll(string, TYPE_PARAMETER_SEPARATOR2, "");
                    break;
                }
                case 5: {
                    string = ((DbChar)dbValue).value;
                    break;
                }
                case 4: {
                    string = new String(((DbBit)dbValue).value ? "TRUE" : "FALSE");
                    break;
                }
                case 6: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    string = simpleDateFormat.format(((DbDate)dbValue).getDate());
                    break;
                }
                case 7: {
                    string = new Time(((DbTime)dbValue).value).toString();
                    break;
                }
                case 8: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    string = simpleDateFormat.format(((DbTimestamp)dbValue).toUtilDate());
                    break;
                }
                default: {
                    if (!fatal.isErrorEnabled()) break;
                    fatal.error(dbValue + " Unknow parameter type!");
                }
            }
        }
        return string;
    }

    public boolean isUseCurrentDate() {
        return this.class$;
    }

    public boolean setUseCurrentDate(boolean bl) {
        if (bl && this.D.type != 6 && this.D.type != 7 && this.D.type != 8) {
            return false;
        }
        this.class$ = bl;
        return true;
    }

    public boolean isUseCurrentDateWhenBlank() {
        return this.clear;
    }

    public boolean setUseCurrentDateWhenBlank(boolean bl) {
        if (bl && this.D.type != 6 && this.D.type != 7 && this.D.type != 8) {
            return false;
        }
        this.clear = bl;
        return true;
    }

    public DbValue getDynamicValue(long l, Locale locale) {
        if (!this.class$ && !this.clear) {
            return null;
        }
        String string = this.clone;
        DbDateTime dbDateTime = null;
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTimeInMillis(l);
        switch (this.D.type) {
            case 6: {
                if (string.length() == 0 && this.clear) {
                    string = "yyyy-MM-dd";
                } else if (string.length() == 0) {
                    dbDateTime = new DbDate(this.J);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(45);
                int n2 = string.indexOf(45, n + 1);
                if (string.indexOf("yyyy") == -1) {
                    calendar.set(1, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("MM") == -1) {
                    calendar.set(2, Integer.parseInt(string.substring(n + 1, n2)) - 1);
                }
                if (string.indexOf("dd") == -1) {
                    calendar.set(5, Integer.parseInt(string.substring(n2 + 1)));
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                dbDateTime = new DbDate(this.J);
                dbDateTime.set(calendar.getTimeInMillis() - calendar.getTimeInMillis() % 1000L);
                break;
            }
            case 7: {
                if (string.length() == 0 && this.clear) {
                    string = "H:mm:ss";
                } else if (string.length() == 0) {
                    dbDateTime = new DbTime(this.J);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(58);
                int n3 = string.indexOf(58, n + 1);
                if (string.indexOf("H") == -1) {
                    calendar.set(11, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("mm") == -1) {
                    calendar.set(12, Integer.parseInt(string.substring(n + 1, n3)));
                }
                if (string.indexOf("ss") == -1) {
                    calendar.set(13, Integer.parseInt(string.substring(n3 + 1)));
                }
                dbDateTime = new DbTime(this.J);
                dbDateTime.set(calendar.getTimeInMillis() % 86400000L - calendar.getTimeInMillis() % 1000L);
                break;
            }
            case 8: {
                if (string.length() == 0 && this.clear) {
                    string = "yyyy-MM-dd-H:mm:ss";
                } else if (string.length() == 0) {
                    dbDateTime = new DbTimestamp(this.J);
                    dbDateTime.bNull = true;
                    break;
                }
                int n = string.indexOf(45);
                int n4 = string.indexOf(45, n + 1);
                int n5 = string.indexOf(45, n4 + 1);
                int n6 = string.indexOf(58, n5 + 1);
                int n7 = string.indexOf(58, n6 + 1);
                if (string.indexOf("yyyy") == -1) {
                    calendar.set(1, Integer.parseInt(string.substring(0, n)));
                }
                if (string.indexOf("MM") == -1) {
                    calendar.set(2, Integer.parseInt(string.substring(n + 1, n4)) - 1);
                }
                if (string.indexOf("dd") == -1) {
                    calendar.set(5, Integer.parseInt(string.substring(n4 + 1, n5)));
                }
                if (string.indexOf("H") == -1) {
                    calendar.set(11, Integer.parseInt(string.substring(n5 + 1, n6)));
                }
                if (string.indexOf("mm") == -1) {
                    calendar.set(12, Integer.parseInt(string.substring(n6 + 1, n7)));
                }
                if (string.indexOf("ss") == -1) {
                    calendar.set(13, Integer.parseInt(string.substring(n7 + 1)));
                }
                dbDateTime = new DbTimestamp(this.J);
                dbDateTime.set(calendar.getTimeInMillis() - calendar.getTimeInMillis() % 1000L);
            }
        }
        return dbDateTime;
    }

    public boolean setDynamicTemplate(String string) {
        if (string == null || string.length() == 0) {
            this.clone = "";
            return true;
        }
        switch (this.D.type) {
            case 6: {
                if (string.matches("((y{4}|\\d{2,4})-(M{2}|\\d{1,2})-(d{2}|\\d{1,2}))") && !string.matches("(\\d{2,4}-\\d{1,2}-\\d{1,2})")) {
                    this.clone = string;
                    return true;
                }
            }
            case 7: {
                if (string.matches("((H|\\d{1,2}):(m{2}|\\d{1,2}):(s{2}|\\d{1,2}))") && !string.matches("(\\d{1,2}:\\d{1,2}:\\d{1,2})")) {
                    this.clone = string;
                    return true;
                }
            }
            case 8: {
                if (!string.matches("((y{4}|\\d{2,4})-(M{2}|\\d{1,2})-(d{2}|\\d{1,2}))-((H|\\d{1,2}):(m{2}|\\d{1,2}):(s{2}|\\d{1,2}))") || string.matches("(\\d{2,4}-\\d{1,2}-\\d{1,2})-(\\d{1,2}:\\d{1,2}:\\d{1,2})")) break;
                this.clone = string;
                return true;
            }
        }
        return false;
    }

    public String getDynamicTemplate() {
        return this.clone;
    }

    public void setHideParameterWhenSingleValueReturn(boolean bl) {
        this.contains = bl;
    }

    public boolean isHideParameterWhenSingleValueReturn() {
        return this.contains;
    }

    public void setIsMultipleValue(boolean bl) {
        this.get = bl;
    }

    public boolean isMultipleValue() {
        return this.get;
    }

    public String[] getMultiDisplayValue(fArray fArray2, Locale locale) {
        if (!this.get) {
            return null;
        }
        if (this.isAllSelected()) {
            return new String[]{"ALL"};
        }
        DbValue[] dbValueArray = fArray2.value;
        String[] stringArray = new String[dbValueArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.getDisplayValue(dbValueArray[n], locale);
            ++n;
        }
        return stringArray;
    }

    public String[] setValue(String[] stringArray, Locale locale) throws InvalidParameterException {
        fArray fArray2 = fArray.getInstance(this.D.type, this.J);
        DbColDesc dbColDesc = DataTypeDef.toDbColDesc(this.D.type, this.D.precise, this.D.scale);
        dbColDesc.setArray(true);
        dbColDesc.setColName(this.name.toUpperCase());
        fArray2.setColDesc(dbColDesc);
        this.setAllSelected(false);
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        int n = stringArray.length;
        DbValue[] dbValueArray = new DbValue[n];
        int n2 = 0;
        while (n2 < n) {
            dbValueArray[n2] = this.applyLocalizedPattern(stringArray[n2], locale2, true);
            ++n2;
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            if (this.chainID(dbValueArray[n3])) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (this.getWhenOutOfRange() == 2 && bl) {
            String string = this.getDefaultValue();
            DbValue dbValue = this.parseInternalValue(string);
            fArray2.set(new DbValue[]{dbValue});
            if (dbValue.bNull) {
                fArray2.bNull = true;
            }
            this.SqlToFml = fArray2;
        } else {
            fArray2.set(dbValueArray);
            if (n == 0) {
                fArray2.bNull = true;
            }
            this.SqlToFml = fArray2;
        }
        return this.getMultiDisplayValue((fArray)this.SqlToFml, locale2);
    }

    public String[] setValue(fArray fArray2, Locale locale) throws InvalidParameterException {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        this.SqlToFml = fArray2;
        if (fArray2 instanceof IAllValue) {
            this.setAllSelected(true);
        } else {
            this.setAllSelected(false);
            DbValue[] dbValueArray = fArray2.value;
            boolean bl = false;
            if (dbValueArray != null) {
                int n = 0;
                while (n < dbValueArray.length) {
                    if (this.chainID(dbValueArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl && this.getWhenOutOfRange() == 2) {
                String string = this.getDefaultValue();
                fArray fArray3 = fArray.getInstance(this.D.type, this.J);
                DbValue dbValue = this.parseInternalValue(string);
                fArray3.set(new DbValue[]{dbValue});
                if (dbValue.bNull) {
                    fArray3.bNull = true;
                }
                this.SqlToFml = fArray3;
            }
        }
        return this.getMultiDisplayValue((fArray)this.SqlToFml, locale2);
    }

    public String[] getMultiStrValue() {
        if (!this.get) {
            return null;
        }
        if (this.SqlToFml == null) {
            try {
                this.initParam(defaultLocale);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (fatal.isErrorEnabled()) {
                    fatal.error("", invalidParameterException);
                }
                return new String[0];
            }
        }
        DbValue[] dbValueArray = ((fArray)this.SqlToFml).value;
        String[] stringArray = new String[dbValueArray.length];
        int n = 0;
        while (n < dbValueArray.length) {
            stringArray[n] = this.booleanValue(dbValueArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void setSelectedValues(Vector vector) {
        this.getAllRelatedParamByValue = vector;
    }

    public Vector getSelectedValues() {
        return this.getAllRelatedParamByValue;
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public void setIsCascading(boolean bl) {
        this.isCascading = bl;
    }

    public void setCascadingInfo(String string, String string2, String string3, boolean bl) {
        this.previousLevel = string2;
        this.nextLevel = string3;
        this.chainID = string;
        this.isSetAsParameter = bl;
    }

    public String getChainID() {
        return this.chainID;
    }

    public String getPreviousLevel() {
        return this.previousLevel;
    }

    public String getNextLevel() {
        return this.nextLevel;
    }

    public boolean isSetAsParameter() {
        return this.isSetAsParameter;
    }

    public void setAllSelected(boolean bl) {
        this.isAllSelected = bl;
    }

    public boolean isAllSelected() {
        boolean bl = false;
        if (!this.get) {
            return false;
        }
        bl = !this.getBeColumn ? false : this.isAllSelected;
        return bl;
    }

    public void setAllowAll(boolean bl) {
        this.getBeColumn = bl;
    }

    public boolean isAllowAll() {
        return this.getBeColumn;
    }

    public void setAllowTypeIn(boolean bl) {
        this.allowTypeIn = bl;
    }

    public boolean isAllowTypeIn() {
        return this.allowTypeIn;
    }

    public void setWhenOutOfRange(int n) {
        this.whenOutOfRange = n;
    }

    public int getWhenOutOfRange() {
        return this.whenOutOfRange;
    }

    public void setValueList(Vector vector) throws InvalidParameterException {
    }

    public String[] detectInvalidValues(String[] stringArray, Locale locale) throws InvalidParameterException {
        String[] stringArray2;
        if (this.isAllSelected()) {
            return new String[0];
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = defaultLocale;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            stringArray2 = this.applyLocalizedPattern(stringArray[n], locale2, true);
            if (this.bNull.size() > 0 && !this.bNull.contains(stringArray2)) {
                vector.add(stringArray[n]);
            }
            ++n;
        }
        stringArray2 = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray2[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray2;
    }

    public void setAllowUseExpression(boolean bl) {
        this.getBinding = bl;
    }

    public boolean allowUseExpression() {
        return this.getBinding;
    }

    public String getLocalizedUserFormat(Locale locale) {
        if (this.containsKey == null || this.containsKey.length() == 0) {
            return this.containsKey;
        }
        String string = null;
        int n = this.D.type;
        if (DataTypeDef.isArray(n)) {
            n -= 11;
        }
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.containsKey, dateFormatSymbols);
                string = simpleDateFormat.toLocalizedPattern();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                DecimalFormat decimalFormat = new DecimalFormat(this.containsKey, decimalFormatSymbols);
                string = decimalFormat.toLocalizedPattern();
                break;
            }
            default: {
                string = this.containsKey;
            }
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

