/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.export.util.CCUtil;
import jet.naming.PropertyNameConstant;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.UnderLinePainter;
import jet.udo.JRObjectRender;
import jet.util.FontSets;
import jet.util.PropertySetable;

public class JReportParagraphText
extends TComponent
implements JRObjectRender,
PainterConstants {
    private int I;
    private List KEY_FRACTIONALMETRICS = new ArrayList();

    public void setProperty(PropertySetable propertySetable) {
        DSParagraphText dSParagraphText = (DSParagraphText)propertySetable;
        this.I = dSParagraphText.getResolution();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        if (color != null) {
            this.setBackground(color);
            this.setEraser(true);
        } else {
            this.setEraser(false);
        }
        this.KEY_FRACTIONALMETRICS = this.QOIV(dSParagraphText);
    }

    public void paint(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            if (JReportViewer.Z) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        }
        this.KEY_FRACTIONALMETRICS(graphics);
        int n = 0;
        while (n < this.KEY_FRACTIONALMETRICS.size()) {
            ExportText exportText = (ExportText)this.KEY_FRACTIONALMETRICS.get(n);
            this.I(graphics, exportText);
            ++n;
        }
    }

    private void I(Graphics graphics, ExportText exportText) {
        if (exportText != null && exportText.C != null) {
            graphics.setColor(exportText.C);
            if (exportText.I != null && exportText.Z != null && exportText.Z.length() > 0) {
                int n;
                int n2;
                graphics.setFont(exportText.I);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = fontMetrics.getHeight();
                int n4 = fontMetrics.getAscent();
                int n5 = fontMetrics.getLeading();
                int n6 = exportText.x;
                int n7 = exportText.y + n4;
                graphics.drawString(exportText.Z, n6, n7);
                ExportLine exportLine = exportText.B;
                if (exportLine != null) {
                    n2 = n6 + exportLine.I;
                    n = n7;
                    UnderLinePainter.paint(graphics, n6, n7 + 2, n2, n + 2, exportLine.Z, exportLine.C);
                }
                if ((exportLine = exportText.D) != null) {
                    n7 = exportText.y + n3 / 2 + (n5 > 0 ? 1 : 3);
                    n2 = n6 + exportLine.I;
                    n = n7;
                    Painter.drawLine(graphics, n6, n7, n2, n, exportLine.C, 1, exportLine.Z);
                }
            }
        }
    }

    private void KEY_FRACTIONALMETRICS(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        if (color != null && this.hasEraser()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    private List QOIV(DSParagraphText dSParagraphText) {
        String string = dSParagraphText.getText();
        if (string != null && string.length() > 0) {
            int n;
            Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
            String string2 = CCUtil.getStringPropertyByName(dSParagraphText, "FontFace");
            int n2 = 0;
            if (CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold")) {
                n2 |= 1;
            }
            if (CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic")) {
                n2 |= 2;
            }
            boolean bl = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript") != 0;
            float f = CCUtil.getIntPropertyByName(dSParagraphText, "FontSize");
            if (bl) {
                f = f * 2.0f / 3.0f;
            }
            Font font = FontSets.getFont(string2, n2, f, this.I);
            ExportLine exportLine = this.VALUE_FRACTIONALMETRICS_ON(dSParagraphText);
            ExportLine exportLine2 = this.add(dSParagraphText);
            int n3 = CCUtil.getIntPropertyByName((DSParagraph)dSParagraphText.getParent(), PropertyNameConstant.getNameByID(979));
            if (n3 == 3 && (n = dSParagraphText.getWords().size()) > 0) {
                int n4 = 0;
                while (n4 < n) {
                    string = (String)dSParagraphText.getWords().elementAt(n4);
                    int n5 = Unit.convertUnitToPixel(dSParagraphText.getWordsPosition()[n4] + dSParagraphText.getTextX(), this.I);
                    int n6 = Unit.convertUnitToPixel(dSParagraphText.getTextY(), this.I);
                    ExportText exportText = this.VALUE_FRACTIONALMETRICS_OFF(string, n5, n6, font, color, exportLine, exportLine2);
                    this.KEY_FRACTIONALMETRICS.add(exportText);
                    ++n4;
                }
                return this.KEY_FRACTIONALMETRICS;
            }
            int n7 = Unit.convertUnitToPixel(dSParagraphText.getTextX(), this.I);
            int n8 = Unit.convertUnitToPixel(dSParagraphText.getTextY(), this.I);
            ExportText exportText = this.VALUE_FRACTIONALMETRICS_OFF(string, n7, n8, font, color, exportLine, exportLine2);
            this.KEY_FRACTIONALMETRICS.add(exportText);
        }
        return this.KEY_FRACTIONALMETRICS;
    }

    private ExportText VALUE_FRACTIONALMETRICS_OFF(String string, int n, int n2, Font font, Color color, ExportLine exportLine, ExportLine exportLine2) {
        ExportText exportText = null;
        if (string != null && string.length() > 0) {
            exportText = new ExportText(this, string);
            exportText.C = color;
            exportText.I = font;
            exportText.x = n;
            exportText.y = n2;
            exportText.D = exportLine2;
            exportText.B = exportLine;
        }
        return exportText;
    }

    private ExportLine VALUE_FRACTIONALMETRICS_ON(DSParagraphText dSParagraphText) {
        ExportLine exportLine = null;
        boolean bl = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        if (bl) {
            exportLine = new ExportLine(this);
            exportLine.Z = this.Z(CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle"));
            exportLine.C = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
            exportLine.x = Unit.convertUnitToPixel(dSParagraphText.getX(), this.I);
            exportLine.y = Unit.convertUnitToPixel(dSParagraphText.getY(), this.I);
            exportLine.I = Unit.convertUnitToPixel(dSParagraphText.getWidth(), this.I);
        }
        return exportLine;
    }

    private int Z(int n) {
        switch (n) {
            case 11: {
                return 11;
            }
            case 5: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 9;
            }
            case 7: {
                return 7;
            }
            case 13: {
                return 13;
            }
            case 15: {
                return 15;
            }
            case 10: {
                return 10;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 16: {
                return 16;
            }
            case 1: {
                return 1;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 6;
            }
            case 12: {
                return 12;
            }
            case 14: {
                return 14;
            }
        }
        return 1;
    }

    private ExportLine add(DSParagraphText dSParagraphText) {
        ExportLine exportLine = null;
        boolean bl = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        if (bl) {
            exportLine = new ExportLine(this);
            exportLine.Z = this.convertUnitToPixel(CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle"));
            exportLine.C = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
            exportLine.x = Unit.convertUnitToPixel(dSParagraphText.getX(), this.I);
            exportLine.y = Unit.convertUnitToPixel(dSParagraphText.getY(), this.I);
            exportLine.I = Unit.convertUnitToPixel(dSParagraphText.getWidth(), this.I);
        }
        return exportLine;
    }

    private int convertUnitToPixel(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 5;
            }
        }
        return 0;
    }

    class ExportLine {
        int x;
        int y;
        int I;
        int Z;
        Color C;
        private final JReportParagraphText this$0;

        ExportLine(JReportParagraphText jReportParagraphText) {
            this.this$0 = jReportParagraphText;
        }
    }

    class ExportText {
        int x;
        int y;
        Font I;
        String Z;
        Color C;
        ExportLine B;
        ExportLine D;
        private final JReportParagraphText this$0;

        ExportText(JReportParagraphText jReportParagraphText, String string) {
            this.this$0 = jReportParagraphText;
            this.x = 0;
            this.y = 0;
            this.Z = null;
            this.Z = string;
        }
    }
}

