/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.awt.Event;
import jet.JResource;
import jet.connect.Db;
import jet.connect.DbColDesc;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.SupportedSQLType;
import jet.universe.UMapTable;

public abstract class JetUResourceEntity
extends JetUDBTreeNode {
    private static char AfterAdd;
    private static String InitAfterLoad;
    public JetString guiField = new JetString(this, "GUIField");
    public JetUnitNumber displaywidth = new JetUnitNumber(this, "DisplayWidth");
    private String arg = null;
    private static JRLogger charAt;
    static Class class$jet$universe$JetUResourceEntity;
    static final boolean $assertionsDisabled;

    public JetUResourceEntity() {
        this.guiField.set("Standard_DBField");
        this.displaywidth.set(0);
    }

    public JetUResourceEntity(String string, String string2) {
        super(string, string2);
        this.guiField.set("Standard_DBField");
        this.displaywidth.set(0);
    }

    public void setResourceName(String string) {
        String string2 = this.arg;
        super.setResourceName(string);
        UMapTable uMapTable = this.getMapTable();
        if (uMapTable != null) {
            uMapTable.updateElementName(this, string2);
        }
    }

    public String getResourceNameInUpperCase() {
        return this.arg;
    }

    public boolean IsTypeSupported() {
        DbColDesc dbColDesc = this.getColDesc();
        if (dbColDesc != null) {
            return SupportedSQLType.isSupported(dbColDesc);
        }
        return true;
    }

    public String getGUIField() {
        return this.guiField.get();
    }

    public void setGUIField(String string) {
        this.guiField.set(string);
    }

    public void createDescription() {
        DbColDesc dbColDesc = this.getColDesc();
        if (dbColDesc != null) {
            this.setDesc(JResource.getMessage("CAT_41", (Object)Db.toTypeString(dbColDesc.sqlType)));
        } else {
            this.setDesc("");
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == -1000 && event.arg != null && ((String)event.arg).equalsIgnoreCase("Name")) {
            this.arg = this.name.get().toUpperCase();
        }
        return super.handleEvent(event);
    }

    public void InitAfterLoad() {
        this.arg = this.name.get().toUpperCase();
        super.InitAfterLoad();
    }

    public void InitAfterCreate() {
        this.arg = this.name.get().toUpperCase();
        if (this.desc.get() == null || this.desc.get().length() == 0) {
            this.createDescription();
        }
        this.AfterAdd();
    }

    public void BeforeRemove() {
        UMapTable uMapTable = this.getMapTable();
        if (uMapTable != null) {
            uMapTable.removeElement(this);
        }
    }

    public void AfterAdd() {
        UMapTable uMapTable = this.getMapTable();
        if (uMapTable != null) {
            uMapTable.addElement(this);
        }
    }

    public static String transferQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '\"' || c == '\\') {
                stringBuffer = stringBuffer.insert(n, AfterAdd);
                ++n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean AfterAdd(String string) {
        if (!($assertionsDisabled || string != null && string.length() != 0)) {
            throw new AssertionError((Object)"Can not accept null identifer as Resource Entity!");
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String qutoedWhenNeed(String string) {
        if (!JetUResourceEntity.AfterAdd(string)) {
            string = InitAfterLoad + string + InitAfterLoad;
        }
        return "@" + string;
    }

    public String getResourceNameString() {
        String string = new String(this.name.get());
        string = JetUResourceEntity.transferQuote(string);
        string = JetUResourceEntity.qutoedWhenNeed(string);
        return string;
    }

    JetObject Z() {
        try {
            return (JetObject)Class.forName("jet.report.JetRptDBField").newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    void I(JetObject jetObject) {
        jetObject.nameToProperty("ColumnName").set(this.getResourceName());
    }

    public JetObject getGUIFieldObject(StringBuffer stringBuffer) {
        JetObject jetObject = null;
        jetObject = this.Z();
        if (jetObject != null) {
            this.I(jetObject);
        }
        return jetObject;
    }

    public boolean isMediaField() {
        boolean bl = false;
        DbColDesc dbColDesc = this.getColDesc();
        if (dbColDesc != null) {
            bl = dbColDesc.getSqlType() == -2 || dbColDesc.getSqlType() == -4;
        }
        return bl;
    }

    public abstract DbColDesc getColDesc();

    public abstract String getDefinition();

    public abstract String toString();

    public String getRealName() {
        return null;
    }

    public void addCaseSensitiveInfo(DbColDesc dbColDesc) {
        JetUConnection jetUConnection;
        JetUDatabase jetUDatabase = this.getDatabase();
        if (jetUDatabase != null && (jetUConnection = jetUDatabase.getConnection()) != null) {
            dbColDesc.setIgnoreCase(!jetUConnection.isSQLTypeCaseSensitive(dbColDesc.getSqlType()));
        }
    }

    public void addEncodingPattern(DbColDesc dbColDesc) {
        JetUConnection jetUConnection;
        JetUDatabase jetUDatabase = this.getDatabase();
        if (jetUDatabase != null && (jetUConnection = jetUDatabase.getConnection()) != null) {
            int n = jetUConnection.getEncodingPattern();
            if (n == 0) {
                dbColDesc.setNotAutoEncode(false);
            } else {
                dbColDesc.setNotAutoEncode(true);
            }
            if (n == 1) {
                dbColDesc.setEncode(true);
            }
            if (n == 2) {
                dbColDesc.setEncode(false);
            }
        }
    }

    public boolean isSimilar(JetUResourceEntity jetUResourceEntity) {
        return this.name.equal(jetUResourceEntity.name) && this.getClass().getName().equals(jetUResourceEntity.getClass().getName());
    }

    public boolean isSimilar(JetUDBTreeNode jetUDBTreeNode) {
        return jetUDBTreeNode instanceof JetUResourceEntity && this.isSimilar((JetUResourceEntity)jetUDBTreeNode);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUResourceEntity == null ? (class$jet$universe$JetUResourceEntity = JetUResourceEntity.class$("jet.universe.JetUResourceEntity")) : class$jet$universe$JetUResourceEntity).desiredAssertionStatus();
        AfterAdd = (char)92;
        InitAfterLoad = "\"";
        charAt = JRLogger.getLogger((class$jet$universe$JetUResourceEntity == null ? (class$jet$universe$JetUResourceEntity = JetUResourceEntity.class$("jet.universe.JetUResourceEntity")) : class$jet$universe$JetUResourceEntity).getName());
    }
}

