/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.connect.DbBufSQLException;
import jet.connect.DbColDesc;
import jet.connect.Record;
import jet.datasource.JRResultSetException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.EndOfRecordsException;
import jet.exception.FormulaRingException;
import jet.exception.InvalidParameterException;
import jet.exception.NoRecordsFoundException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.universe.DataCollection;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.resultfile.UDbBuffer;
import jet.universe.resultfile.URecordModel;
import jet.universe.resultfile.UResultFileException;
import jet.util.RAFile;
import toolkit.db.ParameterFormatInvalid;

public class UResultFile {
    public static final String BLOB_FILE_EXTENSION = ".col";
    public static final String DESCRIPTION_FILE_EXTENSION = ".desc";
    Frame QOIV = null;
    Container addElement = null;
    JetUUniverse addRecord = null;
    JetUQueriable append = null;
    File class$ = null;
    UQueryEngine close = null;
    ResultSet countRecords = null;
    DbColDesc[] createBlobFiles = null;
    URecordModel createEngine = null;
    Hashtable createQueryEngine = new Hashtable();
    UDbBuffer createRecordModel;
    DataCollection currentRecord;
    private static JRLogger elementAt = JRLogger.getLogger((class$jet$universe$resultfile$UResultFile == null ? (class$jet$universe$resultfile$UResultFile = UResultFile.class$("jet.universe.resultfile.UResultFile")) : class$jet$universe$resultfile$UResultFile).getName());
    static Class class$jet$universe$resultfile$UResultFile;

    public UResultFile(JetUUniverse jetUUniverse, JetUQueriable jetUQueriable, File file) {
        this.addRecord = jetUUniverse;
        this.append = jetUQueriable;
        this.class$ = file;
    }

    public void setContainerDialog(Container container) {
        this.addElement = container;
    }

    public boolean generateQueryResultFile() throws UResultFileException {
        boolean bl = this.createQueryEngine();
        if (!bl) {
            return bl;
        }
        this.getResultSet();
        this.createRecordModel();
        this.createBlobFiles();
        this.generateResultFile();
        return true;
    }

    protected boolean createQueryEngine() throws UResultFileException {
        Vector vector = this.append.getFields();
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(n2);
            vector2.addElement(jetUResourceEntity.getResourceName());
            ++n2;
        }
        try {
            this.close = UQueryEngine.createEngine(this.addRecord, this.append.getDatabase().getResourceName(), this.append.getResourceName(), vector2, null, null, false);
            this.close.initialize();
            Hashtable hashtable = this.close.getParamsBuff();
            this.QOIV(hashtable);
            boolean bl = UResultFile.initParameters(this.addElement, hashtable);
            if (!bl) {
                return false;
            }
            this.close.initParameters();
            this.close.start();
            return true;
        }
        catch (CannotFindQuery cannotFindQuery) {
            throw new UResultFileException(1, cannotFindQuery.getMessage());
        }
        catch (CannotFindEntity cannotFindEntity) {
            throw new UResultFileException(1, cannotFindEntity.getMessage());
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new UResultFileException(1, invalidParameterException.getMessage());
        }
        catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
            throw new UResultFileException(1, cannotFindFrmlRefFld.getMessage());
        }
        catch (ParameterNotResolved parameterNotResolved) {
            throw new UResultFileException(1, parameterNotResolved.getMessage());
        }
        catch (FormulaHasGrammarError formulaHasGrammarError) {
            throw new UResultFileException(1, formulaHasGrammarError.getMessage());
        }
        catch (FldNotFoundInQuery fldNotFoundInQuery) {
            throw new UResultFileException(1, fldNotFoundInQuery.getMessage());
        }
        catch (SubLinkError subLinkError) {
            throw new UResultFileException(1, subLinkError.getMessage());
        }
        catch (CannotUseGlobalVarInFrmlWhere cannotUseGlobalVarInFrmlWhere) {
            throw new UResultFileException(1, cannotUseGlobalVarInFrmlWhere.getMessage());
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            throw new UResultFileException(1, parseFormulaFailedException.getMessage());
        }
        catch (QueryWhereFormulaGrammarError queryWhereFormulaGrammarError) {
            throw new UResultFileException(1, queryWhereFormulaGrammarError.getMessage());
        }
        catch (FormulaRingException formulaRingException) {
            throw new UResultFileException(1, formulaRingException.getMessage());
        }
        catch (LoadUserDataSourceException loadUserDataSourceException) {
            throw new UResultFileException(1, loadUserDataSourceException.getMessage());
        }
        catch (JRUserDataSourceException jRUserDataSourceException) {
            throw new UResultFileException(1, jRUserDataSourceException.getMessage());
        }
        catch (JRResultSetException jRResultSetException) {
            throw new UResultFileException(1, jRResultSetException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new UResultFileException(1, sQLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UResultFileException(1, classNotFoundException.getMessage());
        }
    }

    protected static boolean initParameters(Container container, Hashtable hashtable) throws InvalidParameterException {
        if (hashtable.isEmpty()) {
            return true;
        }
        Hashtable hashtable2 = hashtable;
        return false;
    }

    void QOIV(Hashtable hashtable) throws SQLException, ClassNotFoundException, InvalidParameterException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ParamDesc paramDesc = (ParamDesc)enumeration.nextElement();
            if (paramDesc.getBeColumn() != 4) continue;
            if (this.currentRecord == null) {
                this.currentRecord = new DataCollection();
            }
            Vector[] vectorArray = this.currentRecord.getResultSet(this.addRecord, this.append.getDatabase().getResourceName(), paramDesc.getColumn(), paramDesc.getColumns(), paramDesc.isDistinct(), paramDesc.getFormat());
            paramDesc.setValues(vectorArray[0], Locale.getDefault());
            paramDesc.setShowValues(vectorArray.length > 1 ? vectorArray[1] : vectorArray[0]);
            if (vectorArray[0].isEmpty()) continue;
            paramDesc.setDefaultIndex(0);
        }
    }

    protected void getResultSet() throws UResultFileException {
        try {
            this.countRecords = this.close.getResultSet();
        }
        catch (LoadUserDataSourceException loadUserDataSourceException) {
            throw new UResultFileException(2, loadUserDataSourceException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UResultFileException(2, classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new UResultFileException(2, sQLException.getMessage());
        }
        catch (ParameterFormatInvalid parameterFormatInvalid) {
            throw new UResultFileException(2, parameterFormatInvalid.getMessage());
        }
    }

    protected void createRecordModel() throws UResultFileException {
        Vector vector = this.close.getDbFlds();
        int[] nArray = this.close.getDbFldsBackIndex();
        Vector vector2 = null;
        int[] nArray2 = null;
        if (this.close.haveLocalWhere()) {
            vector2 = this.close.getDbFldsInLocalWhere();
            nArray2 = this.close.getDbFldsInLocalWhereBackIndex();
        }
        int n = vector.size();
        if (this.close.haveLocalWhere()) {
            n += vector2.size();
        }
        Vector vector3 = new Vector(n + 1);
        int[] nArray3 = new int[n + 1];
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            if (nArray[n3] != -1) {
                vector3.addElement(vector.elementAt(nArray[n3] - 1));
                nArray3[n3] = n2++;
            } else if (vector2 != null && nArray2 != null) {
                vector3.addElement(vector2.elementAt(nArray2[n3] - 1));
                nArray3[n3] = n2++;
            } else {
                nArray3[n3] = -1;
            }
            ++n3;
        }
        this.createBlobFiles = new DbColDesc[n];
        int n4 = 0;
        while (n4 < n) {
            String string = (String)vector3.elementAt(n4);
            this.createBlobFiles[n4] = new DbColDesc(this.addRecord.getSQLType(this.append.getDatabase().getResourceName(), this.append.getResourceName(), string));
            this.createBlobFiles[n4].setColName(string);
            ++n4;
        }
        try {
            this.createEngine = new URecordModel(this.createBlobFiles);
            this.createEngine.setResultSet(this.countRecords);
            this.createEngine.setColumnMap(nArray3);
        }
        catch (SQLException sQLException) {
            throw new UResultFileException(3, sQLException.getMessage());
        }
    }

    protected void createBlobFiles() throws UResultFileException {
        try {
            int n = 0;
            while (n < this.createBlobFiles.length) {
                if (this.createBlobFiles[n].getSqlType() == -1 || this.createBlobFiles[n].getSqlType() == -4 || this.createBlobFiles[n].getSqlType() == 2005 || this.createBlobFiles[n].getSqlType() == 2004 || this.createBlobFiles[n].isArray()) {
                    String string = this.class$.getPath() + BLOB_FILE_EXTENSION + n;
                    RAFile rAFile = new RAFile(string, "rw");
                    this.createQueryEngine.put(this.createBlobFiles[n], rAFile);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new UResultFileException(4, iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateResultFile() throws UResultFileException {
        try {
            this.createRecordModel = new UDbBuffer(this.createEngine, this.class$, this.createQueryEngine);
            this.createRecordModel.setNeedWaitFetch(false);
            try {
                while (true) {
                    this.createEngine.fetch();
                    Record record = this.createEngine.currentRecord;
                    this.createRecordModel.addRecord(record);
                }
            }
            catch (NoRecordsFoundException noRecordsFoundException) {
                this.createRecordModel.finish();
                this.createRecordModel.refreshAllToFile();
                this.createRecordModel.close();
                this.generateDescriptionFile();
                this.close();
                return;
            }
            catch (EndOfRecordsException endOfRecordsException) {
                this.createRecordModel.finish();
                this.createRecordModel.refreshAllToFile();
                this.createRecordModel.close();
                this.generateDescriptionFile();
                this.close();
                return;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof DbBufSQLException) {
                throw new UResultFileException(7, sQLException.getMessage());
            }
            throw new UResultFileException(6, sQLException.getMessage());
        }
        catch (IOException iOException) {
            throw new UResultFileException(7, iOException.getMessage());
        }
    }

    protected void generateDescriptionFile() throws UResultFileException {
        int n = this.createRecordModel.countRecords();
        this.createEngine.setRecordCount(n);
        try {
            RAFile rAFile = new RAFile(this.class$.getPath() + DESCRIPTION_FILE_EXTENSION, "rw");
            this.createEngine.write(rAFile);
            rAFile.close();
        }
        catch (IOException iOException) {
            throw new UResultFileException(8, iOException.getMessage());
        }
    }

    public void close() throws SQLException {
        if (this.close != null) {
            this.close.end();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

