/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.util.LocaleUtil;
import jet.util.WildcardMatcher;

public class NLSResourceBundle {
    public static String RPT_FILE_EXTENSION = ".rpt";
    public static String CLS_FILE_EXTENSION = ".cls";
    public static String PROPS_FILE_EXTENSION = ".properties";
    public static String FILENAME_CONCAT_CHAR = "_";
    public static String RESOURCE_HEADER = null;
    public static String COMMENT_LINE0 = "#JReport Resources of ";
    public static String COMMENT_LINE1 = "# ---------------------------------------------------------- #";
    public static String COMMENT_LINE2 = "# Note: You must provide correct encoding after 'encoding='. #";
    public static String COMMENT_LINE3 = "# ---------------------------------------------------------- #";
    public static String KEY_ENCODING = "encoding";
    public static String KEY_VALUE_SEPARATOR = "=";
    protected static String CATEGORY_DEFAULT = "KEY";
    public static String CATEGORY_KEY_CONCAT_CHAR = "_";
    protected Properties propResources = new Properties();
    protected String strEncoding = null;
    protected static final String KEY_COPYRIGHT = "copyright";
    protected boolean isNewVersion = false;
    public static final String VALUES_CONCAT_CHAR = ",";

    public void load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        this.propResources.load(inputStream);
        this.strEncoding = this.propResources.getProperty(KEY_ENCODING);
        if (this.strEncoding == null) {
            this.strEncoding = "8859_1";
        }
        this.isNewVersion = this.propResources.getProperty(KEY_COPYRIGHT) != null && this.propResources.getProperty(KEY_COPYRIGHT).equalsIgnoreCase("Jinfonet Software");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205002, new String[]{string});
        }
        if (string == null) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            this.load(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string, Locale locale) throws IOException {
        block12: {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205004, new String[]{string, String.valueOf(locale)});
            }
            if (string == null || locale == null) {
                return;
            }
            if (string.endsWith(CLS_FILE_EXTENSION)) {
                string = string.substring(0, string.length() - CLS_FILE_EXTENSION.length());
            } else if (string.endsWith(RPT_FILE_EXTENSION)) {
                string = string.substring(0, string.length() - RPT_FILE_EXTENSION.length());
            }
            File file = new File(string + FILENAME_CONCAT_CHAR + locale + PROPS_FILE_EXTENSION);
            if (!file.exists() && !(file = new File(string + FILENAME_CONCAT_CHAR + locale.getLanguage() + PROPS_FILE_EXTENSION)).exists()) {
                file = new File(string + PROPS_FILE_EXTENSION);
            }
            if (file != null && file.exists()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, 6205005, new String[]{file.getAbsolutePath()});
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    this.load(fileInputStream);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
                {
                    break block12;
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205006, new String[]{string, String.valueOf(locale)});
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205007, new String[]{string, String.valueOf(locale)});
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        this.storeWithEncoding(outputStream, System.getProperty("file.encoding"));
    }

    public void store(String string) throws IOException {
        this.storeWithEncoding(string, System.getProperty("file.encoding"));
    }

    public void store(String string, Locale locale) throws IOException {
        this.storeWithEncoding(string, locale, System.getProperty("file.encoding"));
    }

    protected void storeWithEncoding(String string, Locale locale, String string2) throws IOException {
        if (string.endsWith(CLS_FILE_EXTENSION)) {
            string = string.substring(0, string.length() - CLS_FILE_EXTENSION.length());
        } else if (string.endsWith(RPT_FILE_EXTENSION)) {
            string = string.substring(0, string.length() - RPT_FILE_EXTENSION.length());
        }
        String string3 = string + FILENAME_CONCAT_CHAR + locale + PROPS_FILE_EXTENSION;
        String string4 = string.substring(string.lastIndexOf(File.separator) + 1);
        this.CATEGORY_DEFAULT(string3, string2, string4, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeWithEncoding(String string, String string2) throws IOException {
        Object[] objectArray = this.CLS_FILE_EXTENSION(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            if (objectArray == null) {
                this.storeWithEncoding(fileOutputStream, string2);
            } else {
                this.CATEGORY_KEY_CONCAT_CHAR(fileOutputStream, string2, (String)objectArray[0], (Locale)objectArray[1]);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    protected void storeWithEncoding(OutputStream outputStream, String string) throws IOException {
        this.propResources.store(outputStream, RESOURCE_HEADER);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        printWriter.println(COMMENT_LINE1);
        printWriter.println(COMMENT_LINE2);
        printWriter.println(COMMENT_LINE3);
        printWriter.println(KEY_ENCODING + KEY_VALUE_SEPARATOR + string);
        if (this.isNewVersion) {
            printWriter.println(KEY_COPYRIGHT + KEY_VALUE_SEPARATOR + "Jinfonet Software");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CATEGORY_DEFAULT(String string, String string2, String string3, Locale locale) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            this.CATEGORY_KEY_CONCAT_CHAR(fileOutputStream, string2, string3, locale);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private void CATEGORY_KEY_CONCAT_CHAR(OutputStream outputStream, String string, String string2, Locale locale) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "8859_1");
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
        printWriter.println(COMMENT_LINE0 + string2 + " On " + locale.toString());
        this.propResources.store(outputStream, RESOURCE_HEADER);
        printWriter.println(COMMENT_LINE1);
        printWriter.println(COMMENT_LINE2);
        printWriter.println(COMMENT_LINE3);
        printWriter.println(KEY_ENCODING + KEY_VALUE_SEPARATOR + string);
        if (this.isNewVersion) {
            printWriter.println(KEY_COPYRIGHT + KEY_VALUE_SEPARATOR + "Jinfonet Software");
        }
    }

    private Object[] CLS_FILE_EXTENSION(String string) {
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1, string.length() - PROPS_FILE_EXTENSION.length());
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = 0;
        String string3 = string2.toLowerCase();
        while (n < localeArray.length) {
            if (string3.endsWith(localeArray[n].toString().toLowerCase())) {
                return new Object[]{string2.substring(0, string2.length() - localeArray[n].toString().length() - 1), localeArray[n]};
            }
            ++n;
        }
        return null;
    }

    public void put(String string, String string2, String string3) {
        this.propResources.put(string + CATEGORY_KEY_CONCAT_CHAR + this.convertKey(string2), string3);
    }

    public void put(String string, String string2) {
        this.put(CATEGORY_DEFAULT, this.convertKey(string), string2);
    }

    public String get(String string, String string2) {
        String string3 = this.propResources.getProperty(string + CATEGORY_KEY_CONCAT_CHAR + this.convertKey(string2));
        return this.decodeValue(string3);
    }

    protected String decodeValue(String string) {
        if (this.isNewVersion) {
            return string;
        }
        char c = '\u0100';
        if (string != null) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) > c) {
                    return string;
                }
                ++n2;
            }
            try {
                string = new String(string.getBytes("8859_1"), this.strEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    public String get(String string) {
        return this.get(CATEGORY_DEFAULT, string);
    }

    public void clear() {
        this.propResources.clear();
    }

    protected String convertKey(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '=') {
                stringBuffer.append('_');
                stringBuffer.append('e');
            } else if (c == ':') {
                stringBuffer.append('_');
                stringBuffer.append('c');
            } else if (c == ' ') {
                stringBuffer.append('_');
                stringBuffer.append('s');
            } else if (c == '_') {
                stringBuffer.append('_');
                stringBuffer.append('_');
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected String decodeKey(String string) {
        int n = string.indexOf(95);
        if (n < 0 || n == string.length() - 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(string.substring(0, n));
            char c = string.charAt(n + 1);
            if (c == '_') {
                stringBuffer.append('_');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 's') {
                stringBuffer.append(' ');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 'e') {
                stringBuffer.append('=');
                string = string.substring(n + 2);
                continue;
            }
            if (c == 'c') {
                stringBuffer.append(':');
                string = string.substring(n + 2);
                continue;
            }
            stringBuffer.append(string.charAt(n));
            string = string.substring(n + 1);
        } while ((n = string.indexOf(95)) >= 0);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static NLSResourceBundle getBundle(String string, Locale locale) throws IOException {
        NLSResourceBundle nLSResourceBundle = new NLSResourceBundle();
        nLSResourceBundle.load(string, locale);
        return nLSResourceBundle;
    }

    public static Vector getAvailableLocales(String string) {
        return NLSResourceBundle.getAvailableLocales(new File(string));
    }

    public static Vector getAvailableLocales(File file) {
        Vector<String> vector = new Vector<String>();
        File file2 = new File(file.getParent());
        String string = NLSResourceBundle.getReportNameFromFileName(file.getName());
        String string2 = string + FILENAME_CONCAT_CHAR + LocaleUtil.LOCALE_ID_WILDCARD + PROPS_FILE_EXTENSION;
        WildcardMatcher wildcardMatcher = new WildcardMatcher(string2, false, 2);
        String[] stringArray = file2.list(wildcardMatcher);
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(NLSResourceBundle.getLocaleFromFileName(stringArray[n]));
            ++n;
        }
        LocaleUtil.LOCALE_ID_WILDCARD = "?????";
        string2 = string + FILENAME_CONCAT_CHAR + LocaleUtil.LOCALE_ID_WILDCARD + PROPS_FILE_EXTENSION;
        wildcardMatcher = new WildcardMatcher(string2, false, 2);
        stringArray = file2.list(wildcardMatcher);
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.addElement(NLSResourceBundle.getLocaleFromFileName(stringArray[n2]));
            ++n2;
        }
        LocaleUtil.LOCALE_ID_WILDCARD = "??";
        return vector;
    }

    public String getEncoding() {
        return this.strEncoding;
    }

    protected static String getReportNameFromFileName(String string) {
        if (string.endsWith(CLS_FILE_EXTENSION)) {
            return string.substring(0, string.length() - CLS_FILE_EXTENSION.length());
        }
        if (string.endsWith(RPT_FILE_EXTENSION)) {
            return string.substring(0, string.length() - RPT_FILE_EXTENSION.length());
        }
        return string;
    }

    protected static String getLocaleFromFileName(String string) {
        if (string.endsWith(PROPS_FILE_EXTENSION)) {
            string = string.substring(0, string.length() - PROPS_FILE_EXTENSION.length());
        }
        if (string.length() > 3) {
            return string.substring(string.length() - LocaleUtil.LOCALE_ID_WILDCARD.length(), string.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFieldNLS(String string, Locale locale) throws IOException {
        File file = new File(string + FILENAME_CONCAT_CHAR + locale + PROPS_FILE_EXTENSION);
        if (!file.exists() && !(file = new File(string + FILENAME_CONCAT_CHAR + locale.getLanguage() + PROPS_FILE_EXTENSION)).exists()) {
            file = new File(string + PROPS_FILE_EXTENSION);
        }
        if (file != null && file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.load(fileInputStream);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            {
            }
        }
    }

    public void putFontText(String string, String string2, String string3) {
        String string4 = string2.concat(VALUES_CONCAT_CHAR).concat(string3);
        String string5 = string2.concat(VALUES_CONCAT_CHAR).concat(string3);
        this.put(string, string4, string5);
    }

    public String getFontText(String string, String string2, String string3) {
        String string4 = string2.concat(VALUES_CONCAT_CHAR).concat(string3);
        return this.get(string, string4);
    }

    public static String[] parseFontContext(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, VALUES_CONCAT_CHAR);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    public static String mergeFontContext(String string, String string2) {
        return string.concat(VALUES_CONCAT_CHAR).concat(string2);
    }
}

