/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.join.data;

import com.jinfonet.dataservice.relational.localrelation.join.data.BigDecimalTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.DateTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.DoubleTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.FloatTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.IntTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.LongTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.StringTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.TimeTyper;
import com.jinfonet.dataservice.relational.localrelation.join.data.TimestampTyper;
import com.jinfonet.dataservice.relational.localrelation.util.cont.IndexLocalRelation;
import jet.dataengine.api.DSException;

public abstract class DataTyper {
    protected final int dataType;

    protected DataTyper(int n) {
        this.dataType = n;
    }

    public static DataTyper getInstance(int n) {
        switch (n) {
            case -6: 
            case 4: 
            case 5: {
                return new IntTyper(n);
            }
            case -5: {
                return new LongTyper(n);
            }
            case 6: {
                return new FloatTyper(n);
            }
            case 8: {
                return new DoubleTyper(n);
            }
            case 91: {
                return new DateTyper(n);
            }
            case 92: {
                return new TimeTyper(n);
            }
            case 93: {
                return new TimestampTyper(n);
            }
            case 12: {
                return new StringTyper(n);
            }
            case 3: {
                return new BigDecimalTyper(n);
            }
        }
        throw new IllegalArgumentException("join column data type not supported");
    }

    public int getDataType() {
        return this.dataType;
    }

    public Object getTargetObject(IndexLocalRelation indexLocalRelation) throws DSException {
        return indexLocalRelation.getTargetObject();
    }
}

