/*
 * Decompiled with CFR 0.152.
 */
package jet.acl;

import java.security.acl.NotOwnerException;
import java.util.Vector;
import jet.JResource;
import jet.acl.ACLException;
import jet.acl.JCLSPolicyCalculator;
import jet.acl.JetAcl;
import jet.acl.JetCLSPolicy;
import jet.acl.JetPolicy;
import jet.acl.JetUser;
import jet.acl.SecurityContextAdapter;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAclImpl;
import jet.cs.jacl.JPermissionImpl;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicy;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;
import jet.server.api.SecurityContext;
import jet.universe.JetUAcl;
import jet.universe.JetUDatabase;
import jet.universe.exception.SecurityEntryException;

public class PermissionManager {
    private JPolicy QOIV = null;
    private JPolicy createAclImpl = null;
    private boolean getAcl = false;
    private boolean getAclByResourceName = false;

    public PermissionManager() {
    }

    public PermissionManager(JetAcl jetAcl, String string) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        this.QOIV(jetAcl, string);
    }

    public PermissionManager(JetUDatabase jetUDatabase, String string, String string2) throws SecurityEntryException, NotOwnerException, JPermissionLinkException, JPolicyLinkException {
        JetUAcl jetUAcl = jetUDatabase.getAclByResourceName(string2);
        if (jetUAcl == null) {
            throw new SecurityEntryException(JResource.getMessage("CAT_SECURITY_NOT_FOUND", (Object)string2));
        }
        JetAcl jetAcl = jetUAcl.getAcl();
        this.QOIV(jetAcl, string);
    }

    public PermissionManager(JetAcl jetAcl, String string, SecurityData securityData) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        this.createAclImpl(jetAcl, string, securityData);
    }

    public PermissionManager(JetUDatabase jetUDatabase, String string, String string2, SecurityData securityData) throws SecurityEntryException, NotOwnerException, JPermissionLinkException, JPolicyLinkException {
        JetUAcl jetUAcl = jetUDatabase.getAclByResourceName(string2);
        if (jetUAcl == null) {
            throw new SecurityEntryException(JResource.getMessage("CAT_SECURITY_NOT_FOUND", (Object)string2));
        }
        JetAcl jetAcl = jetUAcl.getAcl();
        this.createAclImpl(jetAcl, string, securityData);
    }

    public PermissionManager(JetAcl jetAcl, SecurityContext securityContext) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        this.getAcl(jetAcl, securityContext);
    }

    public PermissionManager(JetUDatabase jetUDatabase, String string, SecurityContext securityContext) throws SecurityEntryException, NotOwnerException, JPermissionLinkException, JPolicyLinkException {
        JetUAcl jetUAcl = jetUDatabase.getAclByResourceName(string);
        if (jetUAcl == null) {
            throw new SecurityEntryException(JResource.getMessage("CAT_SECURITY_NOT_FOUND", (Object)string));
        }
        JetAcl jetAcl = jetUAcl.getAcl();
        this.getAcl(jetAcl, securityContext);
    }

    public static boolean isAdmin(JetAcl jetAcl, String string) {
        return jetAcl.isAdminUser(string);
    }

    public static boolean isAdmin(JetAcl jetAcl, String string, SecurityData securityData) {
        return jetAcl.isAdminUser(string, securityData);
    }

    public static boolean isAdmin(JetAcl jetAcl, SecurityContext securityContext) {
        return jetAcl.isAdmin(securityContext);
    }

    public boolean isValidRLS() {
        return this.getAcl;
    }

    public boolean isValidCLS() {
        return this.getAclByResourceName;
    }

    private void QOIV(JetAcl jetAcl, String string) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        if (jetAcl == null) {
            return;
        }
        this.getAcl = jetAcl.isValidRLS();
        this.getAclByResourceName = jetAcl.isValidCLS();
        if (!this.getAcl && !this.getAclByResourceName) {
            return;
        }
        BaseUser baseUser = jetAcl.getUser(string);
        if (baseUser != null) {
            JPermissionImpl jPermissionImpl;
            JAclImpl jAclImpl = jetAcl.createAclImpl(baseUser, jetAcl, 0);
            if (this.getAcl && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 1)) != null) {
                this.QOIV = jPermissionImpl.getPolicy();
            }
            if (this.getAclByResourceName && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 2)) != null) {
                this.createAclImpl = jPermissionImpl.getPolicy();
            }
        }
    }

    private void createAclImpl(JetAcl jetAcl, String string, SecurityData securityData) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        if (jetAcl == null) {
            return;
        }
        this.getAcl = jetAcl.isValidRLS();
        this.getAclByResourceName = jetAcl.isValidCLS();
        if (!this.getAcl && !this.getAclByResourceName) {
            return;
        }
        JPolicy jPolicy = null;
        JPolicy jPolicy2 = null;
        JPolicy jPolicy3 = null;
        JPolicy jPolicy4 = null;
        JAclImpl jAclImpl = null;
        JPermissionImpl jPermissionImpl = null;
        JPermissionImpl jPermissionImpl2 = null;
        BaseUser baseUser = securityData.getUser(string);
        if (baseUser != null) {
            jAclImpl = jetAcl.createAclImpl(baseUser, securityData, 1);
            if (this.getAcl && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 1)) != null) {
                jPolicy = jPermissionImpl.getPolicy();
            }
            if (this.getAclByResourceName && (jPermissionImpl2 = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 2)) != null) {
                jPolicy3 = jPermissionImpl2.getPolicy();
            }
        }
        Object var12_12 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        JetUser jetUser = (JetUser)jetAcl.getUser(string);
        if (jetUser != null && jetUser.getSourceType() == 1) {
            jAclImpl = jetAcl.createAclImpl(jetUser, jetAcl, 2);
            if (this.getAcl && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(jetUser, "visible", 1)) != null) {
                jPolicy2 = jPermissionImpl.getPolicy();
            }
            if (this.getAclByResourceName && (jPermissionImpl2 = (JPermissionImpl)jAclImpl.getPolicyPermission(jetUser, "visible", 2)) != null) {
                jPolicy4 = jPermissionImpl2.getPolicy();
            }
        }
        if (this.getAcl) {
            this.QOIV = jPolicy != null ? jPolicy.union(jPolicy2) : jPolicy2;
        }
        if (this.getAclByResourceName) {
            this.createAclImpl = jPolicy3 != null ? jPolicy3.union(jPolicy4) : jPolicy4;
        }
    }

    private void getAcl(JetAcl jetAcl, SecurityContext securityContext) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        JPermissionImpl jPermissionImpl;
        if (jetAcl == null) {
            return;
        }
        this.getAcl = jetAcl.isValidRLS();
        this.getAclByResourceName = jetAcl.isValidCLS();
        if (!this.getAcl && !this.getAclByResourceName) {
            return;
        }
        SecurityContextAdapter securityContextAdapter = new SecurityContextAdapter(securityContext);
        BaseUser baseUser = securityContextAdapter.getUser(securityContext.getUserName());
        JAclImpl jAclImpl = jetAcl.createAclImpl(baseUser, securityContextAdapter, 0);
        if (this.getAcl && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 1)) != null) {
            this.QOIV = jPermissionImpl.getPolicy();
        }
        if (this.getAclByResourceName && (jPermissionImpl = (JPermissionImpl)jAclImpl.getPolicyPermission(baseUser, "visible", 2)) != null) {
            this.createAclImpl = jPermissionImpl.getPolicy();
        }
    }

    public JetPolicy getRLSPolicy() {
        return (JetPolicy)this.QOIV;
    }

    public JPolicy getCLSPolicy() {
        return this.createAclImpl;
    }

    public boolean isAllowAllColumns() throws ACLException {
        if (!this.getAclByResourceName) {
            throw new ACLException("The permission is not valid.");
        }
        if (this.createAclImpl == null) {
            return false;
        }
        if (this.createAclImpl instanceof JetCLSPolicy) {
            return ((JetCLSPolicy)this.createAclImpl).isAllowAll();
        }
        if (this.createAclImpl instanceof JCLSPolicyCalculator) {
            return ((JCLSPolicyCalculator)this.createAclImpl).isAllowAll();
        }
        return false;
    }

    public boolean isDenyAllColumns() throws ACLException {
        if (!this.getAclByResourceName) {
            throw new ACLException("The permission is not valid.");
        }
        if (this.createAclImpl == null) {
            return true;
        }
        if (this.createAclImpl instanceof JetCLSPolicy) {
            return ((JetCLSPolicy)this.createAclImpl).isDenyAll();
        }
        if (this.createAclImpl instanceof JCLSPolicyCalculator) {
            return ((JCLSPolicyCalculator)this.createAclImpl).isDenyAll();
        }
        return true;
    }

    public Vector getDeniedColumns(Vector vector) throws ACLException {
        if (!this.getAclByResourceName) {
            throw new ACLException("The permission is not valid.");
        }
        if (this.createAclImpl == null) {
            return vector;
        }
        Vector vector2 = new Vector();
        if (this.createAclImpl instanceof JetCLSPolicy) {
            if (((JetCLSPolicy)this.createAclImpl).isDenied()) {
                return vector;
            }
            if (((JetCLSPolicy)this.createAclImpl).isAllowAll()) {
                return vector2;
            }
            return JCLSPolicyCalculator.subtractColumns(vector, JCLSPolicyCalculator.toUpperCase(((JetCLSPolicy)this.createAclImpl).getColumns()));
        }
        if (this.createAclImpl instanceof JCLSPolicyCalculator) {
            JetCLSPolicy jetCLSPolicy = ((JCLSPolicyCalculator)this.createAclImpl).getAllowedPolicy();
            JetCLSPolicy jetCLSPolicy2 = ((JCLSPolicyCalculator)this.createAclImpl).getDeniedPolicy();
            if (jetCLSPolicy == null) {
                return vector;
            }
            if (jetCLSPolicy.isAllowAll()) {
                if (jetCLSPolicy2 == null) {
                    return vector2;
                }
                if (jetCLSPolicy2.isDenyAll()) {
                    return vector;
                }
                return JCLSPolicyCalculator.intersectColumns(vector, JCLSPolicyCalculator.toUpperCase(jetCLSPolicy2.getColumns()));
            }
            if (jetCLSPolicy2 == null) {
                return JCLSPolicyCalculator.subtractColumns(vector, JCLSPolicyCalculator.toUpperCase(jetCLSPolicy.getColumns()));
            }
            if (jetCLSPolicy2.isDenyAll()) {
                return vector;
            }
            return JCLSPolicyCalculator.subtractColumns(vector, JCLSPolicyCalculator.subtractColumns(JCLSPolicyCalculator.intersectColumns(vector, JCLSPolicyCalculator.toUpperCase(jetCLSPolicy.getColumns())), JCLSPolicyCalculator.toUpperCase(jetCLSPolicy2.getColumns())));
        }
        return vector;
    }
}

