/*
 * Decompiled with CFR 0.152.
 */
package jet.report.fax;

import java.io.IOException;
import jet.bean.JRCoverInfo;
import jet.bean.JRFaxServer;
import jet.bean.JRFaxServerException;
import jet.bean.JRFaxServerInfo;
import jet.datastream.Communicator;
import jet.report.fax.ExportReportToStream;

public class JRExportToFax {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportToFaxServer(Communicator communicator, String string, JRFaxServerInfo jRFaxServerInfo, JRCoverInfo jRCoverInfo) throws JRFaxServerException {
        Object object;
        if (!JRExportToFax.I() && string.equalsIgnoreCase("jet.report.fax.HylaFax.JRHylaFaxServer")) {
            throw new JRFaxServerException("JDK version less than 1.5.0");
        }
        Object var4_4 = null;
        try {
            try {
                object = Class.forName("gnu.hylafax.ClientProtocol");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRFaxServerException("can't find class gnu.hylafax.ClientProtocol");
            }
            object = Class.forName(string);
            var4_4 = ((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRFaxServerException("can't find class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRFaxServerException("Illegal access");
        }
        catch (InstantiationException instantiationException) {
            throw new JRFaxServerException("can't instance class " + string);
        }
        catch (Exception exception) {
            throw new JRFaxServerException(exception.getMessage());
        }
        if (!(var4_4 instanceof JRFaxServer)) throw new JRFaxServerException("Class is not a JRFaxServer");
        object = var4_4;
        object.setBasicParameters(jRFaxServerInfo);
        object.setSpecParameters(jRFaxServerInfo.specPars);
        try {
            if (!object.connect(jRFaxServerInfo.host, jRFaxServerInfo.port, jRFaxServerInfo.userid, jRFaxServerInfo.password)) return;
            ExportReportToStream exportReportToStream = new ExportReportToStream(communicator, jRFaxServerInfo.faxnumber, jRCoverInfo);
            int n = 0;
            if (jRFaxServerInfo.retry < 0) {
                jRFaxServerInfo.retry = 0;
            }
            while (n <= jRFaxServerInfo.retry) {
                try {
                    object.send(jRFaxServerInfo.faxnumber, exportReportToStream.create());
                    n = jRFaxServerInfo.retry + 1;
                }
                catch (Exception exception) {
                    if (n == jRFaxServerInfo.retry) {
                        object.disconnect();
                        throw new JRFaxServerException(exception.getMessage());
                    }
                    ++n;
                }
            }
            object.disconnect();
            exportReportToStream.deleteTempfile();
            return;
        }
        catch (IOException iOException) {
            throw new JRFaxServerException("io exception");
        }
    }

    private static boolean I() {
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        return string.compareTo("1.5.0") >= 0;
    }
}

