/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import jet.reportLogic.objectLogic.tabularLogic.Columns;
import jet.reportLogic.objectLogic.tabularLogic.GridCell;
import jet.reportLogic.objectLogic.tabularLogic.IdHandler;
import jet.reportLogic.objectLogic.tabularLogic.Rows;
import jet.reportLogic.objectLogic.tabularLogic.TabularCell;
import jet.reportLogic.objectLogic.tabularLogic.TabularTree;
import jet.util.IntKeyHashtable;
import jet.util.IntSet;
import jet.util.IntVector;

public class Tabular {
    private int QOIV;
    private IntKeyHashtable abs = new IntKeyHashtable();
    private IdHandler add = new IdHandler(0);
    private Rows addAll = null;
    private Columns addElement = null;
    private int addElements = 0;
    private int addGridCell = 0;
    private int addKeepTotalHeight = 0;
    private int addKeepTotalWidth = 0;
    public static int SCALE = 1;
    public static int SHRINK_DEGREE = 1;
    public static int DefaultGridCellHeigth = 150 * SCALE * 60;
    public static int DefaultGridCellWidth = 150 * SCALE * 60;
    public static int DefaultMinGridCellLength = 10 * SCALE * 60;
    int addTabularCell = -1;

    public Tabular() {
        this.addAll = new Rows();
        this.addElement = new Columns();
    }

    public int getBaseMergeCellId() {
        return this.QOIV;
    }

    public Tabular(int n, int n2) {
        this.addAll = new Rows(n);
        this.addElement = new Columns(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                n3 = this.add.generateAddress();
                this.abs.put(n3, new TabularCell(n3, new GridCell(n5, n4)));
                ++n5;
            }
            ++n4;
        }
    }

    public void markAddress(int n) {
        this.add.markMaxAddress(n);
    }

    protected void setAddress(int n) {
        this.addTabularCell = n;
    }

    protected int getAddress() {
        return this.addTabularCell;
    }

    public boolean addTabularCell(TabularCell tabularCell) {
        int n = tabularCell.getAddress();
        if (this.abs.containsKey(n)) {
            return false;
        }
        this.abs.put(n, tabularCell);
        return true;
    }

    public TabularCell getTabularCell(int n) {
        return (TabularCell)this.abs.get(n);
    }

    public IntVector getTabularCells() {
        return this.abs.keys();
    }

    public int getTabularCellAmount() {
        return this.getTabularCells().size();
    }

    public int getColumnNum() {
        return this.addElement.size();
    }

    public int getRowNum() {
        return this.addAll.size();
    }

    protected int getMaxX() {
        return this.getColumnNum() - 1;
    }

    protected int getMaxY() {
        return this.getRowNum() - 1;
    }

    public int getGridWidth(int n) {
        return this.getMaxX(n) - this.getMinX(n) + 1;
    }

    public int getGridHeight(int n) {
        return this.getMaxY(n) - this.getMinY(n) + 1;
    }

    public int getTabularCellWidth(int n) {
        int n2 = this.getMinX(n);
        int n3 = this.getMaxX(n);
        return this.addElement.getGridColumnWidthBetween(n2, n3);
    }

    public int getTabualrCellHorizontalDistance(int n) {
        int n2 = this.getMinX(n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.addElement.getGridColumnWidthAt(n4);
            ++n4;
        }
        return n3 += this.addElement.hCellSpacing * (n2 + 1);
    }

    public int getTabularCellVerticalDistance(int n) {
        int n2 = this.getMinY(n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.addAll.getGridRowHeightAt(n4);
            ++n4;
        }
        return n3 += this.addAll.vCellSpacing * (n2 + 1);
    }

    public int getTabulaHeight() {
        return this.addAll.getTotalHeight() + this.addElements + this.addGridCell;
    }

    public int getTabularWidth() {
        return this.addElement.getTotalWidth() + this.addKeepTotalHeight + this.addKeepTotalWidth;
    }

    public int getTabularCellHeight(int n) {
        int n2 = this.getMinY(n);
        int n3 = this.getMaxY(n);
        return this.addAll.getGridRowHeightBetween(n2, n3);
    }

    protected int getMaxX(IntVector intVector) {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < intVector.size()) {
            n2 = this.getTabularCell(intVector.elementAt(n3)).getMaxX();
            if (n2 > n) {
                n = n2;
            }
            ++n3;
        }
        return n;
    }

    protected int getMaxY(IntVector intVector) {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < intVector.size()) {
            n2 = this.getTabularCell(intVector.elementAt(n3)).getMaxY();
            if (n2 > n) {
                n = n2;
            }
            ++n3;
        }
        return n;
    }

    protected int getMinX(IntVector intVector) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < intVector.size()) {
            n2 = this.getTabularCell(intVector.elementAt(n3)).getMinX();
            if (n2 < n) {
                n = n2;
            }
            ++n3;
        }
        return n;
    }

    protected int getMinY(IntVector intVector) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < intVector.size()) {
            n2 = this.getTabularCell(intVector.elementAt(n3)).getMinY();
            if (n2 < n) {
                n = n2;
            }
            ++n3;
        }
        return n;
    }

    public int getMaxX(int n) {
        return this.getTabularCell(n).getMaxX();
    }

    public int getMaxY(int n) {
        return this.getTabularCell(n).getMaxY();
    }

    public int getMinX(int n) {
        return this.getTabularCell(n).getMinX();
    }

    public int getMinY(int n) {
        return this.getTabularCell(n).getMinY();
    }

    protected TabularCell remove(int n) {
        return (TabularCell)this.abs.remove(n);
    }

    public int findTabularCellByCell(int n, int n2, IntVector intVector) {
        TabularCell tabularCell = null;
        int n3 = 0;
        while (n3 < intVector.size()) {
            tabularCell = this.getTabularCell(intVector.elementAt(n3));
            if (tabularCell.containGridCell(n, n2)) {
                return tabularCell.getAddress();
            }
            ++n3;
        }
        return -1;
    }

    public TabularTree generateTtree() {
        TabularTree tabularTree = new TabularTree();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = null;
        boolean bl = false;
        int n = this.getMaxX(intVector);
        int n2 = this.getMaxY(intVector);
        int n3 = 0;
        while (n3 <= n2) {
            bl = true;
            int n4 = 0;
            while (n4 <= n) {
                int n5 = this.findTabularCellByCell(n4, n3, intVector);
                if (bl && !tabularTree.contain(n5)) {
                    bl = false;
                    intVector2 = new IntVector();
                    tabularTree.addTabularCells(intVector2);
                    intVector2.addElement(n5);
                } else if (!tabularTree.contain(n5)) {
                    intVector2.addElement(n5);
                }
                ++n4;
            }
            ++n3;
        }
        return tabularTree;
    }

    public void changeTotalWidth(int n) {
        this.addElement.resizeTotalWidth(n);
    }

    public void changeTotalHeight(int n) {
        this.addAll.resizeTotalHeight(n);
    }

    public void changeTabularCellWidth(int n, int n2) {
        int n3 = this.getMaxX();
        int n4 = this.getMaxX(n);
        int n5 = this.getMinX(n);
        int n6 = this.getMinY(n);
        if (n2 > 0) {
            if (n3 != n4 && n2 > this.addElement.getGridColumnWidthAt(n4 + 1) - DefaultMinGridCellLength) {
                n2 = this.addElement.getGridColumnWidthAt(n4 + 1) - DefaultMinGridCellLength;
            }
        } else if (n2 < 0 && Math.abs(n2) > this.addElement.getGridColumnWidthAt(n4) - DefaultMinGridCellLength) {
            n2 = -(this.addElement.getGridColumnWidthAt(n4) - DefaultMinGridCellLength);
        }
        this.addElement.resizeWidthBetween(n4, n4, n2);
        if (n3 != n4) {
            int n7 = n4 + 1;
            int n8 = this.findTabularCellByCell(n7, n6, this.getTabularCells());
            int n9 = this.getMaxX(n8);
            this.addElement.resizeWidthBetween(n7, n7, -n2);
        }
    }

    public void changeTabularCellHeight(int n, int n2) {
        int n3 = this.getMinY(n);
        int n4 = this.getMaxY(n);
        if (n2 < 0 && Math.abs(n2) > this.addAll.getGridRowHeightAt(n4) - DefaultMinGridCellLength) {
            n2 = -(this.addAll.getGridRowHeightAt(n4) - DefaultMinGridCellLength);
        }
        this.addAll.resizeHeightBetween(n4, n4, n2);
    }

    public boolean isMergable(IntVector intVector) {
        int n = 0;
        int n2 = 0;
        while (n2 < intVector.size()) {
            n += this.getTabularCell(intVector.elementAt(n2)).getGridCellAmount();
            ++n2;
        }
        int n3 = (this.getMaxX(intVector) - this.getMinX(intVector) + 1) * (this.getMaxY(intVector) - this.getMinY(intVector) + 1);
        return n == n3;
    }

    public int merge(IntVector intVector) {
        if (this.isMergable(intVector)) {
            int n;
            int n2 = this.getMinX(intVector);
            TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(n2, n = this.getMinY(intVector), intVector));
            if (tabularCell != null) {
                int n3 = 0;
                while (n3 < intVector.size()) {
                    if (intVector.elementAt(n3) != tabularCell.getAddress()) {
                        this.addGridCell(tabularCell, this.getTabularCell(intVector.elementAt(n3)));
                        GridCell[] gridCellArray = this.remove(intVector.elementAt(n3)).getGridCellArray();
                        int n4 = 0;
                        while (n4 < gridCellArray.length) {
                            tabularCell.addGridCell(gridCellArray[n4]);
                            ++n4;
                        }
                    }
                    ++n3;
                }
                this.DefaultMinGridCellLength();
                this.QOIV = tabularCell.getAddress();
                return tabularCell.getAddress();
            }
            return -1;
        }
        return -1;
    }

    public ArrayList getRowGroup() {
        ArrayList<IntVector> arrayList = new ArrayList<IntVector>();
        int n = this.getMaxX();
        int n2 = this.getMaxY();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = new IntVector();
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = 0;
            while (n4 <= n) {
                int n5 = this.findTabularCellByCell(n4, n3, intVector);
                if (intVector2.indexOf(n5) == -1) {
                    intVector2.addElement(n5);
                }
                ++n4;
            }
            if (this.isMergable(intVector2)) {
                arrayList.add(intVector2);
                intVector2 = new IntVector();
            }
            ++n3;
        }
        return arrayList;
    }

    public ArrayList getColumnGroup() {
        ArrayList<IntVector> arrayList = new ArrayList<IntVector>();
        int n = this.getMaxX();
        int n2 = this.getMaxY();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = new IntVector();
        int n3 = 0;
        while (n3 <= n) {
            int n4 = 0;
            while (n4 <= n2) {
                int n5 = this.findTabularCellByCell(n3, n4, intVector);
                if (intVector2.indexOf(n5) == -1) {
                    intVector2.addElement(n5);
                }
                ++n4;
            }
            if (this.isMergable(intVector2)) {
                arrayList.add(intVector2);
                intVector2 = new IntVector();
            }
            ++n3;
        }
        return arrayList;
    }

    public void moveColumnGroup(IntVector intVector, IntVector intVector2) {
        int n = this.getMinX(intVector);
        int n2 = this.getMaxX(intVector);
        int n3 = this.getMinX(intVector2);
        int n4 = this.getMaxX(intVector2);
        int n5 = this.getMaxY();
        IntVector intVector3 = new IntVector();
        if (n > n3) {
            int n6;
            int n7;
            intVector3.addElements(intVector2, false);
            int n8 = 0;
            while (n8 <= n5) {
                n7 = n4 + 1;
                while (n7 < n) {
                    n6 = this.findTabularCellByCell(n7, n8, this.getTabularCells());
                    if (intVector3.indexOf(n6) == -1) {
                        intVector3.addElement(n6);
                    }
                    ++n7;
                }
                ++n8;
            }
            n7 = n - n3;
            n6 = 0;
            while (n6 < intVector.size()) {
                this.getTabularCell(intVector.elementAt(n6)).decreaseAllGridOnX(n7);
                ++n6;
            }
            n7 = n2 - n + 1;
            int n9 = 0;
            while (n9 < intVector3.size()) {
                this.getTabularCell(intVector3.elementAt(n9)).increaseAllGridOnX(n7);
                ++n9;
            }
        } else {
            int n10;
            int n11;
            intVector3.addElements(intVector2, false);
            int n12 = 0;
            while (n12 <= n5) {
                n11 = n2 + 1;
                while (n11 < n3) {
                    n10 = this.findTabularCellByCell(n11, n12, this.getTabularCells());
                    if (intVector3.indexOf(n10) == -1) {
                        intVector3.addElement(n10);
                    }
                    ++n11;
                }
                ++n12;
            }
            n11 = n4 - n2;
            n10 = 0;
            while (n10 < intVector.size()) {
                this.getTabularCell(intVector.elementAt(n10)).increaseAllGridOnX(n11);
                ++n10;
            }
            n11 = n2 - n + 1;
            int n13 = 0;
            while (n13 < intVector3.size()) {
                this.getTabularCell(intVector3.elementAt(n13)).decreaseAllGridOnX(n11);
                ++n13;
            }
        }
    }

    public void moveRowGroup(IntVector intVector, IntVector intVector2) {
        int n = this.getMinY(intVector);
        int n2 = this.getMaxY(intVector);
        int n3 = this.getMinY(intVector2);
        int n4 = this.getMaxY(intVector2);
        int n5 = this.getMaxX();
        IntVector intVector3 = new IntVector();
        if (n > n3) {
            int n6;
            int n7;
            intVector3.addElements(intVector2, false);
            int n8 = 0;
            while (n8 <= n5) {
                n7 = n4 + 1;
                while (n7 < n) {
                    n6 = this.findTabularCellByCell(n8, n7, this.getTabularCells());
                    if (intVector3.indexOf(n6) == -1) {
                        intVector3.addElement(n6);
                    }
                    ++n7;
                }
                ++n8;
            }
            n7 = n - n3;
            n6 = 0;
            while (n6 < intVector.size()) {
                this.getTabularCell(intVector.elementAt(n6)).decreaseAllGridOnY(n7);
                ++n6;
            }
            n7 = n2 - n + 1;
            int n9 = 0;
            while (n9 < intVector3.size()) {
                this.getTabularCell(intVector3.elementAt(n9)).increaseAllGridOnY(n7);
                ++n9;
            }
        } else {
            int n10;
            int n11;
            int n12 = 0;
            while (n12 <= n5) {
                n11 = n2 + 1;
                while (n11 < n3) {
                    n10 = this.findTabularCellByCell(n12, n11, this.getTabularCells());
                    if (intVector3.indexOf(n10) == -1) {
                        intVector3.addElement(n10);
                    }
                    ++n11;
                }
                ++n12;
            }
            n11 = n3 - n2 - 1;
            n10 = 0;
            while (n10 < intVector.size()) {
                this.getTabularCell(intVector.elementAt(n10)).increaseAllGridOnY(n11);
                ++n10;
            }
            n11 = n2 - n + 1;
            int n13 = 0;
            while (n13 < intVector3.size()) {
                this.getTabularCell(intVector3.elementAt(n13)).decreaseAllGridOnY(n11);
                ++n13;
            }
        }
    }

    public int[] split(int n, int n2, int n3) {
        IntSet intSet = new IntSet();
        int[] nArray = this.DefaultGridCellHeigth(n, n2).toArray();
        int n4 = 0;
        while (n4 < nArray.length) {
            intSet.addAll(this.DefaultGridCellWidth(nArray[n4], n3).toArray());
            ++n4;
        }
        intSet.remove(n);
        return intSet.toArray();
    }

    private IntSet DefaultGridCellHeigth(int n, int n2) {
        IntSet intSet = new IntSet();
        intSet.add(n);
        TabularCell tabularCell = this.getTabularCell(n);
        while (n2 > 1) {
            int n3;
            int n4 = this.getMaxY(n);
            int n5 = this.getMinY(n);
            TabularCell tabularCell2 = new TabularCell(this.add.generateAddress());
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            if (n4 - n5 != 0) {
                n3 = 0;
                while (n3 < gridCellArray.length) {
                    if (gridCellArray[n3].y == n4) {
                        tabularCell.removeGridCell(gridCellArray[n3]);
                        tabularCell2.addGridCell(gridCellArray[n3]);
                    }
                    ++n3;
                }
            } else {
                this.addAll.addKeepTotalHeight(n4 + 1, this.getTabulaHeight() / this.addAll.size() + 1);
                this.addElements(false, n4 + 1, 1);
                n3 = 0;
                while (n3 <= this.getMaxX()) {
                    int n6 = this.findTabularCellByCell(n3, n4, this.getTabularCells());
                    if (n6 != n) {
                        this.getTabularCell(n6).addGridCell(new GridCell(n3, n4 + 1));
                    } else {
                        tabularCell2.addGridCell(new GridCell(n3, n4 + 1));
                    }
                    ++n3;
                }
            }
            this.addTabularCell(tabularCell2);
            intSet.add(tabularCell2.getAddress());
            --n2;
        }
        return intSet;
    }

    private IntSet DefaultGridCellWidth(int n, int n2) {
        IntSet intSet = new IntSet();
        intSet.add(n);
        TabularCell tabularCell = this.getTabularCell(n);
        while (n2 > 1) {
            int n3;
            int n4 = this.getMaxX(n);
            int n5 = this.getMinX(n);
            TabularCell tabularCell2 = new TabularCell(this.add.generateAddress());
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            if (n4 - n5 != 0) {
                n3 = 0;
                while (n3 < gridCellArray.length) {
                    if (gridCellArray[n3].x == n4) {
                        tabularCell.removeGridCell(gridCellArray[n3]);
                        tabularCell2.addGridCell(gridCellArray[n3]);
                    }
                    ++n3;
                }
            } else {
                this.addElement.addKeepTotalWidth(n4 + 1, this.getTabularWidth() / this.addElement.size() + 1);
                this.addElements(true, n4 + 1, 1);
                n3 = 0;
                while (n3 <= this.getMaxY()) {
                    int n6 = this.findTabularCellByCell(n4, n3, this.getTabularCells());
                    if (n6 != n) {
                        this.getTabularCell(n6).addGridCell(new GridCell(n4 + 1, n3));
                    } else {
                        tabularCell2.addGridCell(new GridCell(n4 + 1, n3));
                    }
                    ++n3;
                }
            }
            this.addTabularCell(tabularCell2);
            intSet.add(tabularCell2.getAddress());
            --n2;
        }
        return intSet;
    }

    private void DefaultMinGridCellLength() {
        this.QOIV(true);
        this.QOIV(false);
    }

    private void QOIV(boolean bl) {
        int n = this.SCALE(bl);
        if (n != -1) {
            this.addAll(bl, n);
            this.QOIV(bl);
        }
    }

    private int SCALE(boolean bl) {
        int n = this.getMaxY();
        int n2 = this.getMaxX();
        IntSet intSet = new IntSet();
        if (bl) {
            int n3 = 0;
            while (n3 <= n2) {
                intSet.clear();
                int n4 = 0;
                while (n4 <= n) {
                    TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(n3, n4, this.getTabularCells()));
                    intSet.add(tabularCell.getAddress());
                    ++n4;
                }
                if (this.SHRINK_DEGREE(bl, intSet)) {
                    return n3;
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 <= n) {
                intSet.clear();
                int n6 = 0;
                while (n6 <= n2) {
                    TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(n6, n5, this.getTabularCells()));
                    intSet.add(tabularCell.getAddress());
                    ++n6;
                }
                if (this.SHRINK_DEGREE(bl, intSet)) {
                    return n5;
                }
                ++n5;
            }
        }
        return -1;
    }

    private boolean SHRINK_DEGREE(boolean bl, IntSet intSet) {
        int[] nArray = intSet.toArray();
        int n = 0;
        while (n < nArray.length) {
            if (bl ? this.getMaxX(nArray[n]) - this.getMinX(nArray[n]) == 0 : this.getMaxY(nArray[n]) - this.getMinY(nArray[n]) == 0) {
                return false;
            }
            ++n;
        }
        int n2 = this.abs(intSet, bl);
        return n2 > SHRINK_DEGREE;
    }

    private int abs(IntSet intSet, boolean bl) {
        int[] nArray = intSet.toArray();
        IntSet intSet2 = null;
        IntSet intSet3 = null;
        if (bl) {
            intSet2 = this.add(this.getMinX(nArray[0]), this.getMaxX(nArray[0]));
            int n = 1;
            while (n < nArray.length) {
                intSet3 = this.add(this.getMinX(nArray[n]), this.getMaxX(nArray[n]));
                intSet2.retainAll(intSet3.toArray());
                ++n;
            }
        } else {
            intSet2 = this.add(this.getMinY(nArray[0]), this.getMaxY(nArray[0]));
            int n = 1;
            while (n < nArray.length) {
                intSet3 = this.add(this.getMinY(nArray[n]), this.getMaxY(nArray[n]));
                intSet2.retainAll(intSet3.toArray());
                ++n;
            }
        }
        return intSet2.size();
    }

    private IntSet add(int n, int n2) {
        IntSet intSet = new IntSet(n2 - n + 1);
        int n3 = n;
        while (n3 <= n2) {
            intSet.add(n3);
            ++n3;
        }
        return intSet;
    }

    private void addAll(boolean bl, int n) {
        IntVector intVector = this.getTabularCells();
        int n2 = 0;
        while (n2 < intVector.size()) {
            TabularCell tabularCell = this.getTabularCell(intVector.elementAt(n2));
            if (bl) {
                tabularCell.removeGridCellX(n);
            } else {
                tabularCell.removeGridCellY(n);
            }
            ++n2;
        }
        if (bl) {
            this.addElement.deleteKeepTotalWidth(n);
            this.addElement(bl, n + 1, 1);
        } else {
            this.addAll.deleteKeepTotalHeight(n);
            this.addElement(bl, n + 1, 1);
        }
    }

    private void addElement(boolean bl, int n, int n2) {
        IntVector intVector = this.getTabularCells();
        int n3 = 0;
        while (n3 < intVector.size()) {
            TabularCell tabularCell = this.getTabularCell(intVector.elementAt(n3));
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            int n4 = 0;
            while (n4 < gridCellArray.length) {
                if (bl) {
                    if (gridCellArray[n4].x >= n) {
                        gridCellArray[n4].x -= n2;
                    }
                } else if (gridCellArray[n4].y >= n) {
                    gridCellArray[n4].y -= n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void addElements(boolean bl, int n, int n2) {
        IntVector intVector = this.getTabularCells();
        int n3 = 0;
        while (n3 < intVector.size()) {
            TabularCell tabularCell = this.getTabularCell(intVector.elementAt(n3));
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            int n4 = 0;
            while (n4 < gridCellArray.length) {
                if (bl) {
                    if (gridCellArray[n4].x >= n) {
                        gridCellArray[n4].x += n2;
                    }
                } else if (gridCellArray[n4].y >= n) {
                    gridCellArray[n4].y += n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void addGridCell(TabularCell tabularCell, TabularCell tabularCell2) {
        tabularCell.getSons().addAll(tabularCell2.getSons());
        tabularCell2.getSons().removeAllElements();
    }

    public int[] getCrossTabularCells(boolean bl, int n) {
        int n2 = 0;
        IntVector intVector = this.getTabularCells();
        IntSet intSet = new IntSet();
        if (bl) {
            int n3 = 0;
            while (n3 < this.addAll.size()) {
                n2 = this.findTabularCellByCell(n, n3, intVector);
                intSet.add(n2);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.addElement.size()) {
                n2 = this.findTabularCellByCell(n4, n, intVector);
                intSet.add(n2);
                ++n4;
            }
        }
        return intSet.toArray();
    }

    public Rows getRows() {
        return this.addAll;
    }

    public Columns getColumns() {
        return this.addElement;
    }

    public int[] insertColumn(int n, boolean bl) {
        int n2 = this.getMinX(n);
        return this.insertGridColumn(n2, bl);
    }

    public int[] insertGridColumn(int n, boolean bl) {
        IntSet intSet = new IntSet();
        int n2 = n;
        int[] nArray = this.getCrossTabularCells(true, n2);
        this.addElement.addKeepTotalWidth(n2, this.getTabularWidth() / this.addElement.size() + 1);
        if (bl) {
            this.addElements(true, n2, 1);
        } else {
            this.addElements(true, ++n2, 1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 = nArray[n4];
            int n5 = this.getMinY(n3);
            int n6 = this.getMaxY(n3);
            int n7 = this.getMinX(n3);
            int n8 = this.getMaxX(n3);
            if (n7 < n2 && n2 < n8) {
                int n9 = n5;
                while (n9 <= n6) {
                    this.getTabularCell(n3).addGridCell(new GridCell(n2, n9));
                    ++n9;
                }
            } else {
                TabularCell tabularCell = new TabularCell(this.add.generateAddress());
                int n10 = n5;
                while (n10 <= n6) {
                    tabularCell.addGridCell(new GridCell(n2, n10));
                    this.addTabularCell(tabularCell);
                    intSet.add(tabularCell.getAddress());
                    ++n10;
                }
            }
            ++n4;
        }
        return intSet.toArray();
    }

    public int[] insertRow(int n, boolean bl) {
        int n2 = this.getMinY(n);
        return this.insertGridRow(n2, bl);
    }

    public int[] insertGridRow(int n, boolean bl) {
        IntSet intSet = new IntSet();
        int n2 = n;
        int[] nArray = this.getCrossTabularCells(false, n2);
        this.addAll.addKeepTotalHeight(n2, this.getTabulaHeight() / (this.addAll.size() + 1));
        if (bl) {
            this.addElements(false, n2, 1);
        } else {
            this.addElements(false, ++n2, 1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 = nArray[n4];
            int n5 = this.getMinX(n3);
            int n6 = this.getMaxX(n3);
            int n7 = this.getMinY(n3);
            int n8 = this.getMaxY(n3);
            if (n7 < n2 && n2 < n8) {
                int n9 = n5;
                while (n9 <= n6) {
                    this.getTabularCell(n3).addGridCell(new GridCell(n9, n2));
                    ++n9;
                }
            } else {
                TabularCell tabularCell = new TabularCell(this.add.generateAddress());
                int n10 = n5;
                while (n10 <= n6) {
                    tabularCell.addGridCell(new GridCell(n10, n2));
                    this.addTabularCell(tabularCell);
                    intSet.add(tabularCell.getAddress());
                    ++n10;
                }
            }
            ++n4;
        }
        return intSet.toArray();
    }

    public void appandRow() {
        int n = this.getMaxY();
        this.addAll.addKeepTotalHeight(-1, this.getTabulaHeight() / this.addAll.size() + 1);
        ++n;
        int n2 = 0;
        while (n2 <= this.getMaxX()) {
            TabularCell tabularCell = new TabularCell(this.add.generateAddress());
            tabularCell.addGridCell(new GridCell(n2, n));
            this.addTabularCell(tabularCell);
            ++n2;
        }
    }

    public void appandColumn() {
        int n = this.getMaxX();
        this.addElement.addKeepTotalWidth(-1, this.getTabularWidth() / this.addElement.size() + 1);
        ++n;
        int n2 = 0;
        while (n2 <= this.getMaxY()) {
            TabularCell tabularCell = new TabularCell(this.add.generateAddress());
            tabularCell.addGridCell(new GridCell(n, n2));
            this.addTabularCell(tabularCell);
            ++n2;
        }
    }

    public void deleteColumn(int n) {
        int n2 = this.getMinX(n);
        this.deleteGridColumn(n2);
    }

    public void deleteRow(int n) {
        int n2 = this.getMinY(n);
        this.deleteGridRow(n2);
    }

    public void deleteColumnGroup(IntVector intVector) {
        int n;
        int n2 = this.getMinX(intVector);
        int n3 = n = this.getMaxX(intVector);
        while (n3 >= n2) {
            this.deleteGridColumn(n3);
            --n3;
        }
    }

    public void deleteRowGroup(IntVector intVector) {
        int n;
        int n2 = this.getMinY(intVector);
        int n3 = n = this.getMaxY(intVector);
        while (n3 >= n2) {
            this.deleteGridRow(n3);
            --n3;
        }
    }

    public void deleteGridRow(int n) {
        if (this.getRowNum() == 1) {
            return;
        }
        int n2 = n;
        this.addAll.deleteKeepTotalHeight(n2);
        int[] nArray = this.getCrossTabularCells(false, n2);
        int n3 = 0;
        while (n3 < nArray.length) {
            TabularCell tabularCell = this.getTabularCell(nArray[n3]);
            tabularCell.removeGridCellY(n2);
            if (tabularCell.getGridCellAmount() == 0) {
                this.remove(nArray[n3]);
            }
            ++n3;
        }
        this.addElement(false, n2, 1);
    }

    public void deleteGridColumn(int n) {
        if (this.getColumnNum() == 1) {
            return;
        }
        int n2 = n;
        this.addElement.deleteKeepTotalWidth(n2);
        int[] nArray = this.getCrossTabularCells(true, n2);
        int n3 = 0;
        while (n3 < nArray.length) {
            TabularCell tabularCell = this.getTabularCell(nArray[n3]);
            tabularCell.removeGridCellX(n2);
            if (tabularCell.getGridCellAmount() == 0) {
                this.remove(nArray[n3]);
            }
            ++n3;
        }
        this.addElement(true, n2, 1);
    }

    public int getBottomBorder() {
        return this.addGridCell;
    }

    public void setBottomBorder(int n) {
        this.addGridCell = n;
        this.changeTotalHeight(-n);
    }

    public int getLeftBorder() {
        return this.addKeepTotalHeight;
    }

    public void setLeftBorder(int n) {
        this.addKeepTotalHeight = n;
        this.changeTotalWidth(-n);
    }

    public int getRightBorder() {
        return this.addKeepTotalWidth;
    }

    public void setRightBorder(int n) {
        this.addKeepTotalWidth = n;
        this.changeTotalWidth(-n);
    }

    public int getTopBorder() {
        return this.addElements;
    }

    public void setTopBorder(int n) {
        this.addElements = n;
        this.changeTotalHeight(-n);
    }

    public String toString() {
        TabularTree tabularTree = this.generateTtree();
        String string = "row :: " + this.getRowNum() + "    column :: " + this.getColumnNum() + "\n";
        int n = 0;
        while (n < tabularTree.getRowSize()) {
            IntVector intVector = tabularTree.getRow(n);
            int n2 = 0;
            while (n2 < intVector.size()) {
                string = string + this.getTabularCell(intVector.elementAt(n2)).toString() + " -- ";
                ++n2;
            }
            string = string + "\n";
            ++n;
        }
        return string;
    }
}

