/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.log.JRLogger;
import jet.report.JetRptField;
import jet.textobj.Caret;
import jet.textobj.ChrMtrcTmpl;
import jet.textobj.DLLBuf;
import jet.textobj.DLLBufable;
import jet.textobj.DblLinkable;
import jet.textobj.DocObj;
import jet.textobj.ExtGraphics;
import jet.textobj.FieldDest;
import jet.textobj.Obj;
import jet.textobj.PageHolder;
import jet.textobj.ParObj;
import jet.textobj.RtfDest;
import jet.textobj.SecObj;
import jet.textobj.TextUnit;
import jet.textobj.TextobjHolder;

public class Holder
implements DLLBufable,
DblLinkable {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int top;
    protected int left;
    protected int bottom;
    protected int right;
    Holder add;
    DLLBuf C = new DLLBuf();
    public ChrMtrcTmpl mtrcTmpl;
    boolean B = false;
    public int markStartPos;
    public int marksize;
    static Color D = Color.black;
    public Color norBkground = Color.white;
    public boolean nowMark;
    boolean F = true;
    static int J = 20;
    int S = 0;
    private static JRLogger black = JRLogger.getLogger((class$jet$textobj$Holder == null ? (class$jet$textobj$Holder = Holder.class$("jet.textobj.Holder")) : class$jet$textobj$Holder).getName());
    public boolean layoutOk;
    DblLinkable class$ = null;
    DblLinkable contains = null;
    static Class class$jet$textobj$Holder;

    public void drawBkground(ExtGraphics extGraphics, Color color, int n, int n2, int n3, int n4) {
        this.drawRawBkground(extGraphics, color, n, n2, n3, n4);
    }

    public void drawBufBkground(ExtGraphics extGraphics, Color color, int n, int n2, int n3, int n4) {
    }

    public void drawRawBkground(ExtGraphics extGraphics, Color color, int n, int n2, int n3, int n4) {
        Graphics graphics = extGraphics.getGraphics();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n - extGraphics.getOffX(), n2 - extGraphics.getOffY(), n3, n4);
        } else {
            TextobjHolder textobjHolder = this.getTextobjHolder();
            if (textobjHolder.G != null) {
                graphics.drawImage(textobjHolder.G, n - extGraphics.getOffX(), n2 - extGraphics.getOffY(), n + n3 - extGraphics.getOffX(), n2 + n4 - extGraphics.getOffY(), n - extGraphics.getOffX(), n2 - extGraphics.getOffY(), n + n3 - extGraphics.getOffX(), n2 + n4 - extGraphics.getOffY(), (Component)((Object)textobjHolder.N));
            }
        }
    }

    public Graphics getBufGraphics() {
        if (this.getTextobjHolder().H == null) {
            return null;
        }
        return this.getTextobjHolder().H.getGraphics();
    }

    public Image getBufImage() {
        return this.getTextobjHolder().H;
    }

    public PageHolder getPageHolder() {
        Holder holder = this;
        while (!(holder instanceof PageHolder)) {
            if ((holder = holder.getParent()) == null) break;
        }
        return (PageHolder)holder;
    }

    public TextobjHolder getTextobjHolder() {
        Holder holder = this;
        while (!(holder instanceof TextobjHolder)) {
            if ((holder = holder.getParent()) == null) break;
        }
        return (TextobjHolder)holder;
    }

    public Holder(Holder holder) {
        this.add = holder;
        this.nowMark = false;
    }

    public Holder() {
        this.add = null;
        this.nowMark = false;
    }

    public void doLayout() {
        this.layoutOk = false;
    }

    public static int screenToTwip(int n) {
        return TextUnit.convertPixelToTwip(n);
    }

    public static int twipToScreen(int n) {
        return TextUnit.convertTwipToPixel(n);
    }

    public static Color getComplementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public void paintBetween(int n, int n2, ExtGraphics extGraphics) {
        Rectangle rectangle = extGraphics.getClipBounds();
        int n3 = 0;
        while (n3 < this.C.size()) {
            Holder holder = (Holder)this.C.objAt(n3);
            if (this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height, holder)) {
                holder.paint(extGraphics);
            }
            ++n3;
        }
    }

    public void paint(ExtGraphics extGraphics) {
        Rectangle rectangle = extGraphics.getClipBounds();
        int n = 0;
        while (n < this.C.size()) {
            Holder holder = (Holder)this.C.objAt(n);
            if (rectangle.width == 0 || rectangle.height == 0 || this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height, holder)) {
                holder.paint(extGraphics);
            }
            ++n;
        }
    }

    public final void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public final void setInsets(Insets insets) {
        this.top = insets.top;
        this.left = insets.left;
        this.bottom = insets.bottom;
        this.right = insets.right;
    }

    public final void setInsets(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public final Insets getInsets() {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public final void setLocation(int n, int n2) {
        this.translate(n - this.x, n2 - this.y);
    }

    public final void setLocation(Point point) {
        this.translate(point.x - this.x, point.y - this.y);
    }

    public final Point getLocation() {
        return new Point(this.x, this.y);
    }

    public final void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public final void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public final Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    protected void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
        int n3 = 0;
        while (n3 < this.C.size()) {
            ((Holder)this.C.objAt(n3)).translate(n, n2);
            ++n3;
        }
    }

    protected void moveTo(int n, int n2) {
        this.translate(n - this.x, n2 - this.y);
    }

    public final Holder getParent() {
        return this.add;
    }

    public final void setParent(Holder holder) {
        this.add = holder;
    }

    public Holder getIntersectFrame(Rectangle rectangle, DLLBuf dLLBuf) {
        if (dLLBuf == null) {
            return null;
        }
        int n = 0;
        while (n < dLLBuf.size()) {
            Holder holder = (Holder)dLLBuf.objAt(n);
            if (this.intersects(rectangle, holder)) {
                return holder;
            }
            ++n;
        }
        return null;
    }

    public Holder getIntersectFrame(int n, int n2, int n3, int n4, DLLBuf dLLBuf) {
        if (dLLBuf == null) {
            return null;
        }
        int n5 = 0;
        while (n5 < dLLBuf.size()) {
            Holder holder = (Holder)dLLBuf.objAt(n5);
            if (this.intersects(n, n2, n3, n4, holder)) {
                return holder;
            }
            ++n5;
        }
        return null;
    }

    public final boolean intersects(int n, int n2, int n3, int n4, Holder holder) {
        return n + n3 > holder.x && n2 + n4 > holder.y && n < holder.x + holder.width && n2 < holder.y + holder.height;
    }

    public final boolean intersects(Rectangle rectangle, Holder holder) {
        return rectangle.x + rectangle.width > holder.x && rectangle.y + rectangle.height > holder.y && rectangle.x < holder.x + holder.width && rectangle.y < holder.y + holder.height;
    }

    public DblLinkable getNext() {
        return this.class$;
    }

    public DblLinkable getPrev() {
        return this.contains;
    }

    public void setNext(DblLinkable dblLinkable) {
        this.class$ = dblLinkable;
    }

    public void setPrev(DblLinkable dblLinkable) {
        this.contains = dblLinkable;
    }

    public boolean isTail() {
        return this.class$ == null;
    }

    public boolean isHead() {
        return this.contains == null;
    }

    public DblLinkable getHead() {
        return this.C.getHead();
    }

    public DblLinkable getTail() {
        return this.C.getTail();
    }

    public int size() {
        return this.C.size();
    }

    public Object objAt(int n) {
        return this.C.objAt(n);
    }

    public int indexOf(Object object) {
        return this.C.indexOf(object);
    }

    public int indexOf(Object object, int n) {
        return this.C.indexOf(object, n);
    }

    public boolean isEmpty() {
        return this.C.isEmpty();
    }

    public void append(DblLinkable dblLinkable, DblLinkable dblLinkable2) {
        this.C.append(dblLinkable, dblLinkable2);
        ((Holder)dblLinkable).setParent(this);
    }

    public void append(DblLinkable dblLinkable) {
        this.C.append(dblLinkable);
        ((Holder)dblLinkable).setParent(this);
    }

    public void add(DblLinkable dblLinkable) {
        this.C.add(dblLinkable);
        ((Holder)dblLinkable).setParent(this);
    }

    public void insert(DblLinkable dblLinkable, DblLinkable dblLinkable2) {
        this.C.insert(dblLinkable, dblLinkable2);
        ((Holder)dblLinkable).setParent(this);
    }

    public void insert(DblLinkable dblLinkable) {
        this.C.insert(dblLinkable);
        ((Holder)dblLinkable).setParent(this);
    }

    public void insert(DblLinkable dblLinkable, int n) {
        this.C.insert(dblLinkable, n);
        ((Holder)dblLinkable).setParent(this);
    }

    public void replace(DblLinkable dblLinkable, DblLinkable dblLinkable2) {
        this.C.replace(dblLinkable, dblLinkable2);
        ((Holder)dblLinkable).setParent(this);
    }

    public void remove(DblLinkable dblLinkable) {
        this.remove(dblLinkable, false);
    }

    public void remove(DblLinkable dblLinkable, boolean bl) {
        this.C.remove(dblLinkable);
        if (bl && this.isEmpty() && this.getParent() != null) {
            this.getParent().remove(this, true);
        }
    }

    public void removeAll() {
        this.C.removeAll();
    }

    public DLLBuf split(DblLinkable dblLinkable) {
        return this.C.split(dblLinkable);
    }

    public boolean isAdded() {
        return !this.C.isEmpty();
    }

    public boolean hasChildren() {
        return !this.C.isEmpty();
    }

    public boolean moveCaretToPoint(int n, int n2, Caret caret) {
        Rectangle rectangle = this.getBounds();
        if (!rectangle.contains(n, n2)) {
            return false;
        }
        Holder holder = (Holder)this.C.getHead();
        while (holder != null) {
            if (holder.moveCaretToPoint(n, n2, caret)) {
                return true;
            }
            holder = (Holder)holder.getNext();
        }
        return false;
    }

    public void dump(int n) {
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        return string + "@" + this.hashCode() + " [" + this.x + "," + this.y + "," + this.width + "," + this.height + "]";
    }

    public void verify() {
    }

    public static void versionConvert(RtfDest rtfDest) {
        if (rtfDest != null && rtfDest.getVersion() < 10) {
            DocObj docObj = (DocObj)rtfDest.getHead();
            Obj obj = docObj.getObjValue("docfmt");
            obj.setIntValue("margl", Holder.convert(rtfDest, obj.getIntValue("margl")));
            obj.setIntValue("margr", Holder.convert(rtfDest, obj.getIntValue("margr")));
            obj.setIntValue("margt", Holder.convert(rtfDest, obj.getIntValue("margt")));
            obj.setIntValue("margb", Holder.convert(rtfDest, obj.getIntValue("margb")));
            obj.setIntValue("deftab", Holder.convert(rtfDest, obj.getIntValue("deftab")));
            SecObj secObj = (SecObj)docObj.getHead();
            ParObj parObj = (ParObj)secObj.getHead();
            while (parObj != null) {
                Obj obj2 = parObj.getObjValue("parfmt");
                obj2.setIntValue("fi", Holder.convert(rtfDest, obj2.getIntValue("fi")));
                obj2.setIntValue("li", Holder.convert(rtfDest, obj2.getIntValue("li")));
                obj2.setIntValue("ri", Holder.convert(rtfDest, obj2.getIntValue("ri")));
                Obj obj3 = (Obj)parObj.getHead();
                while (obj3 != null) {
                    Obj obj4;
                    if (obj3.isObj("kwd")) {
                        obj4 = obj3.getObjValue("chrfmt");
                        if (obj4 != null && obj4.hasValue("fs")) {
                            obj4.setIntValue("fs", Holder.convert(rtfDest, obj4.getIntValue("fs")));
                        }
                    } else {
                        Object object;
                        Object object2;
                        obj4 = obj3.getFldOwner();
                        if (obj4 != null) {
                            object2 = (JetRptField)((FieldDest)obj4).getField();
                            object = JetRptField.getJetPropName("chrfmt.fs");
                            JetProperty jetProperty = ((JetObject)object2).nameToProperty((String)object);
                            jetProperty.set("" + Holder.convert(rtfDest, Integer.parseInt(jetProperty.toString())));
                            Obj obj5 = ((FieldDest)obj4).getField().getRslt().getObjValue("chrfmt");
                            if (obj5 != null && obj5.hasValue("fs")) {
                                obj5.setIntValue("fs", Holder.convert(rtfDest, obj5.getIntValue("fs")));
                            }
                            if ((obj5 = ((FieldDest)obj4).getField().getInst().getObjValue("chrfmt")) != null && obj5.hasValue("fs")) {
                                obj5.setIntValue("fs", Holder.convert(rtfDest, obj5.getIntValue("fs")));
                            }
                            ((FieldDest)obj4).fieldUpdated(false);
                            obj3 = ((FieldDest)obj4).getShowing();
                        }
                        if ((object2 = obj3.getObjValue("chrfmt")) != null && ((Obj)object2).hasValue("fs")) {
                            ((Obj)object2).setIntValue("fs", Holder.convert(rtfDest, ((Obj)object2).getIntValue("fs")));
                        }
                        if (((Obj)(object = (Obj)((DLLBufable)((Object)obj3)).getHead())).isObj("pict")) {
                            ((Obj)object).setIntValue("piccropt", Holder.convert(rtfDest, ((Obj)object).getIntValue("piccropt")));
                            ((Obj)object).setIntValue("piccropl", Holder.convert(rtfDest, ((Obj)object).getIntValue("piccropl")));
                            ((Obj)object).setIntValue("piccropb", Holder.convert(rtfDest, ((Obj)object).getIntValue("piccropb")));
                            ((Obj)object).setIntValue("piccropr", Holder.convert(rtfDest, ((Obj)object).getIntValue("piccropr")));
                        }
                    }
                    obj3 = (Obj)obj3.getNext();
                }
                parObj = (ParObj)parObj.getNext();
            }
            rtfDest.setVersion(10);
        }
    }

    private static int convert(RtfDest rtfDest, int n) {
        if (rtfDest.getVersion() == 10) {
            return n;
        }
        return (int)Math.round((double)(n * 72) / 96.0);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

