/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DPaper;
import chart.data.ChartDataSet;
import chart.graphics.ChartFillPattern;
import chart.properties.ChartGraphProperties;
import java.awt.Shape;

public abstract class Chart2DObject
extends ChartDataObject {
    protected ChartDataSet dataset;
    protected Chart2DPaper paper;
    protected Chart2DLayer layer;
    protected ChartGraphProperties objectProperties;
    protected ChartFillPattern[] seriesPattern;
    protected ChartFillPattern[] lineAreaPattern;
    protected int valueLabelPosition;

    Chart2DObject(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        this.dataset = chartDataSet;
        this.paper = chart2DPaper;
        this.layer = chart2DLayer;
    }

    public void init() {
        this.objectProperties = this.paper.getProperties().getGraphProperties();
    }

    public void setChartFillPatters(ChartFillPattern[] chartFillPatternArray) {
        this.seriesPattern = chartFillPatternArray;
    }

    abstract float[][] getStaticHintLocation();

    abstract Shape[][] getItemShapes();

    public int getValueLabelPosition() {
        return this.valueLabelPosition;
    }

    public void setValueLabelPosition(int n) {
        this.valueLabelPosition = n;
    }

    public ChartFillPattern[] getSeriesPattern() {
        return this.seriesPattern;
    }

    public ChartDataSet getChartDataSet() {
        return this.dataset;
    }

    public ChartFillPattern[] getLineAreaPattern() {
        return this.lineAreaPattern;
    }

    public void setLineAreaPattern(ChartFillPattern[] chartFillPatternArray) {
        this.lineAreaPattern = chartFillPatternArray;
    }
}

