/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.expression.relational;

import com.jinfonet.dataservice.api.expression.relational.IExtendInformation;
import com.jinfonet.dataservice.api.expression.relational.IProjectInformation;
import com.jinfonet.dataservice.api.expression.relational.IRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.ISingleRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.op.ISingleRelationOperator;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.relational.ARelationExpression;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.RelationMetaData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.OperatorTypes;

public final class SingleRelationExpressionImpl
extends ARelationExpression
implements ISingleRelationExpression {
    private IRelationExpression I;

    public SingleRelationExpressionImpl(String string, ISingleRelationOperator iSingleRelationOperator, IRelationExpression iRelationExpression) throws ConditionException, ConditionException {
        super(string, iSingleRelationOperator);
        if (iRelationExpression == null) {
            throw new ConditionException(8405, new Object[]{"sub exp was null"});
        }
        this.I = iRelationExpression;
        if (iRelationExpression.getResultMetaData() == null) {
            throw new ConditionException(8406, new Object[]{"sub exp metadata was null"});
        }
    }

    public IRelationExpression getExpression() {
        return this.I;
    }

    public JRelationMetaData getResultMetaData() throws ConditionException {
        if (this.metaData == null) {
            if (OperatorToolKit.isSelect(this.operator.operatorType()) || OperatorToolKit.isRelationSort(this.operator.operatorType())) {
                this.metaData = new RelationMetaData(this.createAllAtts(this.getAllSingleAtts(this.I.getResultMetaData())));
            } else if (OperatorToolKit.isProject(this.operator.operatorType())) {
                this.metaData = new RelationMetaData(this.I((IProjectInformation)this.operator.getOperatorInformation()));
            } else if (OperatorToolKit.isExtend(this.operator.operatorType())) {
                this.metaData = new RelationMetaData(this.createAllAtts(this.equals((IExtendInformation)this.operator.getOperatorInformation())));
            } else {
                throw new UnsupportedOperationException("operator type not support yet : " + this.operator.toString());
            }
        }
        return this.metaData;
    }

    private JAttribute[] I(IProjectInformation iProjectInformation) throws ConditionException {
        String[] stringArray;
        if (iProjectInformation.getProjectNameMappings().length != 2) {
            throw new IllegalArgumentException("project name list must 2 dimensions, original name and project names");
        }
        String[] stringArray2 = this.createAllAtts(iProjectInformation.getProjectNameMappings());
        if (stringArray2.length != (stringArray = this.append(iProjectInformation.getProjectNameMappings())).length) {
            throw new IllegalStateException("original names not equals with project names list");
        }
        if (this.I == null) {
            throw new IllegalStateException("project expression have not sub expression");
        }
        if (this.I.getResultMetaData() == null) {
            throw new IllegalStateException("project expression can not get sub expression metadata");
        }
        return this.QOIV(this.I.getResultMetaData(), stringArray2, stringArray);
    }

    private JAttribute[] QOIV(JRelationMetaData jRelationMetaData, String[] stringArray, String[] stringArray2) throws ConditionException {
        JAttribute[] jAttributeArray = this.getAllSingleAtts(jRelationMetaData);
        JAttribute[] jAttributeArray2 = new JAttribute[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < jAttributeArray.length) {
                if (jAttributeArray[n2].getAliasName().equals(stringArray[n])) {
                    jAttributeArray2[n] = new Attribute(jAttributeArray[n2]);
                    jAttributeArray2[n].setAliasName(stringArray2[n]);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new IllegalArgumentException("can not found col : " + stringArray[n] + " in sub expression metadata");
            }
            ++n;
        }
        return jAttributeArray2;
    }

    private String[] append(String[][] stringArray) {
        String[] stringArray2 = new String[stringArray[1].length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringArray[1][n];
            ++n;
        }
        return stringArray2;
    }

    private String[] createAllAtts(String[][] stringArray) {
        String[] stringArray2 = new String[stringArray[0].length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringArray[0][n];
            ++n;
        }
        return stringArray2;
    }

    private JAttribute[] equals(IExtendInformation iExtendInformation) throws ConditionException {
        JRelationMetaData jRelationMetaData = this.I.getResultMetaData();
        JAttribute[] jAttributeArray = iExtendInformation.getExtendMetas();
        JAttribute[] jAttributeArray2 = null;
        try {
            jAttributeArray2 = new JAttribute[jRelationMetaData.getColumnCount() + jAttributeArray.length];
            int n = 0;
            while (n < jRelationMetaData.getColumnCount()) {
                jAttributeArray2[n] = jRelationMetaData.getAttribute(n + 1);
                ++n;
            }
            int n2 = 0;
            while (n < jAttributeArray2.length) {
                jAttributeArray2[n] = jAttributeArray[n2];
                ++n;
                ++n2;
            }
        }
        catch (DSException dSException) {
            throw new ConditionException(8409, (Throwable)dSException);
        }
        return jAttributeArray2;
    }

    public void check() throws ConditionException {
    }

    public int expressionType() {
        return 196608;
    }

    public String toExpString() throws ConditionException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OperatorTypes.getOpTypeName(this.getOperator().operatorType()));
        stringBuffer.append(" ( ");
        stringBuffer.append(this.getExpression().toExpString());
        stringBuffer.append(" )");
        if (this.operator.getOperatorInformation() != null) {
            stringBuffer.append(" infor: ");
            stringBuffer.append(this.operator.getOperatorInformation().toString());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(OperatorTypes.getOpTypeName(this.getOperator().operatorType()));
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException(conditionException);
        }
        stringBuffer.append(" ( ");
        stringBuffer.append(this.getExpression().toString());
        stringBuffer.append(" )");
        stringBuffer.append(" infor: ");
        if (this.operator.getOperatorInformation() != null) {
            stringBuffer.append(this.operator.getOperatorInformation().toString());
        } else {
            stringBuffer.append("NULL");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.I.hashCode();
            this.hashCode = this.hashCode * 37 + this.operator.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ISingleRelationExpression) {
            ISingleRelationExpression iSingleRelationExpression = (ISingleRelationExpression)object;
            if (this.I != null && iSingleRelationExpression.getExpression() != null && this.I.equals(iSingleRelationExpression.getExpression()) && this.operator != null && iSingleRelationExpression.getOperator() != null && this.operator.equals(iSingleRelationExpression.getOperator())) {
                return true;
            }
        }
        return false;
    }
}

