/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.core.pushdown;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSDataField;
import java.text.SimpleDateFormat;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IMulti;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.util.CharBinaryFormat;

class ParameterProcessor {
    private ParameterValueList I;
    private ResourceContainer QOIV;

    public ParameterProcessor(ResourceContainer resourceContainer, ParameterValueList parameterValueList) {
        this.QOIV = resourceContainer;
        this.I = parameterValueList;
    }

    public void processParameters(IExpression iExpression) throws DSException {
        this.I(null, iExpression, -1);
    }

    private void I(IExpression iExpression, IExpression iExpression2, int n) throws DSException {
        if (iExpression2 != null) {
            if (ExpressionToolKit.isSetExp(iExpression2.expressionType())) {
                this.QOIV((ISetExpression)iExpression2);
                this.I(iExpression2, ((ISetExpression)iExpression2).getExpression(), 1);
            } else if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                this.Z(iExpression, (IVariableExpression)iExpression2, n);
            } else if (ExpressionToolKit.isSingleExp(iExpression2.expressionType())) {
                this.I(iExpression2, ((ISingle)((Object)iExpression2)).getExpression(), 1);
            } else if (ExpressionToolKit.isBinaryExp(iExpression2.expressionType())) {
                this.I(iExpression2, ((IBinary)((Object)iExpression2)).getExpression1(), 1);
                this.I(iExpression2, ((IBinary)((Object)iExpression2)).getExpression2(), 2);
            } else if (ExpressionToolKit.isTripleExp(iExpression2.expressionType())) {
                this.I(iExpression2, ((ITriple)((Object)iExpression2)).getExpression1(), 1);
                this.I(iExpression2, ((ITriple)((Object)iExpression2)).getExpression2(), 2);
                this.I(iExpression2, ((ITriple)((Object)iExpression2)).getExpression3(), 3);
            } else if (ExpressionToolKit.isMultiExp(iExpression2.expressionType())) {
                IMulti iMulti = (IMulti)((Object)iExpression2);
                IExpression[] iExpressionArray = iMulti.getExpressions();
                int n2 = 0;
                while (n2 < iExpressionArray.length) {
                    this.I(iExpression2, iExpressionArray[n2], -1);
                    ++n2;
                }
            }
        }
    }

    private void QOIV(ISetExpression iSetExpression) throws DSException {
    }

    private void Z(IExpression iExpression, IVariableExpression iVariableExpression, int n) throws DSException {
        try {
            if (ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
                this.append(iExpression, (IParameter)iVariableExpression, n);
            } else if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
                IVariableList iVariableList = (IVariableList)iVariableExpression;
                int n2 = 0;
                while (n2 < iVariableList.size()) {
                    this.Z(iVariableList, iVariableList.getVariableExp(n2), n2);
                    ++n2;
                }
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2540, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    private void append(IExpression iExpression, IParameter iParameter, int n) throws DSException {
        block13: {
            try {
                IVariableExpression iVariableExpression = this.containsIgnoreCase(iParameter);
                if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((ISingle)((Object)iExpression)).setExpression(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2541, new Object[]{"set par index error" + n});
                }
                if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((IBinary)((Object)iExpression)).setExpression1(iVariableExpression);
                        break block13;
                    }
                    if (n == 2) {
                        ((IBinary)((Object)iExpression)).setExpression2(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2542, new Object[]{"set par index error" + n});
                }
                if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                    if (n == 1) {
                        ((ITriple)((Object)iExpression)).setExpression1(iVariableExpression);
                        break block13;
                    }
                    if (n == 2) {
                        ((ITriple)((Object)iExpression)).setExpression2(iVariableExpression);
                        break block13;
                    }
                    if (n == 3) {
                        ((ITriple)((Object)iExpression)).setExpression3(iVariableExpression);
                        break block13;
                    }
                    throw new DSException(2543, new Object[]{"set par index error" + n});
                }
                if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) break block13;
                IVariableList iVariableList = (IVariableList)iExpression;
                if (this.bNull(iParameter)) {
                    iVariableList.setFormula((IFormula)iVariableExpression, n);
                    break block13;
                }
                if (this.contains(iParameter)) {
                    iVariableList.setConstant((IConstant)iVariableExpression, n);
                    break block13;
                }
                throw new DSException(2544, new Object[]{"set par type error"});
            }
            catch (ConditionException conditionException) {
                throw new DSException(2545, new Object[]{"Condition Exception"}, conditionException);
            }
        }
    }

    private boolean bNull(IVariableExpression iVariableExpression) throws DSException {
        try {
            if (this.QOIV.containsIgnoreCase(iVariableExpression.getName())) {
                this.QOIV.getStringValue();
                if (this.QOIV.wasFormula()) {
                    return true;
                }
            }
            return false;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2546, new Object[]{"condition exception"}, conditionException);
        }
    }

    private boolean contains(IVariableExpression iVariableExpression) throws DSException {
        try {
            if (this.QOIV.containsIgnoreCase(iVariableExpression.getName())) {
                return true;
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(2547, new Object[]{"condition exception"}, conditionException);
        }
        return false;
    }

    private IVariableExpression containsIgnoreCase(IVariableExpression iVariableExpression) throws DSException {
        try {
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            if (!this.I.contains(iVariableExpression.getName())) {
                throw new DSException(2548, new Object[]{"can not found parameter : " + iVariableExpression.getName() + " in resource container"});
            }
            DbValue dbValue = this.I.getValue(iVariableExpression.getName());
            IVariableExpression iVariableExpression2 = null;
            if (this.QOIV.containsIgnoreCase(dbValue.toString())) {
                String string = this.QOIV.getStringValue();
                if (this.QOIV.wasField()) {
                    IReference iReference = iExpressionFactory.createReference(string);
                    this.createConstant((JDSDataField)this.QOIV.getJAttribute(), iReference);
                    iVariableExpression2 = iReference;
                } else if (this.QOIV.wasFormula()) {
                    string = this.I.getValue(iVariableExpression.getName()).toString();
                    iVariableExpression2 = iExpressionFactory.createFormula(string);
                }
            } else {
                DbValue dbValue2 = this.I.getValue(iVariableExpression.getName());
                IConstant iConstant = iExpressionFactory.createConstant(ParameterProcessor.I(dbValue2));
                iConstant.setNull(dbValue2.bNull);
                iConstant.setDataType(Types.sqlTypeToType(dbValue2.getSqlType()));
                iVariableExpression2 = iConstant;
            }
            return iVariableExpression2;
        }
        catch (ConditionException conditionException) {
            throw new DSException(2549, new Object[]{"condition exception"}, conditionException);
        }
    }

    private void createConstant(JDSDataField jDSDataField, IReference iReference) throws DSException {
        try {
            iReference.setDataType(jDSDataField.getDataType());
            iReference.setLength(jDSDataField.getLength());
            iReference.setCaseSensitive(jDSDataField.isCaseSensitive());
            iReference.setCurrency(jDSDataField.isCurrency());
            iReference.setNullable(jDSDataField.isNullable());
            iReference.setPrecision(jDSDataField.getPrecision());
            iReference.setScale(jDSDataField.getScale());
        }
        catch (ConditionException conditionException) {
            throw new DSException(2550, new Object[]{"Condition Exception"}, conditionException);
        }
    }

    static String I(DbValue dbValue) {
        String string = null;
        SimpleDateFormat simpleDateFormat = null;
        if (dbValue.getSqlType() == 91) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string = simpleDateFormat.format(((DbDate)dbValue).getDate());
        } else if (dbValue.getSqlType() == 92) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            string = simpleDateFormat.format(((DbTime)dbValue).getTime());
        } else if (dbValue.getSqlType() == 93) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            string = simpleDateFormat.format(((DbTimestamp)dbValue).getTimestamp());
        } else {
            string = dbValue.desc.sqlType == 12 ? new CharBinaryFormat("XX").format(dbValue) : dbValue.toString();
        }
        return string;
    }
}

