/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDBField;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DSSubStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.QuickSortIntVector;
import jet.datastream.RandomByteArrayInputStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.PJFCommunicator;
import jet.ie.ZipToolkit;
import jet.ie.io.FileBlockInputStream;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataInput;
import jet.ie.io.PJFDataOutput;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;
import jet.util.QuickSortableVector;
import jet.util.QuickSorter;
import jet.util.RAFile;
import jet.util.TempFile;
import jet.util.intChain;

public class DataStream
extends DSSubStream {
    protected int cacheSize = 10;
    protected IntKeyHashtable cachedPages;
    protected intChain LRU;
    private boolean GZip;
    protected IntKeyHashtable pageEntries = new IntKeyHashtable();
    protected IntKeyHashtable pageLengthes = new IntKeyHashtable();
    private TempFile QOIV;
    private File UnGZip;
    protected RAFile bufFile;
    protected FileBlockOutputStream out;
    private boolean add = false;
    private DSPage addElement = null;

    public DataStream() {
    }

    public DataStream(Communicator communicator) {
        this(communicator, 4);
    }

    public DataStream(Communicator communicator, int n) {
        super(communicator, 0);
        this.cacheSize = n;
        this.cachedPages = new IntKeyHashtable(n);
        this.LRU = new intChain(n);
    }

    protected void createTempFile() {
        block3: {
            try {
                File file = new File(ReportEnv.temporaryPath);
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                this.QOIV = new TempFile(ReportEnv.temporaryPath, "datastream");
                this.UnGZip = this.QOIV.createTempFile();
                this.bufFile = new RAFile(this.UnGZip, "rw");
                this.out = new FileBlockOutputStream(this.bufFile);
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, exception);
            }
        }
    }

    public boolean isInMemory(int n) {
        return (DSPage)this.cachedPages.get(n) != null;
    }

    public void update(DSPage dSPage) throws IOException {
        int n = dSPage.getPageNum();
        Long l = (Long)this.pageEntries.get(n);
        if (l != null) {
            this.out.reset(l);
            RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
            byte[] byArray = randomByteArrayOutputStream.toByteArray();
            if (this.add) {
                byArray = ZipToolkit.GZip(byArray);
            }
            this.out.write(byArray);
            randomByteArrayOutputStream.close();
        }
    }

    public DSPage getPage(int n) throws IOException, JRStopEngineException {
        DSPage dSPage = null;
        dSPage = (DSPage)this.cachedPages.get(n);
        if (dSPage == null) {
            Long l = (Long)this.pageEntries.get(n);
            if (l != null) {
                dSPage = new DSPage(this, n);
                dSPage.setLocale(this.communicator.getLocale());
                dSPage.setTimeZone(this.communicator.getTimeZone());
                this.bufFile.seek(l);
                int n2 = (Integer)this.pageLengthes.get(n);
                FileBlockInputStream fileBlockInputStream = new FileBlockInputStream(this.bufFile);
                fileBlockInputStream.reset(n2);
                byte[] byArray = new byte[n2];
                fileBlockInputStream.read(byArray);
                byte[] byArray2 = byArray;
                if (this.add) {
                    byArray2 = ZipToolkit.UnGZip(byArray2);
                }
                RandomByteArrayInputStream randomByteArrayInputStream = new RandomByteArrayInputStream(byArray2);
                dSPage.read(new PJFDataInput(randomByteArrayInputStream));
                randomByteArrayInputStream.close();
            } else if (this.communicator instanceof PJFCommunicator) {
                if (this.addElement == null || this.addElement.getPageNum() != n) {
                    this.addElement = this.communicator.getPage(n);
                }
                return this.addElement;
            }
            if (dSPage != null) {
                this.cachePage(dSPage);
            }
        }
        return dSPage;
    }

    public boolean isEngineFinished() {
        return this.communicator.isEngineFinished();
    }

    public Rectangle getPageArea() {
        return this.communicator.getHeaderInfo(0).getPaperArea();
    }

    public Rectangle getPrintableArea() {
        return this.communicator.getHeaderInfo(0).getPrintableArea();
    }

    public int ie() {
        return this.communicator.getHeaderInfo(0).getie();
    }

    public Long getPageEntry(int n) {
        return (Long)this.pageEntries.get(n);
    }

    protected void cachePage(DSPage dSPage) throws IOException {
        int n;
        if (this.cachedPages.size() >= this.cacheSize) {
            n = this.LRU.removeLastElement();
            DSPage dSPage2 = (DSPage)this.cachedPages.remove(n);
            if (this.getPageEntry(n) == null) {
                if (this.bufFile == null) {
                    this.createTempFile();
                }
                long l = this.bufFile.length();
                this.bufFile.seek(l);
                this.out.reset(this.bufFile.length());
                RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage2.length());
                dSPage2.write(new PJFDataOutput(randomByteArrayOutputStream));
                byte[] byArray = randomByteArrayOutputStream.toByteArray();
                if (this.add) {
                    byArray = ZipToolkit.GZip(byArray);
                }
                this.out.write(byArray);
                randomByteArrayOutputStream.close();
                this.pageEntries.put(n, new Long(l));
                this.pageLengthes.put(n, new Integer((int)(this.bufFile.length() - l)));
            }
        }
        n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
        this.LRU.insertElementAt(n, 0);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput) throws IOException, JRStopEngineException {
        return this.saveTo(pJFDataOutput, false);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, boolean bl) throws IOException, JRStopEngineException {
        int n = this.communicator.getPageNum();
        long[] lArray = new long[n];
        if (lArray.length > 0) {
            lArray[0] = pJFDataOutput.getPosition();
        }
        int n2 = 1;
        while (n2 <= n) {
            Object object;
            DSPage dSPage = (DSPage)this.cachedPages.get(n2);
            if (dSPage == null && (object = (Long)this.pageEntries.get(n2)) != null) {
                dSPage = new DSPage(this, n2);
                dSPage.setLocale(this.communicator.getLocale());
                dSPage.setTimeZone(this.communicator.getTimeZone());
                this.bufFile.seek((Long)object);
                int n3 = (Integer)this.pageLengthes.get(n2);
                FileBlockInputStream fileBlockInputStream = new FileBlockInputStream(this.bufFile);
                fileBlockInputStream.reset(n3);
                byte[] byArray = new byte[n3];
                fileBlockInputStream.read(byArray);
                byte[] byArray2 = byArray;
                if (this.add) {
                    byArray2 = ZipToolkit.UnGZip(byArray);
                }
                RandomByteArrayInputStream randomByteArrayInputStream = new RandomByteArrayInputStream(byArray2);
                dSPage.read(new PJFDataInput(randomByteArrayInputStream));
                randomByteArrayInputStream.close();
            }
            object = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput((OutputStream)object));
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            if (bl) {
                byArray = ZipToolkit.GZip(byArray);
            }
            pJFDataOutput.write(byArray);
            if (n2 != n) {
                lArray[n2] = lArray[n2 - 1] + (long)byArray.length;
            }
            ((ByteArrayOutputStream)object).close();
            ++n2;
        }
        return lArray;
    }

    public void clearMem() {
        block5: {
            super.clearMem();
            if (this.cachedPages != null) {
                this.cachedPages.clear();
            }
            this.cachedPages = null;
            this.LRU = null;
            if (this.UnGZip != null) {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    this.bufFile.close();
                    this.UnGZip.delete();
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block5;
                    JRLog.error(2, iOException);
                }
            }
        }
    }

    public void sort(DSSection dSSection, DbValue dbValue, boolean bl) throws JRStopEngineException {
        block20: {
            Vector vector = new Vector(20);
            DSPage dSPage = (DSPage)dSSection.getParent();
            int n = dSPage.getChildren().indexOf(dSSection);
            try {
                Cloneable cloneable;
                int n2;
                Object object;
                int n3;
                int n4;
                int n5;
                boolean bl2 = this.GZip(n, dSPage, vector);
                if (!bl2 && !(this.communicator instanceof PJFCommunicator) && (n5 = dSPage.getPageNum()) != 1) {
                    DSPage dSPage2 = null;
                    int n6 = n5 - 1;
                    while (n6 > 0) {
                        dSPage2 = this.getPage(n6);
                        if (this.GZip(-1, dSPage2, vector)) break;
                        --n6;
                    }
                }
                if ((n5 = (int)(this.LRU(n + 1, dSPage, vector) ? 1 : 0)) == 0 && (n4 = dSPage.getPageNum()) != 1 && !(this.communicator instanceof PJFCommunicator)) {
                    DSPage dSPage3 = null;
                    n3 = this.communicator.getPageNum();
                    int n7 = n4 + 1;
                    while (n7 <= n3) {
                        dSPage3 = this.getPage(n7);
                        if (this.LRU(0, dSPage3, vector)) break;
                        ++n7;
                    }
                }
                DbColDesc dbColDesc = dbValue.getColDesc();
                IntVector intVector = null;
                n3 = 0;
                while (n3 < vector.size()) {
                    DSSection dSSection2 = (DSSection)vector.elementAt(n3);
                    if (intVector == null) {
                        JRecord jRecord;
                        block19: {
                            object = dSSection2.getRecord().getDependCursor();
                            jRecord = null;
                            try {
                                jRecord = object.createRecord();
                            }
                            catch (DSException dSException) {
                                if (!JRLog.isError(2)) break block19;
                                JRLog.error(2, dSException);
                            }
                        }
                        intVector = new QuickSortIntVector(20, jRecord, dbColDesc);
                    }
                    intVector.addElement(dSSection2.getRecordIndex());
                    ++n3;
                }
                new QuickSorter((QuickSortableVector)((Object)intVector), bl).sort();
                int n8 = vector.size();
                object = new Hashtable(n8);
                int n9 = 0;
                while (n9 < n8) {
                    DSSection dSSection3 = (DSSection)vector.elementAt(n9);
                    n2 = dSSection3.getRecordIndex();
                    Vector vector2 = new Vector(5);
                    cloneable = dSSection3.getChildren();
                    int n10 = 0;
                    while (n10 < ((Vector)cloneable).size()) {
                        Object e = ((Vector)cloneable).elementAt(n10);
                        if (e instanceof DSDBField) {
                            vector2.addElement(e);
                        }
                        ++n10;
                    }
                    ((Hashtable)object).put(new Integer(n2), vector2);
                    ++n9;
                }
                n2 = -1;
                int n11 = 0;
                while (n11 < n8) {
                    Object object2;
                    Object object3;
                    int n12 = intVector.elementAt(n11);
                    cloneable = (DSSection)vector.elementAt(n11);
                    ((DSSection)cloneable).setRecordIndex(n12);
                    Vector vector3 = (Vector)((Hashtable)object).get(new Integer(n12));
                    int n13 = 0;
                    while (n13 < vector3.size()) {
                        object3 = (JRVisiableResult)vector3.elementAt(n13);
                        object2 = (DSContainer)((JRObjectResult)object3).getParent();
                        if (object2 != null) {
                            ((DSContainer)object2).remove((JRObjectResult)object3);
                        }
                        ((DSContainer)cloneable).add((JRObjectResult)object3);
                        ++n13;
                    }
                    object3 = (DSPage)((JRObjectResult)cloneable).getParent();
                    if (object3 != null && n2 == -1) {
                        n2 = ((DSPage)object3).getPageNum();
                    }
                    if (object3 != null && n2 != ((DSPage)object3).getPageNum() && (object2 = (Long)this.pageEntries.get(n2 = ((DSPage)object3).getPageNum())) != null) {
                        this.bufFile.seek((Long)object2);
                        this.out.reset(this.bufFile.getPosition());
                        RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(((DSPage)object3).length());
                        ((DSPage)object3).write(new PJFDataOutput(randomByteArrayOutputStream));
                        byte[] byArray = randomByteArrayOutputStream.toByteArray();
                        if (this.add) {
                            byArray = ZipToolkit.GZip(byArray);
                        }
                        this.out.write(byArray);
                    }
                    ++n11;
                }
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block20;
                JRLog.error(2, iOException);
            }
        }
    }

    private boolean GZip(int n, DSPage dSPage, Vector vector) {
        boolean bl = false;
        Vector vector2 = dSPage.getChildren();
        JRObjectResult jRObjectResult = null;
        if (n == -1) {
            n = vector2.size() - 1;
        }
        int n2 = n;
        while (n2 >= 0) {
            jRObjectResult = (JRObjectResult)vector2.elementAt(n2);
            int n3 = jRObjectResult.getObjectType();
            if ((n3 & 0x200) == 512 && n3 != 514 && n3 != 517 && n3 != 513 && n3 != 516) {
                if (n3 == 519) {
                    vector.insertElementAt(jRObjectResult, 0);
                } else {
                    bl = true;
                    break;
                }
            }
            --n2;
        }
        return bl;
    }

    private boolean LRU(int n, DSPage dSPage, Vector vector) {
        boolean bl = false;
        Vector vector2 = dSPage.getChildren();
        int n2 = vector2.size();
        JRObjectResult jRObjectResult = null;
        if (n == -1) {
            n = vector2.size() - 1;
        }
        int n3 = n;
        while (n3 < n2) {
            jRObjectResult = (JRObjectResult)vector2.elementAt(n3);
            int n4 = jRObjectResult.getObjectType();
            if ((n4 & 0x200) == 512 && n4 != 514 && n4 != 517 && n4 != 513 && n4 != 516) {
                if (n4 == 519) {
                    vector.addElement(jRObjectResult);
                } else {
                    bl = true;
                    break;
                }
            }
            ++n3;
        }
        return bl;
    }

    public void finish() {
        this.GZip = true;
    }

    public boolean isFinished() {
        return this.GZip;
    }

    public void savePageIfInDisk(int n, DSPage dSPage) {
        Long l = (Long)this.pageEntries.get(n);
        if (l != null) {
            try {
                this.bufFile.seek(l);
                this.out.reset(this.bufFile.getPosition());
                RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
                dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
                byte[] byArray = randomByteArrayOutputStream.toByteArray();
                if (this.add) {
                    byArray = ZipToolkit.GZip(byArray);
                }
                this.out.write(byArray);
                randomByteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                JRLog.error(2, iOException);
            }
        }
    }

    public boolean isCacheZip() {
        return this.add;
    }

    public void setCacheZip(boolean bl) {
        this.add = bl;
    }
}

