/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.type1;

import java.awt.Color;
import java.awt.Image;
import java.util.Vector;
import jet.datastream.CTGridInfo;
import jet.datastream.DSCTField;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.DSShape;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.report.xls.GlobalWorksheet;
import jet.udos.JHyperLinkRslt;
import jet.util.Containable;

public class ExcelColor {
    private int[] QOIV;
    private GlobalWorksheet addColor;
    private String bgRect;

    public ExcelColor(GlobalWorksheet globalWorksheet, String string) {
        this.addColor = globalWorksheet;
        this.bgRect = string;
        this.QOIV = new int[3];
    }

    public GlobalWorksheet getGws() {
        return this.addColor;
    }

    public String getEncoding() {
        return this.bgRect;
    }

    public int[] getFieldColor(DSField dSField) {
        Containable containable;
        Containable containable2;
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color3 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        if (color == null) {
            color = Color.black;
        }
        this.QOIV[0] = ExcelColor.calculateColor(color);
        if (color2 == null && !(dSField instanceof DSCTField) && dSField.getParent() != null && (containable2 = dSField.getParent()) instanceof DSContainer && (color2 = CCUtil.getColorPropertyByName((DSContainer)containable2, "Background")) == null && (containable = ((DSContainer)containable2).getParent()) != null && containable instanceof DSContainer) {
            color2 = CCUtil.getColorPropertyByName((DSContainer)containable, "Background");
        }
        this.QOIV[1] = color2 != null ? ExcelColor.calculateColor(color2) : -1;
        this.QOIV[2] = color3 == null ? -1 : ExcelColor.calculateColor(color3);
        return this.QOIV;
    }

    public int[] getShapeColor(DSShape dSShape, int n) {
        Color color;
        Color color2;
        this.QOIV[0] = -1;
        if (n != 22) {
            color2 = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
            color = CCUtil.getColorPropertyByName(dSShape, "Background");
        } else {
            color2 = CCUtil.getColorPropertyByName(dSShape, "LineColor");
            color = null;
        }
        this.QOIV[1] = color != null ? ExcelColor.calculateColor(color) : -1;
        this.QOIV[2] = color2 != null ? ExcelColor.calculateColor(color2) : -1;
        return this.QOIV;
    }

    public int[] getParaTextColor(JRVisiableResult jRVisiableResult) {
        this.QOIV[2] = -1;
        if (jRVisiableResult instanceof DSParagraphText) {
            Color color = (Color)jRVisiableResult.getPropertyByName("Foreground").getObject();
            Color color2 = (Color)jRVisiableResult.getPropertyByName("Background").getObject();
            this.QOIV[0] = ExcelColor.calculateColor(color);
            this.QOIV[1] = color2 != null ? ExcelColor.calculateColor(color2) : -1;
        } else {
            this.QOIV[0] = -1;
            this.QOIV[1] = 255;
        }
        return this.QOIV;
    }

    public int[] getUDOColor(JRVisiableResult jRVisiableResult) {
        this.QOIV[2] = -1;
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            Image image = (Image)jRVisiableResult.getPropertyByName("displayImage").getObject();
            if (image == null) {
                Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
                Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
                this.QOIV[0] = ExcelColor.calculateColor(color);
                this.QOIV[1] = color2 != null ? ExcelColor.calculateColor(color2) : -1;
            } else {
                this.QOIV[0] = -1;
                this.QOIV[1] = 255;
            }
        } else {
            this.QOIV[0] = -1;
            this.QOIV[1] = 255;
        }
        return this.QOIV;
    }

    public int[] getPictureColor(DSPicture dSPicture, int n) {
        Color color;
        this.QOIV[2] = -1;
        this.QOIV[1] = -1;
        this.QOIV[0] = -1;
        if (n == 129 && (color = CCUtil.getColorPropertyByName(dSPicture, "BorderColor")) != null) {
            this.QOIV[2] = ExcelColor.calculateColor(color);
        }
        return this.QOIV;
    }

    public int[] getCrosstabFieldColor(DSCTField dSCTField) {
        Color color;
        Object object;
        this.QOIV = this.getFieldColor(dSCTField);
        DSCrossTab dSCrossTab = (DSCrossTab)dSCTField.getParent();
        Color color2 = CCUtil.getColorPropertyByName(dSCTField, "BorderColor");
        if (color2 != null) {
            this.QOIV[2] = ExcelColor.calculateColor(color2);
        } else {
            color2 = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
            if (color2 != null) {
                this.QOIV[2] = ExcelColor.calculateColor(color2);
            }
        }
        if (this.QOIV[1] == -1) {
            object = dSCrossTab.getGridInfos();
            int n = 0;
            while (n < ((Vector)object).size()) {
                Vector vector = (Vector)((Vector)object).elementAt(n);
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    CTGridInfo cTGridInfo = (CTGridInfo)vector.get(n3);
                    if (cTGridInfo.fillColor != null && cTGridInfo.bgRect.contains(dSCTField.getX(), dSCTField.getY())) {
                        this.QOIV[1] = ExcelColor.calculateColor(cTGridInfo.fillColor);
                        break;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        if (this.QOIV[1] == -1 && dSCTField.getParent() != null && (object = dSCTField.getParent()) instanceof DSContainer && (color = CCUtil.getColorPropertyByName((DSContainer)object, "Background")) != null) {
            this.QOIV[1] = ExcelColor.calculateColor(color);
        }
        return this.QOIV;
    }

    public void registerColor(int[] nArray) {
        int n = 0;
        while (n < 3) {
            if (nArray[n] != -1) {
                this.addColor.addColor(nArray[n]);
            }
            ++n;
        }
    }

    public static int calculateColor(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }
}

