/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.service;

import com.jinfonet.util.JRLog;
import java.util.LinkedList;
import java.util.Vector;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.Creatable;
import jet.reportLogic.builder.ActionBuilder;

public class ActionManager {
    protected Queue undoStack;
    protected Queue redoStack;

    public ActionManager(int n) {
        this.undoStack = new Queue(this, n);
        this.redoStack = new Queue(this, n);
    }

    public ActionManager(int n, int n2) {
        this.undoStack = new Queue(this, n);
        this.redoStack = new Queue(this, n2);
    }

    public boolean canUndo() {
        return !this.undoStack.Z();
    }

    public boolean canRedo() {
        return !this.redoStack.Z();
    }

    public boolean isUndoableAction(Action action) {
        return action.isUndoable();
    }

    public boolean isRedoableAction(Action action) {
        return action.isRedoable();
    }

    public Vector doAction(Action action) {
        Vector vector = action.doAction();
        if (action.isUndoable()) {
            this.undoStack.I(action);
            this.redoStack.clear();
        }
        return vector;
    }

    public Vector doAction(Vector vector) {
        if (this.undoStack.contains(vector)) {
            vector = (Vector)vector.clone();
        }
        Vector vector2 = new Vector();
        boolean bl = true;
        int n = 0;
        while (n < vector.size()) {
            Vector vector3 = ((Action)vector.get(n)).doAction();
            if (!((Action)vector.get(n)).isUndoable()) {
                bl = false;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                if (!vector2.contains(vector3.get(n2))) {
                    vector2.add(vector3.get(n2));
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            this.undoStack.I(vector);
            this.redoStack.clear();
        }
        return vector2;
    }

    public Vector appendAction(Vector vector, Action action) {
        if (!this.undoStack.contains(vector) && JRLog.isTrace(6)) {
            JRLog.trace(6, "Append action to a group of actions which is not undoable.");
        }
        Vector vector2 = action.doAction();
        vector.add(action);
        if (!action.isUndoable() && this.undoStack.contains(vector)) {
            this.undoStack.remove(vector);
        }
        return vector2;
    }

    public Vector doSerialActions(Vector vector) {
        Vector<Action> vector2 = new Vector<Action>();
        Vector vector3 = new Vector();
        boolean bl = true;
        int n = 0;
        while (n < vector.size()) {
            ActionBuilder actionBuilder = (ActionBuilder)vector.get(n);
            Action action = actionBuilder.build();
            Vector vector4 = action.doAction();
            vector2.add(action);
            if (!action.isUndoable()) {
                bl = false;
            }
            int n2 = 0;
            while (n2 < vector4.size()) {
                if (!vector3.contains(vector4.get(n2))) {
                    vector3.add(vector4.get(n2));
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            this.undoStack.I(vector2);
            this.redoStack.clear();
        }
        return vector3;
    }

    public Object doCreatingAction(Action action) {
        if (action.getAtomicAction(0) instanceof Creatable) {
            ((Creatable)((Object)action.getAtomicAction(0))).create();
            return ((Creatable)((Object)action.getAtomicAction(0))).getCreation();
        }
        return null;
    }

    public Vector undoAction() {
        if (this.canUndo()) {
            Vector vector = null;
            Object object = this.undoStack.C();
            if (object instanceof Action) {
                vector = ((Action)object).undo();
                if (((Action)object).isRedoable()) {
                    this.redoStack.I(object);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                int n = vector2.size() - 1;
                while (n >= 0) {
                    object = (Action)vector2.get(n);
                    if (((Action)object).isUndoable()) {
                        Vector vector3 = ((Action)object).undo();
                        if (!((Action)vector2.get(n)).isRedoable()) {
                            bl = false;
                        }
                        int n2 = 0;
                        while (n2 < vector3.size()) {
                            if (!vector.contains(vector3.get(n2))) {
                                vector.add(vector3.get(n2));
                            }
                            ++n2;
                        }
                    }
                    --n;
                }
                if (bl) {
                    this.redoStack.I(vector2);
                }
            }
            return vector;
        }
        return null;
    }

    public Vector redoAction() {
        if (this.canRedo()) {
            Vector vector = null;
            Object object = this.redoStack.C();
            if (object instanceof Action) {
                vector = ((Action)object).redo();
                if (((Action)object).isUndoable()) {
                    this.undoStack.I(object);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                int n = 0;
                while (n < vector2.size()) {
                    object = (Action)vector2.get(n);
                    if (((Action)object).isRedoable()) {
                        Vector vector3 = ((Action)object).redo();
                        if (!((Action)vector2.get(n)).isUndoable()) {
                            bl = false;
                        }
                        int n2 = 0;
                        while (n2 < vector3.size()) {
                            if (!vector.contains(vector3.get(n2))) {
                                vector.add(vector3.get(n2));
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                if (bl) {
                    this.undoStack.I(vector2);
                }
            }
            return vector;
        }
        return null;
    }

    public void clearStack() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    class Queue
    extends LinkedList {
        private int QOIV;
        private int clear;
        private final ActionManager this$0;

        Queue(ActionManager actionManager, int n) {
            this.this$0 = actionManager;
            this.QOIV = 0;
            this.clear = 0;
            this.QOIV = n;
        }

        int I() {
            return this.clear;
        }

        boolean Z() {
            return this.clear == 0;
        }

        public void clear() {
            super.clear();
            this.clear = 0;
        }

        Object I(Object object) {
            if (this.clear < this.QOIV) {
                this.add(object);
                ++this.clear;
            } else {
                this.removeFirst();
                this.add(object);
            }
            return object;
        }

        Object C() {
            if (this.clear > 0) {
                return this.remove(--this.clear);
            }
            return null;
        }
    }
}

