/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.security.api.Permissions;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.util.JRLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.acl.NotOwnerException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.acl.ACLException;
import jet.bean.JRCatalog;
import jet.bean.JREngine;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.JetColumnName;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.DataEngineFactory;
import jet.dataengine.api.DataEngineOption;
import jet.dataengine.api.Group;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.GroupQueryOption;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JDemandQuery;
import jet.dataengine.api.query.JDynamicQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.groupengine.GroupEnd;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroupList;
import jet.dataengine.groupengine.LeafGroupModel;
import jet.dataengine.groupengine.NormalGroupBreaker;
import jet.datasource.InputStreamFactory;
import jet.datastream.Communicator;
import jet.exception.EngingPreinitException;
import jet.exception.InvalidParameterException;
import jet.formula.ExecutableJavaFormula;
import jet.formula.FormulaInfo;
import jet.formula.FormulaQueue;
import jet.formula.JavaFormula;
import jet.formula.JavaFormulaContainer;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.ie.CLSInfo;
import jet.ie.VersionException;
import jet.jetc.ReadFailureException;
import jet.report.JReportUtil;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptDBField;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSortContainer;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSystemVariable;
import jet.report.JetRptView;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.convert.CvIExpression;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.DataSetLogic;
import jet.reportLogic.objectLogic.JetFilterExpLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ViewLogic;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportset.DataSet;
import jet.reportset.JSecurityEntryException;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptOnDemandDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.ContainerInfo;
import jet.rptengine.EngineListener;
import jet.rptengine.EngineRefreshListener;
import jet.rptengine.JCommunicator;
import jet.rptengine.JEngineInitializer;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubLinkContainer;
import jet.rptengine.JSubReportEngine;
import jet.rptservice.api.RSDBurstingProvidor;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.ReportSetEnv;
import jet.rptservice.api.ScheduleListener;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRSReportEngine;
import jet.rptservice.engine.JSubRptSetEngine;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.accessor.cube.CubeQueryBuilder;
import jet.rptservice.engine.infocenter.DataSetCenter;
import jet.rptservice.engine.infocenter.PartialData;
import jet.rptservice.engine.infocenter.ReportCenter;
import jet.rptservice.engine.infocenter.ReportInfo;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.engine.infocenter.ReportViewInfo;
import jet.rptservice.engine.infocenter.SubReportInfo;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.exception.JRSInvalidTemplateException;
import jet.rptservice.listener.DataSetListener;
import jet.rptservice.manager.ParameterManager;
import jet.rptservice.pub.DynamicQueryInfo;
import jet.rptservice.pub.JColumnSecurityContainer;
import jet.rptservice.pub.JRecordSecurityContainer;
import jet.rptservice.pub.LinkInfo;
import jet.rptservice.pub.MasterDetailInfo;
import jet.rptservice.pub.RSDBurstingInfo;
import jet.rptservice.pub.RSDInfo;
import jet.rptservice.pub.RSDInfoForSingleRptSet;
import jet.rptservice.security.AccessController;
import jet.rptservice.security.AccessControllerFactory;
import jet.rptservice.util.DataTools;
import jet.rptservice.util.ITemplateLoader;
import jet.rptservice.util.ITreeIterator;
import jet.rptservice.util.ITreeNode;
import jet.rptservice.util.PreOrderIterator;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.SubReportCheckTool;
import jet.rptservice.util.SubRptEngineLoader;
import jet.rptservice.util.SubRptLoader;
import jet.rptservice.util.SubRptShareTool;
import jet.rptservice.util.Tools;
import jet.security.PageACL;
import jet.server.api.SecurityContext;
import jet.server.api.ServerInfo;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.JetUXMLConnection;
import jet.universe.UniverseUtil;
import jet.universe.businesslogic.BLException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.resultfile.CachedQueryResult;
import jet.universe.tools.UniverseTools;
import jet.util.CPUToken;
import jet.util.Converter;
import jet.util.DataEngineInfo;
import jet.util.EngineErrorListener;
import jet.util.EngineExecuter;
import jet.util.EngineRuntimeInfo;
import jet.util.IntVector;
import jet.util.JFieldValueNLSManager;
import jet.util.NLSBundleInfo;
import jet.util.ReportEngineInfo;
import jet.util.ReportsetEngineInfo;
import jet.util.RuntimeInfo;
import jet.util.ThreadErrorListener;

public class JRptSetEngine
implements EngineListener {
    public static final int LEVEL_PARAMETER = 0;
    public static final int LEVEL_RUN_REPORT = 1;
    public static final int ENGINE_TYPE_NORMAL = 0;
    public static final int ENGINE_TYPE_LINK = 1;
    public static final int ENGINE_TYPE_DETAIL = 2;
    public static final int ENGINE_TYPE_GOTODETAIL = 3;
    public static final String JAVA_FORMULA = "java_formula";
    public static final String IS_FAST_PASS = "is_fast_pass";
    public static final String PARAMETERS = "parameters";
    public static final String MAPPING_NAMES = "mapping_names";
    public static final String RPT_FORMULAS = "rpt_formulas";
    public static final String FILTER = "filter";
    public static final int PAINT = 0;
    public static final int RECREATE_DATASTREAM = 1;
    public static final int RELOAD_DATASOURCE = 2;
    public static final int DATASOURCE_ERROR = 4;
    public static final int REPORT_MODIFIED = 5;
    public static final int CATALOG_MODIFIED = 6;
    public static final int DATASET_MODIFIED = 32;
    public static final int QUERY_MODIFIED = 64;
    public static final String PARAM_ALL_VALUE = "\u0007";
    protected Hashtable htReportEngine = new Hashtable();
    protected ReportSetCenter rptSetCenter = null;
    private String LOCAL_LANGUAGE;
    private String P_VISIBLE;
    private String QOIV;
    private String REPORT_NAME = null;
    private String SetShowValueForOneParamDesc = null;
    private Locale ThreadException;
    protected boolean singleThread;
    private TimeZone UNKNOWN;
    protected String userName;
    private boolean __sys__USERNAME = false;
    private RSDInfo add = null;
    private int addAll = 0;
    protected RSDInfoForSingleRptSet rsdInforForRptSet = null;
    protected JetRptReportSet rptSet;
    protected JetUUniverse universe;
    private int addDataContainer = 0;
    private JRCatalog addElement;
    private String addIndexOfParentIndex;
    private Hashtable addJavaFormula = new Hashtable();
    private DynamicQueryInfo addParameterValue = null;
    private int addRefreshListener = Converter.UNKNOWN;
    private int afterInit = Converter.UNKNOWN;
    private String afterInitParameter = null;
    private String append = null;
    private Properties applyNLSorDynamicStyle = null;
    private Hashtable asList;
    private Hashtable asyncronizedSetPriority;
    protected JDataEngine dataEngine = null;
    protected boolean isBatchRun = false;
    private boolean backupDataStatus = false;
    private boolean beforeFirst = false;
    private boolean beforeRun = false;
    private ParameterManager booleanValue = null;
    protected SecurityContext secCxt = null;
    private static SecurityData buildCubeQuery = null;
    private ServerInfo canApplyNLS = null;
    private boolean canSummary = false;
    private boolean catchError = false;
    private CPUToken changeParamValues;
    protected JReportEngine parentReportEngine;
    private JSubLinkContainer checkSubReportLoop;
    private LinkInfo clear = null;
    private MasterDetailInfo clearEngine = null;
    private JetRptSystemVariable clearMem = new JetRptSystemVariable();
    private Vector clearSubEngines;
    private int clearSubRptInfoMap = 0;
    private IntVector clone;
    private HashMap close;
    private boolean closeAllGroups;
    private boolean closeAllRawDatas = false;
    private Object closeRawData = new Object();
    private int closeRelatedDataInstance = -1;
    private Properties colName = null;
    private Locale columnName = null;
    private String compareTo = null;
    private NLSBundleInfo contains = null;
    private EngineExecuter containsKey = null;
    private JdbcDriversConfig create = null;
    private int createAccessController = 2;
    private boolean createDataEngine = false;
    private ScheduleListener createDataSourceQuery = null;
    private boolean createDefaultRuntimeInfo = false;
    public final Object priorityLocker = new Object();
    private int createDemandQuery = 5;
    private boolean createDynamicQuery = false;
    private boolean createEngineRuntimeInfo = false;
    private int createGroupQuery = -1;
    private boolean createNamingSystem = false;
    private String createResultSet = null;
    private BurstingSchema[] createViewEngine = null;
    private RSDBurstingProvidor currentThread;
    private boolean currentTimeMillis = false;
    private boolean cvIExpresstion = false;
    private int dataDriver = 1;
    private Hashtable deepDupWithName;
    private Hashtable denyAllColumns;

    JRptSetEngine() {
    }

    public JRptSetEngine(String string, JetRptReportSet jetRptReportSet, JetUUniverse jetUUniverse, JdbcDriversConfig jdbcDriversConfig, boolean bl) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine()..., rptSetName: " + string + " rptSet: " + jetRptReportSet + " unv: " + jetUUniverse + " jdbcDirverCfg: " + jdbcDriversConfig);
        }
        this.rptSet = jetRptReportSet;
        this.universe = jetUUniverse;
        this.create = jdbcDriversConfig;
        this.createDefaultRuntimeInfo = bl;
        try {
            this.P_VISIBLE(jdbcDriversConfig, bl);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(220010, (Throwable)dSException);
        }
        this.rptSetCenter = new ReportSetCenter(this);
        this.rptSetCenter.setRptSetName(Tools.getFileNameWithoutPath(string));
        this.booleanValue = new ParameterManager(this.rptSetCenter);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "create report set engine, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine().");
        }
    }

    public JRptSetEngine(String string, JetRptReportSet jetRptReportSet, JetUUniverse jetUUniverse, JdbcDriversConfig jdbcDriversConfig, boolean bl, boolean bl2) throws JRScheduleException {
        this(string, jetRptReportSet, jetUUniverse, jdbcDriversConfig, bl);
        this.createEngineRuntimeInfo = bl2;
    }

    public void setParentEngine(JReportEngine jReportEngine) {
        this.parentReportEngine = jReportEngine;
    }

    public JReportEngine getParentEngine() {
        return this.parentReportEngine;
    }

    public void setSubLinkContainer(JSubLinkContainer jSubLinkContainer) {
        this.checkSubReportLoop = jSubLinkContainer;
    }

    public JSubLinkContainer getSubLinkContainer() {
        return this.checkSubReportLoop;
    }

    public void setLinkInfo(LinkInfo linkInfo) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setLinkInfo..., info: " + linkInfo);
        }
        this.clear = linkInfo;
    }

    public LinkInfo getLinkInfo() {
        return this.clear;
    }

    public void setMasterDetailInfo(MasterDetailInfo masterDetailInfo) {
        this.clearEngine = masterDetailInfo;
    }

    public MasterDetailInfo getMasterDetailInfo() {
        return this.clearEngine;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setServerInfo()..., info: " + serverInfo);
        }
        this.canApplyNLS = serverInfo;
    }

    public ServerInfo getServerInfo() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getServerInfo()..., return: " + this.canApplyNLS);
        }
        return this.canApplyNLS;
    }

    public void setKey(String string) {
        this.QOIV = string;
    }

    public String getKey() {
        return this.QOIV;
    }

    public void setUID(String string) {
        this.REPORT_NAME = string;
    }

    public String getUID() {
        return this.REPORT_NAME;
    }

    public void setCallerId(String string) {
        this.SetShowValueForOneParamDesc = string;
    }

    public String getCallerId() {
        return this.SetShowValueForOneParamDesc;
    }

    public JRSReportEngine getReportEngine(String string) {
        return this.htReportEngine == null || string == null ? null : (JRSReportEngine)this.htReportEngine.get(string);
    }

    public JReportEngine getReportViewEngine(String string, String string2) {
        if (this.htReportEngine == null) {
            return null;
        }
        String string3 = string == null ? this.rptSet.getCurReportId() : string;
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string3);
        return jRSReportEngine == null ? null : jRSReportEngine.getViewEngine(string2);
    }

    public Vector getAllReportEngines() {
        Vector<JRSReportEngine> vector = new Vector<JRSReportEngine>();
        if (this.htReportEngine == null) {
            return vector;
        }
        String[] stringArray = this.rptSet.getAllReportsName();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine != null) {
                vector.addElement(jRSReportEngine);
            }
            ++n;
        }
        return vector;
    }

    public Vector getAllReportViewEngines() {
        Vector vector = new Vector();
        Vector vector2 = this.getAllReportEngines();
        int n = 0;
        while (n < vector2.size()) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)vector2.elementAt(n);
            vector.addAll(jRSReportEngine.getViewEngines());
            ++n;
        }
        return vector;
    }

    public Vector getReportViewEngines(String[] stringArray, Vector[] vectorArray) {
        Vector<JReportEngine> vector = new Vector<JReportEngine>();
        if (this.htReportEngine == null) {
            return vector;
        }
        if (stringArray == null || stringArray.length == 0) {
            return vector;
        }
        if (vectorArray == null || vectorArray.length == 0) {
            return vector;
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                if (jReportEngine != null) {
                    vector.addElement(jReportEngine);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public ReportSetCenter getReportSetCenter() {
        return this.rptSetCenter;
    }

    public void setReportSetCenter(ReportSetCenter reportSetCenter) {
        this.rptSetCenter = reportSetCenter;
    }

    public JRptSetEngine getMainRptSetEngine() {
        return this;
    }

    public void setCatalogBean(JRCatalog jRCatalog) {
        this.addElement = jRCatalog;
    }

    public void setConfigFile(String string) {
        this.addIndexOfParentIndex = string;
    }

    public void setUserName(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setUserName()..., userName: " + string);
        }
        this.userName = string;
        this.clearMem.setUserName(string);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.secCxt = securityContext;
    }

    public SecurityContext getSecurityContext() {
        return this.secCxt;
    }

    public static void setSecurityData(SecurityData securityData) {
        buildCubeQuery = securityData;
    }

    public static SecurityData getSecurityData() {
        return buildCubeQuery;
    }

    public void setWherePortion(String string) {
        this.rptSetCenter.setWherePortion(string);
    }

    public void setWherePortion(String string, String string2, String string3) {
        this.rptSetCenter.setWherePortion(string, string2, string3);
    }

    public void setWhereName(String string) {
        this.rptSetCenter.setWhereName(string);
    }

    public void setWhereName(String string, String string2, String string3) {
        this.rptSetCenter.setWhereName(string, string2, string3);
    }

    public void setDataDriver(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setDataDriver()..., url: " + string);
        }
        this.rptSetCenter.setDataDriver(string);
    }

    public void setDataDriver(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setDataDriver()..., dataSetName: " + string + " url: " + string2);
        }
        this.rptSetCenter.setDataDriver(string, string2);
    }

    public JetRptSystemVariable getSysVariable() {
        return this.clearMem;
    }

    public void setSysVariable(JetRptSystemVariable jetRptSystemVariable) {
        this.clearMem = jetRptSystemVariable;
    }

    public Date getModifyDate() {
        return this.getSysVariable().getModifiedDate();
    }

    public DynamicQueryInfo getDynamicQueryInfo(String string) {
        if (this.addJavaFormula == null) {
            return null;
        }
        return (DynamicQueryInfo)this.addJavaFormula.get(string);
    }

    public void setDynamicQueryInfo(String string, DynamicQueryInfo dynamicQueryInfo) {
        if (this.addJavaFormula == null) {
            this.addJavaFormula = new Hashtable();
        }
        this.addJavaFormula.put(string, dynamicQueryInfo);
    }

    public DynamicQueryInfo getDynamicQueryInfo() {
        return this.addParameterValue;
    }

    public void setDynamicQueryInfo(DynamicQueryInfo dynamicQueryInfo) {
        this.addParameterValue = dynamicQueryInfo;
    }

    public void setDynamicQueryInfo(Hashtable hashtable) {
        this.addJavaFormula = hashtable;
    }

    public void setFromEncoding(int n) {
        this.addRefreshListener = n;
    }

    public int getFromEncoding() {
        return this.addRefreshListener;
    }

    public void setToEncoding(int n) {
        this.afterInit = n;
    }

    public int getToEncoding() {
        return this.afterInit;
    }

    public void setType(int n) {
        this.addDataContainer = n;
    }

    public int getType() {
        return this.addDataContainer;
    }

    public boolean isSingleThread() {
        return this.singleThread;
    }

    public void setSingleThread(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setSingleThread()..., singleThread: " + bl + " this: " + this);
        }
        this.singleThread = bl;
        if (this.htReportEngine != null) {
            Enumeration enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(enumeration.nextElement());
                jRSReportEngine.setSingleThread(bl);
            }
        }
    }

    public void setIsDHTML(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setIsDHTML()..., isDHTML: " + bl + " this: " + this);
        }
        this.backupDataStatus = bl;
    }

    public boolean isDHTML() {
        return this.backupDataStatus;
    }

    public void setPipe(boolean bl) {
        this.beforeFirst = bl;
    }

    public boolean isPipe() {
        return this.beforeFirst;
    }

    public void setIsRsd(boolean bl) {
        this.__sys__USERNAME = bl;
    }

    public boolean isRsd() {
        return this.__sys__USERNAME;
    }

    public boolean isBurstingRsd() {
        return this.currentThread != null;
    }

    public boolean isReady() {
        return this.beforeRun;
    }

    public int getRSDIndex() {
        return this.addAll++;
    }

    public void setIsReady(boolean bl) {
        this.beforeRun = bl;
    }

    public String getEncoding() {
        return this.P_VISIBLE;
    }

    public void setEncoding(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setEncoding()..., encoding: " + string);
        }
        this.P_VISIBLE = string;
    }

    public int getConvertFromEncoding() {
        return this.addRefreshListener;
    }

    public int getConvertToEncoding() {
        return this.afterInit;
    }

    public void setConvertEncoding(int n, int n2) {
        this.addRefreshListener = n;
        this.afterInit = n2;
    }

    public void setLocale(Locale locale) {
        this.ThreadException = locale;
    }

    public Locale getLocale() {
        return this.ThreadException == null ? Locale.getDefault() : this.ThreadException;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.UNKNOWN = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.UNKNOWN;
    }

    public void setClientName(String string) {
        this.LOCAL_LANGUAGE = string;
    }

    public String getClientName() {
        return this.LOCAL_LANGUAGE;
    }

    public void setAllowFFP(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setAllowFFP()..., bAFFP: " + bl);
        }
        this.catchError = bl;
    }

    public boolean isAllowFFP() {
        return this.catchError;
    }

    public void setCPUToken(CPUToken cPUToken) {
        this.changeParamValues = cPUToken;
    }

    public CPUToken getCPUToken() {
        return this.changeParamValues;
    }

    public JDataEngine getDataEngine() {
        return this.dataEngine;
    }

    public void setRSDInfo(RSDInfo rSDInfo) {
        this.add = rSDInfo;
    }

    public RSDInfo getRSDInfo() {
        return this.add;
    }

    public RSDBurstingProvidor getBurstingRSDProvidor() {
        return this.currentThread;
    }

    public void setRSDInfoForRptSet(RSDInfoForSingleRptSet rSDInfoForSingleRptSet) {
        this.rsdInforForRptSet = rSDInfoForSingleRptSet;
    }

    public RSDInfoForSingleRptSet getRSDInfoForRptSet() {
        return this.rsdInforForRptSet;
    }

    public ReportSetEnv getReportSetEnv() {
        return this.isBurstingRsd() ? this.getBurstingRSDProvidor().getReportSetEnv(0) : null;
    }

    public void setFontMap(Properties properties, Locale locale, String string) {
        this.colName = properties;
        this.columnName = locale;
        this.compareTo = string;
    }

    public Properties getFontMap() {
        return this.colName;
    }

    public Locale getFontMapLocale() {
        return this.columnName;
    }

    public String getFontMapEncoding() {
        return this.compareTo;
    }

    public void setNLSBundleInfo(NLSBundleInfo nLSBundleInfo) {
        this.contains = nLSBundleInfo;
    }

    public NLSBundleInfo getNLSBundleInfo() {
        return this.contains;
    }

    public void setNLSMode(int n) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setNLSMode()..., mode: " + n);
        }
        this.createAccessController = n;
    }

    public int getNLSMode() {
        return this.createAccessController;
    }

    public void setEngineExecuter(EngineExecuter engineExecuter) {
        this.containsKey = engineExecuter;
    }

    public EngineExecuter getEngineExecuter() {
        return this.containsKey;
    }

    protected Vector getListeners() {
        return this.clearSubEngines;
    }

    protected void setListeners(Vector vector) {
        this.clearSubEngines = vector;
    }

    public void addEngineListener(EngineErrorListener engineErrorListener) {
        if (this.getListeners() == null) {
            this.setListeners(new Vector(3));
        }
        if (!this.getListeners().contains(engineErrorListener)) {
            this.getListeners().addElement(engineErrorListener);
        }
    }

    public void removeEngineListener(EngineErrorListener engineErrorListener) {
        if (this.getListeners() != null) {
            this.getListeners().removeElement(engineErrorListener);
            if (this.getListeners().isEmpty()) {
                this.setListeners(null);
            }
        }
    }

    public SpecialFields getSpecialFields(String string) {
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        SpecialFields specialFields = null;
        if (dataSetCenter != null) {
            specialFields = dataSetCenter.getSpecialFields();
        }
        return specialFields;
    }

    public synchronized int genAliasNo() {
        int n = ++this.clearSubRptInfoMap;
        return n;
    }

    public JFieldValueNLSManager getNLSManager(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getNLSManager()..., rptName: " + string + " viewName: " + string2);
        }
        JFieldValueNLSManager jFieldValueNLSManager = null;
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (jRSReportEngine != null) {
            jFieldValueNLSManager = jRSReportEngine.getNLSManager(string2);
        } else {
            Tools.logTrace(6, "invalid report name, no such engine.");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getNLSManager(). return: " + jFieldValueNLSManager);
        }
        return jFieldValueNLSManager;
    }

    public void setScheduleListener(ScheduleListener scheduleListener) {
        this.createDataSourceQuery = scheduleListener;
    }

    public boolean isCacheZip() {
        return this.createDefaultRuntimeInfo;
    }

    private void LOCAL_LANGUAGE(int n) {
        if (this.createDataSourceQuery != null) {
            this.createDataSourceQuery.notifyMessage(n);
        }
    }

    public void setStyleGroup(String string, String string2, String string3) {
        ReportInfo reportInfo;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setStyleGroup()..., rptName: " + string + " viewName: " + string2 + " styleGroup: " + string3);
        }
        if (this.close == null) {
            this.close = new HashMap();
        }
        if ((reportInfo = (ReportInfo)this.close.get(string)) == null) {
            reportInfo = new ReportInfo();
            ReportViewInfo reportViewInfo = new ReportViewInfo();
            reportViewInfo.setStyleGroup(string3);
            reportInfo.setRptViewInfo(string2, reportViewInfo);
            this.close.put(string, reportInfo);
        } else {
            ReportViewInfo reportViewInfo = reportInfo.getRptViewInfo(string2);
            if (reportViewInfo == null) {
                reportViewInfo = new ReportViewInfo();
                reportInfo.setRptViewInfo(string2, reportViewInfo);
            }
            reportViewInfo.setStyleGroup(string3);
        }
    }

    public ReportInfo getRptInfo(String string) {
        if (this.close == null) {
            return null;
        }
        return (ReportInfo)this.close.get(string);
    }

    public String[] getReportNames() {
        String[] stringArray = this.rptSet.getAllReportsName();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (this.htReportEngine != null && this.htReportEngine.containsKey(stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public Vector[] getViewNames(String[] stringArray) {
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            vectorArray[n] = new Vector();
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                vectorArray[n].addElement(stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return vectorArray;
    }

    public Enumeration getAllDataSetName() {
        return this.rptSetCenter.getAllDataSetName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void P_VISIBLE(JdbcDriversConfig jdbcDriversConfig, boolean bl) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.prepareDataEngines()..., jdbcDriversConfig: " + jdbcDriversConfig);
        }
        DataEngineOption dataEngineOption = new DataEngineOption();
        dataEngineOption.setJdbcDriversConfig(jdbcDriversConfig);
        dataEngineOption.setCacheZip(bl);
        Object object = this.getAllSubRptSetEngine();
        if (object == null) {
            this.dataEngine = DataEngineFactory.createDataEngine(dataEngineOption);
            this.dataEngine.setThreadPriority(this.getPriority());
        } else {
            Object object2 = object;
            synchronized (object2) {
                this.dataEngine = DataEngineFactory.createDataEngine(dataEngineOption);
                this.dataEngine.setThreadPriority(this.getPriority());
            }
        }
    }

    public void setPageNumbers(String string, String string2, int[] nArray) {
    }

    public int[] getPageNumbers(String string, String string2) {
        return null;
    }

    public PageACL getPageACL(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getPageACL()..., rptName: " + string + " viewName: " + string2);
        }
        PageACL pageACL = null;
        JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
        if (jReportEngine != null) {
            pageACL = jReportEngine.getPageACL();
        } else {
            Tools.logTrace(6, "report view engine is null, return null.");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getPageACL(). return: " + pageACL);
        }
        return pageACL;
    }

    public boolean hasSecurity(String string, String string2) throws JRScheduleException {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.hasSecurity()..., rptName: " + string + " viewName: " + string2);
        }
        if ((jReportEngine = this.getReportViewEngine(string, string2)) == null) {
            throw new JRScheduleException(220049, new String[]{string, string2}, null);
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        String[] stringArray = reportViewCenter.getAllDataContainerNames();
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0) {
            JetRptReport jetRptReport = reportViewCenter.getReportView();
            int n = 0;
            while (n < stringArray.length) {
                JetObject jetObject = jetRptReport.nameToObject(stringArray[n]);
                boolean bl2 = false;
                if (jetObject instanceof JetRptSectionObject) {
                    bl2 = ((JetRptSectionObject)jetObject).isSecurity();
                } else if (jetObject instanceof JetRptNewTable) {
                    bl2 = ((JetRptNewTable)jetObject).isSecurity();
                }
                if (bl2) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.hasSecurity(). return: " + bl);
        }
        return bl;
    }

    public boolean prepareReportEngines() {
        Tools.logTrace(6, "JRptSetEngine.prepareReportEngines()...");
        boolean bl = this.prepareReportEngines(1);
        Tools.logTrace(6, "End of JRptSetEngine.prepareReportEngines().");
        return bl;
    }

    public boolean prepareReportEngines(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()..., rptName: " + string + " viewName: " + string2);
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        boolean bl = this.prepareReportEngines(new String[]{string}, new Vector[]{vector});
        Tools.logTrace(6, "End of JRptSetEngine.prepareReportEngines().");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareReportEngines(int n) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()..., rptStatus = " + n);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        boolean bl = false;
        Object object = this.getAllSubRptSetEngine();
        if (object == null) {
            bl = this.REPORT_NAME(n);
        } else {
            Object object2 = object;
            synchronized (object2) {
                bl = this.REPORT_NAME(n);
            }
        }
        if (JRLog.isTrace(6)) {
            this.displayStructure();
            JRLog.trace(6, "prepare report engines, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines()...");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareReportEngines(String[] stringArray, Vector[] vectorArray) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,rptNames = " + Tools.toString(stringArray) + " vRptViews = " + Tools.toString(vectorArray));
        }
        if (stringArray == null || vectorArray == null) {
            Tools.logTrace(5, "warning: rptNames or vRptViews is null!");
            return true;
        }
        if (this.isBursting() && (stringArray.length != 1 || vectorArray.length != 1 || vectorArray[0].size() != 1)) {
            Tools.logTrace(5, "error: only support one bursting report!");
            return false;
        }
        Object object = this.getAllSubRptSetEngine();
        if (object == null) {
            this.QOIV(stringArray, vectorArray);
        } else {
            Object object2 = object;
            synchronized (object2) {
                this.QOIV(stringArray, vectorArray);
            }
        }
        if (JRLog.isTrace(6)) {
            this.displayStructure();
            JRLog.trace(6, "prepare report engines, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines()...");
        }
        return true;
    }

    private void QOIV(String[] stringArray, Vector[] vectorArray) {
        int n = 0;
        while (n < stringArray.length) {
            JetRptReport jetRptReport = this.rptSet.getReport(stringArray[n]);
            String[] stringArray2 = vectorArray[n].toArray(new String[0]);
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                jRSReportEngine = new JRSReportEngine(jetRptReport, this);
                jRSReportEngine.setSingleThread(this.singleThread);
                this.htReportEngine.put(stringArray[n], jRSReportEngine);
                ReportCenter reportCenter = new ReportCenter(jRSReportEngine, stringArray[n]);
                this.rptSetCenter.setReportCenter(stringArray[n], reportCenter);
            }
            jRSReportEngine.createViewEngine(jetRptReport, stringArray2);
            ++n;
        }
    }

    private boolean REPORT_NAME(int n) {
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = new String[]{this.rptSet.getCurReportId()};
                break;
            }
            case 1: {
                stringArray = this.rptSet.getOpenedRptNames();
                break;
            }
            case 2: {
                stringArray = this.rptSet.getAllReportsName();
                break;
            }
            default: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,invalid rpt status: " + n);
                }
                return false;
            }
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                JetRptReport jetRptReport = this.rptSet.getReport(stringArray[n2]);
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n2]);
                if (jRSReportEngine == null) {
                    jRSReportEngine = new JRSReportEngine(jetRptReport, this);
                    jRSReportEngine.setSingleThread(this.singleThread);
                    this.htReportEngine.put(stringArray[n2], jRSReportEngine);
                    ReportCenter reportCenter = new ReportCenter(jRSReportEngine, stringArray[n2]);
                    this.rptSetCenter.setReportCenter(stringArray[n2], reportCenter);
                }
                jRSReportEngine.createViewEngine(jetRptReport, n);
                ++n2;
            }
        }
        return true;
    }

    public boolean prepareReportEngines(RSDInfo rSDInfo) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,rsdInfo = " + rSDInfo);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        this.add = rSDInfo;
        this.__sys__USERNAME = true;
        int n = this.getRSDIndex();
        String string = rSDInfo.getMainRptSetName();
        this.rsdInforForRptSet = rSDInfo.getRSDInfoForRptSet(n);
        this.booleanValue.setValidParamValues(rSDInfo.getParameter());
        this.rptSetCenter.setDeniedBLColumns(1, rSDInfo.getDeniedBLNames(1));
        Map map = rSDInfo.getReportInfos(0);
        int n2 = map.size();
        String[] stringArray = new String[n2];
        Vector[] vectorArray = new Vector[n2];
        int n3 = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n3] = (String)iterator.next();
            vectorArray[n3] = (Vector)map.get(stringArray[n3]);
            ++n3;
        }
        boolean bl = this.prepareReportEngines(stringArray, vectorArray);
        String[] stringArray2 = rSDInfo.getRptSetNames();
        JetRootable[] jetRootableArray = new JetRptReportSet[stringArray2.length];
        int n4 = 0;
        while (n4 < jetRootableArray.length) {
            jetRootableArray[n4] = rSDInfo.getRptSet(n4);
            ++n4;
        }
        Hashtable hashtable = rSDInfo.getImgMappingTable();
        if (hashtable != null) {
            JReportUtil.setImgMappingtable(jetRootableArray, hashtable);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepare report engines, total cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines(rsdInfo).");
        }
        return bl;
    }

    public boolean prepareReportEngines(RSDBurstingProvidor rSDBurstingProvidor) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines(burstingRSDProvidor)...,providor = " + rSDBurstingProvidor);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        this.currentThread = rSDBurstingProvidor;
        this.booleanValue.setValidParamValues(this.currentThread.getParamerValues());
        ReportSetEnv reportSetEnv = this.currentThread.getReportSetEnv(0);
        String[] stringArray = reportSetEnv.getReportNames();
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            vectorArray[n] = new Vector<String>(Arrays.asList(reportSetEnv.getReportViewNames(stringArray[n])));
            ++n;
        }
        boolean bl = this.prepareReportEngines(stringArray, vectorArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepare report engines, total cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines(burstingRSDProvidor).");
        }
        return bl;
    }

    public void runReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptName: " + string + " viewName: " + string2);
        }
        this.runReport(string, string2, true);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public void runReport(String string, String string2, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptName: " + string + " viewName: " + string2 + " applyStyleNls: " + bl);
        }
        String[] stringArray = new String[]{string};
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        this.runReport(stringArray, vectorArray, bl);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public boolean relayout(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.relayout()..., rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.layoutReport(), no any report engines, return false.");
            return false;
        }
        if (!this.getAllReportsName(string, string2)) {
            Tools.logTrace(6, "End of JRptSetEngine.layoutReport(), report view don't be requested to run, return false.");
            return false;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (jRSReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.layoutReport(), report engine don't exist, return false.");
            return false;
        }
        ReportViewNames reportViewNames = new ReportViewNames(this);
        reportViewNames.I(string, string2);
        this.genRawDataQueryOption(reportViewNames);
        boolean bl = jRSReportEngine.I(string2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.layoutReport(), return " + bl);
        }
        return bl;
    }

    public void runReport(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        this.runReport(stringArray, vectorArray, true);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public void runReport(String[] stringArray, Vector[] vectorArray, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " applyStyleNls: " + bl);
        }
        if (!this.requestRunReport(stringArray, vectorArray)) {
            return;
        }
        this.LOCAL_LANGUAGE(7);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray2 = vectorArray[n].toArray(new String[vectorArray[n].size()]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                this.doRequestRunReport(string, stringArray2[n2], bl);
                ++n2;
            }
            ++n;
        }
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public DynamicQueryInfo getUsedDynamicQueryInfo(String string) {
        DynamicQueryInfo dynamicQueryInfo = this.getDynamicQueryInfo(string);
        if (dynamicQueryInfo != null) {
            return dynamicQueryInfo;
        }
        return this.addParameterValue;
    }

    public void runDataSet(String string, boolean bl) throws JRScheduleException {
        JCubeQuery jCubeQuery;
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runDataSet()..., rptSetEngine: " + this + "dataSetName: " + string + " refreshData: " + bl + " rptSetEngine: " + this);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set center is null, dataSetName: " + string);
            }
            return;
        }
        if (dataSetCenter.getDataSet().getMappingListSrc() == 3) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set is hds, can't run data set, dataSetName: " + string);
            }
            return;
        }
        if (!dataSetCenter.hasDbFieldOrPass1Formula() && !dataSetCenter.hasConstantGlobalFormula()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "run data set: no db fields and formula. ");
                JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
            }
            return;
        }
        if (bl) {
            dataSetCenter.setNeedInitQuery(true);
            dataSetCenter.setNeedRefreshGeneralQuery(true);
            dataSetCenter.setNeedRefresh(true);
            dataSetCenter.setNeedInitCubeQuery(true);
            dataSetCenter.setNeedRefreshCube(true);
        }
        if (!dataSetCenter.needRefresh() && !dataSetCenter.needRefreshCube()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "run data set: it is not need to refresh data. ");
                JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
            }
            return;
        }
        try {
            Tools.logTrace(6, "init raw data query.");
            this.initRawDataQuery(dataSetCenter);
        }
        catch (JRScheduleException jRScheduleException) {
            if (!this.catchError(string, jRScheduleException)) {
                throw jRScheduleException;
            }
            return;
        }
        JRawDataQuery jRawDataQuery = dataSetCenter.needRefresh() ? dataSetCenter.getRawDataQuery() : null;
        JCubeQuery jCubeQuery2 = jCubeQuery = dataSetCenter.needRefreshCube() ? dataSetCenter.getCubeQuery() : null;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "begin run raw data query..., rawDataQueryId: " + dataSetCenter.getRawDataId() + " query: " + jRawDataQuery);
        }
        if (jRawDataQuery == null && jCubeQuery == null) {
            Tools.logTrace(6, "raw data query and cube query are all null.");
        } else {
            JQuery[] jQueryArray;
            Tools.logTrace(6, "begin run data set..., " + string);
            long l = System.currentTimeMillis();
            if (jCubeQuery == null) {
                JQuery[] jQueryArray2 = new JQuery[1];
                jQueryArray = jQueryArray2;
                jQueryArray2[0] = jRawDataQuery;
            } else if (jRawDataQuery == null) {
                JQuery[] jQueryArray3 = new JQuery[1];
                jQueryArray = jQueryArray3;
                jQueryArray3[0] = jCubeQuery;
            } else {
                JQuery[] jQueryArray4 = new JQuery[2];
                jQueryArray4[0] = jRawDataQuery;
                jQueryArray = jQueryArray4;
                jQueryArray4[1] = jCubeQuery;
            }
            JQuery[] jQueryArray5 = jQueryArray;
            Tools.logTrace(6, "rptSetName: " + this.rptSetCenter.getRptSetName());
            try {
                Tools.logTrace(6, "run raw data query: " + (jCubeQuery == null ? " raw query id: " + jRawDataQuery.getQueryId() : (jRawDataQuery == null ? " cube query id: " + jCubeQuery.getQueryId() : " raw query id: " + jRawDataQuery.getQueryId() + " cube query id: " + jCubeQuery.getQueryId())));
                int n = 0;
                while (n < jQueryArray5.length) {
                    Tools.logTrace(5, "raw data id: " + jQueryArray5[n].getQueryId());
                    if (jQueryArray5[n] instanceof JRawDataQuery) {
                        Tools.logTrace(5, "mappingNames: " + Tools.toString(((JRawDataQuery)jQueryArray5[n]).getMappingNames()));
                    }
                    ++n;
                }
                this.dataEngine.prepareQuery(jQueryArray5);
            }
            catch (DSException dSException) {
                JRScheduleException jRScheduleException = new JRScheduleException(220002, (Throwable)dSException);
                if (!this.catchError(string, jRScheduleException)) {
                    throw jRScheduleException;
                }
                return;
            }
            catch (JRStopEngineException jRStopEngineException) {
                JRScheduleException jRScheduleException = new JRScheduleException(220002, (Throwable)jRStopEngineException);
                if (!this.catchError(string, jRScheduleException)) {
                    throw jRScheduleException;
                }
                return;
            }
            DataSetListener dataSetListener = dataSetCenter.getRawDataListener();
            dataSetListener.disable();
            if (dataSetListener.getError() != null) {
                new JRScheduleException(220002, dataSetListener.getError());
            }
            long l2 = System.currentTimeMillis();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "prepare raw data query of data set " + string);
                JRLog.trace(6, "SCHEDULE_PRDQ, [ELAPSED]: " + (l2 - l));
            }
        }
        dataSetCenter.setNeedRefresh(false);
        dataSetCenter.setHasUsed(true);
        Tools.logTrace(6, "End of JRptSetEngine.runDataSet().");
    }

    private boolean SetShowValueForOneParamDesc(String string) throws JRScheduleException {
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runGeneralRawDataQuery()..., rptSetEngine: " + this + "dataSetName: " + string);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            JRLog.error(2, "data set center is null, dataSetName: " + string);
            return false;
        }
        try {
            Tools.logTrace(6, "init raw data query.");
            this.initRawDataQuery(dataSetCenter);
        }
        catch (JRScheduleException jRScheduleException) {
            if (!this.catchError(string, jRScheduleException)) {
                throw jRScheduleException;
            }
            return false;
        }
        if (!dataSetCenter.hasDbFieldOrPass1Formula()) {
            JRLog.error(2, "run general raw data query: no db fields and formula. ");
            return false;
        }
        if (!dataSetCenter.needRefreshGeneralQuery()) {
            Tools.logTrace(6, "it is not need to refresh general raw data query.");
            return true;
        }
        JRawDataQuery jRawDataQuery = dataSetCenter.getGeneralRawDataQuery();
        Tools.logTrace(6, "begin run general raw data query..., rawDataQueryId: " + dataSetCenter.getGeneralRawDataId() + " query: " + jRawDataQuery);
        if (jRawDataQuery == null) {
            JRLog.error(2, "general raw data query is null.");
            return false;
        }
        Tools.logTrace(6, "run general raw data query " + string + "...");
        long l = System.currentTimeMillis();
        try {
            this.dataEngine.prepareQuery(new JRawDataQuery[]{jRawDataQuery});
        }
        catch (DSException dSException) {
            JRScheduleException jRScheduleException = new JRScheduleException(220002, (Throwable)dSException);
            if (!this.catchError(string, jRScheduleException)) {
                throw jRScheduleException;
            }
            return false;
        }
        catch (JRStopEngineException jRStopEngineException) {
            JRScheduleException jRScheduleException = new JRScheduleException(220002, (Throwable)jRStopEngineException);
            if (!this.catchError(string, jRScheduleException)) {
                throw jRScheduleException;
            }
            return false;
        }
        long l2 = System.currentTimeMillis();
        Tools.logTrace(6, "prepare general raw data query of data set " + string);
        Tools.logTrace(6, "SCHEDULE_PRDQ, [ELAPSED]: " + (l2 - l));
        dataSetCenter.setNeedRefreshGeneralQuery(false);
        Tools.logTrace(6, "End of JRptSetEngine.runGeneralRawDataQuery().");
        return true;
    }

    protected boolean catchError(String string, JRScheduleException jRScheduleException) {
        if (this instanceof JSubRptSetEngine) {
            ((JSubRptSetEngine)this).setThrowedError(string, jRScheduleException);
            return true;
        }
        return false;
    }

    public void resetRawDataQuery(String string, JRawDataQuery jRawDataQuery, Hashtable hashtable) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.resetRawDataQuery()..., dataSetName: " + string + "params: " + hashtable);
        }
        this.ThreadException(string, hashtable);
        JavaFormula javaFormula = (JavaFormula)hashtable.get(JAVA_FORMULA);
        Boolean bl = (Boolean)hashtable.get(IS_FAST_PASS);
        JetRptFormula[] jetRptFormulaArray = (JetRptFormula[])hashtable.get(RPT_FORMULAS);
        String[] stringArray = (String[])hashtable.get(MAPPING_NAMES);
        Hashtable hashtable2 = (Hashtable)hashtable.get(PARAMETERS);
        IBooleanExpression iBooleanExpression = (IBooleanExpression)hashtable.get(FILTER);
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        try {
            Object object;
            Object object2;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "set java formula: " + javaFormula + " to raw data query, id: " + jRawDataQuery.getRawDataId());
            }
            jRawDataQuery.setJavaFormula(javaFormula);
            ParameterValueList parameterValueList = this.addDataContainer(string, hashtable2);
            jRawDataQuery.setParameterValues(parameterValueList);
            if (dataSetCenter.hasDbFieldOrPass1Formula()) {
                object2 = dataSetCenter.getDataSet();
                object = ((JetRptDataSet)object2).getDataSourceName();
                String string2 = ((JetRptDataSet)object2).getQueryName();
                if (this.isBursting()) {
                    DataBlock dataBlock = dataSetCenter.getDataBlock();
                    try {
                        ResultSet resultSet = dataBlock.createResultSet();
                        String[][] stringArray2 = this.applyNLSorDynamicStyle(resultSet);
                        MappingNameBindInfo[] mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray2, resultSet);
                        DataDescription dataDescription = DataDescription.create(resultSet, this.universe, (String)object, string2, mappingNameBindInfoArray);
                        JDynamicQuery jDynamicQuery = (JDynamicQuery)jRawDataQuery;
                        jDynamicQuery.setDataDescription(dataDescription);
                        jDynamicQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220011, new String[]{string}, dSException);
                    }
                    catch (SQLException sQLException) {
                        throw new JRScheduleException(220011, new String[]{string}, sQLException);
                    }
                    Tools.logTrace(6, "reset dynamic query(bursting), raw data query id: " + jRawDataQuery.getRawDataId());
                } else if (this.isBurstingRsd() || this.isRsd() && dataSetCenter.getRsdResultSet() != null) {
                    Object object3;
                    MappingNameBindInfo[] mappingNameBindInfoArray;
                    ResultSet resultSet = null;
                    String[][] stringArray3 = null;
                    if (this.isBurstingRsd()) {
                        mappingNameBindInfoArray = this.getReportSetEnv().getResultSetProvidor(string);
                        resultSet = mappingNameBindInfoArray.getResultSet();
                        stringArray3 = mappingNameBindInfoArray.getBindInfo();
                    } else {
                        resultSet = dataSetCenter.getRsdResultSet().getResultSet();
                        stringArray3 = dataSetCenter.getBindInfo();
                    }
                    mappingNameBindInfoArray = null;
                    if (this.isRsd() && stringArray3 == null) {
                        object3 = this.rptSetCenter.getAllMappingFields(dataSetCenter.getDataSetName());
                        mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(resultSet, object3, this.universe, (String)object, string2);
                    } else {
                        mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray3, resultSet);
                    }
                    object3 = DataDescription.create(resultSet, this.universe, (String)object, string2, mappingNameBindInfoArray);
                    JDynamicQuery jDynamicQuery = (JDynamicQuery)jRawDataQuery;
                    jDynamicQuery.setDataDescription((DataDescription)object3);
                    jDynamicQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "isBurstingRsd(): " + this.isBurstingRsd() + " isRsd(): " + this.isRsd());
                        JRLog.trace(6, "trace rsd query... resetQuery, rawDataId: " + jRawDataQuery.getRawDataId() + " rawDataQuery: " + jRawDataQuery + " resultSet: " + resultSet);
                        JRLog.trace(6, "reset dynamic query(RSD/BurstingRs), raw data query id: " + jRawDataQuery.getRawDataId());
                    }
                } else {
                    if (this.getType() == 3) {
                        Tools.logTrace(6, "goto detail engine, create dynamic query.");
                        DynamicQueryInfo dynamicQueryInfo = this.getUsedDynamicQueryInfo((String)object);
                        ResultSet resultSet = dynamicQueryInfo.getResultSet();
                        if (resultSet == null) {
                            throw new JRScheduleException(220011, new String[]{string}, null);
                        }
                        try {
                            resultSet.beforeFirst();
                        }
                        catch (SQLException sQLException) {
                            throw new JRScheduleException(220011, new String[]{string}, sQLException);
                        }
                    }
                    String string3 = this.rptSetCenter.getDataDriver(string);
                    if (string3 == null || string3.length() == 0 || string3.equals("CatalogQuery")) {
                        Tools.logTrace(6, "get data driver from center is null.");
                        string3 = ((JetRptDataSet)object2).dataDriver.get();
                    }
                    if (string3 != null && string3.length() > 0 && !string3.equals("CatalogQuery")) {
                        String[] stringArray4;
                        Tools.logTrace(6, "data driver is not null.");
                        String string4 = null;
                        try {
                            string4 = this.beforeFirst(string3);
                        }
                        catch (UDSDriverFormatException uDSDriverFormatException) {
                            throw new JRScheduleException(220053, new String[]{uDSDriverFormatException.getMessage()}, uDSDriverFormatException);
                        }
                        Tools.logTrace(6, "reset raw data query based on cached query result set. url: " + string3 + " file: " + string4);
                        ResultSet resultSet = CachedQueryResult.loadResult(string4);
                        String[][] stringArray5 = this.applyNLSorDynamicStyle(resultSet);
                        MappingNameBindInfo[] mappingNameBindInfoArray = null;
                        if (stringArray5 == null) {
                            stringArray4 = this.rptSetCenter.getAllMappingFields(dataSetCenter.getDataSetName());
                            mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(resultSet, stringArray4, this.universe, (String)object, string2);
                        } else {
                            mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray5, resultSet);
                        }
                        stringArray4 = (JDynamicQuery)jRawDataQuery;
                        DataDescription dataDescription = DataDescription.create(resultSet, this.universe, (String)object, string2, mappingNameBindInfoArray);
                        stringArray4.setDataDescription(dataDescription);
                        stringArray4.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
                        Tools.logTrace(6, "reset dynamic query(ResultSet), raw data query id: " + jRawDataQuery.getRawDataId());
                    } else {
                        int n = ((JetRptDataSet)object2).getMappingListSrc();
                        switch (n) {
                            case 1: {
                                DynamicQueryInfo dynamicQueryInfo = this.getUsedDynamicQueryInfo((String)object);
                                RawDataQueryOption rawDataQueryOption = this.genRawDataQueryOption(dataSetCenter, bl);
                                if (dynamicQueryInfo == null || dynamicQueryInfo.getQueryType() == -1) {
                                    Tools.logTrace(6, "reset data source query, raw data query id: " + jRawDataQuery.getRawDataId());
                                } else {
                                    JetUQueriable jetUQueriable = this.universe.getQueriableByResourceName((String)object, string2);
                                    if (!(dynamicQueryInfo.getQueryType() != 4 && dynamicQueryInfo.getQueryType() != 5 || UniverseUtil.supportUserConnection(jetUQueriable))) {
                                        Tools.logTrace(6, "dynamic query info with uds");
                                        Tools.logTrace(6, "reset data source query, raw data query id: " + jRawDataQuery.getRawDataId());
                                    } else {
                                        Tools.logTrace(6, "dynamic query info");
                                        Tools.logTrace(6, "reset dynamic query, raw data query id: " + jRawDataQuery.getRawDataId());
                                        rawDataQueryOption.setUseFetchSupportInfo(dynamicQueryInfo.isFetchSupportInfo());
                                    }
                                }
                                jRawDataQuery.setOption(rawDataQueryOption);
                                break;
                            }
                            case 4: {
                                jRawDataQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
                                Tools.logTrace(6, "reset on demand query, raw data query id: " + jRawDataQuery.getRawDataId());
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                    }
                }
            } else if (dataSetCenter.hasConstantGlobalFormula()) {
                jRawDataQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
            }
            object2 = jRawDataQuery.getFilters();
            object = ReportTools.getAndExpression((IExpression)object2, iBooleanExpression);
            jRawDataQuery.setFilters((IExpression)object);
        }
        catch (VersionException versionException) {
            throw new JRScheduleException(220024, (Throwable)versionException);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(220024, (Throwable)dSException);
        }
        catch (SQLException sQLException) {
            throw new JRScheduleException(220024, (Throwable)sQLException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException(220024, (Throwable)conditionException);
        }
        Tools.logTrace(6, "End of JRptSetEngine.resetRawDataQuery().");
    }

    private void ThreadException(String string, Hashtable hashtable) throws JRScheduleException {
        if (this.getReportSetCenter().getDataSetCenter(string) == null) {
            throw new JRSInvalidParameterException(220022, new String[]{string}, null);
        }
        if (!hashtable.containsKey(JAVA_FORMULA)) {
            throw new JRSInvalidParameterException(220023);
        }
        if (!hashtable.containsKey(IS_FAST_PASS)) {
            throw new JRSInvalidParameterException(220023);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private JRawDataQuery UNKNOWN(JDataEngine var1_1, int var2_2, DataSetCenter var3_3, boolean var4_4) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.genRawDataQuery()..., rawDataId: " + var2_2 + " dataSetName: " + var3_3.getDataSetName() + "useDataBlock: " + var4_4);
        }
        var5_5 = var3_3.getDataSetName();
        var6_6 = this.rptSet.getDataSet(var5_5);
        var7_7 = var6_6.getDataSourceName();
        var8_8 = var6_6.getQueryName();
        var9_9 = null;
        var3_3.setRawDataListener(new DataSetListener());
        var10_10 = null;
        if (var3_3.hasDbFieldOrPass1Formula()) {
            if (this.isBursting() && var4_4) {
                var11_11 = var3_3.getDataBlock();
                try {
                    var12_18 = var11_11.createResultSet();
                    var9_9 = this.addRefreshListener(var1_1, var2_2, var3_3, (ResultSet)var12_18, this.asList((ResultSet)var12_18, var3_3), false, true);
                    Tools.logTrace(6, "create dynamic query(bursting), raw data query id: " + var2_2);
                }
                catch (DSException var12_19) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var12_19);
                }
                catch (SQLException var13_23) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var13_23);
                }
            }
            if (this.isBurstingRsd() || this.isRsd() && var3_3.getRsdResultSet() != null) {
                try {
                    var11_12 = null;
                    var12_18 = null;
                    if (this.isBurstingRsd()) {
                        var13_24 = this.getReportSetEnv().getResultSetProvidor(var5_5);
                        var11_12 = var13_24.getResultSet();
                        var12_18 = var13_24.getBindInfo();
                    } else {
                        var11_12 = var3_3.getRsdResultSet().getResultSet();
                        var12_18 = var3_3.getBindInfo();
                    }
                    var9_9 = this.afterInit(var1_1, var2_2, var3_3, var11_12, (String[][])var12_18, false);
                    if (!JRLog.isTrace(6)) ** GOTO lbl153
                    JRLog.trace(6, "isBurstingRsd(): " + this.isBurstingRsd() + " isRsd(): " + this.isRsd());
                    JRLog.trace(6, "bindInfo: " + Tools.toString(var12_18));
                    JRLog.trace(6, "trace rsd query... createQuery, rawDataId: " + var2_2 + " rawDataQuery: " + var9_9 + " resultSet: " + var11_12);
                    JRLog.trace(6, "create dynamic query(RSD|BurstingRsd), raw data query id: " + var2_2);
                }
                catch (DSException var11_13) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var11_13);
                }
                catch (SQLException var12_20) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var12_20);
                }
                catch (VersionException var13_25) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var13_25);
                }
            } else {
                if (this.getType() == 3) {
                    Tools.logTrace(6, "goto detail engine, create dynamic query.");
                    var11_14 = this.getUsedDynamicQueryInfo(var7_7);
                    var12_18 = var11_14.getResultSet();
                    if (var12_18 == null) {
                        throw new JRScheduleException(220011, new String[]{var5_5}, null);
                    }
                    try {
                        var12_18.beforeFirst();
                        var9_9 = this.afterInit(var1_1, var2_2, var3_3, (ResultSet)var12_18, this.applyNLSorDynamicStyle((ResultSet)var12_18), false);
                    }
                    catch (DSException var13_26) {
                        throw new JRScheduleException(220011, new String[]{var5_5}, var13_26);
                    }
                    catch (SQLException var14_28) {
                        throw new JRScheduleException(220011, new String[]{var5_5}, var14_28);
                    }
                }
                var11_15 = var6_6.getMappingListSrc();
                var12_18 = null;
                var13_24 = var3_3.getSecContainer();
                if (var13_24.getCategory() != 0 && !var13_24.isNoRecordForSecurity()) {
                    try {
                        var12_18 = var13_24.getIExpressionForRecord(this.universe, var7_7, var8_8);
                    }
                    catch (JRScheduleException var14_29) {
                        JRLog.error(2, var14_29);
                    }
                    catch (ConditionException var15_33) {
                        JRLog.error(2, var15_33);
                    }
                }
                if ((var14_30 = this.rptSetCenter.getDataDriver(var5_5)) == null || var14_30.length() == 0 || var14_30.equals("CatalogQuery")) {
                    Tools.logTrace(6, "get data driver from center is null.");
                    var14_30 = var6_6.dataDriver.get();
                }
                if (var14_30 != null && var14_30.length() > 0 && !var14_30.equals("CatalogQuery")) {
                    Tools.logTrace(6, "data driver is not null.");
                    var15_34 = null;
                    try {
                        var15_34 = this.beforeFirst(var14_30);
                    }
                    catch (UDSDriverFormatException var16_36) {
                        throw new JRScheduleException(220053, new String[]{var16_36.getMessage()}, var16_36);
                    }
                    JRLog.trace(6, "generate dynamic query based on cached query result set. url: " + var14_30 + " file: " + (String)var15_34);
                    try {
                        var16_37 = CachedQueryResult.loadResult((String)var15_34);
                        var9_9 = this.afterInit(var1_1, var2_2, var3_3, (ResultSet)var16_37, this.applyNLSorDynamicStyle((ResultSet)var16_37), false);
                        Tools.logTrace(6, "create dynamic query(ResultSet), raw data query id: " + var9_9.getRawDataId());
                    }
                    catch (DSException var16_38) {
                        throw new JRScheduleException(220011, new String[]{var5_5}, var16_38);
                    }
                    catch (SQLException var17_41) {
                        throw new JRScheduleException(220011, new String[]{var5_5}, var17_41);
                    }
                }
                var15_34 = null;
                switch (var11_15) {
                    case 1: {
                        var15_34 = this.getUsedDynamicQueryInfo(var7_7);
                        try {
                            if (var15_34 == null || var15_34.getQueryType() == -1) {
                                Tools.logTrace(6, "no dynamic query info, create datasource query.");
                                var9_9 = this.addJavaFormula(var1_1, var2_2, var3_3, false);
                                var16_37 = this.getStreamFactory(var7_7);
                                if (var16_37 != null) {
                                    ((JDataSourceQuery)var9_9).setInputStreamFactory((InputStreamFactory)var16_37);
                                }
                            } else {
                                var16_37 = this.universe.getQueriableByResourceName(var7_7, var8_8);
                                if (!(var15_34.getQueryType() != 4 && var15_34.getQueryType() != 5 || UniverseUtil.supportUserConnection((JetUQueriable)var16_37))) {
                                    Tools.logTrace(6, "don't support connection and url, ignore connection or url and create data source query.");
                                    Tools.logTrace(6, "dynamic query type: " + var15_34.getQueryType());
                                    var9_9 = this.addJavaFormula(var1_1, var2_2, var3_3, false);
                                    var17_42 /* !! */  = this.getStreamFactory(var7_7);
                                    if (var17_42 /* !! */  != null) {
                                        ((JDataSourceQuery)var9_9).setInputStreamFactory((InputStreamFactory)var17_42 /* !! */ );
                                    }
                                } else {
                                    Tools.logTrace(6, "dynamic query info, create dynamic query.");
                                    var9_9 = this.addParameterValue(var1_1, var2_2, var3_3, (DynamicQueryInfo)var15_34, false);
                                }
                            }
                            Tools.logTrace(6, "create raw data query, raw data query id: " + var9_9.getRawDataId());
                            break;
                        }
                        catch (DSException var16_39) {
                            throw new JRScheduleException(220011, new String[]{var5_5}, var16_39);
                        }
                        catch (SQLException var17_43) {
                            throw new JRScheduleException(220011, new String[]{var5_5}, var17_43);
                        }
                    }
                    case 4: {
                        var15_34 = this.getUsedDynamicQueryInfo(var7_7);
                        try {
                            var9_9 = this.append(var1_1, var2_2, var3_3, (DynamicQueryInfo)var15_34, false);
                            var16_37 = this.getStreamFactory(var7_7);
                            if (var16_37 != null) {
                                ((JDemandQuery)var9_9).setInputStreamFactory((InputStreamFactory)var16_37);
                            }
                            var17_42 /* !! */  = this.rptSetCenter.getDbFieldFormulaMappingFields(var5_5);
                            var18_45 = ((JetRptOnDemandDataSet)var6_6).getJoinNames().toArray(new String[0]);
                            var19_46 = DataTools.getJoins(this.universe, var7_7, var8_8, var17_42 /* !! */ , var18_45);
                            ((JDemandQuery)var9_9).setJoinList(var19_46);
                            Tools.logTrace(6, "create on demond query, raw data query id: " + var9_9.getRawDataId());
                            Tools.logTrace(6, "joinNames: " + Tools.toString(var19_46));
                            break;
                        }
                        catch (DSException var16_40) {
                            throw new JRScheduleException(220011, new String[]{var5_5}, var16_40);
                        }
                        catch (BLException var17_44) {
                            throw new JRScheduleException(220011, new String[]{var5_5}, var17_44);
                        }
                    }
                    case 3: {
                        Tools.logTrace(6, "hds data set need not to do first interaction, dataSetName: " + var3_3.getDataSetName());
                        return null;
                    }
                    default: {
                        throw new JRSInvalidTemplateException(220003);
                    }
                }
                try {
                    Tools.logTrace(6, "Query: " + var9_9.getQueryId() + " sec expression: " + var12_18);
                    if (!this.isBursting() || !var4_4) {
                        var9_9.setFilters((IExpression)var12_18);
                    }
                    var9_9.setSecurityContext(this.secCxt);
                }
                catch (DSException var15_35) {
                    throw new JRScheduleException(220011, new String[]{var5_5}, var15_35);
                }
            }
lbl153:
            // 5 sources

            var10_10 = this.rptSetCenter.getDbFieldFormulaMappingFields(var5_5);
        } else if (var3_3.hasConstantGlobalFormula()) {
            try {
                var9_9 = this.afterInitParameter(var1_1, var2_2, var3_3, false);
            }
            catch (DSException var11_16) {
                throw new JRScheduleException(220011, new String[]{var5_5}, var11_16);
            }
            var10_10 = var3_3.getConstantGlobalFormulaNames();
        } else {
            Tools.logTrace(6, "no db fields and formula. error.");
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "rptSetName: " + this.rptSetCenter.getRptSetName());
            JRLog.trace(6, "rawDataQueryId: " + var2_2 + " query: " + var9_9);
            JRLog.trace(6, "dataSourceName: " + var7_7 + " queryName: " + var8_8);
            JRLog.trace(6, "raw data query mapping name: " + Tools.toString(var10_10));
        }
        try {
            var9_9.setMappingNames(var10_10);
            var11_11 = this.rptSetCenter.getJavaFormula(var7_7);
            var12_18 = new ArrayList<E>();
            this.__sys__USERNAME((List)var12_18, var5_5);
            this.addAll((List)var12_18, var5_5);
            var13_24 = new JavaFormulaContainer();
            var13_24.addJavaFormula((ExecutableJavaFormula)var11_11);
            if (!var12_18.isEmpty()) {
                var14_31 = 0;
                while (var14_31 < var12_18.size()) {
                    var13_24.addJavaFormula((ExecutableJavaFormula)var12_18.get(var14_31));
                    ++var14_31;
                }
            }
            this.rptSetCenter.prepareJavaFormula((JavaFormula)var13_24);
            var9_9.setJavaFormula((JavaFormula)var13_24);
            Tools.logTrace(6, "set java formula: " + var11_11 + " to raw data query, id: " + var2_2);
            var9_9.setBatchRun(this.isBatchRun);
            var14_32 = this.addDataContainer(var5_5, null);
            var9_9.setParameterValues(var14_32);
            var15_34 = this.getSpecialFields();
            var3_3.setSpecialFields((SpecialFields)var15_34);
            var9_9.setSpecialFields((SpecialFields)var15_34);
            var16_37 = this.add(var3_3);
            var9_9.setReportFormulas((Hashtable)var16_37);
        }
        catch (DSException var11_17) {
            throw new JRScheduleException(220011, new String[]{var5_5}, var11_17);
        }
        if (!this.isBursting() || !var4_4) {
            var11_11 = null;
            try {
                var12_18 = (IBooleanExpression)var6_6.getPreIExpression(true);
                var13_24 = (IBooleanExpression)var6_6.getIExpression(true);
                Tools.logTrace(6, "data set filter: " + var13_24);
                var11_11 = (IBooleanExpression)ReportTools.getAndExpression((IExpression)var13_24, (IBooleanExpression)var12_18);
            }
            catch (ConditionException var12_21) {
                throw new JRScheduleException(220011, new String[]{var5_5}, var12_21);
            }
            try {
                var12_18 = (IBooleanExpression)var9_9.getFilters();
                Tools.logTrace(6, "record security filter: " + var12_18);
                if (var12_18 != null) {
                    var11_11 = ReportTools.getAndExpression((IExpression)var11_11, (IBooleanExpression)var12_18);
                }
                Tools.logTrace(6, "set raw data query filter, id: " + var9_9.getQueryId() + " expression: " + var11_11);
                var9_9.setFilters((IExpression)var11_11);
            }
            catch (DSException var12_22) {
                throw new JRScheduleException(220012, new String[]{var3_3.getDataSetName()}, var12_22);
            }
            catch (ConditionException var13_27) {
                throw new JRScheduleException(220012, new String[]{var3_3.getDataSetName()}, var13_27);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.genRawDataQuery(), return: " + var9_9);
        }
        return var9_9;
    }

    private void __sys__USERNAME(List list, String string) {
        JetRptDataSet jetRptDataSet = this.getReportSet().getDataSet(string);
        if (jetRptDataSet == null) {
            return;
        }
        String string2 = jetRptDataSet.getDataSourceName();
        String[] stringArray = this.getReportNames();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            int n2 = 0;
            while (stringArray2 != null && n2 < stringArray2.length) {
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[n2]);
                JavaFormula javaFormula = jReportEngine.getCFJavaFormula(string2);
                if (javaFormula != null) {
                    list.add(javaFormula);
                }
                ++n2;
            }
            ++n;
        }
    }

    private Hashtable add(DataSetCenter dataSetCenter) {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = dataSetCenter.getCFFormulas();
        Hashtable hashtable3 = dataSetCenter.getFlyFormulas();
        hashtable.putAll(hashtable2);
        hashtable.putAll(hashtable3);
        return hashtable;
    }

    private void addAll(List list, String string) {
        JetRptDataSet jetRptDataSet = this.getReportSet().getDataSet(string);
        if (jetRptDataSet == null) {
            return;
        }
        String string2 = jetRptDataSet.getDataSourceName();
        String string3 = jetRptDataSet.getQueryName();
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        DataSetLogic dataSetLogic = ObjectLogicFactory.getDataSetLogic();
        JBusinessLogic jBusinessLogic = dataSetLogic.getBusinessLogic(jetRptDataSet);
        if (jBusinessLogic == null) {
            return;
        }
        String string4 = jBusinessLogic.getName();
        String[] stringArray = this.getReportNames();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            int n2 = 0;
            while (stringArray2 != null && n2 < stringArray2.length) {
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[n2]);
                JavaFormula javaFormula = jReportEngine.getFlyJavaFormula(string2, string3, string4);
                if (javaFormula != null) {
                    list.add(javaFormula);
                }
                ++n2;
            }
            ++n;
        }
    }

    public String[] getMappingNamesInRawQuery(String string) throws JRScheduleException {
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        if (dataSetCenter == null) {
            throw new JRScheduleException();
        }
        String[] stringArray = null;
        if (dataSetCenter.hasDbFieldOrPass1Formula()) {
            stringArray = this.rptSetCenter.getDbFieldFormulaMappingFields(string);
        } else if (dataSetCenter.hasConstantGlobalFormula()) {
            stringArray = dataSetCenter.getConstantGlobalFormulaNames();
        } else {
            Tools.logTrace(6, "no any mapping name used in data set " + string);
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private ParameterValueList addDataContainer(String string, Hashtable hashtable) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getParameterValueList()..., dataSetName: " + string + "params: " + hashtable);
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        Hashtable hashtable2 = this.getParamsBuffer();
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            Iterator iterator = hashtable2.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ParamDesc paramDesc = this.addElement(string2, hashtable, hashtable2);
                Tools.logTrace(6, "add to parameter list: " + paramDesc);
                parameterValueList.addParameterValue(paramDesc);
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.getParameterValueList().");
        return parameterValueList;
    }

    private ParamDesc addElement(String string, Hashtable hashtable, Hashtable hashtable2) {
        ParamDesc paramDesc = null;
        if (hashtable != null) {
            paramDesc = (ParamDesc)hashtable.get(string);
        }
        if (paramDesc == null) {
            paramDesc = (ParamDesc)hashtable2.get(string);
        }
        if (paramDesc == null) {
            paramDesc = UniverseTools.getParamDesc(string, this.getUniverse());
            this.getParameterManager().getParamBuff().put(string, paramDesc);
        }
        return paramDesc;
    }

    protected int getRawDataId() {
        return this.rptSetCenter.getSerialNo();
    }

    public void initRawDataQuery(DataSetCenter dataSetCenter) throws JRScheduleException {
        String string;
        JetRptDataSet jetRptDataSet;
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.initRawDataQuery()..., dataSetName: " + dataSetCenter.getDataSetName());
        }
        if ((jetRptDataSet = this.rptSet.getDataSet(string = dataSetCenter.getDataSetName())).getMappingListSrc() == 3) {
            Tools.logTrace(6, "data set is hds.");
            return;
        }
        if (!dataSetCenter.needInitQuery()) {
            this.initCubeQuery(dataSetCenter);
            Tools.logTrace(6, "return needInitQuery: " + dataSetCenter.needInitQuery());
            return;
        }
        this.addIndexOfParentIndex(dataSetCenter);
        if (!dataSetCenter.hasData()) {
            Tools.logTrace(6, "data set has not data, dataSetName: " + dataSetCenter.getDataSetName());
            return;
        }
        if (!dataSetCenter.hasDbFieldOrPass1Formula() && !dataSetCenter.hasConstantGlobalFormula()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no db fields and formula. ");
                JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
            }
            return;
        }
        int n = this.getRawDataId();
        JRawDataQuery jRawDataQuery = this.UNKNOWN(this.dataEngine, n, dataSetCenter, true);
        if (jRawDataQuery == null) {
            return;
        }
        dataSetCenter.setRawDataId(n);
        if (dataSetCenter.getRawDataQuery() != null) {
            try {
                Tools.logTrace(6, "init raw data query, close raw data query, id: " + dataSetCenter.getRawDataQuery().getQueryId());
                dataSetCenter.getRawDataQuery().close();
            }
            catch (DSException dSException) {
                JRLog.error(3, dSException);
            }
        }
        dataSetCenter.setRawDataQuery(jRawDataQuery);
        dataSetCenter.setNeedInitQuery(false);
        dataSetCenter.setNeedRefresh(true);
        this.initCubeQuery(dataSetCenter);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init raw data query, cost time(include init cube query): " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.initRawDataQuery()...");
        }
    }

    public void initCubeQuery(DataSetCenter dataSetCenter) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.initCubeQuery()..., dataSetName: " + dataSetCenter.getDataSetName());
        }
        if (!dataSetCenter.needInitCubeQuery()) {
            Tools.logTrace(6, "don't need init cube query, return!");
            Tools.logTrace(6, "End of JRptSetEngine.initCubeQuery()...");
            return;
        }
        this.addIndexOfParentIndex(dataSetCenter);
        CubeModel cubeModel = dataSetCenter.getCubeModel();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "cube model: " + cubeModel);
        }
        if (cubeModel != null && cubeModel.getDimensions() != null && cubeModel.getDimensions().length > 0) {
            Tools.logTrace(6, "create cube., ");
            int n = this.getRawDataId();
            JCubeQuery jCubeQuery = null;
            try {
                jCubeQuery = CubeQueryBuilder.buildCubeQuery(this.dataEngine, dataSetCenter.getRawDataId(), n, dataSetCenter.getCubeModel());
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220028, new String[]{dataSetCenter.getDataSetName()}, dSException);
            }
            dataSetCenter.setCubeQueryId(n);
            dataSetCenter.setCubeQuery(jCubeQuery);
            Tools.logTrace(6, "generated cube query, id: " + n);
        } else {
            Tools.logTrace(6, "don't create cube., ");
        }
        dataSetCenter.setNeedInitCubeQuery(false);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init cube query, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.initCubeQuery().");
        }
    }

    private void addIndexOfParentIndex(DataSetCenter dataSetCenter) {
        if (dataSetCenter.getCubeQuery() != null) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "close cube query, id: " + dataSetCenter.getCubeQuery().getQueryId());
                }
                dataSetCenter.getCubeQuery().close();
            }
            catch (DSException dSException) {
                JRLog.error(3, dSException);
            }
            dataSetCenter.setCubeQuery(null);
        }
    }

    private JDataSourceQuery addJavaFormula(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, boolean bl) throws DSException {
        Tools.logTrace(6, "JRptSetEngine.genDataSourceQuery()...");
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        JDataSourceQuery jDataSourceQuery = jDataEngine.createDataSourceQuery(n);
        jDataSourceQuery.setCatalog(this.universe);
        jDataSourceQuery.setDataSourceName(((JetRptQueryDataSet)jetRptDataSet).getDsName());
        jDataSourceQuery.setQueryName(jetRptDataSet.getQueryName());
        jDataSourceQuery.setPass1Formulas(this.rptSetCenter.getConstantPass1Formulas(dataSetCenter.getDataSetName()));
        String string = this.canApplyNLS(dataSetCenter);
        String string2 = dataSetCenter.getSecContainer().getWhereStringForAcl();
        Tools.logTrace(6, "set where string: " + string);
        jDataSourceQuery.setWherePortion(string);
        Tools.logTrace(6, "set security where string: " + string2);
        jDataSourceQuery.setPolicy(string2);
        jDataSourceQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
        Tools.logTrace(6, "End of JRptSetEngine.genDataSourceQuery().");
        return jDataSourceQuery;
    }

    private JDynamicQuery addParameterValue(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, DynamicQueryInfo dynamicQueryInfo, boolean bl) throws SQLException, DSException, JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.genDynamicQuery()..., DynamicQueryInfo");
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string = jetRptDataSet.getDataSourceName();
        String string2 = jetRptDataSet.getQueryName();
        String string3 = dataSetCenter.getDataSetName();
        JDynamicQuery jDynamicQuery = jDataEngine.createDynamicQuery(n);
        jDynamicQuery.setPass1Formulas(this.rptSetCenter.getConstantPass1Formulas(string3));
        String[] stringArray = this.rptSetCenter.getAllMappingFields(string3);
        String string4 = this.canApplyNLS(dataSetCenter);
        String string5 = dataSetCenter.getSecContainer().getWhereStringForAcl();
        DataDescription dataDescription = DataTools.genDataDescription(dynamicQueryInfo, this.universe, string, string2, stringArray, string4, null, string5);
        jDynamicQuery.setDataDescription(dataDescription);
        RawDataQueryOption rawDataQueryOption = this.genRawDataQueryOption(dataSetCenter, bl);
        rawDataQueryOption.setUseFetchSupportInfo(dynamicQueryInfo.isFetchSupportInfo());
        jDynamicQuery.setOption(rawDataQueryOption);
        Tools.logTrace(6, "end of JRptSetEngine.genDynamicQuery()");
        return jDynamicQuery;
    }

    private JDynamicQuery addRefreshListener(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, ResultSet resultSet, String[][] stringArray, boolean bl, boolean bl2) throws DSException, SQLException, JRScheduleException {
        Object object;
        MappingNameBindInfo[] mappingNameBindInfoArray;
        Object object2;
        Tools.logTrace(6, "JRptSetEngine.genDynamicQuery()..., resultSet");
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string = jetRptDataSet.getDataSourceName();
        String string2 = jetRptDataSet.getQueryName();
        if (!bl2 && DataTools.hasWhereStr((String)(object2 = this.canApplyNLS(dataSetCenter)), null, (String)(mappingNameBindInfoArray = dataSetCenter.getSecContainer().getWhereStringForAcl()))) {
            throw new JRScheduleException(220030);
        }
        object2 = jDataEngine.createDynamicQuery(n);
        mappingNameBindInfoArray = null;
        if (stringArray == null) {
            object = this.rptSetCenter.getAllMappingFields(dataSetCenter.getDataSetName());
            mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(resultSet, object, this.universe, string, string2);
        } else {
            mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray, resultSet);
        }
        object = DataDescription.create(resultSet, this.universe, string, string2, mappingNameBindInfoArray);
        object2.setDataDescription((DataDescription)object);
        RawDataQueryOption rawDataQueryOption = this.genRawDataQueryOption(dataSetCenter, bl);
        object2.setOption(rawDataQueryOption);
        object2.setPass1Formulas(this.rptSetCenter.getConstantPass1Formulas(dataSetCenter.getDataSetName()));
        return object2;
    }

    private JDynamicQuery afterInit(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, ResultSet resultSet, String[][] stringArray, boolean bl) throws DSException, SQLException, JRScheduleException {
        return this.addRefreshListener(jDataEngine, n, dataSetCenter, resultSet, stringArray, bl, false);
    }

    private JDynamicQuery afterInitParameter(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, boolean bl) throws DSException, JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.genDynamicQueryOfConstantFormula()...");
        String string = this.canApplyNLS(dataSetCenter);
        String string2 = dataSetCenter.getSecContainer().getWhereStringForAcl();
        if (DataTools.hasWhereStr(string, null, string2)) {
            throw new JRScheduleException(220033);
        }
        JDynamicQuery jDynamicQuery = jDataEngine.createDynamicQuery(n);
        Hashtable hashtable = this.add(dataSetCenter);
        JetRptFormula[] jetRptFormulaArray = dataSetCenter.getConstantGlobalFormulas(this.universe, hashtable);
        DataDescription dataDescription = DataDescription.create(jetRptFormulaArray);
        jDynamicQuery.setDataDescription(dataDescription);
        RawDataQueryOption rawDataQueryOption = this.genRawDataQueryOption(dataSetCenter, bl);
        jDynamicQuery.setOption(rawDataQueryOption);
        return jDynamicQuery;
    }

    private JDemandQuery append(JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, DynamicQueryInfo dynamicQueryInfo, boolean bl) throws DSException {
        Tools.logTrace(6, "JRptSetEngine.genDemandQuery()...");
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string = jetRptDataSet.getDataSourceName();
        String string2 = jetRptDataSet.getQueryName();
        JDemandQuery jDemandQuery = jDataEngine.createDemandQuery(n);
        jDemandQuery.setCatalog(this.universe);
        jDemandQuery.setDataSourceName(string);
        jDemandQuery.setQueryName(string2);
        jDemandQuery.setOption(this.genRawDataQueryOption(dataSetCenter, bl));
        if (dynamicQueryInfo != null) {
            DataDescription dataDescription = null;
            switch (dynamicQueryInfo.getQueryType()) {
                case 4: {
                    dataDescription = DataTools.genDataDescription(dynamicQueryInfo.getConnection());
                    break;
                }
                case 5: {
                    dataDescription = DataTools.genDataDescription(this.getUniverse(), string, dynamicQueryInfo.getJdbcDriver(), dynamicQueryInfo.getUrl(), dynamicQueryInfo.getUserId(), dynamicQueryInfo.getPassword());
                    break;
                }
            }
            if (dataDescription != null) {
                jDemandQuery.setDataDescription(dataDescription);
            }
        }
        return jDemandQuery;
    }

    private String[][] applyNLSorDynamicStyle(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        int n = 0;
        String[][] stringArray = null;
        resultSetMetaData = resultSet.getMetaData();
        n = resultSetMetaData.getColumnCount();
        stringArray = new String[2][n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[0][n2] = resultSetMetaData.getColumnName(n2 + 1).toUpperCase();
            stringArray[1][n2] = stringArray[0][n2];
            ++n2;
        }
        return stringArray;
    }

    private String[][] asList(ResultSet resultSet, DataSetCenter dataSetCenter) throws SQLException {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getBurstingBindInfo()...");
        }
        JetUUniverse jetUUniverse = this.getUniverse();
        String string = dataSetCenter.getDataSet().getDataSourceName();
        ResultSetMetaData resultSetMetaData = null;
        int n = 0;
        String[][] stringArray = null;
        resultSetMetaData = resultSet.getMetaData();
        n = resultSetMetaData.getColumnCount();
        Hashtable hashtable = new Hashtable();
        Hashtable[] hashtableArray = new Hashtable[]{dataSetCenter.getCFFormulas(), dataSetCenter.getFlyFormulas()};
        int n2 = 0;
        while (n2 < hashtableArray.length) {
            if (hashtableArray[n2] != null) {
                object = hashtableArray[n2].keySet().iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    hashtable.put(string2.toUpperCase(), hashtableArray[n2].get(string2));
                }
            }
            ++n2;
        }
        object = new ArrayList();
        int n3 = 0;
        while (n3 < n) {
            String string3 = resultSetMetaData.getColumnName(n3 + 1).toUpperCase();
            JetUFormula jetUFormula = this.asyncronizedSetPriority(string3, string, hashtable);
            if (jetUFormula == null || !this.backupDataStatus(jetUFormula, string, hashtable)) {
                ((ArrayList)object).add(string3);
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, "column " + string3 + " is referenced to bursting build in function, don't set to bind info.");
            }
            ++n3;
        }
        stringArray = new String[2][((ArrayList)object).size()];
        int n4 = 0;
        while (n4 < ((ArrayList)object).size()) {
            stringArray[0][n4] = (String)((ArrayList)object).get(n4);
            stringArray[1][n4] = stringArray[0][n4];
            ++n4;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getBurstingBindInfo(), return: " + Tools.toString(stringArray));
        }
        return stringArray;
    }

    private JetUFormula asyncronizedSetPriority(String string, String string2, Hashtable hashtable) {
        JetUUniverse jetUUniverse = this.getUniverse();
        JetUFormula jetUFormula = jetUUniverse.getDatabase(string2).getFormulaByResourceName(string);
        if (jetUFormula == null && hashtable != null && hashtable.containsKey(string)) {
            jetUFormula = (JetUFormula)hashtable.get(string);
        }
        return jetUFormula;
    }

    private boolean backupDataStatus(JetUFormula jetUFormula, String string, Hashtable hashtable) {
        String string2 = "CURRENTBURSTINGSCHEMA";
        String string3 = "ISRUNBURSTING";
        FormulaInfo formulaInfo = jetUFormula.getFormulaInfo();
        Vector vector = formulaInfo.getRefBuildInFunctions();
        if (vector.contains(string2) || vector.contains(string3)) {
            return true;
        }
        Vector vector2 = jetUFormula.getRefFormuFld();
        if (vector2 != null && !vector2.isEmpty()) {
            int n = 0;
            while (n < vector2.size()) {
                String string4 = ((String)vector2.get(n)).toUpperCase();
                JetUFormula jetUFormula2 = this.asyncronizedSetPriority(string4, string, hashtable);
                if (this.backupDataStatus(jetUFormula2, string, hashtable)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String beforeFirst(String string) throws UDSDriverFormatException {
        UDSDriver uDSDriver = null;
        uDSDriver = new UDSDriver(string);
        String[] stringArray = uDSDriver.getParams();
        return stringArray[stringArray.length - 1];
    }

    private boolean beforeRun(JRecordSecurityContainer jRecordSecurityContainer) {
        return jRecordSecurityContainer != null && jRecordSecurityContainer.getCategory() != 0 && jRecordSecurityContainer.isNoRecordForSecurity();
    }

    private String booleanValue(DataSetCenter dataSetCenter) {
        String string;
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string2 = jetRptDataSet.getDataSourceName();
        String string3 = this.rptSetCenter.getWhereName(string2, string = jetRptDataSet.getQueryName());
        if (string3 == null || string3.trim().length() == 0) {
            string3 = this.rptSetCenter.getWhereName();
        }
        return string3;
    }

    private String buildCubeQuery(DataSetCenter dataSetCenter) {
        String string;
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string2 = jetRptDataSet.getDataSourceName();
        String string3 = this.rptSetCenter.getWherePortion(string2, string = jetRptDataSet.getQueryName());
        if (string3 == null || string3.trim().length() == 0) {
            string3 = this.rptSetCenter.getWherePortion();
        }
        return string3;
    }

    private String canApplyNLS(DataSetCenter dataSetCenter) {
        String string;
        String string2 = this.buildCubeQuery(dataSetCenter);
        if ((string2 == null || string2.trim().length() == 0) && (string = this.booleanValue(dataSetCenter)) != null) {
            string2 = this.universe.getWherePortion(string);
        }
        return string2;
    }

    public SpecialFields getSpecialFields() {
        SpecialFields specialFields = new SpecialFields();
        specialFields.setUserName(new DbChar(this.getUserName()));
        Date date = this.getSysVariable().getModifiedDate();
        specialFields.setModifiedDate(new DbDate(new java.sql.Date(date.getTime())));
        specialFields.setModifiedTime(new DbTime(new Time(date.getTime())));
        specialFields.setPrintDate(new DbDate(new java.sql.Date(date.getTime())));
        specialFields.setPrintTime(new DbTime(new Time(date.getTime())));
        return specialFields;
    }

    public int getEngineStatus(String string, String string2) {
        return 0;
    }

    public void runReport(Hashtable hashtable) {
    }

    public void setUniverse(JetUUniverse jetUUniverse) {
        this.universe = jetUUniverse;
    }

    public JetUUniverse getUniverse() {
        return this.universe;
    }

    public void setParamFile(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamFile()..., paramFile: " + string);
        }
        this.afterInitParameter = string;
    }

    public String getParamFile() {
        return this.afterInitParameter;
    }

    public void setParamValues(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamValues()..., paramValues: " + string);
        }
        this.append = string;
    }

    public String getParamValues() {
        return this.append;
    }

    public void setParamProperty(Properties properties) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamProperty()..., pParamValue: " + properties);
        }
        this.applyNLSorDynamicStyle = properties;
    }

    public Properties getParamProperty() {
        return this.applyNLSorDynamicStyle;
    }

    public Map getValidParamValues() {
        return this.booleanValue.getValidParamValues();
    }

    public Hashtable getParamsBuffer() {
        return this.booleanValue.getParamBuff();
    }

    public Hashtable getParamToSubRpt() {
        return this.booleanValue.getParamToSubRpt();
    }

    public Hashtable getSubRptAvlGrp() {
        return this.booleanValue.getSubRptAvlGrp();
    }

    public Hashtable getSubRptParmLAuto() {
        return this.booleanValue.getSubRptParmLAuto();
    }

    public Hashtable getSubRptImpParmVal() {
        return this.booleanValue.getSubRptImpParmVal();
    }

    public Vector getGroupParams() {
        return this.booleanValue.getGroupParams();
    }

    public Hashtable getSubRptParams() {
        return this.booleanValue.getSubRptParams();
    }

    public Hashtable getParamInSubSec() {
        return this.booleanValue.getParamInSubSec();
    }

    public Vector getSubRptReturnValues() {
        return this.booleanValue.getSubRptReturnValues();
    }

    public Vector getSubRptLinkParams() {
        return this.booleanValue.getSubRptLinkParams();
    }

    public JetRptReportSet getReportSet() {
        return this.rptSet;
    }

    public void setOnDemandReport(boolean bl) {
        this.canSummary = bl;
    }

    public boolean isOnDemandReport() {
        return this.canSummary;
    }

    public void setReportSet(JetRptReportSet jetRptReportSet) {
    }

    public boolean stop() {
        Tools.logTrace(6, "JRptSetEngine.stop()...");
        boolean bl = true;
        if (this.htReportEngine != null && !this.htReportEngine.isEmpty()) {
            this.closeAllRawDatas = true;
            int n = this.htReportEngine.size();
            String[] stringArray = new String[n];
            Vector[] vectorArray = new Vector[n];
            int n2 = 0;
            Enumeration enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vectorArray[n2] = new Vector();
                stringArray[n2] = string;
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
                String[] stringArray2 = jRSReportEngine.getViewNames();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    vectorArray[n2].addElement(stringArray2[n3]);
                    ++n3;
                }
                ++n2;
            }
            bl = this.stop(stringArray, vectorArray);
        }
        Tools.logTrace(6, "End of JRptSetEngine.stop().");
        return bl;
    }

    public boolean stop(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stop()..., rptName: " + string + " viewName: " + string2);
        }
        String[] stringArray = new String[]{string};
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        boolean bl = this.stop(stringArray, vectorArray);
        Tools.logTrace(6, "End of JRptSetEngine.stop().");
        return bl;
    }

    public boolean stop(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stop()..., rptName: " + Tools.toString(stringArray) + " viewName: " + Tools.toString(vectorArray));
        }
        if (!this.isRunning()) {
            Tools.logTrace(5, "report set engine is not running, skip it, return false!");
            return false;
        }
        if (this.isStopping()) {
            Tools.logTrace(5, "report set engine is stopping, skip it, return false!");
            return false;
        }
        Tools.logTrace(6, "internal set bStopping as true.");
        this.closeAllGroups = true;
        this.createViewEngine();
        this.cvIExpresstion(stringArray, vectorArray);
        HashMap hashMap = this.canSummary();
        if (hashMap == null || hashMap.isEmpty()) {
            return true;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Vector vector = (Vector)hashMap.get(string);
            if (vector == null || vector.isEmpty()) continue;
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                jRSReportEngine.stop(string2);
                ++n;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.stop(). return: true");
        return true;
    }

    private HashMap canSummary() {
        Tools.logTrace(6, "JRptSetEngine.getRealStopReports()...");
        if (this.deepDupWithName == null || this.deepDupWithName.isEmpty()) {
            Tools.logTrace(6, "no any report is running, can't stop any report.");
            return null;
        }
        if (this.denyAllColumns == null || this.denyAllColumns.isEmpty()) {
            Tools.logTrace(6, "no any report is stopping, can't stop any report.");
            return null;
        }
        Tools.logTrace(6, "running report: " + this.deepDupWithName + " stopping report: " + this.denyAllColumns);
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        Enumeration enumeration = this.denyAllColumns.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.deepDupWithName.containsKey(string)) continue;
            Vector vector = (Vector)((Vector)this.deepDupWithName.get(string)).clone();
            Vector vector2 = (Vector)this.denyAllColumns.get(string);
            Tools.logTrace(6, "running: " + vector + " stoping: " + vector2);
            vector.retainAll(vector2);
            hashMap.put(string, vector);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getRealStopReports(), return: " + hashMap);
        }
        return hashMap;
    }

    public void clear() {
        Object object;
        String[] stringArray;
        Tools.logTrace(6, "JRptSetEngine.clear()...");
        HashMap hashMap = this.canSummary();
        this.waitRunFinished(hashMap);
        if (hashMap != null && !hashMap.isEmpty()) {
            stringArray = hashMap.keySet().iterator();
            while (stringArray.hasNext()) {
                String string = (String)stringArray.next();
                object = (Vector)hashMap.get(string);
                if (object == null || ((Vector)object).isEmpty()) {
                    Tools.logTrace(6, "views is " + (object == null ? "null." : "empty."));
                    continue;
                }
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
                int n = 0;
                while (n < ((Vector)object).size()) {
                    String string2 = (String)((Vector)object).elementAt(n);
                    jRSReportEngine.clear(string2);
                    ++n;
                }
            }
        }
        if (this.closeAllRawDatas) {
            stringArray = this.rptSetCenter.getDataSetNames();
            int n = 0;
            while (n < stringArray.length) {
                object = this.rptSetCenter.getDataSetCenter(stringArray[n]);
                ((DataSetCenter)object).closeRawData();
                ++n;
            }
        }
        this.closeAllRawDatas = false;
        Tools.logTrace(6, "internal set bStopping as false.");
        this.closeAllGroups = false;
        Tools.logTrace(6, "End of JRptSetEngine.clear().");
    }

    public Hashtable getReportParams(Vector vector) {
        return null;
    }

    public Hashtable getReportSetParams() {
        return null;
    }

    public void prepareMappingFields() {
    }

    public void refreshReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.refreshReport()..., rptName: " + string + " viewName: " + string2);
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (string2 == null) {
            string2 = this.rptSetCenter.getReportCenter(string).getReport().getCurViewName();
        }
        JReportEngine jReportEngine = jRSReportEngine.getViewEngine(string2);
        jReportEngine.initRun();
        this.runReport(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.refreshReport()...");
    }

    public Hashtable getUseRptView(int n, String string) {
        return this.rptSetCenter.getUseRptView(n, string);
    }

    public Hashtable getUseRptView(String string) {
        return this.rptSetCenter.getUseRptView(string);
    }

    public JetRptReport getReport(String string) {
        return this.getReportEngine(string).getReport();
    }

    public Hashtable getReportViewNames() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.htReportEngine.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
            String[] stringArray = jRSReportEngine.getViewNames();
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < vector.size()) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            hashtable.put(string, vector);
        }
        return hashtable;
    }

    public void preinitMainEngine(boolean bl) throws EngingPreinitException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitMainEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = this.htReportEngine.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine != null) {
                vectorArray[n] = jRSReportEngine.I();
            }
            ++n;
        }
        this.preinitMainEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.preinitMainEngine()");
    }

    public void preinitMainEngine(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException {
        this.preinitMainEngine(stringArray, vectorArray, false);
    }

    public void preinitMainEngine(String[] stringArray, Vector[] vectorArray, boolean bl) throws EngingPreinitException {
        String[] stringArray2;
        int n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitMainEngine()..., rptNames = " + Tools.toString(stringArray) + " vRptViews = " + Tools.toString(vectorArray) + " forceInit: " + bl);
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl) {
            this.rptSetCenter.resetParameterInDataSetQuery();
            this.booleanValue.reset();
            n = 0;
            while (n < stringArray.length) {
                int n2 = 0;
                while (n2 < vectorArray[n].size()) {
                    stringArray2 = (String)vectorArray[n].elementAt(n2);
                    this.createDemandQuery(stringArray[n], (String)stringArray2);
                    ++n2;
                }
                ++n;
            }
        }
        n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            stringArray2 = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.preinitEngine(stringArray2, bl);
            jRSReportEngine.initRunEngine(stringArray2, bl);
            ++n;
        }
        Tools.logTrace(6, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitMainEngine()...");
    }

    public void preinitEngine(boolean bl) throws EngingPreinitException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = this.htReportEngine.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine != null) {
                vectorArray[n] = jRSReportEngine.I();
            }
            ++n;
        }
        this.preinitEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()");
    }

    public void preinitEngine(String[] stringArray, Vector[] vectorArray, boolean bl) throws EngingPreinitException, JRScheduleException {
        Object object;
        int n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngine()..., rptNames: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray) + " forceInit: " + bl);
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl) {
            this.rptSetCenter.resetParameterInDataSetQuery();
            this.booleanValue.reset();
            n = 0;
            while (n < stringArray.length) {
                int n2 = 0;
                while (n2 < vectorArray[n].size()) {
                    object = (String)vectorArray[n].elementAt(n2);
                    this.createDynamicQuery(stringArray[n], (String)object);
                    ++n2;
                }
                ++n;
            }
        }
        n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            object = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.preinitEngine((String[])object, bl);
            ++n;
        }
        Tools.logTrace(6, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        if (bl) {
            long l2 = System.currentTimeMillis();
            try {
                this.clearSubRptInfoMap(stringArray, vectorArray);
            }
            catch (EngingPreinitException engingPreinitException) {
                JRScheduleException jRScheduleException = new JRScheduleException(220013, (Throwable)engingPreinitException);
                JRLog.error(1, jRScheduleException);
                throw jRScheduleException;
            }
            catch (JRScheduleException jRScheduleException) {
                JRLog.error(1, jRScheduleException);
                throw jRScheduleException;
            }
            Tools.logTrace(6, "pre init sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        }
        long l3 = System.currentTimeMillis();
        if (this.isRsd()) {
            // empty if block
        }
        if (bl) {
            String[] stringArray2 = this.getAllDataSet(stringArray, vectorArray);
            this.equalsForRawData(stringArray2);
        }
        Tools.logTrace(6, "pre init whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()...");
    }

    public void preinitEngineAbsolute(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngineAbsolute()..., rptNames: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray));
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            String[] stringArray2 = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.preinitEngineAbsolute(stringArray2);
            ++n;
        }
        Tools.logTrace(6, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        try {
            this.clearSubRptInfoMap(stringArray, vectorArray);
        }
        catch (EngingPreinitException engingPreinitException) {
            JRScheduleException jRScheduleException = new JRScheduleException(220013, (Throwable)engingPreinitException);
            JRLog.error(1, jRScheduleException);
            throw jRScheduleException;
        }
        catch (JRScheduleException jRScheduleException) {
            JRLog.error(1, jRScheduleException);
            throw jRScheduleException;
        }
        Tools.logTrace(6, "pre init sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        long l3 = System.currentTimeMillis();
        if (this.isRsd()) {
            // empty if block
        }
        Tools.logTrace(6, "pre init whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()...");
    }

    public void initRunEngine(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = this.htReportEngine.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine != null) {
                vectorArray[n] = jRSReportEngine.I();
            }
            ++n;
        }
        this.initRunEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngine()");
    }

    public void initRunEngine(String[] stringArray, Vector[] vectorArray, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngine()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray) + " forceInit: " + bl);
            JRLog.trace(6, "initRun..., parameter buf: " + this.getParamsBuffer().toString());
        }
        this.LOCAL_LANGUAGE(5);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            String[] stringArray2 = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.initRunEngine(stringArray2, bl);
            ++n;
        }
        Tools.logTrace(6, "init run main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        this.clone(stringArray, vectorArray);
        Tools.logTrace(6, "init run sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        if (bl) {
            this.rptSetCenter.refreshAllRecSecurities(this.getUserName(), JRptSetEngine.getSecurityData(), this.getSecurityContext());
            this.getAllLinkReportEngine(stringArray, vectorArray);
            JSubRptSetEngine[] jSubRptSetEngineArray = this.rptSetCenter.getAllSubRptSetEngines();
            if (jSubRptSetEngineArray != null && jSubRptSetEngineArray.length > 0) {
                int n2 = 0;
                while (n2 < jSubRptSetEngineArray.length) {
                    ReportSetCenter reportSetCenter = jSubRptSetEngineArray[n2].getReportSetCenter();
                    reportSetCenter.getRptSetEngine().getAllAvailableGroupFieldName();
                    reportSetCenter.closeAllRawDatas();
                    reportSetCenter.refreshAllRecSecurities(this.getUserName(), JRptSetEngine.getSecurityData(), this.getSecurityContext());
                    jSubRptSetEngineArray[n2].initAllRawDataQuery();
                    ++n2;
                }
            }
        }
        Tools.logTrace(6, "init run whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngine()");
    }

    public void initRunEngineAbsolute(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngineAbsolute()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
            JRLog.trace(6, "initRun..., parameter buf: " + this.getParamsBuffer().toString());
        }
        this.LOCAL_LANGUAGE(5);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            String[] stringArray2 = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.initRunEngineAbsolute(stringArray2);
            ++n;
        }
        Tools.logTrace(6, "init run main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        this.clone(stringArray, vectorArray);
        Tools.logTrace(6, "init run sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        this.getAllLinkReportEngine(stringArray, vectorArray);
        JSubRptSetEngine[] jSubRptSetEngineArray = this.rptSetCenter.getAllSubRptSetEngines();
        if (jSubRptSetEngineArray != null && jSubRptSetEngineArray.length > 0) {
            int n2 = 0;
            while (n2 < jSubRptSetEngineArray.length) {
                ReportSetCenter reportSetCenter = jSubRptSetEngineArray[n2].getReportSetCenter();
                reportSetCenter.getRptSetEngine().getAllAvailableGroupFieldName();
                reportSetCenter.closeAllRawDatas();
                reportSetCenter.refreshAllRecSecurities(this.getUserName(), JRptSetEngine.getSecurityData(), this.getSecurityContext());
                jSubRptSetEngineArray[n2].initAllRawDataQuery();
                ++n2;
            }
        }
        Tools.logTrace(6, "init run whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngineAbsolute()");
    }

    public void importParamValues(boolean bl) throws JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.importParamValues()...");
        if (this.booleanValue != null && (bl || !this.cvIExpresstion)) {
            this.booleanValue.initParamBuff();
            this.booleanValue.importParamValues();
            this.cvIExpresstion = true;
        }
        Tools.logTrace(6, "End of JRptSetEngine.importParamValues().");
    }

    public void prepareRunningEnv() throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareRunningEnv()...");
        }
        this.LOCAL_LANGUAGE(4);
        if (this.booleanValue == null) {
            return;
        }
        this.booleanValue.initParamBuff();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init param buff, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        this.booleanValue.importParamValues(false);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "import param values values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        if (!this.isRsd()) {
            this.booleanValue.genValidValues(this.getParamValues(), this.getParamFile(), this.getParamProperty());
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "gen valid values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            }
        }
        this.booleanValue.setValidValues();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "set valid values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepareRunningEnv, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareRunningEnv().");
        }
    }

    public void prepareParamBuff(Hashtable hashtable) throws JRScheduleException {
        if (this.booleanValue == null) {
            return;
        }
        this.booleanValue.prepareParamBuff(hashtable);
    }

    public void notifyChangedParameter(String[] stringArray) {
        if (this.booleanValue == null) {
            return;
        }
    }

    protected RawDataQueryOption genRawDataQueryOption(DataSetCenter dataSetCenter, boolean bl) throws DSException {
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        RawDataQueryOption rawDataQueryOption = new RawDataQueryOption();
        rawDataQueryOption.setFastPass(bl);
        boolean bl2 = true;
        rawDataQueryOption.setLazyRun(bl2);
        int n = this.getLimitedRecNum();
        Tools.logTrace(6, "maxRecord: " + n);
        rawDataQueryOption.setMaxRecords(n);
        rawDataQueryOption.setMaxPageNumber(jetRptDataSet.maxPageNumber.get());
        rawDataQueryOption.setRecordsPerPage(jetRptDataSet.recordsPerPage.get());
        rawDataQueryOption.setSingleThread(this.singleThread);
        boolean bl3 = this.beforeRun(dataSetCenter.getSecContainer());
        Tools.logTrace(6, "set no record: " + bl3);
        rawDataQueryOption.setNoRecord(bl3);
        return rawDataQueryOption;
    }

    public void setLimitedRecNum(int n) {
        this.closeRelatedDataInstance = n;
    }

    public int getLimitedRecNum() {
        return this.closeRelatedDataInstance;
    }

    public String[] getUsedDataSetNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.rptSetCenter.getAllDataSetName();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String[] getAvailableDrillMappingName(String string, JetRptObject jetRptObject) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getAvailableDrillMappingName..., rptName: " + string + " o: " + jetRptObject);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        JetRptDataSet jetRptDataSet = (JetRptDataSet)dataContainerLogic.getUsedDataSet(dataContainerLogic.getDataContainer(jetRptObject, true));
        if (jetRptDataSet == null) {
            Tools.logTrace(6, "data set is null.");
            return null;
        }
        if (jetRptObject instanceof JetRptCTHdDBField) {
            stringArray2 = this.getAllAvailableGroupFieldName(jetRptDataSet);
            stringArray = this.clearEngine((JetRptCTHdDBField)jetRptObject, stringArray2);
        } else {
            JetRptObject jetRptObject2 = jetRptObject;
            while (jetRptObject2 != null && !(jetRptObject2 instanceof JetRptGroupPanel)) {
                if (jetRptObject2 instanceof JetRptDetailPanel || jetRptObject2 instanceof JetRptTableDetail) break;
                if ((jetRptObject2 = (JetRptObject)((Object)jetRptObject2.getParent())) instanceof JetRptReport || !(jetRptObject2 instanceof JetRptGroupPanel)) continue;
                stringArray2 = this.getAllAvailableGroupFieldName(jetRptDataSet);
                stringArray = this.catchError((JetRptGroupPanel)jetRptObject2, stringArray2);
                break;
            }
        }
        return stringArray;
    }

    private String[] catchError(JetRptGroupPanel jetRptGroupPanel, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        String string = jetRptGroupPanel.groupBy.isChangeByOther() ? jetRptGroupPanel.groupBy.getChangeByObjectName() : ((JetColumnName)jetRptGroupPanel.groupBy).get();
        Vector vector2 = this.changeParamValues(jetRptGroupPanel, new Vector());
        Vector vector3 = this.clear(jetRptGroupPanel);
        if (vector2.size() == 0 || !vector2.contains(string) || vector2.contains(string) && vector3.contains(string)) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.compareTo(stringArray[n]) != 0) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        return vector.toArray(new String[0]);
    }

    private Vector changeParamValues(JetRptGroupPanel jetRptGroupPanel, Vector vector) {
        Vector vector2 = jetRptGroupPanel.getChildren();
        JetObject jetObject = null;
        int n = 0;
        while (n < vector2.size()) {
            jetObject = (JetObject)vector2.elementAt(n);
            if (jetObject instanceof JetRptDataContainer) {
                Vector vector3 = this.checkSubReportLoop((JetRptDataContainer)jetObject);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    String string = ((JetRptDBField)vector3.elementAt(n2)).getGroupByFld();
                    if (string != null && string.trim().length() != 0) {
                        vector.add(string.toUpperCase());
                    }
                    ++n2;
                }
            } else if (jetObject instanceof JetRptGroupPanel) {
                vector = this.changeParamValues((JetRptGroupPanel)jetObject, vector);
            }
            ++n;
        }
        return vector;
    }

    private Vector checkSubReportLoop(JetRptDataContainer jetRptDataContainer) {
        Vector vector = jetRptDataContainer.getChildren();
        Vector<JetRptObject> vector2 = new Vector<JetRptObject>();
        JetRptObject jetRptObject = null;
        int n = 0;
        while (n < vector.size()) {
            jetRptObject = (JetRptObject)vector.elementAt(n);
            if (jetRptObject instanceof JetRptDBField) {
                vector2.add(jetRptObject);
            }
            ++n;
        }
        return vector2;
    }

    private Vector clear(JetRptGroupPanel jetRptGroupPanel) {
        Vector<String> vector = new Vector<String>();
        JetRptObject jetRptObject = (JetRptObject)((Object)jetRptGroupPanel.getParent());
        while (jetRptObject != null) {
            if (jetRptObject instanceof JetRptGroupPanel) {
                String string = ((JetRptGroupPanel)jetRptObject).groupBy.isChangeByOther() ? ((JetRptGroupPanel)jetRptObject).groupBy.getChangeByObjectName() : ((JetColumnName)((JetRptGroupPanel)jetRptObject).groupBy).get();
                vector.add(string.toUpperCase());
            }
            jetRptObject = (JetRptObject)((Object)jetRptObject.getParent());
        }
        return vector;
    }

    private String[] clearEngine(JetRptCTHdDBField jetRptCTHdDBField, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (jetRptCTHdDBField.columnName.get().compareTo(stringArray[n]) != 0) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String[] getDbFieldPass1FormulaNames(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDbFieldPass1FormulaNames()... dataSetName: " + string);
        }
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        String[] stringArray = dataSetCenter.getDbFieldPass1FormulaNames();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDbFieldPass1FormulaNames(). return " + Tools.toString(stringArray));
        }
        return dataSetCenter.getDbFieldPass1FormulaNames();
    }

    public String[] getAllAvailableGroupFieldName(JetRptDataSet jetRptDataSet) {
        if (jetRptDataSet == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "dataSet: " + jetRptDataSet);
        }
        String string = jetRptDataSet.getDataSourceName();
        String string2 = jetRptDataSet.getQueryName();
        Vector vector2 = this.universe.getAvailableResourceEntitys(string, string2);
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector2.elementAt(n2);
            if (jetUResourceEntity instanceof JetUDBField) {
                vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
            } else if (jetUResourceEntity instanceof JetUFmlQueryField) {
                vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
            } else if (jetUResourceEntity instanceof JetUFormula && ((JetUFormula)jetUResourceEntity).canSummary()) {
                vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    public JReportEngine getViewEngine(String string, String string2) {
        if (this.htReportEngine == null) {
            return null;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (jRSReportEngine == null) {
            return null;
        }
        return jRSReportEngine.getViewEngine(string2);
    }

    private void clearMem(String[] stringArray, Vector[] vectorArray) {
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n2);
            jReportEngine.getReportViewCenter().clearSubEngines();
            ++n2;
        }
    }

    private void clearSubEngines(String[] stringArray, Vector[] vectorArray) throws JRScheduleException, EngingPreinitException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        JReportEngine jReportEngine;
        Tools.logTrace(6, "JRptSetEngine.initSubReportEngine()...");
        this.clearMem(stringArray, vectorArray);
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        int n = vector.size();
        String string = this.getReportSet().getPath();
        int n2 = 0;
        while (n2 < n) {
            SubReportCheckTool subReportCheckTool = new SubReportCheckTool();
            jReportEngine = (JReportEngine)vector.elementAt(n2);
            object5 = new SubRptLoader(this, jReportEngine.getReportCenter(), this.add);
            object4 = jReportEngine.getReport();
            object3 = subReportCheckTool.checkSubReportLoop((JetRptReport)object4, string, (ITemplateLoader)object5);
            object2 = jReportEngine.getReportViewCenter();
            ((ReportViewCenter)object2).setSubRptInfo((SubReportInfo)object3);
            ((ReportViewCenter)object2).setUpSubRptInfoMap();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            jReportEngine = (JReportEngine)vector.elementAt(n3);
            object5 = jReportEngine.getReportViewCenter();
            object4 = jReportEngine.getReport();
            object3 = ((ReportViewCenter)object5).getSubRptInfo();
            if (object3 != null) {
                object2 = new SubRptShareTool();
                ((SubRptShareTool)object2).initSubRptShareInfo((JetRptReport)object4, (ReportViewCenter)object5);
                ((ReportViewCenter)object5).clearSubRptInfoMap();
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            object5 = (JReportEngine)vector.elementAt(n4);
            object4 = ((JEngineInitializer)object5).getReportViewCenter();
            object3 = ((ReportViewCenter)object4).getSubRptInfo();
            if (object3 != null) {
                object2 = new PreOrderIterator((ITreeNode)object3);
                if (((ITreeIterator)object2).hasNext()) {
                    ((ITreeIterator)object2).next();
                }
                while (((ITreeIterator)object2).hasNext()) {
                    object = (SubReportInfo)((ITreeIterator)object2).next();
                    SubReportInfo subReportInfo = (SubReportInfo)((SubReportInfo)object).getParent();
                    if (((SubReportInfo)object).isShared()) {
                        ((ReportViewCenter)object4).initSubReportEngine(this, (SubReportInfo)object, (JReportEngine)object5, true);
                        continue;
                    }
                    if (subReportInfo.isRoot()) {
                        ((ReportViewCenter)object4).initSubReportEngine(this, (SubReportInfo)object, (JReportEngine)object5, false);
                        continue;
                    }
                    JSubReportEngine jSubReportEngine = subReportInfo.getSubRptViewEngine();
                    ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
                    reportViewCenter.initSubReportEngine(this, (SubReportInfo)object, (JReportEngine)object5, false);
                }
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            object4 = (JReportEngine)vector.elementAt(n5);
            object3 = ((JEngineInitializer)object4).getReportViewCenter();
            ((ReportViewCenter)object3).setUpSubRptShareMap();
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            object3 = (JReportEngine)vector.elementAt(n6);
            object2 = ((JEngineInitializer)object3).getReportViewCenter();
            object = ((ReportViewCenter)object2).getAllSubRptSetEngine();
            int n7 = 0;
            while (n7 < ((JSubRptSetEngine[])object).length) {
                ((JSubRptSetEngine)object[n7]).asyncronizedSetPriority(this.getPriority());
                ++n7;
            }
            ++n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubRptInfoMap(String[] stringArray, Vector[] vectorArray) throws JRScheduleException, EngingPreinitException {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initSubReportEngine()..., rptName: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray));
        }
        Object object2 = object = this.isDhtmlInteract() ? null : this.getPriorityLocker();
        if (object == null) {
            this.clearSubEngines(stringArray, vectorArray);
        } else {
            Object object3 = object;
            synchronized (object3) {
                this.clearSubEngines(stringArray, vectorArray);
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.initSubReportEngine().");
    }

    private void clone(String[] stringArray, Vector[] vectorArray) {
        Tools.logTrace(6, "initRunSubReportEngine ...");
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        ArrayList<JSubRptSetEngine> arrayList = new ArrayList<JSubRptSetEngine>(4);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n2);
            SubReportInfo subReportInfo = jReportEngine.getReportViewCenter().getSubRptInfo();
            if (subReportInfo != null) {
                PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
                if (((ITreeIterator)preOrderIterator).hasNext()) {
                    ((ITreeIterator)preOrderIterator).next();
                }
                while (((ITreeIterator)preOrderIterator).hasNext()) {
                    SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                    JSubReportEngine jSubReportEngine = subReportInfo2.getSubRptViewEngine();
                    JSubRptSetEngine jSubRptSetEngine = subReportInfo2.getSubRptSetEngine();
                    if (!arrayList.contains(jSubRptSetEngine)) {
                        arrayList.add(jSubRptSetEngine);
                    }
                    jSubReportEngine.initRun();
                    jSubReportEngine.getReportViewCenter().refreshDataSet();
                }
            }
            ++n2;
        }
    }

    public void runLinkedReport(String string, String string2, JSubLinkContainer jSubLinkContainer) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runLinkedReport()..., rptName: " + string + " viewName: " + string2);
        }
        if (this.addDataContainer != 1) {
            Tools.logTrace(6, "invalid invoke, engine type is " + this.addDataContainer);
            return;
        }
        this.runReport(string, string2);
    }

    public JReportEngine getDetailReportViewEngine() {
        if (this.addDataContainer != 2) {
            JRLog.error(1, "Inhibitory invoke, engine type does not match., error code: ENGINE_00006");
            return null;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty() || this.htReportEngine.size() != 1) {
            JRLog.error(1, "report engine does not exist.");
            return null;
        }
        Enumeration enumeration = this.htReportEngine.keys();
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(enumeration.nextElement());
        String string = jRSReportEngine.getReport().getCurViewName();
        return jRSReportEngine.getViewEngine(string);
    }

    public boolean prepareParamValues(Hashtable hashtable) throws JRScheduleException {
        return this.booleanValue.prepareParamValues(hashtable);
    }

    Map close(JetRptReportSet jetRptReportSet) {
        HashMap hashMap = new HashMap();
        String[] stringArray = jetRptReportSet.getAllReportsName();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
            String[] stringArray2 = jetRptReport.getAllViewName();
            Vector<String> vector = new Vector<String>();
            vector.addAll(Arrays.asList(stringArray2));
            hashMap.put(stringArray[n], vector);
            ++n;
        }
        return hashMap;
    }

    Vector closeAllGroups(JetRptReportSet jetRptReportSet) {
        Vector<String> vector = new Vector<String>();
        DataSet[] dataSetArray = jetRptReportSet.getAllDataSet();
        int n = 0;
        while (dataSetArray != null && n < dataSetArray.length) {
            vector.addElement(dataSetArray[n].getName());
            ++n;
        }
        return vector;
    }

    Map closeAllRawDatas(Vector vector) throws JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.getResultSet()...");
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        String[] stringArray = vector == null ? new String[]{} : vector.toArray(new String[vector.size()]);
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                ResultSet resultSet;
                DataSetCenter dataSetCenter;
                block8: {
                    dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n]);
                    if (!dataSetCenter.needRefresh()) break block8;
                    this.runDataSet(stringArray[n], false);
                    if (dataSetCenter.needRefresh()) break block9;
                }
                int n2 = dataSetCenter.getRawDataId();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get result set, dataSetName: " + stringArray[n] + " query id: " + n2);
                }
                try {
                    resultSet = this.dataEngine.getResultSet(n2);
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(220005, new String[]{stringArray[n]}, dSException);
                }
                catch (JRStopEngineException jRStopEngineException) {
                    throw new JRScheduleException(220005, new String[]{stringArray[n]}, jRStopEngineException);
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "ResultSet: " + resultSet);
                }
                hashMap.put(stringArray[n], resultSet);
            }
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getResultSet(), return: " + hashMap);
        }
        return hashMap;
    }

    Map closeRawData(Vector vector) throws JRScheduleException {
        HashMap<String, String[][]> hashMap = new HashMap<String, String[][]>();
        String[] stringArray = vector == null ? new String[]{} : vector.toArray(new String[vector.size()]);
        int n = 0;
        while (n < stringArray.length) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n]);
            if (!dataSetCenter.needRefresh()) {
                String[][] stringArray2;
                int n2 = dataSetCenter.getRawDataId();
                try {
                    stringArray2 = this.dataEngine.getBindInfo(n2);
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(220006, new String[]{stringArray[n]}, dSException);
                }
                hashMap.put(stringArray[n], stringArray2);
            }
            ++n;
        }
        return hashMap;
    }

    private int closeRelatedDataInstance(RSDInfo rSDInfo) {
        ArrayList<JSubRptSetEngine> arrayList = new ArrayList<JSubRptSetEngine>();
        Vector vector = this.getAllReportViewEngines();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n2);
            SubReportInfo subReportInfo = jReportEngine.getReportViewCenter().getSubRptInfo();
            if (subReportInfo != null) {
                SubReportInfo subReportInfo2;
                PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
                if (((ITreeIterator)preOrderIterator).hasNext()) {
                    subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                    subReportInfo2.setRSDIndex(0);
                }
                while (((ITreeIterator)preOrderIterator).hasNext()) {
                    subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                    SubReportInfo subReportInfo3 = (SubReportInfo)subReportInfo2.getParent();
                    JetRptSubReport jetRptSubReport = subReportInfo2.getSubReport();
                    JSubRptSetEngine jSubRptSetEngine = subReportInfo2.getSubRptSetEngine();
                    int n3 = jSubRptSetEngine.getRSDKey();
                    subReportInfo2.setRSDIndex(n3);
                    String string = jetRptSubReport.report.get();
                    String string2 = jetRptSubReport.view.get();
                    rSDInfo.addIndexOfParentIndex(subReportInfo3.getRsdIndex(), string, string2, jetRptSubReport.getInstName(), n3);
                    if (subReportInfo2.isShared()) {
                        if (arrayList.contains(jSubRptSetEngine)) continue;
                        arrayList.add(jSubRptSetEngine);
                        continue;
                    }
                    arrayList.add(jSubRptSetEngine);
                }
            }
            ++n2;
        }
        return arrayList.size() + 1;
    }

    public int genRSDKey() {
        return this.dataDriver++;
    }

    public void setRSDKey(int n) {
        this.dataDriver = n;
    }

    public int getRSDKey() {
        return this.dataDriver;
    }

    private void colName(RSDInfo rSDInfo) {
        String[] stringArray = this.getReportNames();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                RuntimeInfo runtimeInfo = this.getRuntimeInfo(stringArray[n], stringArray2[n2]);
                rSDInfo.setHighPrecision(stringArray[n], stringArray2[n2], runtimeInfo.isHighPrecision());
                ++n2;
            }
            ++n;
        }
    }

    private void columnName(RSDInfo rSDInfo) {
        String[] stringArray = this.getReportNames();
        int n = 0;
        while (n < stringArray.length) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[n2]);
                Communicator communicator = jReportEngine.getCommunicator();
                Vector vector = ((JCommunicator)communicator).getListOfPicName();
                rSDInfo.setPictureNames(stringArray[n], stringArray2[n2], vector);
                ++n2;
            }
            ++n;
        }
    }

    Map compareTo(JetRptReportSet jetRptReportSet) throws JRScheduleException {
        Object object;
        String[] stringArray;
        HashMap<String, CLSInfo> hashMap = new HashMap<String, CLSInfo>();
        Vector vector = this.closeAllGroups(jetRptReportSet);
        String[] stringArray2 = stringArray = vector == null ? null : vector.toArray(new String[vector.size()]);
        if (stringArray == null || stringArray.length == 0) {
            return hashMap;
        }
        String[] stringArray3 = jetRptReportSet.getAllReportsName();
        Vector[] vectorArray = new Vector[stringArray3.length];
        int n = 0;
        while (n < stringArray3.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray3[n]);
            object = jetRptReport.getAllViewName();
            vectorArray[n] = new Vector();
            vectorArray[n].addAll(Arrays.asList(object));
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = this.rptSet.getDataSet(stringArray[n2]);
            JColumnSecurityContainer jColumnSecurityContainer = null;
            try {
                jColumnSecurityContainer = new JColumnSecurityContainer(this.getUniverse(), (DataSet)object, this.getUserName(), JRptSetEngine.getSecurityData(), this.getSecurityContext(), this, stringArray3, vectorArray);
            }
            catch (JSecurityEntryException jSecurityEntryException) {
                throw new JRScheduleException(220073, new String[]{stringArray[n2]}, jSecurityEntryException);
            }
            catch (JPermissionLinkException jPermissionLinkException) {
                throw new JRScheduleException(220073, new String[]{stringArray[n2]}, jPermissionLinkException);
            }
            catch (JPolicyLinkException jPolicyLinkException) {
                throw new JRScheduleException(220073, new String[]{stringArray[n2]}, jPolicyLinkException);
            }
            catch (NotOwnerException notOwnerException) {
                throw new JRScheduleException(220073, new String[]{stringArray[n2]}, notOwnerException);
            }
            catch (ACLException aCLException) {
                throw new JRScheduleException(220073, new String[]{stringArray[n2]}, aCLException);
            }
            CLSInfo cLSInfo = new CLSInfo(jColumnSecurityContainer.doCLS(), jColumnSecurityContainer.denyAllColumns(), jColumnSecurityContainer.getDeniedColumns());
            hashMap.put(stringArray[n2], cLSInfo);
            ++n2;
        }
        return hashMap;
    }

    private void contains(RSDInfo rSDInfo) {
        Object object;
        String[] stringArray = this.getReportNames();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            object = this.getReportEngine(stringArray[n]);
            String[] stringArray2 = ((JRSReportEngine)object).getViewNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                ReportViewCenter reportViewCenter = ((JRSReportEngine)object).getReportCenter().getReportViewCenter(stringArray2[n2]);
                JSubReportEngine[] jSubReportEngineArray = reportViewCenter.getAllSubReportEngine();
                int n3 = -1;
                while (n3 < jSubReportEngineArray.length) {
                    block6: {
                        JReportEngine jReportEngine;
                        block7: {
                            block5: {
                                jReportEngine = null;
                                if (n3 != -1) break block5;
                                if (n > 0 || n2 > 0) break block6;
                                jReportEngine = reportViewCenter.getReportViewEngine();
                                break block7;
                            }
                            jReportEngine = jSubReportEngineArray[n3];
                        }
                        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
                        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
                        String[] stringArray3 = reportSetCenter.getDataSetNames();
                        int n4 = 0;
                        while (n4 < stringArray3.length) {
                            DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(stringArray3[n4]);
                            JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
                            this.containsKey(arrayList, jetRptDataSet.getDataSourceName(), jetRptDataSet.getQueryName());
                            ++n4;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        object = this.create(arrayList);
        if (object != null && ((String[])object).length > 0) {
            rSDInfo.setDeniedBLNames(1, (String[])object);
        }
    }

    private void containsKey(List list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        if (!list.contains(arrayList)) {
            list.add(arrayList);
        }
    }

    private String[] create(List list) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDeniedBLColumns()..., list: " + list);
        }
        AccessController accessController = this.getAccessController();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.size()) {
            String string;
            List list2 = (List)list.get(n);
            String string2 = (String)list2.get(0);
            Vector vector = ResourceTool.getBusinessLogicResorceNames(this.universe, string2, string = (String)list2.get(1));
            if (vector != null && !vector.isEmpty()) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string3 = (String)vector.elementAt(n2);
                    try {
                        if (!accessController.hasPermission(string3, Permissions.P_VISIBLE)) {
                            arrayList.add(string3);
                        }
                    }
                    catch (InvalidResource invalidResource) {
                        Tools.logTrace(4, invalidResource);
                        arrayList.add(string3);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getDeniedBLColumns(), return: " + arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public RSDInfo genRSDInfo() throws JRScheduleException {
        return this.genRSDInfo(null, false);
    }

    public RSDInfo genRSDInfo(Map map, boolean bl) throws JRScheduleException {
        Object object;
        Object object2;
        Cloneable cloneable;
        Tools.logTrace(6, "JRptSetEngine.genRSDInfo()...");
        if (this.deepDupWithName != null) {
            cloneable = new HashMap();
            object2 = this.deepDupWithName.keySet().iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                ((HashMap)cloneable).put(string, ((Vector)this.deepDupWithName.get(string)).clone());
            }
            if (this.isOnDemandReport()) {
                this.deepDupWithName((Map)((Object)cloneable));
            }
            this.waitRunFinished((Map)((Object)cloneable));
        }
        if (map != null) {
            map.put(new Integer(0), this);
        }
        cloneable = new Vector();
        object2 = bl ? new RSDBurstingInfo() : new RSDInfo(false);
        int n = this.closeRelatedDataInstance((RSDInfo)object2);
        ((RSDInfo)object2).setRptSetSize(n);
        ((RSDInfo)object2).setRptSetName(this.rptSetCenter.getRptSetName(), 0);
        JetRptReportSet jetRptReportSet = this.denyAllColumns();
        this.disable(jetRptReportSet);
        ((RSDInfo)object2).setRptSet(jetRptReportSet, 0);
        ((RSDInfo)object2).setReportInfo(this.close(jetRptReportSet), 0);
        Vector vector = this.closeAllGroups(jetRptReportSet);
        ((RSDInfo)object2).setDataSetInfo(vector, 0);
        ((RSDInfo)object2).setResultSet(this.closeAllRawDatas(vector), 0);
        ((RSDInfo)object2).setBindInfo(this.closeRawData(vector), 0);
        ((RSDInfo)object2).setUserId(this.getUserName());
        this.colName((RSDInfo)object2);
        ((RSDInfo)object2).setCLSInfo(this.compareTo(jetRptReportSet), 0);
        this.contains((RSDInfo)object2);
        this.columnName((RSDInfo)object2);
        ArrayList<JetRptReportSet> arrayList = new ArrayList<JetRptReportSet>();
        arrayList.add(this.rptSet);
        Vector vector2 = this.getAllReportViewEngines();
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (JReportEngine)vector2.elementAt(n3);
            SubReportCheckTool subReportCheckTool = new SubReportCheckTool();
            SubRptEngineLoader subRptEngineLoader = new SubRptEngineLoader((JReportEngine)object);
            JetRptReport jetRptReport = ((JReportEngine)object).getReport();
            SubReportInfo subReportInfo = null;
            try {
                subReportInfo = subReportCheckTool.checkSubReportLoop(jetRptReport, null, subRptEngineLoader);
            }
            catch (NullPointerException nullPointerException) {
                JRLog.trace(6, nullPointerException);
            }
            if (subReportInfo != null) {
                PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
                if (((ITreeIterator)preOrderIterator).hasNext()) {
                    ((ITreeIterator)preOrderIterator).next();
                }
                while (((ITreeIterator)preOrderIterator).hasNext()) {
                    Vector vector3;
                    JetRptReportSet jetRptReportSet2;
                    int n4;
                    ReportSetCenter reportSetCenter;
                    SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                    String string = subReportInfo2.getSubRptSetName();
                    JSubRptSetEngine jSubRptSetEngine = subReportInfo2.getSubRptSetEngine();
                    boolean bl2 = jSubRptSetEngine.isShared();
                    JetRptReportSet jetRptReportSet3 = jSubRptSetEngine.getReportSet();
                    if (!arrayList.contains(jetRptReportSet3)) {
                        arrayList.add(jetRptReportSet3);
                    }
                    if (bl2) {
                        if (((Vector)cloneable).contains(string)) continue;
                        ((Vector)cloneable).addElement(string);
                        reportSetCenter = jSubRptSetEngine.getReportSetCenter();
                        n4 = jSubRptSetEngine.getRSDKey();
                        ((RSDInfo)object2).setRptSetName(reportSetCenter.getRptSetName(), n4);
                        jetRptReportSet2 = jSubRptSetEngine.denyAllColumns();
                        jSubRptSetEngine.disable(jetRptReportSet2);
                        ((RSDInfo)object2).setRptSet(jetRptReportSet2, n4);
                        ((RSDInfo)object2).setReportInfo(jSubRptSetEngine.close(jetRptReportSet2), n4);
                        vector3 = jSubRptSetEngine.closeAllGroups(jetRptReportSet2);
                        ((RSDInfo)object2).setDataSetInfo(vector3, n4);
                        ((RSDInfo)object2).setResultSet(jSubRptSetEngine.closeAllRawDatas(vector3), n4);
                        ((RSDInfo)object2).setBindInfo(jSubRptSetEngine.closeRawData(vector3), n4);
                        ((RSDInfo)object2).setCLSInfo(jSubRptSetEngine.compareTo(jetRptReportSet2), n4);
                        if (map == null) continue;
                        map.put(new Integer(n4), jSubRptSetEngine);
                        continue;
                    }
                    reportSetCenter = jSubRptSetEngine.getReportSetCenter();
                    n4 = jSubRptSetEngine.getRSDKey();
                    ((RSDInfo)object2).setRptSetName(reportSetCenter.getRptSetName(), n4);
                    jetRptReportSet2 = jSubRptSetEngine.denyAllColumns();
                    jSubRptSetEngine.disable(jetRptReportSet2);
                    ((RSDInfo)object2).setRptSet(jetRptReportSet2, n4);
                    ((RSDInfo)object2).setReportInfo(jSubRptSetEngine.close(jetRptReportSet2), n4);
                    vector3 = jSubRptSetEngine.closeAllGroups(jetRptReportSet2);
                    ((RSDInfo)object2).setDataSetInfo(vector3, n4);
                    ((RSDInfo)object2).setResultSet(jSubRptSetEngine.closeAllRawDatas(vector3), n4);
                    ((RSDInfo)object2).setBindInfo(jSubRptSetEngine.closeRawData(vector3), n4);
                    ((RSDInfo)object2).setCLSInfo(jSubRptSetEngine.compareTo(jetRptReportSet2), n4);
                    if (map == null) continue;
                    map.put(new Integer(n4), jSubRptSetEngine);
                }
            }
            ++n3;
        }
        ((RSDInfo)object2).setUniverse(this.universe);
        ((RSDInfo)object2).setParameter(this.getValidParamValues());
        object = JReportUtil.getImgMappingTable(arrayList.toArray(new JetRptReportSet[0]));
        ((RSDInfo)object2).setImgMappingTable((Hashtable)object);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, object2.toString());
            JRLog.trace(6, "End of JRptSetEngine.genRSDInfo().");
        }
        return object2;
    }

    public RSDBurstingInfo genRSDBurstingInfo() throws JRScheduleException {
        HashMap hashMap = new HashMap();
        RSDBurstingInfo rSDBurstingInfo = (RSDBurstingInfo)this.genRSDInfo(hashMap, true);
        try {
            rSDBurstingInfo.initPLS(hashMap);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException(220079, (Throwable)jRStopEngineException);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(220079, (Throwable)dSException);
        }
        return rSDBurstingInfo;
    }

    public List getValueList(String string, String string2, int n, int n2) throws JRScheduleException {
        Object object;
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getValueList()..., dataSetName: " + string + " colName: " + string2);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            throw new JRSInvalidParameterException(250009, new String[]{string}, null);
        }
        List list = null;
        boolean bl = dataSetCenter.isNewDataSetValues();
        if (bl || dataSetCenter.getDataSetValues(string2) == null) {
            this.SetShowValueForOneParamDesc(string);
            int n3 = this.rptSetCenter.getSerialNo();
            object = null;
            try {
                object = this.createDataSourceQuery(dataSetCenter, string2, dataSetCenter.getGeneralRawDataId(), n3);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220007, new String[]{string}, dSException);
            }
            Group group = null;
            try {
                this.dataEngine.prepareQuery(new JQuery[]{object});
                group = this.dataEngine.getResult(n3);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220008, new String[]{String.valueOf(n3)}, dSException);
            }
            catch (JRStopEngineException jRStopEngineException) {
                throw new JRScheduleException(220008, new String[]{String.valueOf(n3)}, jRStopEngineException);
            }
            dataSetCenter.setDataSetGroupQuery(string2, (JGroupQuery)object);
            list = this.createAccessController(group, n2);
            dataSetCenter.setDataSetValues(string2, list);
            dataSetCenter.setDataSetValueTree(string2, group);
        } else {
            list = dataSetCenter.getDataSetValues(string2);
            if (list.size() < n2 + n) {
                Group group = dataSetCenter.getDataSetValueTree(string2);
                object = this.createAccessController(group, n2 + n - list.size());
                list.addAll(object);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("0");
            dataSetCenter.setNewDataSetValues(false);
        } else {
            arrayList.add("1");
        }
        arrayList.add(String.valueOf(list.size()));
        int n4 = n;
        while (n4 < n2 + n && n4 < list.size()) {
            arrayList.add((String)list.get(n4));
            ++n4;
        }
        Tools.logTrace(6, "JRptSetEngine.getValueList().");
        return arrayList;
    }

    private List createAccessController(Group group, int n) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (n <= 0) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < n) {
            Group group2 = group.fetchGroup();
            if (group2 instanceof GroupEnd) break;
            DbValue dbValue = group2.getGroupName();
            arrayList.add(dbValue);
            ++n2;
        }
        return arrayList;
    }

    private JavaFormula createDataEngine(String string) throws JRScheduleException {
        JavaFormula javaFormula = null;
        try {
            javaFormula = this.universe.loadJavaFormula(string);
        }
        catch (ReadFailureException readFailureException) {
            throw new JRScheduleException(220009, new String[]{string}, readFailureException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JRScheduleException(220009, new String[]{string}, fileNotFoundException);
        }
        catch (GenerateFormulasCodeException generateFormulasCodeException) {
            throw new JRScheduleException(220009, new String[]{string}, generateFormulasCodeException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRScheduleException(220009, new String[]{string}, classNotFoundException);
        }
        catch (IOException iOException) {
            throw new JRScheduleException(220009, new String[]{string}, iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new JRScheduleException(220009, new String[]{string}, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRScheduleException(220009, new String[]{string}, illegalAccessException);
        }
        catch (LoadJavaFormulaException loadJavaFormulaException) {
            throw new JRScheduleException(220009, new String[]{string}, loadJavaFormulaException);
        }
        return javaFormula;
    }

    public JavaFormula buildJavaFormula(String string) throws JRScheduleException {
        Object object;
        JavaFormula javaFormula = this.createDataEngine(string);
        Hashtable hashtable = null;
        Hashtable hashtable2 = this.getParamsBuffer();
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            hashtable = new Hashtable(hashtable2.size());
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                ParamDesc paramDesc = (ParamDesc)hashtable2.get(object);
                hashtable.put(object, paramDesc.getValue());
            }
        }
        javaFormula.LOCAL_LANGUAGE(this.ThreadException == null ? Locale.getDefault().getLanguage() : this.ThreadException.getLanguage());
        javaFormula.setParameters(hashtable);
        javaFormula.getSecurityContext().set(this.secCxt);
        object = this.getUserName();
        javaFormula.REPORT_NAME(this.rptSet.getInstName());
        javaFormula.__sys__USERNAME().set((String)object);
        return javaFormula;
    }

    private JGroupQuery createDataSourceQuery(DataSetCenter dataSetCenter, String string, int n, int n2) throws DSException, JRScheduleException {
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string2 = jetRptDataSet.getDataSourceName();
        String string3 = jetRptDataSet.getQueryName();
        JGroupQuery jGroupQuery = null;
        JetUResourceEntity jetUResourceEntity = this.universe.getResourceByName(string2, string3, string);
        DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
        dbColDesc.colName = string;
        JRLog.trace(6, "1eeeeeeeeeeeee, colName: " + dbColDesc.getColName());
        int n3 = 0;
        GroupModel groupModel = new GroupModel(null, null, null, n3, -1, -1, -1, null, -1);
        NormalGroupBreaker normalGroupBreaker = new NormalGroupBreaker(groupModel);
        groupModel.setBreaker(normalGroupBreaker);
        LeafGroupModel leafGroupModel = new LeafGroupModel(dbColDesc, null, groupModel, n3 + 1, -1, 0, -1, null, -1);
        NormalGroupBreaker normalGroupBreaker2 = new NormalGroupBreaker(leafGroupModel);
        leafGroupModel.setBreaker(normalGroupBreaker2);
        LeafGroupList leafGroupList = leafGroupModel.getList();
        GroupModel groupModel2 = groupModel;
        DbColDesc[] dbColDescArray = new DbColDesc[]{new DbColDesc(null, 4, 0, 0, 2), dbColDesc};
        RecordModelInfo recordModelInfo = new RecordModelInfo(dbColDescArray);
        recordModelInfo.setGroupable(leafGroupList);
        groupModel2.setRecordModelInfo(recordModelInfo);
        jGroupQuery = this.dataEngine.createGroupQuery(n2);
        jGroupQuery.setBaseId(n);
        jGroupQuery.setGroupModel(groupModel2);
        jGroupQuery.setFormulaQueue(new FormulaQueue());
        GroupQueryOption groupQueryOption = new GroupQueryOption();
        groupQueryOption.setSingleThread(this.isSingleThread());
        jGroupQuery.setOption(groupQueryOption);
        JavaFormula javaFormula = this.createDataEngine(string2);
        javaFormula.__sys__USERNAME().set(this.userName);
        jGroupQuery.setJavaFormula(javaFormula);
        return jGroupQuery;
    }

    public JetRptReport getSubReport(JetRptSubReport jetRptSubReport) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getSubReport()..., subReport: " + jetRptSubReport);
        }
        Object var2_2 = null;
        Vector vector = this.getAllReportViewEngines();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n2);
            SubReportInfo subReportInfo = jReportEngine.getReportViewCenter().getSubRptInfo();
            PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
            if (((ITreeIterator)preOrderIterator).hasNext()) {
                ((ITreeIterator)preOrderIterator).next();
            }
            while (((ITreeIterator)preOrderIterator).hasNext()) {
                SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                JSubReportEngine jSubReportEngine = subReportInfo2.getSubRptViewEngine();
                if (jetRptSubReport != subReportInfo2.getSubReport()) continue;
                return jSubReportEngine.getReportViewCenter().getReportView();
            }
            ++n2;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Can't find sub report, subReport: " + jetRptSubReport);
        }
        return null;
    }

    public Vector getParameters(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getParameters()..., rptName: " + string);
        }
        Vector vector = null;
        if (string == null) {
            vector = this.booleanValue.getParameters();
        } else {
            String[] stringArray = this.createDefaultRuntimeInfo(string);
            vector = this.booleanValue.getParameters(stringArray);
        }
        if (vector == null || vector.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.getParameters()..., return blank.");
            return vector;
        }
        Tools.logTrace(6, "End of JRptSetEngine.getParameters()..., don't sort, return: " + vector);
        return vector;
    }

    private String[] createDefaultRuntimeInfo(String string) {
        Object object;
        Cloneable cloneable;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        ReportCenter reportCenter = this.rptSetCenter.getReportCenter(string);
        Vector vector2 = reportCenter.getBindedDataSet();
        int n = 0;
        while (n < vector2.size()) {
            object2 = (DataSet)((Object)this.rptSet.nameToObject((String)vector2.elementAt(n)));
            cloneable = this.rptSetCenter.getQueryInfo(object2.getDataSourceName(), object2.getQueryName()).getUsedParameter();
            int n2 = 0;
            while (cloneable != null && n2 < ((Vector)cloneable).size()) {
                object = ((String)((Vector)cloneable).elementAt(n2)).toUpperCase();
                if (!vector.contains(object)) {
                    vector.addElement(object);
                }
                ++n2;
            }
            object = ObjectLogicFactory.getDataSetLogic().getParameterNamesInDataset((DataSet)object2);
            int n3 = 0;
            while (object != null && n3 < ((Vector)object).size()) {
                String string2 = ((String)((Vector)object).elementAt(n3)).toUpperCase();
                if (!vector.contains(string2)) {
                    vector.addElement(string2);
                }
                ++n3;
            }
            ++n;
        }
        object2 = reportCenter.getReportViewCenter(reportCenter.getReport().getCurViewName());
        cloneable = ((ReportViewCenter)object2).getParameters();
        Enumeration enumeration = ((Hashtable)cloneable).keys();
        while (enumeration.hasMoreElements()) {
            object = ((String)enumeration.nextElement()).toUpperCase();
            if (vector.contains(object)) continue;
            vector.addElement(object);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Vector getParameters() {
        return this.getParameters(null);
    }

    public Vector getParamNamesUsedInQuery(String string, String string2) {
        return this.getMainRptSetEngine().getReportSetCenter().getQueryInfo(string, string2).getUsedParameter();
    }

    public ParamDesc[] getInteractParameters() {
        return this.getParameterManager().getInteractParameters();
    }

    public ParamDesc[] getAllParameters(ParamDesc[] paramDescArray) {
        if (paramDescArray == null) {
            return null;
        }
        String[] stringArray = new String[paramDescArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = paramDescArray[n].getName().toUpperCase();
            ++n;
        }
        Vector vector = this.getParameterManager().getParameters(stringArray);
        return vector.toArray(new ParamDesc[vector.size()]);
    }

    public void clearEngine(String string) {
        if (this.htReportEngine != null && this.htReportEngine.containsKey(string)) {
            this.htReportEngine.remove(string);
        }
    }

    public boolean beforeRun(String[] stringArray, Vector[] vectorArray, EngineExecuter engineExecuter) throws Exception {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.beforeRun()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                if (jReportEngine == null) {
                    Tools.logTrace(6, "no report view engine for report: " + stringArray[n] + " and view: " + string);
                } else if (!jReportEngine.beforeRun(engineExecuter)) {
                    Tools.logTrace(6, "failed to beforRun for report: " + stringArray[n] + " and view: " + string);
                    bl = false;
                }
                ++n2;
            }
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.beforeRun(), return: " + bl);
        }
        return bl;
    }

    public boolean afterInitParameter(String[] stringArray, Vector[] vectorArray, EngineExecuter engineExecuter) throws Exception {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.afterInitParameter()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        if (stringArray == null || this.htReportEngine == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                if (jReportEngine == null) {
                    Tools.logTrace(6, "no report view engine for report: " + stringArray[n] + " and view: " + string);
                } else if (!jReportEngine.afterInitParameter(engineExecuter)) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "failed to afterInitParameter for report: " + stringArray[n] + " and view: " + string);
                    }
                    bl = false;
                }
                ++n2;
            }
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.afterInitParameter(), return: " + bl);
        }
        return bl;
    }

    public void clearMem(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this + " rptName: " + string);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            Tools.logTrace(6, "no any report engye in report set engine.");
            Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        Vector vector = jRSReportEngine.I();
        if (vector != null && !vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                this.createEngineRuntimeInfo(string, string2);
                ++n;
            }
        }
        this.htReportEngine.remove(string);
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    private void createDemandQuery(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.resetParameter()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engye in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.resetParameter().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.resetParameter(string, string2);
        }
        Tools.logTrace(6, "End of JRptSetEngine.resetParameter().");
    }

    private void createDynamicQuery(String string, String string2) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.reset()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engye in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.reset().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.reset(string, string2);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "reset report set engine, cost time: " + (System.currentTimeMillis() - l) + " [ms]");
            JRLog.trace(6, "End of JRptSetEngine.reset().");
        }
    }

    private void createEngineRuntimeInfo(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engye in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.clearMem().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.clearMem(string, string2);
        }
        jRSReportEngine.clearMem(string2);
        this.I(string, string2);
        this.createNamingSystem(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    public synchronized void clearMem() {
        Object object;
        Enumeration enumeration;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this);
        }
        if (this.htReportEngine != null) {
            enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                object = (JRSReportEngine)this.htReportEngine.get(enumeration.nextElement());
                ((JRSReportEngine)object).clearMem();
            }
            if (this.htReportEngine != null) {
                this.htReportEngine.clear();
                this.htReportEngine = null;
            }
        }
        if (this.rptSetCenter != null) {
            this.rptSetCenter.clearMem();
            this.rptSetCenter = null;
        }
        this.ThreadException = null;
        this.UNKNOWN = null;
        this.rptSet = null;
        this.universe = null;
        if (this.addJavaFormula != null) {
            enumeration = this.addJavaFormula.keys();
            while (enumeration.hasMoreElements()) {
                object = (DynamicQueryInfo)this.addJavaFormula.get(enumeration.nextElement());
                if (this.getType() != 3 || ((DynamicQueryInfo)object).getResultSet() != null) {
                    // empty if block
                }
                ((DynamicQueryInfo)object).clearMem();
            }
            if (this.addJavaFormula != null) {
                this.addJavaFormula.clear();
                this.addJavaFormula = null;
            }
        }
        if (this.addParameterValue != null) {
            if (this.getType() != 3 || this.addParameterValue.getResultSet() != null) {
                // empty if block
            }
            this.addParameterValue.clearMem();
            this.addParameterValue = null;
        }
        if (this.applyNLSorDynamicStyle != null) {
            this.applyNLSorDynamicStyle = null;
        }
        if (this.asList != null) {
            this.asList.clear();
            this.asList = null;
        }
        if (this.asyncronizedSetPriority != null) {
            enumeration = this.asyncronizedSetPriority.keys();
            while (enumeration.hasMoreElements()) {
                object = (Hashtable)this.asyncronizedSetPriority.get(enumeration.nextElement());
                ((Hashtable)object).clear();
            }
            if (this.asyncronizedSetPriority != null) {
                this.asyncronizedSetPriority.clear();
                this.asyncronizedSetPriority = null;
            }
        }
        if (!(this instanceof JSubRptSetEngine) && this.booleanValue != null) {
            this.booleanValue.clearMem();
        }
        if (!(this instanceof JSubRptSetEngine) && this.dataEngine != null) {
            try {
                this.dataEngine.close();
            }
            catch (DSException dSException) {
                Tools.logTrace(6, dSException);
            }
            this.dataEngine = null;
        }
        if (this.secCxt != null) {
            this.secCxt = null;
        }
        this.parentReportEngine = null;
        this.checkSubReportLoop = null;
        this.clear = null;
        this.clearEngine = null;
        if (this.rsdInforForRptSet != null) {
            this.rsdInforForRptSet.clearMem();
            this.rsdInforForRptSet = null;
            if (!(this instanceof JSubRptSetEngine) && this.add != null) {
                this.add.clearMem();
                this.add = null;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.getListeners().size()) {
            ThreadErrorListener threadErrorListener = (ThreadErrorListener)this.getListeners().elementAt(n);
            threadErrorListener.ThreadException(thread, throwable);
            ++n;
        }
    }

    public void started() {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.getListeners().size()) {
            EngineListener engineListener = (EngineListener)this.getListeners().elementAt(n);
            engineListener.started();
            ++n;
        }
    }

    public void finished() {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.getListeners().size()) {
            EngineListener engineListener = (EngineListener)this.getListeners().elementAt(n);
            engineListener.finished();
            ++n;
        }
    }

    public void displayStructure() {
        if (JRLog.isTrace(6)) {
            Object object;
            Object object2;
            JRLog.trace(6, "report set name: " + this.rptSetCenter.getRptSetName());
            JRLog.trace(6, "==>rptSetEngine: " + this + " rptSetCenter: " + this.rptSetCenter);
            Enumeration enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (JRSReportEngine)this.htReportEngine.get(object2);
                JRLog.trace(6, "  ==>rptName: " + (String)object2 + " rptEngine: " + object + " reportCenter: " + this.rptSetCenter.getReportCenter((String)object2));
            }
            JRLog.trace(6, "");
            JRLog.trace(6, "==>rptSetCenter: " + this.rptSetCenter + " rptCenters: ");
            object2 = this.htReportEngine.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                ReportCenter reportCenter = ((JRSReportEngine)this.htReportEngine.get(object)).getReportCenter();
                JRLog.trace(6, "  ==>rptName: " + (String)object + " reportCenter: " + reportCenter + " rptSetCenter: " + reportCenter.getRptSetCenter() + " rptViewCenters: " + reportCenter.getReportViewCenters());
                ReportViewCenter[] reportViewCenterArray = reportCenter.getReportViewCenters();
                int n = 0;
                while (n < reportViewCenterArray.length) {
                    JRLog.trace(6, "    viewName: " + reportViewCenterArray[n].getViewName() + " viewCenter: " + reportViewCenterArray[n] + " rptCenter: " + reportViewCenterArray[n].getRptCenter());
                    ++n;
                }
            }
        }
    }

    public void preinitMainEngine() throws EngingPreinitException {
        Tools.logTrace(6, "JRptSetEngine.preinitMainEngine()...");
        this.preinitMainEngine(false);
    }

    public void preinitEngine() throws EngingPreinitException, JRScheduleException {
        this.preinitEngine(false);
    }

    public void preinitEngine(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException, JRScheduleException {
        this.preinitEngine(stringArray, vectorArray, false);
    }

    public void initRunEngine() {
        this.initRunEngine(false);
    }

    public void initRunEngine(String[] stringArray, Vector[] vectorArray) {
        this.initRunEngine(stringArray, vectorArray, false);
    }

    public Thread[] getAllThreads() {
        Object object;
        Tools.logTrace(6, "JRptSetEngine.getAllThreads()...");
        Vector<Object> vector = new Vector<Object>();
        if (this.htReportEngine != null && !this.htReportEngine.isEmpty()) {
            Tools.logTrace(6, "get threads from JReportEngine...");
            object = this.htReportEngine.keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(e);
                Thread[] threadArray = jRSReportEngine.Z();
                if (threadArray == null && threadArray.length == 0) continue;
                int n = 0;
                while (n < threadArray.length) {
                    Tools.logTrace(6, "thread: " + threadArray[n]);
                    vector.addElement(threadArray[n]);
                    ++n;
                }
            }
            Tools.logTrace(6, "End of get threads from JReportEngine.");
        }
        if (!(this instanceof JSubRptSetEngine) && this.dataEngine != null) {
            Tools.logTrace(6, "get threads from data engine...");
            object = this.dataEngine.getAllThreads();
            if (object != null && ((Object)object).length > 0) {
                int n = 0;
                while (n < ((Object)object).length) {
                    Tools.logTrace(6, "thread: " + object[n]);
                    vector.addElement(object[n]);
                    ++n;
                }
            }
            Tools.logTrace(6, "end of get threads from data engine.");
        }
        object = vector.toArray(new Thread[vector.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getAllThreads()..., return: " + Tools.toString(object));
        }
        return object;
    }

    private void createGroupQuery(Hashtable hashtable, String string, String string2) {
        if (hashtable != null && hashtable.containsKey(string)) {
            Vector vector = (Vector)hashtable.get(string);
            vector.remove(string2);
            if (vector.isEmpty()) {
                hashtable.remove(string);
            }
        }
    }

    void I(String string, String string2) {
        this.createGroupQuery(this.deepDupWithName, string, string2);
    }

    private void createNamingSystem(String string, String string2) {
        this.createGroupQuery(this.denyAllColumns, string, string2);
    }

    private void createResultSet() {
        if (this.deepDupWithName != null && !this.deepDupWithName.isEmpty()) {
            Enumeration enumeration = this.deepDupWithName.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.deepDupWithName.get(string);
                vector.clear();
            }
            this.deepDupWithName.clear();
        }
    }

    private void createViewEngine() {
        this.currentThread(this.denyAllColumns);
    }

    private void currentThread(Hashtable hashtable) {
        if (hashtable != null && !hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(string);
                vector.clear();
            }
            hashtable.clear();
        }
    }

    private void currentTimeMillis(String[] stringArray, Vector[] vectorArray) {
        if (this.deepDupWithName == null) {
            this.deepDupWithName = new Hashtable();
        }
        this.dataDriver(this.deepDupWithName, stringArray, vectorArray);
    }

    private void cvIExpresstion(String[] stringArray, Vector[] vectorArray) {
        if (this.denyAllColumns == null) {
            this.denyAllColumns = new Hashtable();
        }
        this.dataDriver(this.denyAllColumns, stringArray, vectorArray);
    }

    private void dataDriver(Hashtable hashtable, String[] stringArray, Vector[] vectorArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], vectorArray[n].clone());
            ++n;
        }
    }

    public boolean isRunning() {
        Tools.logTrace(6, "JRptSetEngine.isRunning()...");
        if (this.deepDupWithName == null || this.deepDupWithName.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.isRunning(), no any report engines, return false.");
            return false;
        }
        if (!this.currentTimeMillis) {
            Tools.logTrace(6, "End of JRptSetEngine.isRunning(), no any report engines is running, return false.");
            return false;
        }
        Enumeration enumeration = this.deepDupWithName.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.deepDupWithName.get(string);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                JCommunicator jCommunicator = (JCommunicator)jReportEngine.getCommunicator();
                if (jCommunicator == null) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "End of JRptSetEngine.isRunning(), communicator of [" + string + "," + string2 + "] is still not generated, return true.");
                    }
                    return true;
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "rptName: " + string + " viewName: " + string2 + " communicator: " + jCommunicator);
                }
                if (!jCommunicator.isEngineFinished()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "End of JRptSetEngine.isRunning(), report [" + string + "," + string2 + "] is running, return true.");
                    }
                    return true;
                }
                Tools.logTrace(6, "engine is finished.");
                ++n;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.isRunning(), return false.");
        return false;
    }

    private boolean dataEngine(String string, String string2) {
        if (this.deepDupWithName == null) {
            return false;
        }
        Vector vector = (Vector)this.deepDupWithName.get(string);
        return vector != null && vector.contains(string2);
    }

    public boolean isStopping() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.isStopping()...");
            JRLog.trace(6, "End of JRptSetEngine.isStopping(), return: " + this.closeAllGroups);
        }
        return this.closeAllGroups;
    }

    public void setParamValues(Map map) throws JRScheduleException {
        String[] stringArray = this.booleanValue.setParamValues(map);
        if (stringArray == null && stringArray.length == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this.rptSetCenter.getDataSetNames();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String[] stringArray3 = this.rptSetCenter.getUsedParamNamesInDataSet(stringArray2[n2]);
            if (stringArray3 != null && stringArray3.length != 0) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    if (vector.contains(stringArray3)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    this.rptSetCenter.getDataSetCenter(stringArray2[n2]).closeRawData();
                    Hashtable hashtable = this.rptSetCenter.getRelatedComponents(stringArray2[n2]);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
                        Enumeration enumeration2 = hashtable2.keys();
                        while (enumeration2.hasMoreElements()) {
                            String string2 = (String)enumeration2.nextElement();
                            Vector vector2 = (Vector)hashtable2.get(string2);
                            if (vector2 == null || vector2.isEmpty()) continue;
                            ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(string, string2);
                            int n4 = 0;
                            while (n4 < vector2.size()) {
                                reportViewCenter.getForceExpiredTable().addDataContainer((String)vector2.elementAt(n2));
                                ++n4;
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public boolean changeParamValues(Map map) throws JRScheduleException {
        return this.getParameterManager().changeParamValues(map);
    }

    public void waitRunFinished(Map map) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.waitRunFinished()..., mReports: " + map);
        }
        if (map == null || map.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.waitRunFinished().");
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Vector vector = (Vector)map.get(string);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "wait finished on view engine, viewName: " + string2 + " engine: " + jReportEngine);
                }
                jReportEngine.waitFinished();
                ++n;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.waitRunFinished().");
    }

    private void deepDupWithName(Map map) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getOndemandLastPage()..., mReports: " + map);
        }
        if (map == null || map.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.getOndemandLastPage().");
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Vector vector = (Vector)map.get(string);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get ondemand last page, viewName: " + string2 + " engine: " + jReportEngine);
                }
                JCommunicator jCommunicator = null;
                try {
                    while (this.dataEngine(string, string2)) {
                        jCommunicator = (JCommunicator)jReportEngine.getCommunicator();
                        if (jCommunicator == null) {
                            Thread.sleep(50L);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    JRLog.error(2, interruptedException);
                }
                if (jCommunicator != null) {
                    try {
                        jCommunicator.getOnDemandLastPage();
                    }
                    catch (JRStopEngineException jRStopEngineException) {
                        Tools.logTrace(5, jRStopEngineException);
                    }
                }
                ++n;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.getOndemandLastPage().");
    }

    protected void initAllRawDataQueries() throws JRScheduleException {
        Enumeration enumeration = this.rptSetCenter.getAllDataSetName();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
            this.initRawDataQuery(dataSetCenter);
        }
    }

    public void processEngineForClosedRpt(String string) {
        this.clearEngine(string);
        this.getReportSetCenter().removeRptCenter(string);
        if (this.deepDupWithName != null) {
            this.deepDupWithName.remove(string);
        }
        if (this.denyAllColumns != null) {
            this.denyAllColumns.remove(string);
        }
    }

    public boolean hasReportViewEngine(String string, String string2) {
        return this.getReportViewEngine(string, string2) != null;
    }

    JetRptReportSet denyAllColumns() throws JRScheduleException {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (this.htReportEngine == null) {
            return this.rptSet;
        }
        JetRptReportSet jetRptReportSet = (JetRptReportSet)this.rptSet.deepDupWithName();
        jetRptReportSet.createNamingSystem();
        jetRptReportSet.setUniverse(this.getMainRptSetEngine().getUniverse());
        jetRptReportSet.setFullFileName(this.rptSet.getFullFileName());
        String[] stringArray = jetRptReportSet.getAllReportsName();
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object3 = jetRptReportSet.getReport(stringArray[n3]);
            if (!this.htReportEngine.containsKey(stringArray[n3])) {
                jetRptReportSet.removeReport(stringArray[n3]);
            } else {
                String[] stringArray2 = jetRptReportSet.getAllRptViewNames(stringArray[n3]);
                object2 = (JRSReportEngine)this.htReportEngine.get(stringArray[n3]);
                n = stringArray2 == null ? 0 : stringArray2.length;
                int n4 = 0;
                while (n4 < n) {
                    if (((JRSReportEngine)object2).getViewEngine(stringArray2[n4]) == null) {
                        object = ((JetRptReport)object3).getViewObject(stringArray2[n4]);
                        ((JetRptReportPanel)object3).remove((JetObject)object);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        this.elementAt(jetRptReportSet);
        object3 = new ArrayList();
        stringArray = jetRptReportSet.getAllReportsName();
        int n5 = 0;
        while (stringArray != null && n5 < stringArray.length) {
            object2 = jetRptReportSet.getReport(stringArray[n5]);
            String string = ((JetRptReport)object2).getCurViewName();
            ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray[n5], string);
            if (!this.isRsd() && !this.isBurstingRsd()) {
                object = ObjectLogicFactory.getViewLogic();
                object.getReportViewForNLSOrDynamicStyle((JetRptReport)object2, reportViewCenter.getStyleGroup(), this.getFontMap(), this.getFontMapEncoding(), this.getFontMapLocale() == null ? this.getLocale() : this.getFontMapLocale(), this.getNLSBundleInfo(), this.getNLSMode(), false);
                JetRptView jetRptView = ((JetRptReport)object2).getViewObject(reportViewCenter.getViewName());
                if (jetRptView.getChildren() != null) {
                    jetRptView.getChildren().clear();
                }
            }
            object = reportViewCenter.getUsedDataSet();
            ((Vector)object).removeAll((Collection<?>)object3);
            ((ArrayList)object3).addAll(object);
            ++n5;
        }
        object2 = jetRptReportSet.getAllDataSet();
        n = 0;
        while (object2 != null && n < ((DataSet[])object2).length) {
            String string = object2[n].getName();
            if (!((ArrayList)object3).contains(string)) {
                jetRptReportSet.remomeDataSet((JetRptDataSet)object2[n]);
            } else {
                try {
                    object2[n].setPreIExpression(null);
                    object2[n].setIExpression(null);
                }
                catch (ConditionException conditionException) {
                    throw new JRScheduleException(220074, new String[]{string}, conditionException);
                }
            }
            ++n;
        }
        return jetRptReportSet;
    }

    void disable(JetRptReportSet jetRptReportSet) {
        if (!this.isDHTML() || !this.isDhtmlInteract()) {
            return;
        }
        Vector vector = this.getAllReportViewEngines();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            JetObject jetObject;
            int n2;
            String[] stringArray;
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n);
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            HashMap hashMap = reportViewCenter.getBrowseFilters();
            if (hashMap != null) {
                stringArray = hashMap.keySet().toArray(new String[0]);
                n2 = 0;
                while (n2 < stringArray.length) {
                    jetObject = jetRptReportSet.nameToObject(stringArray[n2]);
                    if (jetObject != null && jetObject instanceof JetRptDataContainer) {
                        object = reportViewCenter.getBrowseFilter(stringArray[n2]);
                        CvIExpression cvIExpression = new CvIExpression();
                        JetFilterExpression jetFilterExpression = null;
                        try {
                            jetFilterExpression = cvIExpression.cvIExpresstion((IExpression)object);
                        }
                        catch (ConditionException conditionException) {
                            JRLog.error(2, 220019, new Object[]{object}, (Throwable)conditionException);
                        }
                        ((JetFilterExpLogic)((Object)ObjectLogicFactory.getDataContainerLogic())).setBrowserJetFilterExpression((JetRptDataContainer)jetObject, jetFilterExpression, 4098);
                    }
                    ++n2;
                }
            }
            if ((hashMap = reportViewCenter.getRptSortContainers()) != null) {
                stringArray = hashMap.keySet().toArray(new String[0]);
                n2 = 0;
                while (n2 < stringArray.length) {
                    jetObject = jetRptReportSet.nameToObject(stringArray[n2]);
                    if (ReportTools.supportBrowseAction(jetObject)) {
                        object = reportViewCenter.getBrowseSortContainer(stringArray[n2]);
                        this.displayStructure((JetRptDataContainer)jetObject, (JetRptSortContainer)object);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private JetRptSortContainer displayStructure(JetRptDataContainer jetRptDataContainer, JetRptSortContainer jetRptSortContainer) {
        JetRptSortContainer jetRptSortContainer2 = this.doCLS(jetRptDataContainer);
        if (jetRptSortContainer2 != null) {
            this.doRequestRunReport(jetRptDataContainer);
        }
        if (jetRptSortContainer == null) {
            return null;
        }
        return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().add(jetRptDataContainer, jetRptSortContainer);
    }

    private JetRptSortContainer doCLS(JetRptDataContainer jetRptDataContainer) {
        Vector vector = jetRptDataContainer.getChildren();
        int n = 0;
        while (vector != null && n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JetRptSortContainer) {
                return (JetRptSortContainer)e;
            }
            ++n;
        }
        return null;
    }

    private JetRptSortContainer doRequestRunReport(JetRptDataContainer jetRptDataContainer) {
        Vector vector = jetRptDataContainer.getChildren();
        int n = 0;
        while (vector != null && n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof JetRptSortContainer) {
                return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)e);
            }
            ++n;
        }
        return null;
    }

    private void elementAt(JetRptReportSet jetRptReportSet) {
        String string = jetRptReportSet.getCurReportId();
        String[] stringArray = jetRptReportSet.getAllReportsName();
        int n = stringArray == null ? 0 : stringArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n2]);
            if (jetRptReport != null) {
                if (string.equals(stringArray[n2])) {
                    bl = true;
                }
                jetRptReport.setStatus(0);
                String[] stringArray2 = jetRptReportSet.getAllRptViewNames(stringArray[n2]);
                int n3 = stringArray2 == null ? 0 : stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[n4]);
                    jetRptView.setStatus(0);
                    ++n4;
                }
            }
            ++n2;
        }
        if (!bl) {
            jetRptReportSet.setCurReportId(stringArray[0]);
        }
    }

    public void runReport(String[] stringArray, Vector[] vectorArray, int n, Map map) throws JRScheduleException {
        String[] stringArray2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " level: " + n + " mParams: " + map);
            JRLog.trace(6, "parameter buffer: " + this.getParameterManager().getParamBuff());
        }
        String[] stringArray3 = this.getAllDataSet(stringArray, vectorArray);
        Vector<String> vector = new Vector<String>();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "used data set: " + Tools.toString(stringArray3));
        }
        int n2 = 0;
        while (stringArray3 != null && n2 < stringArray3.length) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray3[n2]);
            if (!dataSetCenter.hasBackupedDataStatus()) {
                dataSetCenter.backupDataStatus(this.rptSetCenter);
                if (!vector.contains(stringArray3[n2])) {
                    vector.addElement(stringArray3[n2]);
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                if (!this.genValidValues(stringArray, vectorArray)) break;
                this.runReport(stringArray, vectorArray, 5, map);
                return;
            }
            case 1: {
                if (!this.genValidValues(stringArray, vectorArray)) break;
                this.runReport(stringArray, vectorArray, 5, map);
                return;
            }
            case 2: 
            case 6: {
                this.get(stringArray, vectorArray);
                int n3 = 0;
                while (stringArray3 != null && n3 < stringArray3.length) {
                    DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray3[n3]);
                    dataSetCenter.backupDataStatus(this.rptSetCenter);
                    ++n3;
                }
                this.getAllDataContainerNames(stringArray3);
                this.getAllDataContainerInstNames(stringArray3);
                this.runReport(stringArray, vectorArray);
                JRLog.trace(6, "after run report with reload_datasource level.");
                JRLog.trace(6, "End of JRptSetEngine.runReport().");
                return;
            }
            case 4: {
                throw new JRScheduleException(0, new String[]{String.valueOf(n)}, null);
            }
            case 5: {
                this.get(stringArray, vectorArray);
                break;
            }
            default: {
                throw new JRScheduleException(0, new String[]{String.valueOf(n)}, null);
            }
        }
        JRLog.trace(6, "check data sets...");
        int n4 = 0;
        while (stringArray3 != null && n4 < stringArray3.length) {
            stringArray2 = this.rptSetCenter.getDataSetCenter(stringArray3[n4]);
            if (!stringArray2.equalsForRawData(this.rptSetCenter)) {
                stringArray2.backupDataStatus(this.rptSetCenter);
                if (!vector.contains(stringArray3[n4])) {
                    vector.addElement(stringArray3[n4]);
                }
            }
            ++n4;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "modified data sets: " + vector);
        }
        if (!vector.isEmpty()) {
            stringArray2 = vector.toArray(new String[0]);
            this.getAllDataContainerNames(stringArray2);
            this.getAllDataContainerInstNames(stringArray2);
            if (n == 0) {
                this.equals(stringArray2, stringArray, vectorArray);
            }
        } else if (n == 0) {
            stringArray2 = this.error(stringArray, vectorArray);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "runReportViewNames: " + stringArray2);
            }
            ReportViewNames reportViewNames = this.fetchGroup(stringArray, vectorArray, (ReportViewNames)stringArray2);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "resetRptViewNames: " + reportViewNames);
            }
            if (!reportViewNames.C()) {
                this.genRawDataQueryOption(reportViewNames);
            }
            if (!stringArray2.C()) {
                this.runReport(stringArray2.I(), stringArray2.Z(), 1, map);
                return;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "paint level and not use params, no equals dataDriver and record security, don't need apply nls, so don't need re-run");
                JRLog.trace(6, "End of JRptSetEngine.runReport().");
            }
            return;
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            String string = stringArray[n5];
            Vector vector2 = vectorArray[n5];
            int n6 = 0;
            while (n6 < vector2.size()) {
                String string2 = (String)vector2.elementAt(n6);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
                int n7 = 0;
                while (n7 < jSubReportEngineArray.length) {
                    ReportViewCenter reportViewCenter = jSubReportEngineArray[n7].getReportViewCenter();
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "apply nls for sub report: rptSetName: " + reportViewCenter.getRptCenter().getRptSetCenter().getRptSetName() + " rptName: " + reportViewCenter.getRptCenter().getRptName() + " viewName: " + reportViewCenter.getViewName());
                    }
                    JSubReportEngine jSubReportEngine = jSubReportEngineArray[n7];
                    jSubReportEngine.getReportViewCenter().applyNLSorDynamicStyle();
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        this.runReport(stringArray, vectorArray);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    private void equals(String[] stringArray, String[] stringArray2, Vector[] vectorArray) {
        int n = 0;
        while (n < stringArray.length) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n]);
            dataSetCenter.clear();
            dataSetCenter.refresh(this.universe);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                ReportCenter reportCenter = this.rptSetCenter.getReportCenter(stringArray2[n2]);
                int n3 = 0;
                while (n3 < vectorArray[n2].size()) {
                    String string = (String)vectorArray[n2].elementAt(n3);
                    ReportViewCenter reportViewCenter = reportCenter.getReportViewCenter(string);
                    dataSetCenter.refresh(reportViewCenter);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void equalsForRawData(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n]);
            if (dataSetCenter != null) {
                dataSetCenter.clear();
                dataSetCenter.refresh(this.universe);
            }
            ++n;
        }
    }

    private ReportViewNames error(String[] stringArray, Vector[] vectorArray) {
        ReportViewNames reportViewNames = new ReportViewNames(this);
        ViewLogic viewLogic = ObjectLogicFactory.getViewLogic();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                JReportEngine jReportEngine;
                String string = (String)vectorArray[n].elementAt(n2);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get report view names to run, rptName: " + stringArray[n] + " viewName: " + string);
                }
                if (this.finished(jReportEngine = this.getReportViewEngine(stringArray[n], string), viewLogic)) {
                    reportViewNames.I(stringArray[n], string);
                }
                ++n2;
            }
            ++n;
        }
        return reportViewNames;
    }

    private ReportViewNames fetchGroup(String[] stringArray, Vector[] vectorArray, ReportViewNames reportViewNames) {
        ReportViewNames reportViewNames2 = new ReportViewNames(this);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get report view names to reset flag, rptName: " + stringArray[n] + " viewName: " + string + " exceptRptViewNames: " + reportViewNames);
                }
                if (!reportViewNames.Z(stringArray[n], string) && this.genRSDInfo(jReportEngine)) {
                    reportViewNames2.I(stringArray[n], string);
                }
                ++n2;
            }
            ++n;
        }
        return reportViewNames2;
    }

    private boolean finished(JReportEngine jReportEngine, ViewLogic viewLogic) {
        boolean bl;
        Object object;
        Tools.logTrace(6, "JRptSetEngine.needReRun()...");
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), view engine is null, return true.");
            return true;
        }
        Communicator communicator = jReportEngine.getCommunicator();
        if (communicator == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), communicator is null, return true.");
            return true;
        }
        if (!(!(communicator instanceof JCommunicator) || ((JCommunicator)(object = (JCommunicator)communicator)).isSuccess() && ((JCommunicator)object).isEngineFinished())) {
            Tools.logTrace(6, "End of JRptSetEngine.needRun(), communicator is not sucess or not finished, return true.");
            return true;
        }
        Tools.logTrace(6, "check nls.");
        if (viewLogic.canApplyNLS(jReportEngine.getReportViewCenter().getOriReportView(), this.getReportSet().getFullFileName(), this.getLocale())) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), need apply nls, return true.");
            return true;
        }
        Tools.logTrace(6, "check style group.");
        object = jReportEngine.getReportViewCenter();
        ReportCenter reportCenter = ((ReportViewCenter)object).getRptCenter();
        if (viewLogic.isCanApplyDynamicStyle(((ReportViewCenter)object).getOriReportView(), this.genDataDescription(reportCenter.getRptName(), ((ReportViewCenter)object).getViewName()))) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), need apply style group, return true.");
            return true;
        }
        boolean bl2 = bl = ((ReportViewCenter)object).getReportView() != ((ReportViewCenter)object).getOriReportView();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.needReRun(), return " + bl);
        }
        return bl;
    }

    private String genDataDescription(String string, String string2) {
        ReportInfo reportInfo = this.getRptInfo(string);
        if (reportInfo == null) {
            return null;
        }
        ReportViewInfo reportViewInfo = reportInfo.getRptViewInfo(string2);
        if (reportViewInfo == null) {
            return null;
        }
        return reportViewInfo.getStyleGroup();
    }

    private boolean genRSDInfo(JReportEngine jReportEngine) {
        Tools.logTrace(6, "JRptSetEngine.needResetFlag()...");
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), view engine is null, return false.");
            return false;
        }
        Communicator communicator = jReportEngine.getCommunicator();
        if (communicator == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), communicator is null, return false.");
            return false;
        }
        if (communicator instanceof JCommunicator) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), is JCommunicator, return true.");
            return true;
        }
        Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), return false.");
        return false;
    }

    private void genRawDataQueryOption(ReportViewNames reportViewNames) {
        if (reportViewNames.C()) {
            return;
        }
        String[] stringArray = reportViewNames.I();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = reportViewNames.I(stringArray[n]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], stringArray2[n2]);
                Communicator communicator = jReportEngine.getCommunicator();
                ((JCommunicator)communicator).setBeStopping(false);
                ++n2;
            }
            ++n;
        }
    }

    private boolean genValidValues(String[] stringArray, Vector[] vectorArray) {
        Object object;
        Object object2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.hasUsedParameters()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                object2 = this.rptSetCenter.getReportViewCenter(stringArray[n], string);
                object = ((ReportViewCenter)object2).getMappingFields(1);
                boolean bl2 = bl = object != null && !((Vector)object).isEmpty();
                if (bl) break;
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (bl) {
            return bl;
        }
        String[] stringArray2 = this.getAllDataSet(stringArray, vectorArray);
        if (stringArray2 != null) {
            int n3 = 0;
            while (n3 < stringArray2.length) {
                object2 = this.rptSetCenter.getDataSetCenter(stringArray2[n3]).getDataSet();
                object = ObjectLogicFactory.getDataSetLogic();
                Vector vector = object.getUsedParameterNames((JetRptDataSet)object2);
                if (vector != null && !vector.isEmpty()) {
                    bl = true;
                    break;
                }
                ++n3;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.hasUsedParameters(). return: " + bl);
        }
        return bl;
    }

    private void get(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.closeGroupDatas()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                jReportEngine.closeAllGroups();
                ++n2;
            }
            ++n;
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeGroupDatas().");
    }

    private void getAllAvailableGroupFieldName() {
        Tools.logTrace(6, "JRptSetEngine.closeAllGroupDatas()...");
        Vector vector = this.getAllReportViewEngines();
        if (vector != null && !vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n);
                jReportEngine.closeAllGroups();
                ++n;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeAllGroupDatas().");
    }

    private void getAllDataContainerInstNames(String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.closeRawDatas()..., dataSetNames: " + Tools.toString(stringArray));
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n]);
            dataSetCenter.closeRawData();
            ++n;
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeRawDatas().");
    }

    private void getAllDataContainerNames(String[] stringArray) {
        String[] stringArray2;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        String[] stringArray3 = this.getReportNames();
        if (stringArray3 != null && stringArray3.length > 0) {
            int n = 0;
            while (n < stringArray3.length) {
                JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray3[n]);
                stringArray2 = jRSReportEngine.getViewNames();
                if (stringArray2 != null && stringArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray3[n], stringArray2[n2]);
                        Vector vector = reportViewCenter.getUsedDataSet();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (vector != null && vector.contains(stringArray[n3])) {
                                Vector vector2 = hashMap.containsKey(stringArray3[n]) ? (Vector)hashMap.get(stringArray3[n]) : new Vector();
                                vector2.addElement(stringArray2[n2]);
                                hashMap.put(stringArray3[n], vector2);
                                break;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (!hashMap.isEmpty()) {
            stringArray3 = new String[hashMap.size()];
            Vector[] vectorArray = new Vector[hashMap.size()];
            int n = 0;
            stringArray2 = hashMap.keySet().iterator();
            while (stringArray2.hasNext()) {
                stringArray3[n] = (String)stringArray2.next();
                vectorArray[n] = (Vector)hashMap.get(stringArray3[n]);
                ++n;
            }
            this.get(stringArray3, vectorArray);
        }
    }

    private String[] getAllDataSet(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getUsedDataSetNames()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray[n], string);
                Vector vector2 = reportViewCenter.getUsedDataSet();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n3);
                    if (!vector.contains(string2)) {
                        vector.addElement(string2);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getUsedDataSetNames(). return: " + vector);
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected ParameterManager getParameterManager() {
        return this.booleanValue;
    }

    public void refreshParameter(Hashtable hashtable) {
        this.getParameterManager().refreshParameters(hashtable);
    }

    public JetRptReportSet createSubReportSet(String string) throws ReadFailureException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.createSubReportSet()..., subFullRptSetName: " + string);
            JRLog.trace(6, "main full rpt set name: " + this.rptSet.getFullFileName());
        }
        JetRptReportSet jetRptReportSet = null;
        if (string.equals(this.rptSet.getFullFileName())) {
            Tools.logTrace(6, "clone from main report set.");
            jetRptReportSet = this.getAllDataSetName(this.rptSet);
        } else {
            Tools.logTrace(6, "load from file system.");
            boolean bl = !this.isDHTML();
            JetRptReportSet jetRptReportSet2 = ReportTools.loadReportSet(string, "", bl, this.universe);
            if (bl) {
                jetRptReportSet = this.getAllDataSetName(jetRptReportSet2);
                jetRptReportSet2.free();
            } else {
                jetRptReportSet = jetRptReportSet2;
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.createSubReportSet()!");
        return jetRptReportSet;
    }

    private JetRptReportSet getAllDataSetName(JetRptReportSet jetRptReportSet) {
        JetRptReportSet jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
        jetRptReportSet2.setPath(jetRptReportSet.getPath());
        jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
        jetRptReportSet2.createNamingSystem();
        jetRptReportSet2.afterInit();
        return jetRptReportSet2;
    }

    public void addEngineRefreshListner(String string, String string2, EngineRefreshListener engineRefreshListener) {
        this.getReportEngine(string).getViewEngine(string2).addRefreshListener(engineRefreshListener);
    }

    public void SetShowValueForOneParamDesc(ParamDesc paramDesc) throws SQLException, ClassNotFoundException, InvalidParameterException {
        this.booleanValue.SetShowValueForOneParamDesc(paramDesc, this.rptSetCenter);
    }

    private void getAllLinkReportEngine(String[] stringArray, Vector[] vectorArray) {
        Vector vector;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.refreshPartialData(), this: " + this);
        }
        if ((vector = this.getReportViewEngines(stringArray, vectorArray)) == null || vector.isEmpty()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "view engines is " + (vector == null ? "null." : "empty."));
                JRLog.trace(6, "End of JRptSetEngine.refreshPartialData()!");
            }
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n);
            JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "subEngins: " + Tools.toString(jSubReportEngineArray));
            }
            if (jSubReportEngineArray != null) {
                int n2 = 0;
                while (n2 < jSubReportEngineArray.length) {
                    ReportViewCenter reportViewCenter = jSubReportEngineArray[n2].getReportViewCenter();
                    JetRptSubReport[] jetRptSubReportArray = jSubReportEngineArray[n2].getReportViewCenter().getSubReportsOfSubEngine();
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "subReports: " + Tools.toString(jetRptSubReportArray));
                    }
                    if (jetRptSubReportArray != null) {
                        ReportSetCenter reportSetCenter = reportViewCenter.getRptCenter().getRptSetCenter();
                        int n3 = 0;
                        while (n3 < jetRptSubReportArray.length) {
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "for viewEngine: " + n + " subEngine: " + n2 + " subReport: " + n3);
                            }
                            JetRptSubReport jetRptSubReport = jetRptSubReportArray[n3];
                            String[] stringArray2 = this.getAllMappingFields(reportViewCenter, jetRptSubReport);
                            int n4 = 0;
                            while (n4 < stringArray2.length) {
                                JetRptDataSet jetRptDataSet = reportViewCenter.getDataSet(stringArray2[n4]);
                                String string = jetRptDataSet.getDataSourceName();
                                String string2 = jetRptDataSet.getQueryName();
                                PartialData partialData = new PartialData(stringArray2[n4], reportViewCenter.getOriReportView(), jetRptSubReport);
                                if (JRLog.isTrace(6)) {
                                    JRLog.trace(6, "put PartialData for data set: " + stringArray2[n4]);
                                    JRLog.trace(6, "PartialData: " + partialData);
                                }
                                reportSetCenter.getDataSetCenter(stringArray2[n4]).putPartialData(partialData, this.universe);
                                ++n4;
                            }
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "end for viewEngine: " + n + " subEngine: " + n2 + " subReport: " + n3);
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Tools.logTrace(6, "End of JRptSetEngine.refreshPartialData()!");
    }

    private String[] getAllMappingFields(ReportViewCenter reportViewCenter, JetRptSubReport jetRptSubReport) {
        Vector<String> vector = new Vector<String>();
        List list = jetRptSubReport.getSubLinkContainers();
        if (list != null && !list.isEmpty()) {
            List list2 = this.getAllReportEngines(reportViewCenter);
            int n = 0;
            while (n < list.size()) {
                Vector vector2;
                JetRptSubLinkContainer jetRptSubLinkContainer = (JetRptSubLinkContainer)list.get(n);
                if (jetRptSubLinkContainer.targetCompInst != null && (vector2 = jetRptSubLinkContainer.targetCompInst.get()) != null && !vector2.isEmpty()) {
                    DataSet dataSet;
                    String string = (String)vector2.elementAt(0);
                    JetRptObject jetRptObject = (JetRptObject)reportViewCenter.getOriReportView().nameToObject(string);
                    if (jetRptObject != null && list2.contains(string) && (dataSet = ReportTools.getDataSet(jetRptObject)) != null && !vector.contains(dataSet.getName())) {
                        vector.addElement(dataSet.getName());
                    }
                }
                ++n;
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    private List getAllReportEngines(ReportViewCenter reportViewCenter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ContainerInfo[] containerInfoArray = reportViewCenter.getContainerInfos();
        if (containerInfoArray != null) {
            int n = 0;
            while (n < containerInfoArray.length) {
                String[] stringArray = containerInfoArray[n].getAllDataContainerInstNames();
                if (stringArray != null && stringArray.length > 0) {
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestRunReport(String[] var1_1, Vector[] var2_2) {
        var3_3 = 0L;
        if (JRLog.isTrace(6)) {
            var3_3 = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.requestRunReport()..., rptNames: " + Tools.toString(var1_1) + " vViewNames: " + Tools.toString(var2_2) + " this: " + this);
        }
        var5_4 = this.closeRawData;
        synchronized (var5_4) {
            block17: {
                block16: {
                    if (!this.isDHTML() || !this.isDhtmlPipeline() && !this.isOnDemandReport()) break block16;
                    var6_5 = 0;
                    if (true) ** GOTO lbl32
                }
                if (this.isRunning()) {
                    this.ThreadException(Thread.currentThread(), new JRScheduleException(220038));
                    Tools.logTrace(6, "End of JRptSetEngine.requestRunReport(), isRunning, return false!");
                    return false;
                }
                if (this.isStopping()) {
                    this.ThreadException(Thread.currentThread(), new JRScheduleException(220040));
                    Tools.logTrace(6, "End of JRptSetEngine.requestRunReport(), isStopping, return false!");
                    return false;
                }
                break block17;
                do {
                    var7_9 = 0;
                    while (var7_9 < var2_2[var6_5].size()) {
                        var8_10 = (String)var2_2[var6_5].elementAt(var7_9);
                        var9_11 = this.getReportViewEngine(var1_1[var6_5], var8_10);
                        if (var9_11 != null && (var10_12 = (JCommunicator)var9_11.getCommunicator()) != null && !var10_12.isEngineFinished()) {
                            if (this.isOnDemandReport()) {
                                var9_11.stopLayoutOnly();
                            }
                            var10_12.waitStreamEngineFinished();
                        }
                        ++var7_9;
                    }
                    ++var6_5;
lbl32:
                    // 2 sources

                } while (var6_5 < var1_1.length);
            }
            this.currentTimeMillis = true;
            this.createResultSet();
            this.currentTimeMillis(var1_1, var2_2);
            this.LOCAL_LANGUAGE(6);
            var6_8 = this.rptSetCenter.getUsedDataSet(var1_1, var2_2);
            var7_9 = 0;
            while (var7_9 < var6_8.size()) {
                var8_10 = (String)var6_8.elementAt(var7_9);
                var9_11 = this.rptSetCenter.getDataSetCenter(var8_10);
                try {
                    this.initRawDataQuery((DataSetCenter)var9_11);
                }
                catch (JRScheduleException var10_13) {
                    Tools.logTrace(5, "error: init raw data query for data set " + var8_10 + " failed!");
                    JRLog.error(2, var10_13);
                    if (this.clearSubEngines == null || this.clearSubEngines.isEmpty()) break block15;
                    var11_14 = this.rptSetCenter.getDataSetCenter(var8_10).getRawDataListener();
                    var12_16 = 0;
                    if (true) ** GOTO lbl66
                }
                ++var7_9;
            }
        }
        if (JRLog.isTrace(6) == false) return true;
        JRLog.trace(6, "requestRunReport, cost time: " + (System.currentTimeMillis() - var3_3) + "[ms]");
        JRLog.trace(6, "End of JRptSetEngine.requestRunReport(), return true!");
        return true;
        {
            block15: {
                do {
                    var13_17 = (EngineErrorListener)this.clearSubEngines.elementAt(var12_16);
                    if (var11_14.getError() != null) {
                        var11_14.notifyReceiver(var13_17);
                    } else {
                        var13_17.noteError(Thread.currentThread(), var10_13, 1, "failed to run data set!");
                    }
                    ++var12_16;
lbl66:
                    // 2 sources

                } while (var12_16 < this.clearSubEngines.size());
            }
            this.currentTimeMillis = false;
            this.createResultSet();
            this.getAllReportViewEngines(var1_1, var2_2);
            Tools.logTrace(6, "End of JRptSetEngine.requestRunReport(), failed init raw data query, return false!");
            return false;
        }
    }

    private void getAllReportViewEngines(String[] stringArray, Vector[] vectorArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string = (String)vectorArray[n].elementAt(n2);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[n], string);
                if (jReportEngine != null) {
                    jReportEngine.setErrorFlag();
                }
                ++n2;
            }
            ++n;
        }
    }

    public void ignoreRequestRunReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.ignoreRequestRunReport()..., rptName: " + string + " viewName: " + string2 + " this: " + this);
        }
        this.I(string, string2);
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        this.getAllReportViewEngines(new String[]{string}, vectorArray);
        Tools.logTrace(6, "End of JRptSetEngine.ignoreRequestRunReport().");
    }

    public void doRequestRunReport(String string, String string2, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.doRequestRunReport()..., rptName: " + string + " viewName: " + string2 + " this: " + this);
        }
        if (this.htReportEngine == null) {
            return;
        }
        if (!this.getAllReportsName(string, string2)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "report view don't be requested to run.");
                JRLog.trace(6, "End of JRptSetEngine.doRequestRunReport().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        jRSReportEngine.runReportView(new String[]{string2}, bl);
        Tools.logTrace(6, "End of JRptSetEngine.doRequestRunReport().");
    }

    public void doRequestRunReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.doRequestRunReport()..., rptName: " + string + " viewName: " + string2 + " this: " + this);
        }
        this.doRequestRunReport(string, string2, true);
        Tools.logTrace(6, "End of JRptSetEngine.doRequestRunReport().");
    }

    private boolean getAllReportsName(String string, String string2) {
        Vector vector;
        boolean bl = false;
        if (this.deepDupWithName != null && this.deepDupWithName.containsKey(string) && (vector = (Vector)this.deepDupWithName.get(string)).contains(string2)) {
            bl = true;
        }
        return bl;
    }

    public void free(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.free()..., rptName: " + string + " viewName: " + string2);
        }
        if (!this.getAllReportsName(string, string2)) {
            return;
        }
        if (this.htReportEngine == null) {
            return;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        jRSReportEngine.stop(string2);
        HashMap hashMap = new HashMap();
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        hashMap.put(string, vector);
        this.waitRunFinished(hashMap);
        jRSReportEngine.clear(string2);
        this.I(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.free().");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Tools.logTrace(6, "JRptSetEngine.free()...");
        if (this.htReportEngine == null) {
            return;
        }
        Object object = this.closeRawData;
        synchronized (object) {
            if (this.deepDupWithName != null) {
                String string;
                int n;
                JRSReportEngine jRSReportEngine;
                Vector vector;
                Object object2;
                Object object3;
                Iterator iterator = this.deepDupWithName.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    object2 = this.deepDupWithName;
                    synchronized (object2) {
                        vector = (Vector)this.deepDupWithName.get(object3);
                        if (!vector.isEmpty()) {
                            jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(object3);
                            n = vector.size();
                            while (n-- > 0) {
                                string = (String)vector.elementAt(n);
                                jRSReportEngine.stop(string);
                                if (jRSReportEngine.getViewEngine(string).getCommunicator() != null) continue;
                                vector.remove(n);
                            }
                        }
                        if (vector.isEmpty()) {
                            iterator.remove();
                        }
                    }
                }
                this.waitRunFinished(this.deepDupWithName);
                object3 = this.deepDupWithName.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    vector = (Vector)this.deepDupWithName.get(object2);
                    if (vector.isEmpty()) continue;
                    jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(object2);
                    n = 0;
                    while (n < vector.size()) {
                        string = (String)vector.elementAt(n);
                        jRSReportEngine.clear(string);
                        ++n;
                    }
                }
            }
            this.createResultSet();
            this.createViewEngine();
        }
        this.clearMem();
        Tools.logTrace(6, "End of JRptSetEngine.free().");
    }

    public void fillRptSetEngineInfo(ReportsetEngineInfo reportsetEngineInfo) {
        String[] stringArray;
        if (reportsetEngineInfo == null) {
            throw new NullPointerException();
        }
        if (!(this instanceof JSubRptSetEngine)) {
            stringArray = new DataEngineInfo();
            reportsetEngineInfo.setDataEngineInfo((DataEngineInfo)stringArray);
            if (this.dataEngine != null) {
                this.dataEngine.getEngineInfo((DataEngineInfo)stringArray);
            }
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        stringArray = this.getReportNames();
        reportsetEngineInfo.setUser(this.getUserName());
        reportsetEngineInfo.setRunningReportName(stringArray);
        Object var3_3 = null;
        Vector<ReportEngineInfo> vector = new Vector<ReportEngineInfo>();
        if (this.htReportEngine != null) {
            int n = 0;
            while (n < stringArray.length) {
                Vector vector2;
                JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[n]);
                if (jRSReportEngine != null && (vector2 = jRSReportEngine.I()) != null) {
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        String string = (String)vector2.elementAt(n);
                        JReportEngine jReportEngine = jRSReportEngine.getViewEngine(string);
                        if (jReportEngine != null) {
                            ReportEngineInfo reportEngineInfo = new ReportEngineInfo();
                            vector.addElement(reportEngineInfo);
                            jReportEngine.getReportEngineInfo(reportEngineInfo);
                            reportEngineInfo.setEngineName(stringArray[n]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        reportsetEngineInfo.setReportEngineInfo(vector.toArray(new ReportEngineInfo[vector.size()]));
    }

    private ReportViewInfo getAllRptViewNames(String string, String string2) {
        ReportViewInfo reportViewInfo;
        ReportInfo reportInfo;
        if (this.close == null) {
            this.close = new HashMap();
        }
        if ((reportInfo = (ReportInfo)this.close.get(string)) == null) {
            reportInfo = new ReportInfo();
            this.close.put(string, reportInfo);
        }
        if ((reportViewInfo = reportInfo.getRptViewInfo(string2)) == null) {
            reportViewInfo = new ReportViewInfo();
            reportInfo.setRptViewInfo(string2, reportViewInfo);
        }
        return reportViewInfo;
    }

    public void setRuntimeInfo(String string, String string2, RuntimeInfo runtimeInfo) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setRuntimeInfo()..., rptName: " + string + " viewName: " + string2 + " runtimeInfo: " + runtimeInfo);
        }
        this.getAllRptViewNames(string, string2).setRuntimeInfo(EngineRuntimeInfo.createEngineRuntimeInfo(runtimeInfo));
    }

    public RuntimeInfo getRuntimeInfo(String string, String string2) {
        ReportViewInfo reportViewInfo;
        RuntimeInfo runtimeInfo = null;
        ReportInfo reportInfo = this.getRptInfo(string);
        if (reportInfo != null && (reportViewInfo = reportInfo.getRptViewInfo(string2)) != null) {
            runtimeInfo = reportViewInfo.getRuntimeInfo();
        }
        if (runtimeInfo == null) {
            runtimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
            this.setRuntimeInfo(string, string2, runtimeInfo);
        } else {
            runtimeInfo = EngineRuntimeInfo.createEngineRuntimeInfo(runtimeInfo);
        }
        return runtimeInfo;
    }

    public void setStreamFactory(String string, InputStreamFactory inputStreamFactory) throws JRScheduleException {
        JetUDatabase jetUDatabase = this.universe.getDatabase(string);
        if (jetUDatabase == null) {
            throw new JRScheduleException(220058, new String[]{string}, null);
        }
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection == null) {
            throw new JRScheduleException(220059, new String[]{string}, null);
        }
        if (!(jetUConnection instanceof JetUXMLConnection)) {
            throw new JRScheduleException(220060, new String[]{string}, null);
        }
        this.rptSetCenter.getDataSourceInfo(string).setStreamFactory(inputStreamFactory);
    }

    protected InputStreamFactory getStreamFactory(String string) {
        return this.rptSetCenter.getDataSourceInfo(string).getStreamFactory();
    }

    public void setStreamFactory(String string, String string2, InputStreamFactory inputStreamFactory) throws JRScheduleException {
        JetUQueriable jetUQueriable = this.universe.getQueriableByResourceName(string, string2);
        if (jetUQueriable == null) {
            throw new JRScheduleException(220061, new String[]{string, string2}, null);
        }
        if (!(jetUQueriable instanceof JetUHierDataSource)) {
            throw new JRScheduleException(220062, new String[]{string, string2}, null);
        }
        this.rptSetCenter.getQueryInfo(string, string2).setStreamFactory(inputStreamFactory);
    }

    public InputStreamFactory getStreamFactory(String string, String string2) {
        return this.rptSetCenter.getQueryInfo(string, string2).getStreamFactory();
    }

    public JdbcDriversConfig getJdbcDriversCfg() {
        return this.create;
    }

    public void applyStyleNls(String string, String string2) {
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (jRSReportEngine != null) {
            jRSReportEngine.I(string2, true);
        }
    }

    public void registReportView(JetRptReport jetRptReport) {
        if (jetRptReport == null) {
            throw new NullPointerException();
        }
        int n = jetRptReport.hashCode();
        if (this.clone == null) {
            this.clone = new IntVector();
        } else if (this.clone.contains(n)) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "schedule error, can't regist same view multi times, detail info:\n" + new Exception());
            }
            return;
        }
        this.clone.addElement(n);
    }

    public boolean hasRegisted(JetRptReport jetRptReport) {
        return this.clone != null && this.clone.contains(jetRptReport.hashCode());
    }

    public static final String getFixedAlias(JetRptReport jetRptReport) {
        return "alias_" + jetRptReport.hashCode();
    }

    public AccessController getAccessController() {
        AccessController accessController = null;
        if (this.isRsd()) {
            String[] stringArray = this.getRSDInfo().getDeniedBLNames(1);
            accessController = AccessControllerFactory.createAccessController(stringArray);
        } else {
            int n;
            JetRptReportSet jetRptReportSet;
            String string = this.getUserName();
            String string2 = this.getUniverse().getFullFileName();
            if (string2 == null && (jetRptReportSet = this.getReportSet()).isBoundled()) {
                string2 = jetRptReportSet.getFullFileName();
            }
            if (string2 == null && ((n = this.getType()) == 1 || n == 2 || n == 3)) {
                JetRptReportSet jetRptReportSet2 = this.getReportSet();
                string2 = jetRptReportSet2.getFullFileName();
            }
            accessController = AccessControllerFactory.createAccessController(string, string2);
        }
        return accessController;
    }

    public void setIsDhtmlPipeline(boolean bl) {
        this.createDataEngine = bl;
    }

    public boolean isDhtmlPipeline() {
        return this.createDataEngine;
    }

    private Object getAllSubRptSetEngine() {
        return this.isDhtmlInteract() ? null : (this.getType() == 1 || this.getType() == 2 ? null : this.getPriorityLocker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPriority(int n) {
        Object object = this.getAllSubRptSetEngine();
        if (object == null) {
            this.asyncronizedSetPriority(n);
        } else {
            Object object2 = object;
            synchronized (object2) {
                this.asyncronizedSetPriority(n);
            }
        }
    }

    protected void asyncronizedSetPriority(int n) {
        this.createDemandQuery = n;
        if (this.dataEngine != null) {
            try {
                this.dataEngine.setThreadPriority(n);
            }
            catch (DSException dSException) {
                Tools.logTrace(5, dSException);
            }
        }
        Vector vector = this.getAllReportViewEngines();
        int n2 = 0;
        while (vector != null && n2 < vector.size()) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(n2);
            jReportEngine.setThreadPriority(n);
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            JSubRptSetEngine[] jSubRptSetEngineArray = reportViewCenter.getAllSubRptSetEngine();
            int n3 = 0;
            while (n3 < jSubRptSetEngineArray.length) {
                jSubRptSetEngineArray[n3].asyncronizedSetPriority(n);
                ++n3;
            }
            JREngine[] jREngineArray = reportViewCenter.getAllLinkReportEngine();
            int n4 = 0;
            while (n4 < jREngineArray.length) {
                JRptSetEngine jRptSetEngine = jREngineArray[n4].getRptSetEngine();
                if (jRptSetEngine != null) {
                    jRptSetEngine.asyncronizedSetPriority(n);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public int getPriority() {
        return this.createDemandQuery;
    }

    public void setDhtmlInteract(boolean bl) {
        this.createDynamicQuery = bl;
    }

    public boolean isDhtmlInteract() {
        return this.createDynamicQuery;
    }

    public Object getPriorityLocker() {
        switch (this.getType()) {
            case 0: {
                return this.priorityLocker;
            }
            case 2: {
                return this.priorityLocker;
            }
            case 1: {
                JRptSetEngine jRptSetEngine = this.getRootRptSetEngine();
                return jRptSetEngine == null ? null : jRptSetEngine.priorityLocker;
            }
        }
        return null;
    }

    protected JRptSetEngine getRootRptSetEngine() {
        JRptSetEngine jRptSetEngine = this;
        while (jRptSetEngine != null && (jRptSetEngine.getType() == 1 || jRptSetEngine.getType() == 2)) {
            JReportEngine jReportEngine = jRptSetEngine.getParentEngine();
            JRptSetEngine jRptSetEngine2 = jRptSetEngine = jReportEngine == null ? null : jReportEngine.getRptSetEngine();
        }
        return jRptSetEngine;
    }

    public void getAllReports(Map map) {
        Vector vector = this.getAllReportEngines();
        JRSReportEngine[] jRSReportEngineArray = vector.toArray(new JRSReportEngine[vector.size()]);
        int n = 0;
        while (n < jRSReportEngineArray.length) {
            map.put(jRSReportEngineArray[n].getReport(), jRSReportEngineArray[n].getReport().getDisplayName());
            Vector vector2 = jRSReportEngineArray[n].getViewEngines();
            JReportEngine[] jReportEngineArray = vector2 == null ? new JReportEngine[]{} : vector2.toArray(new JReportEngine[vector2.size()]);
            int n2 = 0;
            while (n2 < jReportEngineArray.length) {
                JSubReportEngine[] jSubReportEngineArray = jReportEngineArray[n2].getReportViewCenter().getAllSubReportEngine();
                if (jSubReportEngineArray != null) {
                    int n3 = 0;
                    while (n3 < jSubReportEngineArray.length) {
                        JetRptReport jetRptReport = jSubReportEngineArray[n3].getReportCenter().getReport();
                        map.put(jetRptReport, jetRptReport.getDisplayName());
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected boolean isBursting() {
        return this.createEngineRuntimeInfo;
    }

    /*
     * Unable to fully structure code
     */
    public boolean requestRunBurstingReport(BurstingSchema[] var1_1, DataBlock[] var2_2, boolean var3_3) throws JRScheduleException {
        var4_4 = 0L;
        if (JRLog.isTrace(6)) {
            var4_4 = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.requestRunBurstingReport()...,  bs: " + Tools.toString(var1_1) + " dataBlocks: " + Tools.toString(var2_2) + " isBurstingFunction: " + var3_3 + " this: " + this);
        }
        if (!this.isBursting()) {
            throw new JRScheduleException(220075);
        }
        this.getAllSubRptSetEngines(var1_1, var2_2, true);
        this.createNamingSystem = var3_3;
        if (var2_2 != null) {
            var6_5 = 0;
            while (var6_5 < var2_2.length) {
                block11: {
                    if (var2_2[var6_5] != null) {
                        block12: {
                            var7_7 = var2_2[var6_5].getDataSetName();
                            var8_8 = this.rptSetCenter.getDataSetCenter(var7_7);
                            var8_8.setDataBlock(var2_2[var6_5]);
                            try {
                                this.initRawDataQuery(var8_8);
                                break block11;
                            }
                            catch (JRScheduleException var9_9) {
                                Tools.logTrace(5, "error: failed to init raw data query for data set " + var7_7);
                                JRLog.error(2, var9_9);
                                if (this.clearSubEngines == null || this.clearSubEngines.isEmpty()) break block12;
                                var10_10 = this.rptSetCenter.getDataSetCenter(var7_7).getRawDataListener();
                                var11_11 = 0;
                                ** while (var11_11 < this.clearSubEngines.size())
                            }
lbl-1000:
                            // 1 sources

                            {
                                var12_12 = (EngineErrorListener)this.clearSubEngines.elementAt(var11_11);
                                if (var10_10.getError() != null) {
                                    var10_10.notifyReceiver(var12_12);
                                } else {
                                    var12_12.noteError(Thread.currentThread(), var9_9, 1, "failed to run data set!");
                                }
                                ++var11_11;
                                continue;
                            }
                        }
                        throw var9_9;
                    }
                }
                ++var6_5;
            }
        }
        this.currentTimeMillis = true;
        this.createResultSet();
        var6_6 = this.getReportNames();
        this.currentTimeMillis(var6_6, this.getViewNames(var6_6));
        this.createViewEngine = var1_1;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "requestRunBurstingReport, cost time: " + (System.currentTimeMillis() - var4_4) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.requestRunBurstingReport(), return true!");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void doRequestRunBurstingReport(DataBlock[] var1_1, String var2_2) {
        block26: {
            block27: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "JRptSetEngine.doRequestRunBurstingReport()...,  dataBlocks: " + Tools.toString(var1_1) + " currentBurstingSchemaName: " + var2_2 + " this: " + this);
                }
                if (!this.isBursting()) {
                    Tools.logTrace(4, new JRScheduleException(220075));
                    return;
                }
                if (this.htReportEngine == null) {
                    return;
                }
                try {
                    this.getAllSubRptSetEngines(this.createViewEngine, var1_1, false);
                    break block26;
                }
                catch (JRScheduleException var3_3) {
                    Tools.logTrace(5, var3_3);
                    if (this.clearSubEngines == null || this.clearSubEngines.isEmpty()) break block27;
                    var4_5 = 0;
                    ** while (var4_5 < this.clearSubEngines.size())
                }
lbl-1000:
                // 1 sources

                {
                    var5_7 = (EngineErrorListener)this.clearSubEngines.elementAt(var4_5);
                    var5_7.noteError(Thread.currentThread(), var3_3, 1, "Data blocks for bursting data sets are not enough.");
                    ++var4_5;
                    continue;
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport().");
            }
            this.createResultSet();
            return;
        }
        var3_4 = new String[var1_1.length];
        var4_6 = 0;
        while (var4_6 < var1_1.length) {
            var3_4[var4_6] = var1_1[var4_6].getDataSetName();
            ++var4_6;
        }
        var5_8 = this.getReportNames();
        var6_9 = this.getViewNames(var5_8);
        var7_10 = 0;
        while (var7_10 < var5_8.length) {
            var8_11 = 0;
            while (var8_11 < var6_9[var7_10].size()) {
                if (!this.getAllReportsName(var5_8[var7_10], (String)var6_9[var7_10].elementAt(var8_11))) {
                    this.createResultSet();
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "report view don't be requested to run.");
                        JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport().");
                    }
                    return;
                }
                ++var8_11;
            }
            ++var7_10;
        }
        var8_11 = 0;
        while (var8_11 < var5_8.length) {
            var9_12 = this.getReportEngine(var5_8[var8_11]);
            var10_14 = 0;
            while (var10_14 < var6_9[var8_11].size()) {
                var11_17 = (String)var6_9[var8_11].elementAt(var10_14);
                var12_19 = var9_12.getViewEngine((String)var11_17);
                var13_21 = new ArrayList<E>();
                var14_23 = new ArrayList<String>(Arrays.asList(var3_4));
                var15_24 = var12_19.getReportViewCenter().getAllDataContainerNames();
                var16_25 = 0;
                while (var16_25 < var15_24.length) {
                    var17_26 = (JetRptDataContainer)var12_19.getReport().nameToObject(var15_24[var16_25]);
                    if (var17_26 != null && !var13_21.contains(var15_24[var16_25]) && (var18_27 = ReportTools.getDataSet(var17_26)) != null && var14_23.contains(var18_27.getName())) {
                        var13_21.add(var15_24[var16_25]);
                    }
                    ++var16_25;
                }
                var9_12.closeRelatedDataInstance((String)var11_17, var13_21.toArray(new String[var13_21.size()]));
                ++var10_14;
            }
            ++var8_11;
        }
        this.getAllDataContainerInstNames(var3_4);
        this.createResultSet = var2_2;
        var9_13 = 0;
        while (var9_13 < var3_4.length) {
            block28: {
                block29: {
                    var10_16 = this.rptSetCenter.getDataSetCenter(var3_4[var9_13]);
                    var10_16.setDataBlock(var1_1[var9_13]);
                    try {
                        this.initRawDataQuery(var10_16);
                        break block28;
                    }
                    catch (JRScheduleException var11_18) {
                        Tools.logTrace(5, "error: failed to init raw data query for data set " + var3_4[var9_13]);
                        JRLog.error(2, var11_18);
                        if (this.clearSubEngines == null || this.clearSubEngines.isEmpty()) break block29;
                        var12_19 = var10_16.getRawDataListener();
                        var13_22 = 0;
                        ** while (var13_22 < this.clearSubEngines.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var14_23 = (EngineErrorListener)this.clearSubEngines.elementAt(var13_22);
                        if (var12_19.getError() != null) {
                            var12_19.notifyReceiver((EngineErrorListener)var14_23);
                        } else {
                            var14_23.noteError(Thread.currentThread(), var11_18, 1, "failed to run data set!");
                        }
                        ++var13_22;
                        continue;
                    }
                }
                this.createResultSet();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport().");
                }
                return;
            }
            ++var9_13;
        }
        var10_15 = 0;
        while (var10_15 < var5_8.length) {
            var11_17 = (JRSReportEngine)this.htReportEngine.get(var5_8[var10_15]);
            var12_20 = 0;
            while (var12_20 < var6_9[var10_15].size()) {
                var13_21 = (String)var6_9[var10_15].elementAt(var12_20);
                var11_17.runReportView(new String[]{var13_21});
                ++var12_20;
            }
            ++var10_15;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport()!");
        }
    }

    private void getAllSubRptSetEngines(BurstingSchema[] burstingSchemaArray, DataBlock[] dataBlockArray, boolean bl) throws JRScheduleException {
        String[] stringArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.checkDataBlocks()..., burstingSchemas: " + Tools.toString(burstingSchemaArray) + " dataBlocks: " + Tools.toString(dataBlockArray) + " isShared: " + bl);
        }
        Vector vector = this.getAllReportViewEngines();
        String[] stringArray2 = null;
        int n = 0;
        while (n < vector.size()) {
            stringArray = (String[])vector.elementAt(n);
            if (ObjectLogicFactory.getReportLogic().isBurstingReport(stringArray.getReport())) {
                stringArray2 = stringArray;
                break;
            }
            ++n;
        }
        if (stringArray2 == null) {
            Tools.logTrace(5, "no bursting report, failed to check data blocks. ");
            return;
        }
        String[] stringArray3 = stringArray = bl ? this.getAllThreads(burstingSchemaArray) : this.getAllViewName(burstingSchemaArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "check data blocks for data sets: " + Tools.toString(stringArray));
        }
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            DataSetCenter dataSetCenter;
            if (!bl || (dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n2])).hasDbFieldOrPass1Formula() || dataSetCenter.hasConstantGlobalFormula()) {
                boolean bl2 = false;
                int n3 = 0;
                while (dataBlockArray != null && n3 < dataBlockArray.length) {
                    if (stringArray[n2].equals(dataBlockArray[n3].getDataSetName())) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl2) {
                    throw new JRScheduleException(bl ? 220077 : 220078, new String[]{stringArray[n2]}, null);
                }
            }
            ++n2;
        }
        Tools.logTrace(6, "End of JRptSetEngine.checkDataBlocks().");
    }

    private String[] getAllThreads(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < burstingSchemaArray.length) {
            String[] stringArray = burstingSchemaArray[n].getBurstingDataSetNames();
            if (n == 0) {
                String[] stringArray2 = burstingSchemaArray[n].getSharedDataSetNames();
                vector.addAll(Arrays.asList(stringArray));
                vector.addAll(Arrays.asList(stringArray2));
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!vector2.contains(stringArray[n2])) {
                    vector2.addElement(stringArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        vector.removeAll(vector2);
        return vector.toArray(new String[vector.size()]);
    }

    private String[] getAllViewName(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < burstingSchemaArray.length) {
            String[] stringArray = burstingSchemaArray[n].getBurstingDataSetNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!vector.contains(stringArray[n2])) {
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public RawDataQueryCreator getRawDataQueryCreator(String string) throws JRScheduleException {
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getRawDataQueryCreator()..., dataSetName: " + string);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            throw new JRScheduleException(250009, new String[]{string}, null);
        }
        EngineRawDataQueryCreator engineRawDataQueryCreator = new EngineRawDataQueryCreator(this, string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getRawDataQueryCreator(), return: " + engineRawDataQueryCreator);
        }
        return engineRawDataQueryCreator;
    }

    public synchronized void setSortMemorySize(int n) {
        this.createGroupQuery = n;
    }

    public synchronized int getSortMemorySize() {
        return this.createGroupQuery;
    }

    public void stopLayout(String string, String string2) {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stopLayout()..., rptName: " + string + " viewName: " + string2);
        }
        if ((jReportEngine = this.getReportViewEngine(string, string2)) != null) {
            Tools.logTrace(6, "stop layout for report view engine");
            jReportEngine.stopLayoutOnly();
        }
        Tools.logTrace(6, "End of JRptSetEngine.stopLayout().");
    }

    public boolean isBurstingFunction() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.isBurstingFunction()..., return: " + this.createNamingSystem);
        }
        return this.createNamingSystem;
    }

    public String getCurrentBurstingSchemaName() {
        return this.createResultSet;
    }

    static JRawDataQuery access$000(JRptSetEngine jRptSetEngine, JDataEngine jDataEngine, int n, DataSetCenter dataSetCenter, boolean bl) throws JRScheduleException {
        return jRptSetEngine.UNKNOWN(jDataEngine, n, dataSetCenter, bl);
    }

    private class ReportViewNames {
        private Vector QOIV;
        private HashMap addElement;
        private final JRptSetEngine this$0;

        ReportViewNames(JRptSetEngine jRptSetEngine) {
            this.this$0 = jRptSetEngine;
            this.QOIV = new Vector();
            this.addElement = new HashMap();
        }

        void I(String string, String string2) {
            if (!this.QOIV.contains(string)) {
                this.QOIV.addElement(string);
                this.addElement.put(string, new String[]{string2});
            } else {
                String[] stringArray = (String[])this.addElement.get(string);
                String[] stringArray2 = new String[stringArray.length + 1];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray2[n] = stringArray[n];
                    ++n;
                }
                stringArray2[stringArray.length] = string2;
                this.addElement.put(string, stringArray2);
            }
        }

        boolean Z(String string, String string2) {
            if (!this.QOIV.contains(string)) {
                return false;
            }
            String[] stringArray = (String[])this.addElement.get(string);
            int n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        String[] I() {
            return this.QOIV.toArray(new String[this.QOIV.size()]);
        }

        Vector[] Z() {
            Vector[] vectorArray = new Vector[this.QOIV.size()];
            int n = 0;
            while (n < vectorArray.length) {
                vectorArray[n] = new Vector();
                String[] stringArray = (String[])this.addElement.get(this.QOIV.elementAt(n));
                int n2 = 0;
                while (n2 < stringArray.length) {
                    vectorArray[n].addElement(stringArray[n2]);
                    ++n2;
                }
                ++n;
            }
            return vectorArray;
        }

        String[] I(String string) {
            return (String[])this.addElement.get(string);
        }

        boolean C() {
            return this.QOIV == null || this.QOIV.isEmpty();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ReportViewNames:\n");
            stringBuffer.append(Tools.toString(this.QOIV) + "\n");
            int n = this.QOIV.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(Tools.toString((String[])this.addElement.get(this.QOIV.elementAt(n2))));
                stringBuffer.append(n2 < n - 1 ? "," : "\n");
                ++n2;
            }
            stringBuffer.append("End of ReportViewNames:\n");
            return stringBuffer.toString();
        }
    }

    private class EngineRawDataQueryCreator
    implements RawDataQueryCreator {
        private String QOIV;
        private final JRptSetEngine this$0;

        EngineRawDataQueryCreator(JRptSetEngine jRptSetEngine, String string) {
            this.this$0 = jRptSetEngine;
            this.QOIV = null;
            this.QOIV = string;
        }

        public JRawDataQuery createRawDataQuery(JDataEngine jDataEngine, int n, ISortExpression iSortExpression) throws DSException, JRScheduleException {
            DataSetCenter dataSetCenter;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "EngineRawDataQueryCreator.createRawDataQuery()..., rawDataQueryId: " + n + " dataSetName: " + this.QOIV);
            }
            if ((dataSetCenter = this.this$0.rptSetCenter.getDataSetCenter(this.QOIV)) == null) {
                throw new JRScheduleException(250009, new String[]{this.QOIV}, null);
            }
            JRawDataQuery jRawDataQuery = JRptSetEngine.access$000(this.this$0, jDataEngine, n, dataSetCenter, false);
            if (iSortExpression != null) {
                jRawDataQuery.setSorter(iSortExpression);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of EngineRawDataQueryCreator.createRawDataQuery(), return: " + jRawDataQuery);
            }
            return jRawDataQuery;
        }
    }
}

