/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.datatypes.JinfonetArray;
import com.jinfonet.datatypes.JinfonetBlob;
import com.jinfonet.datatypes.JinfonetClob;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.dataengine.api.DSException;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.JEnvironmentProperties;
import jet.ie.VersionRecord;
import jet.util.TempFile;

public class ResultSetTool {
    public static void writeResultSet(DataOutputStream dataOutputStream, ResultSet resultSet) throws IOException, DSException, SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JEnvironmentProperties jEnvironmentProperties = EnvironmentPropertiesFactory.getEnviromentProperties();
        String string = jEnvironmentProperties.getTemporaryPath();
        TempFile tempFile = new TempFile(string, "ResultSet", "tem");
        File file = tempFile.createTempFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        int n = resultSetMetaData.getColumnCount();
        long l = 0L;
        dataOutputStream.writeShort(n);
        JAttribute[] jAttributeArray = new JAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = resultSetMetaData.getColumnType(n2 + 1);
            dataOutputStream.writeInt(n3);
            String string2 = resultSetMetaData.getColumnName(n2 + 1);
            if (string2 == null) {
                string2 = "";
            }
            dataOutputStream.writeUTF(string2);
            int n4 = resultSetMetaData.getPrecision(n2 + 1);
            dataOutputStream.writeInt(n4);
            short s = (short)resultSetMetaData.getScale(n2 + 1);
            dataOutputStream.writeShort(s);
            short s2 = (short)resultSetMetaData.isNullable(n2 + 1);
            dataOutputStream.writeShort(s2);
            short s3 = (short)(n2 + 1);
            dataOutputStream.writeShort(s3);
            boolean bl = resultSetMetaData.isCurrency(n2 + 1);
            dataOutputStream.writeBoolean(bl);
            jAttributeArray[n2] = new Attribute(string2, Types.sqlTypeToType(n3), n4, s, n4, s2, bl);
            ++n2;
        }
        RelationMetaData relationMetaData = new RelationMetaData(jAttributeArray);
        VersionRecord versionRecord = new VersionRecord(relationMetaData);
        while (resultSet.next()) {
            int n5 = 0;
            ++l;
            int n6 = 1;
            while (n6 <= n) {
                switch (resultSetMetaData.getColumnType(n6)) {
                    case 2003: {
                        Array array = resultSet.getArray(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2003);
                            break;
                        }
                        versionRecord.putArray(new JinfonetArray(array));
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(3);
                            break;
                        }
                        versionRecord.putBigDecimal(bigDecimal);
                        break;
                    }
                    case 2004: {
                        Blob blob = resultSet.getBlob(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2004);
                            break;
                        }
                        versionRecord.putBlob(new JinfonetBlob(blob));
                        break;
                    }
                    case -7: 
                    case 16: {
                        boolean bl = resultSet.getBoolean(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-7);
                            break;
                        }
                        versionRecord.putBoolean(bl);
                        break;
                    }
                    case -6: {
                        byte by = resultSet.getByte(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-6);
                            break;
                        }
                        versionRecord.putByte(by);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = resultSet.getBytes(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-2);
                            break;
                        }
                        versionRecord.putBytes(byArray);
                        break;
                    }
                    case 2005: {
                        Clob clob = resultSet.getClob(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(2005);
                            break;
                        }
                        versionRecord.putClob(new JinfonetClob(clob));
                        break;
                    }
                    case 91: {
                        Date date = resultSet.getDate(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(91);
                            break;
                        }
                        versionRecord.putDate(new JinfonetDate(date.getTime()));
                        break;
                    }
                    case 8: {
                        double d = resultSet.getDouble(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(8);
                            break;
                        }
                        versionRecord.putDouble(d);
                        break;
                    }
                    case 6: {
                        float f = resultSet.getFloat(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(6);
                            break;
                        }
                        versionRecord.putFloat(f);
                        break;
                    }
                    case 4: {
                        int n7 = resultSet.getInt(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(4);
                            break;
                        }
                        versionRecord.putInt(n7);
                        break;
                    }
                    case -5: {
                        long l2 = resultSet.getLong(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(-5);
                            break;
                        }
                        versionRecord.putLong(l2);
                        break;
                    }
                    case 0: {
                        versionRecord.putNull(0);
                        break;
                    }
                    case 5: {
                        short s = resultSet.getShort(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(5);
                            break;
                        }
                        versionRecord.putLong(s);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        String string3 = resultSet.getString(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(12);
                            break;
                        }
                        versionRecord.putString(string3);
                        break;
                    }
                    case 92: {
                        Time time2 = resultSet.getTime(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(92);
                            break;
                        }
                        versionRecord.putTime(new JinfonetTime(time2.getTime()));
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = resultSet.getTimestamp(n6);
                        if (resultSet.wasNull()) {
                            versionRecord.putNull(93);
                            break;
                        }
                        versionRecord.putTimeStamp(new JinfonetTimeStamp(timestamp.getTime()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                ++n6;
            }
            n5 = versionRecord.getRecordSize();
            randomAccessFile.writeInt(n5);
            randomAccessFile.write(versionRecord.getRecordData(), 0, n5);
            versionRecord.reset();
        }
        randomAccessFile.close();
        dataOutputStream.writeLong(l);
        ResultSetTool.QOIV(dataOutputStream, file);
        file.delete();
    }

    private static void QOIV(DataOutputStream dataOutputStream, File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        long l = file.length();
        dataOutputStream.writeInt((int)l);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            dataOutputStream.write(n);
        }
        ((InputStream)bufferedInputStream).close();
    }

    public static ResultSet loadResultSet(DataInput dataInput) throws IOException, DSException {
        IRelationData iRelationData = ResultSetTool.loadIRelationData(dataInput);
        ResultSetTool resultSetTool = new ResultSetTool();
        resultSetTool.getClass();
        ResultSetAdapterRelationDataCanClose resultSetAdapterRelationDataCanClose = new ResultSetAdapterRelationDataCanClose(resultSetTool, iRelationData);
        return resultSetAdapterRelationDataCanClose;
    }

    public static IRelationData loadIRelationData(DataInput dataInput) throws IOException, DSException {
        int n = dataInput.readShort();
        JAttribute[] jAttributeArray = new JAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = Types.sqlTypeToType(dataInput.readInt());
            String string = dataInput.readUTF();
            if (string == "") {
                string = "NULL";
            }
            int n4 = dataInput.readInt();
            short s = dataInput.readShort();
            short s2 = dataInput.readShort();
            dataInput.readShort();
            boolean bl = dataInput.readBoolean();
            jAttributeArray[n2] = new Attribute(string, n3, n4, s, n4, s2, bl);
            ++n2;
        }
        RelationMetaData relationMetaData = new RelationMetaData(jAttributeArray);
        RelationPool relationPool = new RelationPool(null, relationMetaData);
        VersionRecord versionRecord = new VersionRecord(relationMetaData);
        long l = dataInput.readLong();
        dataInput.readInt();
        byte[] byArray = versionRecord.getRecordData();
        int n5 = 0;
        while ((long)n5 < l) {
            int n6 = dataInput.readInt();
            versionRecord.setDataLength(n6);
            if (byArray.length < n6) {
                versionRecord.resetRecordSize(n6);
                byArray = versionRecord.getRecordData();
            }
            dataInput.readFully(byArray, 0, n6);
            relationPool.appendRecord(versionRecord);
            ++n5;
        }
        relationPool.appendFinished();
        return relationPool;
    }

    class ResultSetAdapterRelationDataCanClose
    extends ResultSetAdapterRelationData {
        IRelationData QOIV;
        private final ResultSetTool this$0;

        public ResultSetAdapterRelationDataCanClose(ResultSetTool resultSetTool, IRelationData iRelationData) throws DSException {
            this.this$0 = resultSetTool;
            super(iRelationData);
            this.QOIV = iRelationData;
        }

        public void close() throws SQLException {
            super.close();
            try {
                this.QOIV.close();
            }
            catch (DSException dSException) {
                throw new SQLException(dSException.getMessage());
            }
        }
    }
}

