/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartLabel;
import chart.ChartLegend;
import chart.ChartPlatform;
import chart.chart2d.Chart2DPaper;
import chart.chart3d.Chart3DPaper;
import chart.data.Chart1DDataSet;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.Chart4DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.util.ChartHintLabel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChartHtmlMapExport {
    private ChartPlatform I;
    private ChartDataSetModel IsShowLabelTips;
    private ChartCoordinatePaper QOIV;
    private Shape[][] add;
    private Shape[] append;
    private Shape[] axisToHtml;
    private int bubbleObjectToHtml;
    private int charAt;
    private List currentSegment = new ArrayList();
    private List effect3DObjectToHtml = new ArrayList();
    private List equals = new ArrayList();
    public static final String TITLE = "title";
    public static final String SHAPE = "shape";
    public static final String COORDS = "coords";
    public static final String XVALUE = "xValue";
    public static final String ZVALUE = "zValue";
    public static final String XLINK = "xHyperLink";
    public static final String ZLINK = "zHyperLink";
    public static final String LINK = "hyperLink";
    public static final String INSTANCENAME = "instanceName";
    public static final String OBJECTTYPE = "objectType";
    public static final String PAPER = "paper";
    public static final String LEGEND = "legend";
    public static final String LABEL = "label";
    public static final String PLATFORM = "platform";
    private ChartLegend get;

    public ChartHtmlMapExport(ChartPlatform chartPlatform) {
        this.I = chartPlatform;
        this.IsShowLabelTips = chartPlatform.getDataSetModel();
        this.QOIV = chartPlatform.getChartCoordinatePaper();
        this.get = chartPlatform.getChartLegend();
    }

    public void exportDHTML(String string, String string2, String string3) {
        this.I(string, string2, string3);
    }

    public void exportHTML(String string, String string2, String string3) {
        this.I(string, string2, string3);
    }

    private void I(String string, String string2, String string3) {
        Point point = this.QOIV.getLocation();
        this.IsShowLabelTips(point);
        this.objectToHtml(point, string);
        this.axisToHtml(point, string2, string3);
    }

    private void IsShowLabelTips(Point point) {
        if (!this.get.getProperties().isShowTips()) {
            return;
        }
        int n = this.get.getOriLabels().length;
        Shape[] shapeArray = this.get.getLabelsShapes();
        Point point2 = this.get.getLocation();
        int n2 = 0;
        while (n2 < n) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(TITLE, this.get.getOriLabels()[n2].getText());
            this.getRectAreaString(shapeArray[n2], point2, hashMap);
            this.equals.add(hashMap);
            ++n2;
        }
    }

    public void objectToHtml(Point point, String string) {
        boolean bl = false;
        List list = this.IsShowLabelTips.getChartDataSets();
        int n = list.size();
        if (this.QOIV instanceof Chart2DPaper) {
            bl = ((Chart2DPaper)this.QOIV).getProperties().isReversePaintingOrder();
        }
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                ChartDataSet chartDataSet = (ChartDataSet)list.get(n2);
                this.bubbleObjectToHtml = chartDataSet.getSeriesSize();
                this.charAt = chartDataSet.getCategorySize();
                int n3 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n4 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                this.add = this.QOIV.getItemShapes(n2);
                if (this.add != null) {
                    block0 : switch (n4) {
                        case 0: {
                            switch (n3) {
                                case 9: {
                                    this.bubbleObjectToHtml(point, string, (Chart3DDataSet)chartDataSet, this.add);
                                    break block0;
                                }
                                case 4: {
                                    this.pieObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                                    break block0;
                                }
                                case 6: {
                                    this.guageObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                                    break block0;
                                }
                                case 10: {
                                    this.stockObjectToHtml(point, string, chartDataSet, this.add);
                                    break block0;
                                }
                                case 8: {
                                    this.scatterObjectToHtml(point, string, (Chart2DDataSet)chartDataSet, this.add);
                                    break block0;
                                }
                            }
                            this.normalObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                            break;
                        }
                        case 4096: {
                            this.effect3DObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                        }
                    }
                }
                ++n2;
            }
        } else {
            int n5 = n - 1;
            while (n5 >= 0) {
                ChartDataSet chartDataSet = (ChartDataSet)list.get(n5);
                this.bubbleObjectToHtml = chartDataSet.getSeriesSize();
                this.charAt = chartDataSet.getCategorySize();
                int n6 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n7 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                this.add = this.QOIV.getItemShapes(n5);
                if (this.add != null) {
                    block11 : switch (n7) {
                        case 0: {
                            switch (n6) {
                                case 9: {
                                    this.bubbleObjectToHtml(point, string, (Chart3DDataSet)chartDataSet, this.add);
                                    break block11;
                                }
                                case 4: {
                                    this.pieObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                                    break block11;
                                }
                                case 6: {
                                    this.guageObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                                    break block11;
                                }
                                case 10: {
                                    this.stockObjectToHtml(point, string, chartDataSet, this.add);
                                    break block11;
                                }
                                case 8: {
                                    this.scatterObjectToHtml(point, string, (Chart2DDataSet)chartDataSet, this.add);
                                    break block11;
                                }
                            }
                            this.normalObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                            break;
                        }
                        case 4096: {
                            this.effect3DObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.add);
                        }
                    }
                }
                --n5;
            }
        }
    }

    public void normalObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart1DDataSet.getValue(n, n2) != null) {
                    string2 = this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()) == null ? null : this.IsShowLabelTips.mapRowName(this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()).toString().trim());
                    string3 = this.IsShowLabelTips.getCategoryName(n2) == null ? null : this.IsShowLabelTips.getCategoryName(n2).toString().trim();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (this.IsShowLabelTips.isTurnedXZ()) {
                        String string4 = string2;
                        string2 = string3;
                        string3 = string4;
                    }
                    if (string == null || string.trim().equals("")) {
                        hashMap.put(XVALUE, string3);
                        hashMap.put(ZVALUE, string2);
                    } else {
                        hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                    }
                    String string5 = this.QOIV instanceof Chart2DPaper ? (this.QOIV.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.IsShowLabelTips, n, n2) : chart1DDataSet.getFormatedHintValue(n, n2)) : chart1DDataSet.getFormatedHintValue(n, n2);
                    hashMap.put(TITLE, string5);
                    this.getRectAreaString(shapeArray[n][n2], point, hashMap);
                    this.equals.add(hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void pieObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart1DDataSet.getValue(n, n2) != null) {
                    int n3 = this.IsShowLabelTips.getSeriesCount();
                    string2 = this.IsShowLabelTips.getSeriesName(n % n3) == null ? null : this.IsShowLabelTips.mapRowName(this.IsShowLabelTips.getSeriesName(n % n3).toString().trim());
                    string3 = this.IsShowLabelTips.getCategoryName(n2) == null ? null : this.IsShowLabelTips.getCategoryName(n2).toString().trim();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (string == null || string.trim().equals("")) {
                        hashMap.put(XVALUE, string3);
                        hashMap.put(ZVALUE, string2);
                    } else {
                        hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                    }
                    String string4 = this.QOIV instanceof Chart2DPaper ? (this.QOIV.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.IsShowLabelTips, n, n2) : chart1DDataSet.getFormatedHintValue(n, n2)) : chart1DDataSet.getFormatedHintValue(n, n2);
                    hashMap.put(TITLE, string4);
                    this.getArcAreaString(shapeArray[n][n2], point, hashMap);
                    this.equals.add(hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void scatterObjectToHtml(Point point, String string, Chart2DDataSet chart2DDataSet, Shape[][] shapeArray) {
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart2DDataSet.getX(n, n2) != null && chart2DDataSet.getY(n, n2) != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    String string2 = "X: " + chart2DDataSet.getX(n, n2).toString() + "\n" + "Y:" + chart2DDataSet.getY(n, n2).toString();
                    if (this.QOIV instanceof Chart2DPaper && this.QOIV.properties.isShowCategoryAndSeries()) {
                        string2 = ChartHintLabel.hintLabelForScatter(chart2DDataSet, this.IsShowLabelTips, n, n2) + "\n" + string2;
                    }
                    this.getRectAreaString(shapeArray[n][n2], point, hashMap);
                    hashMap.put(TITLE, string2);
                    this.equals.add(hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void bubbleObjectToHtml(Point point, String string, Chart3DDataSet chart3DDataSet, Shape[][] shapeArray) {
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart3DDataSet.getX(n, n2) != null && chart3DDataSet.getY(n, n2) != null && chart3DDataSet.getZ(n, n2) != null) {
                    String string2 = "X: " + chart3DDataSet.getX(n, n2).toString() + "\n" + "Y:" + chart3DDataSet.getY(n, n2).toString() + "\n" + "R:" + chart3DDataSet.getZ(n, n2);
                    if (this.QOIV instanceof Chart2DPaper && this.QOIV.properties.isShowCategoryAndSeries()) {
                        string2 = ChartHintLabel.hintLabelForbubble(chart3DDataSet, this.IsShowLabelTips, n, n2) + "\n" + string2;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(TITLE, string2);
                    this.equals.add(hashMap);
                    this.getCircleAreaString(shapeArray[n][n2], point, hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void stockObjectToHtml(Point point, String string, ChartDataSet chartDataSet, Shape[][] shapeArray) {
        int n = ChartTypeInfo.getSeriesType(chartDataSet.getChartDataSetInfo().getChartType());
        switch (n) {
            case 65536: {
                int n2 = 0;
                while (n2 < this.bubbleObjectToHtml) {
                    int n3 = 0;
                    while (n3 < this.charAt) {
                        if (((Chart2DDataSet)chartDataSet).getX(n2, n3) != null && ((Chart2DDataSet)chartDataSet).getY(n2, n3) != null) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            String string2 = "H: " + ((Chart2DDataSet)chartDataSet).getX(n2, n3).toString() + "\n" + "L:" + ((Chart2DDataSet)chartDataSet).getY(n2, n3).toString();
                            if (this.QOIV instanceof Chart2DPaper && this.QOIV.properties.isShowCategoryAndSeries() && this.IsShowLabelTips.getCategoryNmae() != null) {
                                string2 = " " + this.IsShowLabelTips.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.IsShowLabelTips.getCategoryName(n3), n3) + string2;
                            }
                            this.getRectAreaString(shapeArray[n2][n3], point, hashMap);
                            hashMap.put(TITLE, string2);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                break;
            }
            case 131072: {
                int n4 = 0;
                while (n4 < this.bubbleObjectToHtml) {
                    int n5 = 0;
                    while (n5 < this.charAt) {
                        if (((Chart3DDataSet)chartDataSet).getX(n4, n5) != null && ((Chart3DDataSet)chartDataSet).getY(n4, n5) != null && ((Chart3DDataSet)chartDataSet).getZ(n4, n5) != null) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            String string3 = "H: " + ((Chart3DDataSet)chartDataSet).getX(n4, n5).toString() + "\n" + "L:" + ((Chart3DDataSet)chartDataSet).getY(n4, n5).toString() + "\n" + "C:" + ((Chart3DDataSet)chartDataSet).getZ(n4, n5);
                            if (this.QOIV instanceof Chart2DPaper && this.QOIV.properties.isShowCategoryAndSeries() && this.IsShowLabelTips.getCategoryNmae() != null) {
                                string3 = " " + this.IsShowLabelTips.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.IsShowLabelTips.getCategoryName(n5), n5) + string3;
                            }
                            this.getRectAreaString(shapeArray[n4][n5], point, hashMap);
                            hashMap.put(TITLE, string3);
                        }
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 196608: {
                int n6 = 0;
                while (n6 < this.bubbleObjectToHtml) {
                    int n7 = 0;
                    while (n7 < this.charAt) {
                        if (((Chart4DDataSet)chartDataSet).getV1(n6, n7) != null && ((Chart4DDataSet)chartDataSet).getV2(n6, n7) != null && ((Chart4DDataSet)chartDataSet).getV3(n6, n7) != null && ((Chart4DDataSet)chartDataSet).getV4(n6, n7) != null) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            String string4 = "O: " + ((Chart4DDataSet)chartDataSet).getV1(n6, n7).toString() + "\n" + "H: " + ((Chart4DDataSet)chartDataSet).getV2(n6, n7).toString() + "\n" + "L:" + ((Chart4DDataSet)chartDataSet).getV3(n6, n7).toString() + "\n" + "C:" + ((Chart4DDataSet)chartDataSet).getV4(n6, n7);
                            if (this.QOIV instanceof Chart2DPaper && this.QOIV.properties.isShowCategoryAndSeries() && this.IsShowLabelTips.getCategoryNmae() != null) {
                                string4 = " " + this.IsShowLabelTips.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.IsShowLabelTips.getCategoryName(n7), n7) + string4;
                            }
                            hashMap.put(TITLE, string4);
                            this.getRectAreaString(shapeArray[n6][n7], point, hashMap);
                            this.equals.add(hashMap);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
        }
    }

    public void guageObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart1DDataSet.getValue(n, n2) != null) {
                    string2 = this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()) == null ? null : this.IsShowLabelTips.mapRowName(this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()).toString().trim());
                    string3 = this.IsShowLabelTips.getCategoryName(n2) == null ? null : this.IsShowLabelTips.getCategoryName(n2).toString().trim();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (string == null || string.trim().equals("")) {
                        hashMap.put(XVALUE, string3);
                        hashMap.put(ZVALUE, string2);
                    } else {
                        hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                    }
                    String string4 = this.QOIV instanceof Chart2DPaper ? (this.QOIV.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.IsShowLabelTips, n, n2) : chart1DDataSet.getFormatedHintValue(n, n2)) : chart1DDataSet.getFormatedHintValue(n, n2);
                    if (ChartTypeInfo.getSubType(chart1DDataSet.getChartDataSetInfo().getChartType()) == 512) {
                        this.getCircleAreaString(shapeArray[n][n2], point, hashMap);
                    } else {
                        this.getPolyAreaString(shapeArray[n][n2], point, hashMap);
                    }
                    hashMap.put(TITLE, string4);
                    this.equals.add(hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void effect3DObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        int n = 0;
        while (n < this.bubbleObjectToHtml) {
            int n2 = 0;
            while (n2 < this.charAt) {
                if (chart1DDataSet.getValue(n, n2) != null && shapeArray[n][n2] != null) {
                    String string2 = this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()) == null ? null : this.IsShowLabelTips.mapRowName(this.IsShowLabelTips.getSeriesName(n % this.IsShowLabelTips.getSeriesCount()).toString().trim());
                    String string3 = this.IsShowLabelTips.getCategoryName(n2) == null ? null : this.IsShowLabelTips.getCategoryName(n2).toString().trim();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (this.IsShowLabelTips.isTurnedXZ()) {
                        String string4 = string2;
                        string2 = string3;
                        string3 = string4;
                    }
                    if (string == null || string.trim().equals("")) {
                        hashMap.put(XVALUE, string3);
                        hashMap.put(ZVALUE, string2);
                    } else {
                        hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                    }
                    String string5 = this.QOIV instanceof Chart3DPaper ? (this.QOIV.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.IsShowLabelTips, n, n2) : chart1DDataSet.getFormatedHintValue(n, n2)) : chart1DDataSet.getFormatedHintValue(n, n2);
                    this.getPolyAreaString(shapeArray[n][n2], point, hashMap);
                    hashMap.put(TITLE, string5);
                    this.equals.add(hashMap);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void axisToHtml(Point point, String string, String string2) {
        String string3;
        HashMap<String, String> hashMap;
        int n;
        ChartDataSetInfo[] chartDataSetInfoArray = this.IsShowLabelTips.getDatasetInfos();
        int n2 = 0;
        while (n2 < chartDataSetInfoArray.length) {
            int n3 = chartDataSetInfoArray[n2].getChartType();
            int n4 = ChartTypeInfo.getPrimType(n3);
            if (n4 == 9 || n4 == 6 || n4 == 5 || n4 == 8 || n4 == 10 || n4 == 4) {
                return;
            }
            ++n2;
        }
        String[] stringArray = this.QOIV.getXLabels();
        String[] stringArray2 = this.QOIV.getZLabels();
        this.append = this.QOIV.getAxisXShapes();
        this.axisToHtml = this.QOIV.getAxisZShapes();
        if (stringArray == null) {
            return;
        }
        if (string == null || string.trim().equals("")) {
            if (this.QOIV.getProperties().getAxisXProperties().IsShowLabelTips()) {
                n = 0;
                while (n < stringArray.length) {
                    hashMap = new HashMap<String, String>();
                    string3 = stringArray[n];
                    hashMap.put(XVALUE, string3);
                    hashMap.put(TITLE, string3);
                    this.currentSegment.add(hashMap);
                    if (this.append != null) {
                        this.getPolyAreaString(this.append[n], point, hashMap);
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < stringArray.length) {
                    hashMap = new HashMap();
                    string3 = stringArray[n];
                    hashMap.put(XVALUE, string3);
                    this.currentSegment.add(hashMap);
                    if (this.append != null) {
                        this.getPolyAreaString(this.append[n], point, hashMap);
                    }
                    ++n;
                }
            }
        } else if (this.QOIV.getProperties().getAxisXProperties().IsShowLabelTips()) {
            n = 0;
            while (n < stringArray.length) {
                hashMap = new HashMap();
                string3 = ChartHtmlMapExport.parseXHyperLink(string, stringArray[n]);
                hashMap.put(XLINK, string3);
                hashMap.put(TITLE, stringArray[n]);
                this.currentSegment.add(hashMap);
                if (this.append != null) {
                    this.getPolyAreaString(this.append[n], point, hashMap);
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < stringArray.length) {
                hashMap = new HashMap();
                string3 = ChartHtmlMapExport.parseXHyperLink(string, stringArray[n]);
                hashMap.put(XLINK, string3);
                this.currentSegment.add(hashMap);
                if (this.append != null) {
                    this.getPolyAreaString(this.append[n], point, hashMap);
                }
                ++n;
            }
        }
        if (stringArray2 == null) {
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            if (this.QOIV.getProperties().getAxisZProperties().IsShowLabelTips()) {
                n = 0;
                while (n < stringArray2.length) {
                    hashMap = new HashMap();
                    hashMap.put(ZVALUE, stringArray2[n]);
                    hashMap.put(TITLE, stringArray2[n]);
                    this.getPolyAreaString(this.axisToHtml[n], point, hashMap);
                    this.effect3DObjectToHtml.add(hashMap);
                    ++n;
                }
            } else {
                n = 0;
                while (n < stringArray2.length) {
                    hashMap = new HashMap();
                    string3 = stringArray2[n];
                    hashMap.put(ZVALUE, string3);
                    this.effect3DObjectToHtml.add(hashMap);
                    if (this.axisToHtml != null) {
                        this.getPolyAreaString(this.axisToHtml[n], point, hashMap);
                    }
                    ++n;
                }
            }
        } else if (this.QOIV.getProperties().getAxisZProperties().IsShowLabelTips()) {
            n = 0;
            while (n < stringArray2.length) {
                hashMap = new HashMap();
                string3 = ChartHtmlMapExport.parseZHyperLink(string2, stringArray2[n]);
                hashMap.put(ZLINK, string3);
                hashMap.put(TITLE, stringArray2[n]);
                this.getPolyAreaString(this.axisToHtml[n], point, hashMap);
                this.effect3DObjectToHtml.add(hashMap);
                ++n;
            }
        } else {
            n = 0;
            while (n < stringArray2.length) {
                hashMap = new HashMap();
                string3 = ChartHtmlMapExport.parseZHyperLink(string2, stringArray2[n]);
                hashMap.put(ZLINK, string3);
                this.effect3DObjectToHtml.add(hashMap);
                if (this.axisToHtml != null) {
                    this.getPolyAreaString(this.axisToHtml[n], point, hashMap);
                }
                ++n;
            }
        }
    }

    public static String escapeFileName(String string) {
        int n = string.length();
        String string2 = string;
        char c = '-';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '\\' || c == '/' || c == ':' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                string2 = string.replace(c, '-');
            }
            ++n2;
        }
        return string2;
    }

    public static String parseXHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@XDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseZHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@ZDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseHyperLink(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        n = stringBuffer.toString().indexOf("@OUTER");
        while (n != -1) {
            if (string2 != null) {
                stringBuffer.replace(n, n + 6, string2);
            } else {
                stringBuffer.replace(n, n + 6, string3);
            }
            n = stringBuffer.toString().indexOf("@OUTER", n + 1);
        }
        if (string2 == null && n != -1) {
            return stringBuffer.toString();
        }
        n = stringBuffer.toString().indexOf("@INNER");
        while (n != -1) {
            stringBuffer.replace(n, n + 6, string3);
            n = stringBuffer.toString().indexOf("@INNER", n + 1);
        }
        return stringBuffer.toString();
    }

    public void getRectAreaString(Shape shape, Point point, HashMap hashMap) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        float[][] fArray2 = new float[2][2];
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        fArray2[0][0] = (float)point.x + f;
        fArray2[0][1] = (float)point.y + f2;
        fArray2[1][0] = (float)point.x + f + f3;
        fArray2[1][1] = (float)point.y + f2 + f4;
        String string = fArray2[0][0] + "," + fArray2[0][1] + "," + fArray2[1][0] + "," + fArray2[1][1];
        hashMap.put(SHAPE, "rect");
        hashMap.put(COORDS, string);
    }

    public void getPolyAreaString(Shape shape, Point point, HashMap hashMap) {
        boolean bl = false;
        float[] fArray2 = new float[6];
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        String string = "";
        while (!pathIterator.isDone()) {
            bl = true;
            pathIterator.currentSegment(fArray2);
            float f = fArray2[0] + (float)point.x;
            float f2 = fArray2[1] + (float)point.y;
            string = string + f + "," + f2 + ",";
            pathIterator.next();
        }
        int n = string.length();
        if (bl) {
            string = string.substring(0, n - 1);
        }
        hashMap.put(SHAPE, "poly");
        hashMap.put(COORDS, string);
    }

    public void getCircleAreaString(Shape shape, Point point, HashMap hashMap) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        float f = (float)rectangle2D.getCenterX() + (float)point.x;
        float f2 = (float)rectangle2D.getCenterY() + (float)point.y;
        float f3 = (float)rectangle2D.getWidth() / 2.0f;
        String string = f + "," + f2 + "," + f3;
        hashMap.put(SHAPE, "circle");
        hashMap.put(COORDS, string);
    }

    public void getArcAreaString(Shape shape, Point point, HashMap hashMap) {
        this.getPolyAreaString(shape, point, hashMap);
    }

    public String[] getResult() {
        return null;
    }

    public List getResultMap() {
        ArrayList arrayList = new ArrayList();
        int n = this.currentSegment.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.currentSegment.get(n2));
            ++n2;
        }
        int n3 = this.effect3DObjectToHtml.size();
        int n4 = 0;
        while (n4 < n3) {
            arrayList.add(this.effect3DObjectToHtml.get(n4));
            ++n4;
        }
        int n5 = this.equals.size();
        int n6 = 0;
        while (n6 < n5) {
            arrayList.add(this.equals.get(n6));
            ++n6;
        }
        return arrayList;
    }

    public List getCompInfoForDHTML() {
        ArrayList arrayList = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(INSTANCENAME, this.I.getProperties().getInstanceName());
        hashMap.put(OBJECTTYPE, PLATFORM);
        this.QOIV(this.I, hashMap);
        arrayList.add(hashMap);
        int n = this.I.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            ChartComponent chartComponent = this.I.getComponent(n2);
            hashMap = new HashMap();
            this.QOIV(chartComponent, hashMap);
            arrayList.add(hashMap);
            if (chartComponent instanceof ChartCoordinatePaper) {
                hashMap.put(INSTANCENAME, ((ChartCoordinatePaper)chartComponent).getProperties().getInstanceName());
                hashMap.put(OBJECTTYPE, PAPER);
            }
            if (chartComponent instanceof ChartLabel) {
                hashMap.put(INSTANCENAME, ((ChartLabel)chartComponent).getProperties().getInstanceName());
                hashMap.put(OBJECTTYPE, LABEL);
            }
            if (chartComponent instanceof ChartLegend) {
                hashMap.put(INSTANCENAME, ((ChartLegend)chartComponent).getProperties().getInstanceName());
                hashMap.put(OBJECTTYPE, LEGEND);
            }
            ++n2;
        }
        return arrayList;
    }

    private void QOIV(ChartComponent chartComponent, HashMap hashMap) {
        Rectangle rectangle = chartComponent.getBounds();
        String string = rectangle.x + "," + rectangle.y + "," + (rectangle.width + rectangle.x) + ", " + (rectangle.y + rectangle.height);
        hashMap.put(SHAPE, "rect");
        hashMap.put(COORDS, string);
    }
}

