/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational;

import com.jinfonet.dataservice.relational.ALazyRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import com.jinfonet.dataservice.util.IntList;
import jet.dataengine.api.DSException;

public class LazyRowID
implements IRowID {
    protected final ALazyRelationData relationData;
    protected static final int beforeFirst = -1;
    protected int position = -1;
    static final boolean $assertionsDisabled = !(class$com$jinfonet$dataservice$relational$LazyRowID == null ? (class$com$jinfonet$dataservice$relational$LazyRowID = LazyRowID.class$("com.jinfonet.dataservice.relational.LazyRowID")) : class$com$jinfonet$dataservice$relational$LazyRowID).desiredAssertionStatus();
    static Class class$com$jinfonet$dataservice$relational$LazyRowID;

    public LazyRowID(ALazyRelationData aLazyRelationData) {
        this.relationData = aLazyRelationData;
    }

    public int getRowID(int n) throws DSException {
        return this.relationData.getRowId(n);
    }

    public int getCurrentRowID() throws DSException {
        return this.relationData.getRowId(this.position);
    }

    public IntList getRowIDs() throws DSException {
        return this.relationData.getRowIdsCopy();
    }

    public boolean currentRowIDIsAvailable() throws DSException {
        if (this.position <= -1) {
            this.position = -1;
            return false;
        }
        int n = this.relationData.getCurrentFilledRecordsCount();
        if (this.position < n) {
            return true;
        }
        if (this.isFinished()) {
            this.position = n;
            return false;
        }
        boolean bl = this.relationData.nextToPosition(this.position);
        if (bl) {
            return true;
        }
        if (!$assertionsDisabled && !this.isFinished()) {
            throw new AssertionError((Object)"relation data have not finished.");
        }
        this.position = this.relationData.getRecordsCount();
        return false;
    }

    protected int getAfterLast() throws DSException {
        this.relationData.nextToPosition(Integer.MAX_VALUE);
        return this.relationData.getRecordsCount();
    }

    public int size() throws DSException {
        return this.relationData.getRecordsCount();
    }

    public boolean next() throws DSException {
        ++this.position;
        return this.currentRowIDIsAvailable();
    }

    public void beforeFirst() throws DSException {
        this.position = -1;
    }

    public void afterLast() throws DSException {
        this.position = this.getAfterLast();
    }

    public boolean first() throws DSException {
        this.position = 0;
        return this.currentRowIDIsAvailable();
    }

    public boolean isAfterLast() throws DSException {
        return this.position == this.getAfterLast();
    }

    public boolean isBeforeFirst() throws DSException {
        return this.position == -1;
    }

    public boolean isFirst() throws DSException {
        return this.position == 0;
    }

    public boolean isLast() throws DSException {
        return this.position == this.getAfterLast() - 1;
    }

    public boolean last() throws DSException {
        this.position = this.getAfterLast() - 1;
        return this.currentRowIDIsAvailable();
    }

    public boolean previous() throws DSException {
        --this.position;
        return this.currentRowIDIsAvailable();
    }

    public boolean relative(int n) throws DSException {
        this.position += n;
        return this.currentRowIDIsAvailable();
    }

    public void setPosition(long l) throws DSException {
        this.position = (int)l + -1;
        this.currentRowIDIsAvailable();
    }

    public long getPosition() throws DSException {
        return this.position - -1;
    }

    public boolean isFinished() {
        return this.relationData.isFinished();
    }

    public void setFetchDirection(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) throws DSException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    public void getWarnings() throws DSException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws DSException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws DSException {
        throw new UnsupportedOperationException();
    }

    public long getExtent() throws DSException {
        throw new UnsupportedOperationException();
    }

    public int getPosition(int n) {
        return this.relationData.getPosition(n);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

