/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.reg;

import com.jinfonet.reg.RegisterException;
import com.jinfonet.reg.util.QueryString;
import com.jinfonet.reg.util.RegAlgorithm;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.ReportEnv;
import jet.util.KeyChecker;
import jet.util.rpRW;

public final class RegisterAPI {
    private static final String[] FILE_PATH = new String[]{"JReport Designer", "JReport Enterprise Server", "JReport Designer Bean", "JReport Designer Bean for Novell", "JReport Runtime", "JReport Server Engine", "JReport Designer API", "JReport Server Designer API", "JReport Team Designer"};
    private static final int[] QOIV = new int[]{16, 96, 80, 0, 64, 97, 17, 98, 101};
    private static int addQuery = 60;
    private static String append;
    private static String buildLicense;
    private static String check;
    private String checkISV;
    private String close;
    private String currentTimeMillis;
    private String delete;
    private String endsWith;
    private String equalsIgnoreCase;
    private String exists;
    private String get;
    private int getAllByName = -1;
    private int getExtNum = -1;
    private String getHostName = null;
    private long getISV = -1L;
    private long getInputStream = -1L;
    private static PrintStream getLocalHost;

    public RegisterAPI() {
        this.FILE_PATH();
    }

    public void setCompany(String string) {
        this.checkISV = string;
    }

    public String getCompany() {
        return this.checkISV;
    }

    public void setFirstName(String string) {
        this.close = string;
    }

    public String getFirstName() {
        return this.close;
    }

    public void setLastName(String string) {
        this.currentTimeMillis = string;
    }

    public String getLastName() {
        return this.currentTimeMillis;
    }

    public void setEmail(String string) {
        this.delete = string;
    }

    public String getEmail() {
        return this.delete;
    }

    public void setPhone(String string) {
        this.endsWith = string;
    }

    public String getPhone() {
        return this.endsWith;
    }

    public void setISV(String string) {
        this.equalsIgnoreCase = string;
    }

    public String getISV() {
        return this.equalsIgnoreCase;
    }

    public void setExtNum(int n) {
        this.getExtNum = n;
    }

    public int getExtNum() {
        return this.getExtNum;
    }

    public void setUserID(String string) {
        buildLicense = string;
    }

    public String getUserID() {
        return buildLicense;
    }

    public void setMacNum(int n) {
        this.getAllByName = n;
    }

    public int getMacNum() throws FileNotFoundException, IOException {
        if (this.getAllByName == -1) {
            this.addQuery();
        }
        return this.getAllByName;
    }

    public boolean setPrdName(String string) {
        if (RegisterAPI.getPrdID(string) != -1) {
            this.get = string;
            return true;
        }
        return false;
    }

    public String getPrdName() {
        return this.get;
    }

    public void setInstallRoot(String string) {
        append = string;
        RegisterAPI.delete();
    }

    public String getInstallRoot() {
        return append;
    }

    public boolean setGracePeriod(int n) {
        if (n <= 0 || n > 60) {
            return false;
        }
        addQuery = n;
        return true;
    }

    public int getGracePeriod() {
        return addQuery;
    }

    public String doRegister() {
        String string = null;
        String string2 = "http://www.jinfonet.com:8080/servlets/jregister/config";
        try {
            string = this.get(string2);
            RegisterAPI.log("Try to register, 1st: " + string);
            if (this.getRegCode(string) == null) {
                throw new RegisterException(1013);
            }
        }
        catch (RegisterException registerException) {
            RegisterAPI.log(registerException);
            try {
                String[] stringArray = this.getAllByName();
                string2 = "http://" + stringArray[0] + ":" + stringArray[1] + "/" + "servlets/jregister" + "/" + "config";
                string = this.get(string2);
                RegisterAPI.log("Try to register, 2nd: " + string);
                if (string == null) {
                    string = "No response! Please contact support@jinfonet.com for assistance!";
                }
            }
            catch (RegisterException registerException2) {
                RegisterAPI.log(registerException2);
            }
        }
        return string;
    }

    public String getRegCode(String string) {
        String string2;
        int n;
        String string3 = null;
        if (string != null && string.startsWith("REGISTERCODE:") && (n = (string2 = string.substring("REGISTERCODE:".length()).trim()).indexOf("ER56T78")) != -1) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    public void writeRegCode(String string) throws IOException {
        RegisterAPI.endsWith(RegisterAPI.exists(append), "regCode", string);
    }

    public static void writePrdKey(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("uid", string2);
        hashtable.put("password", string3);
        rpRW.write(RegisterAPI.exists(string), hashtable);
        append = string;
        RegisterAPI.checkISV(string);
    }

    public boolean isValidKey() throws FileNotFoundException {
        String string = RegisterAPI.exists(append);
        if (!new File(string).exists()) {
            throw new FileNotFoundException("Cannot find the data file '" + string + "'!");
        }
        boolean bl = KeyChecker.check(string);
        if (bl) {
            buildLicense = KeyChecker.userID;
        }
        return bl;
    }

    public boolean isMasterKey() throws FileNotFoundException {
        boolean bl = false;
        if (this.isValidKey()) {
            bl = KeyChecker.isRegisterRequired();
        }
        return bl;
    }

    public boolean isFirstTry() throws FileNotFoundException, IOException {
        if (this.getInputStream == -1L) {
            this.addQuery();
        }
        return System.currentTimeMillis() - this.getInputStream < 60000L;
    }

    public int getLeftDays() throws FileNotFoundException, IOException {
        if (this.getISV == -1L) {
            this.addQuery();
        }
        String string = this.QOIV();
        int n = -1;
        if (string == null || string.length() == 0) {
            n = addQuery - (int)((System.currentTimeMillis() - this.getISV) / 86400000L);
            if (n <= 0) {
                n = -1;
            }
        } else {
            int n2 = RegAlgorithm.getExtNum(string);
            if (n2 == 0) {
                n = 0;
            } else {
                n = addQuery * (n2 + 1) - (int)((System.currentTimeMillis() - this.getISV) / 86400000L);
                if (n <= 0) {
                    n = -1;
                }
            }
        }
        return n;
    }

    public boolean isRegistrationValid() throws FileNotFoundException, IOException {
        String string = this.QOIV();
        return this.isRegCodeValid(string);
    }

    public boolean isRegCodeValid(String string) throws FileNotFoundException, IOException {
        if (RegAlgorithm.getMacNum(string) != this.getMacNum()) {
            return false;
        }
        return RegAlgorithm.checkISV(string, this.getISV());
    }

    public static final String[] getPrdList() {
        return FILE_PATH;
    }

    public static final String getPrdName(int n) {
        if (n >= 0 && n < 8) {
            return FILE_PATH[n];
        }
        return null;
    }

    public static final int getPrdID(String string) {
        int n = 0;
        while (n < FILE_PATH.length) {
            if (string.trim().equalsIgnoreCase(FILE_PATH[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void setLogFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        getLocalHost = new PrintStream(new FileOutputStream(file));
    }

    public static void log(String string) {
        if (getLocalHost != null) {
            getLocalHost.println(string);
        }
    }

    public static void log(Throwable throwable) {
        if (getLocalHost != null) {
            throwable.printStackTrace(getLocalHost);
        }
    }

    private final void FILE_PATH() {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            int n = 0;
            while (n < inetAddressArray.length) {
                string = string + inetAddressArray[n].toString() + ";";
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            RegisterAPI.log(new UnknownHostException(""));
        }
        this.exists = string;
    }

    private String QOIV() throws FileNotFoundException, IOException {
        if (this.getHostName == null) {
            this.addQuery();
        }
        return this.getHostName;
    }

    private final void addQuery() throws FileNotFoundException, IOException {
        Hashtable hashtable = null;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(RegisterAPI.exists(append)));
        hashtable = rpRW.read(dataInputStream);
        String string = (String)hashtable.get("regVer");
        int n = 0;
        n = string == null || string.trim().length() == 0 ? 0 : Integer.parseInt(string);
        this.getHostName = (String)hashtable.get("regCode");
        string = (String)hashtable.get("firstTry");
        this.getInputStream = string == null || string.trim().length() == 0 ? -1L : Long.parseLong(string);
        this.append();
        if (this.getInputStream == -1L) {
            this.check();
        }
    }

    private final void append() {
        Hashtable hashtable = RegisterAPI.buildLicense(RegisterAPI.equalsIgnoreCase());
        String string = (String)hashtable.get("macNum");
        this.getAllByName = string == null || string.trim().length() == 0 ? -1 : (int)((Long.parseLong(string) & 0xFFFFL) * 10000L / 65535L);
        String string2 = RegisterAPI.currentTimeMillis();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            long l;
            String string3 = (String)enumeration.nextElement();
            if (string3.indexOf(string2) != 0) continue;
            string = (String)hashtable.get(RegisterAPI.close());
            long l2 = l = string == null || string.trim().length() == 0 ? -1L : Long.parseLong(string);
            if (l <= this.getISV) continue;
            this.getISV = l;
        }
    }

    private static final Hashtable buildLicense(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1005));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1006));
        }
        return hashtable;
    }

    private final void check() throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("regVer", "1");
        hashtable.put("regCode", this.getHostName == null ? "" : this.getHostName);
        this.getInputStream = System.currentTimeMillis();
        hashtable.put("firstTry", "" + this.getInputStream);
        rpRW.write(RegisterAPI.exists(append), hashtable);
    }

    private static final void checkISV(String string) {
        if (!new File(RegisterAPI.equalsIgnoreCase()).exists()) {
            long l = System.currentTimeMillis();
            long l2 = (int)l;
            long l3 = (int)l >> 32;
            try {
                RegisterAPI.endsWith(RegisterAPI.equalsIgnoreCase(), "macNum", "" + l3 * l2);
            }
            catch (IOException iOException) {
                RegisterAPI.log(new RegisterException(1007));
            }
        }
        try {
            String string2 = RegisterAPI.close();
            Hashtable hashtable = RegisterAPI.buildLicense(RegisterAPI.equalsIgnoreCase());
            String string3 = (String)hashtable.get(string2);
            if (string3 == null) {
                long l = System.currentTimeMillis();
                RegisterAPI.endsWith(RegisterAPI.equalsIgnoreCase(), string2, "" + l);
            }
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1008));
        }
    }

    private static final String close() {
        return RegisterAPI.currentTimeMillis() + "_" + 9 + "." + 0 + "." + 0 + "_Build" + 900 + "_Help" + 800 + "_Release(" + ReportEnv.releaseDate + ")";
    }

    private static final String currentTimeMillis() {
        RegisterAPI.delete();
        long l = ReportEnv.buildLicense(buildLicense, check);
        int n = (int)(l >> 52) & 0xFF;
        return "JRProd#" + RegisterAPI.getExtNum(n);
    }

    private static final void delete() {
        if (buildLicense == null || buildLicense.length() == 0 || check == null || check.length() == 0) {
            try {
                Hashtable hashtable = rpRW.read(new FileInputStream(RegisterAPI.exists(append)));
                buildLicense = (String)hashtable.get("uid");
                check = (String)hashtable.get("password");
            }
            catch (Exception exception) {
                RegisterAPI.log(exception);
            }
        }
    }

    private static final void endsWith(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string2, string3);
        rpRW.write(string, hashtable);
    }

    private static final String equalsIgnoreCase() {
        String string = null;
        Properties properties = System.getProperties();
        boolean bl = properties.getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
        String string2 = properties.getProperty("java.library.path");
        String string3 = properties.getProperty("path.separator");
        if (bl) {
            string2 = string2.toUpperCase();
            int n = -1;
            n = string2.indexOf("WINNT\\SYSTEM32") != -1 ? string2.indexOf("WINNT\\SYSTEM32") : (string2.indexOf("WINDOWS\\SYSTEM32") != -1 ? string2.indexOf("WINDOWS\\SYSTEM32") : (string2.indexOf("WINNT") != -1 ? string2.indexOf("WINNT") : (string2.indexOf("WINDOWS") != -1 ? string2.indexOf("WINDOWS") : 0)));
            int n2 = string2.lastIndexOf(string3, n) + 1;
            int n3 = string2.indexOf(string3, n);
            if (n3 == -1) {
                n3 = string2.length();
            }
            string = string2.substring(n2, n3) + File.separator + "mscpxw32dr.dll";
        } else if (new File("/usr/lib").exists()) {
            string = "/usr/lib" + File.separator + "liblnm1.0.1.dev1.4.2.os";
        } else {
            int n = string2.indexOf(string3);
            string = string2.substring(0, n) + File.separator + "liblnm1.0.1.dev1.4.2.os";
        }
        return string;
    }

    private static String exists(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + rpRW.FILE_PATH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String get(String string) throws RegisterException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                QueryString queryString = new QueryString();
                queryString.addQuery("COMPANY", this.checkISV);
                queryString.addQuery("FIRSTNAME", this.close);
                queryString.addQuery("LASTNAME", this.currentTimeMillis);
                queryString.addQuery("EMAIL", this.delete);
                queryString.addQuery("PHONE", this.endsWith);
                if (this.equalsIgnoreCase == null) {
                    this.equalsIgnoreCase = "";
                }
                queryString.addQuery("ISVNAME", this.equalsIgnoreCase);
                if (buildLicense == null) {
                    buildLicense = "";
                }
                queryString.addQuery("USERID", buildLicense);
                queryString.addQuery("IPS", this.exists);
                queryString.addQuery("EXTTIMES", this.getExtNum + "");
                queryString.addQuery("MACHINECODE", this.getAllByName + "");
                if (this.get == null) {
                    this.get = FILE_PATH[0];
                }
                queryString.addQuery("PRODUCTID", RegisterAPI.getPrdID(this.get) + 1 + "");
                queryString.addQuery("GRACEPERIOD", addQuery + "");
                queryString.addQuery("ADDINFOS", RegisterAPI.getHostName(append));
                String string3 = queryString.toString();
                if (string3.length() != 0) {
                    string = string + "?" + string3;
                }
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(true);
                bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                string2 = bufferedReader.readLine();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RegisterException(1001);
            }
            catch (IOException iOException) {
                throw new RegisterException(1002);
            }
            Object var9_10 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RegisterException(1003);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new RegisterException(1003);
        }
        bufferedReader.close();
        return string2;
    }

    private String[] getAllByName() throws RegisterException {
        String[] stringArray = new String[2];
        String string = "http://www.jinfonet.com/reg/reghost.ini";
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(false);
            uRLConnection.setDoInput(true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("host")) {
                    stringArray[0] = string2.substring(string2.indexOf("=") + 1).trim();
                    continue;
                }
                if (!string2.startsWith("port")) continue;
                stringArray[1] = string2.substring(string2.indexOf("=") + 1).trim();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegisterException(1009);
        }
        catch (IOException iOException) {
            throw new RegisterException(1010);
        }
        return stringArray;
    }

    private static final int getExtNum(int n) {
        int n2 = 0;
        while (n2 < QOIV.length) {
            if (n == QOIV[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static final String getHostName(String string) {
        String string2;
        Enumeration enumeration;
        Serializable serializable;
        if (string == null) {
            return "";
        }
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(RegisterAPI.equalsIgnoreCase()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1011));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1012));
        }
        try {
            serializable = rpRW.read(new FileInputStream(RegisterAPI.exists(string)));
            enumeration = ((Hashtable)serializable).keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                hashtable.put(string2, ((Hashtable)serializable).get(string2));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(fileNotFoundException);
        }
        catch (IOException iOException) {
            RegisterAPI.log(iOException);
        }
        serializable = new StringBuffer();
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            ((StringBuffer)serializable).append(string2.toString() + "=" + hashtable.get(string2).toString() + "\r\n");
        }
        return ((StringBuffer)serializable).toString();
    }

    static {
        getLocalHost = null;
    }
}

