/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.api.PrincipalLoader;
import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import com.jinfonet.security.loader.DBMSPrincipalLoader;
import com.jinfonet.security.loader.InputPrincipalLoader;
import com.jinfonet.security.loader.LDAPPrincipalLoader;
import com.jinfonet.security.loader.ServerPrincipalLoader;
import com.jinfonet.security.loader.SystemPrincipalLoader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class JRPrincipalManager
implements PrincipalManager {
    private Hashtable QOIV = null;
    private Hashtable add = null;
    private Hashtable append = null;
    private Hashtable elements = new Hashtable(5);
    private int forName = -1;
    private Properties get = new Properties();
    private ServerPrincipalLoader getPrincipal = null;

    public PrincipalLoader getPrincipalLoader(int n) throws Exception {
        this.forName = n;
        switch (n) {
            case 0: {
                String string = System.getProperty("com.jinfonet.principalLoader");
                Object object = this.elements.get(string);
                if (object == null) {
                    object = Class.forName(string).newInstance();
                    this.elements.put("CUSTOMIZE" + string, object);
                }
                return (PrincipalLoader)object;
            }
            case 1: {
                Object object = this.elements.get("SYSTEM");
                if (object == null) {
                    object = new SystemPrincipalLoader();
                    this.elements.put("SYSTEM", object);
                }
                return (SystemPrincipalLoader)object;
            }
            case 2: {
                Object object = this.elements.get("LDAP");
                if (object == null) {
                    object = new LDAPPrincipalLoader();
                    this.elements.put("LDAP", object);
                }
                return (LDAPPrincipalLoader)object;
            }
            case 3: {
                Object object = this.elements.get("DBMS");
                if (object == null) {
                    object = new DBMSPrincipalLoader();
                    this.elements.put("DBMS", object);
                }
                return (DBMSPrincipalLoader)object;
            }
            case 4: {
                Object object = this.elements.get("INPUT");
                if (object == null) {
                    object = new InputPrincipalLoader();
                    this.elements.put("INPUT", object);
                }
                return (InputPrincipalLoader)object;
            }
            case 5: {
                Object v = this.elements.get("SERVER_LOCAL");
                if (v == null) {
                    this.getPrincipal = (ServerPrincipalLoader)Class.forName("jet.server.jrc.security.cube.ServerPrincipalLoaderImpl").newInstance();
                    this.elements.put("SERVER_LOCAL", this.getPrincipal);
                }
                return this.getPrincipal;
            }
        }
        return null;
    }

    public Vector[] getPrincipals() {
        Enumeration enumeration;
        if (this.forName == 5) {
            return this.getPrincipal.getPrincipalNames();
        }
        Vector[] vectorArray = new Vector[3];
        vectorArray[0] = new Vector();
        if (this.append != null) {
            enumeration = this.append.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[0].add(enumeration.nextElement());
            }
        }
        vectorArray[1] = new Vector();
        if (this.QOIV != null) {
            enumeration = this.QOIV.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[1].add(enumeration.nextElement());
            }
        }
        vectorArray[2] = new Vector();
        if (this.add != null) {
            enumeration = this.add.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[2].add(enumeration.nextElement());
            }
        }
        return vectorArray;
    }

    public Vector[] getPrincipalNames() {
        Enumeration enumeration;
        if (this.forName == 5) {
            return this.getPrincipal.getPrincipalNames();
        }
        Vector[] vectorArray = new Vector[3];
        vectorArray[0] = new Vector();
        if (this.append != null) {
            enumeration = this.append.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[0].add(enumeration.nextElement());
            }
        }
        vectorArray[1] = new Vector();
        if (this.QOIV != null) {
            enumeration = this.QOIV.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[1].add(enumeration.nextElement());
            }
        }
        vectorArray[2] = new Vector();
        if (this.add != null) {
            enumeration = this.add.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[2].add(enumeration.nextElement());
            }
        }
        return vectorArray;
    }

    public Principal getPrincipal(String string, int n) {
        if (this.forName == 5) {
            return this.getPrincipal.getPrincipal(string, n);
        }
        if (string != null) {
            switch (n) {
                case 0: {
                    return (JRRole)this.QOIV.get(string);
                }
                case 1: {
                    return (JRGroup)this.add.get(string);
                }
                case 2: {
                    return (JRUser)this.append.get(string);
                }
            }
        }
        return null;
    }

    public void setRoles(Hashtable hashtable) {
        this.QOIV = hashtable;
    }

    public void setGroups(Hashtable hashtable) {
        this.add = hashtable;
    }

    public void setUsers(Hashtable hashtable) {
        this.append = hashtable;
    }

    public int getLoaderType() {
        return this.forName;
    }

    public Properties getLoaderProperties() {
        return this.get;
    }

    public void setLoaderProperties(Properties properties) {
        this.get = properties;
    }
}

