/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;

public class DbDecimal
extends DbNumber {
    public BigDecimal value;

    public DbDecimal() {
    }

    public DbDecimal(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public BigDecimal get() {
        return this.value;
    }

    public void set(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            this.value = this.desc != null ? bigDecimal.setScale(this.desc.getScale(), 4) : bigDecimal;
            this.bNull = false;
        } else {
            this.value = bigDecimal;
            this.bNull = true;
        }
    }

    public void set(ResultSet resultSet, int n) throws SQLException {
        BigDecimal bigDecimal = resultSet.getBigDecimal(n);
        this.bNull = resultSet.wasNull();
        if (!this.bNull) {
            this.set(bigDecimal);
        }
    }

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        BigDecimal bigDecimal = jRHierarchicalDataset.getBigDecimal(n);
        boolean bl = this.bNull = jRHierarchicalDataset.wasNull() || bigDecimal == null;
        if (!this.bNull) {
            this.set(bigDecimal);
        }
    }

    public String toString() {
        if (this.bNull || this.value == null) {
            return "NULL";
        }
        return this.get().toString();
    }

    public Object clone() {
        DbDecimal dbDecimal = new DbDecimal(this.desc);
        dbDecimal.bNull = this.bNull;
        dbDecimal.value = this.value;
        return dbDecimal;
    }

    public boolean equals(DbValue dbValue) {
        DbDecimal dbDecimal = (DbDecimal)dbValue;
        if (dbDecimal.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        if (this.value != null) {
            return this.value.equals(dbDecimal.value);
        }
        return dbDecimal.value == null;
    }

    public int compareTo(DbValue dbValue) {
        DbDecimal dbDecimal = (DbDecimal)dbValue;
        if (dbDecimal.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbDecimal.bNull) {
                return 0;
            }
            return -1;
        }
        return this.value.compareTo(dbDecimal.value);
    }

    public byte byteValue() {
        if (this.value != null) {
            return this.value.byteValue();
        }
        return 0;
    }

    public short shortValue() {
        if (this.value != null) {
            return this.value.shortValue();
        }
        return 0;
    }

    public int intValue() {
        if (this.value != null) {
            return this.value.intValue();
        }
        return 0;
    }

    public long longValue() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return 0L;
    }

    public float floatValue() {
        if (this.value != null) {
            return this.value.floatValue();
        }
        return 0.0f;
    }

    public double doubleValue() {
        if (this.value != null) {
            return this.value.doubleValue();
        }
        return 0.0;
    }

    public void set(DbValue dbValue) {
        this.value = dbValue instanceof DbDouble ? new BigDecimal(((DbDouble)dbValue).doubleValue()) : ((DbDecimal)dbValue).value;
        this.bNull = dbValue.bNull;
    }

    public void setValue(DbNumber dbNumber) {
        if (dbNumber instanceof DbDecimal) {
            this.set(dbNumber);
        } else {
            this.bNull = dbNumber.bNull;
            if (!this.bNull) {
                this.value = new BigDecimal(dbNumber.doubleValue());
            }
        }
    }

    public void setValue(String string) {
        this.value = new BigDecimal(string);
        this.bNull = false;
    }
}

