/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import com.jinfonet.util.JRLog;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ACanBeChange;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.util.DSLog;
import jet.dataengine8.query.QueryManager;
import jet.formula.JavaFormula;

public abstract class AQuery
extends ACanBeChange
implements JQuery {
    private static String QOIV = "AQuery";
    protected final DSLog log = DSLog.getDSLog(this.getClass().getName());
    protected final QueryManager manager;
    protected final Integer id;
    protected final String queryType;
    protected boolean isClose = false;
    protected JavaFormula javaFormula;
    protected boolean isCancel = false;

    protected AQuery(String string, QueryManager queryManager, int n) throws DSException {
        queryManager.I(n);
        this.manager = queryManager;
        this.id = new Integer(n);
        this.queryType = string;
        this.manager.I(this);
    }

    public final int getQueryId() {
        return this.id;
    }

    public String getQueryType() throws DSException {
        this.checkClose();
        return this.queryType;
    }

    public void close() throws DSException {
        if (this.isClose) {
            return;
        }
        this.manager.Z(this);
        this.isClose = true;
        this.clearMemory();
        if (JRLog.isTrace(6)) {
            this.log.externalDebug(1013, new Object[]{this.queryType, "[" + this.hashCode() + "] id = " + this.id.toString()});
        }
    }

    protected void clearMemory() {
        this.javaFormula = null;
    }

    public boolean isClosed() {
        return this.isClose;
    }

    public void cancel(CancelEvent cancelEvent) throws DSException {
        this.checkClose();
        this.log.debug("stop query(" + this.queryType + "), id:" + this.id);
        this.isCancel = true;
        this.manager.cancelQuery(this.id, cancelEvent);
    }

    public void check() throws DSException, JRStopEngineException {
        this.checkClose();
        if (this.isCancel) {
            throw new JRStopEngineException();
        }
        if (this.canBeChange) {
            throw new DSException(1094, new Object[]{String.valueOf(this.id)});
        }
        if (this.javaFormula == null) {
            throw new DSException(1051);
        }
    }

    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("AQuery");
        this.log.indent(QOIV);
        this.log.debug("query id: " + this.id);
        this.log.debug("isClose: " + this.isClose);
        this.log.debug("canBeChange: " + this.canBeChange);
        this.log.debug("javaFormula: " + this.javaFormula);
        this.log.deIndent(QOIV);
        this.log.debug("End AQuery.");
    }

    protected void checkClose() throws DSException {
        if (this.isClose) {
            throw new DSException(1050, new Object[]{this.id.toString()});
        }
    }

    public JavaFormula getJavaFormula() throws DSException {
        this.checkClose();
        return this.javaFormula;
    }

    public void setJavaFormula(JavaFormula javaFormula) throws DSException {
        this.checkClose();
        this.checkCanBeChange();
        this.javaFormula = javaFormula;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCacheZip() throws DSException {
        this.getQueryOption().setCacheZip(this.manager.getEngineOption().isCacheZip());
    }
}

