/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class BarcodeUPCE
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String EAN13;
    boolean EAN13Translate = false;

    public BarcodeUPCE(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    public void init() {
        this.EAN13 = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.supplementText = this.paper.getBarSupplement();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.unit = this.paper.getUnit();
        if (this.supplementText != null && (this.supplementText.length() == 2 || this.supplementText.length() == 5)) {
            this.EAN13Translate = true;
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    public void paint(Graphics2D graphics2D) {
        this.printUPCE(graphics2D, this.EAN13);
    }

    public void calculateWidth() {
        this.EAN13(this.EAN13);
    }

    private void EAN13(String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return;
            }
            ++n2;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer2 = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer2 = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBuffer = BarcodeUPCE.UPCETran(string + String.valueOf(n));
        } else if (string.length() == 8) {
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) {
                // empty if block
            }
            stringBuffer = BarcodeUPCE.UPCETran(string);
        } else {
            return;
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBuffer.length() + stringBuffer2.length() + 1) * f5 / 2.0f + (float)(n3 / 2))) : (f2 = (float)this.centreX - (float)stringBuffer.length() * f5 / 2.0f);
        int n5 = 0;
        while (n5 < stringBuffer.length()) {
            f += f5;
            ++n5;
        }
        if (this.EAN13Translate) {
            float f8 = f = f + (float)n3 + f5;
            int n6 = 0;
            while (n6 < stringBuffer2.length()) {
                f += f5;
                ++n6;
            }
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public static StringBuffer UPCETran(String string) {
        int n;
        String string2 = new String();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '0') {
            n = 0;
            while (n <= 9) {
                if (string.charAt(7) == BarcodeTable.EAN13[n]) {
                    string2 = BarcodeTable.UPCEMTable[0][n];
                }
                ++n;
            }
        } else {
            n = 0;
            while (n <= 9) {
                if (string.charAt(7) == BarcodeTable.EAN13[n]) {
                    string2 = BarcodeTable.UPCEMTable[1][n];
                }
                ++n;
            }
        }
        stringBuffer.append("101");
        n = 1;
        while (n <= 6) {
            int n2;
            if (string2.charAt(n - 1) == '0') {
                n2 = 0;
                while (n2 <= 9) {
                    if (string.charAt(n) == BarcodeTable.EAN13[n2]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 <= 9) {
                    if (string.charAt(n) == BarcodeTable.EAN13[n2]) {
                        stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        stringBuffer.append("010101");
        return stringBuffer;
    }

    public void printUPCE(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer stringBuffer = new StringBuffer();
        graphics2D.setFont(this.bottomLabelFont);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                return;
            }
            ++n2;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer2 = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer2 = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBuffer = BarcodeUPCE.UPCETran(string + String.valueOf(n));
        } else if (string.length() == 8) {
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) {
                // empty if block
            }
            stringBuffer = BarcodeUPCE.UPCETran(string);
        } else {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth("" + string.charAt(0));
        int n4 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBuffer.length() + stringBuffer2.length() + 1) * f5 / 2.0f + (float)(n3 / 2))) : (f2 = (float)this.centreX - (float)stringBuffer.length() * f5 / 2.0f);
        int n5 = 0;
        while (n5 < stringBuffer.length()) {
            if (stringBuffer.charAt(n5) == '1') {
                graphics2D.setColor(this.foreColor);
                if (n5 < 4 || n5 >= stringBuffer.length() - 6) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (n5 < 4 || n5 >= stringBuffer.length() - 6) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
            ++n5;
        }
        graphics2D.setColor(this.foreColor);
        graphics2D.setFont(this.bottomLabelFont);
        BarcodeUtil.printBarcodeDataB(String.valueOf(string.charAt(0)), graphics2D, (int)f2, (int)(f3 + f4));
        if (string.length() == 7) {
            BarcodeUtil.printBarcodeDataM(string.substring(1), graphics2D, (int)((f - 6.0f * f5) / 2.0f + (f2 + 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 9.0f * f5 - f2));
            BarcodeUtil.printBarcodeDataA(String.valueOf(n), graphics2D, (int)f, (int)(f3 + f4));
        } else {
            BarcodeUtil.printBarcodeDataM(string.substring(1, 7), graphics2D, (int)((f - 6.0f * f5) / 2.0f + (f2 + 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 9.0f * f5 - f2));
            BarcodeUtil.printBarcodeDataA(String.valueOf(string.charAt(7)), graphics2D, (int)f, (int)(f3 + f4));
        }
        if (this.EAN13Translate) {
            float f8 = f = f + (float)n3 + f5;
            int n6 = 0;
            while (n6 < stringBuffer2.length()) {
                if (stringBuffer2.charAt(n6) == '1') {
                    graphics2D.setColor(this.foreColor);
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                } else if (this.isExPDF) {
                    if (this.backColor != null) {
                        graphics2D.setColor(this.backColor);
                    } else {
                        graphics2D.setColor(Color.white);
                    }
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                }
                f += f5;
                ++n6;
            }
            graphics2D.setColor(this.foreColor);
            BarcodeUtil.printBarcodeDataU(this.supplementText, graphics2D, (int)((f8 + f) / 2.0f), (int)(f4 + f7), (int)(f - f8));
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n3 * 2)), (int)(f3 + (float)(n4 * 2)));
        this.paper.setBarDimension(this.barD);
    }
}

