/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import jet.Env;
import jet.JRStopEngineException;
import jet.JResource;
import jet.connect.DbBinary;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBarcode;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSMap;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextBox;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.rtf.BaseTool;
import jet.export.rtf.CTCell;
import jet.export.rtf.CTLayoutManager;
import jet.export.rtf.CrossTableRow;
import jet.export.rtf.PropertyInfo;
import jet.export.rtf.ShapeInfo;
import jet.export.rtf.api.FontInfo;
import jet.export.rtf.reLayout.FlowTableLayout;
import jet.export.rtf.reLayout.ObjectRect;
import jet.export.rtf.reLayout.TableInfo;
import jet.export.util.CCUtil;
import jet.export.util.DSShapeRegion;
import jet.export.util.ImageEncoder;
import jet.export.util.ImageEngine;
import jet.export.util.ImageInfo;
import jet.thinviewer.JReportBarcode;
import jet.thinviewer.JReportMap;
import jet.udo.JRObjectRender;
import jet.util.BitmapReader;
import jet.util.Containable;
import jet.util.FontSets;
import jet.util.PictureFileFormatDetector;
import jet.util.Propertiable;

class ExportToRtfFlow
extends BaseTool {
    private static final Toolkit C = Toolkit.getDefaultToolkit();
    public static final String EXP = ".rtf";
    private static final int[] FALSE = new int[]{20, 1, 2, 3, 19, 202, 75, 24};
    public static final String[] NEWBORDERWIDTH = new String[]{"border-top-width", "border-left-width", "border-bottom-width", "border-right-width"};
    public static final String[] NEWBORDERCOLOR = new String[]{"border-top-color", "border-left-color", "border-bottom-color", "border-right-color"};
    private static final String[] QOIV = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    public static final int ALIGN_LEFTTOP = 0;
    public static final int ALIGN_CENTERTOP = 1;
    public static final int ALIGN_RIGHTTOP = 2;
    public static final int ALIGN_LEFTCENTER = 3;
    public static final int ALIGN_CENTERCENTER = 4;
    public static final int ALIGN_RIGHTCENTER = 5;
    public static final int ALIGN_LEFTBOTTOM = 6;
    public static final int ALIGN_CENTERBOTTOM = 7;
    public static final int ALIGN_RIGHTBOTTOM = 8;
    public static final int ALIGN_JUSTIFYTOP = 9;
    public static final int ALIGN_JUSTIFYCENTER = 10;
    public static final int ALIGN_JUSTIFYBOTTOM = 11;
    private static final String[] WHITE = new String[]{"\\ql", "\\qc", "\\qr", "\\qj"};
    public static final int CENTER_X = 2;
    public static final int CENTER_Y = 1;
    public static final int DELTA_X = 3;
    public static final int DELTA_Y = 2;
    public static final int TOP_LINE = 20;
    public static final int BOTTOM_LINE = 12;
    public static final String EVAL = "JReport Evaluation Copy";
    public static final String CONTACT = "to purchase contact " + JResource.getMessage("Sale");
    public static final String PHONE = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
    public static final String EVALFONT = "*ArialNarrow";
    public static final Font FT = FontSets.getFont("*ArialNarrow", 0, 20);
    public static final Font FB = FontSets.getFont("*ArialNarrow", 0, 12);
    public static final FontMetrics FMT = ExportToRtfFlow.getInstance(FT);
    public static final FontMetrics FMB = ExportToRtfFlow.getInstance(FB);
    public static final int TH = FMT.getHeight() * 20;
    public static final int BH = FMB.getHeight() * 20;
    public static final int TW = FMT.stringWidth("JReport Evaluation Copy") * 20;
    public static final int BW1 = FMB.stringWidth(CONTACT) * 20;
    public static final int BW2 = FMB.stringWidth(PHONE) * 20;
    public static final Color DEF_COLOR = Color.cyan;
    public static final int LINE_SPACEING = 280;
    private static final char[] _colSpan = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] _height = new String[]{"\\b", "\\i", "\\strike", "\\ul"};
    private static final int _isMergeHead = Unit.convertPixelToUnit(1, 1440);
    private static final Hashtable _isMergeRowHead = new Hashtable();
    private String _object;
    private String _rowSpan;
    private String _width;
    private boolean add;
    private boolean addImage;
    private boolean append;
    private boolean background;
    private Communicator black;
    private PrintWriter charAt;
    private StringBuffer close;
    private StringBuffer containsKey;
    private StringBuffer convertInchToPixel;
    private Hashtable convertPixelToUnit;
    private Hashtable convertUnitToCentimeter;
    private Vector convertUnitToPixel;
    private int createImage;
    private int currentTimeMillis;
    private int cyan;
    private int deIndent;
    private int delete;
    private int dispose;
    private int dx;
    private int dy;
    private int elementAt;
    private int elements;
    private int endsWith;
    private int equals;
    private int equalsIgnoreCase;
    private int error;
    private int exists;
    private int fillColor;
    private int fillRect;
    private int get;
    private int getAlignment;
    private int getAscent = 0;
    private int getBlue = 0;
    private BufferedOutputStream getBooleanProperty;
    private ImageEngine getBooleanPropertyByName;
    private static String[][] getBounds;
    private Stack getBytes;
    private Hashtable getCell = new Hashtable();
    private Hashtable getCellColor = new Hashtable();
    private static Integer[] getCells;

    public ExportToRtfFlow(Communicator communicator, boolean bl) {
        this.black = communicator;
        this._width = Env.temporaryPath;
        this.add = bl;
    }

    public void publish(BufferedOutputStream bufferedOutputStream, File file) throws JRStopEngineException, IOException {
        this.getBooleanProperty = bufferedOutputStream;
        this.DEF_COLOR();
    }

    private void BH() throws FileNotFoundException, UnsupportedEncodingException {
        this.convertUnitToPixel = new Vector();
        this.convertPixelToUnit = new Hashtable();
        this.convertUnitToCentimeter = new Hashtable();
        this.convertUnitToCentimeter.put("Times New Roman", new Integer(0));
        this.close = new StringBuffer(256);
        this.containsKey = new StringBuffer("{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2 Times New Roman;}");
        this.convertInchToPixel = new StringBuffer("{\\colortbl;");
        this.equals = -1;
        this.currentTimeMillis = 1;
        this.cyan = 1;
        this.deIndent = 1026;
        this.createImage = -1;
        this.equalsIgnoreCase = 0;
        this.background = false;
        this._rowSpan = this.black.getEncoding() != null ? this.black.getEncoding() : "Cp1252";
        this.getBooleanPropertyByName = new ImageEngine();
        this.BW1();
    }

    private synchronized void BW1() throws FileNotFoundException, UnsupportedEncodingException {
        File file;
        JRLog.indent("Create temp file");
        do {
            this._object = this._width + File.separatorChar + this.hashCode() + System.currentTimeMillis() + ".tmp";
        } while ((file = new File(this._object)).exists());
        this.charAt = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this._rowSpan));
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5403001, this._object);
        }
        JRLog.deIndent("Create temp file");
    }

    private void BW2() {
        String string = "\\ansi" + this.C(this._rowSpan);
        this.close.append("{\\rtf1").append("\\ansi");
        this.close.append(string);
        if (string.endsWith("cpg936")) {
            this.close.append("\\uc2 ");
        } else {
            this.close.append("\\uc1 ");
        }
        this.close.append("\\deff0\\deflang1033\\deflangfe1033\\jexpand");
    }

    private String C(String string) {
        int n = 0;
        while (n < getBounds.length) {
            if (getBounds[n][0].equalsIgnoreCase(string)) {
                return getBounds[n][1];
            }
            ++n;
        }
        return "cpg1252";
    }

    private int CONTACT(int n) {
        return Unit.convertUnitToPixel(n, 1440);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DEF_COLOR() throws IOException, JRStopEngineException {
        block11: {
            JRLog.indent("build RTF file.");
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4403002);
            }
            this.getBytes = new Stack();
            try {
                Object object;
                this.BH();
                this.BW2();
                DataStream dataStream = (DataStream)this.black.getDataStream(0);
                this.addImage = dataStream.ie() == 1;
                CommEnumeration commEnumeration = new CommEnumeration(this.black);
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer(64);
                while (commEnumeration.hasMoreElements()) {
                    this.getBytes.push(new Offset(0, 0));
                    object = (DSPage)commEnumeration.nextElement();
                    ++n;
                    Rectangle rectangle = ((DSPage)object).getPageArea();
                    Rectangle rectangle2 = ((DSPage)object).getPrintableArea();
                    if (rectangle != null) {
                        if (!this.add) {
                            this.fillColor = this.CONTACT(rectangle2.y);
                            this.get = this.CONTACT(rectangle2.x);
                            this.getAlignment = this.CONTACT(rectangle.width - (rectangle2.x + rectangle2.width));
                            this.fillRect = this.CONTACT(rectangle.height - (rectangle2.y + rectangle2.height));
                        }
                        this.dx = this.CONTACT(rectangle.width);
                        this.dy = this.CONTACT(rectangle.height);
                        this.delete = 0;
                        this.FALSE((DSPage)object, n, stringBuffer);
                    }
                    this.getBytes.pop();
                }
                object = new StringBuffer(128);
                ((StringBuffer)object).append("\\sectd");
                if (this.dx > this.dy) {
                    ((StringBuffer)object).append("\\lndscpsxn");
                }
                ((StringBuffer)object).append("\\pgwsxn").append(this.dx).append("\\pghsxn").append(this.dy).append("\\marglsxn").append(this.get).append("\\margrsxn").append(this.getAlignment).append("\\margtsxn").append(this.fillColor + this.getAscent).append("\\margbsxn").append(this.fillRect + this.getBlue).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
                this.charAt.write(((StringBuffer)object).toString());
                this.charAt.write(125);
                this.charAt.close();
                if (this.equals != -1) {
                    this.close.append("\\deftab").append(this.equals);
                }
                this.close.append(this.containsKey.append('}').toString()).append(this.convertInchToPixel.append('}').toString()).append(stringBuffer.toString()).append("\n");
                this.getObject();
                Object var9_8 = null;
                this.getBooleanPropertyByName = null;
                this.charAt.close();
                File file = new File(this._object);
                if (!file.exists()) break block11;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.getBooleanPropertyByName = null;
                this.charAt.close();
                File file = new File(this._object);
                if (file.exists()) {
                    file.delete();
                }
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, 4403003);
                }
                JRLog.deIndent("build RTF file.");
                throw throwable;
            }
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4403003);
        }
        JRLog.deIndent("build RTF file.");
        JRLog.deIndent("RTF Exporter");
        this.getBytes = null;
    }

    private void FALSE(DSPage dSPage, int n, StringBuffer stringBuffer) throws IOException {
        StringBuffer stringBuffer2;
        JRObjectResult jRObjectResult;
        int n2 = dSPage.size();
        if (n2 == 0) {
            return;
        }
        ArrayList<JRObjectResult> arrayList = new ArrayList<JRObjectResult>(n2);
        int n3 = -1;
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector<JRObjectResult> vector2 = new Vector<JRObjectResult>();
        int n4 = 0;
        while (n4 < n2) {
            jRObjectResult = this.getRealObject(dSPage.getObject(n4));
            if (this.isExport(jRObjectResult)) {
                n3 = jRObjectResult.getObjectType();
                if (n3 == 514) {
                    this.getAscent = this.CONTACT(((DSContainer)jRObjectResult).getHeight());
                }
                if (n3 == 16) {
                    if (n3 == 22) {
                        vector2.add(jRObjectResult);
                    } else {
                        vector.add(jRObjectResult);
                    }
                } else {
                    arrayList.add(jRObjectResult);
                }
            }
            ++n4;
        }
        Color color = this.black.getHeaderInfo((int)0).background;
        if (n == 1) {
            stringBuffer.append("{\\stylesheet").append("\\viewkind1\\viewscale100}").append("\\paperw").append(this.dx).append("\\paperh").append(this.dy).append("\\margl").append(this.get).append("\\margr").append(this.getAlignment).append("\\margt").append(this.fillColor + this.getAscent).append("\\margb").append(this.fillRect + this.getBlue);
            if (this.dx > this.dy) {
                stringBuffer.append("\\landscape");
            }
            stringBuffer.append("\\viewbksp1{\\*\\background {\\shp{\\*\\shpinst\\shpleft0\\shptop0\\shpright0\\shpbottom0\\shpfhdr0\\shpbxmargin\\shpbxignore\\shpbymargin\\shpbyignore\\shpwr0\\shpwrk0\\shpfblwtxt1");
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv 1}}{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv " + this.getImage(color) + "}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv 1}}{\\sp{\\sn lineWidth}{\\sv 0}}{\\sp{\\sn fLine}{\\sv 0}}{\\sp{\\sn bWMode}{\\sv 9}}{\\sp{\\sn fBackground}{\\sv 1}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}}}}");
            stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("\\sectd");
            if (this.dx > this.dy) {
                stringBuffer2.append("\\lndscpsxn");
            }
            stringBuffer2.append("\\pgwsxn").append(this.dx).append("\\pghsxn").append(this.dy).append("\\marglsxn").append(this.get).append("\\margrsxn").append(this.getAlignment).append("\\margtsxn").append(this.fillColor + this.getAscent).append("\\margbsxn").append(this.fillRect + this.getBlue).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
            this.charAt.write(stringBuffer2.toString());
        } else {
            stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("{\\fs2 \\sect}\n");
            stringBuffer2.append("\\sectd");
            if (this.dx > this.dy) {
                stringBuffer2.append("\\lndscpsxn");
            }
            stringBuffer2.append("\\pgwsxn").append(this.dx).append("\\pghsxn").append(this.dy).append("\\marglsxn").append(this.get).append("\\margrsxn").append(this.getAlignment).append("\\margtsxn").append(this.fillColor + this.getAscent).append("\\margbsxn").append(this.fillRect + this.getBlue).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
            this.charAt.write(stringBuffer2.toString());
        }
        int n5 = 0;
        while (n5 < arrayList.size()) {
            jRObjectResult = (JRObjectResult)arrayList.get(n5);
            n3 = jRObjectResult.getObjectType();
            this.endsWith = 0;
            this.exists = 0;
            this.error = 0;
            if (jRObjectResult instanceof DSSection) {
                this.equalsIgnoreCase = 1;
                DSSection dSSection = (DSSection)jRObjectResult;
                this.equalsIgnoreCase = 0;
                this.FB(jRObjectResult, n3, 0);
            } else {
                this.equalsIgnoreCase = 0;
                this.FB(jRObjectResult, n3, 0);
            }
            ++n5;
        }
        int n6 = this.convertUnitToPixel.size();
        while (--n6 >= 0) {
            this.charAt.write(this.getEncoding((ShapeInfo)this.convertUnitToPixel.elementAt(n6)));
        }
        int n7 = vector.size();
        while (--n7 >= 0) {
            this.getDefaultToolkit((DSShape)vector.elementAt(n7));
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.getDefaultToolkit((DSShape)enumeration.nextElement());
        }
        if (this.addImage) {
            this.getDescent();
        }
    }

    private void FB(JRObjectResult jRObjectResult, int n, int n2) throws IOException {
        if ((n & 0x20) == 32) {
            switch (n) {
                case 33: 
                case 37: 
                case 45: {
                    this.dx((DSSubReport)jRObjectResult, n2);
                    break;
                }
                case 262178: {
                    this._isMergeRowHead((DSParagraph)jRObjectResult, n2);
                    break;
                }
                case 34: {
                    this.getBlue((DSCrossTab)jRObjectResult, n2);
                    break;
                }
                case 46: {
                    this.QOIV((DSTabular)jRObjectResult, n2);
                    break;
                }
                case 262179: {
                    this.getBounds((DSTableObject)jRObjectResult, n2);
                    break;
                }
                case 47: {
                    this.TW((DSTabularCell)jRObjectResult, n2);
                    break;
                }
                case 36: 
                case 262181: {
                    this.getColorProperty((DSContainer)jRObjectResult, n2);
                    break;
                }
                case 40: {
                    this.FMT((DSMap)jRObjectResult, n2);
                    break;
                }
                case 262183: {
                    this.FT((DSMultiValueContainer)jRObjectResult, n2);
                    break;
                }
                case 16385: {
                    this.getDataStream((DSTable)jRObjectResult, n2);
                    break;
                }
                default: {
                    this.FMB((DSContainer)jRObjectResult, n2);
                    break;
                }
            }
        } else if ((n & 0x100) == 256) {
            this.addImage((DSField)jRObjectResult, n, n2);
        } else if ((n & 0x200) == 512) {
            this.NEWBORDERCOLOR((DSSection)jRObjectResult, n2);
        } else if ((n & 0x80) == 128) {
            if (n == 128) {
                this.exists((DSPicture)jRObjectResult, n2);
            } else if (n == 129) {
                this.error((DSPicture)jRObjectResult, n2);
            }
        } else if (n == 71) {
            this.getAscent((DSChartPlatform)jRObjectResult, n2);
        } else if (n == 524291) {
            this.add((DSParagraphText)jRObjectResult, n2);
        } else if (n == 4096) {
            this.equalsIgnoreCase((JRVisiableResult)jRObjectResult, n2);
        } else if (jRObjectResult instanceof DSShape) {
            DSShape dSShape = (DSShape)jRObjectResult;
            this.getDefaultToolkit(dSShape);
        } else if (JRLog.isTrace(3)) {
            JRLog.trace(3, 3403001, jRObjectResult);
        }
    }

    private void FMB(DSContainer dSContainer, int n) throws IOException {
        List list = this.zOrder(dSContainer.getChildren());
        this.dy(dSContainer, n);
        int n2 = list.size();
        if (n2 != 0) {
            this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
            int n3 = dSContainer.getStartYPos();
            int n4 = 0;
            while (n4 < list.size()) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
                if (this.isExport(jRObjectResult)) {
                    this.FB(jRObjectResult, jRObjectResult.getObjectType(), n3);
                }
                ++n4;
            }
            this.getBytes.pop();
        }
    }

    private void FMT(DSMap dSMap, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSMap.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSMap, n));
        int n4 = dSMap.getWidth();
        int n5 = dSMap.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        JReportMap jReportMap = new JReportMap();
        Image image = jReportMap.getMapImage(dSMap);
        switch (this.getMapImage(dSMap)) {
            case 1: {
                this.getAlignment(image, false, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 2: {
                this.getAlignment(image, true, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 3: {
                this.fillRect(image, n4, n5);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSMap.getParent()) instanceof DSParagraph && !dSMap.equals(dSMap.getParent().getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.fillRect(image, n4, n5);
                this.charAt.write("{\\par}");
            }
        }
    }

    private void FT(DSMultiValueContainer dSMultiValueContainer, int n) throws IOException {
        Render render = dSMultiValueContainer.getRender();
        this.append(render, dSMultiValueContainer, n);
        this.getFontRender(dSMultiValueContainer, n);
    }

    private void NEWBORDERCOLOR(DSSection dSSection, int n) throws IOException {
        Vector vector = dSSection.getChildren();
        int n2 = dSSection.getStartYPos();
        switch (this.getMapImage(dSSection)) {
            case 1: {
                ++this.error;
                this.dy(dSSection, n);
                this.getFontName(dSSection, n);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSSection.getX(), this.getY(dSSection, n)));
                int n3 = 0;
                while (n3 < vector.size()) {
                    JRObjectResult jRObjectResult = this.getRealObject((JRObjectResult)vector.get(n3));
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                    ++n3;
                }
                --this.error;
                break;
            }
            default: {
                ++this.endsWith;
                this.NEWBORDERWIDTH(dSSection);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSSection.getX(), this.getY(dSSection, n)));
                int n4 = 0;
                while (n4 < vector.size()) {
                    JRObjectResult jRObjectResult = this.getRealObject((JRObjectResult)vector.get(n4));
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                    ++n4;
                }
                this.PHONE(dSSection);
                --this.endsWith;
                break;
            }
        }
        this.getBytes.pop();
    }

    private void NEWBORDERWIDTH(DSContainer dSContainer) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = Unit.convertUnitToPixel(dSContainer.getWidth(), 1440);
        int n2 = Unit.convertUnitToPixel(dSContainer.getHeight(), 1440);
        Color color = CCUtil.getColorPropertyByName(dSContainer, "Background");
        if (this.endsWith <= 1) {
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\n");
        } else {
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto\\rin0\\lin0").append("\\itap").append(this.endsWith).append("\n");
        }
        this.charAt.write(stringBuffer.toString());
    }

    private void PHONE(DSContainer dSContainer) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = Unit.convertUnitToPixel(dSContainer.getWidth(), 1440);
        int n2 = Unit.convertUnitToPixel(dSContainer.getHeight(), 1440);
        Color color = CCUtil.getColorPropertyByName(dSContainer, "Background");
        if (this.endsWith <= 1) {
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n);
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0\\cgrid\\langnp1033\\langfenp2052 {\\cell}").append("\n");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\nowrap\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0 {");
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\\row }");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto").append("\n");
        } else {
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0").append("\\itap").append(this.endsWith).append("{\\nestcell{\\nonesttables\\par}}").append("\n");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0").append("\\itap").append(this.endsWith);
            stringBuffer.append("{{\\*\\nesttableprops");
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\\nestrow}{\\nonesttables\\par}}").append("\n");
        }
        this.charAt.write(stringBuffer.toString());
    }

    private void QOIV(DSTabular dSTabular, int n) throws IOException {
        JRObjectResult jRObjectResult;
        int n2;
        Vector vector = dSTabular.getChildren();
        int n3 = dSTabular.getStartYPos();
        switch (this.getMapImage(dSTabular)) {
            case 1: {
                ++this.error;
                this.dy(dSTabular, n);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSTabular.getX(), this.getY(dSTabular, n)));
                n2 = 0;
                while (n2 < vector.size()) {
                    jRObjectResult = (JRObjectResult)vector.get(n2);
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n3);
                    }
                    ++n2;
                }
                --this.error;
            }
        }
        ++this.error;
        n2 = this.CONTACT(dSTabular.getWidth());
        int n4 = this.CONTACT(dSTabular.getHeight());
        this.TH(n2, n4);
        this.dy(dSTabular, n);
        this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSTabular.getX(), this.getY(dSTabular, n)));
        int n5 = 0;
        while (n5 < vector.size()) {
            jRObjectResult = (JRObjectResult)vector.get(n5);
            if (this.isExport(jRObjectResult)) {
                this.FB(jRObjectResult, jRObjectResult.getObjectType(), n3);
            }
            ++n5;
        }
        --this.error;
    }

    private void TH(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}").append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private void TW(DSTabularCell dSTabularCell, int n) throws IOException {
        Vector vector = dSTabularCell.getChildren();
        int n2 = dSTabularCell.getStartYPos();
        this.dy(dSTabularCell, n);
        int n3 = this.CONTACT(dSTabularCell.getWidth());
        int n4 = this.CONTACT(dSTabularCell.getHeight());
        this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSTabularCell.getX(), this.getY(dSTabularCell, n)));
        this.append = true;
        this.elements = n4;
        this.elementAt = n3;
        int n5 = 0;
        while (n5 < vector.size()) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n5);
            if (this.isExport(jRObjectResult)) {
                this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
            }
            ++n5;
        }
        this.append = false;
        this.getBytes.pop();
    }

    private void WHITE(DSParagraph dSParagraph, int n, StringBuffer stringBuffer) throws IOException {
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector vector2 = dSParagraph.getChildren();
        int n2 = dSParagraph.getStartYPos();
        this._isMergeHead(dSParagraph, stringBuffer);
        this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
        int n3 = 0;
        while (n3 < vector2.size()) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector2.get(n3);
            int n4 = jRObjectResult.getObjectType();
            if ((n4 & 0x100) == 256) {
                this._height((DSField)jRObjectResult, n2, stringBuffer);
            } else if (jRObjectResult instanceof DSParagraphText) {
                this._width((DSParagraphText)jRObjectResult, n2, stringBuffer);
            } else if (n4 == 128) {
                if (this.getMapImage((JRVisiableResult)jRObjectResult) == 2) {
                    vector.add(jRObjectResult);
                } else {
                    this._colSpan((DSPicture)jRObjectResult, n2, stringBuffer);
                }
            } else if (JRLog.isAd()) {
                JRLog.print("Export to flow rtf, can not handle this object, its type is:(" + n4 + ")");
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < vector.size()) {
            this._colSpan((DSPicture)vector.get(n5), n2, stringBuffer);
            ++n5;
        }
        int n6 = this.getGreen(CCUtil.getIntPropertyByName(dSParagraph, "FontSize"));
        stringBuffer.append("{\\fs" + n6 + "\\par}\n");
        this.getBytes.pop();
    }

    private void _colSpan(DSPicture dSPicture, int n, StringBuffer stringBuffer) throws IOException {
        ImageInfo imageInfo = this.getBooleanPropertyByName.getImage(true, false, dSPicture);
        Image image = imageInfo.getImage();
        if (image == null) {
            return;
        }
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.getY(dSPicture, n) + offset.dy;
        int n3 = this.CONTACT(dSPicture.getX() + offset.dx);
        int n4 = this.CONTACT(n2);
        int n5 = dSPicture.getWidth();
        int n6 = dSPicture.getHeight();
        if (this.createImage > 0 && this.createImage < n2 + n6) {
            if (this.createImage < n2) {
                return;
            }
            n6 = this.createImage - n2;
        }
        int n7 = n3 + this.CONTACT(n5);
        int n8 = n4 + this.CONTACT(n6);
        switch (this.getMapImage(dSPicture)) {
            case 1: {
                this.get(image, false, n3, n4, n5, n6, n7, n8, 0, null, stringBuffer);
                break;
            }
            case 2: {
                this.get(image, true, n3, n4, n5, n6, n7, n8, 0, null, stringBuffer);
                break;
            }
            case 3: {
                this.fillColor(image, n5, n6, stringBuffer);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSPicture.getParent()) instanceof DSParagraph && !dSPicture.equals(dSPicture.getParent().getChildren().get(0))) {
                    stringBuffer.append("{\\par}");
                }
                this.fillColor(image, n5, n6, stringBuffer);
                stringBuffer.append("{\\par}");
            }
        }
    }

    private void _height(DSField dSField, int n, StringBuffer stringBuffer) throws IOException {
        this.getColNum(dSField, 0, 0, stringBuffer, n);
    }

    private void _isMergeHead(DSParagraph dSParagraph, StringBuffer stringBuffer) {
        int n = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_line");
        int n2 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_Left");
        int n3 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_Right");
        float f = Unit.convertUnitToPixel(CCUtil.getFloatPropertyByName(dSParagraph, "Spacing_line"), 1440);
        int n4 = CCUtil.getBooleanPropertyByName(dSParagraph, "Spacing_type") ? 1 : 0;
        int n5 = CCUtil.getIntPropertyByName(dSParagraph, "HorizontalAlignment");
        int n6 = CCUtil.getIntPropertyByName(dSParagraph, "Spacing_Before");
        int n7 = CCUtil.getIntPropertyByName(dSParagraph, "Spacing_After");
        int n8 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_hang");
        if (this.equals != 0) {
            this.equals = CCUtil.getIntPropertyByName(dSParagraph, "TAB_defaultStop");
        }
        n = Unit.convertUnitToPixel(n, 1440);
        n8 = Unit.convertUnitToPixel(n8, 1440);
        n2 = Unit.convertUnitToPixel(n2, 1440);
        n3 = Unit.convertUnitToPixel(n3, 1440);
        n6 = Unit.convertUnitToPixel(n6, 1440);
        n7 = Unit.convertUnitToPixel(n7, 1440);
        int[] nArray = dSParagraph.getStops();
        int[] nArray2 = dSParagraph.getAlignment();
        int[] nArray3 = dSParagraph.getLeaders();
        stringBuffer.append("\\pard\\plain");
        switch (n5) {
            case 0: {
                stringBuffer.append("\\ql");
                break;
            }
            case 1: {
                stringBuffer.append("\\qr");
                break;
            }
            case 2: {
                stringBuffer.append("\\qc");
                break;
            }
            case 3: {
                stringBuffer.append("\\qj");
            }
        }
        if (n >= 0 && n8 == 0) {
            stringBuffer.append("\\fi").append(n);
        } else {
            stringBuffer.append("\\fi").append(-n8);
        }
        stringBuffer.append("\\li").append(n2).append("\\ri").append(n3);
        if (this.background) {
            n6 += Unit.convertUnitToPixel(dSParagraph.getY(), 1440);
        }
        if (n6 > 0) {
            stringBuffer.append("\\sb").append(n6);
        }
        stringBuffer.append("\\sa").append(n7).append("\\widctlpar");
        if (nArray != null) {
            int n9 = 0;
            while (n9 < nArray.length) {
                int n10 = nArray[n9];
                int n11 = nArray2[n9];
                int n12 = nArray3[n9];
                switch (n11) {
                    case 2: {
                        stringBuffer.append("\\tqr");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("\\tqc");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("\\tqdec");
                        break;
                    }
                    default: {
                        stringBuffer.append("\\tql");
                    }
                }
                stringBuffer.append("\\tx").append(n10);
                switch (n12) {
                    case 1: {
                        stringBuffer.append("");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("\\tldot");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("\\tlhyph");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("\\tlul");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("\\tlmdot");
                    }
                }
                ++n9;
            }
        }
        stringBuffer.append("\\sl").append((int)f).append("\\slmult").append(n4);
        stringBuffer.append("\\nowidctlpar\\aspalpha\\aspnum").append("\\faauto\\adjustright").append("\\itap").append(this.endsWith).append("\\cgrig\\langnp1033\\langfeng2052 ");
    }

    private void _isMergeRowHead(DSParagraph dSParagraph, int n) throws IOException {
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector vector2 = dSParagraph.getChildren();
        int n2 = dSParagraph.getStartYPos();
        switch (this.getMapImage(dSParagraph)) {
            case 1: {
                this.dy(dSParagraph, n);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                int n3 = 0;
                while (n3 < vector2.size()) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector2.get(n3);
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                    ++n3;
                }
                break;
            }
            default: {
                this._object(dSParagraph);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                int n4 = 0;
                while (n4 < vector2.size()) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector2.elementAt(n4);
                    if (jRObjectResult instanceof DSPicture && this.getMapImage((JRVisiableResult)jRObjectResult) == 2) {
                        vector.add(jRObjectResult);
                    } else {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < vector.size()) {
                    this.exists((DSPicture)vector.get(n5), n2);
                    ++n5;
                }
                int n6 = this.getGreen(CCUtil.getIntPropertyByName(dSParagraph, "FontSize"));
                this.charAt.write("{\\fs" + n6 + "\\par}\n");
                break;
            }
        }
        this.getBytes.pop();
    }

    private void _object(DSParagraph dSParagraph) {
        StringBuffer stringBuffer = new StringBuffer(128);
        this._isMergeHead(dSParagraph, stringBuffer);
        this.charAt.write(stringBuffer.toString());
    }

    private void _rowSpan(DSField dSField, int n) throws IOException {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        Offset offset = (Offset)this.getBytes.peek();
        nArray2[0] = this.CONTACT(dSField.getX() + offset.dx);
        nArray2[1] = this.CONTACT(this.getY(dSField, n) + offset.dy);
        nArray2[2] = this.CONTACT(dSField.getWidth());
        nArray2[3] = this.CONTACT(dSField.getHeight());
        String string = "";
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "Foreground");
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Underline");
        String string2 = CCUtil.getStringPropertyByName(dSField, "FontFace");
        int n2 = CCUtil.getIntPropertyByName(dSField, "FontSize");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSField, "Bold");
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSField, "Italic");
        int n3 = this.getHGap(string2);
        string2 = this.getHeaderInfo(string2);
        if (bl) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSField, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSField, "StrikeoutlineColor");
        }
        if (bl2) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSField, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSField, "UnderlineColor");
        }
        if (n3 != -1) {
            if ((n3 & 1) == 1) {
                nArray[0] = 1;
            }
            if ((n3 & 2) == 2) {
                nArray[1] = 1;
            }
        } else {
            if (bl3) {
                nArray[0] = 1;
            }
            if (bl4) {
                nArray[1] = 1;
            }
        }
        nArray[4] = this.getGreen(n2);
        Render render = dSField.getRender();
        switch (this.getMapImage(dSField)) {
            case 1: {
                this.append(render, dSField, n);
                break;
            }
            default: {
                if (render instanceof RenderText) {
                    RenderText renderText = (RenderText)render;
                    Vector vector = renderText.getVLines();
                    if (vector != null && vector.size() != 0) {
                        int n4 = 0;
                        while (n4 < vector.size()) {
                            string = (String)vector.get(n4);
                            ++n4;
                        }
                    }
                    this.dispose(string, nArray, 1, string2, colorArray, color2, color);
                    break;
                }
                if (render instanceof RenderList || render instanceof RenderDropDownList) {
                    this.background(render, dSField, n);
                    break;
                }
                this.black(dSField, n);
            }
        }
    }

    private void _width(DSParagraphText dSParagraphText, int n, StringBuffer stringBuffer) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        boolean bl = dSParagraphText.getIsTab();
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.getY(dSParagraphText, n) + offset.dy;
        int n3 = dSParagraphText.getHeight();
        if (this.createImage > 0 && this.createImage < n2 + n3) {
            if (this.createImage < n2) {
                return;
            }
            n3 = this.createImage - n2;
        }
        nArray2[0] = this.CONTACT(dSParagraphText.getX() + offset.dx);
        nArray2[1] = this.CONTACT(n2);
        nArray2[2] = this.CONTACT(dSParagraphText.getWidth());
        nArray2[3] = this.CONTACT(n3);
        String string = dSParagraphText.getText();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        String string2 = CCUtil.getStringPropertyByName(dSParagraphText, "FontFace");
        int n4 = CCUtil.getIntPropertyByName(dSParagraphText, "FontSize");
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold");
        boolean bl5 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic");
        int n5 = this.getHGap(string2);
        string2 = this.getHeaderInfo(string2);
        if (bl2) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
        }
        if (bl3) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
        }
        if (n5 != -1) {
            if ((n5 & 1) == 1) {
                nArray[0] = 1;
            }
            if ((n5 & 2) == 2) {
                nArray[1] = 1;
            }
        } else {
            if (bl4) {
                nArray[0] = 1;
            }
            if (bl5) {
                nArray[1] = 1;
            }
        }
        nArray[4] = this.getGreen(n4);
        int n6 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript");
        Font font = FontSets.getFont(string2, 0 | (bl4 ? 1 : 0) | (bl5 ? 2 : 0), Unit.convertUnitToPixel(n4));
        if (bl && this.getMapImage(dSParagraphText) != 1) {
            stringBuffer.append("{\\tab}");
        } else {
            switch (this.getMapImage(dSParagraphText)) {
                case 1: {
                    if (n6 > 0) {
                        n4 = n4 * 2 / 3;
                    }
                    nArray[4] = this.getGreen(n4);
                    Vector vector = dSParagraphText.getWords();
                    int[] nArray3 = dSParagraphText.getWordsPosition();
                    int n7 = nArray2[0];
                    int n8 = nArray2[2];
                    nArray2[3] = Unit.convertUnitToPixel(dSParagraphText.getTextHeight(), 1440);
                    if (vector.size() != 0) {
                        int n9 = 0;
                        while (n9 < vector.size()) {
                            nArray2[0] = n7;
                            nArray2[2] = n8;
                            String string3 = (String)vector.get(n9);
                            int n10 = Unit.convertUnitToPixel(nArray3[n9], 1440);
                            nArray2[0] = nArray2[0] + n10;
                            nArray2[2] = nArray2[2] - n10;
                            this.convertUnitToPixel(false, nArray2, string3, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, stringBuffer);
                            ++n9;
                        }
                        break;
                    }
                    this.convertUnitToPixel(false, nArray2, string, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, stringBuffer);
                    break;
                }
                default: {
                    this.delete(string, nArray, n6, string2, colorArray, color2, color, stringBuffer);
                }
            }
        }
    }

    private void add(DSParagraphText dSParagraphText, int n) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        boolean bl = dSParagraphText.getIsTab();
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.getY(dSParagraphText, n) + offset.dy;
        int n3 = dSParagraphText.getHeight();
        if (this.createImage > 0 && this.createImage < n2 + n3) {
            if (this.createImage < n2) {
                return;
            }
            n3 = this.createImage - n2;
        }
        nArray2[0] = this.CONTACT(dSParagraphText.getX() + offset.dx);
        nArray2[1] = this.CONTACT(n2);
        nArray2[2] = this.CONTACT(dSParagraphText.getWidth());
        nArray2[3] = this.CONTACT(n3);
        String string = dSParagraphText.getText();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        String string2 = CCUtil.getStringPropertyByName(dSParagraphText, "FontFace");
        int n4 = CCUtil.getIntPropertyByName(dSParagraphText, "FontSize");
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold");
        boolean bl5 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic");
        int n5 = this.getHGap(string2);
        string2 = this.getHeaderInfo(string2);
        if (bl2) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
        }
        if (bl3) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
        }
        if (n5 != -1) {
            if ((n5 & 1) == 1) {
                nArray[0] = 1;
            }
            if ((n5 & 2) == 2) {
                nArray[1] = 1;
            }
        } else {
            if (bl4) {
                nArray[0] = 1;
            }
            if (bl5) {
                nArray[1] = 1;
            }
        }
        nArray[4] = this.getGreen(n4);
        int n6 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript");
        Font font = FontSets.getFont(string2, 0 | (bl4 ? 1 : 0) | (bl5 ? 2 : 0), Unit.convertUnitToPixel(n4));
        if (bl && this.getMapImage(dSParagraphText) != 1) {
            this.charAt.write("{\\tab}");
        } else {
            switch (this.getMapImage(dSParagraphText)) {
                case 1: {
                    if (n6 > 0) {
                        n4 = n4 * 2 / 3;
                    }
                    nArray[4] = this.getGreen(n4);
                    Vector vector = dSParagraphText.getWords();
                    int[] nArray3 = dSParagraphText.getWordsPosition();
                    int n7 = nArray2[0];
                    int n8 = nArray2[2];
                    nArray2[3] = Unit.convertUnitToPixel(dSParagraphText.getTextHeight(), 1440);
                    if (vector.size() != 0) {
                        int n9 = 0;
                        while (n9 < vector.size()) {
                            nArray2[0] = n7;
                            nArray2[2] = n8;
                            String string3 = (String)vector.get(n9);
                            int n10 = Unit.convertUnitToPixel(nArray3[n9], 1440);
                            nArray2[0] = nArray2[0] + n10;
                            nArray2[2] = nArray2[2] - n10;
                            this.createImage(false, nArray2, string3, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false);
                            ++n9;
                        }
                        break;
                    }
                    this.createImage(false, nArray2, string, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false);
                    break;
                }
                default: {
                    this.dispose(string, nArray, n6, string2, colorArray, color2, color);
                }
            }
        }
    }

    private void addImage(DSField dSField, int n, int n2) throws IOException {
        if (n == 264) {
            try {
                this.currentTimeMillis((DSBarcode)dSField, n2);
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403002, (Throwable)exception);
                }
            }
        } else if (dSField.getParent() instanceof DSParagraph || dSField.getParent() instanceof DSTextBox && this.getMapImage(dSField) == 3) {
            this._rowSpan(dSField, n2);
        } else {
            this.append(dSField.getRender(), dSField, n2);
        }
    }

    private void append(Render render, JRVisiableResult jRVisiableResult, int n) throws IOException {
        if (render instanceof RenderText) {
            RenderText renderText = (RenderText)render;
            this.charAt(renderText, jRVisiableResult, n);
        } else if (render instanceof RenderList || render instanceof RenderDropDownList) {
            this.background(render, jRVisiableResult, n);
        } else {
            this.black(jRVisiableResult, n);
        }
    }

    private void background(Render render, JRVisiableResult jRVisiableResult, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n4 = jRVisiableResult.getWidth();
        int n5 = jRVisiableResult.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getIsTab(jRVisiableResult);
        n8 = n8 == 2 ? 3 : n8;
        Image image = render.getImage();
        switch (this.getMapImage(jRVisiableResult)) {
            case 1: {
                this.getAlignment(image, false, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 2: {
                if (this.exists == 0) {
                    this.getAlignment(image, true, n2, n3, n4, n5, n6, n7, 0, null);
                    break;
                }
                this.fillRect(image, n4, n5);
                break;
            }
            case 3: {
                this.fillRect(image, n4, n5);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)jRVisiableResult.getParent()) instanceof DSParagraph && !jRVisiableResult.equals(jRVisiableResult.getParent().getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.fillRect(image, n4, n5);
                this.charAt.write("{\\par}");
            }
        }
    }

    private void black(JRObjectResult jRObjectResult, int n) throws IOException {
        DSField dSField = (DSField)jRObjectResult;
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSField.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSField, n) + offset.dy);
        int n4 = dSField.getWidth();
        int n5 = dSField.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getIsTab(dSField);
        n8 = n8 == 2 ? 3 : n8;
        int n9 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        Render render = dSField.getRender();
        ImageInfo imageInfo = this.getBooleanPropertyByName.getImage(true, false, render);
        Image image = imageInfo.getImage();
        if (image == null) {
            if (color != null && this.getMapImage(dSField) == 1) {
                this.getFontMetrics(n2, n3, Unit.convertUnitToPixel(n4, 1440), Unit.convertUnitToPixel(n5, 1440), color);
            }
            if (color != null && this.getMapImage(dSField) != 1) {
                this.convertPixelToUnit(Unit.convertUnitToPixel(n4, 1440), Unit.convertUnitToPixel(n5, 1440), color);
            }
            return;
        }
        switch (this.getMapImage(dSField)) {
            case 1: {
                this.getAlignment(image, false, n2, n3, n4, n5, n6, n7, n9, color);
                break;
            }
            case 2: {
                if (this.exists == 0) {
                    this.getAlignment(image, true, n2, n3, n4, n5, n6, n7, n9, color);
                    break;
                }
                this.fillRect(image, n4, n5);
                break;
            }
            case 3: {
                this.fillRect(image, n4, n5);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSField.getParent()) instanceof DSParagraph && !dSField.equals(dSField.getParent().getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.fillRect(image, n4, n5);
                this.charAt.write("{\\par}");
            }
        }
    }

    private void charAt(RenderText renderText, JRObjectResult jRObjectResult, int n) {
        int n2;
        int n3;
        byte by;
        int n4;
        Object object;
        PropertyInfo propertyInfo;
        DSField dSField = (DSField)jRObjectResult;
        int[] nArray = new int[4];
        Offset offset = (Offset)this.getBytes.peek();
        nArray[0] = this.CONTACT(dSField.getX() + offset.dx);
        nArray[1] = this.CONTACT(this.getY(dSField, n) + offset.dy);
        nArray[2] = this.CONTACT(dSField.getWidth());
        nArray[3] = this.CONTACT(dSField.getHeight());
        int n5 = this.getIsTab(dSField);
        n5 = n5 == 2 ? 3 : n5;
        int n6 = 0;
        int n7 = CCUtil.getIntPropertyByName(dSField, "LeftLine");
        int n8 = CCUtil.getIntPropertyByName(dSField, "RightLine");
        int n9 = CCUtil.getIntPropertyByName(dSField, "TopLine");
        int n10 = CCUtil.getIntPropertyByName(dSField, "BottomLine");
        if (n7 != 0) {
            n6 = n7;
        } else if (n9 != 0) {
            n6 = n9;
        } else if (n8 != 0) {
            n6 = n8;
        } else if (n10 != 0) {
            n6 = n10;
        }
        int n11 = CCUtil.getIntPropertyByName(dSField, "BorderWidth");
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        int n12 = 1;
        int[] nArray2 = new int[7];
        DSTemplatible dSTemplatible = dSField.getTemplate();
        if (this.getCell.containsKey(dSTemplatible)) {
            propertyInfo = (PropertyInfo)this.getCell.get(dSTemplatible);
        } else {
            object = this.getStringProperty(dSField, "FontFace");
            int n13 = this.getHGap((String)object);
            boolean bl = false;
            n4 = 0;
            if (n13 != -1) {
                if ((n13 & 1) == 1) {
                    bl = true;
                }
                if ((n13 & 2) == 2) {
                    n4 = 1;
                }
            } else {
                bl = this.getBooleanProperty(dSField, "Bold");
                n4 = this.getBooleanProperty(dSField, "Italic");
            }
            boolean bl2 = this.getBooleanProperty(dSField, "Underline");
            propertyInfo = new PropertyInfo((String)object, this.getGridInfo(dSField), bl, n4 != 0, this.getBooleanProperty(dSField, "StrikeOut"));
            propertyInfo.Z = bl2;
            if (!this.getCellColor.containsKey(dSTemplatible)) {
                byte by2 = this.close(dSField, "Bold") ? (byte)0 : (this.close(dSField, "Italic") ? (byte)0 : (this.close(dSField, "FontFace") ? (byte)0 : (this.close(dSField, "FontSize") ? (byte)0 : (this.close(dSField, "StrikeOut") ? (byte)0 : (by = this.close(dSField, "Underline") ? (byte)0 : 1)))));
                if (by != 0) {
                    this.getCell.put(dSTemplatible, propertyInfo);
                } else {
                    this.getCellColor.put(dSTemplatible, Boolean.FALSE);
                }
            }
        }
        object = propertyInfo.getFontInfo();
        String string = ((FontInfo)object).getFontName();
        String string2 = dSField.toString();
        string = this.getHeaderInfo(string);
        if (((FontInfo)object).isBold()) {
            nArray2[0] = 1;
        }
        if (((FontInfo)object).isItalic()) {
            nArray2[1] = 1;
        }
        if (propertyInfo.I) {
            nArray2[2] = 1;
        }
        if (propertyInfo.Z) {
            nArray2[3] = 1;
        }
        n4 = CCUtil.getIntPropertyByName(dSField, "FontSize");
        nArray2[4] = this.getGreen(n4);
        Font font = propertyInfo.getFont();
        by = this.convertInchToPixel(dSField);
        if (dSField.getParent() instanceof DSParagraph && CCUtil.getIntPropertyByName(dSField, "position") != 2) {
            n12 = 6;
        } else {
            int n14 = CCUtil.getIntPropertyByName(dSField, "VerticalAlignment");
            n3 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
            switch (n14) {
                case 1: {
                    if (n3 == 0) {
                        n12 = 0;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 1;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 2;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 9;
                    break;
                }
                case 0: {
                    if (n3 == 0) {
                        n12 = 3;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 4;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 5;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 10;
                    break;
                }
                case 2: {
                    if (n3 == 0) {
                        n12 = 6;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 7;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 8;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 11;
                }
            }
        }
        Vector vector = renderText.getVLines();
        int n15 = n3 = vector == null ? 0 : vector.size();
        if (n3 > 0 && dSField.getParent() instanceof DSParagraph) {
            string2 = (String)vector.get(0);
        }
        Color color3 = CCUtil.getColorPropertyByName(dSField, "Foreground");
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
        FontRenderContext fontRenderContext = propertyInfo.getFontRender();
        if (!bl) {
            string2 = this.getNewColorProperty(string2, font, fontRenderContext, by, this.containsKey(dSField));
        }
        int[] nArray3 = this.elements(dSField);
        boolean bl3 = false;
        if (dSField.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            bl3 = true;
        }
        int[] nArray4 = this.endsWith(dSField, bl3);
        Color[] colorArray = this.equals(dSField, bl3);
        if (nArray3[0] != 0 && nArray4[0] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[0], 1440) / 2;
            nArray[1] = nArray[1] + n2;
            nArray[3] = nArray[3] - n2;
        }
        if (nArray3[2] != 0 && nArray4[2] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[2], 1440) / 2;
            nArray[3] = nArray[3] - n2;
        }
        if (nArray3[1] != 0 && nArray4[1] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[1], 1440) / 2;
            nArray[0] = nArray[0] + n2;
            nArray[2] = nArray[2] - n2;
        }
        if (nArray3[3] != 0 && nArray4[3] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[3], 1440) / 2;
            nArray[2] = nArray[2] - n2;
        }
        switch (this.getMapImage(dSField)) {
            case 1: {
                this.createImage(false, nArray, string2, nArray2, colorArray, font, n6, n11, n12, n3, n4, n5, string, color3, color, color2, bl);
                break;
            }
            case 2: {
                this.createImage(true, nArray, string2, nArray2, colorArray, font, n6, n11, n12, n3, n4, n5, string, color3, color, color2, bl);
                break;
            }
            case 3: {
                this.convertUnitToCentimeter(nArray, string2, nArray2, colorArray, n6, n11, n12, string, font, n4, n3, color3, color, color2, bl);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSField.getParent()) instanceof DSParagraph && !dSField.equals(((DSParagraph)dSField.getParent()).getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.convertUnitToCentimeter(nArray, string2, nArray2, colorArray, n6, n11, n12, string, font, n4, n3, color3, color, color2, bl);
                this.charAt.write("{\\par}");
            }
        }
    }

    private boolean close(JRObjectResult jRObjectResult, String string) {
        return CCUtil.isChangeByFormularProperty(jRObjectResult, string);
    }

    private int containsKey(DSField dSField) {
        return Unit.convertUnitToPixel(dSField.getRender().getWidth(), 72);
    }

    private byte convertInchToPixel(DSField dSField) {
        byte by;
        if (dSField.getPropertyByName("HorizontalAlignment") != null) {
            int n = this.getNewIntProperty(dSField, "HorizontalAlignment");
            switch (n) {
                case 0: {
                    by = 0;
                    break;
                }
                case 2: {
                    by = 2;
                    break;
                }
                case 1: {
                    by = 1;
                    break;
                }
                case 3: {
                    by = 3;
                    break;
                }
                default: {
                    by = 4;
                    break;
                }
            }
        } else {
            int n = this.getIntProperty(dSField, "Alignment");
            switch (n) {
                case 1: 
                case 4: 
                case 7: {
                    by = 0;
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    by = 2;
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    by = 1;
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    by = 3;
                    break;
                }
                default: {
                    by = 4;
                }
            }
        }
        return by;
    }

    private void convertPixelToUnit(int n, int n2, Color color) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(n).append("\\shpbottom").append(n2);
        stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(202).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFilled}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn fLine}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 2}}{\\sp{\\sn posrelv}{\\sv 2}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
        stringBuffer.append("{\\shptxt\\pard\\plain").append("\\li0\\ri0\\widctlpar").append("\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\langnp1033\\langfenp2052");
        stringBuffer.append("{\\fs").append(24);
        stringBuffer.append(' ').append("\\par");
        stringBuffer.append("}}}}}");
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color)).append("}}").append("{\\sp{\\sn fFilled}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}}}").append("\n");
        stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private void convertUnitToCentimeter(int[] nArray, String string, int[] nArray2, Color[] colorArray, int n, int n2, int n3, String string2, Font font, int n4, int n5, Color color, Color color2, Color color3, boolean bl) {
        Comparable<Integer> comparable;
        StringBuffer stringBuffer = new StringBuffer(256);
        int n6 = n3 < 10 ? n3 % 3 : 3;
        int n7 = color2 == null ? 0 : 1;
        n2 = (int)(Unit.convertUnitToCentimeter(n2) * 360000.0);
        stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(nArray[2]).append("\\shpbottom").append(nArray[3]);
        stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(n7).append("}}");
        this.getFont(stringBuffer, n, n2, color3);
        stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 3}}{\\sp{\\sn posrelv}{\\sv 3}}");
        if (!bl) {
            stringBuffer.append("{\\sp{\\sn WrapText}{\\sv 2}}");
        }
        stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 0}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
        stringBuffer.append("{\\shptxt\\pard\\plain").append(WHITE[n6]);
        FontMetrics fontMetrics = ExportToRtfFlow.getInstance(font);
        int n8 = Unit.convertPixelToUnit(nArray[3], 1440);
        n8 = Unit.convertUnitToPixel(n8 - n4 * n5, 1440);
        int n9 = -1;
        if (n3 > 2 && n3 <= 5 || n3 == 10) {
            n9 = n8 / 2 - fontMetrics.getAscent() - fontMetrics.getDescent();
        } else if (n3 > 5 && n3 <= 8 || n3 == 11) {
            n9 = n8 - fontMetrics.getAscent() - fontMetrics.getDescent();
        }
        if (n9 > 0) {
            stringBuffer.append("\\sb").append(n9).append("\\sl240\\slmult1");
        }
        stringBuffer.append("\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\langnp1033\\langfenp2052");
        stringBuffer.append("{\\fs").append(nArray2[4]);
        if (color != null) {
            stringBuffer.append("\\cf").append(this.getHeight(color));
        }
        if (string2 != null) {
            comparable = (Integer)this.convertUnitToCentimeter.get(string2);
            stringBuffer.append("\\f").append(comparable == null ? 0 : (Integer)comparable);
        }
        stringBuffer.append(nArray2[0] == 1 ? _height[0] : "").append(nArray2[1] == 1 ? _height[1] : "").append(nArray2[2] == 1 ? _height[2] : "").append(nArray2[3] == 1 ? _height[3] : "");
        comparable = new StringBuffer(256);
        int n10 = 0;
        while (n10 < string.length()) {
            char c = string.charAt(n10);
            ((StringBuffer)comparable).append("\\uc2\\u").append((int)c).append("\\'").append(_colSpan[c >> 12 & 0xF]).append(_colSpan[c >> 8 & 0xF]).append("\\'").append(_colSpan[c >> 4 & 0xF]).append(_colSpan[c & 0xF]);
            ++n10;
        }
        stringBuffer.append(' ').append(((StringBuffer)comparable).toString());
        stringBuffer.append("\\par");
        stringBuffer.append("}}}}}");
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(nArray[2]).append("\\pichgoal").append(nArray[3]).append("\\wmetafile8").append("}}}}").append("\n");
        stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private void convertUnitToPixel(boolean bl, int[] nArray, String string, int[] nArray2, Color[] colorArray, Font font, int n, int n2, int n3, int n4, int n5, int n6, String string2, Color color, Color color2, Color color3, boolean bl2, StringBuffer stringBuffer) {
        Comparable<Integer> comparable;
        int n7 = n3 < 10 ? n3 % 3 : 3;
        int n8 = color2 == null ? 0 : 1;
        n2 = (int)(Unit.convertUnitToCentimeter(n2) * 360000.0);
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst");
        if (bl) {
            stringBuffer.append("\\shpleft").append(0).append("\\shptop").append(0).append("\\shpright").append(nArray[2]).append("\\shpbottom").append(nArray[3]);
            stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore");
            stringBuffer.append("\\shpwr2\\shpwrk0");
        } else {
            if (this.equalsIgnoreCase == 1) {
                stringBuffer.append("\\shpleft").append(nArray[0]).append("\\shptop").append(nArray[1] + this.fillColor).append("\\shpright").append(nArray[0] + nArray[2]).append("\\shpbottom").append(nArray[1] + nArray[3] + this.fillColor);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(nArray[0]).append("\\shptop").append(nArray[1] - this.getAscent).append("\\shpright").append(nArray[0] + nArray[2]).append("\\shpbottom").append(nArray[1] + nArray[3] - this.getAscent);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
        }
        stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++);
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[5]).append("}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
        if (color2 != null) {
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
        }
        this.getFont(stringBuffer, n, n2, color3);
        if (bl) {
            stringBuffer.append("{\\sp{\\sn posh}{\\sv ").append(n6).append("}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}");
        }
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        if (!bl2) {
            stringBuffer.append("{\\sp{\\sn WrapText}{\\sv 2}}");
        }
        if (bl) {
            stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        }
        stringBuffer.append("{\\shptxt\\pard\\plain").append(WHITE[n7]);
        FontMetrics fontMetrics = ExportToRtfFlow.getInstance(font);
        int n9 = Unit.convertPixelToUnit(nArray[3], 1440);
        n9 = Unit.convertUnitToPixel(n9 - n5 * n4, 1440);
        int n10 = -1;
        if (n3 > 2 && n3 <= 5 || n3 == 10) {
            n10 = n9 / 2 - fontMetrics.getAscent() - fontMetrics.getDescent();
        } else if (n3 > 5 && n3 <= 8 || n3 == 11) {
            n10 = n9 - fontMetrics.getAscent() - fontMetrics.getDescent();
        }
        if (n10 > 0) {
            stringBuffer.append("\\sb").append(n10).append("\\sl240\\slmult1");
        }
        stringBuffer.append("\\li0\\ri0\\widctlpar");
        stringBuffer.append("\\aspalpha\\aspnum\\faauto\\adjustright\\langnp1033\\langfenp2052");
        stringBuffer.append("\\dntblnsbdb\\fs").append(nArray2[4]);
        if (nArray2[3] == 1) {
            this.getMemImgSrc(stringBuffer, nArray2[6]);
        }
        if (colorArray[1] != null) {
            stringBuffer.append("\\ulc").append(this.getHeight(colorArray[1]));
        }
        if (color != null) {
            stringBuffer.append("\\cf").append(this.getHeight(color));
        }
        if (string2 != null) {
            comparable = (Integer)this.convertUnitToCentimeter.get(string2);
            stringBuffer.append("\\f").append(comparable == null ? 0 : (Integer)comparable);
        }
        stringBuffer.append(nArray2[0] == 1 ? _height[0] : "").append(nArray2[1] == 1 ? _height[1] : "").append(nArray2[2] == 1 ? _height[2] : "");
        comparable = new StringBuffer(256);
        int n11 = 0;
        while (n11 < string.length()) {
            char c = string.charAt(n11);
            ((StringBuffer)comparable).append("\\uc2\\u").append((int)c).append("\\'").append(_colSpan[c >> 12 & 0xF]).append(_colSpan[c >> 8 & 0xF]).append("\\'").append(_colSpan[c >> 4 & 0xF]).append(_colSpan[c & 0xF]);
            ++n11;
        }
        stringBuffer.append(' ').append(((StringBuffer)comparable).toString());
        stringBuffer.append("\\par");
        stringBuffer.append("}}}}").append("\n");
    }

    private void createImage(boolean bl, int[] nArray, String string, int[] nArray2, Color[] colorArray, Font font, int n, int n2, int n3, int n4, int n5, int n6, String string2, Color color, Color color2, Color color3, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.convertUnitToPixel(bl, nArray, string, nArray2, colorArray, font, n, n2, n3, n4, n5, n6, string2, color, color2, color3, bl2, stringBuffer);
        this.charAt.write(stringBuffer.toString());
        stringBuffer = null;
    }

    private void currentTimeMillis(DSBarcode dSBarcode, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSBarcode.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSBarcode, n) + offset.dy);
        int n4 = dSBarcode.getWidth();
        int n5 = dSBarcode.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getIsTab(dSBarcode);
        n8 = n8 == 2 ? 3 : n8;
        Rectangle rectangle = dSBarcode.getBounds();
        JReportBarcode jReportBarcode = new JReportBarcode();
        jReportBarcode.setBounds(rectangle);
        jReportBarcode.setProperty(dSBarcode);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        jReportBarcode.paint(graphics);
        switch (this.getMapImage(dSBarcode)) {
            case 1: {
                this.getAlignment(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 2: {
                this.getAlignment(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 3: {
                this.fillRect(bufferedImage, n4, n5);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSBarcode.getParent()) instanceof DSParagraph && !dSBarcode.equals(dSBarcode.getParent().getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.fillRect(bufferedImage, n4, n5);
                this.charAt.write("{\\par}");
            }
        }
    }

    private void cyan(DSField dSField, Render render, StringBuffer stringBuffer, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSField.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSField, n) + offset.dy);
        int n4 = render.getWidth();
        int n5 = render.getHeight();
        int n6 = this.CONTACT(n2 + n4 - 1);
        int n7 = this.CONTACT(n3 + n5 - 1);
        ImageInfo imageInfo = this.getBooleanPropertyByName.getImage(true, false, render);
        Image image = imageInfo.getImage();
        if (image == null) {
            return;
        }
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(n6 + 216).append("\\pich").append(n7 + 48).append("\\pngblip ");
        ImageEncoder imageEncoder = new ImageEncoder();
        stringBuffer.append(this.getMessage(imageEncoder.renderImageToPNG(image)));
        stringBuffer.append("}}}").append("\n");
    }

    private void deIndent(DSField dSField, int n, int n2, StringBuffer stringBuffer) {
        Serializable serializable;
        int n3 = -1;
        int[] nArray = new int[7];
        String string = dSField.toString();
        String string2 = CCUtil.getStringPropertyByName(dSField, "FontFace");
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        int n4 = CCUtil.getIntPropertyByName(dSField, "FontSize");
        nArray[4] = this.getGreen(n4);
        n3 = this.getHGap(string2);
        string2 = this.getHeaderInfo(string2);
        if (n3 != -1) {
            if ((n3 & 1) == 1) {
                nArray[0] = 1;
            }
            if ((n3 & 2) == 2) {
                nArray[1] = 1;
            }
        } else {
            if (CCUtil.getBooleanPropertyByName(dSField, "Bold")) {
                nArray[0] = 1;
            }
            if (CCUtil.getBooleanPropertyByName(dSField, "Italic")) {
                nArray[1] = 1;
            }
        }
        if (CCUtil.getBooleanPropertyByName(dSField, "StrikeOut")) {
            nArray[2] = 1;
        }
        if (CCUtil.getBooleanPropertyByName(dSField, "Underline")) {
            nArray[3] = 1;
        }
        stringBuffer.append("{\\li").append(n).append("\\ri").append(n).append("\\sb").append(n2);
        stringBuffer.append("\\fs").append(nArray[4]);
        if (color != null) {
            this.getHeight(color);
            stringBuffer.append("\\cf").append(this.convertPixelToUnit.get(color));
        }
        if (string2 != null) {
            serializable = (Integer)this.convertUnitToCentimeter.get(string2);
            stringBuffer.append("\\f").append(serializable == null ? 0 : serializable);
        }
        stringBuffer.append(nArray[0] == 1 ? _height[0] : "").append(nArray[1] == 1 ? _height[1] : "").append(nArray[2] == 1 ? _height[2] : "").append(nArray[3] == 1 ? _height[3] : "");
        serializable = CCUtil.getColorPropertyByName(dSField, "Background");
        if (serializable != null) {
            this.getHeight((Color)serializable);
            stringBuffer.append("\\chshdng0").append("\\chcbpat").append(this.convertPixelToUnit.get(serializable));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n5 = 0;
        while (n5 < string.length()) {
            char c = string.charAt(n5);
            stringBuffer2.append("\\uc2\\u").append((int)c).append("\\'").append(_colSpan[c >> 12 & 0xF]).append(_colSpan[c >> 8 & 0xF]).append("\\'").append(_colSpan[c >> 4 & 0xF]).append(_colSpan[c & 0xF]);
            ++n5;
        }
        stringBuffer.append(' ').append(stringBuffer2.toString());
        stringBuffer.append("}");
    }

    private void delete(String string, int[] nArray, int n, String string2, Color[] colorArray, Color color, Color color2, StringBuffer stringBuffer) {
        Comparable<Integer> comparable;
        stringBuffer.append("{\\fs").append(nArray[4]);
        switch (n) {
            case 2: {
                stringBuffer.append("\\super");
                break;
            }
            case 3: {
                stringBuffer.append("\\sub");
            }
        }
        if (nArray[3] == 1) {
            this.getMemImgSrc(stringBuffer, nArray[6]);
        }
        if (colorArray[1] != null) {
            stringBuffer.append("\\ulc").append(this.getHeight(colorArray[1]));
        }
        if (color != null) {
            stringBuffer.append("\\cf").append(this.getHeight(color));
        }
        if (string2 != null) {
            comparable = (Integer)this.convertUnitToCentimeter.get(string2);
            stringBuffer.append("\\f").append(comparable == null ? 0 : (Integer)comparable);
        }
        stringBuffer.append(nArray[0] == 1 ? _height[0] : "").append(nArray[1] == 1 ? _height[1] : "").append(nArray[2] == 1 ? _height[2] : "");
        if (color2 != null) {
            stringBuffer.append("\\chshdng0").append("\\chcbpat").append(this.getHeight(color2));
        }
        comparable = new StringBuffer(256);
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            ((StringBuffer)comparable).append("\\uc2\\u").append((int)c).append("\\'").append(_colSpan[c >> 12 & 0xF]).append(_colSpan[c >> 8 & 0xF]).append("\\'").append(_colSpan[c >> 4 & 0xF]).append(_colSpan[c & 0xF]);
            ++n2;
        }
        stringBuffer.append(' ').append(((StringBuffer)comparable).toString());
        stringBuffer.append("}").append("\n");
    }

    private void dispose(String string, int[] nArray, int n, String string2, Color[] colorArray, Color color, Color color2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.delete(string, nArray, n, string2, colorArray, color, color2, stringBuffer);
        this.charAt.write(stringBuffer.toString());
        stringBuffer = null;
    }

    private void dx(DSSubReport dSSubReport, int n) throws IOException {
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector<JRObjectResult> vector2 = new Vector<JRObjectResult>();
        Vector vector3 = dSSubReport.getChildren();
        int n2 = dSSubReport.getStartYPos();
        switch (this.getMapImage(dSSubReport)) {
            case 1: {
                int n3;
                JRObjectResult jRObjectResult;
                ++this.error;
                this.dy(dSSubReport, n);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSSubReport.getX(), this.getY(dSSubReport, n)));
                ArrayList<JRObjectResult> arrayList = new ArrayList();
                ArrayList<JRObjectResult> arrayList2 = new ArrayList();
                int n4 = 0;
                while (n4 < vector3.size()) {
                    jRObjectResult = this.getRealObject((JRObjectResult)vector3.get(n4));
                    if (this.isExport(jRObjectResult)) {
                        n3 = jRObjectResult.getObjectType();
                        if (jRObjectResult instanceof DSTable) {
                            arrayList.add(jRObjectResult);
                        } else if (n3 == 16) {
                            if (n3 == 22) {
                                vector2.add(jRObjectResult);
                            } else {
                                vector.add(jRObjectResult);
                            }
                        } else {
                            arrayList2.add(jRObjectResult);
                        }
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    jRObjectResult = (JRObjectResult)arrayList.get(n5);
                    this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < arrayList2.size()) {
                    jRObjectResult = (JRObjectResult)arrayList2.get(n6);
                    this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    ++n6;
                }
                --this.error;
                break;
            }
            default: {
                int n3;
                JRObjectResult jRObjectResult;
                ++this.endsWith;
                this.NEWBORDERWIDTH(dSSubReport);
                this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSSubReport.getX(), this.getY(dSSubReport, n)));
                ArrayList<JRObjectResult> arrayList = new ArrayList<JRObjectResult>();
                ArrayList<JRObjectResult> arrayList2 = new ArrayList<JRObjectResult>();
                int n4 = 0;
                while (n4 < vector3.size()) {
                    jRObjectResult = this.getRealObject((JRObjectResult)vector3.get(n4));
                    if (this.isExport(jRObjectResult)) {
                        n3 = jRObjectResult.getObjectType();
                        if (jRObjectResult instanceof DSTable) {
                            arrayList.add(jRObjectResult);
                        } else if (n3 == 16) {
                            if (n3 == 22) {
                                vector2.add(jRObjectResult);
                            } else {
                                vector.add(jRObjectResult);
                            }
                        } else {
                            arrayList2.add(jRObjectResult);
                        }
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    jRObjectResult = (JRObjectResult)arrayList.get(n5);
                    this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < arrayList2.size()) {
                    jRObjectResult = (JRObjectResult)arrayList2.get(n6);
                    this.FB(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    ++n6;
                }
                this.PHONE(dSSubReport);
                --this.endsWith;
                break;
            }
        }
        this.getBytes.pop();
        int n7 = 0;
        while (n7 < vector.size()) {
            this.getDefaultToolkit((DSShape)vector.get(n7));
            ++n7;
        }
        int n8 = 0;
        while (n8 < vector2.size()) {
            this.getDefaultToolkit((DSShape)vector2.get(n8));
            ++n8;
        }
    }

    private void dy(DSContainer dSContainer, int n) {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSContainer.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSContainer, n) + offset.dy);
        int n4 = this.CONTACT(dSContainer.getWidth());
        int n5 = this.CONTACT(dSContainer.getHeight());
        Color color = this.getColorProperty((JRObjectResult)dSContainer, "Background");
        if (color != null) {
            this.getFontMetrics(n2, n3, n4, n5, color);
        }
        this.elementAt(n2, n3, n4, n5, dSContainer);
    }

    private void elementAt(int n, int n2, int n3, int n4, JRVisiableResult jRVisiableResult) {
        int n5;
        int[] nArray = this.elements(jRVisiableResult);
        boolean bl = false;
        if (jRVisiableResult.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            bl = true;
        }
        int[] nArray2 = this.endsWith(jRVisiableResult, bl);
        Color[] colorArray = this.equals(jRVisiableResult, bl);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (nArray[0] != 0 && nArray2[0] != 0) {
            n5 = this.CONTACT(nArray2[0]) / 2;
            stringBuffer.append(this.getFontInfo(n, n2 + n5, n + n3, n2 + n5, colorArray[0], nArray2[0], nArray[0]));
        }
        if (nArray[1] != 0 && nArray2[1] != 0) {
            n5 = this.CONTACT(nArray2[1]) / 2;
            stringBuffer.append(this.getFontInfo(n + n5, n2, n + n5, n2 + n4, colorArray[1], nArray2[1], nArray[1]));
        }
        if (nArray[2] != 0 && nArray2[2] != 0) {
            n5 = this.CONTACT(nArray2[2]) / 2;
            stringBuffer.append(this.getFontInfo(n, n2 + n4 - n5, n + n3, n2 + n4 - n5, colorArray[2], nArray2[2], nArray[2]));
        }
        if (nArray[3] != 0 && nArray2[3] != 0) {
            n5 = this.CONTACT(nArray2[3]) / 2;
            stringBuffer.append(this.getFontInfo(n + n3 - n5, n2, n + n3 - n5, n2 + n4, colorArray[3], nArray2[3], nArray[3]));
        }
        stringBuffer.append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private int[] elements(JRVisiableResult jRVisiableResult) {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = this.getIntProperty(jRVisiableResult, QOIV[n]);
            ++n;
        }
        return nArray;
    }

    private int[] endsWith(JRVisiableResult jRVisiableResult, boolean bl) {
        int[] nArray = new int[4];
        if (bl) {
            int n = 0;
            while (n < 4) {
                nArray[n] = this.getNewIntProperty(jRVisiableResult, NEWBORDERWIDTH[n]);
                ++n;
            }
        } else {
            int n = this.getIntProperty(jRVisiableResult, "BorderWidth");
            int n2 = 0;
            while (n2 < 4) {
                nArray[n2] = n;
                ++n2;
            }
        }
        return nArray;
    }

    private Color[] equals(JRVisiableResult jRVisiableResult, boolean bl) {
        Color[] colorArray = new Color[4];
        if (bl) {
            int n = 0;
            while (n < 4) {
                colorArray[n] = this.getNewColorProperty(jRVisiableResult, NEWBORDERCOLOR[n]);
                ++n;
            }
        } else {
            Color color = this.getColorProperty(jRVisiableResult, "BorderColor");
            int n = 0;
            while (n < 4) {
                colorArray[n] = color;
                ++n;
            }
        }
        return colorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equalsIgnoreCase(JRVisiableResult jRVisiableResult, int n) throws IOException {
        block14: {
            Offset offset = (Offset)this.getBytes.peek();
            int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
            int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
            int n4 = this.CONTACT(jRVisiableResult.getWidth());
            int n5 = this.CONTACT(jRVisiableResult.getHeight());
            int n6 = n2 + n4;
            int n7 = n3 + n5;
            int n8 = this.getIsTab(jRVisiableResult);
            n8 = n8 == 2 ? 3 : n8;
            BufferedImage bufferedImage = null;
            try {
                JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
                if (jRObjectRender == null) break block14;
                jRObjectRender.setProperty(jRVisiableResult);
                Rectangle rectangle = jRVisiableResult.getBounds();
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
                bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                try {
                    graphics.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics);
                    Object var16_17 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    graphics.dispose();
                    throw throwable;
                }
                switch (this.getMapImage(jRVisiableResult)) {
                    case 1: {
                        this.getAlignment(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null);
                        break;
                    }
                    case 2: {
                        this.getAlignment(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null);
                        break;
                    }
                    case 3: {
                        this.fillRect(bufferedImage, n4, n5);
                        break;
                    }
                    default: {
                        if ((JRVisiableResult)((Object)jRVisiableResult.getParent()) instanceof DSParagraph && !jRVisiableResult.equals(jRVisiableResult.getParent().getChildren().get(0))) {
                            this.charAt.write("{\\par}");
                        }
                        this.fillRect(bufferedImage, n4, n5);
                        this.charAt.write("{\\par}");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403003, (Throwable)classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403004, (Throwable)instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!JRLog.isError(2)) break block14;
                JRLog.error(2, 2403005, (Throwable)illegalAccessException);
            }
        }
    }

    private void error(DSPicture dSPicture, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSPicture.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSPicture, n) + offset.dy);
        int n4 = dSPicture.getWidth();
        int n5 = dSPicture.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getIsTab(dSPicture);
        n8 = n8 == 2 ? 3 : n8;
        DbBinary dbBinary = (DbBinary)dSPicture.getRecord().getCell(CCUtil.getStringPropertyByName(dSPicture, "ColumnName"));
        Image image = null;
        if (!dbBinary.isNull()) {
            byte[] byArray = dbBinary.get();
            int n9 = (Integer)dSPicture.getPropertyByName("MediaType").getObject();
            if (byArray != null && byArray.length > 0) {
                if (n9 == 2) {
                    n9 = PictureFileFormatDetector.getPictureFileType(byArray);
                }
                if (n9 == 4 || n9 == 0) {
                    image = C.createImage(byArray);
                } else if (n9 == 1) {
                    BitmapReader bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream(byArray)));
                    image = C.createImage(bitmapReader.getMemImgSrc());
                }
            }
            if (image != null) {
                switch (this.getMapImage(dSPicture)) {
                    case 1: {
                        this.getAlignment(image, false, n2, n3, n4, n5, n6, n7, 0, null);
                        break;
                    }
                    case 2: {
                        this.getAlignment(image, true, n2, n3, n4, n5, n6, n7, 0, null);
                        break;
                    }
                    case 3: {
                        this.fillRect(image, n4, n5);
                        break;
                    }
                    default: {
                        if ((JRVisiableResult)((Object)dSPicture.getParent()) instanceof DSParagraph && !dSPicture.equals(dSPicture.getParent().getChildren().get(0))) {
                            this.charAt.write("{\\par}");
                        }
                        this.fillRect(image, n4, n5);
                        this.charAt.write("{\\par}");
                    }
                }
            }
        }
    }

    private void exists(DSPicture dSPicture, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this._colSpan(dSPicture, n, stringBuffer);
        this.charAt.write(stringBuffer.toString());
        stringBuffer = null;
    }

    private void fillColor(Image image, int n, int n2, StringBuffer stringBuffer) throws IOException {
        n = this.CONTACT(n);
        n2 = this.CONTACT(n2);
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(image.getWidth(null) + 216).append("\\pich").append(image.getHeight(null) + 48).append("\\pngblip ");
        ImageEncoder imageEncoder = new ImageEncoder();
        stringBuffer.append(this.getMessage(imageEncoder.renderImageToPNG(image)));
        stringBuffer.append("}}}").append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private void fillRect(Image image, int n, int n2) throws IOException {
        if (image != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.fillColor(image, n, n2, stringBuffer);
            this.charAt.write(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    private void get(Image image, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst");
        if (bl) {
            stringBuffer.append("\\shpleft").append(0).append("\\shptop").append(0).append("\\shpright").append(n5).append("\\shpbottom").append(n6);
            stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore");
            stringBuffer.append("\\shpwr2\\shpwrk0");
        } else {
            if (this.equalsIgnoreCase == 1) {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.fillColor).append("\\shpright").append(n5).append("\\shpbottom").append(n6 + this.fillColor);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getAscent).append("\\shpright").append(n5).append("\\shpbottom").append(n6 - this.getAscent);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
        }
        stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++);
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[5]).append("}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
        if (color == null) {
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(0).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv " + this.getImage(color) + "}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(1).append("}}");
        }
        this.getFont(stringBuffer, 0, 0, null);
        if (bl) {
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}");
        }
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        if (bl) {
            stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        }
        stringBuffer.append("{\\shptxt\\pard\\plain");
        switch (n7) {
            case 0: {
                stringBuffer.append("\\ql");
                break;
            }
            case 2: {
                stringBuffer.append("\\qc");
                break;
            }
            case 1: {
                stringBuffer.append("\\qr");
            }
        }
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(image.getWidth(null) + 216).append("\\pich").append(image.getHeight(null) + 48).append("\\pngblip ");
        ImageEncoder imageEncoder = new ImageEncoder();
        stringBuffer.append(this.getMessage(imageEncoder.renderImageToPNG(image)));
        stringBuffer.append("}}}");
        stringBuffer.append("}}}}").append("\n");
    }

    private void getAlignment(Image image, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color) throws IOException {
        if (image != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.get(image, bl, n, n2, n3, n4, n5, n6, n7, color, stringBuffer);
            this.charAt.write(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    private void getAscent(DSChartPlatform dSChartPlatform, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSChartPlatform.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSChartPlatform, n) + offset.dy);
        int n4 = dSChartPlatform.getWidth();
        int n5 = dSChartPlatform.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getIsTab(dSChartPlatform);
        n8 = n8 == 2 ? 3 : n8;
        Rectangle rectangle = dSChartPlatform.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        dSChartPlatform.paint(graphics);
        switch (this.getMapImage(dSChartPlatform)) {
            case 1: {
                this.getAlignment(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 2: {
                this.getAlignment(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null);
                break;
            }
            case 3: {
                this.fillRect(bufferedImage, n4, n5);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSChartPlatform.getParent()) instanceof DSParagraph && !dSChartPlatform.equals(dSChartPlatform.getParent().getChildren().get(0))) {
                    this.charAt.write("{\\par}");
                }
                this.fillRect(bufferedImage, n4, n5);
                this.charAt.write("{\\par}");
            }
        }
    }

    private void getBlue(DSCrossTab dSCrossTab, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSCrossTab.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSCrossTab, n) + offset.dy);
        int n4 = this.CONTACT(dSCrossTab.getWidth());
        int n5 = this.CONTACT(dSCrossTab.getHeight());
        Color color = CCUtil.getColorPropertyByName(dSCrossTab, "Background");
        int n6 = this.getMapImage(dSCrossTab);
        boolean bl = CCUtil.getBooleanPropertyByName(dSCrossTab, "Hasborder");
        Color color2 = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
        int n7 = this.CONTACT(dSCrossTab.getHGap());
        int n8 = this.CONTACT(dSCrossTab.getVGap());
        StringBuffer stringBuffer = new StringBuffer();
        CTLayoutManager cTLayoutManager = new CTLayoutManager(dSCrossTab);
        cTLayoutManager.manageLayout();
        Hashtable hashtable = cTLayoutManager.getRows();
        if (this.append) {
            if (n4 > this.elementAt) {
                n4 = this.elementAt;
            }
            if (n5 > this.elements) {
                n5 = this.elements;
            }
        }
        this.getCells(n2, n3, n4, n5, n6, 0, 0, null, null, stringBuffer);
        int n9 = 0;
        while (n9 < hashtable.size()) {
            Hashtable hashtable2 = ((CrossTableRow)hashtable.get(this.getBooleanProperty(n9))).getCells();
            int n10 = 0;
            int n11 = 0;
            while (n11 < hashtable2.size()) {
                CTCell cTCell = (CTCell)hashtable2.get(this.getBooleanProperty(n11));
                if (n11 == 0 && stringBuffer != null) {
                    stringBuffer.append("\\trowd\\trgaph5");
                    stringBuffer.append("\\trrh-").append(Unit.convertUnitToPixel(cTCell._height, 1440));
                    stringBuffer.append("\\trleft0\\irow").append(n9).append("\\irowband").append(n9).append("\\ts15");
                    stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1\\tbllkhdrrows\\tbllklastrow\\tbllkhdrcols\\tbllklastcol").append("\n");
                }
                n10 = this.getBooleanPropertyByName(cTCell, color, color2, n10, n7, n8, bl, stringBuffer);
                ++n11;
            }
            stringBuffer.append("{\\row}\n");
            ++n9;
        }
        this.getCells_old(n4, n5, n6, stringBuffer);
        this.charAt.write(stringBuffer.toString());
    }

    private Object getBooleanProperty(int n) {
        if (n < 21) {
            return getCells[n];
        }
        return new Integer(n);
    }

    private int getBooleanPropertyByName(CTCell cTCell, Color color, Color color2, int n, int n2, int n3, boolean bl, StringBuffer stringBuffer) throws IOException {
        int n4 = cTCell._rowSpan;
        int n5 = cTCell._colSpan;
        int n6 = cTCell._width;
        CTGridInfo cTGridInfo = cTCell.getGridInfo();
        DSField dSField = cTCell._object;
        int n7 = Unit.convertUnitToPixel(n6, 1440);
        Vector vector = cTGridInfo.getChildren();
        if (vector.size() <= 1) {
            if (cTCell._isMergeHead && cTCell._rowSpan > 0) {
                stringBuffer.append("\\clvmgf");
            } else if (n4 > 0) {
                stringBuffer.append("\\clvmrg");
            }
            if (cTCell._isMergeRowHead && cTCell._colSpan > 0) {
                stringBuffer.append("\\clmgf");
            } else if (n5 > 0) {
                stringBuffer.append("\\clmrg");
            }
        }
        int n8 = dSField != null ? CCUtil.getIntPropertyByName(dSField, "Alignment") : 1;
        stringBuffer.append("\\clvertalc");
        stringBuffer.append("\\clbrdrt");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrl");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrb");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrr");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        } else {
            stringBuffer.append("tbl");
        }
        int n9 = n8 < 10 ? n8 % 3 : 3;
        stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n7).append("\\clshdrawnil").append(WHITE[n9]);
        Color color3 = cTGridInfo.fillColor;
        if (color3 != null) {
            stringBuffer.append("\\clcbpat").append(this.getHeight(color3));
        } else if (color != null) {
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
        }
        stringBuffer.append("\\intbl\\cellx").append(n + n7 - 5).append(" ");
        stringBuffer.append("{");
        if (dSField != null) {
            this.getColNum(dSField, n2, n3, stringBuffer, 0);
        }
        stringBuffer.append("}\\cell").append("\n");
        return n + n7;
    }

    private void getBounds(DSTableObject dSTableObject, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        boolean bl = dSTableObject.hasInlinePanel();
        int n2 = dSTableObject.getX();
        int n3 = this.getY(dSTableObject, n);
        this.getBytes.push(new Offset(offset, n2, n3));
        n2 = this.CONTACT(n2 + offset.dx);
        n3 = this.CONTACT(offset.dy);
        int n4 = this.CONTACT(dSTableObject.getWidth());
        int n5 = this.CONTACT(dSTableObject.getHeight());
        Color color = this.getNewColorProperty(dSTableObject, "Background");
        int n6 = this.getMapImage(dSTableObject);
        if (this.append) {
            if (n4 > this.elementAt) {
                n4 = this.elementAt;
            }
            if (n5 > this.elements) {
                n5 = this.elements;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.getCells(n2, n3, n4, n5, n6, 0, 0, null, null, stringBuffer);
        this.charAt.write(stringBuffer.toString());
        stringBuffer = null;
        if (bl) {
            FlowTableLayout flowTableLayout = new FlowTableLayout();
            TableInfo tableInfo = flowTableLayout.getTableInfo(dSTableObject);
            int n7 = tableInfo.getRowNumber();
            int n8 = 0;
            while (n8 < n7) {
                int n9 = tableInfo.getColNum(n8);
                boolean bl2 = true;
                stringBuffer = new StringBuffer();
                stringBuffer.append("\\trowd\\trgaph0\\trleft-5");
                int n10 = 0;
                while (n10 < n9) {
                    ObjectRect objectRect = tableInfo.getCell(n8, n10);
                    if (bl2) {
                        stringBuffer.append("\\trrh-").append(this.CONTACT(objectRect.getHeight()));
                        stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
                        bl2 = false;
                    }
                    if (!objectRect.isDep()) {
                        this.getBytes(objectRect, stringBuffer, color);
                    }
                    ++n10;
                }
                stringBuffer.append("{\\row}\n");
                this.charAt.write(stringBuffer.toString());
                stringBuffer = null;
                ++n8;
            }
        } else {
            boolean bl3 = dSTableObject.isHorizontal();
            List list = dSTableObject.getCells_old();
            int n11 = 0;
            while (n11 < list.size()) {
                List list2 = (List)list.get(n11);
                if (list2.size() > 0) {
                    DSTableCell dSTableCell = (DSTableCell)list2.get(0);
                    DSTableRow dSTableRow = (DSTableRow)dSTableCell.getParent();
                    if (this.isExport(dSTableRow)) {
                        stringBuffer = new StringBuffer();
                        this.getCellColor(list2, color, bl3, stringBuffer);
                        this.charAt.write(stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else {
                    return;
                }
                ++n11;
            }
        }
        stringBuffer = new StringBuffer();
        this.getCells_old(n4, n5, n6, stringBuffer);
        this.charAt.write(stringBuffer.toString());
        stringBuffer = null;
        this.getBytes.pop();
    }

    private void getBytes(ObjectRect objectRect, StringBuffer stringBuffer, Color color) throws IOException {
        DSTableCell dSTableCell = (DSTableCell)objectRect.getTableCell();
        Color color2 = objectRect.getCellColor();
        if (color2 == null) {
            color2 = color;
        }
        int n = this.CONTACT(objectRect.getX());
        int n2 = this.CONTACT(objectRect.getWidth());
        this.getCell(n, n2, dSTableCell, color2, stringBuffer, objectRect.isMergeRow(), objectRect.isFirstMergeRow());
    }

    private void getCell(int n, int n2, DSTableCell dSTableCell, Color color, StringBuffer stringBuffer, boolean bl, boolean bl2) throws IOException {
        JRObjectResult jRObjectResult;
        int n3;
        Color color2;
        int n4 = CCUtil.getIntPropertyByName(dSTableCell, "Alignment");
        if (n4 >= 0 && n4 <= 2 || n4 == 9) {
            stringBuffer.append("\\clvertalt");
        } else if (n4 > 5 && n4 <= 8 || n4 == 11) {
            stringBuffer.append("\\clvertalb");
        } else {
            stringBuffer.append("\\clvertalc");
        }
        if (bl) {
            if (bl2) {
                stringBuffer.append("\\clvmgf");
            } else {
                stringBuffer.append("\\clvmrg");
            }
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "TopLine") != 0) {
            stringBuffer.append("\\clbrdrt");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "TopLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-top-width"), 1440));
            color2 = CCUtil.getColorPropertyByName(dSTableCell, "border-top-color");
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "LeftLine") != 0) {
            stringBuffer.append("\\clbrdrl");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "LeftLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-left-width"), 1440));
            color2 = CCUtil.getColorPropertyByName(dSTableCell, "border-left-color");
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "BottomLine") != 0) {
            stringBuffer.append("\\clbrdrb");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "BottomLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-bottom-width"), 1440));
            color2 = CCUtil.getColorPropertyByName(dSTableCell, "border-bottom-color");
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "RightLine") != 0) {
            stringBuffer.append("\\clbrdrr");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "RightLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-right-width"), 1440));
            color2 = CCUtil.getColorPropertyByName(dSTableCell, "border-right-color");
            stringBuffer.append("\\brdrcf").append(this.getHeight(color2));
        }
        int n5 = n4 < 10 ? n4 % 3 : 3;
        stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n2).append("\\clshdrawnil").append(WHITE[n5]);
        if (color != null) {
            stringBuffer.append("\\clcbpat").append(this.getHeight(color));
        }
        stringBuffer.append("\\intbl\\cellx").append(n + n2 - 5).append(" ");
        Vector vector = dSTableCell.getChildren();
        stringBuffer.append("{");
        int n6 = 0;
        while (vector.size() > 1 && n6 < vector.size()) {
            JRObjectResult jRObjectResult2 = (JRVisiableResult)vector.elementAt(n6);
            n3 = n6 + 1;
            while (n3 < vector.size()) {
                jRObjectResult = (JRVisiableResult)vector.elementAt(n3);
                if (((JRVisiableResult)jRObjectResult).getX() < jRObjectResult2.getX()) {
                    vector.remove(n3);
                    vector.add(n6, jRObjectResult);
                    jRObjectResult2 = jRObjectResult;
                }
                ++n3;
            }
            ++n6;
        }
        int n7 = dSTableCell.getStartYPos();
        n3 = 0;
        while (n3 < vector.size()) {
            JRVisiableResult jRVisiableResult;
            jRObjectResult = (JRObjectResult)vector.elementAt(n3);
            if (jRObjectResult instanceof DSField) {
                jRVisiableResult = (DSField)jRObjectResult;
                this.getColNum((DSField)jRVisiableResult, 0, 0, stringBuffer, n7);
            } else if (jRObjectResult instanceof DSChartPlatform) {
                jRVisiableResult = (DSChartPlatform)jRObjectResult;
                this.getClass((DSChartPlatform)jRVisiableResult, stringBuffer, n7);
            } else if (jRObjectResult instanceof DSPicture) {
                jRVisiableResult = (DSPicture)jRObjectResult;
                this._colSpan((DSPicture)jRVisiableResult, n7, stringBuffer);
            } else if (jRObjectResult instanceof DSParagraph && ((DSContainer)(jRVisiableResult = (DSParagraph)jRObjectResult)).getChildren().size() != 0) {
                this.WHITE((DSParagraph)jRVisiableResult, n7, stringBuffer);
            }
            ++n3;
        }
        stringBuffer.append("\\e2\\cell}");
    }

    private void getCellColor(List list, Color color, boolean bl, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("\\trowd\\trgaph0\\trleft-5");
        int n = 0;
        while (n < list.size()) {
            Color color2;
            DSTableCell dSTableCell = (DSTableCell)list.get(n);
            DSTableRow dSTableRow = (DSTableRow)dSTableCell.getParent();
            if (n == 0 && stringBuffer != null) {
                stringBuffer.append("\\trrh-").append(Unit.convertUnitToPixel(dSTableCell.getHeight(), 1440));
                stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            }
            Color color3 = color2 = CCUtil.getColorPropertyByName(dSTableRow, "Background") == null ? color : CCUtil.getColorPropertyByName(dSTableRow, "Background");
            if (!CCUtil.getBooleanPropertyByName(dSTableCell, "Invisible")) {
                this.getChildren(dSTableCell, color2, bl, stringBuffer);
            }
            ++n;
        }
        stringBuffer.append("{\\row}\n");
    }

    private void getCells(int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, StringBuffer stringBuffer) {
        int n8 = color == null ? 0 : 1;
        n7 = (int)(Unit.convertUnitToCentimeter(n7) * 360000.0);
        if (n5 == 4) {
            stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
            stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(n3).append("\\shpbottom").append(n4);
            stringBuffer.append("\\shpbxcolumn\\hpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv ").append(0).append("}}");
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 3}}{\\sp{\\sn posrelv}{\\sv 3}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 0}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
            this.getFont(stringBuffer, n6, n7, color2);
            stringBuffer.append("{\\shptxt").append("\n");
        } else {
            stringBuffer.append("{\\lang1024\\langfe1024\\noproof{\\shp{\\*\\shpinst");
            if (this.equalsIgnoreCase == 1) {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.fillColor).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 + this.fillColor);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getAscent).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 - this.getAscent);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
            stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++);
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
            if (this.equalsIgnoreCase == 1) {
                stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
            } else {
                stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
            }
            stringBuffer.append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
            this.getFont(stringBuffer, n6, n7, color2);
            stringBuffer.append("{\\shptxt").append("\n");
        }
    }

    private void getCells_old(int n, int n2, int n3, StringBuffer stringBuffer) {
        if (n3 == 4) {
            stringBuffer.append("\\pard\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\itap0 {\\par }");
            stringBuffer.append("}}}}");
            stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
            stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}}}").append("\n");
            stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("{\\par}").append("\n");
        } else {
            stringBuffer.append("\\pard\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\itap0 {\\par }");
            stringBuffer.append("}}}}").append("\n");
        }
    }

    private void getChildren(DSTableCell dSTableCell, Color color, boolean bl, StringBuffer stringBuffer) throws IOException {
        JRVisiableResult jRVisiableResult = (JRVisiableResult)((Object)dSTableCell.getParent());
        int n = bl ? this.CONTACT(jRVisiableResult.getX()) : this.CONTACT(dSTableCell.getX());
        int n2 = this.CONTACT(dSTableCell.getWidth());
        Color color2 = CCUtil.getColorPropertyByName(dSTableCell, "Background");
        if (color2 == null) {
            color2 = color;
        }
        this.getCell(n, n2, dSTableCell, color2, stringBuffer, false, false);
    }

    private void getClass(DSChartPlatform dSChartPlatform, StringBuffer stringBuffer, int n) throws IOException {
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSChartPlatform.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSChartPlatform, n) + offset.dy);
        int n4 = dSChartPlatform.getWidth();
        int n5 = dSChartPlatform.getHeight();
        int n6 = this.CONTACT(n2 + n4 - 1);
        int n7 = this.CONTACT(n3 + n5 - 1);
        Rectangle rectangle = dSChartPlatform.getBounds();
        Image image = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        dSChartPlatform.paint(graphics);
        if (image != null) {
            n4 = Unit.convertUnitToPixel(n4, 96);
            n5 = Unit.convertUnitToPixel(n5, 96);
            if (image.getWidth(null) != n4 || image.getHeight(null) != n5) {
                image = image.getScaledInstance(n4, n5, 4);
            }
            this.getIntProperty(image);
            if (n4 != 0 && n5 != 0 && image.getWidth(null) == 0 && image.getHeight(null) == 0) {
                int n8 = 0;
                while (n8 < 200 && image.getWidth(null) == 0 && image.getHeight(null) == 0) {
                    this.getIntProperty(image);
                    ++n8;
                }
            }
            stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(n6 + 216).append("\\pich").append(n7 + 48).append("\\pngblip ");
            ImageEncoder imageEncoder = new ImageEncoder();
            stringBuffer.append(this.getMessage(imageEncoder.renderImageToPNG(image)));
            stringBuffer.append("}}}").append("\n");
        }
    }

    private void getColNum(DSField dSField, int n, int n2, StringBuffer stringBuffer, int n3) throws IOException {
        Render render;
        block6: {
            render = dSField.getRender();
            if (dSField.getObjectType() == 264) {
                try {
                    this.currentTimeMillis((DSBarcode)dSField, n3);
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block6;
                    JRLog.error(2, 2403002, (Throwable)exception);
                }
            }
        }
        if (dSField.getObjectType() != 264) {
            if (render instanceof RenderText) {
                this.deIndent(dSField, n, n2, stringBuffer);
            } else {
                this.cyan(dSField, render, stringBuffer, n3);
            }
        }
    }

    private void getColorProperty(DSContainer dSContainer, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(256);
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.getY(dSContainer, n) + offset.dy;
        int n3 = this.CONTACT(dSContainer.getX() + offset.dx);
        int n4 = this.CONTACT(n2);
        int n5 = this.CONTACT(dSContainer.getWidth());
        int n6 = this.CONTACT(dSContainer.getHeight());
        Color color = this.getColorProperty((JRObjectResult)dSContainer, "Background");
        int n7 = this.getMapImage(dSContainer);
        int n8 = 0;
        int n9 = this.getIntProperty(dSContainer, "LeftLine");
        int n10 = this.getIntProperty(dSContainer, "RightLine");
        int n11 = this.getIntProperty(dSContainer, "TopLine");
        int n12 = this.getIntProperty(dSContainer, "BottomLine");
        int n13 = -1;
        Color color2 = null;
        this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        n13 = this.getIntProperty(dSContainer, "BorderWidth");
        color2 = this.getColorProperty((JRObjectResult)dSContainer, "BorderColor");
        if (n9 != 0) {
            n8 = n9;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-left-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n11 != 0) {
            n8 = n11;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-top-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n10 != 0) {
            n8 = n10;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-right-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n12 != 0) {
            n8 = n12;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-bottom-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        }
        Vector vector = dSContainer.getChildren();
        int n14 = dSContainer.getStartYPos();
        switch (this.getMapImage(dSContainer)) {
            case 1: {
                ++this.error;
                this.createImage = n2 + dSContainer.getHeight();
                if (color != null) {
                    this.getFontMetrics(n3, n4, n5, n6, color);
                }
                int n15 = 0;
                while (n15 < vector.size()) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(n15);
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n14);
                    }
                    ++n15;
                }
                this.getBytes.pop();
                this.getFontRender(dSContainer, n);
                this.createImage = -1;
                --this.error;
                break;
            }
            default: {
                ++this.exists;
                this.getCells(n3, n4, n5, n6, n7, n8, n13, color, color2, stringBuffer);
                this.charAt.write(stringBuffer.toString());
                int n16 = CCUtil.getIntPropertyByName(dSContainer, "VerticalAlignment");
                int n17 = 0;
                while (n17 < vector.size()) {
                    this.background = n17 == 0 && n16 != 1;
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.get(n17);
                    if (this.isExport(jRObjectResult)) {
                        this.FB(jRObjectResult, jRObjectResult.getObjectType(), n14);
                    }
                    ++n17;
                }
                stringBuffer = new StringBuffer(256);
                this.getCells_old(n5, n6, n7, stringBuffer);
                this.charAt.write(stringBuffer.toString());
                --this.exists;
                this.getBytes.pop();
                break;
            }
        }
    }

    private String getColorPropertyByName(int n) {
        switch (n) {
            case 0: {
                return "tbl";
            }
            case 1: {
                return "s";
            }
            case 2: {
                return "dash";
            }
            case 3: {
                return "dot";
            }
            case 4: {
                return "dashd";
            }
            case 5: {
                return "db";
            }
        }
        return "s";
    }

    private void getDataStream(DSTable dSTable, int n) {
        Vector vector;
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(dSTable.getX() + offset.dx);
        int n3 = this.getY(dSTable, n);
        this.getBytes.push(new Offset((Offset)this.getBytes.peek(), dSTable.getX(), n3));
        n3 = this.CONTACT(dSTable.getY() + offset.dy);
        int n4 = this.CONTACT(dSTable.getWidth());
        int n5 = this.CONTACT(dSTable.getHeight());
        Color color = CCUtil.getColorPropertyByName(dSTable, "Background");
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (color != null) {
            this.getFontMetrics(n2, n3, n4, n5, color);
        }
        if ((vector = dSTable.getChildren()) != null) {
            this.getDefault(vector, rectangle);
        }
        if (CCUtil.getBooleanPropertyByName(dSTable, "ShowBorder")) {
            this.getEncoding(new ShapeInfo(n2, n3, n4, n5, Color.black, null, 1, _isMergeHead, 1));
        }
        this.getBytes.pop();
    }

    private void getDefault(Vector vector, Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer(256);
        DSColumn dSColumn = null;
        Color color = null;
        int n = rectangle.y;
        int n2 = rectangle.height;
        Offset offset = (Offset)this.getBytes.peek();
        int n3 = 0;
        while (n3 < vector.size()) {
            dSColumn = (DSColumn)vector.elementAt(n3);
            int n4 = this.CONTACT(dSColumn.getX() + offset.dx) + rectangle.x;
            int n5 = this.CONTACT(dSColumn.getWidth());
            color = CCUtil.getColorPropertyByName(dSColumn, "Background");
            if (color != null) {
                this.getFontMetrics(n4 + 1, n + 1, n5 - 2, n2 - 1, color);
            }
            if (CCUtil.getBooleanPropertyByName(dSColumn, "ShowBorder")) {
                stringBuffer.append(this.getFontInfo(n4 + n5 - 1, n, n4 + n5 - 1, n + n2, Color.black, _isMergeHead, 1));
            }
            ++n3;
        }
        this.charAt.write(stringBuffer.toString());
    }

    private void getDefaultToolkit(DSShape dSShape) {
        DSShapeRegion dSShapeRegion;
        Rectangle rectangle;
        int n = dSShape.getObjectType();
        Color color = null;
        Color color2 = null;
        int n2 = 0;
        int n3 = 0;
        if (n != 18 && (rectangle = (dSShapeRegion = new DSShapeRegion(dSShape, false)).getShapeRegion()) != null) {
            int n4 = 0;
            int n5 = Unit.convertUnitToPixel(rectangle.x, 1440);
            int n6 = Unit.convertUnitToPixel(rectangle.y, 1440);
            int n7 = Unit.convertUnitToPixel(rectangle.width, 1440);
            int n8 = Unit.convertUnitToPixel(rectangle.height, 1440);
            if (n != 22) {
                color2 = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
                color = CCUtil.getColorPropertyByName(dSShape, "Background");
                n3 = CCUtil.getIntPropertyByName(dSShape, "BorderStyle");
                n2 = CCUtil.getIntPropertyByName(dSShape, "BorderWidth");
                if (n2 > 0) {
                    n5 += n2 >> 1;
                    n6 += n2 >> 1;
                    n7 -= n2;
                    n8 -= n2;
                }
            } else {
                color2 = CCUtil.getColorPropertyByName(dSShape, "LineColor");
                n2 = CCUtil.getIntPropertyByName(dSShape, "LineWidth");
                n3 = CCUtil.getIntPropertyByName(dSShape, "LineStyle");
            }
            switch (n) {
                case 22: {
                    this.charAt.print(this.getFontInfo(n5, n6, n5 + n7, n6 + n8, color2, n2, n3));
                    break;
                }
                case 23: {
                    n4 = 1;
                    break;
                }
                case 20: {
                    n4 = 2;
                    break;
                }
                case 19: {
                    n4 = 3;
                }
            }
            if (n4 != 0) {
                this.charAt.print(this.getFloatPropertyByName(n5, n6, n7, n8, color2, color, n3, n2, n4));
            }
        }
    }

    private void getDescent() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = Unit.convertInchToPixel(2.0, 1440);
        int n2 = Unit.convertInchToPixel(1.0, 1440);
        int n3 = Unit.convertInchToPixel(3.0, 1440);
        int n4 = Unit.convertInchToPixel(2.0, 1440);
        int[] nArray = new int[7];
        this.getHeaderInfo("Arial Narrow");
        while (n < this.dx && n2 < this.dy) {
            int n5 = n - TW / 2;
            int n6 = n - BW1 / 2;
            int n7 = n - BW2 / 2;
            int n8 = n2 - BH / 2 - 280;
            int n9 = n2;
            int n10 = n2 + BH / 2 + 280;
            nArray[0] = FT.isBold() ? 1 : 0;
            nArray[4] = FT.getSize() * 2;
            this.createImage(false, new int[]{n5, n8, TW, TH}, EVAL, nArray, new Color[2], FT, 0, 0, 1, 1, 20, 0, "Arial Narrow", DEF_COLOR, null, null, false);
            nArray[0] = FB.isBold() ? 1 : 0;
            nArray[4] = FB.getSize() * 2;
            this.createImage(false, new int[]{n6, n9, BW1, BH}, CONTACT, nArray, new Color[2], FB, 0, 0, 1, 1, 12, 0, "Arial Narrow", DEF_COLOR, null, null, false);
            this.createImage(false, new int[]{n7, n10, BW2, BH}, PHONE, nArray, new Color[2], FB, 0, 0, 1, 1, 12, 0, "Arial Narrow", DEF_COLOR, null, null, false);
            n += n3;
            n2 += n4;
        }
        this.charAt.write(stringBuffer.toString());
    }

    private String getEncoding(ShapeInfo shapeInfo) {
        return this.getFloatPropertyByName(shapeInfo.x, shapeInfo.y, shapeInfo.I, shapeInfo.Z, shapeInfo.F, shapeInfo.J, shapeInfo.C, shapeInfo.B, shapeInfo.D);
    }

    private String getFloatPropertyByName(int n, int n2, int n3, int n4, Color color, Color color2, int n5, int n6, int n7) {
        if (n7 == 0) {
            return this.getFontInfo(n, n2, n3, n4, color, n6, n5);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.dispose);
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.fillColor).append("\\shpbottom").append(n2 + n4 + this.fillColor).append("\\shpright").append(n + n3);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getAscent).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 - this.getAscent);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[n7]).append("}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(color2 == null ? 0 : 1).append("}}");
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        n6 = (int)(Unit.convertUnitToCentimeter(n6) * 360000.0);
        this.getFont(stringBuffer, n5, n6, color);
        stringBuffer.append("}}}");
        return stringBuffer.toString();
    }

    private void getFont(StringBuffer stringBuffer, int n, int n2, Color color) {
        if (color != null && n != 0 && n2 != 0) {
            stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getImage(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
        }
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 6}}");
                break;
            }
            case 3: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 2}}");
                break;
            }
            case 4: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 9}}");
                break;
            }
            case 5: {
                stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 1}}");
            }
        }
        if (n != 5) {
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(n2).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(n2 << 1).append("}}");
        }
    }

    private String getFontInfo(int n, int n2, int n3, int n4, Color color, int n5, int n6) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.dispose);
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.fillColor).append("\\shpright").append(n3).append("\\shpbottom").append(n4 + this.fillColor);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getAscent).append("\\shpright").append(n3).append("\\shpbottom").append(n4 - this.getAscent);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[0]).append("}}");
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        n5 = (int)(Unit.convertUnitToCentimeter(n5) * 360000.0);
        this.getFont(stringBuffer, n6, n5, color);
        stringBuffer.append("}}}");
        return stringBuffer.toString();
    }

    private void getFontMetrics(int n, int n2, int n3, int n4, Color color) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.dispose);
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.fillColor).append("\\shpbottom").append(n2 + n4 - 1 + this.fillColor).append("\\shpright").append(n + n3 - 1);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getAscent).append("\\shpbottom").append(n2 + n4 - 1 - this.getAscent).append("\\shpright").append(n + n3 - 1);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.delete++).append("\\shplid").append(this.deIndent++).append("{\\sp{\\sn shapeType}{\\sv ").append(FALSE[1]).append("}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getImage(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fBehindDocument}{\\sv 0}}");
        if (this.equalsIgnoreCase == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        stringBuffer.append("}}}").append("\n");
        this.charAt.write(stringBuffer.toString());
    }

    private void getFontName(JRVisiableResult jRVisiableResult, int n) {
        if (!this.getBooleanProperty(jRVisiableResult, "ShowBottomLine")) {
            return;
        }
        Offset offset = (Offset)this.getBytes.peek();
        int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n4 = this.CONTACT(jRVisiableResult.getWidth());
        int n5 = this.CONTACT(jRVisiableResult.getHeight());
        this.charAt.write(this.getFontInfo(n2, n3 + n5, n2 + n4, n3 + n5, Color.black, 98, 1));
    }

    /*
     * Unable to fully structure code
     */
    private void getFontRender(JRVisiableResult var1_1, int var2_2) {
        block10: {
            var3_3 = (Offset)this.getBytes.peek();
            var4_4 = this.CONTACT(var1_1.getX() + var3_3.dx);
            var5_5 = this.CONTACT(this.getY(var1_1, var2_2) + var3_3.dy);
            var6_6 = this.CONTACT(var1_1.getWidth());
            var7_7 = this.CONTACT(var1_1.getHeight());
            var8_8 = new int[4];
            var9_9 = new int[4];
            var10_10 = new Color[4];
            try {
                var11_11 = 4;
                while (--var11_11 >= 0) {
                    var8_8[var11_11] = CCUtil.getIntPropertyByName(var1_1, ExportToRtfFlow.QOIV[var11_11]);
                    var9_9[var11_11] = CCUtil.getIntPropertyByName(var1_1, "BorderWidth");
                    var10_10[var11_11] = CCUtil.getColorPropertyByName(var1_1, "BorderColor");
                }
                break block10;
            }
            catch (NullPointerException var11_12) {
                var12_14 = 4;
                ** while (--var12_14 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var8_8[var12_14] = this.getGraphics(CCUtil.getIntPropertyByName(var1_1, ExportToRtfFlow.QOIV[var12_14]));
                var9_9[var12_14] = CCUtil.getIntPropertyByName(var1_1, ExportToRtfFlow.NEWBORDERWIDTH[var12_14]);
                var10_10[var12_14] = CCUtil.getColorPropertyByName(var1_1, ExportToRtfFlow.NEWBORDERCOLOR[var12_14]);
                continue;
            }
        }
        var11_13 = new StringBuffer(256);
        if (var8_8[0] != 0 && var9_9[0] != 0) {
            var12_14 = Unit.convertUnitToPixel(var9_9[0], 1440) / 2;
            var11_13.append(this.getFontInfo(var4_4, var5_5 + var12_14, var4_4 + var6_6, var5_5 + var12_14, var10_10[0], var9_9[0], var8_8[0]));
        }
        if (var8_8[1] != 0 && var9_9[1] != 0) {
            var12_14 = Unit.convertUnitToPixel(var9_9[1], 1440) / 2;
            var11_13.append(this.getFontInfo(var4_4 + var12_14, var5_5, var4_4 + var12_14, var5_5 + var7_7, var10_10[1], var9_9[1], var8_8[1]));
        }
        if (var1_1 instanceof DSSection && CCUtil.getBooleanPropertyByName(var1_1, "ShowBottomLine")) {
            this.getFontName(var1_1, var2_2);
        } else if (var8_8[2] != 0 && var9_9[2] != 0) {
            var12_14 = Unit.convertUnitToPixel(var9_9[2], 1440) / 2;
            var11_13.append(this.getFontInfo(var4_4, var5_5 + var7_7 - var12_14, var4_4 + var6_6, var5_5 + var7_7 - var12_14, var10_10[2], var9_9[2], var8_8[2]));
        }
        if (var8_8[3] != 0 && var9_9[3] != 0) {
            var12_14 = Unit.convertUnitToPixel(var9_9[3], 1440) / 2;
            var11_13.append(this.getFontInfo(var4_4 + var6_6 - var12_14, var5_5, var4_4 + var6_6 - var12_14, var5_5 + var7_7, var10_10[3], var9_9[3], var8_8[3]));
        }
        var11_13.append("\n");
        this.charAt.write(var11_13.toString());
    }

    private int getGraphics(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private int getGreen(int n) {
        return Unit.convertUnitToPixel(n, 72) * 2;
    }

    private int getGridInfo(DSField dSField) {
        return Unit.convertUnitToPixel(this.getIntProperty(dSField, "FontSize"), 72);
    }

    private int getHGap(String string) {
        if (FontSets.isTrueType(string)) {
            return FontSets.getTrueTypeFontStyle(string);
        }
        return -1;
    }

    private String getHeaderInfo(String string) {
        String string2 = (String)_isMergeRowHead.get(string);
        if (string2 == null || string2.length() == 0) {
            string2 = FontSets.getFont(string, 0, 16).getFontName(Locale.getDefault());
        }
        if (this.convertUnitToCentimeter.get(string2) == null) {
            this.convertUnitToCentimeter.put(string2, new Integer(this.currentTimeMillis));
            this.containsKey.append("{\\f").append(this.currentTimeMillis++).append("\\froman").append("\\charset0").append("\\fprq1 ").append(string2).append(";}");
        }
        return string2;
    }

    private int getHeight(Color color) {
        if (color == null) {
            return -1;
        }
        if (this.convertPixelToUnit.get(color) == null) {
            this.convertPixelToUnit.put(color, new Integer(this.cyan));
            this.convertInchToPixel.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
            ++this.cyan;
            return this.cyan - 1;
        }
        return (Integer)this.convertPixelToUnit.get(color);
    }

    private String getImage(Color color) {
        color = color == null ? Color.white : color;
        return Integer.toString((color.getBlue() << 16) + (color.getGreen() << 8) + color.getRed());
    }

    private static FontMetrics getInstance(Font font) {
        return C.getFontMetrics(font);
    }

    private void getIntProperty(Image image) {
        block3: {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2403006, (Throwable)interruptedException);
                }
            }
        }
    }

    private int getIntPropertyByName(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("display");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 0;
    }

    private int getIsTab(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("float");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 0;
    }

    private int getLeaders(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("position");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 2;
    }

    private int getMapImage(JRVisiableResult jRVisiableResult) {
        boolean bl;
        Containable containable;
        int n = jRVisiableResult.getObjectType();
        if (jRVisiableResult instanceof DSSection) {
            if (n == 514 || n == 517) {
                return 1;
            }
            if (n == 2562 && this.getBooleanProperty(jRVisiableResult, "ToBottom")) {
                return 1;
            }
        }
        boolean bl2 = false;
        bl2 = (n & 0x100) == 256 ? !((containable = jRVisiableResult.getParent()) instanceof DSParagraph || containable instanceof DSTableCell || containable instanceof DSTabularCell) : false;
        if (bl2) {
            return 1;
        }
        if (this.exists > 0) {
            return 3;
        }
        if (this.error > 0) {
            return 1;
        }
        int n2 = this.getLeaders(jRVisiableResult);
        int n3 = this.getIsTab(jRVisiableResult);
        int n4 = this.getIntPropertyByName(jRVisiableResult);
        boolean bl3 = n2 == 2;
        boolean bl4 = n3 != 2;
        boolean bl5 = n4 == 1;
        boolean bl6 = bl = n4 == 0;
        if (bl3) {
            return 1;
        }
        if (bl4) {
            return 2;
        }
        if (bl5) {
            return 3;
        }
        if (bl) {
            return 0;
        }
        return 1;
    }

    private void getMemImgSrc(StringBuffer stringBuffer, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "\\ul";
                break;
            }
            case 2: {
                string = "\\uldb";
                break;
            }
            case 3: {
                string = "\\ulth";
                break;
            }
            case 4: {
                string = "\\uld";
                break;
            }
            case 5: {
                string = "\\ulthd";
                break;
            }
            case 6: {
                string = "\\uldash";
                break;
            }
            case 7: {
                string = "\\ulthdash";
                break;
            }
            case 8: {
                string = "\\ulldash";
                break;
            }
            case 9: {
                string = "\\ulthldash";
                break;
            }
            case 10: {
                string = "\\uldashd";
                break;
            }
            case 11: {
                string = "\\ulthdashd";
                break;
            }
            case 12: {
                string = "\\uldashdd";
                break;
            }
            case 13: {
                string = "\\ulthdashdd";
                break;
            }
            case 14: {
                string = "\\ulwave";
                break;
            }
            case 15: {
                string = "\\ulhwave";
                break;
            }
            case 16: {
                string = "\\ululdbwave";
                break;
            }
            default: {
                string = "\\ul";
            }
        }
        stringBuffer.append(string);
    }

    private String getMessage(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(_colSpan[byArray[n] >> 4 & 0xF]).append(_colSpan[byArray[n] & 0xF]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String getNewColorProperty(String string, Font font, FontRenderContext fontRenderContext, byte by, int n) {
        int n2 = this.getNewIntProperty(font, fontRenderContext, string);
        if (n2 > n) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            if (by == 0 || by == 3) {
                bl = true;
            } else if (by == 2) {
                bl2 = true;
            }
            while (n2 > n) {
                if (bl || bl2 && bl3) {
                    int n3 = string.length() - 1;
                    if (string.length() == 0) {
                        return string;
                    }
                    n2 -= this.getNewIntProperty(font, fontRenderContext, String.valueOf(string.charAt(n3)));
                    string = string.substring(0, n3);
                } else {
                    if (string.length() == 1) {
                        return string;
                    }
                    n2 -= this.getNewIntProperty(font, fontRenderContext, String.valueOf(string.charAt(0)));
                    string = string.substring(1);
                }
                boolean bl4 = bl3 = !bl3;
            }
        }
        return string;
    }

    private int getNewIntProperty(Font font, FontRenderContext fontRenderContext, String string) {
        int n = (int)Math.round(font.getStringBounds(string, fontRenderContext).getWidth());
        return n;
    }

    private void getObject() throws IOException {
        int n;
        File file = new File(this._object);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        this.getBooleanProperty.write(this.close.toString().getBytes(this._rowSpan));
        byte[] byArray = new byte[5120];
        while ((n = randomAccessFile.read(byArray)) != -1) {
            this.getBooleanProperty.write(byArray, 0, n);
        }
        randomAccessFile.close();
        file.delete();
    }

    static {
        _isMergeRowHead.put("Default", "Arial");
        _isMergeRowHead.put("Dialog", "Arial");
        _isMergeRowHead.put("ArialMT", "Arial");
        _isMergeRowHead.put("ArialNarrow", "Arial Narrow");
        _isMergeRowHead.put("Helvetica", "Microsoft Sans Serif");
        _isMergeRowHead.put("SansSerif", "Microsoft Sans Serif");
        _isMergeRowHead.put("Serif", "Times New Roman");
        _isMergeRowHead.put("Monospaced", "Courier New");
        _isMergeRowHead.put("TimesRoman", "Times New Roman");
        _isMergeRowHead.put("DialogInput", "Courier New");
        _isMergeRowHead.put("ZapfDingbats", "WingDings");
        _isMergeRowHead.put("ComicSansMS", "Comic Sans MS");
        getBounds = new String[][]{{"Big5", "cpg950"}, {"Cp037", "cpg37"}, {"Cp1006", "cpg1006"}, {"Cp1025", "cpg1025"}, {"Cp1026", "cpg1026"}, {"Cp1046", "cpg1046"}, {"Cp1097", "cpg1097"}, {"Cp1098", "cpg1098"}, {"Cp1112", "cpg1112"}, {"Cp1122", "cpg1122"}, {"Cp1123", "cpg1123"}, {"Cp1124", "cpg1124"}, {"Cp1250", "cpg1250"}, {"Cp1251", "cpg1251"}, {"Cp1252", "cpg1252"}, {"Cp1253", "cpg1253"}, {"Cp1254", "cpg1254"}, {"Cp1255", "cpg1255"}, {"Cp1256", "cpg1256"}, {"Cp1257", "cpg1257"}, {"Cp1258", "cpg1258"}, {"Cp1381", "cpg1381"}, {"Cp1383", "cpg1383"}, {"Cp273", "cpg273"}, {"Cp277", "cpg277"}, {"Cp278", "cpg278"}, {"Cp280", "cpg280"}, {"Cp284", "cpg284"}, {"Cp285", "cpg285"}, {"Cp297", "cpg297"}, {"Cp33722", "cpg33722"}, {"Cp420", "cpg420"}, {"Cp424", "cpg424"}, {"Cp437", "cpg437"}, {"Cp500", "cpg500"}, {"Cp737", "cpg737"}, {"Cp775", "cpg775"}, {"Cp838", "cpg838"}, {"Cp850", "cpg850"}, {"Cp852", "cpg852"}, {"Cp855", "cpg855"}, {"Cp857", "cpg857"}, {"Cp860", "cpg860"}, {"Cp861", "cpg861"}, {"Cp862", "cpg862"}, {"Cp863", "cpg863"}, {"Cp864", "cpg864"}, {"Cp865", "cpg865"}, {"Cp866", "cpg866"}, {"Cp868", "cpg868"}, {"Cp869", "cpg869"}, {"Cp870", "cpg870"}, {"Cp871", "cpg871"}, {"Cp874", "cpg874"}, {"Cp875", "cpg875"}, {"Cp918", "cpg918"}, {"Cp921", "cpg921"}, {"Cp922", "cpg922"}, {"Cp930", "cpg930"}, {"Cp933", "cpg933"}, {"Cp935", "cpg935"}, {"Cp937", "cpg937"}, {"Cp939", "cpg939"}, {"Cp942", "cpg942"}, {"Cp948", "cpg948"}, {"Cp949", "cpg949"}, {"Cp950", "cpg950"}, {"Cp964", "cpg964"}, {"Cp970", "cpg970"}, {"EUC_CN", "cpg936"}, {"EUC_JP", "cpg932"}, {"EUC_KR", "cpg933"}, {"EUC_TW", "cpg950"}, {"GBK", "cpg936"}, {"GB2312", "cpg936"}, {"ISO2022CN", "cpg936"}, {"ISO2022CN_CNS", "cpg950"}, {"ISO2022CN_GB", "cpg936"}, {"ISO2022JP", "cpg932"}, {"ISO2022KR", "cpg933"}, {"JIS0201", "cpg932"}, {"JIS0208", "cpg932"}, {"JIS0212", "cpg932"}, {"KOI8_R", "cpg933"}, {"MS874", "cpg874"}, {"SJIS", "cpg932"}};
        getCells = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20)};
    }
}

