/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import jet.util.RandomAccessable;

public class PJFDataOutput
extends DataOutputStream
implements RandomAccessable {
    public OutputStream getUnderlying() {
        return this.out;
    }

    public PJFDataOutput(OutputStream outputStream) {
        super(outputStream);
        if (!(outputStream instanceof RandomAccessable)) {
            throw new IllegalArgumentException("Output stream " + outputStream + " must impelement RandomAccessable");
        }
    }

    public void writeUTC(long l) throws IOException {
        this.writeLong(l);
    }

    public void writeDate(Date date) throws IOException {
        this.writeLong(date.getTime());
    }

    public void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws IOException {
        this.writeShort(n2);
        byte[] byArray = new byte[n2];
        if (bigDecimal == null) {
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = 32;
                ++n3;
            }
        } else {
            byte[] byArray2 = bigDecimal.movePointRight(n).toBigInteger().toByteArray();
            int n4 = (byArray2[0] & 0x80) != 128 ? 0 : -1;
            int n5 = 0;
            while (n5 < n2) {
                byArray[n5] = n4;
                ++n5;
            }
            System.arraycopy(byArray2, 0, byArray, n2 - byArray2.length, byArray2.length);
        }
        this.write(byArray);
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        this.write(bigInteger.toByteArray());
    }

    public void writeOffset(long l) throws IOException {
        this.writeLong(l);
    }

    public void writeFixedString(String string, String string2, int n) throws IOException {
        byte[] byArray = string.getBytes(string2);
        int n2 = byArray.length;
        if (n2 > 65535 || n2 > n) {
            throw new IOException("too long for fixed string to write:" + string + ", len:" + n + ", actual:" + n2);
        }
        this.writeShort((short)n2);
        this.write(byArray, 0, n2);
        int n3 = 0;
        while (n3 < n - n2) {
            this.write(0);
            ++n3;
        }
    }

    public void writeFixedBinary(byte[] byArray, int n) throws IOException {
        int n2 = byArray.length > n ? n : byArray.length;
        this.writeShort(n2);
        this.write(byArray, 0, n2);
        int n3 = 0;
        while (n3 < n - n2) {
            this.writeByte(0);
            ++n3;
        }
    }

    public void writeVariantString(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        int n = byArray.length;
        this.writeInt(n);
        this.write(byArray, 0, n);
    }

    public void writeVariantBinary(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.writeInt(n);
        this.write(byArray, 0, n);
    }

    public void seek(long l) throws IOException {
        ((RandomAccessable)((Object)this.out)).seek(l);
    }

    public long getPosition() throws IOException {
        return ((RandomAccessable)((Object)this.out)).getPosition();
    }

    public int skipBytes(int n) throws IOException {
        return ((RandomAccessable)((Object)this.out)).skipBytes(n);
    }

    public long length() throws IOException {
        return ((RandomAccessable)((Object)this.out)).length();
    }
}

