/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import chart.data.ChartDataFilter;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartCustomizedPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import com.jinfonet.awt.JFont;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.controls.ChangedProperties;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetImgProperty;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.JetChartTypeEnumeration;
import jet.report.JetRptChart2DCoordinatepaper;
import jet.report.JetRptChartBorderStyle;
import jet.report.JetRptChartCoordinatepaper;
import jet.report.JetRptChartLabel;
import jet.report.JetRptChartLegend;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDataSource;
import jet.report.JetRptDataSourceProperty;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptLineWidth;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportset.DataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.util.FontSets;
import jet.util.HashVector;
import jet.util.MiscTools;
import jet.util.ReportFormat;
import jet.util.TreeIterater;

public class JetRptChartPlatform
extends JetRptDataContainer
implements PropertyChangeListener {
    public static final Hashtable chartTypes = new Hashtable();
    public static final Hashtable comboTypes = new Hashtable();
    private transient JetRptChartPlatform BUILTINTYPES;
    public JetRptDataSourceProperty dataSource;
    public JetBoolean horizontal;
    public JetChartTypeEnumeration type;
    public JetBoolean isCombo;
    public JetChartTypeEnumeration primaryType;
    public JetChartTypeEnumeration secondType;
    public JetColumnVector group1;
    public JetColumnVector group2;
    public JetColumnVector value;
    public JetVector catGroup;
    public JetString section;
    public JetBoolean level;
    public JetNumber start1st;
    public JetNumber end1st;
    public JetNumber start2nd;
    public JetNumber end2nd;
    public JetBoolean reverseInRow;
    public JetBoolean reverseInColumn;
    public JetStringList format;
    public JetStringList grpValueFormat;
    public JetBoolean antiAliasing;
    public JetVector grp1Patternlist;
    public JetVector grp2Patternlist;
    public JetVector grp3Patternlist;
    public JetString hyperlink;
    public JetString xhyperlink;
    public JetString zhyperlink;
    public JetEnumeration sortX;
    public JetEnumeration sortZ;
    public JetVector priFilter;
    public JetVector secFilter;
    public JetVector catFilter;
    public JetVector serFilter;
    public JetBoolean autoLayout;
    public JetRptChartBorderStyle borderStyle;
    public JetEnumeration penStyle;
    public JetColor penColor;
    public JetRptLineWidth penThickness;
    public JetEnumeration endCaps;
    public JetEnumeration lineJoint;
    public JetBoolean outlined;
    public JetBoolean variabledDash;
    public JetNumber borderTrans;
    public JetEnumeration fillPattern;
    public JetNumber bgTrans;
    public JetNumber top;
    public JetNumber left;
    public JetNumber right;
    public JetNumber bottom;
    public JetColor bgColor;
    public JetEnumeration textureStyle;
    public JetColor tForeColor;
    public JetColor tBackColor;
    public JetEnumeration gradientStyle;
    public JetColor startColor;
    public JetColor endColor;
    public JetNumber gradX1;
    public JetNumber gradY1;
    public JetNumber gradX2;
    public JetNumber gradY2;
    public JetImgProperty image;
    public JetEnumeration layout;
    public JetNumber imgX;
    public JetNumber imgY;
    public JetNumber imgWidth;
    public JetNumber imgHeight;
    public JetNumber sizeOfPart1;
    public JetNumber columnNum;
    public JetNumber rowNum;
    private static final HashMap CHART_FILTER_EDITOR;
    private static final HashVector CHART_FILTER_EDITOR_NO_DATE;

    private void BUILTINTYPES() {
        this.dataSource = new JetRptDataSourceProperty(this, "DataSource");
        this.horizontal = new JetBoolean(this, "Horizontal");
        this.type = new JetChartTypeEnumeration(this, "Type");
        this.isCombo = new JetBoolean(this, "IsCombo");
        this.primaryType = new JetChartTypeEnumeration(this, "PrimaryType");
        this.secondType = new JetChartTypeEnumeration(this, "SecondType");
        this.group1 = new JetColumnVector(this, "Category");
        this.group2 = new JetColumnVector(this, "Series");
        this.value = new JetColumnVector(this, "Value");
        this.catGroup = new JetVector(this, "CatGroup");
        this.section = new JetString(this, "Section");
        this.level = new JetBoolean(this, "SameLevel");
        this.start1st = new JetNumber(this, "StartOffset(1st Data Set)", -1);
        this.end1st = new JetNumber(this, "EndOffset(1st Data Set)", -1);
        this.start2nd = new JetNumber(this, "StartOffset(2nd Data Set)", -1);
        this.end2nd = new JetNumber(this, "EndOffset(2nd Data Set)", -1);
        this.reverseInRow = new JetBoolean(this, "ReverseRows", false);
        this.reverseInColumn = new JetBoolean(this, "ReverseColumns", false);
        this.format = new JetStringList(this, "HintFormat");
        this.grpValueFormat = new JetStringList(this, "GroupValueFormat");
        this.antiAliasing = new JetBoolean(this, "AntiAliasing", true);
        this.grp1Patternlist = new JetVector(this, "OuterGroupPatternList");
        this.grp2Patternlist = new JetVector(this, "InnerGroupPatternList");
        this.grp3Patternlist = new JetVector(this, "PatternList");
        this.hyperlink = new JetString(this, "HyperLink");
        this.xhyperlink = new JetString(this, "XHyperLink");
        this.zhyperlink = new JetString(this, "ZHyperLink");
        this.sortX = new JetEnumeration(this, "SortX", 88);
        this.sortZ = new JetEnumeration(this, "SortZ", 88);
        this.priFilter = new JetVector(this, "PrimaryDataFilter");
        this.secFilter = new JetVector(this, "SecondaryDataFilter");
        this.catFilter = new JetVector(this, "CategoryFilter");
        this.serFilter = new JetVector(this, "SeriesFilter");
        this.autoLayout = new JetBoolean(this, "AutoLayout", true);
        this.borderStyle = new JetRptChartBorderStyle(this, "BorderStyle");
        this.penStyle = new JetEnumeration(this, "PenStyle", 18);
        this.penColor = new JetColor(this, "PenColor", null, true);
        this.penThickness = new JetRptLineWidth(this, "PenThickness");
        this.endCaps = new JetEnumeration(this, "EndCaps", 14);
        this.lineJoint = new JetEnumeration(this, "LineJoint", 57);
        this.outlined = new JetBoolean(this, "Outline", false);
        this.variabledDash = new JetBoolean(this, "VariabledDash", false);
        this.borderTrans = new JetNumber(this, "BorderTransparency", 0);
        this.fillPattern = new JetEnumeration(this, "FillPattern", 76);
        this.bgTrans = new JetNumber(this, "BackgroundTransparency");
        this.top = new JetNumber(this, "Top");
        this.left = new JetNumber(this, "Left");
        this.right = new JetNumber(this, "Right");
        this.bottom = new JetNumber(this, "Bottom");
        this.bgColor = new JetColor(this, "BackgroundColor", null, true);
        this.textureStyle = new JetEnumeration(this, "TextureStyle", 96);
        this.tForeColor = new JetColor(this, "TextureForeColor", Color.black, true);
        this.tBackColor = new JetColor(this, "TextureBackColor", Color.white, true);
        this.gradientStyle = new JetEnumeration(this, "GradientStyle", 43);
        this.startColor = new JetColor(this, "GradientStartColor", Color.blue, true);
        this.endColor = new JetColor(this, "GradientEndColor", Color.red, true);
        this.gradX1 = new JetNumber(this, "GradientStartX");
        this.gradY1 = new JetNumber(this, "GradientStartY");
        this.gradX2 = new JetNumber(this, "GradientEndX", 100);
        this.gradY2 = new JetNumber(this, "GradientEndY", 100);
        this.image = new JetImgProperty(this, "Image");
        this.layout = new JetEnumeration(this, "ImageLayout", 49);
        this.imgX = new JetNumber(this, "ImageX");
        this.imgY = new JetNumber(this, "ImageY", 100);
        this.imgWidth = new JetNumber(this, "ImageWidth", 100);
        this.imgHeight = new JetNumber(this, "ImageHeight", 100);
        this.sizeOfPart1 = new JetNumber(this, "SizeOfPart1", -1);
        this.columnNum = new JetNumber(this, "ColumnNumber", 0);
        this.rowNum = new JetNumber(this, "RowNumber", 0);
    }

    public JetRptChartPlatform() {
        this.BUILTINTYPES();
        Vector vector = ReportFormat.getMoreFormat(2, 0);
        Vector vector2 = ReportFormat.getMoreFormat(-5, 0);
        int n = 0;
        while (n < vector2.size()) {
            if (!vector.contains(vector2.elementAt(n))) {
                vector.addElement(vector2.elementAt(n));
            }
            ++n;
        }
        this.format.setList(vector);
        this.format.set((String)vector.elementAt(0));
        vector = ReportFormat.getMoreFormat(12, 0);
        this.grpValueFormat.setList(vector);
        this.grpValueFormat.set((String)vector.elementAt(0));
        this.sortX.set("None");
        this.sortZ.set("None");
        this.isCombo.set(false);
        this.primaryType.setEnumerationSet(chartTypes);
        this.secondType.setEnumerationSet(comboTypes);
        this.COLORLENGTH();
        this.penStyle.set("Solid Line");
        this.endCaps.set("Square");
        this.lineJoint.set("Miter");
        this.fillPattern.set("None");
        this.layout.set("Tile");
        this.textureStyle.set("Small Dot");
        this.gradientStyle.set("Linear");
        this.height.setUnitValue(JRObjectTemplate.convertSize(400));
        this.width.setUnitValue(JRObjectTemplate.convertSize(500));
        this.setObjectType(71);
        this.dataSource.setEditFlag(0);
        this.primaryType.setEditFlag(0);
        this.secondType.setEditFlag(0);
        this.isCombo.setEditFlag(0);
        this.group1.setEditFlag(0);
        this.group2.setEditFlag(0);
        this.value.setEditFlag(0);
        this.grp1Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.grp2Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.grp3Patternlist.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
        this.priFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.secFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR_NO_DATE);
        this.catFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.serFilter.setEditorType(JetProperty.CHART_FILTER_EDITOR);
        this.outlined.setCanChangeByOthers(false);
        this.variabledDash.setCanChangeByOthers(false);
        this.top.setCanChangeByOthers(false);
        this.bottom.setCanChangeByOthers(false);
        this.left.setCanChangeByOthers(false);
        this.right.setCanChangeByOthers(false);
        this.columnNum.setCanChangeByOthers(false);
        this.rowNum.setCanChangeByOthers(false);
        this.style.setDefault(JRObjectTemplate.CHARTPLATFORM_STL);
        if (this.style.getList() == null) {
            Vector<String> vector3 = new Vector<String>();
            vector3.add(JRObjectTemplate.CHARTPLATFORM_STL);
            this.style.setList(vector3);
        } else if (!this.style.getList().contains(JRObjectTemplate.CHARTPLATFORM_STL)) {
            this.style.getList().insertElementAt(JRObjectTemplate.CHARTPLATFORM_STL, 0);
        }
    }

    public ChartDataSetInfo[] getChartDataSetInfos() {
        ChartDataSetInfo[] chartDataSetInfoArray = this.isCombo.get() ? new ChartDataSetInfo[]{new ChartDataSetInfo((Integer)this.primaryType.get()), new ChartDataSetInfo((Integer)this.secondType.get())} : new ChartDataSetInfo[]{new ChartDataSetInfo((Integer)this.primaryType.get())};
        return chartDataSetInfoArray;
    }

    public void setChartDataSetInfos(ChartDataSetInfo[] chartDataSetInfoArray) {
        boolean bl = chartDataSetInfoArray.length > 1;
        this.isCombo.set(bl);
        this.primaryType.set(JetChartPropertyValues.mapTypeFromIntToStr(chartDataSetInfoArray[0].getChartType()));
        if (bl) {
            this.secondType.set(JetChartPropertyValues.mapTypeFromIntToStr(chartDataSetInfoArray[1].getChartType()));
        }
    }

    public static ChartDataFilter getFilter(JetVector jetVector) {
        Vector vector = jetVector.get();
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        ChartDataFilter chartDataFilter = new ChartDataFilter();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        int n2 = 0;
        while (n2 < n) {
            String string = vector.elementAt(n2).toString();
            Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
            vector2.add(objectArray);
            ++n2;
        }
        chartDataFilter.setFilters(vector2);
        return chartDataFilter;
    }

    public static String getFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            int n = 0;
            while (n < chartDataFilter.getFilters().size()) {
                if (n != 0) {
                    string = string + "\u0007";
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(n);
                string = string + objectArray[0].toString() + objectArray[1].toString();
                ++n;
            }
        }
        return string;
    }

    public ChartPenStyle getPen() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(this.penColor.get());
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setDashPattern(this.penStyle.intValue());
        chartColorPattern.setColor((Color)this.penColor.getValue());
        chartColorPattern.setAlpha((float)this.borderTrans.intValue() / 100.0f);
        chartPenStyle.setPenWidth(this.penThickness.intValue());
        chartPenStyle.setEndCaps(this.endCaps.intValue());
        chartPenStyle.setPenColor(chartColorPattern);
        chartPenStyle.setLineJoints(this.lineJoint.intValue());
        chartPenStyle.setOutlined(this.outlined.booleanValue());
        chartPenStyle.setVariabledDash(this.variabledDash.booleanValue());
        return chartPenStyle;
    }

    public ChartFillPattern getPattern(Component component) {
        ChartFillPattern chartFillPattern = null;
        switch (this.fillPattern.intValue()) {
            case 0: {
                return null;
            }
            case 1: {
                chartFillPattern = new ChartColorPattern((Color)this.bgColor.getValue());
                ((ChartColorPattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                break;
            }
            case 2: {
                try {
                    chartFillPattern = new ChartTexturePattern(this.textureStyle.intValue(), new ChartColorPattern((Color)this.tForeColor.getValue()), new ChartColorPattern((Color)this.tBackColor.getValue()));
                    ((ChartTexturePattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                try {
                    chartFillPattern = new ChartGradientPattern(this.gradientStyle.intValue());
                    ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern((Color)this.startColor.getValue()));
                    ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern((Color)this.endColor.getValue()));
                    ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float((float)this.gradX1.intValue() / 100.0f, 1.0f - (float)this.gradY1.intValue() / 100.0f));
                    ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float((float)this.gradX2.intValue() / 100.0f, 1.0f - (float)this.gradY2.intValue() / 100.0f));
                    ((ChartGradientPattern)chartFillPattern).setAlpha((float)this.bgTrans.intValue() / 100.0f);
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                Object object;
                String string = this.image.get();
                if (string == null || string.length() <= 0) break;
                float f = (float)this.imgX.intValue() / 100.0f;
                float f2 = 1.0f - (float)this.imgY.intValue() / 100.0f;
                float f3 = (float)this.imgWidth.intValue() / 100.0f;
                float f4 = (float)this.imgHeight.intValue() / 100.0f;
                f3 = f + f3 > 1.0f ? 1.0f - f : f3;
                f4 = f2 + f4 > 1.0f ? 1.0f - f2 : f4;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
                int n = this.layout.intValue();
                float f5 = (float)this.bgTrans.intValue() / 100.0f;
                String string2 = "";
                if (string.indexOf(":") == -1) {
                    object = ReportTools.getDataSet(this);
                    string2 = object != null ? object.getUniversePath() : this.dataSource.get().getUniversePath();
                }
                object = string2 + File.separator + this.image.get();
                chartFillPattern = new ChartCustomizedPattern((String)object, float_, n, f5);
            }
        }
        return chartFillPattern;
    }

    public String getInstancePrefix() {
        return "ChartPlatform";
    }

    public String getPrefix() {
        return JResource.getMessage("ChartPlatform");
    }

    public synchronized void afterInit() {
        if (!this.isAfterInit()) {
            Vector<String> vector;
            Vector vector2;
            int n;
            if (((JetRootable)((Object)JetObject.getRoot(this))).getVersion() <= 65550) {
                n = 1;
                vector2 = this.group1.get();
                vector = vector2.iterator();
                while (vector.hasNext()) {
                    String string = (String)vector.next();
                    if (string.equals("")) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    this.set("Category", "");
                }
            }
            if (((JetRootable)((Object)JetObject.getRoot(this))).getVersion() <= 65541) {
                Object object;
                if (this.start1st.isChangeByOther()) {
                    String string = (String)this.start1st.getChangeByObject();
                    this.start1st.set(0);
                    this.end1st.setChangeByObject(string);
                    this.start2nd.set(0);
                    this.end2nd.setChangeByObject(string);
                } else {
                    n = this.start1st.intValue();
                    if (n > 0) {
                        this.start1st.set(0);
                        this.end1st.set(n - 1);
                        n = this.start2nd.intValue();
                        this.start2nd.set(0);
                        this.end2nd.set(n - 1);
                    }
                }
                if (this.backColor.isChangeByOther()) {
                    object = (String)this.backColor.getChangeByObject();
                    this.bgColor.setChangeByObject(object);
                    this.penColor.setChangeByObject(object);
                } else {
                    object = this.backColor.get();
                    this.bgColor.set((Color)object);
                    this.penColor.set((Color)object);
                }
                this.backColor.set((Color)null);
                object = (String)this.image.getValue();
                if (object == null || ((String)object).length() < 1) {
                    this.fillPattern.set(new Integer(1));
                } else {
                    this.fillPattern.set(new Integer(4));
                    this.layout.set(new Integer(2));
                }
                vector2 = this.grp1Patternlist.get();
                vector = new Vector();
                int n2 = vector2 == null ? 0 : vector2.size();
                int n3 = 0;
                while (n3 < n2) {
                    vector.addElement("c" + this.CHART_FILTER_EDITOR_NO_DATE((String)vector2.elementAt(n3)) + "000");
                    ++n3;
                }
                if (n2 > 0) {
                    this.grp1Patternlist.set(vector);
                }
                vector2 = this.grp2Patternlist.get();
                vector = new Vector<String>();
                n2 = vector2 == null ? 0 : vector2.size();
                int n4 = 0;
                while (n4 < n2) {
                    vector.addElement("c" + this.CHART_FILTER_EDITOR_NO_DATE((String)vector2.elementAt(n4)) + "000");
                    ++n4;
                }
                if (n2 > 0) {
                    this.grp2Patternlist.set(vector);
                }
                this.CHART_FILTER_EDITOR();
            }
        }
        this.CHARTPLATFORM_STL();
        this.CHART_PATTERN_LIST_EDITOR();
        super.afterInit();
    }

    private void CHARTPLATFORM_STL() {
        int n;
        Vector vector = this.grp1Patternlist.get();
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            this.grp3Patternlist.set(vector);
        }
        int n3 = n = (vector = this.grp2Patternlist.get()) == null ? 0 : vector.size();
        if (n > 0) {
            this.grp3Patternlist.set(vector);
        }
        int n4 = n = (vector = this.grp3Patternlist.get()) == null ? 0 : vector.size();
        if (n == 0) {
            this.grp3Patternlist.set(JetChartPropertyValues.getDefaultPatternString());
        } else if (n < JetChartPropertyValues.COLORLENGTH) {
            int n5 = n;
            while (n5 < JetChartPropertyValues.COLORLENGTH) {
                vector.add("c0x" + Integer.toHexString(JetChartPropertyValues.DEFAULTCOLORS[n5]) + "000");
                ++n5;
            }
            this.grp3Patternlist.set(vector);
        }
    }

    private void CHART_FILTER_EDITOR() {
        Object object;
        Object object2;
        Vector vector = this.getChildren();
        Object var2_2 = null;
        int n = Unit.convertInchToUnit(0.02);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = vector.size() - 1;
        while (n5 >= 0) {
            JRObjectTemplate jRObjectTemplate;
            var2_2 = vector.elementAt(n5);
            if (var2_2 instanceof JetRptChartLegend) {
                jRObjectTemplate = var2_2;
                bl = jRObjectTemplate.showlegend.get() && (!jRObjectTemplate.hideCategory.get() || !jRObjectTemplate.hideSeries.get());
                jRObjectTemplate.x.setUnitValue(-1);
                jRObjectTemplate.y.setUnitValue(-1);
                jRObjectTemplate.width.setUnitValue(-1);
                jRObjectTemplate.height.setUnitValue(-1);
            } else if (var2_2 instanceof JetRptChartLabel) {
                jRObjectTemplate = var2_2;
                String string = ((JetRptChartLabel)jRObjectTemplate).text.get();
                if (string != "") {
                    object2 = (String)((JetRptChartLabel)jRObjectTemplate).location.get();
                    ((JetRptChartLabel)jRObjectTemplate).height.setUnitValue(((JetRptChartLabel)jRObjectTemplate).height.getUnit() + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit());
                    if (((String)object2).equals("North")) {
                        n3 = ((JetRptChartLabel)jRObjectTemplate).height.getUnit();
                    } else if (((String)object2).equals("South")) {
                        n4 = ((JetRptChartLabel)jRObjectTemplate).height.getUnit();
                    }
                    if (string == null || string.length() == 0) {
                        this.remove(jRObjectTemplate);
                    } else {
                        object = FontSets.getFont(((JetRptChartLabel)jRObjectTemplate).fontName.get(), (int)((Integer)((JetRptChartLabel)jRObjectTemplate).fontStyle.get()), ((JetRptChartLabel)jRObjectTemplate).fontSize.get());
                        FontMetrics fontMetrics = object instanceof JFont ? ((JFont)object).getFontMetrics() : Toolkit.getDefaultToolkit().getFontMetrics((Font)object);
                        int n6 = Unit.convertPixelToUnit(fontMetrics.stringWidth(string));
                        if (((String)object2).equals("North")) {
                            ((JetRptChartLabel)jRObjectTemplate).x.setUnitValue((this.width.getUnit() - (n6 + n * 2)) / 2);
                            ((JetRptChartLabel)jRObjectTemplate).y.setUnitValue(n + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0));
                            ((JetRptChartLabel)jRObjectTemplate).width.setUnitValue(n6 + n * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit());
                            ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Center");
                        } else if (((String)object2).equals("South")) {
                            ((JetRptChartLabel)jRObjectTemplate).x.setUnitValue((this.width.getUnit() - (n6 + n * 2)) / 2);
                            ((JetRptChartLabel)jRObjectTemplate).y.setUnitValue(this.height.getUnit() - (((JetRptChartLabel)jRObjectTemplate).height.getUnit() + n) - (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0));
                            ((JetRptChartLabel)jRObjectTemplate).width.setUnitValue(n6 + n * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit());
                            ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Center");
                        } else {
                            n2 = n6 + n * 2;
                            ((JetRptChartLabel)jRObjectTemplate).x.setUnitValue(n + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0));
                            ((JetRptChartLabel)jRObjectTemplate).y.setUnitValue((this.height.getUnit() - (((JetRptChartLabel)jRObjectTemplate).height.getUnit() + n * 2)) / 2);
                            ((JetRptChartLabel)jRObjectTemplate).width.setUnitValue(n6 + n * 2 + 2 * ((JetRptChartLabel)jRObjectTemplate).penThickness.getUnit());
                            ((JetRptChartLabel)jRObjectTemplate).textAlign.set("Left");
                        }
                    }
                } else {
                    this.remove((JetObject)var2_2);
                }
            }
            --n5;
        }
        int n7 = Unit.convertPixelToUnit(3);
        int n8 = 0;
        while (n8 < vector.size()) {
            var2_2 = vector.elementAt(n8);
            if (var2_2 instanceof JetRptChartCoordinatepaper) {
                object2 = var2_2;
                ((JetRptChartCoordinatepaper)object2).x.setUnitValue(n2 + n * 2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0));
                ((JetRptChartCoordinatepaper)object2).y.setUnitValue(n3 + n * 2 + (this.borderStyle.intValue() != 3 ? this.penThickness.getUnit() : 0));
                ((JetRptChartCoordinatepaper)object2).width.setUnitValue(this.width.getUnit() - n2 - (bl ? this.width.getUnit() * 3 / 16 + n * (this.borderStyle.intValue() != 3 ? 5 : 6) + n7 : 0) - 2 * this.penThickness.getUnit());
                ((JetRptChartCoordinatepaper)object2).height.setUnitValue(this.height.getUnit() - (n3 + n4 + n * 4) - 2 * this.penThickness.getUnit());
            }
            ++n8;
        }
        object2 = this.group1.get();
        object = (String)((Vector)object2).elementAt(0);
        if (object != null && !((String)object).equals("")) {
            this.section.set((String)object);
        }
        this.catGroup.add("1");
    }

    private String CHART_FILTER_EDITOR_NO_DATE(String string) {
        String string2;
        int n = 8 - string.length();
        switch (n) {
            case 1: {
                string2 = "0";
                break;
            }
            case 2: {
                string2 = "00";
                break;
            }
            case 3: {
                string2 = "000";
                break;
            }
            case 4: {
                string2 = "0000";
                break;
            }
            case 5: {
                string2 = "00000";
                break;
            }
            case 6: {
                string2 = "000000";
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (n <= 0) {
            return string;
        }
        return "0x" + string2 + string.substring(2);
    }

    public JetRptChartCoordinatepaper get3DPaper() {
        Vector vector = this.getChildren();
        JetRptChartCoordinatepaper jetRptChartCoordinatepaper = null;
        int n = 0;
        while (n < vector.size()) {
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)vector.get(n);
            if (jRObjectTemplate.getObjectType() == 72) {
                jetRptChartCoordinatepaper = (JetRptChartCoordinatepaper)jRObjectTemplate;
                break;
            }
            ++n;
        }
        return jetRptChartCoordinatepaper;
    }

    public JetRptChart2DCoordinatepaper get2DPaper() {
        Vector vector = this.getChildren();
        JetRptChart2DCoordinatepaper jetRptChart2DCoordinatepaper = null;
        int n = 0;
        while (n < vector.size()) {
            JRObjectTemplate jRObjectTemplate = (JRObjectTemplate)vector.get(n);
            if (jRObjectTemplate.getObjectType() == 74) {
                jetRptChart2DCoordinatepaper = (JetRptChart2DCoordinatepaper)jRObjectTemplate;
                break;
            }
            ++n;
        }
        return jetRptChart2DCoordinatepaper;
    }

    public JetRptChartLegend getLegend() {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        int n = 0;
        while (n < vector.size()) {
            jRObjectTemplate = (JRObjectTemplate)vector.elementAt(n);
            if (jRObjectTemplate.getObjectType() == 70) break;
            ++n;
        }
        return (JetRptChartLegend)jRObjectTemplate;
    }

    public JetRptChartLabel getChartLabel(String string) {
        Vector vector = this.getChildren();
        JRObjectTemplate jRObjectTemplate = null;
        int n = 0;
        while (n < vector.size()) {
            jRObjectTemplate = (JRObjectTemplate)vector.elementAt(n);
            if (jRObjectTemplate.getObjectType() == 69 && ((String)((JetEnumeration)jRObjectTemplate.getPropertyByName("LabelLocation")).getObject()).equals(string)) {
                return (JetRptChartLabel)jRObjectTemplate;
            }
            ++n;
        }
        return null;
    }

    public boolean isByOneGroup() {
        Vector vector = this.group2.get();
        return vector == null || vector.size() == 0;
    }

    public JetProperty nameToProperty(String string) {
        String[] stringArray = (String[])ChangedProperties.htJetRptChartPlatform.get(string);
        if (stringArray != null) {
            return super.nameToProperty(stringArray[0]);
        }
        return super.nameToProperty(string);
    }

    public void checkChart() {
        JetObject jetObject;
        JetRptObject jetRptObject;
        JetObject jetObject2 = JetObject.getRoot(this);
        JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)jetObject2;
        TreeIterater treeIterater = new TreeIterater(jetRptReportPanel, false);
        String string = null;
        String string2 = null;
        JetRptDataSource jetRptDataSource = jetRptReportPanel.getDataSource();
        DataSet dataSet = ReportTools.getDataSet(this);
        JetUUniverse jetUUniverse = dataSet != null ? dataSet.getCurrentUniverse() : jetRptDataSource.getUniverse();
        if (jetUUniverse == null) {
            return;
        }
        String string3 = dataSet != null ? ((JetRptQueryDataSet)dataSet).getQueryName() : jetRptDataSource.uQueryName.get();
        if (string3 == null || string3.length() <= 0) {
            return;
        }
        JetUDatabase jetUDatabase = dataSet != null ? jetUUniverse.getDatabase(((JetRptQueryDataSet)dataSet).getDsName()) : jetUUniverse.getDatabase(jetRptDataSource.sourceName.get());
        Vector vector = jetRptReportPanel.getGroupPanels();
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            jetRptObject = (JetRptGroupPanel)vector.elementAt(n2);
            vector2.addElement(jetRptObject.nameToProperty("GroupBy").toUnitString());
            ++n2;
        }
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject != this) continue;
            jetRptObject = (JetRptChartPlatform)jetObject;
            if (!((JetRptChartPlatform)jetRptObject).isByOneGroup()) {
                int n3 = 0;
                int n4 = 0;
                Vector vector3 = ((JetRptChartPlatform)jetRptObject).group1.get();
                Vector vector4 = ((JetRptChartPlatform)jetRptObject).group2.get();
                if (vector3 != null && vector3.size() > 0) {
                    string = (String)vector3.elementAt(0);
                }
                if (vector4 != null && vector4.size() > 0) {
                    string2 = (String)vector4.elementAt(0);
                }
                int n5 = 0;
                while (n5 < n) {
                    if (((String)vector2.elementAt(n5)).equalsIgnoreCase(string)) {
                        n3 = n5;
                    } else if (((String)vector2.elementAt(n5)).equalsIgnoreCase(string2)) {
                        n4 = n5;
                    }
                    ++n5;
                }
                if (n4 > n3) {
                    return;
                }
                String string4 = new String(string);
                string = string2;
                string2 = string4;
                this.group1 = new JetColumnVector(this, "Category");
                this.group2 = new JetColumnVector(this, "Series");
                this.group1.add(string);
                this.group2.add(string2);
            }
            return;
        }
    }

    private void CHART_PATTERN_LIST_EDITOR() {
        int n;
        Object object;
        Object object2;
        if (this.primaryType.get() == null && this.secondType.get() == null) {
            if (this.type.get() instanceof Integer) {
                this.isCombo.set(false);
                this.primaryType.set(this.type.get());
            } else if (this.type.get() instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.type.get();
                object2 = (int[])arrayList.get(0);
                object = (int[])arrayList.get(1);
                this.isCombo.set(true);
                this.primaryType.set(new Integer(ChartTypeInfo.BUILTINTYPES[object2[0]][object2[1]]));
                this.secondType.set(new Integer(ChartTypeInfo.BUILTINTYPES[object[0]][object[1]]));
                if (object[0] == 3) {
                    this.get2DPaper().reversePaintingOrder.set(true);
                }
            }
        }
        if ((n = ((JetRootable)((Object)JetObject.getRoot(this))).getVersion()) >= 65541 && n < 65545) {
            object2 = this.get2DPaper();
            if (object2 != null) {
                ((JetRptChart2DCoordinatepaper)object2).keepOldLayout.set(true);
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapX.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapX.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapY.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapY.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).labelAxisGapY2.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).labelAxisGapY2.set(12);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthX.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthX.set(8);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY1.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY1.set(8);
                }
                if (((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY2.isNull()) {
                    ((JetRptChart2DCoordinatepaper)object2).tickMarkLengthY2.set(8);
                }
            }
            object = this.getLegend();
            ((JetRptChartLegend)object).showlegend.set(this.isByOneGroup() && !this.isCombo.booleanValue() ? !((JetRptChartLegend)object).hideCategory.booleanValue() : !((JetRptChartLegend)object).hideSeries.booleanValue());
        }
    }

    private void COLORLENGTH() {
        this.type.setEnumerationSet((Hashtable)chartTypes.clone());
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = 0;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 2};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[2];
        nArray[0] = 0;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 1;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-LineStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[2];
        nArray[0] = 2;
        nArray[1] = 0;
        nArray2[0] = 2;
        nArray2[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DLineArray-LineArray2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[2];
        nArray2 = new int[]{3, 1};
        nArray[0] = 0;
        nArray[1] = 0;
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarSideBySide-AreaStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 1};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarStack-AreaStack2Y", arrayList);
        arrayList = new ArrayList();
        nArray = new int[]{0, 2};
        arrayList.add(nArray);
        arrayList.add(nArray2);
        this.type.add("2DBarPercent-AreaStack2Y", arrayList);
        this.type.set("3DBarArray");
    }

    public Hashtable getPropertiesForAdhoc() {
        int n = Unit.convertPixelToUnit(this.x.intValue());
        int n2 = Unit.convertPixelToUnit(this.y.intValue());
        int n3 = Unit.convertPixelToUnit(this.width.intValue());
        int n4 = Unit.convertPixelToUnit(this.height.intValue());
        int n5 = this.start2nd.intValue();
        int n6 = this.end2nd.intValue();
        int n7 = this.start1st.intValue();
        int n8 = this.end1st.intValue();
        Hashtable hashtable = (Hashtable)this.getProperties().clone();
        hashtable.put("X", new Integer(n));
        hashtable.put("Y", new Integer(n2));
        hashtable.put("Width", new Integer(n3));
        hashtable.put("Height", new Integer(n4));
        hashtable.put("StartOffsetX", new Integer(n7));
        hashtable.put("EndOffsetX", new Integer(n8));
        hashtable.put("StartOffsetZ", new Integer(n5));
        hashtable.put("EndOffsetZ", new Integer(n6));
        hashtable.put("SortX", new Integer(this.sortX.intValue()));
        hashtable.put("SortZ", new Integer(this.sortZ.intValue()));
        ChartFillPattern[] chartFillPatternArray = null;
        ChartFillPattern[] chartFillPatternArray2 = null;
        ChartFillPattern[] chartFillPatternArray3 = null;
        Vector vector = this.grp1Patternlist.get();
        int n9 = 0;
        if (vector != null) {
            n9 = vector.size();
        }
        if (n9 != 0) {
            chartFillPatternArray = JetChartPropertyValues.mapPatterns(vector);
        }
        if (chartFillPatternArray == null) {
            hashtable.put("OuterPatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray);
            hashtable.put("OuterPatternList", string);
            hashtable.put("OuterFillPatternLength", new Integer(chartFillPatternArray.length));
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", new Integer(chartFillPatternArray.length));
        }
        Vector vector2 = this.grp2Patternlist.get();
        n9 = 0;
        if (vector2 != null) {
            n9 = vector2.size();
        }
        if (n9 != 0) {
            chartFillPatternArray2 = JetChartPropertyValues.mapPatterns(vector2);
        }
        if (chartFillPatternArray2 == null) {
            hashtable.put("InnerPatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray2);
            hashtable.put("InnerPatternList", string);
            hashtable.put("InnerFillPatternLength", new Integer(chartFillPatternArray2.length));
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", new Integer(chartFillPatternArray2.length));
        }
        Vector vector3 = this.grp3Patternlist.get();
        n9 = 0;
        if (vector3 != null) {
            n9 = vector3.size();
        }
        if (n9 != 0) {
            chartFillPatternArray3 = JetChartPropertyValues.mapPatterns(vector3);
        }
        if (chartFillPatternArray3 == null) {
            hashtable.put("PatternList", "");
        } else {
            String string = this.getGroupPatternString(chartFillPatternArray3);
            hashtable.put("PatternList", string);
            hashtable.put("FillPatternLength", new Integer(chartFillPatternArray3.length));
        }
        hashtable.put("PrimaryDataFilter", "");
        hashtable.put("SecondaryDataFilter", "");
        hashtable.put("CategoryFilter", "");
        hashtable.put("SeriesFilter", "");
        hashtable.put("BorderStyle", new Integer(this.borderStyle.intValue()));
        hashtable.put("PenStyle", new Integer(this.penStyle.intValue()));
        hashtable.put("EndCaps", new Integer(this.endCaps.intValue()));
        hashtable.put("LineJoint", new Integer(this.lineJoint.intValue()));
        hashtable.put("FillPattern", new Integer(this.fillPattern.intValue()));
        hashtable.put("TextureStyle", new Integer(this.textureStyle.intValue()));
        hashtable.put("GradientStyle", new Integer(this.gradientStyle.intValue()));
        hashtable.put("ImageLayout", new Integer(this.layout.intValue()));
        return hashtable;
    }

    public String getGroupPatternString(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        int n = 0;
        while (n < chartFillPatternArray.length) {
            String string2;
            Color color;
            String string3;
            String string4;
            int n2;
            ChartFillPattern chartFillPattern;
            Color color2;
            if (n != 0) {
                string = string + "@";
            }
            string = string + n;
            if (chartFillPatternArray[n] == null) {
                string = string + "~";
                string = string + "0";
                string = string + "~";
                string = string + "0";
            } else if (chartFillPatternArray[n] instanceof ChartColorPattern) {
                string = string + "~";
                string = string + chartFillPatternArray[n].getAlpha();
                string = string + "~1~";
                color2 = ((ChartColorPattern)chartFillPatternArray[n]).getColor();
                string = color2 != null ? string + MiscTools.mapColorToString(color2) : string + "Transparent";
            } else if (chartFillPatternArray[n] instanceof ChartTexturePattern) {
                string = string + "~";
                string = string + chartFillPatternArray[n].getAlpha();
                string = string + "~2~";
                chartFillPattern = (ChartTexturePattern)chartFillPatternArray[n];
                n2 = ((ChartTexturePattern)chartFillPattern).getPattern();
                string4 = "";
                if (n2 < 10) {
                    string4 = "0";
                }
                string4 = string4 + String.valueOf(new Integer(n2));
                color2 = ((ChartTexturePattern)chartFillPattern).getForeground().getColor();
                string3 = color2 != null ? MiscTools.mapColorToString(color2) : "Transparent";
                color = ((ChartTexturePattern)chartFillPattern).getBackground().getColor();
                string2 = color != null ? MiscTools.mapColorToString(color) : "Transparent";
                string = string + string4 + "~" + string3 + "~" + string2;
            } else if (chartFillPatternArray[n] instanceof ChartGradientPattern) {
                string = string + "~";
                string = string + chartFillPatternArray[n].getAlpha();
                string = string + "~3~";
                chartFillPattern = (ChartGradientPattern)chartFillPatternArray[n];
                n2 = ((ChartGradientPattern)chartFillPattern).getPattern();
                string4 = "";
                if (n2 < 10) {
                    string4 = "0";
                }
                string4 = string4 + String.valueOf(new Integer(n2));
                color2 = ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
                string3 = color2 != null ? MiscTools.mapColorToString(color2) : "Transparent";
                color = ((ChartGradientPattern)chartFillPattern).getEndColor().getColor();
                string2 = color != null ? MiscTools.mapColorToString(color) : "Transparent";
                int n3 = (int)(((ChartGradientPattern)chartFillPattern).getStartPoint().getX() * 100.0);
                int n4 = (int)((1.0 - ((ChartGradientPattern)chartFillPattern).getStartPoint().getY()) * 100.0);
                int n5 = (int)(((ChartGradientPattern)chartFillPattern).getEndPoint().getX() * 100.0);
                int n6 = (int)((1.0 - ((ChartGradientPattern)chartFillPattern).getEndPoint().getY()) * 100.0);
                String string5 = "";
                if (n3 < 10) {
                    string5 = "00";
                } else if (n3 < 100) {
                    string5 = "0";
                }
                string5 = string5 + String.valueOf(new Integer(n3));
                String string6 = "";
                if (n5 < 10) {
                    string6 = "00";
                } else if (n5 < 100) {
                    string6 = "0";
                }
                string6 = string6 + String.valueOf(new Integer(n5));
                String string7 = "";
                if (n4 < 10) {
                    string7 = "00";
                } else if (n4 < 100) {
                    string7 = "0";
                }
                string7 = string7 + String.valueOf(new Integer(n4));
                String string8 = "";
                if (n6 < 10) {
                    string8 = "00";
                } else if (n6 < 100) {
                    string8 = "0";
                }
                string8 = string8 + String.valueOf(new Integer(n6));
                string = string + string4 + "~" + string3 + "~" + string2 + "~" + string5 + "~" + string7 + "~" + string6 + "~" + string8;
            }
            ++n;
        }
        return string;
    }

    public JetObject deepDupWithoutCopyProperties(Hashtable hashtable, Hashtable hashtable2, boolean bl, boolean bl2) {
        JetRptChartPlatform jetRptChartPlatform = null;
        jetRptChartPlatform = (JetRptChartPlatform)super.deepDupWithoutCopyProperties(hashtable, hashtable2, bl, bl2);
        jetRptChartPlatform.setLinkedTemplate(this);
        jetRptChartPlatform.primaryType.addPropertyChangeListener(jetRptChartPlatform);
        jetRptChartPlatform.secondType.addPropertyChangeListener(jetRptChartPlatform);
        return jetRptChartPlatform;
    }

    public JetRptChartPlatform getLinkedTemplate() {
        return this.BUILTINTYPES;
    }

    public void setLinkedTemplate(JetRptChartPlatform jetRptChartPlatform) {
        this.BUILTINTYPES = jetRptChartPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.BUILTINTYPES != null) {
            JetRptChartPlatform jetRptChartPlatform = this.BUILTINTYPES;
            synchronized (jetRptChartPlatform) {
                JetChartTypeEnumeration jetChartTypeEnumeration = this.BUILTINTYPES.primaryType;
                JetChartTypeEnumeration jetChartTypeEnumeration2 = this.BUILTINTYPES.secondType;
                jetChartTypeEnumeration.runtime = true;
                if (this.primaryType.runtime) {
                    jetChartTypeEnumeration.set(this.primaryType.get());
                } else if (this.secondType.runtime) {
                    jetChartTypeEnumeration2.runtime = true;
                    jetChartTypeEnumeration2.set(this.secondType.get());
                }
            }
        }
    }

    public Vector getChildren() {
        Vector vector = this.BUILTINTYPES != null ? this.BUILTINTYPES.getChildren() : super.getChildren();
        return vector;
    }

    public HashMap getIndecialMap() {
        return CHART_FILTER_EDITOR;
    }

    public HashVector getPropGrpsDesc() {
        return CHART_FILTER_EDITOR_NO_DATE;
    }

    static {
        chartTypes.put("2DBarSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[0][0]));
        chartTypes.put("2DBarStack", new Integer(ChartTypeInfo.BUILTINTYPES[0][1]));
        chartTypes.put("2DBarPercent", new Integer(ChartTypeInfo.BUILTINTYPES[0][2]));
        chartTypes.put("3DBarSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[0][3]));
        chartTypes.put("3DBarStack", new Integer(ChartTypeInfo.BUILTINTYPES[0][4]));
        chartTypes.put("3DBarPercent", new Integer(ChartTypeInfo.BUILTINTYPES[0][5]));
        chartTypes.put("3DBarArray", new Integer(ChartTypeInfo.BUILTINTYPES[0][6]));
        chartTypes.put("2DBenchSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[1][0]));
        chartTypes.put("2DBenchStack", new Integer(ChartTypeInfo.BUILTINTYPES[1][1]));
        chartTypes.put("2DBenchPercent", new Integer(ChartTypeInfo.BUILTINTYPES[1][2]));
        chartTypes.put("3DBenchSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[1][3]));
        chartTypes.put("3DBenchStack", new Integer(ChartTypeInfo.BUILTINTYPES[1][4]));
        chartTypes.put("3DBenchPercent", new Integer(ChartTypeInfo.BUILTINTYPES[1][5]));
        chartTypes.put("3DBenchArray", new Integer(ChartTypeInfo.BUILTINTYPES[1][6]));
        chartTypes.put("2DLineArray", new Integer(ChartTypeInfo.BUILTINTYPES[2][0]));
        chartTypes.put("2DLineStack", new Integer(ChartTypeInfo.BUILTINTYPES[2][1]));
        chartTypes.put("2DLinePercent", new Integer(ChartTypeInfo.BUILTINTYPES[2][2]));
        chartTypes.put("3DLineArray", new Integer(ChartTypeInfo.BUILTINTYPES[2][3]));
        chartTypes.put("2DAreaArray", new Integer(ChartTypeInfo.BUILTINTYPES[3][0]));
        chartTypes.put("2DAreaStack", new Integer(ChartTypeInfo.BUILTINTYPES[3][1]));
        chartTypes.put("2DAreaPercent", new Integer(ChartTypeInfo.BUILTINTYPES[3][2]));
        chartTypes.put("3DAreaArray", new Integer(ChartTypeInfo.BUILTINTYPES[3][3]));
        chartTypes.put("3DAreaStack", new Integer(ChartTypeInfo.BUILTINTYPES[3][4]));
        chartTypes.put("3DAreaPercent", new Integer(ChartTypeInfo.BUILTINTYPES[3][5]));
        chartTypes.put("2DPieSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[4][0]));
        chartTypes.put("3DPieSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[4][1]));
        chartTypes.put("2DRadar", new Integer(ChartTypeInfo.BUILTINTYPES[5][0]));
        chartTypes.put("2DGaugeDial", new Integer(ChartTypeInfo.BUILTINTYPES[6][0]));
        chartTypes.put("2DGaugeBar", new Integer(ChartTypeInfo.BUILTINTYPES[6][1]));
        chartTypes.put("2DGaugeBall", new Integer(ChartTypeInfo.BUILTINTYPES[6][2]));
        chartTypes.put("3DSurface", new Integer(ChartTypeInfo.BUILTINTYPES[7][0]));
        chartTypes.put("2DScatterArray", new Integer(ChartTypeInfo.BUILTINTYPES[8][0]));
        chartTypes.put("2DScatterStack", new Integer(ChartTypeInfo.BUILTINTYPES[8][1]));
        chartTypes.put("2DScatterSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[8][2]));
        chartTypes.put("2DBubble", new Integer(ChartTypeInfo.BUILTINTYPES[9][0]));
        chartTypes.put("2DHigh_LowStock", new Integer(ChartTypeInfo.BUILTINTYPES[10][0]));
        chartTypes.put("2DHigh_Low_CloseStock", new Integer(ChartTypeInfo.BUILTINTYPES[10][1]));
        chartTypes.put("2DOpen_High_Low_CloseStock", new Integer(ChartTypeInfo.BUILTINTYPES[10][2]));
        comboTypes.put("2DBarSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[0][0]));
        comboTypes.put("2DBarStack", new Integer(ChartTypeInfo.BUILTINTYPES[0][1]));
        comboTypes.put("2DBarPercent", new Integer(ChartTypeInfo.BUILTINTYPES[0][2]));
        comboTypes.put("3DBarSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[0][3]));
        comboTypes.put("3DBarStack", new Integer(ChartTypeInfo.BUILTINTYPES[0][4]));
        comboTypes.put("3DBarPercent", new Integer(ChartTypeInfo.BUILTINTYPES[0][5]));
        comboTypes.put("3DBarArray", new Integer(ChartTypeInfo.BUILTINTYPES[0][6]));
        comboTypes.put("2DBenchSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[1][0]));
        comboTypes.put("2DBenchStack", new Integer(ChartTypeInfo.BUILTINTYPES[1][1]));
        comboTypes.put("2DBenchPercent", new Integer(ChartTypeInfo.BUILTINTYPES[1][2]));
        comboTypes.put("3DBenchSideBySide", new Integer(ChartTypeInfo.BUILTINTYPES[1][3]));
        comboTypes.put("3DBenchStack", new Integer(ChartTypeInfo.BUILTINTYPES[1][4]));
        comboTypes.put("3DBenchPercent", new Integer(ChartTypeInfo.BUILTINTYPES[1][5]));
        comboTypes.put("3DBenchArray", new Integer(ChartTypeInfo.BUILTINTYPES[1][6]));
        comboTypes.put("2DLineArray", new Integer(ChartTypeInfo.BUILTINTYPES[2][0]));
        comboTypes.put("2DLineStack", new Integer(ChartTypeInfo.BUILTINTYPES[2][1]));
        comboTypes.put("2DLinePercent", new Integer(ChartTypeInfo.BUILTINTYPES[2][2]));
        comboTypes.put("3DLineArray", new Integer(ChartTypeInfo.BUILTINTYPES[2][3]));
        comboTypes.put("2DAreaArray", new Integer(ChartTypeInfo.BUILTINTYPES[3][0]));
        comboTypes.put("2DAreaStack", new Integer(ChartTypeInfo.BUILTINTYPES[3][1]));
        comboTypes.put("2DAreaPercent", new Integer(ChartTypeInfo.BUILTINTYPES[3][2]));
        comboTypes.put("3DAreaArray", new Integer(ChartTypeInfo.BUILTINTYPES[3][3]));
        comboTypes.put("3DAreaStack", new Integer(ChartTypeInfo.BUILTINTYPES[3][4]));
        comboTypes.put("3DAreaPercent", new Integer(ChartTypeInfo.BUILTINTYPES[3][5]));
        CHART_FILTER_EDITOR = new HashMap(134);
        CHART_FILTER_EDITOR.put("padding-bottom", new Integer(0));
        CHART_FILTER_EDITOR.put("Bottom", new Integer(1));
        CHART_FILTER_EDITOR.put("AutoLayout", new Integer(2));
        CHART_FILTER_EDITOR.put("LineJoint", new Integer(3));
        CHART_FILTER_EDITOR.put("StartOffset(2nd Data Set)", new Integer(4));
        CHART_FILTER_EDITOR.put("Value", new Integer(5));
        CHART_FILTER_EDITOR.put("GradientStartColor", new Integer(6));
        CHART_FILTER_EDITOR.put("Type", new Integer(7));
        CHART_FILTER_EDITOR.put("HintFormat", new Integer(8));
        CHART_FILTER_EDITOR.put("margin-left", new Integer(9));
        CHART_FILTER_EDITOR.put("XHyperLink", new Integer(10));
        CHART_FILTER_EDITOR.put("float", new Integer(11));
        CHART_FILTER_EDITOR.put("StartOffset(1st Data Set)", new Integer(12));
        CHART_FILTER_EDITOR.put("display", new Integer(13));
        CHART_FILTER_EDITOR.put("ChildStyle", new Integer(14));
        CHART_FILTER_EDITOR.put("Section", new Integer(15));
        CHART_FILTER_EDITOR.put("BackgroundColor", new Integer(16));
        CHART_FILTER_EDITOR.put("RightLine", new Integer(17));
        CHART_FILTER_EDITOR.put("ZHyperLink", new Integer(18));
        CHART_FILTER_EDITOR.put("TOCAnchor", new Integer(19));
        CHART_FILTER_EDITOR.put("SameLevel", new Integer(20));
        CHART_FILTER_EDITOR.put("BottomLine", new Integer(21));
        CHART_FILTER_EDITOR.put("Shadow", new Integer(22));
        CHART_FILTER_EDITOR.put("ShadowColor", new Integer(23));
        CHART_FILTER_EDITOR.put("class", new Integer(24));
        CHART_FILTER_EDITOR.put("HyperLink", new Integer(25));
        CHART_FILTER_EDITOR.put("WebStyleGroup", new Integer(26));
        CHART_FILTER_EDITOR.put("border-top-color", new Integer(27));
        CHART_FILTER_EDITOR.put("DisplayName", new Integer(28));
        CHART_FILTER_EDITOR.put("GradientStartY", new Integer(29));
        CHART_FILTER_EDITOR.put("GradientStartX", new Integer(30));
        CHART_FILTER_EDITOR.put("SuppressedIfNoRecords", new Integer(31));
        CHART_FILTER_EDITOR.put("Horizontal", new Integer(32));
        CHART_FILTER_EDITOR.put("ColumnIndex", new Integer(33));
        CHART_FILTER_EDITOR.put("ExternalCSSClassValue", new Integer(34));
        CHART_FILTER_EDITOR.put("Invisible", new Integer(35));
        CHART_FILTER_EDITOR.put("ExportToDHTML", new Integer(36));
        CHART_FILTER_EDITOR.put("margin-top", new Integer(37));
        CHART_FILTER_EDITOR.put("Right", new Integer(38));
        CHART_FILTER_EDITOR.put("AntiAliasing", new Integer(39));
        CHART_FILTER_EDITOR.put("VariabledDash", new Integer(40));
        CHART_FILTER_EDITOR.put("border-right-color", new Integer(41));
        CHART_FILTER_EDITOR.put("z-order", new Integer(42));
        CHART_FILTER_EDITOR.put("ReverseRows", new Integer(43));
        CHART_FILTER_EDITOR.put("LeftLine", new Integer(44));
        CHART_FILTER_EDITOR.put("PrimaryType", new Integer(45));
        CHART_FILTER_EDITOR.put("UDOResultName", new Integer(46));
        CHART_FILTER_EDITOR.put("ExportToCSV", new Integer(47));
        CHART_FILTER_EDITOR.put("FillPattern", new Integer(48));
        CHART_FILTER_EDITOR.put("UDOName", new Integer(49));
        CHART_FILTER_EDITOR.put("RowIndex", new Integer(50));
        CHART_FILTER_EDITOR.put("dataInherit", new Integer(51));
        CHART_FILTER_EDITOR.put("padding-right", new Integer(52));
        CHART_FILTER_EDITOR.put("StyleName", new Integer(53));
        CHART_FILTER_EDITOR.put("PenColor", new Integer(54));
        CHART_FILTER_EDITOR.put("Image", new Integer(55));
        CHART_FILTER_EDITOR.put("ReverseColumns", new Integer(56));
        CHART_FILTER_EDITOR.put("SecondType", new Integer(57));
        CHART_FILTER_EDITOR.put("ImageWidth", new Integer(58));
        CHART_FILTER_EDITOR.put("RowNumber", new Integer(59));
        CHART_FILTER_EDITOR.put("border-left-color", new Integer(60));
        CHART_FILTER_EDITOR.put("GradientEndY", new Integer(61));
        CHART_FILTER_EDITOR.put("BorderWidth", new Integer(62));
        CHART_FILTER_EDITOR.put("GradientEndX", new Integer(63));
        CHART_FILTER_EDITOR.put("Category", new Integer(64));
        CHART_FILTER_EDITOR.put("Background", new Integer(65));
        CHART_FILTER_EDITOR.put("id", new Integer(66));
        CHART_FILTER_EDITOR.put("BorderStyle", new Integer(67));
        CHART_FILTER_EDITOR.put("ExportToXLS", new Integer(68));
        CHART_FILTER_EDITOR.put("border-bottom-color", new Integer(69));
        CHART_FILTER_EDITOR.put("padding-left", new Integer(70));
        CHART_FILTER_EDITOR.put("TextureBackColor", new Integer(71));
        CHART_FILTER_EDITOR.put("BackgroundTransparency", new Integer(72));
        CHART_FILTER_EDITOR.put("DataSource", new Integer(73));
        CHART_FILTER_EDITOR.put("position", new Integer(74));
        CHART_FILTER_EDITOR.put("dataSet", new Integer(75));
        CHART_FILTER_EDITOR.put("TextureForeColor", new Integer(76));
        CHART_FILTER_EDITOR.put("Suppressed", new Integer(77));
        CHART_FILTER_EDITOR.put("Alignment", new Integer(78));
        CHART_FILTER_EDITOR.put("SecondaryDataFilter", new Integer(79));
        CHART_FILTER_EDITOR.put("SizeOfPart1", new Integer(80));
        CHART_FILTER_EDITOR.put("PrimaryDataFilter", new Integer(81));
        CHART_FILTER_EDITOR.put("padding-top", new Integer(82));
        CHART_FILTER_EDITOR.put("GradientStyle", new Integer(83));
        CHART_FILTER_EDITOR.put("GroupValueFormat", new Integer(84));
        CHART_FILTER_EDITOR.put("Name_", new Integer(85));
        CHART_FILTER_EDITOR.put("margin-bottom", new Integer(86));
        CHART_FILTER_EDITOR.put("CategoryFilter", new Integer(87));
        CHART_FILTER_EDITOR.put("ImageHeight", new Integer(88));
        CHART_FILTER_EDITOR.put("InnerGroupPatternList", new Integer(89));
        CHART_FILTER_EDITOR.put("Left", new Integer(90));
        CHART_FILTER_EDITOR.put("PatternList", new Integer(91));
        CHART_FILTER_EDITOR.put("border-top-width", new Integer(92));
        CHART_FILTER_EDITOR.put("AnchorDispValue", new Integer(93));
        CHART_FILTER_EDITOR.put("margin-right", new Integer(94));
        CHART_FILTER_EDITOR.put("ImageY", new Integer(95));
        CHART_FILTER_EDITOR.put("ColumnNumber", new Integer(96));
        CHART_FILTER_EDITOR.put("ImageX", new Integer(97));
        CHART_FILTER_EDITOR.put("RecordLocation", new Integer(98));
        CHART_FILTER_EDITOR.put("OuterGroupPatternList", new Integer(99));
        CHART_FILTER_EDITOR.put("UDORenderName", new Integer(100));
        CHART_FILTER_EDITOR.put("Y", new Integer(101));
        CHART_FILTER_EDITOR.put("X", new Integer(102));
        CHART_FILTER_EDITOR.put("RunTimeInstName", new Integer(103));
        CHART_FILTER_EDITOR.put("border-right-width", new Integer(104));
        CHART_FILTER_EDITOR.put("TextureStyle", new Integer(105));
        CHART_FILTER_EDITOR.put("BorderTransparency", new Integer(106));
        CHART_FILTER_EDITOR.put("WebStyleName", new Integer(107));
        CHART_FILTER_EDITOR.put("Height", new Integer(108));
        CHART_FILTER_EDITOR.put("Outline", new Integer(109));
        CHART_FILTER_EDITOR.put("SortZ", new Integer(110));
        CHART_FILTER_EDITOR.put("clear", new Integer(111));
        CHART_FILTER_EDITOR.put("SortX", new Integer(112));
        CHART_FILTER_EDITOR.put("border-left-width", new Integer(113));
        CHART_FILTER_EDITOR.put("Series", new Integer(114));
        CHART_FILTER_EDITOR.put("EndOffset(2nd Data Set)", new Integer(115));
        CHART_FILTER_EDITOR.put("RTFID", new Integer(116));
        CHART_FILTER_EDITOR.put("PenStyle", new Integer(117));
        CHART_FILTER_EDITOR.put("Top", new Integer(118));
        CHART_FILTER_EDITOR.put("refMode", new Integer(119));
        CHART_FILTER_EDITOR.put("Width", new Integer(120));
        CHART_FILTER_EDITOR.put("ObjectIndex", new Integer(121));
        CHART_FILTER_EDITOR.put("border-bottom-width", new Integer(122));
        CHART_FILTER_EDITOR.put("ImageLayout", new Integer(123));
        CHART_FILTER_EDITOR.put("IsCombo", new Integer(124));
        CHART_FILTER_EDITOR.put("EndOffset(1st Data Set)", new Integer(125));
        CHART_FILTER_EDITOR.put("BorderColor", new Integer(126));
        CHART_FILTER_EDITOR.put("TopLine", new Integer(127));
        CHART_FILTER_EDITOR.put("PenThickness", new Integer(128));
        CHART_FILTER_EDITOR.put("EndCaps", new Integer(129));
        CHART_FILTER_EDITOR.put("Style", new Integer(130));
        CHART_FILTER_EDITOR.put("GradientEndColor", new Integer(131));
        CHART_FILTER_EDITOR.put("SeriesFilter", new Integer(132));
        CHART_FILTER_EDITOR.put("CatGroup", new Integer(133));
        CHART_FILTER_EDITOR.put("Lang", new Integer(134));
        CHART_FILTER_EDITOR.put("ExternalStyle", new Integer(135));
        CHART_FILTER_EDITOR.put("ExternalID", new Integer(136));
        CHART_FILTER_EDITOR_NO_DATE = new HashVector(7);
        String string = null;
        Vector<String> vector = null;
        string = "DataSource";
        vector = new Vector<String>(23);
        vector.add("IsCombo");
        vector.add("PrimaryType");
        vector.add("SecondType");
        vector.add("Category");
        vector.add("Series");
        vector.add("Value");
        vector.add("StartOffset(1st Data Set)");
        vector.add("EndOffset(1st Data Set)");
        vector.add("StartOffset(2nd Data Set)");
        vector.add("EndOffset(2nd Data Set)");
        vector.add("ReverseRows");
        vector.add("ReverseColumns");
        vector.add("PatternList");
        vector.add("PrimaryDataFilter");
        vector.add("SecondaryDataFilter");
        vector.add("CategoryFilter");
        vector.add("SeriesFilter");
        vector.add("SizeOfPart1");
        vector.add("SortX");
        vector.add("SortZ");
        vector.add("HyperLink");
        vector.add("XHyperLink");
        vector.add("ZHyperLink");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "Geometry";
        vector = new Vector(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "CSS";
        vector = new Vector(3);
        vector.add("Style");
        vector.add("class");
        vector.add("ExternalCSSClassValue");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "Others";
        vector = new Vector(7);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("SuppressedIfNoRecords");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "Excel";
        vector = new Vector(4);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        vector.add("ColumnNumber");
        vector.add("RowNumber");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "Border";
        vector = new Vector(6);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("BorderColor");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
        string = "Platform";
        vector = new Vector(35);
        vector.add("BorderStyle");
        vector.add("PenStyle");
        vector.add("PenColor");
        vector.add("PenThickness");
        vector.add("EndCaps");
        vector.add("LineJoint");
        vector.add("Outline");
        vector.add("VariabledDash");
        vector.add("BorderTransparency");
        vector.add("FillPattern");
        vector.add("BackgroundTransparency");
        vector.add("Top");
        vector.add("Left");
        vector.add("Right");
        vector.add("Bottom");
        vector.add("BackgroundColor");
        vector.add("TextureStyle");
        vector.add("TextureForeColor");
        vector.add("TextureBackColor");
        vector.add("GradientStyle");
        vector.add("GradientStartColor");
        vector.add("GradientEndColor");
        vector.add("GradientStartX");
        vector.add("GradientStartY");
        vector.add("GradientEndX");
        vector.add("GradientEndY");
        vector.add("Image");
        vector.add("ImageLayout");
        vector.add("ImageX");
        vector.add("ImageY");
        vector.add("ImageWidth");
        vector.add("ImageHeight");
        vector.add("AntiAliasing");
        vector.add("HintFormat");
        vector.add("GroupValueFormat");
        CHART_FILTER_EDITOR_NO_DATE.put(string, vector);
    }
}

