/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.pub;

import com.jinfonet.util.JRLog;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import jet.acl.ACLException;
import jet.acl.JetAcl;
import jet.acl.PermissionManager;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;
import jet.report.JetRptDataContainer;
import jet.reportset.DataSet;
import jet.reportset.JSecurityEntryException;
import jet.rptengine.JReportEngine;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.infocenter.DataSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.util.ReportTools;
import jet.server.api.SecurityContext;
import jet.universe.JetUUniverse;
import jet.util.StringTools;

public class JColumnSecurityContainer {
    private boolean QOIV = true;
    private boolean addAll = true;
    private ArrayList append;
    private boolean asList = true;
    private boolean clone = false;

    public JColumnSecurityContainer(JetUUniverse jetUUniverse, DataSet dataSet, String string, SecurityData securityData, SecurityContext securityContext, JRptSetEngine jRptSetEngine, String[] stringArray, Vector[] vectorArray) throws JSecurityEntryException, JPermissionLinkException, JPolicyLinkException, NotOwnerException, ACLException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JColumnSecurityContainer()..., userName: " + string + " secData: " + securityData + " secCxt: " + securityContext + " rptSetEngine: " + jRptSetEngine);
        }
        String string2 = dataSet.getName();
        DataSetCenter dataSetCenter = jRptSetEngine.getReportSetCenter().getDataSetCenter(string2);
        if (dataSetCenter == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of JColumnSecurityContainer(), invalid data set name: " + string2);
            }
            return;
        }
        this.QOIV(jetUUniverse, dataSet, string, securityData, securityContext, dataSetCenter.getDbFieldFormulaMappingNames());
        if (!this.asList) {
            this.QOIV = false;
            this.addAll = false;
            this.append = null;
        } else if (this.asList && !this.denyAllColumns() && !this.clone) {
            this.addAll(dataSet.getName(), jRptSetEngine, stringArray, vectorArray);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JColumnSecurityContainer(), this: " + this);
        }
    }

    private void QOIV(JetUUniverse jetUUniverse, DataSet dataSet, String string, SecurityData securityData, SecurityContext securityContext, String[] stringArray) throws JSecurityEntryException, JPermissionLinkException, JPolicyLinkException, NotOwnerException, ACLException {
        JetAcl jetAcl = dataSet.getAcl();
        PermissionManager permissionManager = null;
        if (jetAcl != null && jetAcl.isValidCLS()) {
            if (!(StringTools.nullOrAllSpaces(string) || securityContext != null && StringTools.nullOrAllSpaces(securityContext.getUserName()))) {
                if (securityContext == null) {
                    if (!StringTools.nullOrAllSpaces(string) && !jetAcl.isAdminUser(string)) {
                        permissionManager = new PermissionManager(jetAcl, string);
                    }
                } else if (!jetAcl.isAdmin(securityContext)) {
                    permissionManager = new PermissionManager(jetAcl, securityContext);
                }
            }
        } else {
            this.asList = false;
        }
        if (permissionManager != null) {
            this.addAll = permissionManager.isDenyAllColumns();
            Vector vector = new Vector();
            if (!permissionManager.isAllowAllColumns() && !this.addAll) {
                Vector<String> vector2 = new Vector<String>();
                vector2.addAll(Arrays.asList(stringArray));
                vector = permissionManager.getDeniedColumns(vector2);
            }
            this.clone = permissionManager.isAllowAllColumns();
            this.QOIV = (!vector.isEmpty() || this.addAll) && !this.clone;
        }
    }

    private void addAll(String string, JRptSetEngine jRptSetEngine, String[] stringArray, Vector[] vectorArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                String string3 = (String)vectorArray[n].elementAt(n2);
                ReportViewCenter reportViewCenter = jRptSetEngine.getReportSetCenter().getReportViewCenter(string2, string3);
                String[] stringArray2 = reportViewCenter.getAllDataContainerNames();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    JetRptDataContainer jetRptDataContainer = (JetRptDataContainer)reportViewCenter.getReportView().nameToObject(stringArray2[n3]);
                    DataSet dataSet = ReportTools.getDataSet(jetRptDataContainer);
                    if (dataSet != null && string.equalsIgnoreCase(dataSet.getName())) {
                        this.append(reportViewCenter.getReportViewEngine(), jetRptDataContainer);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void append(JReportEngine jReportEngine, JetRptDataContainer jetRptDataContainer) {
        if (jReportEngine.getDoCLS(jetRptDataContainer)) {
            Vector vector = jReportEngine.getDeniedFlds(jetRptDataContainer);
            if (this.append == null) {
                this.append = new ArrayList(vector);
            } else {
                Vector vector2 = (Vector)vector.clone();
                vector2.removeAll(this.append);
                this.append.addAll(vector2);
            }
            this.QOIV = true;
        }
    }

    public boolean doCLS() {
        return this.QOIV;
    }

    public boolean denyAllColumns() {
        return this.addAll;
    }

    public String[] getDeniedColumns() {
        return this.append == null ? null : this.append.toArray(new String[this.append.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("doCls: ").append(this.QOIV).append(" denyAllColumns: ").append(this.addAll).append("\ndeniedColumns: ").append(this.append);
        return stringBuffer.toString();
    }
}

